/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.EndorsementBillEntryCollection;
import com.kingdee.eas.fm.nt.EndorsementBillEntryInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.BillTransBizType;
import com.kingdee.eas.fm.ntp.BillTransactionLogFactory;
import com.kingdee.eas.fm.ntp.BillTransactionLogInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NTPHelper {
    public static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    public static final String KEY_IS_ELEC = "IS_ELEC";
    private static Map<String, Object> paramCache;

    public static boolean getParamValue(Context ctx, String key) throws BOSException {
        boolean value = false;
        if (paramCache == null) {
            paramCache = new HashMap<String, Object>();
        }
        if (paramCache.containsKey(key)) {
            value = (Boolean)paramCache.get(key);
        } else {
            String sql = "SELECT FValue FROM T_NT_Param WHERE FKey = '" + key + "'";
            ISQLExecutor exec = null;
            exec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
            IRowSet rs = exec.executeSQL();
            try {
                if (rs.next()) {
                    value = Boolean.valueOf(rs.getString("FValue"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            paramCache.put(key, value);
        }
        return value;
    }

    public static boolean existBEProcessing(EndorsementBillEntryCollection entrys) {
        boolean exist = false;
        for (int i = 0; i < entrys.size(); ++i) {
            EndorsementBillEntryInfo entry = entrys.get(i);
            if (entry.getBankReturnStatus() != null && !entry.getBankReturnStatus().equals((Object)BankReturnStatusEnum.EB_PROCESSING) && !entry.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_PROCESSING) && !entry.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_EXCEPTION)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static boolean existBEProcessing(ReceivableBillCollection entrys) {
        boolean exist = false;
        for (int i = 0; i < entrys.size(); ++i) {
            ReceivableBillInfo receivableBillInfo = entrys.get(i);
            if (receivableBillInfo.getBankReturnStatus() != null && !receivableBillInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.EB_PROCESSING) && !receivableBillInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_PROCESSING) && !receivableBillInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_EXCEPTION)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static boolean isBEAllProcessed(EndorsementBillEntryCollection entrys) {
        boolean isProcessed = true;
        for (int i = 0; i < entrys.size(); ++i) {
            EndorsementBillEntryInfo entry = entrys.get(i);
            if (entry.getBankReturnStatus() != null && (entry.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_SUCCESS) || entry.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_FAIL))) continue;
            isProcessed = false;
            break;
        }
        return isProcessed;
    }

    public static boolean isBEAllProcessed(ReceivableBillCollection entrys) {
        boolean isProcessed = true;
        for (int i = 0; i < entrys.size(); ++i) {
            ReceivableBillInfo receivableBillInfo = entrys.get(i);
            if (receivableBillInfo.getBankReturnStatus() != null && (receivableBillInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_SUCCESS) || receivableBillInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_FAIL))) continue;
            isProcessed = false;
            break;
        }
        return isProcessed;
    }

    public static void showActionResult(Component comp, BatchExecuteResult result) {
        String summaryMsg = result.getSummaryMsg();
        if (result.isError() > 0) {
            String LINE_SEPARATOR = System.getProperty("line.separator");
            List msgList = result.getDetailMsgList();
            StringBuffer errorDetail = new StringBuffer();
            for (int i = 0; i < msgList.size(); ++i) {
                errorDetail.append((String)msgList.get(i)).append(LINE_SEPARATOR);
            }
            MsgBox.showDetailAndOK((Component)comp, (String)summaryMsg, (String)errorDetail.toString(), (int)0);
        } else {
            MsgBox.showInfo((Component)comp, (String)summaryMsg);
        }
    }

    public static void addBillTransLogByColl(Context ctx, ReceivableBillCollection coll, BillTransBizType typeEnum) throws EASBizException, BOSException {
        if (coll.size() > 0) {
            CoreBaseCollection logColl = new CoreBaseCollection();
            BillTransactionLogInfo logInfo = null;
            ReceivableBillInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                logInfo = new BillTransactionLogInfo();
                info = coll.get(i);
                logInfo.setDraftNumber(info.getDraftNumber());
                logInfo.setCompany(info.getHolder());
                logInfo.setBizType(typeEnum);
                logInfo.setHandler(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                logInfo.setHandleDate(new Date());
                logColl.add((CoreBaseInfo)logInfo);
            }
            if (logColl.size() > 0) {
                BillTransactionLogFactory.getLocalInstance((Context)ctx).addnewBatchData(logColl);
            }
        }
    }

    public static void addBillTransLogByInfo(Context ctx, ReceivableBillInfo info, BillTransBizType typeEnum) throws EASBizException, BOSException {
        if (info != null) {
            BillTransactionLogInfo logInfo = new BillTransactionLogInfo();
            logInfo.setDraftNumber(info.getDraftNumber());
            logInfo.setCompany(info.getHolder());
            logInfo.setBizType(typeEnum);
            logInfo.setHandler(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
            logInfo.setHandleDate(new Date());
            BillTransactionLogFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)logInfo);
        }
    }
}

