/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.nt.IPayableBill;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.TypeConversionUtils;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayableBillUpdateDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)PayableBillUpdateDataImport.class.getName());
    private Map infoMap = new HashMap(100);
    private String lastKey;
    private String curKey;
    public static final String NT_RESOURCE = "com.kingdee.eas.fm.nt.NtResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PayableBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null) {
            return;
        }
        PayableBillInfo info = (PayableBillInfo)coreBaseInfo;
        IPayableBill iPayableBill = (IPayableBill)this.getController(ctx);
        try {
            iPayableBill.updateBillByImport(info);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TaskExternalException(info.getNumber() + EASResource.getString((String)NT_RESOURCE, (String)"client_import_updatefalil"));
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CompanyOrgUnitInfo currCompany;
        String number;
        PayableBillInfo head = new PayableBillInfo();
        this.curKey = number = (String)this.getData(hsData, "FNumber");
        if (this.lastKey == null) {
            this.lastKey = this.curKey;
        }
        if (this.verify(hsData, currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany(), ctx)) {
            if (!this.infoMap.containsKey(this.curKey)) {
                head = (PayableBillInfo)this.parseHead(hsData, ctx);
                this.infoMap.put(this.curKey, head);
            } else {
                head = (PayableBillInfo)this.infoMap.get(this.curKey);
            }
        }
        head.setCompany(currCompany);
        return head;
    }

    private boolean verify(Hashtable hsData, CompanyOrgUnitInfo companyInfo, Context ctx) throws TaskExternalException {
        String eDate;
        boolean flag = true;
        String company = companyInfo.getNumber();
        String number = this.getData(hsData, "FNumber") != null ? (String)this.getData(hsData, "FNumber") : null;
        this.checkEmpty(number, EASResource.getString((String)NT_RESOURCE, (String)"client_import_billNumber"));
        String draftNumber = this.getData(hsData, "FDraftNumber") != null ? (String)this.getData(hsData, "FDraftNumber") : null;
        this.checkEmpty(draftNumber, EASResource.getString((String)NT_RESOURCE, (String)"client_import_draftNumber"));
        if (company == null || number == null) {
            flag = false;
        }
        String iDate = this.getData(hsData, "FIssueDate") != null ? (String)this.getData(hsData, "FIssueDate") : null;
        String string = eDate = this.getData(hsData, "FExpiredDate") != null ? (String)this.getData(hsData, "FExpiredDate") : null;
        if (iDate != null && eDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            java.util.Date issueDate = null;
            java.util.Date expireDate = null;
            try {
                issueDate = sdf.parse(iDate);
                expireDate = sdf.parse(eDate);
                if (issueDate.equals(expireDate) || expireDate.before(issueDate)) {
                    throw new TaskExternalException(EASResource.getString((String)NT_RESOURCE, (String)"126_EXPIRE_G_ISSUEDATE", (Object[])new Object[]{number}));
                }
            }
            catch (ParseException e) {
                throw new TaskExternalException(EASResource.getString((String)NT_RESOURCE, (String)"125_DATE_FORMAT_ERR"));
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company));
        evi.setFilter(filter);
        try {
            PayableBillCollection coll = PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(evi);
            if (coll == null || coll.size() == 0) {
                flag = false;
                throw new TaskExternalException(number + EASResource.getString((String)NT_RESOURCE, (String)"client_import_noBill"));
            }
            boolean stateFlag = false;
            for (int i = 0; i < coll.size(); ++i) {
                PayableBillInfo info = coll.get(i);
                PayableBillStateEnum billState = info.getBillState();
                if (billState == null || billState.getValue() != 0) continue;
                stateFlag = true;
            }
            if (!stateFlag) {
                flag = false;
                throw new TaskExternalException(number + EASResource.getString((String)NT_RESOURCE, (String)"client_import_noSubmit"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            flag = false;
        }
        return flag;
    }

    private void checkEmpty(Object obj, String msg) throws TaskExternalException {
        if (obj == null || obj.toString().trim().length() == 0) {
            throw new TaskExternalException(msg + EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"79_ReceivableBillImportVerify"));
        }
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx) throws TaskExternalException {
        PayableBillInfo info = new PayableBillInfo();
        Object data = null;
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0 && !data.toString().equals("")) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FDraftNumber")) != null && data.toString().trim().length() > 0 && !data.toString().equals("")) {
            info.setDraftNumber(data.toString());
        }
        data = this.getData(hsData, "FIssueDate");
        Date beginDate = null;
        if (data != null && data.toString().trim().length() > 0 && !data.toString().equals("")) {
            beginDate = TypeConversionUtils.objToDate((Object)data);
            info.setIssueDate(beginDate);
        }
        data = this.getData(hsData, "FExpiredDate");
        Date endDate = null;
        if (data != null && data.toString().trim().length() > 0 && !data.toString().equals("")) {
            endDate = TypeConversionUtils.objToDate((Object)data);
            info.setExpiredDate(endDate);
        }
        if (beginDate != null && endDate != null) {
            info.setHorizon(FinHorizon.getHorizon((java.util.Date)beginDate, endDate));
        }
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }
}

