/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.nt.RecChequeCollection;
import com.kingdee.eas.fm.nt.RecChequeInfo;
import com.kingdee.eas.fm.nt.RecChequeStatueEnum;
import com.kingdee.eas.fm.nt.client.util.MyVOComparator;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;

public class RecChequeHelper {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";

    private static String getNTAutoResource(String sourceName) {
        return EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)sourceName);
    }

    public static boolean isCanReceipt(RecChequeInfo info) {
        return RecChequeStatueEnum.NEW.equals((Object)info.getState());
    }

    public static boolean isCanCancelReceipt(RecChequeInfo info) {
        if (RecChequeStatueEnum.RECEIPT == info.getState()) {
            return !RecChequeHelper.isAlreadyGenBill(info);
        }
        return false;
    }

    public static boolean isCanReceipt(RecChequeCollection coll) throws EASBizException {
        if (coll == null || coll.size() <= 0) {
            return false;
        }
        if (coll.size() > 1) {
            String[] fields = new String[]{"ntType", "currency"};
            MyVOComparator comparator = new MyVOComparator(fields);
            RecChequeInfo info = coll.get(0);
            for (int i = 1; i < coll.size(); ++i) {
                if (!RecChequeHelper.isCanReceipt(info)) {
                    MsgBox.showInfo((String)RecChequeHelper.getNTAutoResource("404_RecChequeHelper"));
                    return false;
                }
                if (comparator.compareVO((IObjectValue)info, (IObjectValue)coll.get(i)).isEqual()) continue;
                MsgBox.showInfo((String)RecChequeHelper.getNTAutoResource("405_RecChequeHelper"));
                return false;
            }
        } else if (!RecChequeHelper.isCanReceipt(coll.get(0))) {
            MsgBox.showInfo((String)RecChequeHelper.getNTAutoResource("404_RecChequeHelper"));
            return false;
        }
        return true;
    }

    public static boolean isCanEndorse(RecChequeInfo info) {
        boolean flag = false;
        if (RecChequeStatueEnum.NEW.equals((Object)info.getState()) && !info.getNtType().isIsCash() && !info.isIsQuota()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCanEndorse(RecChequeCollection coll) throws EASBizException {
        if (coll == null || coll.size() <= 0) {
            return false;
        }
        if (coll.size() > 1) {
            String[] fields = new String[]{"ntType", "currency"};
            MyVOComparator comparator = new MyVOComparator(fields);
            RecChequeInfo info = coll.get(0);
            for (int i = 1; i < coll.size(); ++i) {
                if (!RecChequeHelper.isCanEndorse(info)) {
                    MsgBox.showInfo((String)RecChequeHelper.getNTAutoResource("406_RecChequeHelper"));
                    return false;
                }
                if (comparator.compareVO((IObjectValue)info, (IObjectValue)coll.get(i)).isEqual()) continue;
                MsgBox.showInfo((String)RecChequeHelper.getNTAutoResource("407_RecChequeHelper"));
                return false;
            }
        } else if (!RecChequeHelper.isCanEndorse(coll.get(0))) {
            MsgBox.showInfo((String)RecChequeHelper.getNTAutoResource("406_RecChequeHelper"));
            return false;
        }
        return true;
    }

    public static boolean isCanCancelEndorse(RecChequeInfo info) {
        if (RecChequeStatueEnum.ENDORSE.equals((Object)info.getState())) {
            return !RecChequeHelper.isAlreadyGenBill(info);
        }
        return false;
    }

    public static boolean isCanAbandon(RecChequeInfo info) {
        if (!RecChequeStatueEnum.ABANDON.equals((Object)info.getState())) {
            return !RecChequeHelper.isAlreadyGenBill(info);
        }
        return false;
    }

    public static boolean isCanCancelAbandon(RecChequeInfo info) {
        return RecChequeStatueEnum.ABANDON.equals((Object)info.getState());
    }

    public static boolean isCanRecord(RecChequeInfo info) {
        return RecChequeStatueEnum.RECEIPT.equals((Object)info.getState()) && info.getJouranl() == null;
    }

    public static boolean isCanCancelRecord(RecChequeInfo info) {
        return info.getJouranl() != null;
    }

    public static boolean isCanVoucher(RecChequeInfo info) {
        return !info.isFivouchered() && (info.getState().equals((Object)RecChequeStatueEnum.RECEIPT) || info.getState().equals((Object)RecChequeStatueEnum.ENDORSE));
    }

    public static boolean isCanCancelVoucher(RecChequeInfo info) {
        return info.isFivouchered();
    }

    public static boolean isCanRemove(RecChequeInfo info) {
        if (RecChequeStatueEnum.NEW.equals((Object)info.getState())) {
            return !RecChequeHelper.isAlreadyGenBill(info);
        }
        return false;
    }

    public static boolean isAlreadyGenBill(RecChequeInfo info) {
        return info.isFivouchered() || info.getJouranl() != null;
    }

    public static boolean isOwnCompany(RecChequeInfo info, CompanyOrgUnitInfo company) {
        if (info == null || company == null || info.getCompany() == null) {
            return false;
        }
        return company.getId().equals((Object)info.getCompany().getId());
    }

    public static boolean isClearinghourseCompany(CompanyOrgUnitInfo company) {
        try {
            return BankFactory.getRemoteInstance().isClearinghouseCompany(company.getId().toString());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    public static boolean isCanTDPrint(RecChequeInfo info) {
        return RecChequeStatueEnum.RECEIPT.equals((Object)info.getState());
    }
}

