/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import java.util.Date;
import java.util.Set;

public class TeleOrderBookBuilder
implements IBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection coll = new JournalCollection();
        ChequeInfo bill = ChequeFactory.getLocalInstance(ctx).getChequeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billId)), this.getSelector());
        JournalInfo info = new JournalInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCompany(bill.getApplyRec().getApplyCompany());
        info.setSource(JournalSourceEnum.BYBILL);
        info.setBillId(bill.getId().toString());
        info.setBizDate(DateUtil.getDayBegin((Date)bill.getIssueDate()));
        info.setCreateDate(DateUtil.getDayBegin((Date)bill.getIssueDate()));
        info.setBillType(BillTypeEnum.TeleOrder);
        info.setBillNumber(bill.getNumber());
        info.setTicketNumber(bill.getNumber());
        info.setSettlementNumber(bill.getNumber());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)bill.getNtType().getId().toString()));
        view.setFilter(filter);
        SettlementTypeCollection setColl = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = bill.getSettleType();
        if (setColl != null && setColl.size() == 1) {
            type = setColl.get(0);
        }
        info.setSettlementType(type);
        info.setCurrency(bill.getCurrency());
        info.setDescription(bill.getUsage());
        if (bill.getOppAccount() != null) {
            info.setOppAccountView(bill.getOppAccount());
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setCashier(userInfo);
        info.setVerifyStatus(VerifyScopeEnum.NOVA);
        info.setAccountBank(bill.getBankAcct());
        info.setAccountView(bill.getBankAcct().getAccount());
        info.setCreditAmount(bill.getAmount());
        info.setType(JournalTypeEnum.BANK);
        coll.add(info);
        return coll;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("company.*");
        selectors.add("applyRec.applyCompany.*");
        selectors.add("applyRec.*");
        selectors.add("oppAccount.*");
        selectors.add("bankAcct.*");
        selectors.add("turnInAcctBank.*");
        selectors.add("oppAccount.*");
        selectors.add("ntType.*");
        selectors.add("oppAccount.*");
        return selectors;
    }

    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        return null;
    }
}

