/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.BankPayUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.nt.BankDraftReqCollection;
import com.kingdee.eas.fm.nt.BankDraftReqFactory;
import com.kingdee.eas.fm.nt.BankDraftReqInfo;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.ReqBillStateEnum;
import com.kingdee.eas.fm.nt.app.AbstractBankDraftReqControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class BankDraftReqControllerBean
extends AbstractBankDraftReqControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.BankDraftReqControllerBean");

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankDraftReqInfo info = null;
        try {
            info = this.getBankDraftReqInfo(ctx, pk);
            if (info.getBillState() == ReqBillStateEnum.SAVE || info.getBillState() == ReqBillStateEnum.SUBMIT) {
                String errorDetail = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"7_BankDraftReqControllerBean", (Locale)ctx.getLocale());
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{errorDetail});
            }
            ReqBillStateEnum billState = info.getBillState();
            if (billState != ReqBillStateEnum.AUDIT || info.isIsDraw() || info.getBankState() != BankPayingBillStateEnum.OP && info.getBankState() != BankPayingBillStateEnum.OF) {
                String errorDetail = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"8_BankDraftReqControllerBean", (Locale)ctx.getLocale());
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{errorDetail});
            }
            info.setBillState(ReqBillStateEnum.SAVE);
            info.setBankState(BankPayingBillStateEnum.OP);
            info.setAuditor(null);
            BankDraftReqFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            logger.info((Object)e.getMessage());
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankDraftReqInfo info = null;
        info = this.getBankDraftReqInfo(ctx, pk);
        if (null == info) {
            String errorDetail = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"10_BankDraftReqControllerBean", (Locale)ctx.getLocale());
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{errorDetail});
        }
        if (info.getBillState() == ReqBillStateEnum.SAVE || info.getBillState() == ReqBillStateEnum.AUDIT) {
            String errorDetail = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"9_BankDraftReqControllerBean", (Locale)ctx.getLocale());
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{errorDetail});
        }
        info.setBillState(ReqBillStateEnum.AUDIT);
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        BankDraftReqFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((BankDraftReqInfo)model));
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        IObjectPK pk = super._submit(ctx, model);
        NTHelper.OnWaybgCtrl(ctx, pk.toString());
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((BankDraftReqInfo)model));
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (int i = 0; i < arrayPK.length; ++i) {
            FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)arrayPK[i]);
        }
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK[])arrayPK);
        super._delete(ctx, arrayPK);
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _submitBank(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankDraftReqCollection coll = new BankDraftReqCollection();
        BankDraftReqInfo info = null;
        BankDraftReqInfo bdrInfo = null;
        SelectorItemCollection sele = this.getSelectorForBe();
        try {
            bdrInfo = this.getBankDraftReqInfo(ctx, pk, sele);
            if (bdrInfo.getBillState() != ReqBillStateEnum.AUDIT || bdrInfo.getBankState() != BankPayingBillStateEnum.OP && bdrInfo.getBankState() != BankPayingBillStateEnum.OF) {
                String errorDetail = bdrInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"11_BankDraftReqControllerBean", (Locale)ctx.getLocale());
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{errorDetail});
            }
            if (bdrInfo.getPayAccountBank().isIsOnlyRead()) {
                String errorDetail = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"12_BankDraftReqControllerBean", (Locale)ctx.getLocale()) + bdrInfo.getPayAccountBank().getBankAccountNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"13_BankDraftReqControllerBean", (Locale)ctx.getLocale());
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{errorDetail});
            }
            coll.add(bdrInfo);
            logger.debug((Object)"begin to submit bankDraftReq");
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                try {
                    info = (BankDraftReqInfo)coll.getObject(i);
                    BankPayUtil bankPayUtil = new BankPayUtil();
                    PayBody body = beServiceHelper.parseBankDraftReqBody((Context)ctx, (BankDraftReqInfo)info);
                    BankBizInfo bizInfo = new BankBizInfo();
                    bizInfo.setBankAcct(info.getPayAccountBank().getBankAccountNumber());
                    bizInfo.setBillType(BillTypeEnum.PAYMENT_BILL);
                    bizInfo.setCurrency(FmBeHelper.getCurrencyISO((Context)ctx, (CurrencyInfo)info.getCurrency()));
                    PaymentDetail[] detail = bankPayUtil.pay(ctx, bizInfo, body);
                    BankPayingBillStateEnum state = beServiceHelper.transferState((String)detail[0].getEbStatus());
                    this.reverseBillState(ctx, state, info.getId().toString());
                    continue;
                }
                catch (ServiceException e) {
                    logger.error((Object)"summit to ebGateWay failure! exception message is:", (Throwable)e);
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"14_BankDraftReqControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"16_BankDraftReqControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
    }

    private void reverseBillState(Context ctx, BankPayingBillStateEnum state, String id) throws BOSException, EASBizException {
        String sql = "Update T_NT_BankDraftReq set FBankState =? where Fid=?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, state.getValue());
            pstmt.setString(2, id);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"is error", (Throwable)e);
                throw new BEException(BEException.WRITESTATEFAILURE, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private SelectorItemCollection getSelectorForBe() {
        SelectorItemCollection sele = new SelectorItemCollection();
        sele.add("*");
        sele.add("ntType.*");
        sele.add("client.*");
        sele.add("payAccountBank.*");
        sele.add("payerBank.*");
        sele.add("currency.*");
        return sele;
    }

    @Override
    protected void _returnBudget(Context ctx, String number) throws BOSException, EASBizException {
        BankDraftReqInfo bankDraftReq = BankDraftReqFactory.getLocalInstance(ctx).getBankDraftReqInfo("select * where number = '" + number + "'");
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(bankDraftReq.getId()));
    }

    @Override
    protected boolean _editState(Context ctx, String id, BankPayingBillStateEnum state) throws BOSException, EASBizException {
        if (id == null || state == null) {
            return false;
        }
        BankDraftReqInfo info = BankDraftReqFactory.getLocalInstance(ctx).getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getBankState() != BankPayingBillStateEnum.NC) {
            throw new NTException(NTException.EDITSTATEERROR1);
        }
        this.reverseBillState(ctx, state, id);
        return true;
    }
}

