/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.NotePayableDetail;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.CirStatusEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NoteStatusEnum;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.ntp.DraftSignInFactory;
import com.kingdee.eas.fm.ntp.DraftSignInInfo;
import com.kingdee.eas.fm.ntp.ElecDraftInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillServerUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.BillServerUtil");
    public static final String RECEIVABLE = "receivable";
    public static final String ENDORSE = "endorse";
    public static final String ENDORSE_CANCLE = "endorse_Cancle";
    public static final String DISCOUNT = "discount";
    public static final String DISCOUNT_CANCLE = "discount_Cancle";
    public static final String PLEDGE = "pledge";
    public static final String PLEDGE_CANCLE = "pledge_Cancle";
    public static final String DISPLEDGE = "disPledge";
    public static final String DISPLEDGE_CANCLE = "disPledge_Cancle";
    public static final String COLLECTREGISTER = "collectRegister";
    public static final String COLLECTREGISTER_CANCLE = "collectRegister_Cancle";

    public static void setKeepFlag(NoteReceivableDetail detail, ReceivableBillInfo info) {
        int source = 1;
        if (info.getSource().equals((Object)BillSourceEnum.BYNEW)) {
            source = 0;
        }
        int isSplit = 0;
        String startNo = "0";
        String endNo = "0";
        BigDecimal origAmount = BigDecimal.ZERO;
        if (info.isIsSplit()) {
            isSplit = 1;
            startNo = info.getOrigStartNo().toString();
            endNo = info.getOrigEndNo().toString();
            origAmount = info.getOrigEndNo().subtract(info.getOrigStartNo()).add(BigDecimal.ONE).divide(new BigDecimal(100));
        }
        String keepflag = "origStartNo=" + startNo + ";origEndNo=" + endNo + ";grdBag=" + isSplit + ";IsNewECDS=" + source + ";origAmount=" + origAmount.setScale(2).toString();
        logger.error((Object)("\u65b0\u7968\u636e\u7cfb\u7edf\u540c\u6b65\u72b6\u6001keepflag: " + keepflag));
        detail.setKeepFlag(keepflag);
    }

    public static ElecBillStatusEnum setElecBillStatus(String operation, ReceivableBillInfo info, NoteReceivableDetail detail) {
        ElecBillStatusEnum elecBillStatusEnum = null;
        if (EmptyUtil.isEmpty((String)detail.getNoteStatus()) || EmptyUtil.isEmpty((String)detail.getKeepFlag())) {
            return elecBillStatusEnum;
        }
        info.setNoteStatus(NoteStatusEnum.getEnum(detail.getNoteStatus()));
        if (EmptyUtil.isEmpty((Object)((Object)NoteStatusEnum.getEnum(detail.getNoteStatus())))) {
            return elecBillStatusEnum;
        }
        String[] strArr = detail.getKeepFlag().split(";");
        boolean hasCirStatus = false;
        for (int i = 0; i < strArr.length; ++i) {
            String returnValue = strArr[i].trim();
            if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("cirStatus=".toUpperCase(Locale.ENGLISH))) continue;
            info.setCirStatus(CirStatusEnum.getEnum(returnValue.substring("cirStatus=".length())));
            hasCirStatus = true;
            break;
        }
        if (!hasCirStatus) {
            return elecBillStatusEnum;
        }
        int isNoUsed = 1;
        if (!info.isIsNoUsed()) {
            isNoUsed = 0;
        }
        int bankReturnStatus = 0;
        BankReturnStatusEnum ebStatus = DraftBEUtil.transferState(detail.getEbStatus());
        if (ebStatus.equals((Object)BankReturnStatusEnum.BANK_SUCCESS) || ebStatus.equals((Object)BankReturnStatusEnum.BANK_FAIL)) {
            bankReturnStatus = ebStatus.getValue();
        }
        String key = operation + info.getNoteStatus().getName() + bankReturnStatus + info.getCirStatus().getName() + isNoUsed;
        logger.error((Object)("\u65b0\u7968\u636e\u7cfb\u7edf\u540c\u6b65\u72b6\u6001key: " + key));
        if (!EmptyUtil.isEmpty((Object)((Object)BillServerUtil.getElecBillStatus(key)))) {
            info.setElecBillStatus(BillServerUtil.getElecBillStatus(key));
            elecBillStatusEnum = BillServerUtil.getElecBillStatus(key);
        }
        return elecBillStatusEnum;
    }

    public static ElecBillStatusEnum getElecBillStatus(String key) {
        HashMap<String, ElecBillStatusEnum> statusMap = new HashMap<String, ElecBillStatusEnum>();
        statusMap.put("endorseCS030TF03021", ElecBillStatusEnum.NT100001);
        statusMap.put("endorseCS030TF03020", ElecBillStatusEnum.NT100001);
        statusMap.put("endorseCS033TF03021", ElecBillStatusEnum.NT100001);
        statusMap.put("endorseCS033TF03020", ElecBillStatusEnum.NT100001);
        statusMap.put("endorseCS034TF03021", ElecBillStatusEnum.NT100001);
        statusMap.put("endorseCS034TF03020", ElecBillStatusEnum.NT100001);
        statusMap.put("endorseCS033TF03011", ElecBillStatusEnum.NT100006);
        statusMap.put("endorseCS033TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("endorseCS034TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("endorseCS034TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("endorse_CancleCS033TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("endorse_CancleCS033TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("endorse_CancleCS034TF03021", ElecBillStatusEnum.NT100001);
        statusMap.put("endorse_CancleCS034TF03020", ElecBillStatusEnum.NT100001);
        statusMap.put("discountCS030TF03021", ElecBillStatusEnum.NT110101);
        statusMap.put("discountCS030TF03020", ElecBillStatusEnum.NT110101);
        statusMap.put("discountCS033TF03021", ElecBillStatusEnum.NT110101);
        statusMap.put("discountCS033TF03020", ElecBillStatusEnum.NT110101);
        statusMap.put("discountCS034TF03021", ElecBillStatusEnum.NT110101);
        statusMap.put("discountCS034TF03020", ElecBillStatusEnum.NT110101);
        statusMap.put("discountCS033TF03011", ElecBillStatusEnum.NT110106);
        statusMap.put("discountCS033TF03010", ElecBillStatusEnum.NT110106);
        statusMap.put("discountCS034TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("discountCS034TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("discount_CancleCS033TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("discount_CancleCS033TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("discount_CancleCS034TF03021", ElecBillStatusEnum.NT110101);
        statusMap.put("discount_CancleCS034TF03020", ElecBillStatusEnum.NT110101);
        statusMap.put("pledgeCS030TF03021", ElecBillStatusEnum.NT180001);
        statusMap.put("pledgeCS030TF03020", ElecBillStatusEnum.NT180001);
        statusMap.put("pledgeCS033TF03021", ElecBillStatusEnum.NT180001);
        statusMap.put("pledgeCS033TF03020", ElecBillStatusEnum.NT180001);
        statusMap.put("pledgeCS034TF03021", ElecBillStatusEnum.NT180001);
        statusMap.put("pledgeCS034TF03020", ElecBillStatusEnum.NT180001);
        statusMap.put("pledgeCS033TF03041", ElecBillStatusEnum.NT180006);
        statusMap.put("pledgeCS033TF03040", ElecBillStatusEnum.NT180006);
        statusMap.put("pledgeCS034TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("pledgeCS034TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("pledge_CancleCS033TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("pledge_CancleCS033TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("pledge_CancleCS034TF03021", ElecBillStatusEnum.NT180001);
        statusMap.put("pledge_CancleCS034TF03020", ElecBillStatusEnum.NT180001);
        statusMap.put("disPledgeCS030TF03021", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS030TF03020", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS033TF03021", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS033TF03020", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS034TF03021", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS034TF03020", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS040TF03021", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS040TF03020", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS043TF03021", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS043TF03020", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS044TF03021", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS044TF03020", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledgeCS033TF03011", ElecBillStatusEnum.NT190006);
        statusMap.put("disPledgeCS033TF03010", ElecBillStatusEnum.NT190006);
        statusMap.put("disPledgeCS043TF04011", ElecBillStatusEnum.NT190006);
        statusMap.put("disPledgeCS043TF04010", ElecBillStatusEnum.NT190006);
        statusMap.put("disPledgeCS034TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("disPledgeCS034TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("disPledge_CancleCS033TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("disPledge_CancleCS033TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("disPledge_CancleCS034TF03020", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledge_CancleCS034TF03021", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledge_CancleCS044TF03021", ElecBillStatusEnum.NT190001);
        statusMap.put("disPledge_CancleCS044TF03020", ElecBillStatusEnum.NT190001);
        statusMap.put("collectRegisterCS030TF03021", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS030TF03020", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS033TF03021", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS033TF03020", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS034TF03021", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS034TF03020", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS040TF03021", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS040TF03020", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS043TF03021", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS043TF03020", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS044TF03021", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS044TF03020", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegisterCS060TF05011", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS060TF05010", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS063TF05011", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS063TF05010", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS064TF05011", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS064TF05010", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS060TF05011", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS060TF05010", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS063TF05011", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS063TF05010", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS064TF05011", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS064TF05010", ElecBillStatusEnum.NT000000);
        statusMap.put("collectRegisterCS034TF03011", ElecBillStatusEnum.NT200412);
        statusMap.put("collectRegisterCS034TF03010", ElecBillStatusEnum.NT200412);
        statusMap.put("collectRegisterCS044TF04011", ElecBillStatusEnum.NT200412);
        statusMap.put("collectRegisterCS044TF04010", ElecBillStatusEnum.NT200412);
        statusMap.put("collectRegister_CancleCS033TF03011", ElecBillStatusEnum.NT030006);
        statusMap.put("collectRegister_CancleCS033TF03010", ElecBillStatusEnum.NT100006);
        statusMap.put("collectRegister_CancleCS034TF03021", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegister_CancleCS034TF03020", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegister_CancleCS044TF03021", ElecBillStatusEnum.NT200001);
        statusMap.put("collectRegister_CancleCS044TF03020", ElecBillStatusEnum.NT200001);
        return (ElecBillStatusEnum)((Object)statusMap.get(key));
    }

    public static ElecBillStatusEnum setPayElecBillStatus(PayableBillInfo info, NotePayableDetail detail) {
        ElecBillStatusEnum elecBillStatusEnum = null;
        Object[] reserveds = detail.getReserveds();
        if (EmptyUtil.isEmpty((String)detail.getNoteStatus()) || EmptyUtil.isEmpty((Object[])reserveds)) {
            return elecBillStatusEnum;
        }
        if (!EmptyUtil.isEmpty((Object[])reserveds)) {
            for (int a = 0; a < reserveds.length; ++a) {
                String returnValue = ((String)reserveds[a]).trim();
                logger.error((Object)("returnValue: " + returnValue));
                if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("cirStatus=".toUpperCase(Locale.ENGLISH))) {
                    info.setCirStatus(CirStatusEnum.getEnum(returnValue.substring("cirStatus=".length())));
                }
                if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("oldStatus=".toUpperCase(Locale.ENGLISH))) continue;
                logger.error((Object)("\u65e7\u7968\u72b6\u6001: " + returnValue.substring("oldStatus=".length())));
                elecBillStatusEnum = ElecBillStatusEnum.getEnum(returnValue.substring("oldStatus=".length()));
            }
        }
        info.setNoteStatus(NoteStatusEnum.getEnum(detail.getNoteStatus()));
        if (EmptyUtil.isEmpty((Object)((Object)info.getNoteStatus())) || EmptyUtil.isEmpty((Object)((Object)info.getCirStatus()))) {
            return elecBillStatusEnum;
        }
        if (!EmptyUtil.isEmpty(elecBillStatusEnum)) {
            info.setElecBillStatus(elecBillStatusEnum);
            return elecBillStatusEnum;
        }
        String key = info.getNoteStatus().getName() + info.getCirStatus().getName();
        logger.error((Object)("\u65b0\u7968\u636e\u7cfb\u7edf\u540c\u6b65\u72b6\u6001key: " + key));
        if (!EmptyUtil.isEmpty((Object)((Object)BillServerUtil.getPayElecBillStatus(key)))) {
            info.setElecBillStatus(BillServerUtil.getPayElecBillStatus(key));
            elecBillStatusEnum = BillServerUtil.getPayElecBillStatus(key);
        }
        return elecBillStatusEnum;
    }

    public static ElecBillStatusEnum getPayElecBillStatus(String key) {
        HashMap<String, ElecBillStatusEnum> statusMap = new HashMap<String, ElecBillStatusEnum>();
        statusMap.put("CS01TF0101", ElecBillStatusEnum.NT010004);
        statusMap.put("CS05TF0501", ElecBillStatusEnum.NT000002);
        statusMap.put("CS01TF0302", ElecBillStatusEnum.NT020001);
        statusMap.put("CS02TF0101", ElecBillStatusEnum.NT020006);
        statusMap.put("CS02TF0302", ElecBillStatusEnum.NT030001);
        statusMap.put("CS03TF0301", ElecBillStatusEnum.NT030006);
        return (ElecBillStatusEnum)((Object)statusMap.get(key));
    }

    public static void setStartAndEndNo(Context ctx, String keepFlag, String bankStatusName, ReceivableBillInfo recInfo) throws BOSException, EASBizException {
        BigDecimal startNo = null;
        BigDecimal endNo = null;
        BigDecimal origStartNo = null;
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance(ctx);
        if (BankReturnStatusEnum.BANK_FAIL.getName().equals(bankStatusName)) {
            if (!EmptyUtil.isEmpty((String)keepFlag) && keepFlag.contains("endNo")) {
                BillServerUtil.getBankReturnNo(recInfo, keepFlag, startNo, endNo);
            } else {
                ReceivableBillInfo upRecInfo = new ReceivableBillInfo();
                if (!EmptyUtil.isEmpty((String)recInfo.getSourceBillId()) && BOSObjectType.create((String)"16CC5356").equals((Object)BOSUuid.read((String)recInfo.getSourceBillId().toString()).getType())) {
                    upRecInfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(recInfo.getSourceBillId()));
                }
                ReceivableBillCollection coll = iReceivableBill.getReceivableBillCollection("where draftPackageNumber = '" + recInfo.getDraftPackageNumber() + "' and company.id = '" + recInfo.getCompany().getId().toString() + "'");
                BigDecimal tagNo = recInfo.getOrigStartNo();
                if (tagNo != null) {
                    for (int i = 0; i < coll.size(); ++i) {
                        ReceivableBillInfo billInfo = coll.get(i);
                        if (upRecInfo == null || upRecInfo.getOrigEndNo() == null || billInfo.getOrigEndNo() == null || billInfo.getOrigEndNo().compareTo(upRecInfo.getOrigEndNo()) >= 0 || tagNo.compareTo(billInfo.getOrigEndNo()) >= 0 || billInfo.getId().toString().equals(recInfo.getId().toString())) continue;
                        tagNo = billInfo.getOrigEndNo();
                    }
                    if (recInfo.getOrigStartNo() != null && tagNo.compareTo(recInfo.getOrigStartNo()) != 0) {
                        tagNo = tagNo.add(Constants.ONE);
                        recInfo.setOrigStartNo(tagNo);
                        recInfo.setSubStartNumber(tagNo);
                        recInfo.setDraftNumber(recInfo.getDraftPackageNumber() + "-" + tagNo + "-" + recInfo.getOrigEndNo());
                    }
                }
            }
        } else {
            if (EmptyUtil.isEmpty((String)keepFlag)) {
                return;
            }
            if ((endNo = BillServerUtil.getBankReturnNo(recInfo, keepFlag, startNo, endNo)) != null) {
                ReceivableBillInfo upRecInfo;
                HashSet<String> needUpdateIdSet = new HashSet<String>();
                if (!EmptyUtil.isEmpty((String)recInfo.getSourceBillId()) && BOSObjectType.create((String)"16CC5356").equals((Object)BOSUuid.read((String)recInfo.getSourceBillId().toString()).getType()) && (upRecInfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(recInfo.getSourceBillId()))).getOrigEndNo() != null && endNo.compareTo(upRecInfo.getOrigEndNo()) == 0) {
                    return;
                }
                HashSet<String> idSet = new HashSet<String>();
                Map receBillMap = new HashMap<String, ReceivableBillInfo>();
                ReceivableBillCollection coll = iReceivableBill.getReceivableBillCollection("where draftPackageNumber = '" + recInfo.getDraftPackageNumber() + "' and company.id = '" + recInfo.getCompany().getId().toString() + "'");
                for (int i = 0; i < coll.size(); ++i) {
                    ReceivableBillInfo billInfo = coll.get(i);
                    if (billInfo.getBillState().equals((Object)BillStateEnum.ABANDON) || billInfo.getId().toString().equals(recInfo.getId().toString()) || billInfo.getOrigStartNo() == null || endNo.compareTo(billInfo.getOrigStartNo()) < 0) continue;
                    idSet.add(billInfo.getId().toString());
                    receBillMap.put(billInfo.getId().toString(), billInfo);
                }
                if (idSet.size() > 0) {
                    IBOTRelation iBOTR = BOTRelationFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new ReceivableBillInfo().getBOSType().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("srcObjectID", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    BOTRelationCollection botRelColl = iBOTR.getCollection(view);
                    ArrayList<String> endorList = new ArrayList<String>();
                    ArrayList<String> discountList = new ArrayList<String>();
                    ArrayList<String> wageList = new ArrayList<String>();
                    ArrayList<String> collRegistList = new ArrayList<String>();
                    HashMap<String, ArrayList<String>> billMap = new HashMap<String, ArrayList<String>>();
                    HashMap<String, String> destBillAndRecMap = new HashMap<String, String>();
                    for (int i = 0; i < botRelColl.size(); ++i) {
                        BOTRelationInfo relationInfo = botRelColl.get(i);
                        if ("2584B4A2".equals(relationInfo.getDestEntityID())) {
                            endorList.add(relationInfo.getDestObjectID());
                            destBillAndRecMap.put(relationInfo.getDestObjectID(), relationInfo.getSrcObjectID());
                            continue;
                        }
                        if ("99142CBB".equals(relationInfo.getDestEntityID())) {
                            discountList.add(relationInfo.getDestObjectID());
                            destBillAndRecMap.put(relationInfo.getDestObjectID(), relationInfo.getSrcObjectID());
                            continue;
                        }
                        if ("0523E75A".equals(relationInfo.getDestEntityID())) {
                            wageList.add(relationInfo.getDestObjectID());
                            destBillAndRecMap.put(relationInfo.getDestObjectID(), relationInfo.getSrcObjectID());
                            continue;
                        }
                        if (!"282893AF".equals(relationInfo.getDestEntityID())) continue;
                        collRegistList.add(relationInfo.getDestObjectID());
                        destBillAndRecMap.put(relationInfo.getDestObjectID(), relationInfo.getSrcObjectID());
                    }
                    billMap.put("2584B4A2", endorList);
                    billMap.put("99142CBB", discountList);
                    billMap.put("0523E75A", wageList);
                    billMap.put("282893AF", collRegistList);
                    ReceivableBillCollection collNew = new ReceivableBillCollection();
                    if (destBillAndRecMap.size() > 0) {
                        receBillMap = BillServerUtil.filterReceColl(ctx, destBillAndRecMap, billMap, receBillMap);
                    }
                    Set keySet = receBillMap.keySet();
                    Iterator it = keySet.iterator();
                    while (it.hasNext()) {
                        ReceivableBillInfo info = (ReceivableBillInfo)receBillMap.get(it.next());
                        collNew.add(info);
                    }
                    origStartNo = endNo.add(Constants.ONE);
                    for (int j = 0; j < collNew.size(); ++j) {
                        ReceivableBillInfo billInfo = collNew.get(j);
                        needUpdateIdSet.add(billInfo.getId().toString());
                    }
                }
                if (needUpdateIdSet.size() > 0) {
                    String sql = "update T_NT_ReceivableBill set FOrigStartNo=? where FID in (" + BillServerUtil.newBuildIn(needUpdateIdSet.toArray());
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{origStartNo});
                }
            }
        }
    }

    private static BigDecimal getBankReturnNo(ReceivableBillInfo recInfo, String keepFlag, BigDecimal startNo, BigDecimal endNo) {
        String[] strArr = keepFlag.split(";");
        for (int i = 0; i < strArr.length; ++i) {
            String returnValue = strArr[i].trim();
            if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("startNo=".toUpperCase(Locale.ENGLISH))) {
                startNo = TypeConversionUtils.objToBigDecimal((Object)returnValue.substring("startNo=".length()));
            }
            if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("endNo=".toUpperCase(Locale.ENGLISH))) continue;
            endNo = TypeConversionUtils.objToBigDecimal((Object)returnValue.substring("endNo=".length()));
        }
        if (startNo != null) {
            recInfo.setSubStartNumber(startNo);
            recInfo.setOrigStartNo(startNo);
        }
        if (endNo != null) {
            recInfo.setSubEndNumber(endNo);
            recInfo.setOrigEndNo(endNo);
        }
        if (startNo != null || endNo != null) {
            recInfo.setDraftNumber(recInfo.getDraftPackageNumber() + "-" + startNo + "-" + endNo);
            recInfo.setSubRegion(startNo + "-" + endNo);
        }
        return endNo;
    }

    private static Map filterReceColl(Context ctx, Map destBillAndRecMap, Map bizBillMap, Map receBillMap) throws BOSException {
        if (bizBillMap == null) {
            return receBillMap;
        }
        for (String bosType : bizBillMap.keySet()) {
            int i;
            List billIdList = (List)bizBillMap.get(bosType);
            if (billIdList.size() == 0) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)billIdList), CompareType.INCLUDE));
            view.setFilter(filter);
            ICoreBase icoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType));
            CoreBaseCollection billColl = icoreBase.getCollection(view);
            HashMap<String, Boolean> bankFailMap = new HashMap<String, Boolean>();
            for (i = 0; i < billColl.size(); ++i) {
                CoreBaseInfo entryBaseInfo;
                CoreBaseInfo coreBaseInfo = billColl.get(i);
                AbstractObjectCollection entryColl = null;
                entryColl = coreBaseInfo instanceof WageInfo ? (AbstractObjectCollection)coreBaseInfo.get("billEntrys") : (AbstractObjectCollection)coreBaseInfo.get("entrys");
                Iterator iterator = entryColl.iterator();
                if (!iterator.hasNext() || (Integer)(entryBaseInfo = (CoreBaseInfo)iterator.next()).get("bankReturnStatus") != 4) continue;
                bankFailMap.put(coreBaseInfo.getId().toString(), true);
                break;
            }
            for (i = 0; i < billColl.size(); ++i) {
                if (billColl.get(i).get("isCommitToBE") == null && billColl.get(i).get("isCommitToBe") == null || !((Boolean)billColl.get(i).get("isCommitToBE")).booleanValue() && !((Boolean)billColl.get(i).get("isCommitToBe")).booleanValue() || bankFailMap.get(billColl.get(i).getId().toString()) != null) continue;
                receBillMap.remove(destBillAndRecMap.get(billColl.get(i).getId().toString()));
            }
        }
        return receBillMap;
    }

    private static String newBuildIn(Object[] set) {
        if (set == null || set.length == 0) {
            return "'')";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < set.length; ++i) {
            if (i == set.length - 1) {
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                continue;
            }
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getBankRefKey(Context ctx, ReceivableBillInfo info) {
        String bankRefKey = "";
        bankRefKey = BillServerUtil.reursion(ctx, info, bankRefKey);
        return bankRefKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String reursion(Context ctx, ReceivableBillInfo info, String bankRefKey) {
        if (info.getSourceBillId() == null) return bankRefKey;
        BOSObjectType bosType = BOSUuid.read((String)info.getSourceBillId().toString()).getType();
        if (!EmptyUtil.isEmpty((Object)bosType) && BOSObjectType.create((String)"592A83B0").equals((Object)bosType)) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("elecDraft.*"));
                DraftSignInInfo signInInfo = DraftSignInFactory.getLocalInstance((Context)ctx).getDraftSignInInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), sic);
                ElecDraftInfo elecDraft = signInInfo.getElecDraft();
                if (EmptyUtil.isEmpty((String)elecDraft.getReserveds())) return bankRefKey;
                Object[] reserveds = elecDraft.getReserveds().split(";");
                if (EmptyUtil.isEmpty((Object[])reserveds)) return bankRefKey;
                int a = 0;
                while (a < reserveds.length) {
                    String returnValue = ((String)reserveds[a]).trim();
                    if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefKey=".toUpperCase(Locale.ENGLISH))) {
                        bankRefKey = returnValue.substring("bankRefKey=".length());
                    }
                    ++a;
                }
                return bankRefKey;
            }
            catch (EASBizException e) {
                logger.error((Object)"\u83b7\u53d6\u5e94\u6536\u7968\u636e(\u5e94\u6536\u7968\u636e\u53ef\u80fd\u662f\u5b50\u7968)\u7684\u6c47\u7968\u7b7e\u6536\u5907\u7528\u4fe1\u606f\u62a5\u9519\uff1a", (Throwable)e);
                e.printStackTrace();
                return bankRefKey;
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u5e94\u6536\u7968\u636e(\u5e94\u6536\u7968\u636e\u53ef\u80fd\u662f\u5b50\u7968)\u7684\u6c47\u7968\u7b7e\u6536\u5907\u7528\u4fe1\u606f\u62a5\u9519\uff1a", (Throwable)e);
                e.printStackTrace();
                return bankRefKey;
            }
        }
        if (EmptyUtil.isEmpty((Object)bosType)) return bankRefKey;
        if (!BOSObjectType.create((String)"16CC5356").equals((Object)bosType)) return bankRefKey;
        try {
            ReceivableBillInfo infoNew = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            return BillServerUtil.reursion(ctx, infoNew, bankRefKey);
        }
        catch (EASBizException e) {
            logger.error((Object)"\u83b7\u53d6\u5e94\u6536\u7968\u636e(\u5e94\u6536\u7968\u636e\u53ef\u80fd\u662f\u5b50\u7968)\u7684\u6c47\u7968\u7b7e\u6536\u5907\u7528\u4fe1\u606f\u62a5\u9519\uff1a", (Throwable)e);
            e.printStackTrace();
            return bankRefKey;
        }
        catch (BOSException e) {
            logger.error((Object)"\u83b7\u53d6\u5e94\u6536\u7968\u636e(\u5e94\u6536\u7968\u636e\u53ef\u80fd\u662f\u5b50\u7968)\u7684\u6c47\u7968\u7b7e\u6536\u5907\u7528\u4fe1\u606f\u62a5\u9519\uff1a", (Throwable)e);
            e.printStackTrace();
        }
        return bankRefKey;
    }

    public static void updateBizBillSettle(Context ctx, CoreBaseCollection recColl) {
        try {
            String updateSql = "update T_FM_ReceivableBillEntry set FReceivableBillNum = ? where  FReceivableBillID =?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (int i = 0; i < recColl.size(); ++i) {
                SettlementBillCollection settColl;
                SelectorItemCollection sic;
                int j;
                String newSettNum;
                String[] settNumAry;
                int fSeq;
                ReceivableBillInfo info = (ReceivableBillInfo)recColl.get(i);
                String sql = "select * from  T_FM_ReceivableBillEntry where  FReceivableBillID =?";
                paramsList.add(new Object[]{info.getDraftNumber(), info.getId().toString()});
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
                if (rs == null || !rs.next()) continue;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)rs.getString("FBillId")));
                view.setFilter(filter);
                if (new PaymentBillInfo().getBOSType().equals((Object)BOSUuid.read((String)rs.getString("FBillId")).getType())) {
                    PaymentBillCollection payColl = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(view);
                    if (EmptyUtil.isEmpty((AbstractObjectCollection)payColl) || payColl.get(0).getSettlementNumber() == null) continue;
                    PaymentBillInfo payInfo = payColl.get(0);
                    fSeq = rs.getInt("FSeq");
                    settNumAry = payInfo.getSettlementNumber().split(";");
                    if (settNumAry.length > 1) {
                        settNumAry[fSeq - 1] = info.getDraftNumber();
                        newSettNum = "";
                        for (j = 0; j < settNumAry.length; ++j) {
                            newSettNum = j == settNumAry.length - 1 ? newSettNum + settNumAry[j] : newSettNum + settNumAry[j] + ";";
                        }
                        if (!EmptyUtil.isEmpty((String)newSettNum)) {
                            payInfo.setSettlementNumber(newSettNum);
                        }
                    } else {
                        payInfo.setSettlementNumber(info.getDraftNumber());
                    }
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("settlementNumber"));
                    PaymentBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)payInfo, sic);
                    continue;
                }
                if (!new SettlementBillInfo().getBOSType().equals((Object)BOSUuid.read((String)rs.getString("FBillId")).getType()) || EmptyUtil.isEmpty((AbstractObjectCollection)(settColl = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillCollection(view))) || settColl.get(0).getOuterSettleNumber() == null) continue;
                SettlementBillInfo settInfo = settColl.get(0);
                fSeq = rs.getInt("FSeq");
                settNumAry = settInfo.getOuterSettleNumber().split(";");
                if (settNumAry.length > 1) {
                    settNumAry[fSeq - 1] = info.getDraftNumber();
                    newSettNum = "";
                    for (j = 0; j < settNumAry.length; ++j) {
                        newSettNum = j == settNumAry.length - 1 ? newSettNum + settNumAry[j] : newSettNum + settNumAry[j] + ";";
                    }
                    if (!EmptyUtil.isEmpty((String)newSettNum)) {
                        settInfo.setOuterSettleNumber(newSettNum);
                    }
                } else {
                    settInfo.setOuterSettleNumber(info.getDraftNumber());
                }
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("outerSettleNumber"));
                SettlementBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)settInfo, sic);
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u5e94\u6536\u7968\u636e\u5173\u8054\u7684\u4e1a\u52a1\u5355\u5f02\u5e38", (Throwable)e);
        }
    }
}

