/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.StorageSettingInstance;
import com.kingdee.eas.fm.nt.app.util.PayableBillJDBC;
import com.kingdee.eas.fm.nt.vo.PayableBillVO;
import com.kingdee.eas.util.ResourceBase;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBPayableBillService {
    private static Logger logger = Logger.getLogger((String)DBPayableBillService.class.getName());
    StorageSettingInstance storageSetting;
    EReceiptStorageSettingInfo eReceiptStorageSettingInfo;

    public void initService(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"\u5f00\u59cb \u521d\u59cb\u5316 \u57fa\u7840\u7535\u5b50\u56de\u5355\u5b58\u50a8\u8bbe\u7f6e\u6570\u636e");
        try {
            StorageSettingInstance.init((Context)ctx);
            this.storageSetting = StorageSettingInstance.getInstance((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.eReceiptStorageSettingInfo = this.storageSetting.getStorageSettingInfo();
        if (this.eReceiptStorageSettingInfo == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"427_DBPayableBillService", (Locale)ctx.getLocale()));
        }
    }

    public Map<String, byte[]> getBatchStorePDFMap(Context ctx, List contractIdList) throws BOSException, EASBizException {
        Map<String, byte[]> pdfMap;
        this.initService(ctx);
        PayableBillJDBC payableBill = new PayableBillJDBC();
        logger.error((Object)"\u7535\u5b50\u56de\u5355\u6570\u636e 1\u4e3a\u6570\u636e\u5b58\u653e\u5728PDF\u6570\u636e\u5e93\u4e2d  ");
        try {
            pdfMap = payableBill.getBatchEReceiptPDFValues(contractIdList, CompareType.INCLUDE, this.eReceiptStorageSettingInfo);
        }
        catch (Exception e) {
            logger.error((Object)("\u53bb\u56de\u5355\u6570\u636e\u5e93\u4e2d\u67e5\u8be2\u5408\u540c\u6587\u4ef6  \u8fd4\u56de\u7ed3\u679c \u53d1\u751f\u5f02\u5e38 \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1ae  " + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        logger.error((Object)"\u67e5\u8be2\u5408\u540c  \u8fd4\u56de\u7ed3\u679c \u5b8c\u6210  ");
        return pdfMap;
    }

    protected void insertEReceiptPDFToDB(Context ctx, byte[] fileValue, String contractId, String contractNumber) throws BOSException, EASBizException {
        this.initService(ctx);
        PayableBillJDBC payableBillJDBC = new PayableBillJDBC();
        PayableBillVO payableBillVO = new PayableBillVO();
        payableBillVO.setFID(contractId);
        payableBillVO.setEASID(contractId);
        payableBillVO.setFILENAME(contractNumber);
        ByteArrayInputStream input = new ByteArrayInputStream(fileValue);
        payableBillVO.setFILEVALUE(input);
        try {
            logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u6570\u636e\u5e93  start");
            payableBillJDBC.insertEReceipt(payableBillVO, this.eReceiptStorageSettingInfo);
            logger.error((Object)"\u4fdd\u5b58PDF\u5230 \u6570\u636e\u5e93  OK");
        }
        catch (Exception e) {
            String exMsg = "\u4fdd\u5b58PDF\u5230\u56de\u5355\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4PDF\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage();
            logger.error((Object)exMsg);
            e.printStackTrace();
            throw new BEException(null);
        }
    }
}

