/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.PaperNoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.PaperNoteRecOpUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.app.util.PaperNoteBizInfo;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.DiscountApplyBillCollection;
import com.kingdee.eas.fm.nt.DiscountApplyBillException;
import com.kingdee.eas.fm.nt.DiscountApplyBillInfo;
import com.kingdee.eas.fm.nt.DiscountApplyBillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTPHelper;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.AbstractDiscountApplyBillControllerBean;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.nt.app.util.ReceivableBillCommitToBEUtil;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class DiscountApplyBillControllerBean
extends AbstractDiscountApplyBillControllerBean {
    private static final long serialVersionUID = -3853781781538975808L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.DiscountApplyBillControllerBean");
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    private ReceivableBillCollection receivableColl = null;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DiscountApplyBillInfo disCountApplyBillInfo = (DiscountApplyBillInfo)model;
        this.validateInputData(ctx, model, false);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DiscountApplyBillInfo disCountApplyBillInfo = (DiscountApplyBillInfo)model;
        disCountApplyBillInfo.setBillState(DiscountApplyBillStateEnum.SUBMIT);
        if (disCountApplyBillInfo.getReceivableEntrys().size() > 0) {
            this.receivableColl = this.copyReceivableBillCollection(disCountApplyBillInfo.getReceivableEntrys());
        }
        if (disCountApplyBillInfo.getId() == null) {
            disCountApplyBillInfo.getReceivableEntrys().clear();
        }
        IObjectPK pk = super._submit(ctx, model);
        if (this.receivableColl != null) {
            Iterator iter = this.receivableColl.iterator();
            while (iter.hasNext()) {
                ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
                String noteBillId = recvBillInfo.getId().toString();
                if (StringUtils.isEmpty((String)noteBillId)) continue;
                DbUtil.execute((Context)ctx, (String)("update T_NT_ReceivableBill set FDiscountApplyId = '" + pk.toString() + "' WHERE FID='" + recvBillInfo.getId().toString() + "'"));
                FinUtils.addBotRelation((Context)ctx, (String)noteBillId, (String)pk.toString());
            }
        }
        return pk;
    }

    private void recsubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        DiscountApplyBillInfo disCountApplyBillInfo = (DiscountApplyBillInfo)model;
        if (disCountApplyBillInfo.getReceivableEntrys().size() > 0) {
            this.receivableColl = this.copyReceivableBillCollection(disCountApplyBillInfo.getReceivableEntrys());
        }
        if (disCountApplyBillInfo.getId() == null) {
            disCountApplyBillInfo.getReceivableEntrys().clear();
        }
        IObjectPK pk = super._submit(ctx, model);
        this.afterSubmit(ctx, (DiscountApplyBillInfo)model);
    }

    private void afterSubmit(Context ctx, DiscountApplyBillInfo model) throws BOSException, EASBizException {
        if (this.receivableColl != null) {
            IReceivableBill irecBill = ReceivableBillFactory.getLocalInstance(ctx);
            Iterator iter = this.receivableColl.iterator();
            while (iter.hasNext()) {
                ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
                recvBillInfo.setDiscountApplyBill(model);
                irecBill.update((IObjectPK)new ObjectUuidPK(recvBillInfo.getId()), (CoreBaseInfo)recvBillInfo);
            }
        }
    }

    private ReceivableBillCollection copyReceivableBillCollection(ReceivableBillCollection coll) {
        ReceivableBillCollection retColl = new ReceivableBillCollection();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            retColl.add((ReceivableBillInfo)iter.next());
        }
        return retColl;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.validateInputData(ctx, model, true);
        super._update(ctx, pk, model);
    }

    public void validateInputData(Context ctx, IObjectValue bill, boolean isUpdate) throws BOSException, EASBizException {
        String num;
        DiscountApplyBillInfo info = (DiscountApplyBillInfo)bill;
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        if ((num = info.getNumber()) == null || num.trim().length() == 0) {
            throw new DiscountApplyBillException(DiscountApplyBillException.NUMBER_NULL);
        }
        this.validateNumber(ctx, info, isUpdate);
        if (isUpdate) {
            if (info.getBizValidDateEnd() != null && info.getBizValidDateStart().compareTo(info.getBizValidDateEnd()) > 0) {
                throw new DiscountApplyBillException(DiscountApplyBillException.DISAPPLYBIZVALIDDATE_EXCEPTION);
            }
            if (null == info.getDiscountApplyAmt() || info.getDiscountApplyAmt().doubleValue() <= 0.0) {
                throw new DiscountApplyBillException(DiscountApplyBillException.DISAPPLYAMT_EXCEPTION);
            }
            if (null == info.getDiscountRate() || info.getDiscountRate().doubleValue() <= 0.0) {
                throw new DiscountApplyBillException(DiscountApplyBillException.DISAPPLYRATE_EXCEPTION);
            }
        }
    }

    private void validateNumber(Context ctx, DiscountApplyBillInfo info, boolean isUpdate) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        if (isUpdate && info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        String sql = "update T_NT_DiscountApplyBill set FBillState = ?,FAuditorID=?,FAuditDate=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer("2"), currentUser.getId().toString(), new Date(System.currentTimeMillis()), pk.toString()});
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            pk = new ObjectUuidPK((String)iter.next());
            super.audit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "update T_NT_DiscountApplyBill set FBillState = ? , FAuditDate=null , FAuditorID=null where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer("1"), pk.toString()});
    }

    @Override
    protected List _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        DiscountApplyBillCollection discountApplyBillCol = this.getDiscountApplyCol(ctx, idSet);
        ArrayList<String> returnList = new ArrayList<String>();
        DiscountApplyBillInfo tempInfo = null;
        for (int i = 0; i < discountApplyBillCol.size(); ++i) {
            tempInfo = discountApplyBillCol.get(i);
            try {
                if (tempInfo.getBillState() != DiscountApplyBillStateEnum.SAVED) continue;
                logger.info((Object)("\u6279\u91cf\u63d0\u4ea4\u8d34\u73b0\u7533\u8bf7\u5355\uff1a" + tempInfo.getId()));
                super.submit(ctx, (CoreBaseInfo)tempInfo);
                continue;
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
                returnList.add(tempInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.nt.client.DiscountApplyClientResource", (String)"12_Submited_failed", (Locale)ctx.getLocale()) + "\n" + e.getMessage());
            }
        }
        return returnList;
    }

    private DiscountApplyBillCollection getDiscountApplyCol(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return this.getDiscountApplyBillCollection(ctx, evi);
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            pk = new ObjectUuidPK((String)iter.next());
            super.antiAudit(ctx, (IObjectPK)pk);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        sic.add("receivableEntrys.*");
        sic.add("receivableEntrys.ntType.*");
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.id"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.name"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.bankAccountNumber"));
        return sic;
    }

    @Override
    protected void _commitToBE(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DiscountApplyBillInfo info = this.getDiscountApplyBillInfo(ctx, pk, this.getSelector());
        boolean canBE = false;
        if (info.isIsCommitToBE()) {
            if (NTPHelper.existBEProcessing(info.getReceivableEntrys())) {
                throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"056_COMMITBE_PROCESSING"));
            }
            if (NTPHelper.isBEAllProcessed(info.getReceivableEntrys())) {
                throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"043_COMMITTOBE_FINISHED"));
            }
            canBE = true;
        } else {
            canBE = true;
        }
        if (!canBE || info.getBillState() != DiscountApplyBillStateEnum.Audit) {
            throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"057_COMMITBE_CONDITION_LESSTHAN"));
        }
        this.doProcess(ctx, info);
    }

    private void doProcess(Context ctx, DiscountApplyBillInfo info) throws BOSException, EASBizException {
        TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
        for (int i = 0; i < info.getReceivableEntrys().size(); ++i) {
            ReceivableBillInfo entry = info.getReceivableEntrys().get(i);
            if (entry.getHolderAccount() == null) {
                throw new DiscountApplyBillException(DiscountApplyBillException.HOLDERACCT_CANNOT_NULL);
            }
            String accNo = entry.getHolderAccount().getBankAccountNumber();
            ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
            if (lst == null) {
                lst = new ArrayList<ReceivableBillInfo>();
            }
            lst.add(entry);
            accNoMap.put(accNo, lst);
        }
        PaperNoteRecOpUtil recOpUtil = new PaperNoteRecOpUtil(ctx);
        for (String accNo : accNoMap.keySet()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            List infoList = (List)accNoMap.get(accNo);
            for (ReceivableBillInfo entry : infoList) {
                totalAmount = totalAmount.add(entry.getBillAmt());
            }
            this.doCommitBE(ctx, recOpUtil, accNo, totalAmount, infoList, info);
        }
    }

    private void doCommitBE(Context ctx, PaperNoteRecOpUtil recOpUtil, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, DiscountApplyBillInfo info) throws BOSException, EASBizException {
        logger.debug((Object)"begin to commitToBE DiscountApplyBillInfo");
        try {
            this.beforeProcess(ctx, info.isIsCommitToBE(), infoList);
            NoteReceivableBody body = this.parseDiscountApplyBody(ctx, totalAmount, infoList, info);
            PaperNoteBizInfo bizInfo = new PaperNoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(PaperNoteTypeEnum.DISCOUNT_APPLY);
            NoteReceivableDetail[] detail = recOpUtil.paperNoteRecOp(ctx, bizInfo, body);
            info.setIsCommitToBE(true);
            this.updatePartial(ctx, (CoreBaseInfo)info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBE"}));
            this.afterProcess(ctx, infoList, detail);
        }
        catch (BEException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception(ctx, info.getReceivableEntrys());
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception(ctx, info.getReceivableEntrys());
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception(ctx, info.getReceivableEntrys());
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void beforeProcess(Context ctx, boolean isCommitToBE, List<ReceivableBillInfo> infoList) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
        CoreBaseCollection recBillCollection = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo info = infoList.get(i);
            info.setDetailSeqID(serialNos[i]);
            info.setBatchSeqID(serialNos[0]);
            if (isCommitToBE && info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                info.setBankReturnStatus(null);
                info.setBankReturnMsg(null);
            }
            recBillCollection.add((CoreBaseInfo)info);
        }
        ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recBillCollection);
    }

    private NoteReceivableBody parseDiscountApplyBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, DiscountApplyBillInfo info) {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = infoList.get(0).getBatchSeqID();
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseDiscountApplyDetail(ctx, infoList, info));
        return body;
    }

    private NoteReceivableDetail[] parseDiscountApplyDetail(Context ctx, List<ReceivableBillInfo> infoList, DiscountApplyBillInfo info) {
        NoteReceivableDetail[] details = new NoteReceivableDetail[infoList.size()];
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo entry = infoList.get(i);
            NoteReceivableDetail detail = new NoteReceivableDetail();
            detail.setDetailSeqID(entry.getDetailSeqID());
            detail.setDetailBizNo(entry.getDetailSeqID());
            detail.setBillNo(entry.getDraftNumber());
            detail.setDisCountRate(info.getDiscountRate().setScale(4, 4).toString());
            detail.setRateType(this.getRateType(info.getIntRateTypeExp()));
            if (entry.getBillAmt() == null) {
                detail.setOppAmount(BigDecimal.ZERO.setScale(2).toString());
            } else {
                detail.setOppAmount(entry.getBillAmt().setScale(2).toString());
            }
            details[i] = detail;
        }
        return details;
    }

    private String getRateType(IntRateTypeExpressionEnum rateTypeEnum) {
        String rateType = "";
        if (rateTypeEnum == IntRateTypeExpressionEnum.YEAR) {
            rateType = "01";
        } else if (rateTypeEnum == IntRateTypeExpressionEnum.MONTH) {
            rateType = "02";
        } else if (rateTypeEnum == IntRateTypeExpressionEnum.DAY) {
            rateType = "03";
        }
        return rateType;
    }

    private void afterProcess(Context ctx, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo recInfo = infoList.get(i);
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                recInfo.setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
                if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    // empty if block
                }
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                }
                recInfo.setBankReturnMsg(detail.getEbStatusMsg());
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recColl);
    }

    @Override
    protected Map _syncBeStatus(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        view.setSelector(this.getSelector());
        int success = 0;
        DiscountApplyBillCollection colls = this.getDiscountApplyBillCollection(ctx, view);
        PaperNoteRecOpUtil recOpUtil = new PaperNoteRecOpUtil(ctx);
        for (int i = 0; i < colls.size(); ++i) {
            DiscountApplyBillInfo info = colls.get(i);
            try {
                if (!info.isIsCommitToBE()) {
                    throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS"));
                }
                TreeMap<String, List<ReceivableBillInfo>> batchSeqMap = new TreeMap<String, List<ReceivableBillInfo>>();
                for (int j = 0; j < info.getReceivableEntrys().size(); ++j) {
                    ReceivableBillInfo entry = info.getReceivableEntrys().get(j);
                    String batchSeqID = entry.getBatchSeqID();
                    if (EmptyUtil.isEmpty((String)batchSeqID) || entry.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"071_COMMITFAIL_CANNOT_SYNCSTATUS"));
                    }
                    ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                this.doSyncStatus(ctx, recOpUtil, batchSeqMap);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == idSet.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doSyncStatus(Context ctx, PaperNoteRecOpUtil recOpUtil, Map<String, List<ReceivableBillInfo>> batchSeqMap) throws EASBizException, BOSException {
        for (String key : batchSeqMap.keySet()) {
            List<ReceivableBillInfo> infoList = batchSeqMap.get(key);
            NoteReceivableDetail[] details = this.queryRec(ctx, recOpUtil, infoList);
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess(ctx, infoList, details);
        }
    }

    private NoteReceivableDetail[] queryRec(Context ctx, PaperNoteRecOpUtil recOpUtil, List<ReceivableBillInfo> infoList) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(infoList.get(0).getBatchSeqID());
        String accNo = infoList.get(0).getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryPaperNoteRec(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    @Override
    protected void _updateBeStatus(Context ctx, List statusList) throws BOSException, EASBizException {
        logger.debug((Object)"begin to updateBeStatus DiscountApplyBillInfo");
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance(ctx);
        ArrayList<ReceivableBillInfo> updateList = new ArrayList<ReceivableBillInfo>();
        for (int i = 0; i < statusList.size(); ++i) {
            Map map = (Map)statusList.get(i);
            String id = (String)map.get("id");
            ReceivableBillInfo recInfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (recInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) {
                throw new BEException(BEException.UPDATESTATEERROR1);
            }
            recInfo.setBankReturnStatus((BankReturnStatusEnum)((Object)map.get("bankReturnStatus")));
            updateList.add(recInfo);
        }
        PaperNoteRecOpUtil util = new PaperNoteRecOpUtil(ctx);
        NoteStatusBody body = new NoteStatusBody();
        body.setTotalCount(String.valueOf(updateList.size()));
        body.setDetails(this.parseUpdteDetail(ctx, updateList));
        try {
            NoteStatusDetail[] details = util.updatePaperNoteStatus(ctx, null, body);
            this.afterProcess4Update(ctx, updateList, details);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        logger.debug((Object)"end to updateBeStatus DiscountApplyBillInfo");
    }

    private NoteStatusDetail[] parseUpdteDetail(Context ctx, List<ReceivableBillInfo> updateList) {
        NoteStatusDetail[] details = new NoteStatusDetail[updateList.size()];
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            NoteStatusDetail detail = new NoteStatusDetail();
            detail.setDetailSeqID(recInfo.getDetailSeqID());
            detail.setBatchSeqID(recInfo.getBatchSeqID());
            detail.setEbStatus(recInfo.getBankReturnStatus().getName());
            detail.setEbNoteType("noteRecivable");
            detail.setUpdateReason(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"065_EDITBESTATUS_BYHAND"));
            detail.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            detail.setOrganizationName(ContextUtil.getCurrentFIUnit((Context)ctx).getName());
            details[i] = detail;
        }
        return details;
    }

    private void afterProcess4Update(Context ctx, List<ReceivableBillInfo> updateList, NoteStatusDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteStatusDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                recInfo.setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
                if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    // empty if block
                }
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                }
                recInfo.setBankReturnMsg(detail.getEbStatusMsg());
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recColl);
    }

    @Override
    protected int _releaseFailedBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DiscountApplyBillInfo oldInfo = this.getDiscountApplyBillInfo(ctx, pk, this.getSelector());
        int oldEntrysCnt = oldInfo.getReceivableEntrys().size();
        List<ReceivableBillInfo> notFailList = this.getBENotFailColl(oldInfo.getReceivableEntrys());
        int notFailCnt = notFailList.size();
        if (notFailCnt == 0) {
            throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"064_CANNOT_RELEASEFAILEDBILL"));
        }
        DiscountApplyBillInfo newInfo = oldInfo;
        newInfo.getReceivableEntrys().clear();
        String draftNumber = "";
        BigDecimal billAmt = Constants.ZERO;
        BigDecimal exRate = BigDecimal.ONE;
        int i = 0;
        for (ReceivableBillInfo notFailEntry : notFailList) {
            newInfo.getReceivableEntrys().add(notFailEntry);
            draftNumber = draftNumber + notFailEntry.getDraftNumber() + ",";
            billAmt = billAmt.add(notFailEntry.getBillAmt());
            if (i == 0) {
                exRate = notFailEntry.getExchangeRate();
            }
            ++i;
        }
        newInfo.setId(null);
        newInfo.setDraftNumber(draftNumber.substring(0, draftNumber.length() - 1));
        newInfo.setDiscountApplyAmt(billAmt);
        newInfo.setLocalAmount(billAmt.multiply(exRate));
        this.cancelDiscountApply(ctx, pk);
        this.recsubmit(ctx, (IObjectValue)newInfo);
        return oldEntrysCnt - notFailCnt;
    }

    private List<ReceivableBillInfo> getBENotFailColl(ReceivableBillCollection coll) {
        ArrayList<ReceivableBillInfo> notFailList = new ArrayList<ReceivableBillInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (entry.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
            notFailList.add(entry);
        }
        return notFailList;
    }

    @Override
    protected void _cancelDiscountApply(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DiscountApplyBillInfo info = this.getDiscountApplyBillInfo(ctx, pk, this.getSelector());
        for (int i = 0; i < info.getReceivableEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = info.getReceivableEntrys().get(i);
            if (EmptyUtil.isEmpty((Object)((Object)recInfo.getBillState())) || recInfo.getBillState() != BillStateEnum.ABANDON) continue;
            throw new NTException(NTException.RETURNBILL_CANNOT_DELETE);
        }
        DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FElecBillStatus = null, FBankReturnStatus = null, FBankReturnMsg = null, FBatchSeqID = null, FDetailSeqID = null,  FDiscountApplyID = null, FLastUpdateTime = ? where FDiscountApplyID = ? ", (Object[])new Object[]{DateUtil.getTime(), pk.toString()});
        DbUtil.execute((Context)ctx, (String)"delete from T_NT_DiscountApplyBill where FID=?", (Object[])new Object[]{pk.toString()});
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        botRelation.removeRelationByDestObjId(pk.toString(), new ReceivableBillInfo().getBOSType().toString());
    }
}

