/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;

public class EndorseBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    private SelectorItemCollection getEndorseSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("CU.id");
        return sic;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        EndorsementBillInfo billInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getEndorseSelector());
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)billInfo, (String)"bankAccount");
        if (billInfo.getBankAccount() == null) {
            return null;
        }
        JournalInfo jnInfo = new JournalInfo();
        jnInfo.setAccountBank(billInfo.getBankAccount());
        jnInfo.setAccountView(billInfo.getBankAccount().getAccount());
        jnInfo.setCurrency(billInfo.getCurrency());
        jnInfo.setCreateDate(new Date());
        jnInfo.setIsDebit(true);
        jnInfo.setDebitAmount(billInfo.getEndorseAmt().subtract(billInfo.getFee()));
        jnInfo.setSettlementType(this.getSettlementType(ctx));
        String s = billInfo.getNoteBillNumber();
        if (s.length() > 80) {
            s = s.substring(0, 75) + "...";
        }
        jnInfo.setSettlementNumber(s);
        jnInfo.setBizDate(billInfo.getEndorseDate());
        jnInfo.setOppAccountView(billInfo.getOppAccount());
        jnInfo.setOppUnit(billInfo.getEndorsee());
        jnInfo.setBillType(BillTypeEnum.EndorsementBill);
        jnInfo.setBillNumber(s);
        jnInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"27_EndorseBillBookNotifyBuilder", (Locale)ctx.getLocale()));
        jnInfo.setBillId(billInfo.getId().toString());
        jnInfo.setType(JournalTypeEnum.BANK);
        jnInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        jnInfo.setCompany(billInfo.getCompany());
        jnInfo.setCU(billInfo.getCompany().getCU());
        jnInfo.setCashier(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        jnInfo.setSource(JournalSourceEnum.BYBILL);
        JournalCollection jnColl = new JournalCollection();
        jnColl.add(jnInfo);
        return jnColl;
    }

    private SettlementTypeInfo getSettlementType(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)"33333333-3333-3333-3333-3333333333331C9A9013"));
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = null;
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        return type;
    }
}

