/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ebservice.NoteDetailRequestBody;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.NoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.NoteReceivableOpUtil;
import com.kingdee.eas.fm.be.app.service.NoteUpdateStautsUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.app.util.NoteBizInfo;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.EndorseException;
import com.kingdee.eas.fm.nt.EndorseListingCollection;
import com.kingdee.eas.fm.nt.EndorseListingFactory;
import com.kingdee.eas.fm.nt.EndorseListingInfo;
import com.kingdee.eas.fm.nt.EndorseStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillCollection;
import com.kingdee.eas.fm.nt.EndorsementBillEntryCollection;
import com.kingdee.eas.fm.nt.EndorsementBillEntryFactory;
import com.kingdee.eas.fm.nt.EndorsementBillEntryInfo;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementDisposerFactory;
import com.kingdee.eas.fm.nt.EndorsementSettleEntryInfo;
import com.kingdee.eas.fm.nt.EndorsementTypeEnum;
import com.kingdee.eas.fm.nt.IEndorsementDisposer;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTPHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.OprtEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.AbstractEndorsementBillControllerBean;
import com.kingdee.eas.fm.nt.app.BillServerUtil;
import com.kingdee.eas.fm.nt.app.EndorseBillBookNotifyBuilder;
import com.kingdee.eas.fm.nt.app.InEndorseBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.nt.app.NTServerUtils;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.nt.app.util.ReceivableBillCommitToBEUtil;
import com.kingdee.eas.fm.ntp.BillTransBizType;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class EndorsementBillControllerBean
extends AbstractEndorsementBillControllerBean {
    private static final long serialVersionUID = -5849333427793340230L;
    private static Logger logger = Logger.getLogger((String)EndorsementBillControllerBean.class.getName());
    private ReceivableBillCollection ReceivableColl = null;
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final String PAYMENTBILLBOSTYPE = "40284E81";
    private static final String SETTLEMENTBILLBOSTYPE = "6E41E17C";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.beforeAddNew(ctx, (EndorsementBillInfo)model);
        super._addnew(ctx, pk, model);
        this.afterAddNew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeAddNew(ctx, (EndorsementBillInfo)model);
        IObjectPK pk = super._addnew(ctx, model);
        this.afterAddNew(ctx, pk, model);
        return pk;
    }

    private void afterAddNew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EndorsementBillInfo info = (EndorsementBillInfo)model;
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getNumber(), (String)"endorsementBill_addNew", (String)info.getCompany().getId().toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        this.addBotpRelation(ctx, pk, model);
    }

    @Override
    public EndorsementBillInfo getEndorsementBillInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super.getEndorsementBillInfo(ctx, pk, this.getSic());
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return super._getValue(ctx, pk, this.getSic());
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._getValue(ctx, pk, this.getSic());
    }

    private SelectorItemCollection getSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        sic.add("endorsedCompany.*");
        sic.add("innerAccount.*");
        sic.add("bankAccount.*");
        sic.add("bankAccount.InnerAcct.id");
        sic.add("bankAccount.InnerAcct.name");
        sic.add("bankAccount.InnerAcct.number");
        sic.add("endorsedSupplier.*");
        sic.add("endorsedCustomer.*");
        sic.add("fromCompany.*");
        sic.add("fpItem.*");
        sic.add("oppAccount.*");
        sic.add("receivableEntrys.*");
        sic.add("creator.*");
        sic.add("cashier.*");
        sic.add("auditor.*");
        sic.add("accountant.*");
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.id"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.name"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.bankAccountNumber"));
        sic.add("receivableEntrys.ntType.*");
        sic.add("receivableEntrys.ntType.group");
        sic.add("receivableEntrys.currency.*");
        sic.add("settleEntrys.settleAmount");
        sic.add("settleEntrys.*");
        sic.add("settleEntrys.supplier.*");
        sic.add("settleEntrys.customer.*");
        sic.add("settleEntrys.oppAccontView.*");
        sic.add("project.id");
        sic.add("project.name");
        sic.add("project.number");
        sic.add("costCenter.id");
        sic.add("costCenter.name");
        sic.add("costCenter.number");
        sic.add("fundFlowItem.id");
        sic.add("fundFlowItem.number");
        sic.add("fundFlowItem.name");
        sic.add("endorseeBank.id");
        sic.add("endorseeBank.number");
        sic.add("endorseeBank.name");
        sic.add("endorseeBank.BeProvince");
        sic.add("endorseeBank.BeCity");
        sic.add("entrys.*");
        sic.add("entrys.elecBillStatus");
        sic.add("entrys.bankReturnStatus");
        sic.add("entrys.bankReturnMsg");
        sic.add("entrys.receivableBill.*");
        sic.add("entrys.receivableBill.currency.*");
        sic.add("entrys.receivableBill.holderAccount.id");
        sic.add("entrys.receivableBill.holderAccount.name");
        sic.add("entrys.receivableBill.holderAccount.bankAccountNumber");
        sic.add("entrys.receivableBill.ntType.*");
        sic.add("entrys.receivableBill.ntType.group");
        sic.add("entrys.receivableBill.currency.*");
        sic.add("entrys.receivableBill.company.*");
        return sic;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EndorsementBillInfo info = (EndorsementBillInfo)model;
        EndorsementBillInfo oldinfo = new EndorsementBillInfo();
        if (info.getId() != null) {
            oldinfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo(pk);
        }
        if (info.getFee() == null) {
            info.setFee(Constants.ZERO);
        }
        if (info.getFeeRate() == null) {
            info.setFeeRate(Constants.ZERO);
        }
        this.updateState(info);
        this.checkEndorseDate(ctx, info);
        this.ReceivableColl = this.copyReceivableBillCollection(info.getReceivableEntrys());
        if (info.getId() == null) {
            info.getReceivableEntrys().clear();
        }
        super._submit(ctx, pk, model);
        this.afterSubmit(ctx, (EndorsementBillInfo)model, false);
        if ((info.getBillType() == EndorsementTypeEnum.IN || info.getBillType() == EndorsementTypeEnum.OUT) && info.isEdit()) {
            if (this.ReceivableColl == null) {
                return;
            }
            Iterator iter = this.ReceivableColl.iterator();
            while (iter.hasNext()) {
                ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
                String noteBillId = recvBillInfo.getId().toString();
                NTHelper.updateOprtLog(ctx, oldinfo, noteBillId, info);
            }
        }
        this.dispose(ctx, info, DisposerActionEnum.SUBMIT);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EndorsementBillInfo info = (EndorsementBillInfo)model;
        EndorsementBillInfo oldinfo = new EndorsementBillInfo();
        if (info.getId() != null) {
            oldinfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        }
        if (info.getFee() == null) {
            info.setFee(Constants.ZERO);
        }
        if (info.getFeeRate() == null) {
            info.setFeeRate(Constants.ZERO);
        }
        this.updateState(info);
        this.checkEndorseDate(ctx, info);
        this.ReceivableColl = this.copyReceivableBillCollection(info.getReceivableEntrys());
        if (info.getId() == null) {
            info.getReceivableEntrys().clear();
        }
        info.setNumber(info.getNoteBillNumber());
        IObjectPK pk = super._submit(ctx, model);
        String pfLogId_Submit_updateOprtLog = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"EndorsementBillControllerBean.Submit_updateOprtLog");
        if (info.getId() != null) {
            Iterator iter = this.ReceivableColl.iterator();
            while (iter.hasNext()) {
                ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
                String noteBillId = recvBillInfo.getId().toString();
                NTHelper.updateOprtLog(ctx, oldinfo, noteBillId, info);
            }
        }
        PerfLogRecorder.endRecord((String)pfLogId_Submit_updateOprtLog);
        String pfLogId_inSubmit_addlog = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"EndorsementBillControllerBean.Submit_addlog");
        NTPHelper.addBillTransLogByColl(ctx, this.ReceivableColl, BillTransBizType.ENDORSE_REGISTER);
        PerfLogRecorder.endRecord((String)pfLogId_inSubmit_addlog);
        this.dispose(ctx, info, DisposerActionEnum.SUBMIT);
        return pk;
    }

    private ReceivableBillCollection copyReceivableBillCollection(ReceivableBillCollection coll) {
        ReceivableBillCollection retColl = new ReceivableBillCollection();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            retColl.add((ReceivableBillInfo)iter.next());
        }
        return retColl;
    }

    private void updateState(EndorsementBillInfo info) {
        if (!(EndorseStateEnum.Confirmed.equals((Object)info.getState()) || EndorseStateEnum.Save.equals((Object)info.getState()) || EndorseStateEnum.Audited.equals((Object)info.getState()))) {
            info.setState(EndorseStateEnum.Submit);
        }
    }

    private void addBotpRelation(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        EndorsementBillInfo info = (EndorsementBillInfo)model;
        EndorsementBillEntryCollection entrycoll = info.getEntrys();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (int i = 0; i < entrycoll.size(); ++i) {
            EndorsementBillEntryInfo entryInfo = entrycoll.get(i);
            if (EmptyUtil.isEmpty((Object)entryInfo.getEndorseAmt()) || entryInfo.getEndorseAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            map.put(entryInfo.getReceivableBill().getId().toString(), entryInfo.getEndorseAmt());
        }
        if (this.ReceivableColl == null) {
            return;
        }
        Iterator iter = this.ReceivableColl.iterator();
        while (iter.hasNext()) {
            ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
            String noteBillId = recvBillInfo.getId().toString();
            if (!StringUtils.isEmpty((String)noteBillId)) {
                if (!this.isPartialEnd(map, recvBillInfo, info)) {
                    DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FEndorseBillId =? where FID=?", (Object[])new Object[]{info.getId().toString(), recvBillInfo.getId().toString()});
                }
                FinUtils.addBotRelation((Context)ctx, (String)noteBillId, (String)info.getId().toString());
            }
            if (StringUtils.isEmpty((String)info.getLinkbillId())) continue;
            FinUtils.addBotRelation((Context)ctx, (String)info.getLinkbillId(), (String)info.getId().toString());
        }
    }

    protected void beforeAddNew(Context ctx, EndorsementBillInfo model) throws BOSException, EASBizException {
        this.checkEndoreAddNew(ctx, model);
        model.setCreateTime(new Timestamp(new Date().getTime()));
    }

    private boolean getSysParam(Context ctx, String number, CompanyOrgUnitInfo cur) {
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        return contextHelper.getBooleanParam(number, (IObjectPK)new ObjectUuidPK(cur.getId().toString()));
    }

    private int getIntSysParam(Context ctx, String number, CompanyOrgUnitInfo cur) {
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        return contextHelper.getIntParam(number, (IObjectPK)new ObjectUuidPK(cur.getId().toString()));
    }

    private void afterSubmit(Context ctx, EndorsementBillInfo model, boolean isCreatRepayment) throws BOSException, EASBizException {
        BillStateEnum endorse_state;
        String noteDesc = null;
        boolean isAudit = this.getSysParam(ctx, "NT019", model.getCompany());
        if (model.getBillType() == EndorsementTypeEnum.IN) {
            ObjectUuidPK pk = new ObjectUuidPK(model.getId());
            if (!NTServerUtils.checkIsInAuditWF(ctx, (IObjectPK)pk)) {
                EndorsementBillInfo info = model;
                boolean isAutoAccount = this.getSysParam(ctx, "NT015", info.getCompany());
                int val = this.getIntSysParam(ctx, "CS001", info.getCompany());
                if (val == 0 && !isCreatRepayment && !isAudit) {
                    if (info.getBankAccount() != null && isAutoAccount) {
                        NTBookHelper.bookJournal(ctx, pk.toString(), EndorseBillBookNotifyBuilder.class.getName());
                    } else if (info.getInnerAccount() != null) {
                        this.recAccount(ctx, info);
                    }
                }
            }
            BOSUuid endorsedCompanyId = model.getEndorsedCompany().getId();
            CompanyOrgUnitInfo endorsedCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(endorsedCompanyId));
            noteDesc = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.app.EndorseServerResource", (String)"InEndorseNoteBillDescTemplete", (Locale)ctx.getLocale()) + endorsedCompanyInfo.getName();
            endorse_state = BillStateEnum.INENDORSED;
        } else if (model.getBillType() == EndorsementTypeEnum.OUT) {
            String suppName = model.getEndorsee();
            noteDesc = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.app.EndorseServerResource", (String)"OutEndorseNoteBillDescTemplete", (Locale)ctx.getLocale()) + suppName;
            endorse_state = BillStateEnum.OUTENDORSED;
            NTHelper.updateFpItem(ctx, (IObjectPK)new ObjectUuidPK(model.getId()), "com.kingdee.eas.fm.nt.app.EndorsementBill");
        } else {
            throw new AssertionError();
        }
        if (this.ReceivableColl == null) {
            return;
        }
        EndorsementBillEntryCollection entrycoll = model.getEntrys();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (int i = 0; i < entrycoll.size(); ++i) {
            EndorsementBillEntryInfo entryInfo = entrycoll.get(i);
            if (EmptyUtil.isEmpty((Object)entryInfo.getEndorseAmt()) || entryInfo.getEndorseAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            map.put(entryInfo.getReceivableBill().getId().toString(), entryInfo.getEndorseAmt());
        }
        IReceivableBill irecBill = ReceivableBillFactory.getLocalInstance(ctx);
        Iterator iter = this.ReceivableColl.iterator();
        while (iter.hasNext()) {
            ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
            if (this.isPartialEnd(map, recvBillInfo, model)) continue;
            recvBillInfo.setBillState(endorse_state);
            recvBillInfo.setDigest(noteDesc);
            recvBillInfo.setTransferDate(model.getEndorseDate());
            recvBillInfo.setEndorseBill(model);
            recvBillInfo.setAvailableAmt(BigDecimal.ZERO);
            recvBillInfo.setLockAmt(BigDecimal.ZERO);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("billState");
            selector.add("digest");
            selector.add("transferDate");
            selector.add("endorseBill");
            selector.add("availableAmt");
            selector.add("lockAmt");
            irecBill.updatePartial((CoreBaseInfo)recvBillInfo, selector);
            recvBillInfo.setOprtLogDate(model.getEndorseDate());
            if (!model.isEdit()) {
                NTHelper.writOprtLog(ctx, (IObjectValue)recvBillInfo, recvBillInfo.getId().toString(), OprtEnum.ENDORSE, OprtEnum.SAVE);
                continue;
            }
            NTHelper.writOprtLog(ctx, (IObjectValue)recvBillInfo, recvBillInfo.getId().toString(), OprtEnum.ENDORSE, OprtEnum.ENDORSE);
        }
    }

    protected boolean isPartialEnd(Map map, ReceivableBillInfo recvBillInfo, EndorsementBillInfo model) {
        if (model.getLinkbillId() != null && (BOSUuid.read((String)model.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString()) || BOSUuid.read((String)model.getLinkbillId()).getType().toString().equals(new SettlementBillInfo().getBOSType().toString()))) {
            return !recvBillInfo.getSource().equals((Object)BillSourceEnum.BYHAND) && !EmptyUtil.isEmpty(map.get(recvBillInfo.getId().toString())) && recvBillInfo.getBillAmt().compareTo((BigDecimal)map.get(recvBillInfo.getId().toString())) != 0;
        }
        return !recvBillInfo.getSource().equals((Object)BillSourceEnum.BYHAND) && BigDecimal.ZERO.compareTo(recvBillInfo.getLockAmt()) != 0;
    }

    protected void recAccount(Context ctx, EndorsementBillInfo endoreseBillInfo) throws EASBizException, BOSException {
        DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FHandlerId=? where FId=?", (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString(), endoreseBillInfo.getId().toString()});
        String endorsePK = endoreseBillInfo.getId().toString();
        ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)endoreseBillInfo.getCompany());
        NTBookHelper.bookSubsidiary(ctx, endorsePK, InEndorseBillSubsidiaryBookProvider.class.getName());
    }

    protected void antiRecAccount(Context ctx, EndorsementBillInfo endoreseBillInfo) throws EASBizException, BOSException {
        DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FHandlerId=null where FId=?", (Object[])new Object[]{endoreseBillInfo.getId().toString()});
        String endorsePK = endoreseBillInfo.getId().toString();
        NTBookHelper.antiBookSubsidiary(ctx, endorsePK);
    }

    private void checkEndoreAddNew(Context ctx, EndorsementBillInfo model) throws BOSException, EASBizException {
        String s = model.getNoteBillNumber();
        if (s.length() > 80) {
            model.setNoteBillNumber(s.substring(0, 75) + "...");
            model.setNumber(model.getNoteBillNumber());
        }
        EndorsementBillInfo info = model;
        if (this.ReceivableColl == null) {
            return;
        }
        if (StringUtils.isEmpty((String)info.getLinkbillId()) || !StringUtils.isEmpty((String)info.getLinkbillId()) && !BOSUuid.read((String)model.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString()) && !BOSUuid.read((String)model.getLinkbillId()).getType().toString().equals(new SettlementBillInfo().getBOSType().toString())) {
            HashSet<String> draftNumberset = new HashSet<String>();
            Iterator iter = this.ReceivableColl.iterator();
            while (iter.hasNext()) {
                ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
                draftNumberset.add(recvBillInfo.getId().toString());
            }
            ReceivableBillFactory.getLocalInstance(ctx).verifyBill(draftNumberset, model.getCompany().getId().toString());
        }
    }

    private void checkEndorseDate(Context ctx, EndorsementBillInfo model) throws EASBizException, BOSException {
        boolean bCandoExpired = this.isCandoExpired(ctx);
        Iterator iter = model.getReceivableEntrys().iterator();
        while (iter.hasNext()) {
            ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
            Date takeDate = DateUtil.getDayBegin((Date)recvBillInfo.getTakeDate());
            Date endoreDate = DateUtil.getDayBegin((Date)model.getEndorseDate());
            Date expiredDate = DateUtil.getDayBegin((Date)recvBillInfo.getExpiredDate());
            if (endoreDate.before(takeDate)) {
                throw new EndorseException(EndorseException.ENDORSEDATECANNOTBEFORENOTEBILLTAKEDATE);
            }
            if (bCandoExpired || !endoreDate.after(expiredDate)) continue;
            throw new NTException(NTException.BILLHASEXPIRED);
        }
    }

    private boolean isCandoExpired(Context ctx) {
        CompanyOrgUnitInfo cur = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        return contextHelper.getBooleanParam("NT009", (IObjectPK)new ObjectUuidPK(cur.getId().toString()));
    }

    @Override
    protected void _cancelInEndorse(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
        EndorsementBillInfo endInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(pk));
        if (!endInfo.getBillType().equals((Object)EndorsementTypeEnum.IN)) {
            throw new EndorseException(EndorseException.ONLYINENDORSECANCANCEL);
        }
        if (endInfo.getState().equals((Object)EndorseStateEnum.Confirmed)) {
            throw new EndorseException(EndorseException.ALREADYCONFIRMEDCANNOTCANCEL);
        }
        EndorsementBillEntryCollection entrycoll = endInfo.getEntrys();
        for (int i = 0; i < entrycoll.size(); ++i) {
            EndorsementBillEntryInfo entryInfo = entrycoll.get(i);
            if (!EmptyUtil.isEmpty((String)endInfo.getLinkbillId()) && BOSUuid.read((String)endInfo.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FTransferDate = null,FDigest=null,FEndorseBillId=null,FElecBillStatus = null, FBankReturnStatus = null, FBankReturnMsg = null, FBatchSeqID = null, FDetailSeqID = null, FBillState=?,FLastUpdateTime=?,fNotifyCompanyid=null,FLockAmt=FLockAmt+? where fid=?", (Object[])new Object[]{new Integer(NTHelper.getNTInitState(ctx, true)), DateUtil.getTime(), entryInfo.getEndorseAmt(), entryInfo.getReceivableBill().getId().toString()});
                continue;
            }
            if (!entryInfo.getReceivableBill().getSource().equals((Object)BillSourceEnum.BYHAND)) continue;
            DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FTransferDate = null,FDigest=null,FEndorseBillId=null,FElecBillStatus = null, FBankReturnStatus = null, FBankReturnMsg = null, FBatchSeqID = null, FDetailSeqID = null, FBillState=?,FLastUpdateTime=?,fNotifyCompanyid=null,FAvailableAmt=FBillAmt where fid=?", (Object[])new Object[]{new Integer(NTHelper.getNTInitState(ctx, true)), DateUtil.getTime(), entryInfo.getReceivableBill().getId().toString()});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new EndorsementBillInfo().getBOSType(), null, (String)endInfo.getNumber(), (String)"endorsementBill_cancelInEndorse", (String)endInfo.getCompany().getId().toString(), (String)"\u53d6\u6d88\u5bf9\u5185\u80cc\u4e66");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
        DbUtil.execute((Context)ctx, (String)"delete from T_NT_EndorsementBill where FID=?", (Object[])new Object[]{pk.toString()});
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        botRelation.removeRelationByDestObjId(pk.toString(), new ReceivableBillInfo().getBOSType().toString());
    }

    @Override
    protected void _cancelOutEndorse(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        EndorsementBillInfo endInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(pk), sic);
        String sql = "select FID from t_nt_receivablebill where FEndorseBillId='" + pk.toString() + "' and FBillState=9";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                throw new NTException(NTException.OUTENDORSEMENTNOTCANCEL);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!endInfo.getBillType().equals((Object)EndorsementTypeEnum.OUT)) {
            throw new AssertionError((Object)"must be OutEndorse");
        }
        EndorsementBillEntryCollection entrycoll = endInfo.getEntrys();
        for (int i = 0; i < entrycoll.size(); ++i) {
            EndorsementBillEntryInfo entryInfo = entrycoll.get(i);
            if (!EmptyUtil.isEmpty((Object)((Object)entryInfo.getBankReturnStatus())) && (entryInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_FAIL) || entryInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.COMMIT_FAIL))) continue;
            if (!EmptyUtil.isEmpty((String)endInfo.getLinkbillId()) && (BOSUuid.read((String)endInfo.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString()) || BOSUuid.read((String)endInfo.getLinkbillId()).getType().toString().equals(new SettlementBillInfo().getBOSType().toString()))) {
                if (!entryInfo.getReceivableBill().getSource().equals((Object)BillSourceEnum.BYHAND) && !EmptyUtil.isEmpty((Object)entryInfo.getReceivableBill().getLockAmt()) && (EmptyUtil.isEmpty((Object)entryInfo.getReceivableBill().getLockAmt()) || BigDecimal.ZERO.compareTo(entryInfo.getReceivableBill().getLockAmt()) != 0)) continue;
                DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FTransferDate = null,FDigest=null,FBatchSeqID = null, FDetailSeqID = null, FBillState=?,FEndorseBillID=null,FLastUpdateTime=?,FLockAmt=FLockAmt+? where fid=?", (Object[])new Object[]{new Integer(NTHelper.getNTInitState(ctx, true)), DateUtil.getTime(), entryInfo.getEndorseAmt(), entryInfo.getReceivableBill().getId().toString()});
                continue;
            }
            if (entryInfo.getReceivableBill().getSource().equals((Object)BillSourceEnum.BYHAND)) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FTransferDate = null,FDigest=null,FBatchSeqID = null, FDetailSeqID = null, FBillState=?,FEndorseBillID=null,FLastUpdateTime=?,FAvailableAmt=FBillAmt where fid=?", (Object[])new Object[]{new Integer(NTHelper.getNTInitState(ctx, true)), DateUtil.getTime(), entryInfo.getReceivableBill().getId().toString()});
                continue;
            }
            if (EmptyUtil.isEmpty((Object)entryInfo.getReceivableBill().getLockAmt()) || !EmptyUtil.isEmpty((Object)entryInfo.getReceivableBill().getLockAmt()) && BigDecimal.ZERO.compareTo(entryInfo.getReceivableBill().getLockAmt()) == 0) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FTransferDate = null,FDigest=null,FBatchSeqID = null, FDetailSeqID = null, FBillState=?,FEndorseBillID=null,FLastUpdateTime=?,FAvailableAmt=FAvailableAmt+? where fid=?", (Object[])new Object[]{new Integer(NTHelper.getNTInitState(ctx, true)), DateUtil.getTime(), entryInfo.getEndorseAmt(), entryInfo.getReceivableBill().getId().toString()});
                continue;
            }
            DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FTransferDate = null,FDigest=null,FBatchSeqID = null, FDetailSeqID = null, FBillState=?,FEndorseBillID=null,FLastUpdateTime=?,FAvailableAmt=FAvailableAmt+?,FLockAmt=FLockAmt-?  where fid=?", (Object[])new Object[]{new Integer(NTHelper.getNTInitState(ctx, true)), DateUtil.getTime(), entryInfo.getEndorseAmt(), entryInfo.getEndorseAmt(), entryInfo.getReceivableBill().getId().toString()});
        }
        boolean isCancelPay = this.isCancelPay(ctx, endInfo);
        if (!isCancelPay) {
            DbUtil.execute((Context)ctx, (String)"delete from T_NT_EndorsementBill where FID=?", (Object[])new Object[]{pk.toString()});
            DbUtil.execute((Context)ctx, (String)"delete from T_NT_EndorsementSettleEntry where FParentID=?", (Object[])new Object[]{pk.toString()});
        }
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        if (!isCancelPay) {
            botRelation.removeRelationByDestObjId(pk.toString(), new ReceivableBillInfo().getBOSType().toString());
        }
        botRelation.removeRelationByDestObjId(pk.toString(), new PaymentBillInfo().getBOSType().toString());
        botRelation.removeRelationByDestObjId(pk.toString(), new SettlementBillInfo().getBOSType().toString());
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new EndorsementBillInfo().getBOSType(), null, (String)endInfo.getNumber(), (String)"endorsementBill_cancelOutEndorse", (String)endInfo.getCompany().getId().toString(), (String)"\u53d6\u6d88\u5bf9\u5916\u80cc\u4e66");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        BOTRelationInfo botInfo = (BOTRelationInfo)bOTRelationInfo;
        if (botInfo.getDestEntityID().equals(new VoucherInfo().getBOSType().toString())) {
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("number"));
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botInfo.getDestObjectID()), sic);
                DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FAccountantID=?, FFivouchered=1, FVoucherNumber=? where FID=?", (Object[])new Object[]{user.getId().toString(), voucherInfo.getNumber(), botInfo.getSrcObjectID()});
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FAccountantID=null,FFivouchered=0, FVoucherNumber=null where FID=?", (Object[])new Object[]{botInfo.getSrcObjectID()});
            }
        }
        if (botInfo.getDestEntityID().equals(new PaymentBillInfo().getBOSType().toString())) {
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE) && !NTHelper.ifHaveDestBills(ctx, srcBillPK.toString(), botInfo.getDestEntityID())) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FRpBillId=null where FID=?", (Object[])new Object[]{srcBillPK.toString()});
            }
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FRpBillId=? where FID=?", (Object[])new Object[]{botInfo.getDestObjectID(), srcBillPK.toString()});
            }
        }
    }

    private void dispose(Context ctx, EndorsementBillInfo info, DisposerActionEnum disposerActionEnum) throws BOSException, EASBizException {
        IEndorsementDisposer disposer = EndorsementDisposerFactory.getInstance(ctx, info.getLinkbillId());
        if (disposer != null) {
            BillDisposerAction disposerAction = new BillDisposerAction();
            disposerAction.setDestBill((CoreBaseInfo)info);
            disposerAction.setActionType(disposerActionEnum);
            disposer.dispose(ctx, disposerAction);
        }
    }

    @Override
    protected void _cancelConfirm(Context ctx, String id) throws BOSException, EASBizException {
        EndorsementBillInfo info = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(id));
        BOSUuid curCompanyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId();
        ArrayList recvBillIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(id, new ReceivableBillInfo().getBOSType().toString());
        if (recvBillIdList.size() == 0) {
            return;
        }
        for (int i = 0; i < recvBillIdList.size(); ++i) {
            String recvBillId = recvBillIdList.get(i).toString();
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(recvBillId);
            ReceivableBillInfo recvInfo = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(recvBillId));
            this.checkCancelConfirmRecv(ctx, recvInfo);
            DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FSourceBillID=null where FId=?", (Object[])new Object[]{recvInfo.getId().toString()});
            ReceivableBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(recvInfo.getId()));
        }
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        botRelation.removeRelationBySrcObjId(id, new ReceivableBillInfo().getBOSType().toString());
        boolean isAudit = this.getSysParam(ctx, "NT019", info.getCompany());
        Integer submitState = isAudit ? new Integer(3) : new Integer(1);
        DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set Fstate=?,FConfirmerID=null,fconfirmDate=null where FId=?", (Object[])new Object[]{submitState, id});
        if (info.getBillType() == EndorsementTypeEnum.IN) {
            FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getCompany().getId().toString());
        }
    }

    private void checkCancelConfirmRecv(Context ctx, ReceivableBillInfo recvInfo) throws EndorseException {
        if (!recvInfo.getBillState().equals((Object)BillStateEnum.SAVED)) {
            throw new EndorseException(EndorseException.RECVNOTSAVEDSTATECANNOTCANCELCONFIRMED);
        }
        if (recvInfo.isFivouchered()) {
            throw new EndorseException(EndorseException.RECVVOUCHEREDCANNOTCANCELCONFIRMED);
        }
    }

    private void checkCancelConfirmSubsidiaryLedger(Context ctx, EndorsementBillInfo info, BOSUuid curCompanyId) throws EndorseException, EASBizException, BOSException {
        if (info.getState().equals((Object)EndorseStateEnum.Confirmed) && info.getFromCompany().getId().equals((Object)curCompanyId)) {
            throw new EndorseException(EndorseException.ONLYCONFIRMEDNOTSELFBILLCANCANCELCONFIRM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _cancelEndorse(Context ctx, BOSUuid pk, boolean isFromOtherBill) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        EndorsementBillInfo endInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(pk), sic);
        if (!this.checkFinalCheckout(ctx, SystemEnum.NT_MANAGEMENT, endInfo.getCompany().getId().toString(), endInfo.getEndorseDate())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED", (Locale)ctx.getLocale())});
        }
        boolean isCanUpdate = false;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            isCanUpdate = iMutex.requestBizObjIDForUpdate(endInfo.getId().toString());
            if (!isCanUpdate) {
                throw new NTException(NTException.NOT_OPERATION);
            }
            boolean isCancelPay = this.isCancelPay(ctx, endInfo);
            if (isFromOtherBill && !isCancelPay && (endInfo.getState() != EndorseStateEnum.Submit || endInfo.isFiVouchered() || endInfo.isIsCommitToBE() && (!endInfo.isIsCommitToBE() || !this.isBEAllFail(endInfo, true)))) {
                throw new NTException(NTException.NOT_CANCELENDORSE);
            }
            IReceivableBill iBill = ReceivableBillFactory.getLocalInstance(ctx);
            ReceivableBillCollection recBillCol = iBill.getReceivableBillCollection(" where endorseBill = '" + pk.toString() + "'");
            Iterator iterator = recBillCol.iterator();
            while (iterator.hasNext()) {
                ReceivableBillInfo recInfo = (ReceivableBillInfo)iterator.next();
                if (FMHelper.isEmpty((CoreBaseInfo)recInfo)) continue;
                if (!FMHelper.isEmpty((Object)((Object)recInfo.getBillState())) && recInfo.getBillState() == BillStateEnum.ABANDON) {
                    throw new NTException(NTException.CANNOTENDORSE4RETURNBILL);
                }
                if (!endInfo.getBillType().equals((Object)EndorsementTypeEnum.OUT)) continue;
                iBill.checkNumberDup((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)recInfo.getId().toString())), (CoreBillBaseInfo)recInfo);
            }
            if (!FMHelper.isEmpty((String)endInfo.getRpBillId())) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)this.getPaymentIdsByEndorse(ctx, endInfo.getId().toString()), CompareType.INCLUDE));
                view.setFilter(fi);
                BillBaseCollection coll = PaymentBillFactory.getLocalInstance((Context)ctx).getBillBaseCollection(view);
                for (PaymentBillInfo info : coll) {
                    PaymentBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                }
            }
            if (!isFromOtherBill && endInfo.getLinkbillId() != null && !"".equals(endInfo.getLinkbillId())) {
                if (BOSUuid.read((String)endInfo.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                    throw new EndorseException(EndorseException.NOTCANCELENDORSEBYHAND);
                }
                if (BOSUuid.read((String)endInfo.getLinkbillId()).getType().toString().equals(new SettlementBillInfo().getBOSType().toString())) {
                    throw new EndorseException(EndorseException.NOTCANCELENDORSEBYSETT);
                }
            }
            NTBookHelper.autoAntiBookJournal(ctx, endInfo.getId().toString(), endInfo.getCompany());
            iterator = endInfo.getReceivableEntrys().iterator();
            while (iterator.hasNext()) {
                ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iterator.next();
                recvBillInfo.setOprtLogDate(endInfo.getEndorseDate());
                NTHelper.writOprtLog(ctx, (IObjectValue)recvBillInfo, recvBillInfo.getId().toString(), OprtEnum.SAVE, OprtEnum.ENDORSE);
            }
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectUuidPK(pk));
            if (endInfo.getBillType().equals((Object)EndorsementTypeEnum.OUT)) {
                NTHelper.cancelFpItem(ctx, pk.toString());
                this.cancelOutEndorse(ctx, pk);
            } else if (endInfo.getBillType().equals((Object)EndorsementTypeEnum.IN)) {
                this.cancelInEndorse(ctx, pk);
            } else {
                throw new AssertionError();
            }
            NTPHelper.addBillTransLogByColl(ctx, recBillCol, BillTransBizType.ENDORSE_CANCEL);
        }
        finally {
            if (isCanUpdate) {
                iMutex.releaseObjIDForUpdate(endInfo.getId().toString());
            }
        }
    }

    protected boolean checkFinalCheckout(Context ctx, SystemEnum systemEnum, String companyId, Date bizDate) throws BOSException, EASBizException {
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FMJZ001", (IObjectPK)new ObjectUuidPK(companyId));
        if (!val) {
            return true;
        }
        int systemEnumValue = systemEnum.getValue();
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo currentPeriod = ictrol.getCacheCurrentPeriod(systemEnumValue, companyId);
        Boolean isStart = ictrol.isStart(systemEnumValue, companyId);
        if (!isStart.booleanValue()) {
            return true;
        }
        if (currentPeriod == null) {
            return true;
        }
        Date peroidStart = currentPeriod.getBeginDate();
        if (bizDate == null) {
            return true;
        }
        return !bizDate.before(peroidStart);
    }

    private boolean isBEAllFail(EndorsementBillInfo sourceBill, boolean rejected) {
        boolean flg = true;
        EndorsementBillEntryCollection coll = sourceBill.getEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            EndorsementBillEntryInfo info = coll.get(i);
            if (info.getBankReturnStatus() != null) {
                if (rejected) {
                    if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
                    flg = false;
                    break;
                }
                if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) continue;
                flg = false;
                break;
            }
            flg = false;
            break;
        }
        return flg;
    }

    private Set getPaymentIdsByEndorse(Context ctx, String id) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        String sql = "select a.* from  t_cas_paymentbill a, t_cas_paymentbillentry b where a.fid=b.fpaymentbillid and b.fsourcebillid='" + id + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return idSet;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue endorseBill, boolean isCreatePayment) throws BOSException, EASBizException {
        EndorsementBillInfo element = (EndorsementBillInfo)endorseBill;
        IObjectPK pk = this.submit(ctx, (CoreBaseInfo)element);
        this.afterSubmit(ctx, element, isCreatePayment);
        if (isCreatePayment) {
            element.getReceivableEntrys().addCollection(this.ReceivableColl);
            String s = element.getNoteBillNumber();
            if (s.length() > 80) {
                element.setNoteBillNumber(s.substring(0, 75) + "...");
            }
            NTHelper.genPaymentBillByBotp(ctx, (CoreBillBaseInfo)element);
        }
        return pk;
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        for (String id : idSet) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _batchUnAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        for (String id : idSet) {
            this.unAudit(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EndorsementBillInfo info = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo(pk);
        if (info.getState() != EndorseStateEnum.Submit) {
            throw new NTException(NTException.NOTALLSUBMIT);
        }
        info.setState(EndorseStateEnum.Audited);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setAuditor(userInfo);
        EndorsementBillEntryCollection entrycoll = info.getEntrys();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (int i = 0; i < entrycoll.size(); ++i) {
            EndorsementBillEntryInfo entryInfo = entrycoll.get(i);
            if (EmptyUtil.isEmpty((Object)entryInfo.getEndorseAmt()) || entryInfo.getEndorseAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            map.put(entryInfo.getReceivableBill().getId().toString(), entryInfo.getEndorseAmt());
        }
        IReceivableBill irecBill = ReceivableBillFactory.getLocalInstance(ctx);
        ReceivableBillCollection coll = info.getReceivableEntrys();
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                ReceivableBillInfo bill = coll.get(i);
                if (this.isPartialEnd(map, bill, info)) continue;
                bill.setBillLastState(bill.getBillState());
                if (info.getBillType() == EndorsementTypeEnum.IN) {
                    bill.setBillState(BillStateEnum.INENDORSED);
                } else {
                    bill.setBillState(BillStateEnum.OUTENDORSED);
                }
                irecBill.update((IObjectPK)new ObjectUuidPK(bill.getId().toString()), (CoreBaseInfo)bill);
            }
        }
        EndorsementBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
        if (info.getBillType() == EndorsementTypeEnum.IN) {
            boolean isAudit = this.getSysParam(ctx, "NT019", info.getCompany());
            boolean isAutoAccount = this.getSysParam(ctx, "NT015", info.getCompany());
            int val = this.getIntSysParam(ctx, "CS001", info.getCompany());
            if (val == 0 && info.getRpBillId() == null && isAudit) {
                if (info.getBankAccount() != null && isAutoAccount) {
                    NTBookHelper.bookJournal(ctx, pk.toString(), EndorseBillBookNotifyBuilder.class.getName());
                } else if (info.getInnerAccount() != null) {
                    this.recAccount(ctx, info);
                }
            }
        }
        NTPHelper.addBillTransLogByColl(ctx, coll, BillTransBizType.ENDORSE_AUDIT);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new EndorsementBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"endorsementBill_audit", (String)info.getCompany().getId().toString(), (String)"\u80cc\u4e66\u5355\u5ba1\u6279");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EndorsementBillInfo info = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo(pk);
        if (info.getState() != EndorseStateEnum.Audited) {
            throw new NTException(NTException.NOTALLAUDIT);
        }
        if (info.isFiVouchered()) {
            throw new NTException(NTException.ISFIVOUCHERED);
        }
        info.setState(EndorseStateEnum.Submit);
        info.setAuditor(null);
        ReceivableBillCollection coll = info.getReceivableEntrys();
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                ReceivableBillInfo bill = coll.get(i);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)bill.getDraftNumber()));
                view.setFilter(filterInfo);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("draftNumber"));
                sic.add(new SelectorItemInfo("takeDate"));
                view.setSelector(sic);
                ReceivableBillCollection receivableBillcolls = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillCollection(view);
                if (receivableBillcolls.size() > 1) {
                    for (int k = 0; k < receivableBillcolls.size(); ++k) {
                        if (!coll.get(i).getTakeDate().before(receivableBillcolls.get(k).getTakeDate())) continue;
                        throw new EndorseException(EndorseException.EXITOTHERENDORSEMENTBILL);
                    }
                }
                bill.setBillState(bill.getBillLastState());
            }
        }
        EndorsementBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
        if (info.getBillType() == EndorsementTypeEnum.IN) {
            boolean isAudit = this.getSysParam(ctx, "NT019", info.getCompany());
            boolean isAutoAccount = this.getSysParam(ctx, "NT015", info.getCompany());
            int val = this.getIntSysParam(ctx, "CS001", info.getCompany());
            if (val == 0 && info.getRpBillId() == null && isAudit) {
                if (info.getBankAccount() != null && isAutoAccount) {
                    NTBookHelper.autoAntiBookJournal(ctx, pk.toString(), info.getCompany());
                } else if (info.getInnerAccount() != null) {
                    this.antiRecAccount(ctx, info);
                }
            }
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new EndorsementBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"endorsementBill_unAudit", (String)info.getCompany().getId().toString(), (String)"\u80cc\u4e66\u5355\u53cd\u5ba1\u6279");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected IObjectPK _inSubmit(Context ctx, IObjectValue model, boolean isCreatePayment) throws BOSException, EASBizException {
        EndorsementBillInfo element = (EndorsementBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)element);
        element.setState(EndorseStateEnum.Submit);
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"EndorsementBillControllerBean.insubmit");
        IObjectPK pk = this._submit(ctx, (IObjectValue)element);
        PerfLogRecorder.endRecord((String)pfLogId);
        String pfLogId_afterSubmit = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"EndorsementBillControllerBean.afterInSubmit");
        this.afterSubmit(ctx, element, isCreatePayment);
        PerfLogRecorder.endRecord((String)pfLogId_afterSubmit);
        element.put("id", element.getId());
        if (isCreatePayment) {
            element.getReceivableEntrys().addCollection(this.ReceivableColl);
            String s = element.getNoteBillNumber();
            if (s.length() > 80) {
                element.setNoteBillNumber(s.substring(0, 75) + "...");
            }
            NTHelper.genPaymentBillByBotp(ctx, (CoreBillBaseInfo)element, false);
        }
        return pk;
    }

    @Override
    protected IObjectPK _outSubmit(Context ctx, IObjectValue model, boolean isCreatePayment) throws BOSException, EASBizException {
        EndorsementBillInfo element = (EndorsementBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)element);
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"EndorsementBillControllerBean.outsubmit");
        IObjectPK pk = this._submit(ctx, (IObjectValue)element);
        PerfLogRecorder.endRecord((String)pfLogId);
        String pfLogId_afterSubmit = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"EndorsementBillControllerBean.afteroutSubmit");
        this.afterSubmit(ctx, element, false);
        PerfLogRecorder.endRecord((String)pfLogId_afterSubmit);
        element.put("id", element.getId());
        if (isCreatePayment) {
            element.getReceivableEntrys().addCollection(this.ReceivableColl);
            String s = element.getNoteBillNumber();
            if (s.length() > 80) {
                element.setNoteBillNumber(s.substring(0, 75) + "...");
            }
            NTHelper.genPaymentBillByBotp(ctx, (CoreBillBaseInfo)element, false);
        }
        return pk;
    }

    @Override
    protected ArrayList _batchCommitToBE(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> commitResult = new ArrayList<BankPayResult>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        evi.setSelector(this.getSic());
        EndorsementBillCollection infoColl = this.getEndorsementBillCollection(ctx, evi);
        int count = infoColl.size();
        for (int i = 0; i < count; ++i) {
            BankPayResult resultInfo;
            EndorsementBillInfo info = infoColl.get(i);
            if (info.getBillMedium() != BillMediumEnum.ELECTRONIC) {
                BankPayResult resultInfo2 = new BankPayResult();
                resultInfo2.setId(info.getId().toString());
                resultInfo2.setNumber(info.getNumber());
                resultInfo2.setErrorDetail(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"455_EndorsementBillControllerBean", (Locale)ctx.getLocale()));
                commitResult.add(resultInfo2);
                continue;
            }
            boolean canBE = false;
            if (info.isIsCommitToBE()) {
                if (NTPHelper.existBEProcessing(info.getReceivableEntrys())) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(info.getId().toString());
                    resultInfo.setNumber(info.getNumber());
                    resultInfo.setErrorDetail(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"456_EndorsementBillControllerBean", (Locale)ctx.getLocale()));
                    commitResult.add(resultInfo);
                    continue;
                }
                if (NTPHelper.isBEAllProcessed(info.getReceivableEntrys())) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(info.getId().toString());
                    resultInfo.setNumber(info.getNumber());
                    resultInfo.setErrorDetail(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"457_EndorsementBillControllerBean", (Locale)ctx.getLocale()));
                    commitResult.add(resultInfo);
                    continue;
                }
                canBE = true;
            } else {
                canBE = true;
            }
            if (canBE && this.isCommitBE(ctx, info)) {
                try {
                    this.doProcess(ctx, info);
                }
                catch (Exception e) {
                    BankPayResult resultInfo3 = new BankPayResult();
                    resultInfo3.setId(info.getId().toString());
                    resultInfo3.setNumber(info.getNumber());
                    resultInfo3.setErrorDetail(e.getMessage());
                    commitResult.add(resultInfo3);
                }
                continue;
            }
            resultInfo = new BankPayResult();
            resultInfo.setId(info.getId().toString());
            resultInfo.setNumber(info.getNumber());
            resultInfo.setErrorDetail(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"458_EndorsementBillControllerBean", (Locale)ctx.getLocale()));
            commitResult.add(resultInfo);
        }
        return commitResult;
    }

    @Override
    protected void _commitToBE(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EndorsementBillInfo info = this.getEndorsementBillInfo(ctx, pk, this.getSic());
        if (info.getBillMedium() != BillMediumEnum.ELECTRONIC) {
            throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"042_ISNOT_ELECTRONIC"));
        }
        boolean canBE = false;
        if (info.isIsCommitToBE()) {
            if (NTPHelper.existBEProcessing(info.getEntrys())) {
                throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"056_COMMITBE_PROCESSING"));
            }
            if (NTPHelper.isBEAllProcessed(info.getEntrys())) {
                throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"043_COMMITTOBE_FINISHED"));
            }
            canBE = true;
        } else {
            canBE = true;
        }
        if (!canBE || !this.isCommitBE(ctx, info)) {
            throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"057_COMMITBE_CONDITION_LESSTHAN"));
        }
        this.doProcess(ctx, info);
    }

    private void doProcess(Context ctx, EndorsementBillInfo info) throws BOSException, EASBizException {
        TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
        logger.error((Object)("\u80cc\u4e66\u5355\u5f00\u59cb\u63d0\u4ea4\u94f6\u4f01\uff0cID\u4e3a " + info.getId().toString()));
        logger.error((Object)("\u80cc\u4e66\u5355\u5206\u5f55\u6570\u91cf\u4e3a " + info.getEntrys().size()));
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            ReceivableBillInfo entry = info.getEntrys().get(i).getReceivableBill();
            logger.error((Object)("\u80cc\u4e66\u5355\u5206\u5f55\u5bf9\u5e94\u5e94\u6536\u7968\u636e " + info.getEntrys().get(i).getReceivableBill().getId().toString()));
            String accNo = entry.getHolderAccount().getBankAccountNumber();
            logger.error((Object)("\u5e94\u6536\u7968\u636e\u6301\u7968\u4eba\u8d26\u6237 " + entry.getHolderAccount().getBankAccountNumber()));
            ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
            if (lst == null) {
                lst = new ArrayList<ReceivableBillInfo>();
            }
            lst.add(entry);
            accNoMap.put(accNo, lst);
            if (!EmptyUtil.isEmpty((Object)info.getEntrys().get(i).getEndorseAmt()) && info.getEntrys().get(i).getEndorseAmt().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal endAmt = info.getEntrys().get(i).getEndorseAmt();
                amtMap.put(entry.getId().toString(), endAmt);
            }
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("receivableBill.draftPackageNumber", (Object)entry.getDraftPackageNumber()));
                view.setFilter(filterInfo);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("receivableBill.draftPackageNumber"));
                sic.add(new SelectorItemInfo("receivableBill.bankReturnStatus"));
                sic.add(new SelectorItemInfo("bankReturnStatus"));
                sic.add(new SelectorItemInfo("parent.id"));
                view.setSelector(sic);
                EndorsementBillEntryCollection endorsementEntryBillcolls = EndorsementBillEntryFactory.getLocalInstance(ctx).getEndorsementBillEntryCollection(view);
                HashSet<String> ids = new HashSet<String>();
                if (endorsementEntryBillcolls.size() > 0) {
                    for (int j = 0; j < endorsementEntryBillcolls.size(); ++j) {
                        EndorsementBillEntryInfo entryInfo = endorsementEntryBillcolls.get(j);
                        if (!EmptyUtil.isEmpty((Object)((Object)entryInfo.getBankReturnStatus())) && (entryInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.EB_PROCESSING) || entryInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_PROCESSING))) {
                            ids.add(entryInfo.getParent().getId().toString());
                            continue;
                        }
                        if (EmptyUtil.isEmpty((Object)((Object)entryInfo.getReceivableBill().getBankReturnStatus())) || !entryInfo.getReceivableBill().getBankReturnStatus().equals((Object)BankReturnStatusEnum.EB_PROCESSING) && !entryInfo.getReceivableBill().getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_PROCESSING)) continue;
                        ids.add(entryInfo.getParent().getId().toString());
                    }
                }
                if (ids.size() <= 0) continue;
                this._syncBeStatus(ctx, ids);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"\u63d0\u4ea4\u94f6\u4f01\u65f6\uff0c\u540c\u6b65\u72b6\u6001\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil(ctx);
        for (String accNo : accNoMap.keySet()) {
            logger.error((Object)("accNoMap KEY \u4e3a " + accNo));
            BigDecimal totalAmount = BigDecimal.ZERO;
            List infoList = (List)accNoMap.get(accNo);
            for (ReceivableBillInfo entry : infoList) {
                BigDecimal amt = BigDecimal.ZERO;
                amt = amtMap.containsKey(entry.getId().toString()) ? (BigDecimal)amtMap.get(entry.getId().toString()) : entry.getBillAmt();
                totalAmount = totalAmount.add(amt);
            }
            this.doCommitBE(ctx, recOpUtil, accNo, totalAmount, infoList, info);
        }
    }

    private void doCommitBE(Context ctx, NoteReceivableOpUtil recOpUtil, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, EndorsementBillInfo info) throws BOSException, EASBizException {
        logger.error((Object)"begin to commitToBE EndorsementBillInfo");
        try {
            EndorsementBillEntryCollection entry = info.getEntrys();
            HashMap<String, EndorsementBillEntryInfo> entryMap = new HashMap<String, EndorsementBillEntryInfo>();
            for (int i = 0; i < entry.size(); ++i) {
                entryMap.put(entry.get(i).getReceivableBill().getId().toString(), entry.get(i));
            }
            this.beforeProcess(ctx, info.isIsCommitToBE(), infoList, entryMap);
            NoteReceivableBody body = this.parseEndorsementBody(ctx, totalAmount, infoList, info, entryMap);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.ENDORSEMENT_BILL);
            NoteReceivableDetail[] detail = recOpUtil.noteRecOp(ctx, bizInfo, body);
            info.setIsCommitToBE(true);
            this.updatePartial(ctx, (CoreBaseInfo)info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBE"}));
            info = this.getEndorsementBillInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), this.getSic());
            this.afterProcess(ctx, info, infoList, detail);
        }
        catch (BEException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception(ctx, info.getReceivableEntrys());
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception(ctx, info.getReceivableEntrys());
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception(ctx, info.getReceivableEntrys());
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                logger.error((Object)("---------" + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"BEanalysisException") + "--------------------"));
                logger.error((Object)err);
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void afterProcess(Context ctx, EndorsementBillInfo endorsementInfo, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        ReceivableBillCollection coll = new ReceivableBillCollection();
        CoreBaseCollection endorsementColl = new CoreBaseCollection();
        HashSet<String> idSet = new HashSet<String>();
        int count = infoList.size();
        for (int i = 0; i < count; ++i) {
            idSet.add(infoList.get(i).getId().toString());
        }
        logger.error((Object)(" \u66f4\u65b0\u5e94\u6536\u7968\u636e:\u94f6\u884c\u8fd4\u56de\u72b6\u6001 infoList.size() = " + infoList.size() + "   details.size() = " + details.length));
        boolean isSplit = false;
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (int i = 0; i < endorsementInfo.getEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(endorsementInfo.getEntrys().get(i).getReceivableBill().getId()));
            EndorsementBillEntryInfo endorsementBillEntryInfo = endorsementInfo.getEntrys().get(i);
            if (idSet != null && !idSet.contains(endorsementBillEntryInfo.getReceivableBill().getId().toString()) || endorsementBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) continue;
            String detailSeqID = endorsementBillEntryInfo.getDetailSeqID();
            if (EmptyUtil.isEmpty((String)detailSeqID)) {
                detailSeqID = recInfo.getDetailSeqID();
            }
            logger.error((Object)"\u521d\u59cb\u5316maxSeq=0");
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (detailSeqID == null || !detailSeqID.equals(detail.getDetailSeqID())) continue;
                if (!EmptyUtil.isEmpty((String)detail.getKeepFlag()) && detail.getKeepFlag().contains("endNo") && !recInfo.getBillState().equals((Object)BillStateEnum.OUTENDORSED)) {
                    BigDecimal endNo = null;
                    String[] strArr = detail.getKeepFlag().split(";");
                    for (int a = 0; a < strArr.length; ++a) {
                        String returnValue = strArr[a].trim();
                        if (!returnValue.toUpperCase().startsWith("endNo=".toUpperCase())) continue;
                        endNo = TypeConversionUtils.objToBigDecimal((Object)returnValue.substring("endNo=".length()));
                    }
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)recInfo.getEndorseBill())) {
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)recInfo.getEndorseBill().getId().toString()));
                        view.setFilter(filter);
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("entrys.*"));
                        sic.add(new SelectorItemInfo("id"));
                        view.setSelector(sic);
                        EndorsementBillCollection ecoll = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillCollection(view);
                        if (!EmptyUtil.isEmpty((AbstractObjectCollection)ecoll) && ecoll.size() > 0) {
                            EndorsementBillInfo endInfo = ecoll.get(0);
                            EndorsementBillEntryCollection entryColl = endInfo.getEntrys();
                            for (int a = 0; a < entryColl.size(); ++a) {
                                EndorsementBillEntryInfo entryInfo = entryColl.get(a);
                                if (!entryInfo.getReceivableBill().getId().toString().equals(recInfo.getId().toString()) || !entryInfo.isIsCommitCancel() || !entryInfo.isIsNoteCancel()) continue;
                                recInfo.setOrigEndNo(endNo);
                            }
                        }
                    }
                    recInfo = (ReceivableBillInfo)this._reverseRec(ctx, (IObjectValue)endorsementInfo, (IObjectValue)endorsementBillEntryInfo, (IObjectValue)recInfo);
                    isSplit = true;
                }
                logger.error((Object)("\u94f6\u884c\u8fd4\u56de\u72b6\u6001 = " + (Object)((Object)recInfo.getBankReturnStatus())));
                boolean returnSta = detail.getEbStatus().equals(BankReturnStatusEnum.BANK_SUCCESS.getName());
                logger.error((Object)("\u662f\u5426\u76f8\u7b49  = " + returnSta));
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_SUCCESS.getName()) && endorsementBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_SUCCESS) {
                    logger.error((Object)("\u80cc\u4e66\u64a4\u9500 \u662f\u5426\u6210\u529f detail.getReservedFiled2() = " + detail.getReservedFiled2()));
                    if ("note_cancle".equals(detail.getReservedFiled2())) {
                        this.setNoteCancelSign(ctx, endorsementInfo, recInfo, i, true);
                    } else {
                        this.addEndorseListInfo(ctx, coreColl, recInfo);
                    }
                }
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName()) && !"note_cancle".equals(detail.getReservedFiled2())) {
                    this.setNoteCancelSign(ctx, endorsementInfo, recInfo, i, false);
                }
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName()) && endorsementInfo.getEntrys().get(i).isIsCommitCancel()) {
                    endorsementInfo.getEntrys().get(i).setIsCommitCancel(false);
                }
                if (recInfo.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                    ElecBillStatusEnum elecBillStatusEnum = null;
                    elecBillStatusEnum = endorsementBillEntryInfo.isIsCommitCancel() ? BillServerUtil.setElecBillStatus("endorse_Cancle", recInfo, detail) : BillServerUtil.setElecBillStatus("endorse", recInfo, detail);
                    if (!EmptyUtil.isEmpty((Object)((Object)elecBillStatusEnum))) {
                        endorsementBillEntryInfo.setElecBillStatus(elecBillStatusEnum);
                    }
                    BillServerUtil.setStartAndEndNo(ctx, detail.getKeepFlag(), detail.getEbStatus(), recInfo);
                    endorsementBillEntryInfo.setReserveds(detail.getKeepFlag());
                } else if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                    endorsementBillEntryInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                }
                endorsementBillEntryInfo.setBankReturnMsg(detail.getBankStatusMsg());
                endorsementBillEntryInfo.setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
                logger.error((Object)("\u80cc\u4e66\u5355\u540c\u6b65\u72b6\u6001  detail.getReservedFiled1() = " + detail.getReservedFiled1()));
                recInfo.setBeColumn(detail.getReservedFiled1());
                recColl.add((CoreBaseInfo)recInfo);
                coll.add(recInfo);
            }
        }
        if (recColl != null && recColl.size() > 0) {
            if (isSplit && !EmptyUtil.isEmpty((String)endorsementInfo.getLinkbillId()) && BOSUuid.read((String)endorsementInfo.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                String billNumber = "";
                for (int i = 0; i < endorsementInfo.getEntrys().size(); ++i) {
                    ReceivableBillInfo recInfo = endorsementInfo.getEntrys().get(i).getReceivableBill();
                    billNumber = billNumber.length() > 0 ? billNumber + ";" + recInfo.getDraftNumber() : recInfo.getDraftNumber();
                }
                if (billNumber != null && billNumber.length() > 2000) {
                    billNumber = billNumber.substring(0, 2000);
                }
                DbUtil.execute((Context)ctx, (String)"update T_CAS_PaymentBill set FSettlementNumber = ? where FId=?", (Object[])new Object[]{billNumber, endorsementInfo.getLinkbillId()});
            }
            if (endorsementInfo.getNoteBillNumber().length() > 75) {
                endorsementInfo.setNoteBillNumber(endorsementInfo.getNoteBillNumber().substring(0, 75));
            }
            endorsementColl.add((CoreBaseInfo)endorsementInfo);
            EndorsementBillFactory.getLocalInstance(ctx).updateBatchData(endorsementColl);
            logger.error((Object)("\u80cc\u4e66\u8054\u7684\u6570\u91cf coreColl.size() = " + coreColl.size()));
            if (coreColl.size() > 0) {
                IObjectPK[] addnewBatchData = EndorseListingFactory.getLocalInstance(ctx).addnewBatchData(coreColl);
                logger.error((Object)("\u80cc\u4e66\u8054\u7684\u6570\u91cf\uff1a " + coreColl.size() + "\u6210\u529f\u63d0\u4ea4\u6570\u636e\u5e93\u7684\u6570\u91cf \uff1a " + addnewBatchData.length));
            }
            ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recColl);
            BillServerUtil.updateBizBillSettle(ctx, recColl);
            NTPHelper.addBillTransLogByColl(ctx, coll, BillTransBizType.ENDORSE_TOBE);
        }
    }

    @Override
    protected IObjectValue _reverseRec(Context ctx, IObjectValue model, IObjectValue endorsementBillEntryInfo, IObjectValue recInfo) throws BOSException, EASBizException {
        BillStateEnum endorse_state;
        EndorsementBillInfo eInfo = (EndorsementBillInfo)model;
        EndorsementBillEntryInfo entInfo = (EndorsementBillEntryInfo)endorsementBillEntryInfo;
        ReceivableBillInfo rInfo = (ReceivableBillInfo)recInfo;
        if (rInfo.getBillState().equals((Object)BillStateEnum.OUTENDORSED)) {
            return recInfo;
        }
        if (!(EmptyUtil.isEmpty((Object)entInfo.getEndorseAmt()) || BigDecimal.ZERO.compareTo(rInfo.getAvailableAmt()) <= 0 && BigDecimal.ZERO.compareTo(rInfo.getAvailableAmt()) == 0 && rInfo.getLockAmt().compareTo(entInfo.getEndorseAmt()) == 0)) {
            eInfo.getReceivableEntrys().remove(rInfo);
            ReceivableBillInfo splitInfoA = (ReceivableBillInfo)rInfo.clone();
            ReceivableBillInfo splitInfoB = (ReceivableBillInfo)rInfo.clone();
            this.splitReceivableBill(ctx, entInfo.getEndorseAmt(), rInfo, splitInfoA, splitInfoB, eInfo);
            splitInfoA.setEndorseBill(eInfo);
            recInfo = splitInfoA;
            eInfo.getReceivableEntrys().add(splitInfoA);
            entInfo.setReceivableBill(splitInfoA);
            DbUtil.execute((Context)ctx, (String)"update t_bot_relation set FSRCOBJECTID = ? where FSRCOBJECTID=? and FDESTOBJECTID = ?", (Object[])new Object[]{splitInfoA.getId().toString(), splitInfoB.getId().toString(), eInfo.getId().toString()});
            if (!EmptyUtil.isEmpty((String)eInfo.getLinkbillId()) && BOSUuid.read((String)eInfo.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                DbUtil.execute((Context)ctx, (String)"update T_FM_ReceivableBillEntry set FReceivableBillID = ?,FReceivableBillNum = ? where FBillID = ? and FReceivableBillID = ?", (Object[])new Object[]{splitInfoA.getId().toString(), splitInfoA.getDraftNumber(), eInfo.getLinkbillId(), splitInfoB.getId().toString()});
            }
        } else {
            eInfo.getReceivableEntrys().remove(rInfo);
            rInfo.setEndorseBill(eInfo);
            eInfo.getReceivableEntrys().add(rInfo);
            entInfo.setReceivableBill(rInfo);
        }
        String noteDesc = null;
        boolean isAudit = this.getSysParam(ctx, "NT019", eInfo.getCompany());
        if (eInfo.getBillType() == EndorsementTypeEnum.IN) {
            BOSUuid endorsedCompanyId = eInfo.getEndorsedCompany().getId();
            CompanyOrgUnitInfo endorsedCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(endorsedCompanyId));
            noteDesc = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.app.EndorseServerResource", (String)"InEndorseNoteBillDescTemplete", (Locale)ctx.getLocale()) + endorsedCompanyInfo.getName();
            endorse_state = BillStateEnum.INENDORSED;
        } else if (eInfo.getBillType() == EndorsementTypeEnum.OUT) {
            String suppName = eInfo.getEndorsee();
            noteDesc = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.app.EndorseServerResource", (String)"OutEndorseNoteBillDescTemplete", (Locale)ctx.getLocale()) + suppName;
            endorse_state = BillStateEnum.OUTENDORSED;
        } else {
            throw new AssertionError();
        }
        ReceivableBillCollection coll = eInfo.getReceivableEntrys();
        IReceivableBill irecBill = ReceivableBillFactory.getLocalInstance(ctx);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
            recvBillInfo.setBillState(endorse_state);
            recvBillInfo.setDigest(noteDesc);
            recvBillInfo.setTransferDate(eInfo.getEndorseDate());
            recvBillInfo.setEndorseBill(eInfo);
            recvBillInfo.setAvailableAmt(BigDecimal.ZERO);
            recvBillInfo.setLockAmt(BigDecimal.ZERO);
            irecBill.update((IObjectPK)new ObjectUuidPK(recvBillInfo.getId().toString()), (CoreBaseInfo)recvBillInfo);
            recvBillInfo.setOprtLogDate(eInfo.getEndorseDate());
            if (!eInfo.isEdit()) {
                NTHelper.writOprtLog(ctx, (IObjectValue)recvBillInfo, recvBillInfo.getId().toString(), OprtEnum.ENDORSE, OprtEnum.SAVE);
                continue;
            }
            NTHelper.writOprtLog(ctx, (IObjectValue)recvBillInfo, recvBillInfo.getId().toString(), OprtEnum.ENDORSE, OprtEnum.ENDORSE);
        }
        return recInfo;
    }

    private int addEndorseListInfo(Context ctx, CoreBaseCollection coreColl, ReceivableBillInfo recInfo) throws BOSException {
        EndorseListingCollection endorseListColl = new EndorseListingCollection();
        int maxSeq = 0;
        EndorseListingInfo endorseListInfo = new EndorseListingInfo();
        logger.error((Object)("\u5e94\u6536\u7968\u636e\u5173\u8054\u7684\u80cc\u4e66\u5355\u7684\u80cc\u4e66\u65e5\u671f = " + recInfo.getEndorseBill().getEndorseDate()));
        logger.error((Object)(" \u80cc\u4e66\u4eba = " + recInfo.getCompany().toString()));
        logger.error((Object)(" \u88ab\u80cc\u4e66\u4eba(\u5185\u90e8\u516c\u53f8\uff09 " + recInfo.getEndorseBill().getEndorsedCompany()));
        logger.error((Object)(" \u88ab\u80cc\u4e66\u4eba\uff08\u4f9b\u5e94\u5546\uff09 " + recInfo.getEndorseBill().getEndorsedSupplier()));
        logger.error((Object)(" \u88ab\u80cc\u4e66\u4eba\uff08\u5ba2\u6237\uff09 " + recInfo.getEndorseBill().getEndorsedCustomer()));
        logger.error((Object)(" \u662f\u5426\u5141\u8bb8\u8f6c\u8ba9 = " + recInfo.getEndorseBill().isIsTransfer()));
        endorseListInfo.setEndorseDate(recInfo.getEndorseBill().getEndorseDate());
        endorseListInfo.setEndorser(recInfo.getCompany().toString());
        if (recInfo.getEndorseBill().getEndorsedCompany() != null) {
            endorseListInfo.setEndorsee(recInfo.getEndorseBill().getEndorsedCompany().getName().toString());
        } else if (recInfo.getEndorseBill().getEndorsedSupplier() != null) {
            endorseListInfo.setEndorsee(recInfo.getEndorseBill().getEndorsedSupplier().getName().toString());
        } else if (recInfo.getEndorseBill().getEndorsedCustomer() != null) {
            endorseListInfo.setEndorsee(recInfo.getEndorseBill().getEndorsedCustomer().getName().toString());
        }
        if (EmptyUtil.isEmpty((String)endorseListInfo.getEndorsee())) {
            endorseListInfo.setEndorsee(recInfo.getEndorseBill().getEndorsee());
        }
        endorseListInfo.setTransferFlag(recInfo.getEndorseBill().isIsTransfer());
        endorseListInfo.setHead(recInfo);
        endorseListInfo.setBusinessCode("\u8f6c\u8ba9\u80cc\u4e66-\u5e94\u6536\u751f\u6210\u80cc\u4e66" + new Timestamp(System.currentTimeMillis()));
        coreColl.add((CoreBaseInfo)endorseListInfo);
        logger.error((Object)("recInfo.getEndorseListColl() = " + (Object)((Object)recInfo.getEndorseListColl()) + ", recInfo.getId() = " + recInfo.getId()));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("head", (Object)recInfo.getId().toString()));
        view.setSelector(sic);
        view.setFilter(filterInfo);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo seqSort = new SorterItemInfo("Seq");
        seqSort.setSortType(SortType.DESCEND);
        sortColl.add(seqSort);
        view.setSorter(sortColl);
        EndorseListingCollection endorseListingCollection = EndorseListingFactory.getLocalInstance(ctx).getEndorseListingCollection(view);
        if (endorseListingCollection.size() == 0) {
            maxSeq = 0;
            endorseListInfo.setSeq(maxSeq);
            endorseListColl.add(endorseListInfo);
            recInfo.setEndorseListColl(endorseListColl);
        } else if (endorseListingCollection.size() > 0) {
            logger.error((Object)("recInfo.getId() = " + recInfo.getId() + "\u80cc\u4e66\u5355\u540c\u6b65\u72b6\u6001\u53cd\u5199\u5e94\u6536\u7968\u636e\u80cc\u4e66\u8054\uff1a \u80cc\u4e66\u8054\u6570\u91cf endorseListingCollection.size()  = " + endorseListingCollection.size()));
            maxSeq = endorseListingCollection.get(0).getSeq() + 1;
            endorseListInfo.setSeq(maxSeq);
            recInfo.getEndorseListColl().add(endorseListInfo);
        }
        return maxSeq;
    }

    private void setNoteCancelSign(Context ctx, EndorsementBillInfo endorsementInfo, ReceivableBillInfo recInfo, int i, boolean isnotecancel) {
        boolean isPartialEnd;
        if (isnotecancel) {
            endorsementInfo.getEntrys().get(i).setIsNoteCancel(true);
        }
        EndorsementBillEntryInfo eInf = endorsementInfo.getEntrys().get(i);
        boolean bl = isPartialEnd = !recInfo.getBillState().equals((Object)BillStateEnum.OUTENDORSED);
        if (!EmptyUtil.isEmpty((Object)eInf.getEndorseAmt()) && eInf.getEndorseAmt().compareTo(BigDecimal.ZERO) > 0) {
            if (!EmptyUtil.isEmpty((String)endorsementInfo.getLinkbillId()) && BOSUuid.read((String)endorsementInfo.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                if (!isPartialEnd) {
                    recInfo.setLockAmt(eInf.getEndorseAmt());
                }
            } else if (isPartialEnd) {
                recInfo.setLockAmt(recInfo.getLockAmt().subtract(eInf.getEndorseAmt()));
                recInfo.setAvailableAmt(recInfo.getAvailableAmt().add(eInf.getEndorseAmt()));
            } else {
                recInfo.setAvailableAmt(recInfo.getAvailableAmt().add(eInf.getEndorseAmt()));
            }
        }
        if (!isPartialEnd) {
            recInfo.setIsNoteCancel(true);
            recInfo.setDigest(null);
            recInfo.setTransferDate(null);
            boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()));
            if (NT011) {
                recInfo.setBillState(BillStateEnum.Audit);
            } else {
                recInfo.setBillState(BillStateEnum.SAVED);
            }
            endorsementInfo.getEntrys().get(i).setReceivableBill(recInfo);
            ReceivableBillCollection rcoll = endorsementInfo.getReceivableEntrys();
            for (int a = 0; a < rcoll.size(); ++a) {
                ReceivableBillInfo info = rcoll.get(a);
                if (!info.getId().toString().equals(recInfo.getId().toString())) continue;
                rcoll.remove(info);
                rcoll.add(recInfo);
            }
        }
    }

    private void afterProcessNoteCancel(Context ctx, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        ReceivableBillCollection coll = new ReceivableBillCollection();
        logger.error((Object)("\u80cc\u4e66\u5355\u8f6c\u8ba9\u64a4\u9500\uff0c\u66f4\u65b0\u5e94\u6536\u7968\u636e:\u94f6\u884c\u8fd4\u56de\u72b6\u6001  infoList.size() = " + infoList.size() + "   details.size() = " + details.length));
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo recInfo = infoList.get(i);
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                recInfo.setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
                logger.error((Object)("\u94f6\u884c\u8fd4\u56de\u72b6\u6001  = " + (Object)((Object)recInfo.getBankReturnStatus()) + "recInfo.getCompany()= " + recInfo.getCompany()));
                boolean issucc = recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS;
                logger.error((Object)("recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS " + issucc));
                if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()));
                    if (NT011) {
                        recInfo.setBillState(BillStateEnum.Audit);
                    } else {
                        recInfo.setBillState(BillStateEnum.SAVED);
                    }
                }
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                }
                recInfo.setBankReturnMsg(detail.getBankStatusMsg());
            }
            recColl.add((CoreBaseInfo)recInfo);
            coll.add(recInfo);
        }
        ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recColl);
        NTPHelper.addBillTransLogByColl(ctx, coll, BillTransBizType.ENDORSE_CANCEL);
    }

    private void beforeProcess(Context ctx, boolean isCommitBE, List<ReceivableBillInfo> infoList, Map entryMap) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
        CoreBaseCollection entCollection = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            logger.error((Object)"\u5f00\u59cb\u66f4\u65b0\u5e94\u6536\u7968\u636eDetailSeqID");
            ReceivableBillInfo info = infoList.get(i);
            logger.error((Object)("\u5e94\u6536\u7968\u636eID" + info.getId().toString()));
            EndorsementBillEntryInfo eInfo = (EndorsementBillEntryInfo)entryMap.get(info.getId().toString());
            eInfo.setDetailSeqID(serialNos[i]);
            logger.error((Object)("\u66f4\u65b0\u5e94\u6536\u7968\u636eDetailSeqID\u4e3a" + serialNos[i]));
            eInfo.setBatchSeqID(serialNos[0]);
            if (isCommitBE && eInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                eInfo.setBankReturnStatus(null);
                eInfo.setBankReturnMsg(null);
            }
            entCollection.add((CoreBaseInfo)eInfo);
        }
        EndorsementBillEntryFactory.getLocalInstance(ctx).updateBatchData(entCollection);
    }

    private NoteReceivableBody parseEndorsementBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, EndorsementBillInfo info, Map entryMap) {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = ((EndorsementBillEntryInfo)entryMap.get(infoList.get(0).getId().toString())).getBatchSeqID();
        if (EmptyUtil.isEmpty((String)seqID)) {
            seqID = infoList.get(0).getBatchSeqID();
        }
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseEndorsementDetail(ctx, infoList, info, entryMap));
        return body;
    }

    private NoteReceivableDetail[] parseEndorsementDetail(Context ctx, List<ReceivableBillInfo> infoList, EndorsementBillInfo info, Map entryMap) {
        NoteReceivableDetail[] details = new NoteReceivableDetail[infoList.size()];
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo entry = infoList.get(i);
            NoteReceivableDetail detail = new NoteReceivableDetail();
            detail.setReservedFiled1(entry.getDrawerName() + "|" + entry.getDrawerAccountName() + "|" + entry.getDrawerBankName());
            logger.error((Object)("DrawerName = " + entry.getDrawerName() + "DrawerAccountName = " + entry.getDrawerAccountName() + "DrawerBankName = " + entry.getDrawerBankName()));
            logger.error((Object)("detail.getReservedFiled1() = " + detail.getReservedFiled1()));
            String seqID = ((EndorsementBillEntryInfo)entryMap.get(infoList.get(i).getId().toString())).getDetailSeqID();
            if (!EmptyUtil.isEmpty((String)seqID)) {
                detail.setDetailSeqID(seqID);
                detail.setDetailBizNo(seqID);
            } else {
                detail.setDetailSeqID(entry.getDetailSeqID());
                detail.setDetailBizNo(entry.getDetailSeqID());
            }
            detail.setOppAccName(info.getEndorsee());
            detail.setOppAccNo(info.getEndorseeAccountName());
            detail.setOppBankName(info.getEndorseeBankName() != null ? info.getEndorseeBankName() : (info.getEndorseeBank() != null ? info.getEndorseeBank().getName() : ""));
            detail.setOppCnapsCode(info.getEndorseeBankNum());
            if (info.getEndorseeBank() != null) {
                detail.setOppProvince(info.getEndorseeBank().getBeProvince());
                detail.setOppCity(info.getEndorseeBank().getBeCity());
            }
            detail.setOppAmount(((EndorsementBillEntryInfo)entryMap.get(entry.getId().toString())).getEndorseAmt().setScale(2, 4).toString());
            detail.setBillNo(entry.getDraftPackageNumber());
            detail.setDraftType(entry.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept) ? "AC01" : "AC02");
            detail.setTransferFlag(info.isIsTransfer() ? "EM00" : "EM01");
            detail.setIssueDate(DraftBEUtil.date2String(entry.getIssuesDate(), "yyyyMMdd"));
            detail.setDueDate(DraftBEUtil.date2String(entry.getExpiredDate(), "yyyyMMdd"));
            detail.setDesc(info.getDescription());
            detail.setThirdAccName("");
            detail.setThirdAccNo("");
            detail.setThirdBankName("");
            detail.setThirdCnapCode("");
            detail.setThirdBankAddr("");
            detail.setThirdCity("");
            detail.setThirdProvince("");
            detail.setThirdCountry("");
            if (entry.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                BillServerUtil.setKeepFlag(detail, entry);
                String bankRefKey = BillServerUtil.getBankRefKey(ctx, entry);
                detail.setKeepFlag(detail.getKeepFlag() + ";bankRefKey=" + bankRefKey);
            }
            details[i] = detail;
        }
        return details;
    }

    private boolean isCommitBE(Context ctx, EndorsementBillInfo info) {
        boolean isCommitBE = false;
        boolean isAudit = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT019", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        if (isAudit) {
            if (info.getState() == EndorseStateEnum.Audited) {
                isCommitBE = true;
            }
        } else if (info.getState() == EndorseStateEnum.Submit) {
            isCommitBE = true;
        }
        return isCommitBE;
    }

    @Override
    protected Map _syncBeStatus(Context ctx, Set ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{ids.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.number"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorseDate"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.company.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedSupplier.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCustomer.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.isTransfer"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.cu.id"));
        sic.add(new SelectorItemInfo("entrys.cu.id"));
        sic.add(new SelectorItemInfo("entrys.company.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.company.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("endorsedCompany.*"));
        sic.add(new SelectorItemInfo("endorsedSupplier.*"));
        sic.add(new SelectorItemInfo("endorsedCustomer.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.cu.id"));
        view.setSelector(sic);
        int success = 0;
        EndorsementBillCollection colls = this.getEndorsementBillCollection(ctx, view);
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil(ctx);
        for (int i = 0; i < colls.size(); ++i) {
            EndorsementBillInfo info = colls.get(i);
            try {
                if (!info.isIsCommitToBE()) {
                    throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS"));
                }
                TreeMap<String, List<ReceivableBillInfo>> batchSeqMap = new TreeMap<String, List<ReceivableBillInfo>>();
                HashMap<String, EndorsementBillEntryInfo> map = new HashMap<String, EndorsementBillEntryInfo>();
                for (int j = 0; j < info.getEntrys().size(); ++j) {
                    EndorsementBillEntryInfo endorsementBillEntryInfo = info.getEntrys().get(j);
                    ReceivableBillInfo entry = info.getEntrys().get(j).getReceivableBill();
                    String batchSeqID = info.getEntrys().get(j).getBatchSeqID();
                    if (EmptyUtil.isEmpty((String)batchSeqID)) {
                        batchSeqID = entry.getBatchSeqID();
                    } else {
                        map.put(entry.getId().toString(), info.getEntrys().get(j));
                    }
                    if (EmptyUtil.isEmpty((String)batchSeqID) || endorsementBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"071_COMMITFAIL_CANNOT_SYNCSTATUS"));
                    }
                    ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                this.doSyncStatus(ctx, info, recOpUtil, batchSeqMap, map);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doSyncStatus(Context ctx, EndorsementBillInfo endorseInfo, NoteReceivableOpUtil recOpUtil, Map<String, List<ReceivableBillInfo>> batchSeqMap, Map map) throws EASBizException, BOSException {
        for (String key : batchSeqMap.keySet()) {
            List<ReceivableBillInfo> infoList = batchSeqMap.get(key);
            NoteReceivableDetail[] details = this.queryRec(ctx, recOpUtil, infoList, map);
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess(ctx, endorseInfo, infoList, details);
        }
    }

    private void cancelPay(Context ctx, EndorsementBillInfo endorsementInfo) throws EASBizException, BOSException {
        boolean isCancelPay = this.isCancelPay(ctx, endorsementInfo);
        List<String> billIdList = EndorsementBillControllerBean.getRelateBills(ctx, endorsementInfo.getId().toString());
        ArrayList<String> settleIds = new ArrayList<String>();
        HashSet<String> payIds = new HashSet<String>();
        if (billIdList.size() >= 1) {
            for (int i = 0; i < billIdList.size(); ++i) {
                String id = billIdList.get(i);
                String bosType = BOSUuid.read((String)id).getType().toString();
                if (bosType.equals(new PaymentBillInfo().getBOSType().toString())) {
                    payIds.add(id);
                    continue;
                }
                if (!bosType.equals(new SettlementBillInfo().getBOSType().toString())) continue;
                settleIds.add(id);
            }
            if (settleIds.size() >= 1) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FLINKBILLID = '' where FId=?", (Object[])new Object[]{endorsementInfo.getId().toString()});
                BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationBySrcObjId(endorsementInfo.getLinkbillId(), endorsementInfo.getBOSType().toString());
                Set settleIdSet = FMHelper.list2Set(settleIds);
                String sql = "UPDATE t_fs_settlementbill SET FBITBACKADVICE = '\u80cc\u4e66\u5355\u63d0\u4ea4\u94f6\u4f01\u5931\u8d25\uff01'  WHERE FID in " + FMHelper.setTran2String((Set)settleIdSet);
                DbUtil.execute((Context)ctx, (String)sql);
                try {
                    SettleFacadeFactory.getLocalInstance((Context)ctx).unSettle(settleIds);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (payIds.size() >= 1) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FLINKBILLID = '' where FId=?", (Object[])new Object[]{endorsementInfo.getId().toString()});
                BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationBySrcObjId(endorsementInfo.getLinkbillId(), endorsementInfo.getBOSType().toString());
                String sql = "UPDATE T_CAS_PaymentBill SET FCONCEIT = '\u80cc\u4e66\u5355\u63d0\u4ea4\u94f6\u4f01\u5931\u8d25\uff01'  WHERE FID in " + FMHelper.setTran2String(payIds);
                DbUtil.execute((Context)ctx, (String)sql);
                try {
                    PaymentBillFactory.getLocalInstance((Context)ctx).cancelPay(payIds);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (payIds.size() >= 1 || settleIds.size() >= 1) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_EndorsementBill set FIsBitBack=1 where FId=?", (Object[])new Object[]{endorsementInfo.getId().toString()});
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"488_EndorsementBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
    }

    private static List<String> getRelateBills(Context ctx, String billInfoID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)billInfoID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        ArrayList<String> relateBills = new ArrayList<String>();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    relateBills.add(rs.getString("srcObjectID"));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return relateBills;
    }

    private boolean isCancelPay(Context ctx, EndorsementBillInfo endorsementInfo) {
        boolean isCancelPay = true;
        for (int i = 0; i < endorsementInfo.getEntrys().size(); ++i) {
            EndorsementBillEntryInfo endorsementBillEntryInfo = endorsementInfo.getEntrys().get(i);
            if (endorsementBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL || endorsementBillEntryInfo.isIsNoteCancel()) continue;
            isCancelPay = false;
        }
        return isCancelPay;
    }

    private void doSyncForceStatus(Context ctx, EndorsementBillInfo endorseInfo, NoteReceivableOpUtil recOpUtil, Map<String, List<ReceivableBillInfo>> batchSeqMap) throws EASBizException, BOSException {
        for (String key : batchSeqMap.keySet()) {
            List<ReceivableBillInfo> infoList = batchSeqMap.get(key);
            NoteReceivableDetail[] details = this.queryForceRec(ctx, recOpUtil, infoList);
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess(ctx, endorseInfo, infoList, details);
        }
    }

    private NoteReceivableDetail[] queryForceRec(Context ctx, NoteReceivableOpUtil recOpUtil, List<ReceivableBillInfo> infoList) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(infoList.get(0).getBatchSeqID());
        body.setReserved1("enforcequery");
        String accNo = infoList.get(0).getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryNoteReceivable(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    private NoteReceivableDetail[] queryRec(Context ctx, NoteReceivableOpUtil recOpUtil, List<ReceivableBillInfo> infoList, Map map) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        if (map.containsKey(infoList.get(0).getId().toString())) {
            body.setBatchSeqID(((EndorsementBillEntryInfo)map.get(infoList.get(0).getId().toString())).getBatchSeqID());
        } else {
            body.setBatchSeqID(infoList.get(0).getBatchSeqID());
        }
        String accNo = infoList.get(0).getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryNoteReceivable(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    @Override
    protected void _updateBeStatus(Context ctx, List statusList) throws BOSException, EASBizException {
        int i;
        EndorsementBillInfo info;
        ArrayList<ReceivableBillInfo> updateList = new ArrayList<ReceivableBillInfo>();
        Map listmap = (Map)statusList.get(0);
        String recId = (String)listmap.get("id");
        ReceivableBillInfo recInfo = this.getRecInfoById(ctx, recId);
        HashMap<String, EndorsementBillEntryInfo> entryMap = new HashMap<String, EndorsementBillEntryInfo>();
        if (recInfo != null && recInfo.getEndorseBill() != null) {
            info = this.getEndorInfoById(ctx, recInfo.getEndorseBill().getId().toString());
            EndorsementBillEntryCollection coll = info.getEntrys();
            for (i = 0; i < coll.size(); ++i) {
                entryMap.put(coll.get(i).getReceivableBill().getId().toString(), coll.get(i));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"489_EndorsementBillControllerBean", (Locale)ctx.getLocale()));
        }
        EndorsementBillEntryInfo entryInfo = new EndorsementBillEntryInfo();
        for (i = 0; i < statusList.size(); ++i) {
            Map StatusMap = (Map)statusList.get(i);
            String id = (String)StatusMap.get("id");
            if (!entryMap.containsKey(id)) continue;
            entryInfo = (EndorsementBillEntryInfo)entryMap.get(id);
            if (entryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) {
                throw new BEException(BEException.UPDATESTATEERROR1);
            }
            entryInfo.getReceivableBill().setBankReturnStatus((BankReturnStatusEnum)((Object)StatusMap.get("bankReturnStatus")));
            updateList.add(entryInfo.getReceivableBill());
        }
        logger.debug((Object)"begin to updateBeStatus EndorsementBillInfo");
        HashMap<String, EndorsementBillEntryInfo> map = new HashMap<String, EndorsementBillEntryInfo>();
        map.put(recInfo.getId().toString(), entryInfo);
        NoteUpdateStautsUtil util = new NoteUpdateStautsUtil();
        NoteStatusBody body = new NoteStatusBody();
        body.setTotalCount(String.valueOf(updateList.size()));
        body.setDetails(this.parseUpdteDetail(ctx, updateList, map));
        try {
            NoteStatusDetail[] details = util.updateNoteStatus(ctx, null, body);
            this.afterProcess4Update(ctx, info, updateList, details);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err.toString());
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private ReceivableBillInfo getRecInfoById(Context ctx, String recId) throws BOSException, EASBizException {
        SelectorItemCollection recsic = new SelectorItemCollection();
        recsic.add(new SelectorItemInfo("endorseBill.id"));
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance(ctx);
        ReceivableBillInfo recInfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(recId), recsic);
        return recInfo;
    }

    private EndorsementBillInfo getEndorInfoById(Context ctx, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.detailSeqID"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.batchSeqID"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.bankReturnStatus"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.bankReturnMsg"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.elecBillStatus"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.company.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.billstate"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.isNoteCancel"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.getEndorsedSupplier.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        EndorsementBillCollection coll = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillCollection(view);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private void afterProcess4Update(Context ctx, EndorsementBillInfo endorsementInfo, List<ReceivableBillInfo> updateList, NoteStatusDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        ReceivableBillCollection coll = new ReceivableBillCollection();
        CoreBaseCollection endorsementColl = new CoreBaseCollection();
        HashSet<String> idSet = new HashSet<String>();
        int count = updateList.size();
        for (int i = 0; i < count; ++i) {
            idSet.add(updateList.get(i).getId().toString());
        }
        logger.error((Object)(" \u66f4\u65b0\u5e94\u6536\u7968\u636e:\u94f6\u884c\u8fd4\u56de\u72b6\u6001 infoList.size() = " + updateList.size() + "   details.size() = " + details.length));
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (int i = 0; i < endorsementInfo.getEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = endorsementInfo.getEntrys().get(i).getReceivableBill();
            EndorsementBillEntryInfo endorsementBillEntryInfo = endorsementInfo.getEntrys().get(i);
            if (idSet != null && !idSet.contains(endorsementBillEntryInfo.getReceivableBill().getId().toString())) continue;
            String detailSeqID = !EmptyUtil.isEmpty((String)endorsementBillEntryInfo.getDetailSeqID()) ? endorsementBillEntryInfo.getDetailSeqID() : recInfo.getDetailSeqID();
            logger.error((Object)"\u521d\u59cb\u5316maxSeq=0");
            for (int j = 0; j < details.length; ++j) {
                NoteStatusDetail detail = details[j];
                if (detailSeqID == null || !detailSeqID.equals(detail.getDetailSeqID())) continue;
                Object endorseListInfo = null;
                logger.error((Object)("\u94f6\u884c\u8fd4\u56de\u72b6\u6001 = " + (Object)((Object)recInfo.getBankReturnStatus())));
                boolean returnSta = detail.getEbStatus().equals(BankReturnStatusEnum.BANK_SUCCESS.getName());
                logger.error((Object)("\u662f\u5426\u76f8\u7b49  = " + returnSta));
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_SUCCESS.getName())) {
                    if (endorsementBillEntryInfo.isIsCommitCancel()) {
                        this.setNoteCancelSign(ctx, endorsementInfo, recInfo, i, true);
                    } else {
                        recInfo.setElecBillStatus(ElecBillStatusEnum.NT100006);
                        endorsementBillEntryInfo.setElecBillStatus(ElecBillStatusEnum.NT100006);
                        this.addEndorseListInfo(ctx, coreColl, recInfo);
                    }
                }
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName()) && !endorsementBillEntryInfo.isIsCommitCancel()) {
                    this.setNoteCancelSign(ctx, endorsementInfo, recInfo, i, false);
                } else if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName()) && endorsementBillEntryInfo.isIsCommitCancel()) {
                    endorsementBillEntryInfo.setIsCommitCancel(false);
                }
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                    endorsementBillEntryInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                }
                endorsementBillEntryInfo.setBankReturnMsg(detail.getBankStatusMsg());
                endorsementBillEntryInfo.setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
            }
            recColl.add((CoreBaseInfo)recInfo);
            coll.add(recInfo);
        }
        if (endorsementInfo.getNoteBillNumber().length() > 75) {
            endorsementInfo.setNoteBillNumber(endorsementInfo.getNoteBillNumber().substring(0, 75));
        }
        endorsementColl.add((CoreBaseInfo)endorsementInfo);
        EndorsementBillFactory.getLocalInstance(ctx).updateBatchData(endorsementColl);
        logger.error((Object)("\u80cc\u4e66\u8054\u7684\u6570\u91cf coreColl.size() = " + coreColl.size()));
        if (coreColl.size() > 0) {
            IObjectPK[] addnewBatchData = EndorseListingFactory.getLocalInstance(ctx).addnewBatchData(coreColl);
            logger.error((Object)("\u80cc\u4e66\u8054\u7684\u6570\u91cf\uff1a " + coreColl.size() + "\u6210\u529f\u63d0\u4ea4\u6570\u636e\u5e93\u7684\u6570\u91cf \uff1a " + addnewBatchData.length));
        }
        ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recColl);
        NTPHelper.addBillTransLogByColl(ctx, coll, BillTransBizType.ENDORSE_TOBE);
    }

    private NoteStatusDetail[] parseUpdteDetail(Context ctx, List<ReceivableBillInfo> updateList, Map map) {
        NoteStatusDetail[] details = new NoteStatusDetail[updateList.size()];
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            NoteStatusDetail detail = new NoteStatusDetail();
            if (map.containsKey(recInfo.getId().toString())) {
                detail.setDetailSeqID(((EndorsementBillEntryInfo)map.get(recInfo.getId().toString())).getDetailSeqID());
                detail.setBatchSeqID(((EndorsementBillEntryInfo)map.get(recInfo.getId().toString())).getBatchSeqID());
            } else {
                detail.setDetailSeqID(recInfo.getDetailSeqID());
                detail.setBatchSeqID(recInfo.getBatchSeqID());
            }
            detail.setEbStatus(recInfo.getBankReturnStatus().getName());
            detail.setEbNoteType("noteRecivable");
            detail.setUpdateReason(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"065_EDITBESTATUS_BYHAND"));
            detail.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            detail.setOrganizationName(ContextUtil.getCurrentFIUnit((Context)ctx).getName());
            details[i] = detail;
        }
        return details;
    }

    @Override
    protected int _releaseFailedBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EndorsementBillInfo oldInfo = this.getEndorsementBillInfo(ctx, pk);
        int oldEntrysCnt = oldInfo.getReceivableEntrys().size();
        List<ReceivableBillInfo> notFailList = this.getBENotFailColl(oldInfo.getReceivableEntrys());
        int notFailCnt = notFailList.size();
        if (notFailCnt == 0) {
            throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"064_CANNOT_RELEASEFAILEDBILL"));
        }
        EndorsementBillInfo newInfo = oldInfo;
        newInfo.getReceivableEntrys().clear();
        String draftNumber = "";
        BigDecimal endorseAmt = Constants.ZERO;
        for (ReceivableBillInfo notFailEntry : notFailList) {
            newInfo.getReceivableEntrys().add(notFailEntry);
            draftNumber = draftNumber + notFailEntry.getDraftNumber() + ",";
            endorseAmt = endorseAmt.add(notFailEntry.getBillAmt());
        }
        newInfo.setId(null);
        newInfo.setNoteBillNumber(draftNumber.substring(0, draftNumber.length() - 1));
        newInfo.setEndorseAmt(endorseAmt);
        newInfo.setLocalAmount(endorseAmt.multiply(newInfo.getExRate()));
        if (newInfo.getSettleEntrys() != null && newInfo.getSettleEntrys().size() > 0) {
            EndorsementSettleEntryInfo settleEntry = newInfo.getSettleEntrys().get(0);
            settleEntry.setSettleAmount(endorseAmt);
        }
        this.cancelEndorse(ctx, BOSUuid.read((String)pk.toString()), false);
        boolean isCreatePayment = !StringUtils.isEmpty((String)newInfo.getLinkbillId());
        this.createNewInfo(ctx, newInfo, isCreatePayment);
        return oldEntrysCnt - notFailCnt;
    }

    private void createNewInfo(Context ctx, EndorsementBillInfo model, boolean isCreatePayment) throws EASBizException, BOSException {
        EndorsementBillInfo element = model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)element);
        IObjectPK pk = this._submit(ctx, (IObjectValue)element);
        this.afterSubmit(ctx, element, isCreatePayment);
        element.put("id", element.getId());
        if (isCreatePayment) {
            element.getReceivableEntrys().addCollection(this.ReceivableColl);
            String s = element.getNoteBillNumber();
            if (s.length() > 80) {
                element.setNoteBillNumber(s.substring(0, 75) + "...");
            }
            NTHelper.genPaymentBillByBotp(ctx, (CoreBillBaseInfo)element, false);
        }
    }

    private List<ReceivableBillInfo> getBENotFailColl(ReceivableBillCollection coll) {
        ArrayList<ReceivableBillInfo> notFailList = new ArrayList<ReceivableBillInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (entry.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
            notFailList.add(entry);
        }
        return notFailList;
    }

    private EndorsementBillEntryCollection getEndorseBillEntryColl(Context ctx, HashSet idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("receivableBill.*"));
        sic.add(new SelectorItemInfo("receivableBill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("receivableBill.currency.*"));
        sic.add(new SelectorItemInfo("receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("receivableBill.company.*"));
        view.setSelector(sic);
        EndorsementBillEntryCollection coll = EndorsementBillEntryFactory.getLocalInstance(ctx).getEndorsementBillEntryCollection(view);
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _noteCancles(Context ctx, List billIdList, HashSet entryIdSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        int entryCount = entryIdSet.size();
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"68_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + entryCount + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"170_WageControllerBean", (Locale)ctx.getLocale());
        EndorsementBillCollection coll = this.getEndorsementBillColl(ctx, new HashSet(billIdList));
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int fail = 0;
        for (int i = 0; i < coll.size(); ++i) {
            EndorsementBillInfo info = coll.get(i);
            EndorsementBillEntryCollection entrys = info.getEntrys();
            EndorsementBillEntryCollection noteEntrys = new EndorsementBillEntryCollection();
            for (int j = 0; j < entrys.size(); ++j) {
                EndorsementBillEntryInfo entry = entrys.get(j);
                if (!entryIdSet.contains(entry.getId().toString())) continue;
                noteEntrys.add(entry);
            }
            boolean isLock = iMutex.requestObjIDForUpdate(ctx, info.getId().toString());
            try {
                this.verifyNoteCancelHead(ctx, isLock, info);
            }
            catch (Exception e) {
                fail += noteEntrys.size();
                for (int m = 0; m < noteEntrys.size(); ++m) {
                    ReceivableBillInfo receivable = noteEntrys.get(m).getReceivableBill();
                    result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"171_WageControllerBean", (Locale)ctx.getLocale()) + receivable.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"172_WageControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                }
                if (!isLock) continue;
                iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                continue;
            }
            try {
                TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
                HashMap<String, EndorsementBillEntryInfo> map = new HashMap<String, EndorsementBillEntryInfo>();
                for (int j = 0; j < noteEntrys.size(); ++j) {
                    EndorsementBillEntryInfo entry = noteEntrys.get(j);
                    ReceivableBillInfo recBill = entry.getReceivableBill();
                    try {
                        String batchSeqID = entry.getBatchSeqID();
                        if (!EmptyUtil.isEmpty((String)batchSeqID)) {
                            map.put(recBill.getId().toString(), entry);
                        }
                        this.verifyNoteCancelEntry(ctx, entry);
                    }
                    catch (Exception e) {
                        ++fail;
                        result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"171_WageControllerBean", (Locale)ctx.getLocale()) + recBill.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"172_WageControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                        entryIdSet.remove(entry.getId().toString());
                        continue;
                    }
                    String accNo = recBill.getHolderAccount().getBankAccountNumber();
                    ArrayList<ReceivableBillInfo> lst = (List)accNoMap.get(accNo);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(recBill);
                    accNoMap.put(accNo, lst);
                }
                if (accNoMap.size() == 0) continue;
                for (String accNo : accNoMap.keySet()) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    List receivableList = (List)accNoMap.get(accNo);
                    for (ReceivableBillInfo receivable : receivableList) {
                        totalAmount = totalAmount.add(receivable.getBillAmt());
                    }
                    try {
                        this.doNoteCancle(ctx, accNo, totalAmount, receivableList, info, entryIdSet, map);
                    }
                    catch (Exception e) {
                        fail += receivableList.size();
                        for (int m = 0; m < receivableList.size(); ++m) {
                            ReceivableBillInfo receivable = (ReceivableBillInfo)receivableList.get(m);
                            result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"171_WageControllerBean", (Locale)ctx.getLocale()) + receivable.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"172_WageControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                        }
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                }
            }
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"155_NoteCancle");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"156_NoteCancle", (String[])new String[]{String.valueOf(entryCount - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyNoteCancelHead(Context ctx, boolean isLock, EndorsementBillInfo info) throws NTException {
        if (!isLock) {
            throw new NTException(NTException.COMMON, new Object[]{FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI")});
        }
        if (!info.isIsCommitToBE()) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"173_WageControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void verifyNoteCancelEntry(Context ctx, EndorsementBillEntryInfo entry) throws NTException {
        if (!ElecBillStatusEnum.NT100001.equals((Object)entry.getElecBillStatus())) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"490_EndorsementBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (entry.isIsCommitCancel()) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"175_WageControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected void _noteCancle(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EndorsementBillInfo info = this.getEndorsementBillInfo(ctx, pk, this.getSic());
        TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
        HashMap<String, EndorsementBillEntryInfo> map = new HashMap<String, EndorsementBillEntryInfo>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            ReceivableBillInfo entry = info.getEntrys().get(i).getReceivableBill();
            String accNo = entry.getHolderAccount().getBankAccountNumber();
            ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
            if (lst == null) {
                lst = new ArrayList<ReceivableBillInfo>();
            }
            lst.add(entry);
            accNoMap.put(accNo, lst);
            EndorsementBillEntryInfo eInfo = info.getEntrys().get(i);
            String batchSeqID = eInfo.getBatchSeqID();
            if (EmptyUtil.isEmpty((String)batchSeqID)) continue;
            map.put(entry.getId().toString(), eInfo);
        }
        for (String accNo : accNoMap.keySet()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            List infoList = (List)accNoMap.get(accNo);
            for (ReceivableBillInfo entry : infoList) {
                totalAmount = totalAmount.add(entry.getBillAmt());
            }
            this.doNoteCancle(ctx, accNo, totalAmount, infoList, info, null, map);
        }
    }

    private void doNoteCancle(Context ctx, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, EndorsementBillInfo info, HashSet idSet, Map map) throws BOSException, EASBizException {
        logger.debug((Object)"begin to noteCancle EndorsementBillInfo");
        try {
            StringBuffer accnoarray = new StringBuffer();
            String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
            CoreBaseCollection recBillCollection = new CoreBaseCollection();
            CoreBaseCollection entryCollection = new CoreBaseCollection();
            for (int i = 0; i < infoList.size(); ++i) {
                ReceivableBillInfo receivableBillInfo = infoList.get(i);
                if (map.containsKey(receivableBillInfo.getId().toString())) {
                    EndorsementBillEntryInfo eInfo = (EndorsementBillEntryInfo)map.get(receivableBillInfo.getId().toString());
                    eInfo.setLastBatchSeq(eInfo.getBatchSeqID());
                    eInfo.setLastDetailSeq(eInfo.getDetailSeqID());
                    eInfo.setDetailSeqID(serialNos[i]);
                    eInfo.setBatchSeqID(serialNos[0]);
                    entryCollection.add((CoreBaseInfo)eInfo);
                } else {
                    receivableBillInfo.setLastBatchSeq(receivableBillInfo.getBatchSeqID());
                    receivableBillInfo.setLastDetailSeq(receivableBillInfo.getDetailSeqID());
                    receivableBillInfo.setDetailSeqID(serialNos[i]);
                    receivableBillInfo.setBatchSeqID(serialNos[0]);
                }
                if (i < infoList.size() - 1) {
                    accnoarray.append(receivableBillInfo.getDraftNumber()).append(";");
                } else {
                    accnoarray.append(receivableBillInfo.getDraftNumber());
                }
                recBillCollection.add((CoreBaseInfo)receivableBillInfo);
            }
            info.setNoteBillNumber(accnoarray.toString());
            ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recBillCollection);
            EndorsementBillEntryFactory.getLocalInstance(ctx).updateBatchData(entryCollection);
            logger.error((Object)("\u80cc\u4e66\u5355\u7684\u7968\u636e\u53f7\u7801 = " + accnoarray.toString()));
            NoteReceivableOpUtil noteReceivableOpUtil = new NoteReceivableOpUtil();
            NoteReceivableBody noteReceivableBody = this.parseNoteReceivableBody(ctx, totalAmount, infoList, info, map);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.NOTE_CANCLE);
            logger.error((Object)"\u2014\u2014\u2014\u2014\u2014\u2014before noteCancle\u2014\u2014\u2014\u2014\u2014\u2014");
            NoteReceivableDetail[] noteReceivableDetails = noteReceivableOpUtil.noteRecOp(ctx, bizInfo, noteReceivableBody);
            logger.error((Object)"\u2014\u2014\u2014\u2014\u2014\u2014end noteCancle\u2014\u2014\u2014\u2014\u2014\u2014");
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                EndorsementBillEntryInfo endorseEntry = info.getEntrys().get(i);
                if (!idSet.contains(endorseEntry.getId().toString())) continue;
                endorseEntry.setIsCommitCancel(true);
            }
            this.afterProcess(ctx, info, infoList, noteReceivableDetails);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
    }

    private NoteDetailRequestBody parseNoteDetailRequestBody(Context ctx, EndorsementBillInfo info) {
        NoteDetailRequestBody body = new NoteDetailRequestBody();
        body.setNoteNo(info.getNoteBillNumber());
        body.setTranType("10");
        body.setPageNum("1");
        return body;
    }

    private NoteReceivableBody parseNoteReceivableBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, EndorsementBillInfo info, Map map) throws NTException {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = infoList.get(0).getBatchSeqID();
        if (map.containsKey(infoList.get(0).getId().toString())) {
            seqID = ((EndorsementBillEntryInfo)map.get(infoList.get(0).getId().toString())).getBatchSeqID();
        }
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseNoteReceiableDetail(ctx, infoList, info, map));
        return body;
    }

    private NoteReceivableDetail[] parseNoteReceiableDetail(Context ctx, List<ReceivableBillInfo> infoList, EndorsementBillInfo info, Map map) throws NTException {
        NoteReceivableDetail[] details = new NoteReceivableDetail[infoList.size()];
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo recInfo = infoList.get(i);
            NoteReceivableDetail detail = new NoteReceivableDetail();
            String seqID = recInfo.getDetailSeqID();
            if (map.containsKey(recInfo.getId().toString())) {
                seqID = ((EndorsementBillEntryInfo)map.get(infoList.get(i).getId().toString())).getDetailSeqID();
            }
            detail.setDetailSeqID(seqID);
            detail.setDetailBizNo(seqID);
            detail.setOppAccNo(info.getEndorseeAccountName());
            detail.setOppAccName(info.getEndorsee());
            detail.setOppBankName(info.getEndorseeBankName() != null ? info.getEndorseeBankName() : (info.getEndorseeBank() != null ? info.getEndorseeBank().getName() : ""));
            detail.setOppCnapsCode(info.getEndorseeBankNum());
            detail.setOppAmount(recInfo.getBillAmt().setScale(2, 4).toString());
            detail.setBillNo(recInfo.getDraftPackageNumber());
            detail.setDraftType(recInfo.getNtType().getGroup().equals((Object)NTTypeGroupEnum.PAYABLE_BankAccept) ? "AC01" : "AC02");
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0cDetail\u94f6\u884c\u53c2\u8003\u53f7\u4e3a\uff1a " + detail.getBankRefKey()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636eID\u4e3a\uff1a " + recInfo.getId().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636eNTPYPEID\u4e3a\uff1a " + recInfo.getNtType().getId().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636e\u7684\u7968\u636e\u7c7b\u578b\u5206\u7ec4\u4e3a\uff1a " + recInfo.getNtType().getGroup().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0cDraftType \u4e3a\uff1a " + detail.getDraftType()));
            if ("AC02".equals(detail.getDraftType()) && "33333333-3333-3333-3333-3333333333331C9A9013".equals(recInfo.getNtType().getId().toString())) {
                logger.error((Object)"rewriting DraftType to  AC01");
                detail.setDraftType("AC01");
            }
            detail.setTransferFlag(info.isIsTransfer() ? "EM00" : "EM01");
            detail.setDueDate(DraftBEUtil.date2String(recInfo.getExpiredDate(), "yyyyMMdd"));
            detail.setIssueDate(DraftBEUtil.date2String(recInfo.getIssuesDate(), "yyyyMMdd"));
            if (recInfo.getElecBillStatus() != null) {
                detail.setNoteStatus(recInfo.getNoteStatus().getName());
            }
            detail.setDesc(info.getDescription());
            detail.setOperationCode("10");
            detail.setOperationName(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"endorseTransferCancel"));
            logger.error((Object)("recInfo.getBeColumn()" + recInfo.getBeColumn()));
            detail.setReservedFiled1(recInfo.getBeColumn());
            ArrayList receivableId = new ArrayList();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            logger.error((Object)"beginDiscountCommitToBe");
            if (!EmptyUtil.isEmpty((CoreBaseInfo)recInfo)) {
                logger.error((Object)"beginDiscountCommitToBe !EmptyUtil.isEmpty(receInfo)");
                detail.setReservedFiled2(recInfo.getDrawerName() + "|" + recInfo.getDrawerAccountName() + "|" + recInfo.getDrawerBankName());
                logger.error((Object)("DrawerName = " + recInfo.getDrawerName() + "DrawerAccountName = " + recInfo.getDrawerAccountName() + "DrawerBankName = " + recInfo.getDrawerBankName()));
                logger.error((Object)("detail.getReservedFiled2() = " + detail.getReservedFiled2()));
            } else {
                logger.error((Object)"EmptyUtil.isEmpty(receInfo)");
                logger.error((Object)"\u5e94\u6536\u7968\u636e \u4e3a\u7a7a");
                logger.error((Object)("detail.getReservedFiled2() = " + detail.getReservedFiled2()));
            }
            if (recInfo.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                BillServerUtil.setKeepFlag(detail, recInfo);
                EndorsementBillEntryCollection entrys = info.getEntrys();
                String keepFlag = detail.getKeepFlag();
                for (int j = 0; j < entrys.size(); ++j) {
                    EndorsementBillEntryInfo entryInfo = entrys.get(j);
                    if (entryInfo.getReceivableBill() == null || !entryInfo.getReceivableBill().getId().toString().equals(recInfo.getId().toString()) || EmptyUtil.isEmpty((String)entryInfo.getReserveds())) continue;
                    String[] reserveds = entryInfo.getReserveds().split(";");
                    for (int k = 0; k < reserveds.length; ++k) {
                        String returnValue = reserveds[k].trim();
                        if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefKey=".toUpperCase(Locale.ENGLISH))) {
                            keepFlag = keepFlag + ";" + returnValue;
                        }
                        if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefDate=".toUpperCase(Locale.ENGLISH))) continue;
                        keepFlag = keepFlag + ";" + returnValue;
                    }
                }
                detail.setKeepFlag(keepFlag);
            }
            details[i] = detail;
        }
        return details;
    }

    @Override
    protected Map _syncBeForceStatus(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.number"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorseDate"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.company.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedSupplier.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCustomer.*"));
        sic.add(new SelectorItemInfo("entrys.company.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        view.setSelector(sic);
        int success = 0;
        EndorsementBillCollection colls = this.getEndorsementBillCollection(ctx, view);
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil(ctx);
        for (int i = 0; i < colls.size(); ++i) {
            EndorsementBillInfo info = colls.get(i);
            try {
                if (!info.isIsCommitToBE()) {
                    throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS"));
                }
                TreeMap<String, List<ReceivableBillInfo>> batchSeqMap = new TreeMap<String, List<ReceivableBillInfo>>();
                for (int j = 0; j < info.getEntrys().size(); ++j) {
                    EndorsementBillEntryInfo endorsementBillEntryInfo = info.getEntrys().get(j);
                    ReceivableBillInfo entry = info.getEntrys().get(j).getReceivableBill();
                    String batchSeqID = entry.getBatchSeqID();
                    if (EmptyUtil.isEmpty((String)batchSeqID) || endorsementBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"071_COMMITFAIL_CANNOT_SYNCSTATUS"));
                    }
                    ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                this.doSyncForceStatus(ctx, info, recOpUtil, batchSeqMap);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == idSet.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected ArrayList _bitBack(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> commitResult = new ArrayList<BankPayResult>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        evi.setSelector(this.getSic());
        EndorsementBillCollection infoColl = this.getEndorsementBillCollection(ctx, evi);
        int count = infoColl.size();
        for (int i = 0; i < count; ++i) {
            EndorsementBillInfo info = infoColl.get(i);
            boolean isCancelPay = this.isCancelPay(ctx, info);
            if (isCancelPay && !info.isIsBitBack()) {
                try {
                    this.cancelPay(ctx, info);
                }
                catch (Exception e) {
                    BankPayResult resultInfo = new BankPayResult();
                    resultInfo.setId(info.getId().toString());
                    resultInfo.setNumber(info.getNumber());
                    resultInfo.setErrorDetail(e.getMessage());
                    commitResult.add(resultInfo);
                }
                continue;
            }
            BankPayResult resultInfo = new BankPayResult();
            resultInfo.setId(info.getId().toString());
            resultInfo.setNumber(info.getNumber());
            resultInfo.setErrorDetail(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"185_EndorsementBill"));
            commitResult.add(resultInfo);
        }
        return commitResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _updateEntryStatus(Context ctx, List idList, List statusList) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"68_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + statusList.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"170_WageControllerBean", (Locale)ctx.getLocale());
        EndorsementBillCollection coll = this.getEndorsementBillColl(ctx, new HashSet(idList));
        HashMap<String, BankReturnStatusEnum> entry_statusMap = new HashMap<String, BankReturnStatusEnum>();
        for (int i = 0; i < statusList.size(); ++i) {
            Map map = (Map)statusList.get(i);
            String id = (String)map.get("id");
            BankReturnStatusEnum status = (BankReturnStatusEnum)((Object)map.get("bankReturnStatus"));
            entry_statusMap.put(id, status);
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int fail = 0;
        for (int i = 0; i < coll.size(); ++i) {
            EndorsementBillInfo info = coll.get(i);
            if (!info.isIsCommitToBE()) continue;
            ArrayList<ReceivableBillInfo> updateList = new ArrayList<ReceivableBillInfo>();
            EndorsementBillEntryCollection entrys = info.getEntrys();
            HashMap<String, EndorsementBillEntryInfo> map = new HashMap<String, EndorsementBillEntryInfo>();
            for (int j = 0; j < entrys.size(); ++j) {
                EndorsementBillEntryInfo entry = entrys.get(j);
                ReceivableBillInfo rInfo = entry.getReceivableBill();
                String batchSeqID = entry.getBatchSeqID();
                if (!EmptyUtil.isEmpty((String)batchSeqID)) {
                    map.put(rInfo.getId().toString(), entry);
                }
                if (!entry_statusMap.keySet().contains(entry.getId().toString())) continue;
                ReceivableBillInfo receivableBill = entry.getReceivableBill();
                receivableBill.setBankReturnStatus((BankReturnStatusEnum)((Object)entry_statusMap.get(entry.getId().toString())));
                entry.setBankReturnStatus((BankReturnStatusEnum)((Object)entry_statusMap.get(entry.getId().toString())));
                updateList.add(receivableBill);
            }
            if (updateList.size() == 0) continue;
            boolean isLock = iMutex.requestObjIDForUpdate(ctx, info.getId().toString());
            try {
                if (!isLock) {
                    throw new NTException(NTException.COMMON, new Object[]{FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI")});
                }
                this.doUpdateStatus(ctx, updateList, info, map);
                continue;
            }
            catch (Exception e) {
                fail += updateList.size();
                for (int m = 0; m < updateList.size(); ++m) {
                    ReceivableBillInfo receivable = (ReceivableBillInfo)updateList.get(m);
                    result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"171_WageControllerBean", (Locale)ctx.getLocale()) + receivable.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"183_WageControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                }
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                }
            }
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"074_ALL_UPDATESTATUS_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"075_UPDATESTATUS_RESULT", (String[])new String[]{String.valueOf(statusList.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private void doUpdateStatus(Context ctx, List<ReceivableBillInfo> updateList, EndorsementBillInfo info, Map map) throws BEException {
        logger.debug((Object)"begin to updateBeStatus EndorsementBillInfo");
        NoteUpdateStautsUtil util = new NoteUpdateStautsUtil();
        NoteStatusBody body = new NoteStatusBody();
        body.setTotalCount(String.valueOf(updateList.size()));
        body.setDetails(this.parseUpdteDetail(ctx, updateList, map));
        try {
            NoteStatusDetail[] details = util.updateNoteStatus(ctx, null, body);
            this.afterProcess4Update(ctx, info, updateList, details);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err.toString());
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private EndorsementBillCollection getEndorsementBillColl(Context ctx, Set set) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getSic();
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.number"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorseDate"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.company.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedSupplier.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCustomer.*"));
        sic.add(new SelectorItemInfo("entrys.company.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        EndorsementBillCollection coll = this.getEndorsementBillCollection(ctx, view);
        return coll;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, IObjectCollection destObjCol) throws BOSException, EASBizException {
        if (bOTRelationInfos == null || bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
                for (int i = 0; i < bOTRelationInfos.size(); ++i) {
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    VoucherInfo voucherInfo = new VoucherInfo();
                    if (destObjCol != null && destObjCol.size() > 0) {
                        try {
                            for (int j = 0; j < destObjCol.size(); ++j) {
                                voucherInfo = (VoucherInfo)destObjCol.getObject(j);
                                if (bOTRelationInfos.get(i).getDestObjectID().equals(voucherInfo.getId().toString())) break;
                            }
                        }
                        catch (Exception e) {
                            voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(bOTRelationInfos.get(i).getDestObjectID()));
                        }
                    } else {
                        voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(bOTRelationInfos.get(i).getDestObjectID()));
                    }
                    String billSql = "";
                    billSql = BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum) ? "Update T_NT_EndorsementBill set FVoucherNumber = null , FFivouchered = 0 where FID = '" + srcBillId + "'" : (BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum) ? "Update T_NT_EndorsementBill set FVoucherNumber ='" + voucherInfo.getNumber() + "' where FID = '" + srcBillId + "'" : "Update T_NT_EndorsementBill set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FFivouchered = 1   where Fid = '" + srcBillId + "'");
                    if (EmptyUtil.isEmpty((String)billSql)) continue;
                    stmt.addBatch(billSql);
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _genPayment(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> ret = new HashMap<String, String>();
        HashMap<String, String> id2Number = new HashMap<String, String>();
        StringBuffer errMsg = new StringBuffer();
        int errCount = 0;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        evi.setSelector(this.getSic());
        EndorsementBillCollection endorseColl = this.getEndorsementBillCollection(ctx, evi);
        EndorsementBillCollection transColl = new EndorsementBillCollection();
        ArrayList<String> notPayedBills = new ArrayList<String>();
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < endorseColl.size(); ++i) {
            EndorsementBillInfo endorse = endorseColl.get(i);
            id2Number.put(endorse.getId().toString(), endorse.getNumber());
            ArrayList destPayment = botRelation.getDestObjIdByDestType(endorse.getId().toString(), PAYMENTBILLBOSTYPE);
            ArrayList srcPayment = botRelation.getSrcObjIdBySrcType(endorse.getId().toString(), PAYMENTBILLBOSTYPE);
            ArrayList srcSettlement = botRelation.getSrcObjIdBySrcType(endorse.getId().toString(), SETTLEMENTBILLBOSTYPE);
            if (!(EmptyUtil.isEmpty((Collection)destPayment) && EmptyUtil.isEmpty((Collection)srcPayment) && EmptyUtil.isEmpty((Collection)srcSettlement))) {
                errMsg.append(endorse.getNumber() + ": " + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"hasPayment"));
                errMsg.append("\r\n");
                ++errCount;
                continue;
            }
            notPayedBills.add(endorse.getId().toString());
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<String> success = new HashSet<String>();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(notPayedBills);
            for (String key : notPayedBills) {
                if (((Boolean)resultRequest.get(key)).booleanValue()) {
                    success.add(key);
                    continue;
                }
                errMsg.append((String)id2Number.get(key) + ": " + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"canNotGetLock"));
                errMsg.append("\r\n");
                ++errCount;
            }
            if (!EmptyUtil.isEmpty(success)) {
                for (int i = 0; i < endorseColl.size(); ++i) {
                    EndorsementBillInfo endorse = endorseColl.get(i);
                    if (!success.contains(endorse.getId().toString())) continue;
                    transColl.add(endorse);
                }
            }
            if (transColl.size() > 0) {
                for (int i = 0; i < transColl.size(); ++i) {
                    try {
                        NTHelper.genPaymentBillByBotp(ctx, (CoreBillBaseInfo)transColl.get(i));
                        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)transColl.get(i).getBOSType(), (IObjectPK)new ObjectUuidPK(transColl.get(i).getId().toString()), (String)transColl.get(i).getNumber(), (String)"endorsementBill_genPayment", (String)transColl.get(i).getCompany().getId().toString(), null);
                        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                        continue;
                    }
                    catch (Exception e) {
                        errMsg.append(transColl.get(i).getNumber() + ": " + e.getMessage());
                        errMsg.append("\r\n");
                        ++errCount;
                        logger.error((Object)"\u80cc\u4e66\u5355\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
        finally {
            if (!EmptyUtil.isEmpty(success)) {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(success));
            }
        }
        ret.put("errMsg", errMsg.toString());
        ret.put("errCount", errCount + "");
        return ret;
    }

    @Override
    protected void _splitEndorse(Context ctx, IObjectValue model, Map map, boolean isBatchEndorseOut, boolean isCreatePayment, boolean isOut) throws BOSException, EASBizException {
        EndorsementBillInfo element = (EndorsementBillInfo)model;
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance(ctx);
        if (map.size() == 0) {
            ReceivableBillCollection receivablebillColl = element.getReceivableEntrys();
            EndorsementBillEntryCollection entry = element.getEntrys();
            String billNumber = "";
            for (int i = 0; i < entry.size(); ++i) {
                EndorsementBillEntryInfo info = entry.get(i);
                ReceivableBillInfo receivableBillinfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(info.getReceivableBill().getId().toString()));
                info.setEndorseAmt(receivableBillinfo.getAvailableAmt());
                billNumber = billNumber.length() > 0 ? billNumber + ";" + receivableBillinfo.getDraftNumber() : receivableBillinfo.getDraftNumber();
                if (!receivableBillinfo.getSource().equals((Object)BillSourceEnum.BYHAND)) {
                    if (EmptyUtil.isEmpty((String)element.getLinkbillId()) || !BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString()) && !BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new SettlementBillInfo().getBOSType().toString())) continue;
                    DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FLockAmt =0 where FId=?", (Object[])new Object[]{receivableBillinfo.getId().toString()});
                    receivableBillinfo.setAvailableAmt(BigDecimal.ZERO);
                    info.setEndorseAmt(receivableBillinfo.getLockAmt());
                    continue;
                }
                if (EmptyUtil.isEmpty((String)element.getLinkbillId()) || !BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString()) && !BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new SettlementBillInfo().getBOSType().toString())) continue;
                DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FLockAmt =0 where FId=?", (Object[])new Object[]{receivableBillinfo.getId().toString()});
                info.setEndorseAmt(receivableBillinfo.getLockAmt());
            }
            if (!EmptyUtil.isEmpty((String)element.getLinkbillId()) && BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                if (billNumber != null && billNumber.length() > 2000) {
                    billNumber = billNumber.substring(0, 2000);
                }
                DbUtil.execute((Context)ctx, (String)"update T_CAS_PaymentBill set FSettlementNumber = ? where FId=?", (Object[])new Object[]{billNumber, element.getLinkbillId()});
            }
            if (isOut) {
                EndorsementBillFactory.getLocalInstance(ctx).outSubmit((EndorsementBillInfo)model, isCreatePayment);
            } else {
                EndorsementBillFactory.getLocalInstance(ctx).inSubmit((EndorsementBillInfo)model, isCreatePayment);
            }
        } else {
            ReceivableBillCollection receivablebillColl = (ReceivableBillCollection)((Object)element.getReceivableEntrys().clone());
            element.getReceivableEntrys().clear();
            element.getEntrys().clear();
            String billNumber = "";
            BigDecimal amt = BigDecimal.ZERO;
            for (int i = 0; i < receivablebillColl.size(); ++i) {
                ReceivableBillInfo receivableBillinfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(receivablebillColl.get(i).getId().toString()));
                if (map.containsKey(receivableBillinfo.getId().toString())) {
                    BigDecimal endAmt = (BigDecimal)map.get(receivableBillinfo.getId().toString());
                    EndorsementBillEntryInfo endorsementBillEntryinfo = new EndorsementBillEntryInfo();
                    endorsementBillEntryinfo.setEndorseAmt(endAmt);
                    if (receivableBillinfo.getSource().equals((Object)BillSourceEnum.BYHAND)) {
                        ReceivableBillInfo splitInfoA = (ReceivableBillInfo)receivableBillinfo.clone();
                        ReceivableBillInfo splitInfoB = (ReceivableBillInfo)receivableBillinfo.clone();
                        this.splitReceivableBill(ctx, endAmt, receivableBillinfo, splitInfoA, splitInfoB, element);
                        billNumber = billNumber.length() > 0 ? billNumber + ";" + splitInfoA.getDraftNumber() : splitInfoA.getDraftNumber();
                        element.getReceivableEntrys().add(splitInfoA);
                        endorsementBillEntryinfo.setReceivableBill(splitInfoA);
                        if (!EmptyUtil.isEmpty((String)element.getLinkbillId()) && BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                            DbUtil.execute((Context)ctx, (String)"update T_FM_ReceivableBillEntry set FReceivableBillID = ?,FReceivableBillNum = ? where FBillID = ? and FReceivableBillID = ?", (Object[])new Object[]{splitInfoA.getId().toString(), splitInfoA.getDraftNumber(), element.getLinkbillId(), receivableBillinfo.getId().toString()});
                        }
                    } else {
                        billNumber = billNumber.length() > 0 ? billNumber + ";" + receivableBillinfo.getDraftNumber() : receivableBillinfo.getDraftNumber();
                        if (EmptyUtil.isEmpty((String)element.getLinkbillId()) || !EmptyUtil.isEmpty((String)element.getLinkbillId()) && !BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                            DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FLockAmt = FLockAmt+?,FAvailableAmt = FAvailableAmt-? where FId=?", (Object[])new Object[]{endAmt, endAmt, receivableBillinfo.getId().toString()});
                            receivableBillinfo.setLockAmt(receivableBillinfo.getLockAmt().add(endAmt));
                        }
                        element.getReceivableEntrys().add(receivableBillinfo);
                        endorsementBillEntryinfo.setReceivableBill(receivableBillinfo);
                    }
                    amt = amt.add(endAmt);
                    element.getEntrys().add(endorsementBillEntryinfo);
                    continue;
                }
                billNumber = billNumber.length() > 0 ? billNumber + ";" + receivableBillinfo.getDraftNumber() : receivableBillinfo.getDraftNumber();
                if (!EmptyUtil.isEmpty((String)element.getLinkbillId()) && (BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString()) || BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new SettlementBillInfo().getBOSType().toString()))) {
                    DbUtil.execute((Context)ctx, (String)"update T_NT_ReceivableBill set FLockAmt =0 where FId=?", (Object[])new Object[]{receivableBillinfo.getId().toString()});
                }
                amt = amt.add(receivableBillinfo.getBillAmt());
                element.getReceivableEntrys().add(receivableBillinfo);
                EndorsementBillEntryInfo endorsementBillEntryinfo = new EndorsementBillEntryInfo();
                endorsementBillEntryinfo.setReceivableBill(receivableBillinfo);
                endorsementBillEntryinfo.setEndorseAmt(receivableBillinfo.getBillAmt());
                element.getEntrys().add(endorsementBillEntryinfo);
            }
            if (!EmptyUtil.isEmpty((String)element.getLinkbillId()) && BOSUuid.read((String)element.getLinkbillId()).getType().toString().equals(new PaymentBillInfo().getBOSType().toString())) {
                String pNumber = billNumber;
                if (pNumber != null && pNumber.length() > 2000) {
                    pNumber = pNumber.substring(0, 2000);
                }
                DbUtil.execute((Context)ctx, (String)"update T_CAS_PaymentBill set FSettlementNumber = ? where FId=?", (Object[])new Object[]{pNumber, element.getLinkbillId()});
            }
            if (billNumber != null && billNumber.length() > 75) {
                billNumber = billNumber.substring(0, 75);
            }
            element.setNumber(billNumber);
            element.setNoteBillNumber(billNumber);
            element.setEndorseAmt(amt);
            element.setLocalAmount(amt.multiply(element.getExRate()));
            if (isOut) {
                EndorsementBillFactory.getLocalInstance(ctx).outSubmit(element, isCreatePayment);
            } else {
                EndorsementBillFactory.getLocalInstance(ctx).inSubmit(element, isCreatePayment);
            }
        }
    }

    protected void splitReceivableBill(Context ctx, BigDecimal endAmt, ReceivableBillInfo receivableBillInfo, ReceivableBillInfo splitInfoA, ReceivableBillInfo splitInfoB, EndorsementBillInfo element) throws EASBizException, BOSException {
        String permission = receivableBillInfo.getSource().equals((Object)BillSourceEnum.BYHAND) ? "RECEIVABLE_43splitBill" : "ent_receivablebill_41splitBill";
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(receivableBillInfo.getCompany().getId()), (String)permission);
        if (!isPermission) {
            throw new NTException(NTException.NOTPERMISSION);
        }
        String slinkNoteBillId = element.getLinkbillId();
        boolean isfromPay = slinkNoteBillId != null && (BOSUuid.read((String)slinkNoteBillId).getType().toString().equals(new PaymentBillInfo().getBOSType().toString()) || BOSUuid.read((String)slinkNoteBillId).getType().toString().equals(new SettlementBillInfo().getBOSType().toString()));
        ReceivableBillCollection coll = new ReceivableBillCollection();
        splitInfoA.setId(null);
        splitInfoA.setNumber(null);
        splitInfoA.setSourceBillId(receivableBillInfo.getId().toString());
        splitInfoA.setIsPledge(false);
        splitInfoA.setIsDisPledge(false);
        splitInfoA.setDigest(null);
        BigDecimal subQuantity = endAmt.multiply(new BigDecimal(100));
        splitInfoA.setSubQuantity(subQuantity);
        splitInfoA.setBillAmt(endAmt);
        splitInfoA.setNaturalAmt(splitInfoA.getExchangeRate().multiply(endAmt));
        splitInfoA.setAvailableAmt(BigDecimal.ZERO);
        splitInfoA.setLockAmt(BigDecimal.ZERO);
        splitInfoA.setDraftNumber(splitInfoA.getDraftPackageNumber());
        if (receivableBillInfo.getSource().equals((Object)BillSourceEnum.BYHAND)) {
            splitInfoA.setSubStartNumber(receivableBillInfo.getSubStartNumber());
            BigDecimal subEndNumber = endAmt.multiply(new BigDecimal(100)).add(receivableBillInfo.getSubStartNumber()).subtract(new BigDecimal(1));
            splitInfoA.setSubEndNumber(subEndNumber);
            splitInfoA.setSubRegion(splitInfoA.getSubStartNumber().stripTrailingZeros().toPlainString() + "-" + subEndNumber.stripTrailingZeros().toPlainString());
            splitInfoA.setDraftNumber(splitInfoA.getDraftPackageNumber() + "-" + splitInfoA.getSubRegion());
        } else {
            splitInfoA.put("subStartNumber", null);
            splitInfoA.put("subEndNumber", null);
            splitInfoA.setSubRegion(null);
        }
        if (EmptyUtil.isEmpty((String)element.getLinkbillId())) {
            splitInfoA.setIsLockByBill(false);
        }
        coll.add(splitInfoA);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)splitInfoB.getEndorseBill())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)splitInfoA.getEndorseBill().getId().toString()));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("entrys.*"));
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            EndorsementBillCollection ecoll = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)ecoll) && ecoll.size() > 0) {
                EndorsementBillInfo endInfo = ecoll.get(0);
                EndorsementBillEntryCollection entryColl = endInfo.getEntrys();
                for (int a = 0; a < entryColl.size(); ++a) {
                    EndorsementBillEntryInfo entryInfo = entryColl.get(a);
                    if (!entryInfo.getReceivableBill().getId().toString().equals(splitInfoB.getId().toString()) || !entryInfo.isIsCommitCancel() || !entryInfo.isIsNoteCancel()) continue;
                    BigDecimal origEndNo = splitInfoB.getOrigEndNo();
                    splitInfoB.setOrigStartNo(origEndNo.add(Constants.ONE));
                    ReceivableBillInfo oldReceivableBillinfo = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(splitInfoB.getId().toString()));
                    splitInfoB.setOrigEndNo(oldReceivableBillinfo.getOrigEndNo());
                }
            }
        }
        BigDecimal endAmtB = receivableBillInfo.getBillAmt().subtract(endAmt);
        BigDecimal subQuantityB = endAmtB.multiply(new BigDecimal(100));
        splitInfoB.setSubQuantity(subQuantityB);
        splitInfoB.setBillAmt(endAmtB);
        splitInfoB.setNaturalAmt(splitInfoB.getExchangeRate().multiply(endAmtB));
        splitInfoB.setDraftNumber(splitInfoB.getDraftPackageNumber());
        if (splitInfoB.getLockAmt().compareTo(BigDecimal.ZERO) > 0) {
            splitInfoB.setLockAmt(splitInfoB.getLockAmt().subtract(endAmt));
        } else {
            splitInfoB.setLockAmt(BigDecimal.ZERO);
        }
        splitInfoB.setAvailableAmt(endAmtB.subtract(splitInfoB.getLockAmt()));
        if (receivableBillInfo.getSource().equals((Object)BillSourceEnum.BYHAND)) {
            splitInfoB.setSubStartNumber(splitInfoA.getSubEndNumber().add(new BigDecimal(1)));
            BigDecimal subEndNumberB = receivableBillInfo.getSubEndNumber();
            splitInfoB.setSubEndNumber(subEndNumberB);
            splitInfoB.setSubRegion(splitInfoB.getSubStartNumber().stripTrailingZeros().toPlainString() + "-" + subEndNumberB.stripTrailingZeros().toPlainString());
            splitInfoB.setDraftNumber(splitInfoB.getDraftPackageNumber() + "-" + splitInfoB.getSubRegion());
        } else {
            splitInfoB.put("subStartNumber", null);
            splitInfoB.put("subEndNumber", null);
            splitInfoB.setSubRegion(null);
        }
        if (isfromPay) {
            try {
                String sSQL = "Select * From T_FM_ReceivableBillEntry Where FBillID <> '" + slinkNoteBillId + "' and FReceivableBillID = '" + splitInfoB.getId().toString() + "'";
                ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sSQL);
                IRowSet rs = exec.executeSQL();
                if (!rs.next()) {
                    splitInfoB.setIsLockByBill(false);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        coll.add(splitInfoB);
        ReceivableBillFactory.getLocalInstance(ctx).saveSplitBill((IObjectCollection)coll, (IObjectValue)receivableBillInfo);
    }
}

