/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.nt.EndorseStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillCollection;
import com.kingdee.eas.fm.nt.EndorsementBillEntryInfo;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementTypeEnum;
import com.kingdee.eas.fm.nt.IEndorsementBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.AbstractEndorsementBillWebFacadeControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EndorsementBillWebFacadeControllerBean
extends AbstractEndorsementBillWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.EndorsementBillWebFacadeControllerBean");

    private IEndorsementBill getBizInterface(Context ctx) throws BOSException {
        return EndorsementBillFactory.getLocalInstance(ctx);
    }

    @Override
    protected Map _submit(Context ctx, EndorsementBillInfo info, boolean isCreatePayment) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IObjectPK rstID = null;
        try {
            if (!EmptyUtil.isEmpty((Object)info.getId()) && this.getBizInterface(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                info.setIsEdit(true);
                EndorsementBillInfo oldInfo = this.getBizInterface(ctx).getEndorsementBillInfo("select * where id='" + info.getId().toString() + "'");
                if (!oldInfo.getState().equals((Object)EndorseStateEnum.Submit)) {
                    throw new NTException(NTException.NOT_SUBMIT);
                }
            } else {
                info.setId(null);
                info.setIsEdit(false);
                info.setState(EndorseStateEnum.Submit);
                ReceivableBillCollection coll = info.getReceivableEntrys();
                for (int i = 0; i < coll.size(); ++i) {
                    ReceivableBillInfo receivableInfo = coll.get(i);
                    EndorsementBillEntryInfo entryInfo = new EndorsementBillEntryInfo();
                    entryInfo.setReceivableBill(receivableInfo);
                    entryInfo.setElecBillStatus(receivableInfo.getElecBillStatus());
                    entryInfo.setBankReturnStatus(receivableInfo.getBankReturnStatus());
                    entryInfo.setBankReturnMsg(receivableInfo.getBankReturnMsg());
                    entryInfo.setEndorseAmt(receivableInfo.getBillAmt());
                    info.getEntrys().add(entryInfo);
                }
            }
            info.setFromCompany(info.getCompany());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String endorseDate = sdf.format(info.getEndorseDate());
            info.setEndorseDate(sdf.parse(endorseDate));
            rstID = info.getBillType().equals((Object)EndorsementTypeEnum.IN) ? this.getBizInterface(ctx).inSubmit(info, isCreatePayment) : this.getBizInterface(ctx).outSubmit(info, isCreatePayment);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        catch (ParseException e3) {
            result.put("MsgStr", e3.getMessage());
            e3.printStackTrace();
            logger.debug((Object)e3);
            return result;
        }
        result.put("MsgStr", CASWebHelper.getCASMsg((Context)ctx, (String)"SAVE_Successfully"));
        result.put("OPStatus", "success");
        result.put("IdAfterSave", rstID);
        result.put("createPayment", isCreatePayment);
        return result;
    }

    @Override
    protected Map _antiAudit(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + EndorsementBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            EndorsementBillCollection colls = this.getEndorsementBillCollByIdSet(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                EndorsementBillInfo info = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"nt_inendorse_unAudit");
                    if (!isPermission) {
                        throw new BOSException(EndorsementBillWebFacadeControllerBean.getResource(ctx, "269_ReceivableBill", new String[]{info.getCompany().getName()}));
                    }
                    this.getBizInterface(ctx).unAudit((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(EndorsementBillWebFacadeControllerBean.getResource(ctx, "203_ReceivableBill", new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(EndorsementBillWebFacadeControllerBean.getResource(ctx, "270_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? EndorsementBillWebFacadeControllerBean.getResource(ctx, "205_ReceivableBill", null) : summary + EndorsementBillWebFacadeControllerBean.getResource(ctx, "206_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _audit(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + EndorsementBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            EndorsementBillCollection colls = this.getEndorsementBillCollByIdSet(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                EndorsementBillInfo info = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"nt_inendorse_audit");
                    if (!isPermission) {
                        throw new BOSException(EndorsementBillWebFacadeControllerBean.getResource(ctx, "271_ReceivableBill", new String[]{info.getCompany().getName()}));
                    }
                    this.getBizInterface(ctx).audit((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(EndorsementBillWebFacadeControllerBean.getResource(ctx, "198_ReceivableBill", new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(EndorsementBillWebFacadeControllerBean.getResource(ctx, "272_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? EndorsementBillWebFacadeControllerBean.getResource(ctx, "200_ReceivableBill", null) : summary + EndorsementBillWebFacadeControllerBean.getResource(ctx, "201_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected void _batchSubmit(Context ctx, Map idMap) throws BOSException, EASBizException {
    }

    @Override
    protected Map _cancelEndorse(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + EndorsementBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            EndorsementBillCollection colls = this.getEndorsementBillCollByIdSet(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                EndorsementBillInfo info = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"nt_inendorse_cancel");
                    if (!isPermission) {
                        throw new BOSException(EndorsementBillWebFacadeControllerBean.getResource(ctx, "273_ReceivableBill", new String[]{info.getCompany().getName()}));
                    }
                    if (info.getState() != EndorseStateEnum.Submit || info.isFiVouchered()) {
                        throw new NTException(NTException.NOT_CANCELENDORSE);
                    }
                    this.getBizInterface(ctx).cancelEndorse(BOSUuid.read((String)info.getId().toString()), false);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(EndorsementBillWebFacadeControllerBean.getResource(ctx, "274_ReceivableBill", new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(EndorsementBillWebFacadeControllerBean.getResource(ctx, "275_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? EndorsementBillWebFacadeControllerBean.getResource(ctx, "276_ReceivableBill", null) : summary + EndorsementBillWebFacadeControllerBean.getResource(ctx, "277_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private EndorsementBillCollection getEndorsementBillCollByIdSet(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        entityViewInfo.setSelector(sic);
        return this.getBizInterface(ctx).getEndorsementBillCollection(entityViewInfo);
    }

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }
}

