/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.nt.LetterOfCreditAppModifyException;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyModifyEntryCollection;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyModifyEntryInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyModifyFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyModifyInfo;
import com.kingdee.eas.fm.nt.app.AbstractLetterOfCreditApplyModifyControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;

public class LetterOfCreditApplyModifyControllerBean
extends AbstractLetterOfCreditApplyModifyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.LetterOfCreditApplyModifyControllerBean");

    @Override
    protected int _getModifyTimes(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "Select count(*) as total_1 From T_NT_LetterOfCreditApplyModify Where FLetterNumber = ? ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        int num = 0;
        try {
            if (rowset.next()) {
                num = rowset.getInt("total_1");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return num;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditApplyModifyInfo info = LetterOfCreditApplyModifyFactory.getLocalInstance(ctx).getLetterOfCreditApplyModifyInfo(pk);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getAuditor())) {
            throw new LetterOfCreditAppModifyException(LetterOfCreditAppModifyException.ISAUDITED);
        }
        LetterOfCreditApplyInfo apply = this.updateLetterColumn(ctx, (IObjectValue)info, 1);
        this.modifyAmount(ctx, apply);
        this.verify(ctx, apply);
        LetterOfCreditApplyFactory.getLocalInstance(ctx).submit((CoreBaseInfo)apply);
        String sql = " Update T_NT_LetterOfCreditApplyModify Set FAuditorID =? Where FID=? ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString(), pk.toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditApplyModifyInfo info = LetterOfCreditApplyModifyFactory.getLocalInstance(ctx).getLetterOfCreditApplyModifyInfo(pk);
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getAuditor())) {
            throw new LetterOfCreditAppModifyException(LetterOfCreditAppModifyException.ISNOTAUDITED);
        }
        this.reAuditCheck(ctx, info);
        LetterOfCreditApplyInfo apply = this.updateLetterColumn(ctx, (IObjectValue)info, 2);
        this.modifyAmount(ctx, apply);
        this.verify(ctx, apply);
        LetterOfCreditApplyFactory.getLocalInstance(ctx).submit((CoreBaseInfo)apply);
        String sql = " Update T_NT_LetterOfCreditApplyModify Set FAuditorID = null Where FID=? ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
    }

    private void reAuditCheck(Context ctx, LetterOfCreditApplyModifyInfo info) throws BOSException, EASBizException {
        String sql = " Select count(*) as total From T_NT_LetterOfCreditApplyModify Where FLetterId =? and FModifyNumber > ?";
        int num = 0;
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getLetterId(), String.valueOf(info.getModifyNumber())});
        try {
            if (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (num > 0) {
            throw new LetterOfCreditAppModifyException(LetterOfCreditAppModifyException.NOTPERMITREAUDIT);
        }
    }

    private void modifyAmount(Context ctx, LetterOfCreditApplyInfo info) throws BOSException, EASBizException {
        BigDecimal Horizon = FinHorizon.getHorizon((Date)info.getIssueDate(), (Date)info.getExpiredDate());
        BigDecimal biginfo = new BigDecimal(String.valueOf(Horizon));
        this.setValue(info, "Horizon", biginfo);
        BigDecimal bdAmount = info.getAmount();
        BigDecimal bdCurExRaTe = info.getLocalCurExRate();
        BigDecimal biginBalancefo = new BigDecimal(String.valueOf(bdAmount));
        this.setValue(info, "Amount", biginBalancefo);
        this.setValue(info, "AmountLocalCur", biginBalancefo.multiply(bdCurExRaTe));
    }

    protected LetterOfCreditApplyInfo updateLetterColumn(Context ctx, IObjectValue value, int operateType) throws BOSException, EASBizException {
        Object object = null;
        LetterOfCreditApplyModifyInfo letterInfo = (LetterOfCreditApplyModifyInfo)value;
        LetterOfCreditApplyModifyEntryCollection colls = letterInfo.getEntrys();
        LetterOfCreditApplyInfo info = LetterOfCreditApplyFactory.getLocalInstance(ctx).getLetterOfCreditApplyInfo((IObjectPK)new ObjectUuidPK(letterInfo.getLetterId()));
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditApplyModifyEntryInfo entryInfo = colls.get(i);
            object = operateType == 1 ? this.getRealValue(entryInfo, entryInfo.getContentAfterM(), ctx) : this.getRealValue(entryInfo, entryInfo.getContentBeforeM(), ctx);
            this.setValue(info, entryInfo.getModifyItem().getName(), object);
        }
        return info;
    }

    private Object getRealValue(LetterOfCreditApplyModifyEntryInfo entryInfo, String value, Context ctx) throws BOSException, EASBizException {
        Object object = null;
        if (entryInfo.getModifyItem().getValue().equals("1") || entryInfo.getModifyItem().getValue().equals("21") || entryInfo.getModifyItem().getValue().equals("22") || entryInfo.getModifyItem().getValue().equals("23") || entryInfo.getModifyItem().getValue().equals("3") || entryInfo.getModifyItem().getValue().equals("5") || entryInfo.getModifyItem().getValue().equals("13") || entryInfo.getModifyItem().getValue().equals("12") || entryInfo.getModifyItem().getValue().equals("8") || entryInfo.getModifyItem().getValue().equals("19") || entryInfo.getModifyItem().getValue().equals("29") || entryInfo.getModifyItem().getValue().equals("15")) {
            object = value;
        }
        if ((entryInfo.getModifyItem().getValue().equals("14") || entryInfo.getModifyItem().getValue().equals("24") || entryInfo.getModifyItem().getValue().equals("6")) && value != null) {
            DateFormat format = (DateFormat)FMHelper.getNantionalDateMap((Context)ctx).get("dateFormat");
            try {
                object = format.parse(value);
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (entryInfo.getModifyItem().getValue().equals("16") || entryInfo.getModifyItem().getValue().equals("17") || entryInfo.getModifyItem().getValue().equals("11") || entryInfo.getModifyItem().getValue().equals("7")) {
            object = new Boolean(value);
        }
        if (entryInfo.getModifyItem().getValue().equals("20") || entryInfo.getModifyItem().getValue().equals("4") || entryInfo.getModifyItem().getValue().equals("0") || entryInfo.getModifyItem().getValue().equals("2") || entryInfo.getModifyItem().getValue().equals("18") || entryInfo.getModifyItem().getValue().equals("25") || entryInfo.getModifyItem().getValue().equals("27") || entryInfo.getModifyItem().getValue().equals("28")) {
            if (value == null) {
                object = null;
            } else {
                CoreBaseInfo obj = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(value);
                object = obj;
            }
        }
        if (entryInfo.getModifyItem().getValue().equals("26")) {
            if (value == null) {
                object = null;
            } else {
                AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
                adminOrg.setId(BOSUuid.read((String)value));
                object = adminOrg;
            }
        }
        return object;
    }

    protected void verify(Context ctx, LetterOfCreditApplyInfo info) throws BOSException, EASBizException {
        if (info.getFluctuateScale() > 100 || info.getFluctuateScale() < -100 || info.getFScalefloor() > 100 || info.getFScalefloor() < -100) {
            throw new LetterOfCreditAppModifyException(LetterOfCreditAppModifyException.FLUCTUATESCALE);
        }
        if (!info.isIsDYZ()) {
            info.setFluctuateScale(0);
            info.setFScalefloor(0);
        }
        if (info.getForwardDate() > 0 && !info.isIsForward()) {
            info.setForwardDate(0);
        }
        Date dateBegin = DateTimeUtils.truncateDate((Date)info.getIssueDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)info.getExpiredDate());
        if (!dateEnd.after(dateBegin)) {
            throw new LetterOfCreditAppModifyException(LetterOfCreditAppModifyException.LETTEROFCREDITENDDATELATERTHANBEGINDATE);
        }
    }

    private void setValue(LetterOfCreditApplyInfo info, String ColumnName, Object ColumnValue) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = null;
        entity = loader.getEntity(info.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (int i = 0; i < pc.size(); ++i) {
            PropertyInfo pro = pc.get(i);
            String fieldName = pro.getName();
            if (!ColumnName.equalsIgnoreCase(fieldName)) continue;
            if ("entrys".equals(fieldName)) break;
            BindingUtility.setBeanProperty((Object)info, (String)fieldName, (Object)ColumnValue);
            break;
        }
    }
}

