/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.fm.nt.LetterOfCreditDisCountFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditDisCountInfo;
import com.kingdee.eas.fm.nt.app.AbstractLetterOfCreditDisCountControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class LetterOfCreditDisCountControllerBean
extends AbstractLetterOfCreditDisCountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.LetterOfCreditDisCountControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditDisCountInfo info = (LetterOfCreditDisCountInfo)model;
        IObjectPK pk = super._addnew(ctx, model);
        this.disposeLetterOfCreditReceive(ctx, info.getSourceBillId(), pk.toString(), false);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditDisCountInfo info = LetterOfCreditDisCountFactory.getLocalInstance(ctx).getLetterOfCreditDisCountInfo(pk);
        if (info.isIsGenRec()) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.DISCOUNTDELETE);
        }
        super._delete(ctx, pk);
        this.disposeLetterOfCreditReceive(ctx, info.getSourceBillId(), pk.toString(), true);
    }

    @Override
    protected void _genRecBill(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("recAccountBank.account.id"));
        sic.add(new SelectorItemInfo("recAccountBank.bank.id"));
        LetterOfCreditDisCountInfo info = LetterOfCreditDisCountFactory.getLocalInstance(ctx).getLetterOfCreditDisCountInfo((IObjectPK)pk, sic);
        if (info.isIsGenRec()) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ISGENREC);
        }
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        ReceivingBillInfo recinfo = new ReceivingBillInfo();
        recinfo.setBizDate(info.getDisCountDate());
        recinfo.setSourceType(SourceTypeEnum.CASH);
        recinfo.setCompany(info.getCompany());
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        ExchangeRateInfo rate = CasForArApUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)currentCompany, (CurrencyInfo)info.getCurrency(), (Date)info.getBizDate());
        if (EmptyUtil.isEmpty((CoreBaseInfo)rate)) {
            recinfo.setExchangeRate(Constants.ONE);
        } else {
            recinfo.setExchangeRate(rate.getConvertRate());
        }
        recinfo.setCurrency(info.getCurrency());
        recinfo.setPayeeAccountBank(info.getRecAccountBank());
        recinfo.setPayeeAccount(info.getRecAccountBank().getAccount());
        recinfo.setPayeeBank(info.getRecAccountBank().getBank());
        recinfo.setCreator(user);
        recinfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        recinfo.setBillStatus(BillStatusEnum.SAVE);
        recinfo.setDescription(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.nt.NtResource", (String)"lettercreditdiscount_rec"));
        recinfo.setAmount(info.getActAmount());
        ReceivingBillEntryInfo entryInfo = new ReceivingBillEntryInfo();
        entryInfo.setSeq(1);
        entryInfo.setSourceBillId(id);
        entryInfo.setCurrency(info.getCurrency());
        entryInfo.setActualAmt(info.getActAmount());
        recinfo.getEntries().add(entryInfo);
        recinfo.setSourceBillId(id);
        ReceivingBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)recinfo);
        ArrayList<String> srcIdList = new ArrayList<String>();
        srcIdList.add(id);
        BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)recinfo.getId().toString());
        String sSQL = "Update T_NT_LetterOfCreditDisCount Set FisGenRec = ? Where Fid = ? ";
        DbUtil.execute((Context)ctx, (String)sSQL, (Object[])new Object[]{true, id});
    }

    private void disposeLetterOfCreditReceive(Context ctx, String srcBillId, String destBillId, boolean isDelete) throws BOSException {
        String sSQL = "Update T_NT_LetterOfCreditReceive Set FLetterStatus = ?, Fbillstate = ? Where Fid = ? ";
        String letterStatus = "1";
        Integer state = new Integer(3);
        if (isDelete) {
            letterStatus = "0";
            state = 2;
        }
        DbUtil.execute((Context)ctx, (String)sSQL, (Object[])new Object[]{letterStatus, state, srcBillId});
        if (isDelete) {
            Object[] paramList = new Object[]{destBillId};
            String sql = "delete from T_BOT_Relation where fdestobjectid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
        } else {
            FinUtils.addBotRelation((Context)ctx, (String)srcBillId, (String)destBillId);
        }
    }
}

