/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTWarnLedgerFilterParam;
import com.kingdee.eas.fm.nt.NoteKindEnum;
import com.kingdee.eas.fm.nt.WarnCondTypeEnum;
import com.kingdee.eas.fm.nt.app.AbstractNTWarnLedgeFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class NTWarnLedgeFacadeControllerBean
extends AbstractNTWarnLedgeFacadeControllerBean {
    private NTWarnLedgerFilterParam p;
    private CompanyOrgUnitInfo company;

    @Override
    protected IRowSet _getRowSet(Context ctx, FilterParam param) throws BOSException {
        if (!(param instanceof NTWarnLedgerFilterParam)) {
            return null;
        }
        this.company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.p = (NTWarnLedgerFilterParam)param;
        Set groupSet = this.getNTGroup(ctx);
        if (groupSet == null || groupSet.size() <= 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select * \n");
        sql.append(" from ( \n");
        Object[] group = groupSet.toArray();
        if (NTTypeGroupEnum.PaymentCheque.equals(group[0])) {
            sql.append(this.getChequeSql(ctx));
        } else if (NTTypeGroupEnum.GatherCheque.equals(group[0])) {
            sql.append(this.getRecChequeSql(ctx));
        } else if (NTTypeGroupEnum.PAYABLE.equals(group[0])) {
            sql.append(this.getPayableSql(ctx));
        } else if (NTTypeGroupEnum.RECEIVABLE.equals(group[0])) {
            sql.append(this.getReceivableSql(ctx));
        } else if (NTTypeGroupEnum.ImportCredit.equals(group[0])) {
            sql.append(this.getLetterOfCreditSql(ctx));
        }
        for (int i = 1; i < group.length; ++i) {
            sql.append("\n union \n");
            if (NTTypeGroupEnum.PaymentCheque.equals(group[i])) {
                sql.append(this.getChequeSql(ctx));
                continue;
            }
            if (NTTypeGroupEnum.GatherCheque.equals(group[i])) {
                sql.append(this.getRecChequeSql(ctx));
                continue;
            }
            if (NTTypeGroupEnum.PAYABLE.equals(group[i])) {
                sql.append(this.getPayableSql(ctx));
                continue;
            }
            if (NTTypeGroupEnum.RECEIVABLE.equals(group[i])) {
                sql.append(this.getReceivableSql(ctx));
                continue;
            }
            if (!NTTypeGroupEnum.ImportCredit.equals(group[i])) continue;
            sql.append(this.getLetterOfCreditSql(ctx));
        }
        sql.append("\n ) as Fact \n");
        sql.append("order by \"NOTEKIND\",\"NTTYPE.SUPERGROUP\",\"EXPIREDDATE\"");
        try {
            return FMIsqlFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString(), new Object[0]);
        }
        catch (EASBizException e) {
            new BOSException((Throwable)e);
            return null;
        }
    }

    private String getChequeSql(Context ctx) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.fm.nt.app", "NTWarnLedgeChequeQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.getChequeFilter());
        exec.setObjectView(evi);
        return exec.getSQL();
    }

    private String getRecChequeSql(Context ctx) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.fm.nt.app", "NTWarnLedgerRecChequeQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.getRecChequeFilter());
        exec.setObjectView(evi);
        return exec.getSQL();
    }

    private String getReceivableSql(Context ctx) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.fm.nt.app", "NTWarnLedgeReceivableQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.getReceivableFilter());
        exec.setObjectView(evi);
        return exec.getSQL();
    }

    private String getPayableSql(Context ctx) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.fm.nt.app", "NTWarnLedgePayableQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.getPayableFilter());
        exec.setObjectView(evi);
        return exec.getSQL();
    }

    private String getLetterOfCreditSql(Context ctx) throws BOSException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.fm.nt.app", "NTWarnLedgeCreditQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.getLetterOfCreditFilter());
        exec.setObjectView(evi);
        return exec.getSQL();
    }

    private Set getNTGroup(Context ctx) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (NoteKindEnum.receiptBill.equals((Object)this.p.getNoteKind())) {
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(6)));
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(4)));
            filter.setMaskString("#0 or #1");
        } else if (NoteKindEnum.remitBill.equals((Object)this.p.getNoteKind())) {
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(7)));
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(5)));
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(3)));
            filter.setMaskString("#0 or #1 or #2");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(6)));
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(4)));
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(7)));
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(5)));
            filter.getFilterItems().add(new FilterItemInfo("supergroup", (Object)new Integer(3)));
            filter.setMaskString("#0 or #1 or #2 or #3 or #4");
        }
        if (this.p.getNtIdSet() != null && this.p.getNtIdSet().size() > 0) {
            FilterInfo filterType = new FilterInfo();
            filterType.getFilterItems().add(new FilterItemInfo("id", (Object)this.p.getNtIdSet(), CompareType.INCLUDE));
            filter.mergeFilter(filterType, "AND");
        }
        evi.setFilter(filter);
        NTTypeCollection coll = NTTypeFactory.getLocalInstance(ctx).getNTTypeCollection(evi);
        if (coll == null || coll.size() <= 0) {
            return null;
        }
        HashSet<NTTypeGroupEnum> groupSet = new HashSet<NTTypeGroupEnum>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (coll.get(i).getSuperGroup() == null) continue;
            groupSet.add(coll.get(i).getSuperGroup());
        }
        return groupSet;
    }

    private FilterInfo getBaseFilter(String expiredDate) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (!FMHelper.isEmpty((Collection)this.p.getCompanyIdSet())) {
            filterItems.add(new FilterItemInfo("company.id", (Object)this.p.getCompanyIdSet(), CompareType.INCLUDE));
        } else {
            filterItems.add(new FilterItemInfo("company.id", (Object)this.company.getId()));
        }
        if (!FMHelper.isEmpty((Collection)this.p.getNtIdSet())) {
            filterItems.add(new FilterItemInfo("ntType.id", (Object)this.p.getNtIdSet(), CompareType.INCLUDE));
        }
        if (this.p.getCurrency() != null) {
            filterItems.add(new FilterItemInfo("currency.id", (Object)this.p.getCurrency().getId()));
        }
        Calendar calendar = Calendar.getInstance();
        if (this.p.getCurrentDate() != null) {
            calendar.setTime(this.p.getCurrentDate());
        }
        Calendar tmpCalendar = Calendar.getInstance();
        tmpCalendar.setTime(calendar.getTime());
        if (WarnCondTypeEnum.UNDUE.equals((Object)this.p.getPreWarnType())) {
            tmpCalendar.add(5, this.p.getPreWarnDays());
            filterItems.add(new FilterItemInfo(expiredDate, (Object)DateUtil.getSQLBegin((Date)calendar.getTime()), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo(expiredDate, (Object)DateUtil.getSQLEnd((Date)tmpCalendar.getTime()), CompareType.LESS));
        } else if (WarnCondTypeEnum.DUE.equals((Object)this.p.getPreWarnType())) {
            tmpCalendar.add(5, -this.p.getPreWarnDays());
            filterItems.add(new FilterItemInfo(expiredDate, (Object)DateUtil.getSQLBegin((Date)tmpCalendar.getTime()), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo(expiredDate, (Object)DateUtil.getSQLEnd((Date)calendar.getTime()), CompareType.LESS));
        }
        return filter;
    }

    private FilterInfo getChequeFilter() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        filter.getFilterItems().add(new FilterItemInfo("isAbandon", (Object)Constants.FALSE));
        filter.mergeFilter(this.getBaseFilter("applyRec.remindDate"), "AND");
        return filter;
    }

    private FilterInfo getRecChequeFilter() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        filter.mergeFilter(this.getBaseFilter("expiredDate"), "AND");
        return filter;
    }

    private FilterInfo getPayableFilter() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(5)));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(2)));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(6)));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(7)));
        filter.setMaskString("#0 or #1 or #2 or #3 or #4 or #5");
        filter.mergeFilter(this.getBaseFilter("ExpiredDate"), "AND");
        return filter;
    }

    private FilterInfo getReceivableFilter() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(8)));
        filter.setMaskString("#0 or #1");
        filter.mergeFilter(this.getBaseFilter("ExpiredDate"), "AND");
        return filter;
    }

    private FilterInfo getLetterOfCreditFilter() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("LetterStatus", (Object)new Integer("0")));
        filter.mergeFilter(this.getBaseFilter("expiredDate"), "AND");
        return filter;
    }
}

