/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.BillPoolJournalFactory;
import com.kingdee.eas.fm.ntp.BillPoolJournalInfo;
import com.kingdee.eas.fm.ntp.BizProcessTypeEnum;
import com.kingdee.eas.fm.ntp.DirectionEnum;
import com.kingdee.eas.fm.ntp.IPledgeBill;
import com.kingdee.eas.fm.ntp.PledgeBillFactory;
import com.kingdee.eas.fm.ntp.PledgeBillInfo;
import com.kingdee.eas.fm.ntp.PledgeBillStatusEnum;
import com.kingdee.eas.fm.ntp.PledgeTypeEnum;
import com.kingdee.eas.fm.ntp.PoolTypeEnum;
import com.kingdee.eas.fm.ntp.TrusteeInBillFactory;
import com.kingdee.eas.fm.ntp.TrusteeInBillInfo;
import com.kingdee.eas.fm.ntp.TrusteeOutBillFactory;
import com.kingdee.eas.fm.ntp.TrusteeOutBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class NtAutoOutPledgePool {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.NtAutoOutPledgePool");
    private static UserInfo userInfo = null;

    public static void autoCreatePoolJournal(Context ctx, IObjectCollection receivableColl, boolean isRp) throws EASBizException, BOSException {
        userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (isRp) {
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo receivableBillInfo = (ReceivableBillInfo)receivableColl.getObject(i);
                if (receivableBillInfo.getBillState() != BillStateEnum.POOLPLEDGE && receivableBillInfo.getBillState() != BillStateEnum.POOLTRUSTEE) continue;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("sourceBillID", (Object)receivableBillInfo.getId(), CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("recDate"));
                sic.add(new SelectorItemInfo("bizDate"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("actRecAmt"));
                sic.add(new SelectorItemInfo("company.id"));
                sic.add(new SelectorItemInfo("currency.id"));
                sic.add(new SelectorItemInfo("payeeBank.id"));
                sic.add(new SelectorItemInfo("payeeBank.name"));
                sic.add(new SelectorItemInfo("sourceBillId"));
                view.setSelector(sic);
                ReceivingBillCollection receivingColl = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillCollection(view);
                BillPoolJournalInfo journalInfo = NtAutoOutPledgePool.buildJournal4ReceivingInfo(ctx, receivingColl.get(0), receivableBillInfo);
                BillPoolJournalFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)journalInfo);
            }
        } else {
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo receivableBillInfo = (ReceivableBillInfo)receivableColl.getObject(i);
                if (receivableBillInfo.getBillState() != BillStateEnum.POOLPLEDGE && receivableBillInfo.getBillState() != BillStateEnum.POOLTRUSTEE) continue;
                BillPoolJournalInfo journalInfo = NtAutoOutPledgePool.buildJournal4ReceInfo(ctx, receivableBillInfo);
                BillPoolJournalFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)journalInfo);
                receivableBillInfo.setOutPoolDate(DateTimeUtils.truncateDate((Date)new Date()));
            }
        }
    }

    public static void removePoolJournal(Context ctx, Set idSet, boolean isRp) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (isRp) {
            filter.getFilterItems().add(new FilterItemInfo("receivingBillId", (Object)idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        }
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(11);
        state.add(12);
        filter.getFilterItems().add(new FilterItemInfo("BillLastState", state, CompareType.INCLUDE));
        view.setFilter(filter);
        ReceivableBillCollection receivableColl = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillCollection(view);
        for (int i = 0; i < receivableColl.size(); ++i) {
            String sql;
            ReceivableBillInfo receivableBillInfo = (ReceivableBillInfo)receivableColl.getObject(i);
            if (receivableBillInfo.getBillLastState() != BillStateEnum.POOLPLEDGE && receivableBillInfo.getBillLastState() != BillStateEnum.POOLTRUSTEE) continue;
            if (BillStateEnum.POOLTRUSTEE == receivableBillInfo.getBillLastState()) {
                sql = "update t_nt_receivablebill set FBillState=12,FBillLastState=4,FoutPoolDate=null,FTransferDate=null,FDigest=null where fid ='" + receivableBillInfo.getId() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            } else {
                sql = "update t_nt_receivablebill set FBillState=11,FBillLastState=4,FoutPoolDate=null,FTransferDate=null,FDigest=null where fid ='" + receivableBillInfo.getId() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            sql = " delete from T_NTP_BillPoolJournal where FBillID ='" + receivableBillInfo.getId() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    public static void autoOutPledgePool(Context ctx, Set idSet) throws EASBizException, BOSException {
        userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("discountBill.id", (Object)idSet, CompareType.INCLUDE));
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(12);
        state.add(3);
        filter.getFilterItems().add(new FilterItemInfo("billState", state, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection receivableColl = ReceivableBillFactory.getLocalInstance(ctx).getCollection(view);
        IPledgeBill iPledgeBill = null;
        iPledgeBill = PledgeBillFactory.getLocalInstance((Context)ctx);
        if (receivableColl.size() != 0) {
            for (int i = 0; i < receivableColl.size(); ++i) {
                BOSUuid pk;
                ReceivableBillInfo receivableBillInfo = (ReceivableBillInfo)receivableColl.getObject(i);
                if (receivableBillInfo.getBillState() == BillStateEnum.POOLPLEDGE || receivableBillInfo.getBillLastState() == BillStateEnum.POOLPLEDGE) {
                    PledgeBillInfo info = NtAutoOutPledgePool.buildPledgeInfo(ctx, receivableBillInfo);
                    iPledgeBill.save((CoreBaseInfo)info);
                    pk = info.getId();
                    receivableBillInfo.setOutPledgeID(pk.toString());
                    PledgeBillInfo pledgeBillInfo = PledgeBillFactory.getLocalInstance((Context)ctx).getPledgeBillInfo((IObjectPK)new ObjectUuidPK(pk));
                    BillPoolJournalInfo journalInfo = NtAutoOutPledgePool.buildJournalInfo(ctx, pledgeBillInfo);
                    BillPoolJournalFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)journalInfo);
                    continue;
                }
                if (receivableBillInfo.getBillState() != BillStateEnum.POOLTRUSTEE && receivableBillInfo.getBillLastState() != BillStateEnum.POOLTRUSTEE) continue;
                TrusteeOutBillInfo trusteeOutBillInfo = NtAutoOutPledgePool.buildTrusteeOutInfo(ctx, receivableBillInfo);
                pk = TrusteeOutBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)trusteeOutBillInfo);
                receivableBillInfo.setTrusteeOutBill(trusteeOutBillInfo);
                receivableColl.add((CoreBaseInfo)receivableBillInfo);
                BillPoolJournalInfo journalInfo = NtAutoOutPledgePool.buildTrustJournalInfo(ctx, trusteeOutBillInfo);
                BillPoolJournalFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)journalInfo);
            }
            ReceivableBillFactory.getLocalInstance(ctx).update(receivableColl);
        }
    }

    public static void removePoolTrust(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("discountBill.id", (Object)idSet, CompareType.INCLUDE));
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(12);
        filter.getFilterItems().add(new FilterItemInfo("BillLastState", state, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection receivableColl = ReceivableBillFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < receivableColl.size(); ++i) {
            ReceivableBillInfo receivableBillInfo = (ReceivableBillInfo)receivableColl.getObject(i);
            if (receivableBillInfo.getTrusteeOutBill() == null) continue;
            DbUtil.execute((Context)ctx, (String)("delete from T_NTP_BillPoolJournal where FBillID='" + receivableBillInfo.getTrusteeOutBill().getId() + "'"));
            TrusteeOutBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(receivableBillInfo.getTrusteeOutBill().getId()));
            receivableBillInfo.setTrusteeOutBill(null);
            receivableColl.add((CoreBaseInfo)receivableBillInfo);
        }
        ReceivableBillFactory.getLocalInstance(ctx).update(receivableColl);
    }

    private static BillPoolJournalInfo buildJournalInfo(Context ctx, PledgeBillInfo pledgeBillInfo) throws BOSException, EASBizException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(pledgeBillInfo.getCompany());
        journalInfo.setBillID(pledgeBillInfo.getId().toString());
        journalInfo.setBillNumber(pledgeBillInfo.getNumber());
        journalInfo.setBizDate(pledgeBillInfo.getPledgeDate());
        journalInfo.setCreateDate(pledgeBillInfo.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.PLEDGE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.PLEDGE_OUT);
        journalInfo.setDirection(DirectionEnum.OUTFLOW);
        journalInfo.setOutAmount(pledgeBillInfo.getAmount());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)pledgeBillInfo.getPledgee())) {
            BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(pledgeBillInfo.getPledgee().getId().toString()));
            journalInfo.setCooperativeBank(bankInfo);
            journalInfo.setCooperativeBankName(bankInfo.getName());
        }
        journalInfo.setCount(pledgeBillInfo.getCount());
        journalInfo.setCurrency(pledgeBillInfo.getCurrency());
        return journalInfo;
    }

    private static BillPoolJournalInfo buildTrustJournalInfo(Context ctx, TrusteeOutBillInfo trusteeOutBillInfo) throws BOSException, EASBizException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(trusteeOutBillInfo.getCompany());
        journalInfo.setBillID(trusteeOutBillInfo.getId().toString());
        journalInfo.setBillNumber(trusteeOutBillInfo.getNumber());
        journalInfo.setBizDate(trusteeOutBillInfo.getTrusteeDate());
        journalInfo.setCreateDate(trusteeOutBillInfo.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.TRUSTEE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEE_OUT);
        journalInfo.setDirection(DirectionEnum.OUTFLOW);
        journalInfo.setOutAmount(trusteeOutBillInfo.getTotalAmout());
        journalInfo.setCooperativeBank(trusteeOutBillInfo.getTrustee());
        journalInfo.setCooperativeBankName(trusteeOutBillInfo.getTrustee().getName());
        journalInfo.setCount(trusteeOutBillInfo.getCount());
        journalInfo.setCurrency(trusteeOutBillInfo.getCurrency());
        return journalInfo;
    }

    private static TrusteeOutBillInfo buildTrusteeOutInfo(Context ctx, ReceivableBillInfo receivableBillInfo) throws BOSException, EASBizException {
        TrusteeInBillInfo trusteeInBillInfo = TrusteeInBillFactory.getLocalInstance((Context)ctx).getTrusteeInBillInfo((IObjectPK)new ObjectUuidPK(receivableBillInfo.getTrusteeInBill().getId()), NtAutoOutPledgePool.getTrusteeInSelector());
        TrusteeOutBillInfo trusteeOutBillInfo = new TrusteeOutBillInfo();
        trusteeOutBillInfo.setBillState(PledgeBillStatusEnum.OUTPOOL);
        trusteeOutBillInfo.setBizDate(DateUtil.getDayBegin());
        trusteeOutBillInfo.setCurrency(trusteeInBillInfo.getCurrency());
        trusteeOutBillInfo.setNtType(trusteeInBillInfo.getNtType());
        trusteeOutBillInfo.setCompany(trusteeInBillInfo.getCompany());
        trusteeOutBillInfo.setTrustee(trusteeInBillInfo.getTrustee());
        String number = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = trusteeInBillInfo.getCompany().getId().toString();
        boolean hasRule = codingRuleManager.isExist((IObjectValue)trusteeOutBillInfo, strCompanyID);
        if (!hasRule) {
            throw new NTException(NTException.TRUSTEEOUTBILL_NO_CODINGRULE);
        }
        number = codingRuleManager.getNumber((IObjectValue)trusteeOutBillInfo, strCompanyID);
        trusteeOutBillInfo.setNumber(number);
        trusteeOutBillInfo.setCount(1);
        trusteeOutBillInfo.setTotalAmout(receivableBillInfo.getBillAmt());
        trusteeOutBillInfo.setBillMedium(trusteeInBillInfo.getBillMedium());
        trusteeOutBillInfo.setTrusteeDate(DateUtil.getDayBegin());
        trusteeOutBillInfo.setConfirmDate(DateUtil.getDayBegin());
        trusteeOutBillInfo.setAuditDate(DateUtil.getDayBegin());
        trusteeOutBillInfo.setAuditor(userInfo);
        trusteeOutBillInfo.setConfirmor(userInfo);
        return trusteeOutBillInfo;
    }

    private static PledgeBillInfo buildPledgeInfo(Context ctx, ReceivableBillInfo receivableBillInfo) throws BOSException, EASBizException {
        PledgeBillInfo info = new PledgeBillInfo();
        info.setPledgeType(PledgeTypeEnum.getEnum((int)2));
        info.setBillStatus(PledgeBillStatusEnum.getEnum((int)3));
        info.setNtType(receivableBillInfo.getNtType());
        info.setCurrency(receivableBillInfo.getCurrency());
        info.setCount(1);
        info.setCompany(receivableBillInfo.getCompany());
        info.setConfirmer(userInfo);
        info.setConfirmDate(DateUtil.getDayBegin());
        info.setAuditor(userInfo);
        info.setAuditDate(DateUtil.getDayBegin());
        return info;
    }

    private static BillPoolJournalInfo buildJournal4ReceInfo(Context ctx, ReceivableBillInfo receivableBillInfo) throws BOSException, EASBizException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(receivableBillInfo.getCompany());
        journalInfo.setBillNumber(receivableBillInfo.getDraftNumber());
        journalInfo.setBizDate(receivableBillInfo.getBizDate());
        journalInfo.setCreateDate(DateUtil.getDayBegin());
        if (BillStateEnum.POOLTRUSTEE == receivableBillInfo.getBillState()) {
            journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEE_REC);
            journalInfo.setPoolType(PoolTypeEnum.TRUSTEE);
        } else {
            journalInfo.setBizProcessType(BizProcessTypeEnum.PLEDGE_REC);
            journalInfo.setPoolType(PoolTypeEnum.PLEDGE);
        }
        journalInfo.setDirection(DirectionEnum.OUTFLOW);
        journalInfo.setOutAmount(receivableBillInfo.getBillAmt());
        journalInfo.setCooperativeBank(receivableBillInfo.getCooperativeBank());
        journalInfo.setCooperativeBankName(receivableBillInfo.getCooperativeBankName());
        journalInfo.setCount(1);
        journalInfo.setCurrency(receivableBillInfo.getCurrency());
        return journalInfo;
    }

    private static BillPoolJournalInfo buildJournal4ReceivingInfo(Context ctx, ReceivingBillInfo receivingBillInfo, ReceivableBillInfo receivableBillInfo) throws BOSException, EASBizException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCreateDate(receivingBillInfo.getBizDate());
        journalInfo.setBillNumber(receivingBillInfo.getNumber());
        if (BillStateEnum.POOLTRUSTEE == receivableBillInfo.getBillState()) {
            journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEE_REC);
            journalInfo.setPoolType(PoolTypeEnum.TRUSTEE);
        } else {
            journalInfo.setBizProcessType(BizProcessTypeEnum.PLEDGE_REC);
            journalInfo.setPoolType(PoolTypeEnum.PLEDGE);
        }
        journalInfo.setDirection(DirectionEnum.OUTFLOW);
        journalInfo.setOutAmount(receivingBillInfo.getActRecAmt());
        journalInfo.setCount(1);
        journalInfo.setBillID(receivingBillInfo.getId().toString());
        journalInfo.setCompany(receivingBillInfo.getCompany());
        journalInfo.setCurrency(receivingBillInfo.getCurrency());
        journalInfo.setCooperativeBank(receivingBillInfo.getPayeeBank());
        journalInfo.setCooperativeBankName(receivingBillInfo.getPayeeBank().getName());
        return journalInfo;
    }

    private static SelectorItemCollection getTrusteeInSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("billState");
        selector.add("auditor.id");
        selector.add("auditDate");
        selector.add("company.id");
        selector.add("trustee.id");
        selector.add("trusteeDate");
        selector.add("confirmDate");
        selector.add("totalAmout");
        selector.add("count");
        selector.add("currency.id");
        selector.add("trustee.name");
        selector.add("billMedium");
        return selector;
    }
}

