/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.DiscountBillCollection;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.OprtEnum;
import com.kingdee.eas.fm.nt.OprtLogFactory;
import com.kingdee.eas.fm.nt.OprtLogInfo;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillFactory;
import com.kingdee.eas.fm.nt.app.AbstractOprtLogFacadeControllerBean;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class OprtLogFacadeControllerBean
extends AbstractOprtLogFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.OprtLogFacadeControllerBean");

    @Override
    protected void _doLog(Context ctx, IObjectValue newInfo, String oldInfoId, OprtEnum newOprt, OprtEnum oldOprt) throws BOSException, EASBizException {
        this.doNewOprtLog(ctx, newInfo, newOprt, oldOprt);
        this.doOldOprtLog(ctx, newInfo, oldInfoId, newOprt, oldOprt);
    }

    private void doNewOprtLog(Context ctx, IObjectValue newInfo, OprtEnum newOprt, OprtEnum oldOprt) throws BOSException, EASBizException {
        if (newInfo == null || newOprt == null) {
            return;
        }
        ReceivableBillInfo info = (ReceivableBillInfo)newInfo;
        if (info.getBillState().equals((Object)BillStateEnum.TempSaved)) {
            return;
        }
        if (OprtEnum.SAVE.equals((Object)newOprt) && OprtEnum.RECEIVE.equals((Object)oldOprt)) {
            if (info.isIsTrustee()) {
                newOprt = OprtEnum.TRUST;
            }
            if (info.isIsPledge() && !info.isIsDisPledge()) {
                newOprt = OprtEnum.PLEDGE;
            }
        }
        boolean isSaveChanged = this.isSaveChanged(newOprt, oldOprt);
        OprtLogInfo logInfo = this.genOprtLogInfo(ctx, info, newOprt, info.getOprtLogDate(), isSaveChanged, true);
        OprtLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)logInfo);
        if (logInfo.getOprtState().equals((Object)OprtEnum.DISCOUNT)) {
            OprtLogInfo disIntLogInfo = (OprtLogInfo)logInfo.clone();
            disIntLogInfo.setId(null);
            String billId = logInfo.getBillId();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billId));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            DiscountBillCollection discountBillCollection = DiscountBillFactory.getLocalInstance(ctx).getDiscountBillCollection(evi);
            if (discountBillCollection == null || discountBillCollection.isEmpty()) {
                return;
            }
            DiscountBillInfo disBillInfo = discountBillCollection.get(0);
            disIntLogInfo.setOprtState(OprtEnum.DISCOUNTINT);
            disIntLogInfo.setChangeAmt(disBillInfo.getActDiscountInt());
            if (disBillInfo.getExRate() != null) {
                disIntLogInfo.setChangeLocalAmt(disBillInfo.getActDiscountInt().multiply(disBillInfo.getExRate()));
            } else {
                disIntLogInfo.setChangeLocalAmt(disBillInfo.getActDiscountInt());
            }
            OprtLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)disIntLogInfo);
        }
    }

    private OprtLogInfo genOprtLogInfo(Context ctx, ReceivableBillInfo info, OprtEnum oprt, Date oprtLogDate, boolean isSaveChanged, boolean isNew) throws BOSException, EASBizException {
        OprtLogInfo logInfo = new OprtLogInfo();
        if (oprtLogDate == null) {
            throw new BOSException("OprtLogDate is Null!");
        }
        if (info.getCompany() == null) {
            throw new BOSException("OprtLog getCompany is Null!");
        }
        if (info.getCurrency() == null) {
            throw new BOSException("OprtLog getCurrency is Null!");
        }
        if (info.getNtType() == null) {
            throw new BOSException("OprtLog getNtType is Null!");
        }
        logInfo.setCompany(info.getCompany());
        logInfo.setCurrency(info.getCurrency());
        logInfo.setNtType(info.getNtType());
        BigDecimal locAmt = null;
        if (info.getId() != null) {
            BillBaseInfo billInfo;
            AbstractObjectCollection billCollection;
            EntityViewInfo evi;
            FilterInfo filter;
            String billId = info.getId().toString();
            if (oprt.equals((Object)OprtEnum.DISCOUNT)) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billId));
                evi = new EntityViewInfo();
                evi.setFilter(filter);
                billCollection = DiscountBillFactory.getLocalInstance(ctx).getDiscountBillCollection(evi);
                if (billCollection != null && !billCollection.isEmpty()) {
                    billInfo = billCollection.get(0);
                    locAmt = billInfo.getLocalAmount();
                }
            }
            if (oprt.equals((Object)OprtEnum.RECEIVE)) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billId));
                evi = new EntityViewInfo();
                evi.setFilter(filter);
                billCollection = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillCollection(evi);
                if (billCollection != null && !billCollection.isEmpty()) {
                    billInfo = billCollection.get(0);
                    locAmt = billInfo.getActRecLocAmt();
                }
            }
            if (oprt.equals((Object)OprtEnum.ENDORSE)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("EndorseBill.*");
                ReceivableBillInfo billInfo2 = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
                if (billInfo2 != null) {
                    locAmt = billInfo2.getEndorseBill().getLocalAmount();
                }
            }
            if (oprt.equals((Object)OprtEnum.RETURN)) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("srcbillid", (Object)billId));
                evi = new EntityViewInfo();
                evi.setFilter(filter);
                billCollection = ReturnBillFactory.getLocalInstance(ctx).getReturnBillCollection(evi);
                if (billCollection != null && !billCollection.isEmpty()) {
                    billInfo = billCollection.get(0);
                    locAmt = billInfo.getLocAmount();
                }
            }
        }
        if (locAmt == null) {
            locAmt = info.getNaturalAmt();
        }
        if (isNew) {
            logInfo.setChangeAmt(info.getBillAmt());
            logInfo.setChangeLocalAmt(locAmt);
        } else {
            logInfo.setChangeAmt(info.getBillAmt().negate());
            logInfo.setChangeLocalAmt(locAmt.negate());
        }
        logInfo.setOprtState(oprt);
        if (info.getId() != null) {
            logInfo.setBillId(info.getId().toString());
        }
        logInfo.setIsSaveChanged(isSaveChanged);
        logInfo.setBizDate(oprtLogDate);
        return logInfo;
    }

    private boolean isSaveChanged(OprtEnum newOprt, OprtEnum oldOprt) {
        if (oldOprt == null) {
            return true;
        }
        if (newOprt == null) {
            return true;
        }
        return oldOprt.equals((Object)newOprt) && newOprt.equals((Object)OprtEnum.SAVE);
    }

    private void doOldOprtLog(Context ctx, IObjectValue newInfo, String oldInfoId, OprtEnum newOprt, OprtEnum oldOprt) throws BOSException, EASBizException {
        if (oldInfoId == null || oldOprt == null) {
            return;
        }
        ReceivableBillInfo oldInfo = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(oldInfoId));
        if (oldInfo.getBillState().equals((Object)BillStateEnum.TempSaved)) {
            return;
        }
        if (OprtEnum.RECEIVE.equals((Object)newOprt) && OprtEnum.SAVE.equals((Object)oldOprt)) {
            if (oldInfo.isIsTrustee()) {
                oldOprt = OprtEnum.TRUST;
            }
            if (oldInfo.isIsPledge() && !oldInfo.isIsDisPledge()) {
                oldOprt = OprtEnum.PLEDGE;
            }
        }
        Date oprtLogDate = null;
        oprtLogDate = newOprt != null && oldOprt.equals((Object)OprtEnum.SAVE) && oldOprt.equals((Object)newOprt) || newOprt == null ? oldInfo.getTakeDate() : ((ReceivableBillInfo)newInfo).getOprtLogDate();
        boolean isSaveChanged = this.isSaveChanged(newOprt, oldOprt);
        OprtLogInfo logInfo = this.genOprtLogInfo(ctx, oldInfo, oldOprt, oprtLogDate, isSaveChanged, false);
        OprtLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)logInfo);
        if (logInfo.getOprtState().equals((Object)OprtEnum.DISCOUNT)) {
            OprtLogInfo disIntLogInfo = (OprtLogInfo)logInfo.clone();
            disIntLogInfo.setId(null);
            String billId = logInfo.getBillId();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billId));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            DiscountBillCollection discountBillCollection = DiscountBillFactory.getLocalInstance(ctx).getDiscountBillCollection(evi);
            if (discountBillCollection == null || discountBillCollection.isEmpty()) {
                return;
            }
            DiscountBillInfo disBillInfo = discountBillCollection.get(0);
            disIntLogInfo.setOprtState(OprtEnum.DISCOUNTINT);
            disIntLogInfo.setChangeAmt(disBillInfo.getActDiscountInt().negate());
            if (disBillInfo.getExRate() != null) {
                disIntLogInfo.setChangeLocalAmt(disBillInfo.getActDiscountInt().negate().multiply(disBillInfo.getExRate()));
            } else {
                disIntLogInfo.setChangeLocalAmt(disBillInfo.getActDiscountInt().negate());
            }
            OprtLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)disIntLogInfo);
        }
    }
}

