/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.app.service.BankPayUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.BankBizInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.BankStateEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableApplyBillFactory;
import com.kingdee.eas.fm.nt.PayableApplyBillInfo;
import com.kingdee.eas.fm.nt.PayableApplyBillStateEnum;
import com.kingdee.eas.fm.nt.PayableApplyException;
import com.kingdee.eas.fm.nt.app.AbstractPayableApplyBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class PayableApplyBillControllerBean
extends AbstractPayableApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.PayableApplyBillControllerBean");

    public void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        model = this.setDefaultData(model);
        this.validateInputData(ctx, model, false);
        super._addnew(ctx, pk, model);
    }

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        model = this.setDefaultData(model);
        this.validateInputData(ctx, model, false);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.validateInputData(ctx, model, true);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PayableApplyBillInfo info = (PayableApplyBillInfo)PayableApplyBillFactory.getLocalInstance(ctx).getBillBaseInfo(pk);
        if (PayableApplyBillStateEnum.approve.equals((Object)info.getState())) {
            throw new PayableApplyException(PayableApplyException.NOT_DELETE);
        }
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PayableApplyBillInfo info = (PayableApplyBillInfo)this._getValue(ctx, pk);
        if (!info.getState().equals((Object)PayableApplyBillStateEnum.submit)) {
            throw new PayableApplyException(PayableApplyException.NOT_PASSAUDIT);
        }
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setState(PayableApplyBillStateEnum.approve);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _reverseAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PayableApplyBillInfo info = (PayableApplyBillInfo)this._getValue(ctx, pk);
        if (!info.getState().equals((Object)PayableApplyBillStateEnum.approve)) {
            throw new PayableApplyException(PayableApplyException.NOT_REVERSEAUDIT);
        }
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        ArrayList destList = iBotRelation.getDestObjIdByDestType(pk.toString(), null);
        if (null != destList && destList.size() > 0) {
            throw new PayableApplyException(PayableApplyException.IS_RELATION);
        }
        info.setAuditor(null);
        info.setState(PayableApplyBillStateEnum.submit);
        super._update(ctx, pk, (IObjectValue)info);
    }

    public IObjectValue setDefaultData(IObjectValue modle) {
        PayableApplyBillInfo info = (PayableApplyBillInfo)modle;
        info.setState(PayableApplyBillStateEnum.getEnum(0));
        info.setUsedAmount(new BigDecimal(0));
        info.setMakedCount(0);
        return info;
    }

    public void validateInputData(Context ctx, IObjectValue bill, boolean isUpdate) throws BOSException, EASBizException {
        String num;
        PayableApplyBillInfo info = (PayableApplyBillInfo)bill;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        if ((num = info.getNumber()) == null || num.trim().length() == 0) {
            throw new PayableApplyException(PayableApplyException.NUMBER_NULL);
        }
        if (null == info.getApplyDate()) {
            throw new PayableApplyException(PayableApplyException.APPLYDATE_NULL);
        }
        if (null == info.getNoteType()) {
            throw new PayableApplyException(PayableApplyException.NOTETYPE_NULL);
        }
        if (null == info.getApplyQuomodo()) {
            throw new PayableApplyException(PayableApplyException.APPLYQUOMODO_NULL);
        }
        if (null == info.getUsePayableCo()) {
            throw new PayableApplyException(PayableApplyException.USEPAYABLECO_NULL);
        }
        if (null == info.getMakeType()) {
            throw new PayableApplyException(PayableApplyException.MAKETYPE_NULL);
        }
        if (null == info.getStartDate()) {
            throw new PayableApplyException(PayableApplyException.STARTDATE_NULL);
        }
        if (null == info.getEndDate()) {
            throw new PayableApplyException(PayableApplyException.ENDDATE_NULL);
        }
        if (null == info.getCurrency()) {
            throw new PayableApplyException(PayableApplyException.CURRENCY_NULL);
        }
        if (null == info.getApplyAmount() || info.getApplyAmount().doubleValue() <= 0.0) {
            throw new PayableApplyException(PayableApplyException.APPLYAMOUNT);
        }
        if (info.getPayableCount() < 1) {
            throw new PayableApplyException(PayableApplyException.PAYABLECOUNT);
        }
        if (null == info.getProvideCo()) {
            throw new PayableApplyException(PayableApplyException.PROVIDECO_NULL);
        }
        if (null == info.getReceiverSp() && null == info.getReceiverCp() && (null == info.getReceiverName() || "".equals(info.getReceiverName().trim()))) {
            throw new PayableApplyException(PayableApplyException.RECEIVER_NULL);
        }
        if (null == info.getState()) {
            throw new PayableApplyException(PayableApplyException.NOTETYPE_NULL);
        }
        if (null == info.getUse() || info.getUse().trim().length() > 500) {
            // empty if block
        }
        this.validateNumber(ctx, info, isUpdate);
        this.validateDate(ctx, info);
    }

    private void validateNumber(Context ctx, PayableApplyBillInfo info, boolean isUpdate) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("applayCompany.id", (Object)currentCompany.getId().toString()));
        if (isUpdate) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    private void validateDate(Context ctx, PayableApplyBillInfo info) throws PayableApplyException {
        Date dateBegin = DateTimeUtils.truncateDate((Date)info.getStartDate());
        Date dateApplay = DateTimeUtils.truncateDate((Date)info.getApplyDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)info.getEndDate());
        if (!dateBegin.after(dateApplay) && !dateBegin.equals(dateApplay)) {
            throw new PayableApplyException(PayableApplyException.BEGIN_APPLY);
        }
        if (!dateEnd.after(dateBegin)) {
            throw new PayableApplyException(PayableApplyException.BEGIN_END);
        }
        info.setStartDate(dateBegin);
        info.setApplyDate(dateApplay);
        info.setEndDate(dateEnd);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        PayableApplyBillInfo sourceInfo = (PayableApplyBillInfo)srcBillVO;
        if (FMHelper.isInstanceof((String)bOTRelationInfo.getString("destobjectid"), AssureAmountInfo.class)) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                String sql = "update T_NT_PayableApplyBill set FisGenePayBill= ? where fid = ?";
                FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(true), srcBillPK.toString()});
            } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
                String sql = "update T_NT_PayableApplyBill set FisGenePayBill= ? where fid = ?";
                FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(false), srcBillPK.toString()});
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        PayableApplyBillInfo info = (PayableApplyBillInfo)value;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
        IObjectPK pk = super._submit(ctx, value);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)info);
        NTHelper.OnWaybgCtrl(ctx, pk.toString());
        return pk;
    }

    @Override
    protected void _submitBank(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PayableApplyBillInfo info = this.getPayableApplyBillInfo(ctx, pk);
        if (info == null) {
            return;
        }
        if (info.getState() != PayableApplyBillStateEnum.approve || info.getBankState() != BankStateEnum.NOSUBMIT && info.getBankState() != BankStateEnum.SUBMITFAIL) {
            throw new PayableApplyException(PayableApplyException.NOT_APPLY, new Object[]{info.getNumber()});
        }
        if (info.getProvideCoAccount() != null && info.getProvideCoAccount().isIsOnlyRead()) {
            throw new PayableApplyException(PayableApplyException.ISONLYREAD, new Object[]{info.getProvideCoAccount().getBankAccountNumber()});
        }
        logger.debug((Object)"begin to submit payableApplyBillInfo");
        BankStateEnum state = null;
        try {
            BankPayUtil bankPayUtil = new BankPayUtil();
            PayBody body = PayableApplyBillControllerBean.parsePayableApplyBody(ctx, info);
            BankBizInfo bizInfo = new BankBizInfo();
            bizInfo.setBankAcct("0000000000000000000");
            bizInfo.setBillType(BillTypeEnum.PAYMENT_BILL);
            PaymentDetail[] detail = bankPayUtil.pay(ctx, bizInfo, body);
            state = beServiceHelper.transferState((String)detail[0].getEbStatus()) != null ? BankStateEnum.SUBMITSUCCESS : BankStateEnum.SUBMITFAIL;
            this.reverseBillState(ctx, state, info.getId().toString());
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
        }
    }

    private void reverseBillState(Context ctx, BankStateEnum state, String id) throws BOSException, EASBizException {
        String sql = "Update T_NT_PayableApplyBill set FBankState =? where Fid=?";
        FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{String.valueOf(state.getValue()), id});
    }

    public static PayBody parsePayableApplyBody(Context ctx, PayableApplyBillInfo info) throws BOSException, EASBizException, RemoteException, ServiceException {
        PayBody body = new PayBody();
        body.setBatchBizNo(String.valueOf(beServiceHelper.getSerialNumber((int)1)[0]));
        body.setTotalAmount(String.valueOf(info.getApplyAmount()));
        body.setTotalCount("1");
        body.setVerifyField("pay");
        body.setDetails(PayableApplyBillControllerBean.parsePayableApplyDetail(ctx, info));
        return body;
    }

    public static PaymentDetail[] parsePayableApplyDetail(Context ctx, PayableApplyBillInfo info) {
        PaymentDetail[] details = new PaymentDetail[1];
        PaymentDetail detail = new PaymentDetail();
        detail.setDetailBizNo(beServiceHelper.getSerialNumber((int)1)[0]);
        detail.setPayeeAccName(info.getReceiverName());
        if (null != info.getReceiveBankName()) {
            detail.setPayeeBankName(info.getReceiveBankName());
        } else {
            detail.setPayeeBankName(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"19_BankDraftReqControllerBean", (Locale)ctx.getLocale()));
        }
        if (null != info.getReceiveCoAccount()) {
            detail.setPayeeAccNo(info.getReceiveCoAccount().getBankAccountNumber());
        } else {
            detail.setPayeeAccNo("0000000000000000");
        }
        detail.setPayeeCountry(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"18_BankDraftReqControllerBean", (Locale)ctx.getLocale()));
        detail.setPayeeProvince(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"20_BankDraftReqControllerBean", (Locale)ctx.getLocale()));
        detail.setPayeeCity(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"21_BankDraftReqControllerBean", (Locale)ctx.getLocale()));
        detail.setAmount(String.valueOf(info.getApplyAmount()));
        detail.setUrgent("TRUE");
        detail.setUseCode("-1");
        detail.setForceManual("TRUE");
        detail.setUse("\u7f51\u4e0a\u62a5\u9500");
        detail.setDesc(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"23_GuaranteeApplyControllerBean", (Locale)ctx.getLocale()));
        detail.setVerifyField("pay");
        detail.setPayeeType("company");
        details[0] = detail;
        return details;
    }
}

