/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillUsedCollection;
import com.kingdee.eas.fm.ctl.AssureBillUsedFactory;
import com.kingdee.eas.fm.ctl.AssureBillUsedInfo;
import com.kingdee.eas.fm.fin.BillTypeEnum;
import com.kingdee.eas.fm.fin.ControlWayEnum;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditFinancingReduceInfo;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailCollection;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.LimitTypeEnum;
import com.kingdee.eas.fm.fin.MortgageTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.WageEntryInfo;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.nt.AssureAmountCollection;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.AssureSourceEnum;
import com.kingdee.eas.fm.nt.AssureStateEnum;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IPayableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.PayableException;
import com.kingdee.eas.fm.nt.app.AbstractPayableBillWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayableBillWebFacadeControllerBean
extends AbstractPayableBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.PayableBillWebFacadeControllerBean");
    private static final String NT_RES = "com.kingdee.eas.fm.nt.NtResource";
    private static final String FINAutoGenerateResource = "com.kingdee.eas.fm.fin.FINAutoGenerateResource";
    private static final String NTAutoGenerateResource = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";

    @Override
    protected Map _save(Context ctx, PayableBillInfo info) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.setBaseProps(ctx, info);
        this.createGuaranteeEntrys(ctx, info);
        this.verifyGuaranteeEntrys(ctx, info);
        this.createReduceCol(ctx, info);
        IObjectPK pk = PayableBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        map.put("sucessMsg", ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"544_PayableBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        map.put("id", pk.toString());
        return map;
    }

    @Override
    protected Map _submit(Context ctx, PayableBillInfo info, boolean isCreatePayment) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.setBaseProps(ctx, info);
        info.setIsCreatePayment(isCreatePayment);
        this.createGuaranteeEntrys(ctx, info);
        this.createReduceCol(ctx, info);
        IObjectPK pk = PayableBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        map.put("sucessMsg", ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"74_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        map.put("id", pk.toString());
        return map;
    }

    @Override
    protected Map _beforeSave(Context ctx, boolean isSave, PayableBillInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (isSave) {
            this.checkPermission(ctx, info.getCompany(), "PayableBill_EDIT", "Permission_NO_Save");
        } else {
            this.checkPermission(ctx, info.getCompany(), "payable_submit", "Permission_NO_Submit");
        }
        this.setBaseProps(ctx, info);
        this.createGuaranteeEntrys(ctx, info);
        this.verify(ctx, info, isSave);
        this.verifyGuaranteeEntrys(ctx, info);
        this.showConfirm(ctx, info, map, isSave);
        return map;
    }

    protected void verify(Context ctx, PayableBillInfo info, boolean isSave) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((Object)info.getId()) && PayableBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            PayableBillInfo payable = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            info.setBillState(payable.getBillState());
        }
        boolean isAudit = info.getBillState() == PayableBillStateEnum.Audit;
        boolean isCanModifyDate = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT032", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        boolean isCanModifyDraftNumber = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT042", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        if (!(!isAudit || isCanModifyDate && isCanModifyDraftNumber && isSave)) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"isAudit")});
        }
        if (info.getPayee() == null && info.getPayee1() == null && info.getPayeeName() == null) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"473_PayableBillEditUI")});
        }
        if (info.getBillMaker() == null) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"570_prmtPayee_NULL")});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getOutBankAccount()) && !this.getMakeType(ctx, info.getCompany(), info).equals((Object)BillMakeTypeEnum.ENTRUST)) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"569_prmtCommerDraftAcct_NULL")});
        }
        Date dateAccept = info.getAcceptDate();
        Date dateBegin = info.getIssueDate();
        Date dateEnd = info.getExpiredDate();
        if (info.getDraftSource() != BillSourceEnum.BYECDS && dateAccept != null && (dateEnd != null && dateEnd.before(dateAccept) || dateBegin != null && dateBegin.after(dateAccept))) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"295_PayableBillAcceptUI")});
        }
        if (!dateEnd.after(dateBegin)) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"298_PayableBillEditUI")});
        }
        if (info.getAmount().compareTo(new BigDecimal(0)) <= 0) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"Amount_More_Zero")});
        }
        if (info.getPayeeName().length() > 80) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"476_PayableBillEditUI")});
        }
        if (!EmptyUtil.isEmpty((String)info.getPayeeAccountName()) && info.getPayeeAccountName().length() > 44) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"477_PayableBillEditUI")});
        }
        if (!EmptyUtil.isEmpty((Object)info.getHorizon()) && info.getHorizon().floatValue() <= 0.0f) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"478_PayableBillEditUI")});
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getOutBankAccount()) && info.getOutBankAccount().getName().length() > 255) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"479_PayableBillEditUI")});
        }
        if (info.getCreditLocalAmt() != null && info.getCreditLocalAmt().compareTo(info.getAmount()) > 0) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"Cannot_Save")});
        }
    }

    protected void showConfirm(Context ctx, PayableBillInfo info, Map<String, Object> map, boolean isSave) throws BOSException, EASBizException {
        boolean nt014;
        ArrayList<String> outAssureNumberList;
        if (info.getDraftSource() != BillSourceEnum.BYECDS) {
            Boolean isPapery = info.getBillMedium() == BillMediumEnum.PAPERY;
            if (isPapery.booleanValue() && info.getHorizon().compareTo(new BigDecimal("6")) > 0) {
                map.put("isCheckHorizon", true);
                map.put("checkHorizonSummaryMsg", CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"CheckPayableHorizon"));
            } else if (!isPapery.booleanValue() && info.getHorizon().compareTo(new BigDecimal("12")) > 0) {
                map.put("isCheckHorizon", true);
                map.put("checkHorizonSummaryMsg", CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"CheckPayableTimeHorizon"));
            }
        }
        if (info.getCreditLimit() != null && info.getCreditLimit().getSupplier() != null && info.getPayee() != null && !info.getPayee().getId().toString().equals(info.getCreditLimit().getSupplier().getId().toString())) {
            map.put("isCheckSupplier", true);
            map.put("checkSupplierSummaryMsg", CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"supplierSame"));
        }
        if ((info.getGuaranteeTypeInputMode() == GuaranteeTypeInputModeEnum.assure || info.getGuaranteeTypeInputMode() == GuaranteeTypeInputModeEnum.mix) && (outAssureNumberList = this.checkAssureLimit(ctx, info)).size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < outAssureNumberList.size(); ++i) {
                sb.append(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"AssureBillHasOutTip", (String[])new String[]{outAssureNumberList.get(i)}) + ";   ");
            }
            map.put("isCheckAssure", true);
            map.put("checkAssureSummaryMsg", CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"AssureBillHasOutTipSummary"));
            map.put("checkAssureDetailMsg", sb.toString());
        }
        for (GuaranteeDetailInfo guarDetailInfo : info.getGuaranteeEntrys()) {
            if (guarDetailInfo.getBilltype() != GuanTypeBillEnum.wage || guarDetailInfo.getBillId() == null) continue;
            WageInfo wageInfo = WageFactory.getLocalInstance((Context)ctx).getWageInfo((IObjectPK)new ObjectUuidPK(guarDetailInfo.getBillId()));
            BigDecimal hasWageAmt = new BigDecimal(String.valueOf(0));
            for (WageEntryInfo element : wageInfo.getEntrys()) {
                if (info.getBalance().compareTo(new BigDecimal(String.valueOf(0))) <= 0 || info.getId() == null || element.getBillid().toString().equals(info.getId().toString())) continue;
                hasWageAmt = hasWageAmt.add(element.getRealWage());
            }
            if (hasWageAmt.add(guarDetailInfo.getRealWage()).subtract(guarDetailInfo.getCanWage()).compareTo(new BigDecimal(String.valueOf(1.0E-4))) <= 0) continue;
            map.put("isCheckWage", true);
            map.put("checkWageSummaryMsg", CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"193_FinancingBillEditUI"));
        }
        if (!isSave && (nt014 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "NT014")).booleanValue()) && EmptyUtil.isEmpty((String)info.getRpBillId()) && (EmptyUtil.isEmpty((String)info.getSourceBillId()) || !BOSUuid.read((String)info.getSourceBillId()).getType().equals((Object)new PaymentBillInfo().getBOSType()))) {
            map.put("isCheckPayment", true);
            map.put("checkPaymentSummaryMsg", CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"isGenPaymentBill"));
        }
    }

    protected ArrayList<String> checkAssureLimit(Context ctx, PayableBillInfo info) throws BOSException, EASBizException {
        ArrayList<String> outAssureNumberList = new ArrayList<String>();
        HashMap<String, BigDecimal> guarIdRateMap = new HashMap<String, BigDecimal>();
        GuaranteeDetailCollection entrys = info.getGuaranteeEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            String billId;
            GuaranteeDetailInfo entry = entrys.get(i);
            if (entry.getGuaranteeTypeProperty() != GuaranteeTypePropertyEnum.assure || (billId = entry.getBillId()) == null) continue;
            BigDecimal scale = entry.getScale();
            if (guarIdRateMap.keySet().contains(billId)) {
                scale = scale.add((BigDecimal)guarIdRateMap.get(billId));
            }
            guarIdRateMap.put(billId, scale);
        }
        Set idSet = guarIdRateMap.keySet();
        for (String guarId : idSet) {
            AssureBillInfo assInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(guarId));
            BigDecimal asLocalLimitAmt = assInfo.getAsLocalLimitAmt();
            BigDecimal bizLocalBalance = assInfo.getBizLocalBalance();
            if (info.getId() != null) {
                BigDecimal finAmt = BigDecimal.ZERO;
                AssureBillUsedCollection usedcoll = AssureBillUsedFactory.getLocalInstance((Context)ctx).getAssureBillUsedCollection("where FinbillId = '" + info.getId().toString() + "'");
                for (int i = 0; i < usedcoll.size(); ++i) {
                    AssureBillUsedInfo usedInfo = usedcoll.get(i);
                    finAmt = finAmt.add(usedInfo.getUsedAssAmount());
                }
                bizLocalBalance = bizLocalBalance.subtract(finAmt);
            }
            BigDecimal balance = asLocalLimitAmt.subtract(bizLocalBalance);
            BigDecimal scale = (BigDecimal)guarIdRateMap.get(guarId);
            scale = scale.divide(new BigDecimal(100));
            if (info.getAmount().multiply(scale).compareTo(balance) != 1) continue;
            outAssureNumberList.add(assInfo.getNumber());
        }
        return outAssureNumberList;
    }

    protected BillMakeTypeEnum getMakeType(Context ctx, CompanyOrgUnitInfo currCompany, PayableBillInfo info) throws BOSException, EASBizException {
        if (currCompany != null && info.getBillMaker() != null && info.getApplyUnit() != null) {
            if (!currCompany.getName().equals(info.getBillMaker().getName()) && !currCompany.getName().equals(info.getApplyUnit().getName())) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"hasTheSameCompany")});
            }
            String companyName = currCompany.getName();
            if (companyName.equals(info.getBillMakerName()) && companyName.equals(info.getApplyUnit().getName())) {
                return BillMakeTypeEnum.SELF;
            }
            if (companyName.equals(info.getBillMakerName()) && !companyName.equals(info.getApplyUnit().getName())) {
                return BillMakeTypeEnum.SUB;
            }
            return BillMakeTypeEnum.ENTRUST;
        }
        return BillMakeTypeEnum.SELF;
    }

    private void setBaseProps(Context ctx, PayableBillInfo info) throws BOSException, EASBizException {
        info.setApplyUnit(info.getCompany());
        info.setMakeType(this.getMakeType(ctx, info.getCompany(), info));
        info.setType(info.getNtType().getFinanceType());
        info.setAmountLocalCur(info.getAmount());
        info.setLocalCurExRate(new BigDecimal(1));
    }

    @Override
    protected Map _audit(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        HashSet<String> idSet = new HashSet<String>();
        String[] idsArray = id.split(",");
        for (int i = 0; i < idsArray.length; ++i) {
            idSet.add(idsArray[i]);
        }
        try {
            PayableBillInfo info = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
            this.checkPermission(ctx, info.getCompany(), "PayableBill_Audit", "Permission_NO_Audit");
            PayableBillFactory.getLocalInstance(ctx).audit(idSet);
            String summaryMsg = CASWebUtil.getResource((Context)ctx, (String)"AUDIT_SUCCESS");
            pageModel.put("error", 0);
            pageModel.put("id", id);
            pageModel.put("summaryMsg", summaryMsg);
        }
        catch (Exception e) {
            logger.error((Object)e);
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    @Override
    protected Map _antiAudit(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        HashSet<String> idSet = new HashSet<String>();
        String[] idsArray = id.split(",");
        for (int i = 0; i < idsArray.length; ++i) {
            idSet.add(idsArray[i]);
        }
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId());
            Map map = new HashMap();
            PayableBillInfo info = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
            this.checkPermission(ctx, info.getCompany(), "PayableBill_CancelAudit", "Permission_NO_CancelAudit");
            map = PayableBillFactory.getLocalInstance(ctx).cancelAudit(idSet, (IObjectPK)userPK);
            String summaryMsg = CASWebUtil.getResource((Context)ctx, (String)"UNAUDIT_SUCCESS");
            if (map.size() != 0) {
                StringBuffer msg = new StringBuffer();
                pageModel.put("error", 1);
                for (Map.Entry entry : map.entrySet()) {
                    msg.append((String)entry.getKey() + ":" + (String)entry.getValue());
                }
                pageModel.put("msg", msg);
                return pageModel;
            }
            pageModel.put("error", 0);
            pageModel.put("id", id);
            pageModel.put("summaryMsg", summaryMsg);
        }
        catch (Exception e) {
            logger.error((Object)e);
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    @Override
    protected Map _beforeSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Boolean> com_nt014Map = new HashMap<String, Boolean>();
        PayableBillCollection coll = this.getPayableColl(ctx, ids);
        for (int i = 0; i < coll.size(); ++i) {
            boolean nt014;
            PayableBillInfo info = coll.get(i);
            if (com_nt014Map.get(info.getCompany().getId().toString()) == null) {
                nt014 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "NT014"));
                com_nt014Map.put(info.getCompany().getId().toString(), nt014);
            }
            if (!(nt014 = ((Boolean)com_nt014Map.get(info.getCompany().getId().toString())).booleanValue()) || !EmptyUtil.isEmpty((String)info.getRpBillId()) || !EmptyUtil.isEmpty((String)info.getSourceBillId()) && BOSUuid.read((String)info.getSourceBillId()).getType().equals((Object)new PaymentBillInfo().getBOSType())) continue;
            map.put("isCheckPayment", true);
            map.put("checkPaymentSummaryMsg", CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"isGenPaymentBill"));
            break;
        }
        return map;
    }

    @Override
    protected Map _batchSubmit(Context ctx, String[] ids, boolean isCreatePayment) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        PayableBillCollection coll = this.getPayableColls(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), "payable_submit", "Permission_NO_Submit", permissionSet);
                if (info.getBillState() != PayableBillStateEnum.TempSaved) {
                    throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"status_Not_Save")});
                }
                if (EmptyUtil.isEmpty((String)info.getDraftNumber()) && !info.getDraftSource().equals((Object)BillSourceEnum.BYECDS) && isCreatePayment) {
                    throw new NTException(NTException.DRAFTNUMBERNOTNULL);
                }
                if (info.getRpBillId() == null && isCreatePayment) {
                    info.setIsCreatePayment(new Boolean(true));
                } else {
                    info.setIsCreatePayment(new Boolean(false));
                }
                info.setBatchNo("");
                info.setBatchAssureAmount(Constants.ZERO);
                info.setBatchNaturalAmount(Constants.ZERO);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billID", (Object)info.getId().toString()));
                view.setFilter(filter);
                info.setReduceCol(CreditFinancingReduceFactory.getLocalInstance((Context)ctx).getCreditFinancingReduceCollection(view));
                PayableBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"Payable_SUBMIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"Payable_SUBMIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        PayableBillCollection coll = this.getPayableColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), "PayableBill_Audit", "Permission_NO_Audit", permissionSet);
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                PayableBillFactory.getLocalInstance(ctx).audit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"Payable_AUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"Payable_AUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map batchAntiAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        PayableBillCollection coll = this.getPayableColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        boolean hasInitParam = false;
        boolean isCancelAuditorSameAsAuditor = false;
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), "PayableBill_CancelAudit", "Permission_NO_CancelAudit", permissionSet);
                if (info.isFiVouchered()) {
                    throw new NTException(NTException.CHEQUEISFIVOUCHERED);
                }
                if (!hasInitParam) {
                    isCancelAuditorSameAsAuditor = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT013", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                    hasInitParam = true;
                }
                if (info.getBillState() != PayableBillStateEnum.Audit) {
                    throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"status_Not_Audit")});
                }
                if (isCancelAuditorSameAsAuditor && !userInfo.getId().toString().equals(info.getAuditor().getId().toString())) {
                    throw new NTException(NTException.CANCELAUDITORNOTSAMEASAUDITOR);
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("sourcebillid", (Object)info.getId().toString()));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                AssureAmountCollection assureColl = AssureAmountFactory.getLocalInstance(ctx).getAssureAmountCollection(view);
                if (assureColl.size() != 0 && (assureColl.size() != 1 || assureColl.get(0).getSeq() != 0L)) {
                    throw new NTException(NTException.HASDESTBILL, new Object[]{info.getNumber()});
                }
                if (assureColl.size() > 0) {
                    AssureAmountInfo assureAmount = assureColl.get(0);
                    if (AssureSourceEnum.PAYABLEBILLREQ != assureAmount.getAssureSource()) {
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)assureAmount.getId().toString(), CompareType.EQUALS));
                        if (assureAmount != null && !assureAmount.getAssureState().equals((Object)AssureStateEnum.SAVED)) {
                            throw new NTException(NTException.ASSUREAMOUNTSTATE_ISNOT_SAVED, new String[]{info.getDraftNumber()});
                        }
                        AssureAmountFactory.getLocalInstance(ctx).delete(filterInfo);
                    }
                    if (assureAmount.getAssureSource() == AssureSourceEnum.MANUAL) {
                        throw new NTException(NTException.CANNOT_CANCELAUDIT);
                    }
                    IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                    botRelation.removeRelationByDestObjId(assureAmount.getId().toString(), info.getBOSType().toString());
                }
                DbUtil.execute((Context)ctx, (String)"update t_nt_payablebill set FBillState=?,FBillLastState=?, FAuditorID=null  where FId=?", (Object[])new Object[]{new Integer(4), new Integer(5), info.getId().toString()});
                PayableBillFactory.getLocalInstance(ctx).antiAudit4WF((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"Payable_CancelAudit_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"Payable_CancelAudit_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected void _beforePayableCash(Context ctx, String[] ids) throws BOSException, EASBizException {
        PayableBillCollection coll = this.getPayableColl(ctx, ids);
        this.checkPermission(ctx, coll.get(0).getCompany(), "PayableBill_CreateTo", "Not_CreateTo_Permission");
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo payableInfo = coll.get(i);
            if (!payableInfo.getCompany().getId().toString().equals(coll.get(0).getCompany().getId().toString())) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"company_Not_same")});
            }
            if (ElecBillStatusEnum.NT000002 == payableInfo.getElecBillStatus()) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"exist_invalid_PayableBill")});
            }
            if (payableInfo.getBillState() == PayableBillStateEnum.CASH) {
                throw new PayableException(PayableException.HASCASH);
            }
            if (payableInfo.getBillState() != PayableBillStateEnum.Audit && payableInfo.getBillState() != PayableBillStateEnum.InTransfer && payableInfo.getBillState() != PayableBillStateEnum.OutTransfer && payableInfo.getBillState() != PayableBillStateEnum.Discount) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"exist_state_PayableBill", (String[])new String[]{payableInfo.getBillState().getAlias()})});
            }
            if (payableInfo.getConfirmer() == null && !payableInfo.isIsFromEntrust() && payableInfo.getMakeType() == BillMakeTypeEnum.SUB) {
                throw new PayableException(PayableException.NOTCASH4NOCONFIRM);
            }
            if (payableInfo.getMakeType() != BillMakeTypeEnum.ENTRUST) continue;
            throw new PayableException(PayableException.NOTCASH4ENTRUST);
        }
    }

    @Override
    protected Map _batchRepayment(Context ctx, RepaymentInfo info, boolean isCreatePayment) throws BOSException, EASBizException {
        List list = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)info.get("entrys")), List.class);
        HashMap<String, Integer> payable_seqMap = new HashMap<String, Integer>();
        HashMap<String, String> payable_bankAcctMap = new HashMap<String, String>();
        HashSet<String> bankAcctSet = new HashSet<String>();
        this.beforeBatchRepayment(ctx, list, payable_seqMap, payable_bankAcctMap, bankAcctSet);
        Map<String, AccountBankInfo> bankAcctMap = this.getBankAcctMap(ctx, bankAcctSet);
        PayableBillCollection payableColl = this.getPayableColl(ctx, payable_seqMap.keySet());
        boolean nt014 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "NT014"));
        RepaymentCollection repayColl = new RepaymentCollection();
        for (int i = 0; i < payableColl.size(); ++i) {
            ExchangeRateInfo rateInfo;
            PayableBillInfo payableInfo = payableColl.get(i);
            RepaymentInfo repayInfo = new RepaymentInfo();
            if (payableColl.size() == 1) {
                repayInfo.setId(info.getId());
            }
            repayInfo.setCompany(payableInfo.getCompany());
            repayInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
            repayInfo.setCreator(info.getCreator());
            repayInfo.setRemark(payableInfo.getRemark());
            repayInfo.setBizDate(info.getBizDate());
            repayInfo.setFundFlowItem(info.getFundFlowItem());
            repayInfo.setDescription(info.getDescription());
            repayInfo.setSourceType(FinancingBillTypeEnum.CommercialDraft);
            repayInfo.setCTLCancel(false);
            repayInfo.setCreditor(payableInfo.getInstitution());
            repayInfo.setRegion(payableInfo.getRegion());
            repayInfo.setCurrency(payableInfo.getCurrency());
            repayInfo.setAmount(payableInfo.getBalance());
            repayInfo.setLocalCurExRate(payableInfo.getLocalCurExRate());
            repayInfo.setApplyUnit(payableInfo.getApplyUnit());
            repayInfo.setMakeType(payableInfo.getMakeType());
            repayInfo.setCreditorCompany(payableInfo.getInstitutionCompany());
            repayInfo.setSourceAmount(payableInfo.getAmount());
            repayInfo.setSourceBillId(payableInfo.getId().toString());
            repayInfo.setSourceCurrency(payableInfo.getCurrency());
            repayInfo.setSourceBillNum(payableInfo.getNumber());
            repayInfo.setPayee(payableInfo.getPayee());
            repayInfo.setPayeeCust(payableInfo.getPayee1());
            repayInfo.setLoanAcct(payableInfo.getBillAccount());
            repayInfo.setSourceBillNum(payableInfo.getDraftNumber());
            repayInfo.setAddAmount(payableInfo.getAmount());
            repayInfo.setEndDate(payableInfo.getExpiredDate());
            repayInfo.setReturnedQuota(payableInfo.getUsedQuota());
            repayInfo.setCreditLimit(payableInfo.getCreditLimit());
            repayInfo.setIsIncredit(payableInfo.isIsInCredit());
            repayInfo.setCreditCurExRate(payableInfo.getCreditCurExRate());
            repayInfo.setCreatePayment(false);
            if (isCreatePayment && payableInfo.getMakeType() == BillMakeTypeEnum.SELF && !info.isIsGenPayBill() && nt014) {
                repayInfo.setCreatePayment(true);
            }
            repayInfo.setSourceCurExRate(FMConstants.ONE);
            if (!(FMHelper.isEmpty((CoreBaseInfo)repayInfo.getSourceCurrency()) || FMHelper.isEmpty((CoreBaseInfo)repayInfo.getCurrency()) || FMHelper.isEmpty((CoreBaseInfo)(rateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)repayInfo.getSourceCurrency(), (CurrencyInfo)repayInfo.getCurrency(), (CompanyOrgUnitInfo)repayInfo.getCompany(), (Date)repayInfo.getBizDate()))))) {
                repayInfo.setSourceCurExRate(rateInfo.getConvertRate());
            }
            repayInfo.setBankAcct(bankAcctMap.get(payable_bankAcctMap.get(payableInfo.getId().toString())));
            repayInfo.setBank(repayInfo.getBankAcct().getBank());
            if (repayInfo.getBank() != null && repayInfo.getBank().getBankAreaType() != null) {
                repayInfo.setRegion(repayInfo.getBank().getBankAreaType());
            } else {
                repayInfo.setRegion(BankAreaTypeEnum.In);
            }
            repayInfo.setCreditPercetage(FMConstants.ONE_HUNDRED);
            repayInfo.setRepaySeq(1);
            repayInfo.setLocalAmount(FMHelper.multiply((BigDecimal)repayInfo.getAmount(), (BigDecimal)repayInfo.getLocalCurExRate()));
            repayInfo.setNtType(payableInfo.getNtType());
            repayColl.add(repayInfo);
        }
        if (repayColl.size() == 1 && repayColl.get(0).getId() != null && RepaymentFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(repayColl.get(0).getId()))) {
            RepaymentFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)repayColl.get(0));
        } else {
            PayableBillFactory.getLocalInstance(ctx).batchRepayment(repayColl, payableColl, false);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sucessMsg", ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"74_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        return map;
    }

    protected void beforeBatchRepayment(Context ctx, List<Map<String, Object>> list, Map<String, Integer> payable_seqMap, Map<String, String> payable_bankAcctMap, Set<String> bankAcctSet) throws PayableException {
        if (list.size() == 0) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"entry_Not_Null")});
        }
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> entry = list.get(i);
            Map payableBill = (Map)entry.get("draftNumber");
            if (payableBill == null) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"draftNumber_Not_Null")});
            }
            Map bankAcct = (Map)entry.get("bankAcct");
            if (bankAcct == null) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"bankAcct_Not_Null")});
            }
            String payableId = (String)payableBill.get("id");
            Integer seq = payable_seqMap.get(payableId);
            if (seq != null) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"entry_repeat", (String[])new String[]{String.valueOf(seq), String.valueOf(i + 1)})});
            }
            payable_seqMap.put(payableId, i + 1);
            String bankAcctId = (String)bankAcct.get("id");
            payable_bankAcctMap.put(payableId, bankAcctId);
            bankAcctSet.add(bankAcctId);
        }
    }

    @Override
    protected Map _beforeCashSubmit(Context ctx, RepaymentInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean nt014 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "NT014"));
        if (!nt014 || info.isIsGenPayBill()) {
            return map;
        }
        List list = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)info.get("entrys")), List.class);
        HashMap<String, Integer> payable_seqMap = new HashMap<String, Integer>();
        HashMap<String, String> payable_bankAcctMap = new HashMap<String, String>();
        HashSet<String> bankAcctSet = new HashSet<String>();
        this.beforeBatchRepayment(ctx, list, payable_seqMap, payable_bankAcctMap, bankAcctSet);
        PayableBillCollection payableColl = this.getPayableColl(ctx, payable_seqMap.keySet());
        for (int i = 0; i < payableColl.size(); ++i) {
            PayableBillInfo payableInfo = payableColl.get(i);
            if (payableInfo.getMakeType() != BillMakeTypeEnum.SELF) continue;
            map.put("isCheckPayment", true);
            map.put("checkPaymentSummaryMsg", CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"isGenPaymentBill"));
            break;
        }
        return map;
    }

    @Override
    protected Map _unPayableCash(Context ctx, String[] payableBillIds) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        PayableBillCollection coll = this.getPayableColl(ctx, payableBillIds);
        Map<String, RepaymentInfo> map = this.getPayable_RepaymentMap(ctx, payableBillIds);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            String repaymentNumber = "";
            try {
                if (info.getBillState() != PayableBillStateEnum.CASH) {
                    throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"status_Not_cash")});
                }
                RepaymentInfo repayment = map.get(info.getId().toString());
                if (EmptyUtil.isEmpty((CoreBaseInfo)repayment)) {
                    throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"already_ubPayableCash")});
                }
                repaymentNumber = CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"repayment_delete_error", (String[])new String[]{repayment.getNumber()});
                RepaymentFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(repayment.getId().toString()));
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"UNPayableCash_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber(), repaymentNumber}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"ALL_UNPayableCash_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"UNPayableCash_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected void _beforeAddAssure(Context ctx, String payableBillId) throws BOSException, EASBizException {
        boolean doNextTask;
        PayableBillInfo info = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(payableBillId));
        if (info.getMakeType() == BillMakeTypeEnum.ENTRUST) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"CannotAddAssure")});
        }
        boolean isAudited = info.getBillState() == PayableBillStateEnum.Audit;
        boolean inTransfer = info.getBillState() == PayableBillStateEnum.InTransfer;
        boolean outTransfer = info.getBillState() == PayableBillStateEnum.OutTransfer;
        boolean isDiscount = info.getBillState() == PayableBillStateEnum.Discount;
        boolean bl = doNextTask = isAudited || inTransfer || outTransfer || isDiscount;
        if (!doNextTask) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"validBill")});
        }
        if (info.getBalance().compareTo(Constants.ZERO) == 0) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"balanceZero")});
        }
        if (ElecBillStatusEnum.NT000002 == info.getElecBillStatus()) {
            throw new PayableException(PayableException.COMMON, new Object[]{info.getElecBillStatus().getAlias()});
        }
    }

    @Override
    protected void _beforeAppointAssure(Context ctx, String payableBillId) throws BOSException, EASBizException {
        PayableBillInfo info = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(payableBillId), this.getSelector());
        this.checkPermission(ctx, info.getCompany(), "payable_appointAssure", "Not_appointAssure_Permission");
        if (info.getOriAssureAmount().compareTo(BigDecimal.ZERO) == 1) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"OriAssureAmount_More_Zero")});
        }
        if (info.getBillState() != PayableBillStateEnum.Audit) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"Not_Audit")});
        }
        if (info.getAssureAmount().compareTo(BigDecimal.ZERO) != 0) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"AssureAmount_Not_Zero")});
        }
    }

    @Override
    protected Map _appointAssure(Context ctx, String payableBillId, String assureAmountId) throws BOSException, EASBizException {
        IPayableBill iPayableBill = PayableBillFactory.getLocalInstance(ctx);
        boolean isExist = iPayableBill.exists((IObjectPK)new ObjectUuidPK(payableBillId));
        if (!isExist) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"PayableBill_Not_Exist")});
        }
        PayableBillInfo payableInfo = iPayableBill.getPayableBillInfo((IObjectPK)new ObjectUuidPK(payableBillId));
        iPayableBill.appointAssure(payableInfo, assureAmountId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sucessMsg", ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"545_PayableBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        return map;
    }

    @Override
    protected Map _cancelAppiontAssure(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        PayableBillCollection coll = this.getPayableColl(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getCompany(), "payable_cancelAppointAssure", "Not_cancelAppointAssure_Permission", permissionSet);
                if (info.getBillState() != PayableBillStateEnum.Audit) {
                    throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"status_Not_Audit")});
                }
                PayableBillFactory.getLocalInstance(ctx).cancelAppointAssure(info);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"CancelAppiontAssure_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"ALL_CancelAppiontAssure_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"CancelAppiontAssure_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected void _beforeVoucher(Context ctx, String[] ids) throws BOSException, EASBizException {
        PayableBillCollection coll = this.getPayableColl(ctx, ids);
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            BOSObjectType bosType;
            boolean canVoucher;
            PayableBillInfo info = coll.get(i);
            this.checkPermission(ctx, info.getCompany(), "PayableBill_CrteateVoucher", "Not_Voucher_Permission", permissionSet);
            if (info.isFiVouchered()) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"PayableBill_IsVoucher", (String[])new String[]{info.getNumber()})});
            }
            boolean isAudited = info.getBillState() == PayableBillStateEnum.Audit;
            boolean inTransfer = info.getBillState() == PayableBillStateEnum.InTransfer;
            boolean outTransfer = info.getBillState() == PayableBillStateEnum.OutTransfer;
            boolean isDiscount = info.getBillState() == PayableBillStateEnum.Discount;
            boolean isABANDON = info.getBillState() == PayableBillStateEnum.ABANDON;
            boolean bl = canVoucher = isAudited || inTransfer || outTransfer || isDiscount || isABANDON;
            if (!canVoucher) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"state_canNot_Voucher", (String[])new String[]{info.getNumber()})});
            }
            if (info.getSourceBillId() != null && (bosType = BOSUuid.read((String)info.getSourceBillId().toString()).getType()).equals((Object)new PaymentBillInfo().getBOSType())) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"PayableBill_FromPayment", (String[])new String[]{info.getNumber()})});
            }
            if (!EmptyUtil.isEmpty((String)info.getRpBillId())) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"PayableBill_RpBillId", (String[])new String[]{info.getNumber()})});
            }
            if (info.getMakeType() != BillMakeTypeEnum.SUB || info.getConfirmer() != null || info.isIsFromEntrust()) continue;
            throw new PayableException(PayableException.NOVOUCHER4NOCONFIRM);
        }
    }

    protected PayableBillCollection getPayableColl(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(view);
    }

    protected PayableBillCollection getPayableColls(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(view);
    }

    protected PayableBillCollection getPayableColl(Context ctx, Set payableSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)payableSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(view);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        return sic;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("oriAssureAmount"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("oppAccount.isCash"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("Institution.isBank"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.CU"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        return sic;
    }

    protected Map<String, RepaymentInfo> getPayable_RepaymentMap(Context ctx, String[] payableBillIds) throws EASBizException, BOSException {
        HashMap<String, RepaymentInfo> map = new HashMap<String, RepaymentInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillID", (Object)FMHelper.Array2Set((String[])payableBillIds), CompareType.INCLUDE));
        view.setFilter(filter);
        RepaymentCollection rePayColl = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentCollection(view);
        if (rePayColl != null && rePayColl.size() > 0) {
            for (int i = 0; i < rePayColl.size(); ++i) {
                RepaymentInfo info = rePayColl.get(i);
                map.put(info.getSourceBillId(), info);
            }
        }
        return map;
    }

    protected Map<String, AccountBankInfo> getBankAcctMap(Context ctx, Set bankAcctSet) throws EASBizException, BOSException {
        HashMap<String, AccountBankInfo> map = new HashMap<String, AccountBankInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.getBankAreaType"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankAcctSet, CompareType.INCLUDE));
        view.setFilter(filter);
        AccountBankCollection accountBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        for (int i = 0; i < accountBankColl.size(); ++i) {
            AccountBankInfo bankAcct = accountBankColl.get(i);
            map.put(bankAcct.getId().toString(), bankAcct);
        }
        return map;
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource, Set<String> permissionSet) throws EASBizException, BOSException {
        if (!permissionSet.contains(company.getId().toString())) {
            this.checkPermission(ctx, company, checkPermissionName, exceptionResource);
            permissionSet.add(company.getId().toString());
        }
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)checkPermissionName);
        if (!isPermission) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)exceptionResource, (String[])new String[]{company.getName()})});
        }
    }

    private void createGuaranteeEntrys(Context ctx, PayableBillInfo info) throws BOSException {
        info.getGuaranteeEntrys().clear();
        List assureEntrys = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)info.get("assureentrys")), List.class);
        for (int i = 0; i < assureEntrys.size(); ++i) {
            Map entry = (Map)assureEntrys.get(i);
            GuaranteeDetailInfo guarantInfo = new GuaranteeDetailInfo();
            guarantInfo.setParentBillId((FinancingBillInfo)info);
            guarantInfo.setParentBillType(BillTypeEnum.PAYABLEBILL);
            if (!EmptyUtil.isEmpty(entry.get("billNumber"))) {
                Map entryBill = (Map)entry.get("billNumber");
                guarantInfo.setBillId((String)entryBill.get("id"));
                guarantInfo.setBillNumber((String)entryBill.get("number"));
                guarantInfo.setBilltype(GuanTypeBillEnum.AssureBill);
            }
            guarantInfo.setScale(new BigDecimal(String.valueOf(entry.get("scale") == null ? Integer.valueOf(0) : entry.get("scale"))));
            guarantInfo.setAmount(new BigDecimal(String.valueOf(entry.get("amount") == null ? Integer.valueOf(0) : entry.get("amount"))));
            guarantInfo.setBalance(new BigDecimal(String.valueOf(entry.get("assureCfgFee") == null ? Integer.valueOf(0) : entry.get("assureCfgFee"))));
            guarantInfo.setExchangeRate(new BigDecimal(String.valueOf(entry.get("exchangeRate") == null ? Integer.valueOf(0) : entry.get("exchangeRate"))));
            guarantInfo.setRemark((String)entry.get("remark"));
            guarantInfo.setGuaranteeCompHand((String)entry.get("guaranteeCompHand"));
            if (entry.get("guaranteeComp") != null) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)((String)((Map)entry.get("guaranteeComp")).get("id"))));
                guarantInfo.setGuaranteeComp(company);
            }
            if (entry.get("guaranteeCustomer") != null) {
                CustomerInfo customer = new CustomerInfo();
                customer.setId(BOSUuid.read((String)((String)((Map)entry.get("guaranteeCustomer")).get("id"))));
                guarantInfo.setGuaranteeCustomer(customer);
            }
            if (entry.get("currency") != null) {
                CurrencyInfo currency = new CurrencyInfo();
                currency.setId(BOSUuid.read((String)((String)((Map)entry.get("currency")).get("id"))));
                guarantInfo.setCurrency(currency);
            }
            guarantInfo.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.assure);
            info.getGuaranteeEntrys().add(guarantInfo);
        }
        List pledgeEntrys = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)info.get("pledgeentrys")), List.class);
        for (int i = 0; i < pledgeEntrys.size(); ++i) {
            Map entry = (Map)pledgeEntrys.get(i);
            GuaranteeDetailInfo guarantInfo = new GuaranteeDetailInfo();
            guarantInfo.setParentBillId((FinancingBillInfo)info);
            guarantInfo.setParentBillType(BillTypeEnum.PAYABLEBILL);
            if (!EmptyUtil.isEmpty(entry.get("billNumber"))) {
                Map entryBill = (Map)entry.get("billNumber");
                guarantInfo.setBillId((String)entryBill.get("id"));
                guarantInfo.setBillNumber((String)entryBill.get("number"));
            }
            guarantInfo.setMortgageType(MortgageTypeEnum.Collateral);
            guarantInfo.setBilltype(GuanTypeBillEnum.wage);
            guarantInfo.setScale(new BigDecimal(String.valueOf(entry.get("scale") == null ? Integer.valueOf(0) : entry.get("scale"))));
            guarantInfo.setGuaranteeName((String)entry.get("guaranteeName"));
            guarantInfo.setWage(new BigDecimal(String.valueOf(entry.get("wage") == null ? Integer.valueOf(0) : entry.get("wage"))));
            guarantInfo.setWageRate(new BigDecimal(String.valueOf(entry.get("wageRate") == null ? Integer.valueOf(0) : entry.get("wageRate"))));
            guarantInfo.setCanWage(new BigDecimal(String.valueOf(entry.get("canWage") == null ? Integer.valueOf(0) : entry.get("canWage"))));
            guarantInfo.setRealWage(new BigDecimal(String.valueOf(entry.get("realWage") == null ? Integer.valueOf(0) : entry.get("realWage"))));
            guarantInfo.setRemark((String)entry.get("remark"));
            guarantInfo.setGuaranteeCompHand((String)entry.get("guaranteeCompHand"));
            if (entry.get("guaranteeComp") != null) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)((String)((Map)entry.get("guaranteeComp")).get("id"))));
                guarantInfo.setGuaranteeComp(company);
            }
            guarantInfo.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.pledge);
            info.getGuaranteeEntrys().add(guarantInfo);
        }
        List impawnEntrys = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)info.get("impawnentrys")), List.class);
        for (int i = 0; i < impawnEntrys.size(); ++i) {
            Map entry = (Map)impawnEntrys.get(i);
            GuaranteeDetailInfo guarantInfo = new GuaranteeDetailInfo();
            guarantInfo.setParentBillId((FinancingBillInfo)info);
            guarantInfo.setParentBillType(BillTypeEnum.PAYABLEBILL);
            if (!EmptyUtil.isEmpty(entry.get("billNumber"))) {
                Map entryBill = (Map)entry.get("billNumber");
                guarantInfo.setBillId((String)entryBill.get("id"));
                guarantInfo.setBillNumber((String)entryBill.get("number"));
                guarantInfo.setBilltype(GuanTypeBillEnum.wage);
            }
            guarantInfo.setScale(new BigDecimal(String.valueOf(entry.get("scale") == null ? Integer.valueOf(0) : entry.get("scale"))));
            guarantInfo.setGuaranteeName((String)entry.get("guaranteeName"));
            guarantInfo.setCanWage(new BigDecimal(String.valueOf(entry.get("canWage") == null ? Integer.valueOf(0) : entry.get("canWage"))));
            guarantInfo.setRealWage(new BigDecimal(String.valueOf(entry.get("realWage") == null ? Integer.valueOf(0) : entry.get("realWage"))));
            guarantInfo.setRemark((String)entry.get("remark"));
            guarantInfo.setGuaranteeCompHand((String)entry.get("guaranteeCompHand"));
            if (entry.get("guaranteeComp") != null) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)((String)((Map)entry.get("guaranteeComp")).get("id"))));
                guarantInfo.setGuaranteeComp(company);
            }
            guarantInfo.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.impawn);
            info.getGuaranteeEntrys().add(guarantInfo);
        }
        List creditEntrys = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)info.get("creditentrys")), List.class);
        for (int i = 0; i < creditEntrys.size(); ++i) {
            Map entry = (Map)creditEntrys.get(i);
            GuaranteeDetailInfo guarantInfo = new GuaranteeDetailInfo();
            guarantInfo.setParentBillId((FinancingBillInfo)info);
            guarantInfo.setParentBillType(BillTypeEnum.PAYABLEBILL);
            guarantInfo.setScale(new BigDecimal(String.valueOf(entry.get("scale") == null ? Integer.valueOf(0) : entry.get("scale"))));
            guarantInfo.setGuaranteeCompHand((String)entry.get("guaranteeCompHand"));
            guarantInfo.setRemark((String)entry.get("remark"));
            guarantInfo.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.credit);
            info.getGuaranteeEntrys().add(guarantInfo);
        }
        List otherEntrys = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)info.get("otherentrys")), List.class);
        for (int i = 0; i < otherEntrys.size(); ++i) {
            Map entry = (Map)otherEntrys.get(i);
            GuaranteeDetailInfo guarantInfo = new GuaranteeDetailInfo();
            guarantInfo.setParentBillId((FinancingBillInfo)info);
            guarantInfo.setParentBillType(BillTypeEnum.PAYABLEBILL);
            guarantInfo.setScale(new BigDecimal(String.valueOf(entry.get("scale") == null ? Integer.valueOf(0) : entry.get("scale"))));
            guarantInfo.setRemark((String)entry.get("remark"));
            if (entry.get("guaranteetype") != null) {
                GuaranteeTypeInfo guaranteeType = new GuaranteeTypeInfo();
                guaranteeType.setId(BOSUuid.read((String)((String)((Map)entry.get("guaranteetype")).get("id"))));
                guarantInfo.setGuaranteeType(guaranteeType);
            }
            guarantInfo.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.other);
            info.getGuaranteeEntrys().add(guarantInfo);
        }
    }

    private void verifyGuaranteeEntrys(Context ctx, PayableBillInfo info) throws PayableException {
        boolean isShowEntitry = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN016", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        GuaranteeTypeInputModeEnum guaranteeTypeInputModeEnum = info.getGuaranteeTypeInputMode();
        GuaranteeDetailCollection entrys = info.getGuaranteeEntrys();
        if (isShowEntitry) {
            if (guaranteeTypeInputModeEnum == GuaranteeTypeInputModeEnum.assure && (entrys == null || entrys.size() <= 0)) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"180_FinancingBillEditUI")});
            }
            if (guaranteeTypeInputModeEnum == GuaranteeTypeInputModeEnum.pledge && (entrys == null || entrys.size() <= 0)) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"181_FinancingBillEditUI")});
            }
            if (guaranteeTypeInputModeEnum == GuaranteeTypeInputModeEnum.impawn && (entrys == null || entrys.size() <= 0)) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"182_FinancingBillEditUI")});
            }
            if (guaranteeTypeInputModeEnum == GuaranteeTypeInputModeEnum.other && (entrys == null || entrys.size() <= 0)) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"184_FinancingBillEditUI")});
            }
            if (guaranteeTypeInputModeEnum == GuaranteeTypeInputModeEnum.mix && (entrys == null || entrys.size() <= 0)) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"GuaranteeTypeInput_Mix_EntrysNull")});
            }
        }
        if (!(isShowEntitry || guaranteeTypeInputModeEnum != GuaranteeTypeInputModeEnum.credit || entrys != null && entrys.size() > 0)) {
            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"183_FinancingBillEditUI")});
        }
        if (entrys != null && entrys.size() > 0) {
            ArrayList<String> billIdList = new ArrayList<String>();
            block7: for (int i = 0; i < entrys.size(); ++i) {
                GuaranteeDetailInfo entry = entrys.get(i);
                GuaranteeTypePropertyEnum guaranteeType = entry.getGuaranteeTypeProperty();
                String billId = entry.getBillId();
                if (!EmptyUtil.isEmpty((String)billId)) {
                    if (billIdList.contains(billId)) {
                        throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NT_RES, (String)"GuaranteeEntry_repeat", (String[])new String[]{guaranteeType.getAlias()})});
                    }
                    billIdList.add(billId);
                }
                switch (guaranteeType.getValue()) {
                    case 1: {
                        if (EmptyUtil.isEmpty((String)entry.getGuaranteeCompHand())) {
                            throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"151_CreditLimitEditUI")});
                        }
                        if (!EmptyUtil.isEmpty((Object)entry.getExchangeRate())) continue block7;
                        throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"187_FinancingBillEditUI")});
                    }
                    case 2: {
                        if (!EmptyUtil.isEmpty((String)entry.getGuaranteeName())) continue block7;
                        throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"152_CreditLimitEditUI")});
                    }
                    case 3: {
                        if (!EmptyUtil.isEmpty((String)entry.getGuaranteeName())) continue block7;
                        throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"153_CreditLimitEditUI")});
                    }
                    case 4: {
                        if (!EmptyUtil.isEmpty((String)entry.getGuaranteeCompHand())) continue block7;
                        throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"154_CreditLimitEditUI")});
                    }
                    case 5: {
                        if (!EmptyUtil.isEmpty((CoreBaseInfo)entry.getGuaranteeType())) continue block7;
                        throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)FINAutoGenerateResource, (String)"155_CreditLimitEditUI")});
                    }
                }
            }
        }
    }

    private void createReduceCol(Context ctx, PayableBillInfo info) throws BOSException, EASBizException {
        if (info.getCreditLimit() == null) {
            return;
        }
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance((Context)ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(info.getCreditLimit().getId()), FinUtils.getCreditLimitEntityView().getSelector());
        if (creditLimitInfo.getLimitType() == LimitTypeEnum.BILLPOOL_LIMIT || creditLimitInfo.getShareType() != ShareTypeEnum.ASSIGN || !creditLimitInfo.getCreditUsage().isColligateCredit()) {
            return;
        }
        if (info.get("rightRows") == null || info.get("rightRows") == "") {
            CreditFinancingReduceCollection cfrcoll = this.getReduceCol(ctx, info.getId().toString());
            if (cfrcoll == null || cfrcoll.size() == 0) {
                throw new PayableException(PayableException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"300_PayableBillEditUI")});
            }
            info.setReduceCol(cfrcoll);
            return;
        }
        CreditFinancingReduceCollection reduceCol = new CreditFinancingReduceCollection();
        BigDecimal balanceTmp = info.getAmount().subtract(info.getOriAssureAmount()).multiply(info.getCreditCurExRate());
        List rightRows = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)info.get("rightRows")), List.class);
        for (int i = 0; i < rightRows.size(); ++i) {
            Map row = (Map)rightRows.get(i);
            CreditFinancingReduceInfo reduceInfo = new CreditFinancingReduceInfo();
            reduceInfo.setBillID(info.getId());
            reduceInfo.setCreditLimitID(info.getCreditLimit().getId());
            reduceInfo.setAssignAmt(new BigDecimal(String.valueOf(row.get("rightassignAmt") == null ? Integer.valueOf(0) : row.get("rightassignAmt"))));
            reduceInfo.setBalance(new BigDecimal(String.valueOf(row.get("rightbalance") == null ? Integer.valueOf(0) : row.get("rightbalance"))));
            reduceInfo.setReduceSeq(((Double)((Object)(row.get("rightreduceSeq") == null ? Integer.valueOf(0) : row.get("rightreduceSeq")))).intValue());
            if (row.get("rightcompany") != null) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)((String)((Map)row.get("rightcompany")).get("id"))));
                reduceInfo.setShareOrg(company);
            }
            if (row.get("rightfinPro") != null) {
                FinancingProductsInfo finPro = new FinancingProductsInfo();
                finPro.setId(BOSUuid.read((String)((String)((Map)row.get("rightfinPro")).get("id"))));
                reduceInfo.setFinPro(finPro);
            }
            if (row.get("rightentryID") != null) {
                CreditLimitEntryInfo creditEntry = new CreditLimitEntryInfo();
                creditEntry.setId(BOSUuid.read((String)((String)row.get("rightentryID"))));
                reduceInfo.setCreditEntry(creditEntry);
            }
            if (row.get("rightcontrolWay") != null) {
                ControlWayEnum controlWay = ControlWayEnum.getEnum((int)((Double)((Map)row.get("rightcontrolWay")).get("value")).intValue());
                reduceInfo.setControlWay(controlWay);
            }
            if (balanceTmp.subtract(reduceInfo.getBalance()).compareTo(Constants.ZERO) >= 0) {
                reduceInfo.setUsedAmt(reduceInfo.getBalance());
            } else {
                reduceInfo.setUsedAmt(balanceTmp);
            }
            balanceTmp = balanceTmp.subtract(reduceInfo.getBalance());
            reduceCol.add(reduceInfo);
        }
        info.setReduceCol(reduceCol);
    }

    private CreditFinancingReduceCollection getReduceCol(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billId));
        view.setFilter(filter);
        return CreditFinancingReduceFactory.getLocalInstance((Context)ctx).getCreditFinancingReduceCollection(view);
    }
}

