/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookMessageInfo;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.nt.IRecCheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.RecChequeCollection;
import com.kingdee.eas.fm.nt.RecChequeException;
import com.kingdee.eas.fm.nt.RecChequeFactory;
import com.kingdee.eas.fm.nt.RecChequeHelper;
import com.kingdee.eas.fm.nt.RecChequeInfo;
import com.kingdee.eas.fm.nt.RecChequeStatueEnum;
import com.kingdee.eas.fm.nt.app.AbstractRecChequeControllerBean;
import com.kingdee.eas.fm.nt.app.RecChequeBookBuilder;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;

public class RecChequeControllerBean
extends AbstractRecChequeControllerBean {
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecChequeInfo info = (RecChequeInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        this.verifyBook(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        if (info.isReceipt()) {
            NTHelper.updateFpItem(ctx, pk, null);
            FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((RecChequeInfo)model));
        }
        return pk;
    }

    private void verifyBook(Context ctx, IObjectValue model) throws EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"ntType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"issueDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"expiredDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"receiveDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"currency");
        RecChequeInfo info = (RecChequeInfo)model;
        if (info.getRemitter() == null && info.getRemitterC() == null && info.getRemitterS() == null) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"remitter");
        }
        if (info.isIsQuota()) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"ceiling");
        } else {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"amount");
        }
        if (info.isReceipt()) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"receiptAmount");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"receiptDate");
            info.setState(RecChequeStatueEnum.RECEIPT);
        } else {
            info.setState(RecChequeStatueEnum.NEW);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RecChequeInfo info = RecChequeFactory.getLocalInstance(ctx).getRecChequeInfo(pk);
        if (!RecChequeHelper.isCanRemove(info)) {
            throw new RecChequeException(RecChequeException.CAN_NOT_REMOVE);
        }
        NTHelper.cancelFpItem(ctx, pk.toString());
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof RecChequeInfo) {
            RecChequeInfo info = (RecChequeInfo)model;
            if (info.isEdit()) {
                if (RecChequeStatueEnum.NEW.equals((Object)info.getState())) {
                    this.verifyBook(ctx, model);
                    super._update(ctx, pk, model);
                } else if (RecChequeStatueEnum.RECEIPT.equals((Object)info.getState())) {
                    FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"receiptDate");
                    FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"receiptAmount");
                    super._update(ctx, pk, model);
                } else if (RecChequeStatueEnum.ENDORSE.equals((Object)info.getState())) {
                    FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"endorseDate");
                    if (info.getEndorser() == null && info.getEndorserC() == null && info.getEndorserS() == null) {
                        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"endorser");
                    }
                    super._update(ctx, pk, model);
                }
            }
            if (info.isReceipt()) {
                NTHelper.updateFpItem(ctx, pk, null);
                FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)info);
            }
        }
    }

    @Override
    protected IObjectCollection _book(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        int i;
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        int l = coll.size();
        for (int i2 = 0; i2 < l; ++i2) {
            idList.add(this.addnew(ctx, (CoreBaseInfo)((RecChequeInfo)coll.getObject(i2))));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ntType.*");
        sic.add("currency.*");
        sic.add("payeeBank.*");
        sic.add("payeeBankAcct.*");
        sic.add("department.*");
        sic.add("oppAcct.*");
        sic.add("project.*");
        sic.add("outBgItemId");
        sic.add("outBgItemName");
        sic.add("outBgItemNumber");
        sic.add("Pproject.name");
        sic.add("Pproject.number");
        sic.add("dealer.*");
        sic.add("receiptAcct.*");
        sic.add("payerS.Name");
        sic.add("payerC.Name");
        sic.add("remitterS.name");
        sic.add("remitterC.name");
        RecChequeCollection col = new RecChequeCollection();
        IRecCheque recCheque = RecChequeFactory.getLocalInstance(ctx);
        for (i = 0; i < idList.size(); ++i) {
            RecChequeInfo info = recCheque.getRecChequeInfo((IObjectPK)idList.get(i), sic);
            if (RecChequeStatueEnum.RECEIPT.equals((Object)info.getState())) {
                info.setReceipt(true);
            }
            col.add(info);
        }
        int l2 = coll.size();
        for (i = 0; i < l2; ++i) {
            RecChequeInfo info = (RecChequeInfo)col.getObject(i);
            FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
            FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IFMBgUsed)info);
        }
        return col;
    }

    @Override
    protected void _receipt(Context ctx, IObjectCollection modelCol) throws BOSException, EASBizException {
        RecChequeInfo info;
        int i;
        if (modelCol == null || modelCol.size() <= 0) {
            throw new RecChequeException(RecChequeException.CAN_NOT_RECEIPT);
        }
        int l = modelCol.size();
        for (i = 0; i < l; ++i) {
            info = (RecChequeInfo)modelCol.getObject(i);
            if (!RecChequeHelper.isCanReceipt(info)) {
                throw new RecChequeException(RecChequeException.CAN_NOT_RECEIPT);
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"receiptDate");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"receiptAmount");
        }
        l = modelCol.size();
        for (i = 0; i < l; ++i) {
            info = (RecChequeInfo)modelCol.getObject(i);
            info.setState(RecChequeStatueEnum.RECEIPT);
            SelectorItemCollection sic = new SelectorItemCollection();
            String[] fields = this.getFields4Receipt();
            int len = fields.length;
            for (int j = 0; j < len; ++j) {
                if (info.get(fields[j]) == null) continue;
                sic.add(fields[j]);
            }
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
            FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
            NTHelper.updateFpItem(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), null);
            FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IFMBgUsed)info);
        }
    }

    @Override
    protected void _cancelReceipt(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic;
        RecChequeInfo info = RecChequeFactory.getLocalInstance(ctx).getRecChequeInfo(pk);
        if (RecChequeHelper.isCanCancelReceipt(info)) {
            info.setState(RecChequeStatueEnum.NEW);
            String[] fields = this.getFields4Receipt();
            this.doFields(info, fields);
            sic = new SelectorItemCollection();
            int len = fields.length;
            for (int i = 0; i < len; ++i) {
                sic.add(fields[i]);
            }
        } else {
            throw new RecChequeException(RecChequeException.CAN_NOT_CANCELRECEIPT);
        }
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        NTHelper.cancelFpItem(ctx, pk.toString());
    }

    private String[] getFields4Receipt() {
        String[] fields = new String[]{"state", "receiptDate", "receiptAmount", "receiptAcct", "payeeBank", "payeeBankAcct", "oppAcct", "project", "Pproject", "outBgItemId", "outBgItemName", "outBgItemNumber", "description", "fundFlowItem", "mbgNumber", "mbgName"};
        return fields;
    }

    private String[] getFields4Endorse() {
        String[] fields = new String[]{"state", "endorseDate", "endorser", "endorserC", "endorserS", "oppAcct", "project", "Pproject", "description", "outBgItemId", "outBgItemName", "outBgItemNumber", "fundFlowItem", "mbgNumber", "mbgName"};
        return fields;
    }

    private void doFields(RecChequeInfo info, String[] fields) {
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            if ("state".equals(fields[i])) continue;
            if (info.get(fields[i]) instanceof BigDecimal) {
                info.put(fields[i], Constants.ZERO);
                continue;
            }
            if (info.get(fields[i]) instanceof Boolean) {
                info.put(fields[i], Boolean.FALSE);
                continue;
            }
            info.put(fields[i], null);
        }
    }

    @Override
    protected void _endorse(Context ctx, IObjectCollection modelCol) throws BOSException, EASBizException {
        RecChequeInfo info;
        int i;
        if (modelCol == null || modelCol.size() <= 0) {
            return;
        }
        int l = modelCol.size();
        for (i = 0; i < l; ++i) {
            info = (RecChequeInfo)modelCol.getObject(i);
            if (!RecChequeHelper.isCanEndorse(info)) {
                throw new RecChequeException(RecChequeException.CAN_NOT_ENDORSE);
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"endorseDate");
            if (info.getEndorser() != null || info.getEndorserC() != null || info.getEndorserS() != null) continue;
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"endorser");
        }
        l = modelCol.size();
        for (i = 0; i < l; ++i) {
            info = (RecChequeInfo)modelCol.getObject(i);
            info.setState(RecChequeStatueEnum.ENDORSE);
            SelectorItemCollection sic = new SelectorItemCollection();
            String[] fields = this.getFields4Endorse();
            int len = fields.length;
            for (int j = 0; j < len; ++j) {
                if (info.get(fields[j]) == null) continue;
                sic.add(fields[j]);
            }
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        }
    }

    @Override
    protected void _cancelEndorse(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic;
        RecChequeInfo info = RecChequeFactory.getLocalInstance(ctx).getRecChequeInfo(pk);
        if (RecChequeHelper.isCanCancelEndorse(info)) {
            info.setState(RecChequeStatueEnum.NEW);
            String[] fields = this.getFields4Endorse();
            this.doFields(info, fields);
            sic = new SelectorItemCollection();
            int len = fields.length;
            for (int i = 0; i < len; ++i) {
                sic.add(fields[i]);
            }
        } else {
            throw new RecChequeException(RecChequeException.CAN_NOT_CANCELENDORSE);
        }
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    @Override
    protected void _abandon(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecChequeInfo info;
        if (model instanceof RecChequeInfo && RecChequeHelper.isCanAbandon(info = (RecChequeInfo)model)) {
            StringBuffer sql = new StringBuffer(128);
            sql.append("update T_NT_RecCheque ");
            sql.append("set FAbandonState = ");
            sql.append(info.getState().getValue());
            sql.append(", FState = ");
            sql.append(8);
            sql.append(", FAbandonDate = ?");
            if (info.getAbandonReason() != null) {
                sql.append(", FAbandonReason = '");
                sql.append(info.getAbandonReason());
                sql.append("' ");
            }
            sql.append(" where FID = '");
            sql.append(info.getId().toString()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getAbandonDate()});
        }
    }

    @Override
    protected void _cancelAbandon(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RecChequeInfo info = RecChequeFactory.getLocalInstance(ctx).getRecChequeInfo(pk);
        if (RecChequeHelper.isCanCancelAbandon(info)) {
            StringBuffer sql = new StringBuffer(128);
            sql.append("update T_NT_RecCheque ");
            sql.append("set FState = FAbandonState,");
            sql.append("FAbandonDate = null,");
            sql.append("FAbandonState = null,");
            sql.append("FAbandonReason = null ");
            sql.append("where FID = '");
            sql.append(info.getId().toString()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _record(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() <= 0) {
            return;
        }
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(localInstance.getCurrentCompany().getId()));
        if (val != 0) {
            throw new NTException(NTException.BOOKONLYBYBILL);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        evi.setFilter(filter);
        RecChequeCollection coll = RecChequeFactory.getLocalInstance(ctx).getRecChequeCollection(evi);
        if (coll == null || coll.size() <= 0) {
            throw new RecChequeException(RecChequeException.CAN_NOT_RECORD);
        }
        String sql = "update T_NT_RecCheque set FCashierID = ?,FJouranlID = ? where FID = ?";
        String userid = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        for (String id : idSet) {
            RecChequeBookBuilder builder = new RecChequeBookBuilder();
            JournalCollection journalColl = builder.getJournalColl(ctx, id);
            String jouranlid = journalColl.get(0).getId().toString();
            BookMessageInfo bookMsg = BookNotifyFacadeFactory.getLocalInstance((Context)ctx).bookBatch(journalColl);
            if (bookMsg.isSuccess()) {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, jouranlid, id});
                continue;
            }
            throw new BOSException(bookMsg.getMsg());
        }
    }

    @Override
    protected void _cancelRecord(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        RecChequeInfo info = RecChequeFactory.getLocalInstance(ctx).getRecChequeInfo(pk);
        if (!RecChequeHelper.isCanCancelRecord(info)) {
            throw new RecChequeException(RecChequeException.CAN_NOT_CANCELRECORD);
        }
        String sql = "update T_NT_RecCheque set FCashierID = null,FJouranlID = null where FID = ?";
        String id = pk.toString();
        BookNotifyFacadeFactory.getLocalInstance((Context)ctx).antiBook(id);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, billOperStateEnum, relationInfo);
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)billOperStateEnum)) {
            String sql = "update T_NT_RecCheque set FFivouchered = 1 where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{srcBillPK.toString()});
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)billOperStateEnum)) {
            String sql = "update T_NT_RecCheque set FFivouchered = 0 where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{srcBillPK.toString()});
        }
    }
}

