/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.OprtEnum;
import com.kingdee.eas.fm.nt.OprtLogCollection;
import com.kingdee.eas.fm.nt.OprtLogFactory;
import com.kingdee.eas.fm.nt.OprtLogInfo;
import com.kingdee.eas.fm.nt.ReceivableBillBalanceCollection;
import com.kingdee.eas.fm.nt.ReceivableBillBalanceFactory;
import com.kingdee.eas.fm.nt.ReceivableBillBalanceInfo;
import com.kingdee.eas.fm.nt.app.AbstractReceivableBillBalanceControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceivableBillBalanceControllerBean
extends AbstractReceivableBillBalanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.ReceivableBillBalanceControllerBean");

    @Override
    protected void _init(Context ctx) throws BOSException, EASBizException {
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"39_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()));
        String deleteOprtSql = "DELETE FROM T_NT_OprtLog";
        DbUtil.execute((Context)ctx, (String)deleteOprtSql);
        String deleteBalanceSql = "DELETE FROM T_NT_ReceivableBillBalance";
        DbUtil.execute((Context)ctx, (String)deleteBalanceSql);
        this.getSavedAmt(ctx, null);
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"40_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()));
    }

    private ReceivableBillBalanceCollection getSavedAmt(Context ctx, Map compMinDateMap) throws BOSException {
        StringBuffer occurAmtsql = new StringBuffer();
        occurAmtsql.append(" SELECT NEWBOSID('21E666A6'), COMPANYID, BIZDATE, NTTYPE, CURRENCYID \n").append(" ,SUM(SAVEAMT) SAVEAMT \n").append(" ,SUM(SAVELOCAMT) SAVELOCAMT \n").append(" ,SUM(ENDORSEAMT) ENDORSEAMT \n").append(" ,SUM(ENDORSELOCAMT) ENDORSEAMT \n").append(" ,SUM(DISCOUNTAMT)  DISCOUNTAMT \n").append(" ,SUM(DISCOUNTLOCAMT)  DISCOUNTAMT \n").append(" ,SUM(DISCOUNTINT)  DISCOUNTINT \n").append(" ,SUM(DISCOUNTLOCINT)  DISCOUNTINT \n").append(" ,SUM(RECAMT) RECAMT \n").append(" ,SUM(RECAMT) RECLOCAMT \n").append(" ,SUM(RETURNAMT) RETURNAMT \n").append(" ,SUM(RETURNAMT) RETURNLOCAMT \n").append(" ,SUM(TranLendAmt) TranLendAmt \n").append(" ,SUM(TranLendLocAmt) TranLendLocAmt \n").append(" FROM  \n").append(" ( \n").append(this.getSaveAmtSql()).append(" UNION ALL \n").append(this.getTransferAmtSql()).append(" ) as yyy \n").append(" GROUP BY COMPANYID, BIZDATE, NTTYPE, CURRENCYID \n").append(" ORDER BY COMPANYID, BIZDATE, NTTYPE, CURRENCYID \n");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO T_NT_ReceivableBillBalance \n").append(" (FID, FCompanyId, FBizDate, FNtTypeId, FCurrencyId, \n").append("\tFSaveAmt,FSaveLocAmt, FEndorseAmt,FEndorseLocAmt, FDiscountAmt,FDiscountLocAmt, FDiscountIntAmt,FDiscountLocIntAmt, FRecAmt,FRecLocAmt, FReturnAmt,FReturnLocAmt,FTranLendAmt,FTranLendLocAmt) \n").append(occurAmtsql);
        logger.info((Object)("\n insertOccurAmtSql = " + insertSql.toString()));
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        StringBuffer savePreBalanceSql = new StringBuffer();
        savePreBalanceSql.append(" SELECT A.FCOMPANYID,A.FNTTYPEID,A.FCURRENCYID,SUM(A.FBILLAMT) BALANCE,SUM(A.FNaturalAmt) LocBALANCE \n").append(" FROM T_NT_RECEIVABLEBILL A \n").append(" LEFT JOIN T_FIN_WAGE B ON A.FWAGEID=B.FID \n").append(" LEFT JOIN T_NT_returnbill C ON A.FID=C.FSrcBillId \n").append(" WHERE A.FCOMPANYID = ? \n").append("\tAND FNTTYPEID = ? \n").append(" AND A.FCURRENCYID = ? \n").append(" AND A.FTAKEDATE < ? \n").append(" AND (A.FTRUSTDATE IS NULL OR A.FTRUSTDATE >= ? ) \n").append(" AND (B.FIssueDate IS NULL OR  B.FIssueDate >= ? OR A.FIsDisPledge = 1) \n").append(" AND (A.FTRANSFERDATE IS NULL OR (A.FTRANSFERDATE >=? AND (C.FSRCBILLTRANSFERDATE IS NULL OR  C.FSRCBILLTRANSFERDATE>=?)) ) \n").append(" AND A.FBILLSTATE <> 0 \n").append(" GROUP BY A.FCOMPANYID,A.FNTTYPEID,A.FCURRENCYID \n");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"41_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + savePreBalanceSql));
        StringBuffer saveBalanceSql = new StringBuffer();
        saveBalanceSql.append(" SELECT A.FCOMPANYID,A.FNTTYPEID,A.FCURRENCYID,SUM(A.FBILLAMT) BALANCE,SUM(A.FNaturalAmt) LocBALANCE \n").append(" FROM T_NT_RECEIVABLEBILL A \n").append(" LEFT JOIN T_FIN_WAGE B ON A.FWAGEID=B.FID \n").append(" LEFT JOIN T_NT_returnbill C ON A.FID=C.FSrcBillId \n").append(" WHERE A.FCOMPANYID = ? \n").append("\tAND FNTTYPEID = ? \n").append(" AND A.FCURRENCYID = ? \n").append(" AND A.FTAKEDATE <= ? \n").append(" AND (A.FTRUSTDATE IS NULL OR A.FTRUSTDATE > ? ) \n").append(" AND (B.FIssueDate IS NULL OR  B.FIssueDate > ? OR A.FIsDisPledge = 1) \n").append(" AND (A.FTRANSFERDATE IS NULL OR (A.FTRANSFERDATE >? AND (C.FSRCBILLTRANSFERDATE IS NULL OR  C.FSRCBILLTRANSFERDATE>?)) ) \n").append(" AND A.FBILLSTATE <> 0 \n").append(" GROUP BY A.FCOMPANYID,A.FNTTYPEID,A.FCURRENCYID \n");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"42_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + saveBalanceSql));
        StringBuffer trustPreBalanceSql = new StringBuffer();
        trustPreBalanceSql.append(" SELECT FCOMPANYID,FNTTYPEID,FCURRENCYID,SUM(FBILLAMT) BALANCE,SUM(FNaturalAmt) LocBALANCE \n").append(" FROM T_NT_RECEIVABLEBILL \n").append(" WHERE FCOMPANYID = ? \n").append("\tAND FNTTYPEID = ? \n").append("\tAND FCURRENCYID = ? \n").append("\tAND FTRUSTDATE IS NOT NULL AND FTRUSTDATE < ? \n").append("\tAND (FTRANSFERDATE IS NULL OR FTRANSFERDATE >= ?) \n").append("\tGROUP BY FCOMPANYID,FNTTYPEID,FCURRENCYID \n");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"43_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + trustPreBalanceSql));
        StringBuffer trustBalanceSql = new StringBuffer();
        trustBalanceSql.append(" SELECT FCOMPANYID,FNTTYPEID,FCURRENCYID,SUM(FBILLAMT) BALANCE,SUM(FNaturalAmt) LocBALANCE \n").append(" FROM T_NT_RECEIVABLEBILL \n").append("\tWHERE FCOMPANYID = ? \n").append("\tAND FNTTYPEID = ? \n").append("\tAND FCURRENCYID = ? \n").append(" \tAND FTRUSTDATE IS NOT NULL AND FTRUSTDATE <= ? \n").append("\tAND (FTRANSFERDATE IS NULL OR FTRANSFERDATE > ?) \n").append("\tGROUP BY FCOMPANYID,FNTTYPEID,FCURRENCYID \n");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"44_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + trustBalanceSql));
        StringBuffer pledgePreBalanceSql = new StringBuffer();
        pledgePreBalanceSql.append(" SELECT A.FCOMPANYID,A.FNTTYPEID,A.FCURRENCYID,SUM(A.FBILLAMT) BALANCE,SUM(A.FNaturalAmt) LocBALANCE \n").append(" FROM T_NT_RECEIVABLEBILL A \n").append(" LEFT JOIN T_FIN_WAGE B ON A.FWAGEID=B.FID \n").append("\tWHERE A.FCOMPANYID = ? \n").append("\tAND A.FNTTYPEID = ? \n").append("\tAND A.FCURRENCYID = ? \n").append(" \tAND B.FIssueDate < ? \n").append("\tAND (A.FTRANSFERDATE IS NULL OR A.FTRANSFERDATE >= ?) \n").append(" \tAND (A.FIsDisPledge = 0 AND A.FIsPledge=1) \n").append("\tGROUP BY A.FCOMPANYID, A.FNTTYPEID, A.FCURRENCYID \n");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"45_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + pledgePreBalanceSql));
        StringBuffer pledgeBalanceSql = new StringBuffer();
        pledgeBalanceSql.append(" SELECT A.FCOMPANYID,A.FNTTYPEID,A.FCURRENCYID,SUM(A.FBILLAMT) BALANCE,SUM(A.FNaturalAmt) LocBALANCE \n").append(" FROM T_NT_RECEIVABLEBILL A \n").append(" LEFT JOIN T_FIN_WAGE B ON A.FWAGEID=B.FID \n").append("\tWHERE A.FCOMPANYID = ? \n").append("\tAND A.FNTTYPEID = ? \n").append("\tAND A.FCURRENCYID = ? \n").append(" \tAND B.FIssueDate <= ? \n").append("\tAND (A.FTRANSFERDATE IS NULL OR A.FTRANSFERDATE > ?) \n").append(" \tAND (A.FIsDisPledge = 0 AND A.FIsPledge=1 ) \n").append("\tGROUP BY A.FCOMPANYID, A.FNTTYPEID, A.FCURRENCYID \n");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"46_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + pledgeBalanceSql));
        StringBuffer baseSql = new StringBuffer();
        baseSql.append("SELECT A.FCOMPANYID,A.FNTTYPEID,A.FCURRENCYID FROM T_NT_RECEIVABLEBILL A \n").append("WHERE A.FCOMPANYID = ? \n").append("\tAND A.FNTTYPEID = ? \n").append("\tAND A.FCURRENCYID = ? \n");
        StringBuffer allBalanceSql = new StringBuffer();
        allBalanceSql.append(" SELECT SAVEPREBAL.FCOMPANYID,SAVEPREBAL.FNTTYPEID,SAVEPREBAL.FCURRENCYID \n").append(" ,SAVEPREBAL.BALANCE PRESAVEBALANCE  \n").append(" ,SAVEPREBAL.LocBALANCE PRESAVELocBALANCE  \n").append(" ,SAVEBAL.BALANCE SAVEBALANCE \n").append(" ,SAVEBAL.LocBALANCE SAVELocBALANCE \n").append(" ,TRUSTPREBAL.BALANCE PRETRUSTBALANCE \n").append(" ,TRUSTPREBAL.LocBALANCE PRETRUSTLocBALANCE \n").append(" ,TRUSTBAL.BALANCE TRUSTBALANCE \n").append(" ,TRUSTBAL.LocBALANCE TRUSTLocBALANCE \n").append(" ,PLEDGEPREBAL.BALANCE PREPLEDGEBALANCE \n").append(" ,PLEDGEPREBAL.LocBALANCE PREPLEDGELocBALANCE \n").append(" ,PLEDGEBAL.BALANCE PLEDGEBALANCE \n").append(" ,PLEDGEBAL.LocBALANCE PLEDGELocBALANCE \n").append(" FROM (").append(baseSql).append(") BASE \n").append(" LEFT JOIN (").append(savePreBalanceSql).append(") SAVEPREBAL \n").append("\tON BASE.FCOMPANYID=SAVEPREBAL.FCOMPANYID  \n").append("\t\tAND BASE.FNTTYPEID=SAVEPREBAL.FNTTYPEID \n").append("\t\tAND BASE.FCURRENCYID=SAVEPREBAL.FCURRENCYID \n").append(" LEFT JOIN (").append(saveBalanceSql).append(") SAVEBAL \n").append("\tON BASE.FCOMPANYID=SAVEBAL.FCOMPANYID  \n").append("\t\tAND BASE.FNTTYPEID=SAVEBAL.FNTTYPEID \n").append("\t\tAND BASE.FCURRENCYID=SAVEBAL.FCURRENCYID \n").append(" LEFT JOIN (").append(trustPreBalanceSql).append(") TRUSTPREBAL \n").append("\tON BASE.FCOMPANYID=TRUSTPREBAL.FCOMPANYID  \n").append("\t\tAND BASE.FNTTYPEID=TRUSTPREBAL.FNTTYPEID \n").append("\t\tAND BASE.FCURRENCYID=TRUSTPREBAL.FCURRENCYID \n").append(" LEFT JOIN (").append(trustBalanceSql).append(") TRUSTBAL \n").append("\tON BASE.FCOMPANYID=TRUSTBAL.FCOMPANYID  \n").append("\t\tAND BASE.FNTTYPEID=TRUSTBAL.FNTTYPEID \n").append("\t\tAND BASE.FCURRENCYID=TRUSTBAL.FCURRENCYID \n").append(" LEFT JOIN (").append(pledgePreBalanceSql).append(") PLEDGEPREBAL ").append("\tON BASE.FCOMPANYID=PLEDGEPREBAL.FCOMPANYID  \n").append("\t\tAND BASE.FNTTYPEID=PLEDGEPREBAL.FNTTYPEID \n").append("\t\tAND BASE.FCURRENCYID=PLEDGEPREBAL.FCURRENCYID \n").append(" LEFT JOIN (").append(pledgeBalanceSql).append(") PLEDGEBAL \n").append("\tON BASE.FCOMPANYID=PLEDGEBAL.FCOMPANYID  \n").append("\t\tAND BASE.FNTTYPEID=PLEDGEBAL.FNTTYPEID \n").append("\t\tAND BASE.FCURRENCYID=PLEDGEBAL.FCURRENCYID \n");
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"47_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + allBalanceSql.toString()));
        StringBuffer updateBalanceSql = new StringBuffer();
        updateBalanceSql.append(" UPDATE T_NT_ReceivableBillBalance \n").append(" SET FPreSaveBal = ?,FPreSaveLocBal = ?, FSaveBal = ?, FSaveLocBal = ? , FPreTrustBal = ?, FPreTrustLocBal = ?, FTrustBal = ?, FTrustLocBal = ?  \n").append(" \t, FPrePledgeBal = ?, FPrePledgeLocBal = ?, FPledgeBal = ?, FPledgeLocBal = ? \n").append(" WHERE FID = ? \n");
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSorter().add(new SorterItemInfo("bizDate"));
        ReceivableBillBalanceCollection coll = ReceivableBillBalanceFactory.getLocalInstance(ctx).getReceivableBillBalanceCollection(evi);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"48_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + coll.size()));
        ReceivableBillBalanceInfo info = null;
        BigDecimal preSaveBalance = Constants.ZERO;
        BigDecimal saveBalance = Constants.ZERO;
        BigDecimal preTrustBalance = Constants.ZERO;
        BigDecimal trustBalance = Constants.ZERO;
        BigDecimal prePledgeBalance = Constants.ZERO;
        BigDecimal pledgeBalance = Constants.ZERO;
        BigDecimal preSaveLocBalance = Constants.ZERO;
        BigDecimal saveLocBalance = Constants.ZERO;
        BigDecimal preTrustLocBalance = Constants.ZERO;
        BigDecimal trustLocBalance = Constants.ZERO;
        BigDecimal prePledgeLocBalance = Constants.ZERO;
        BigDecimal pledgeLocBalance = Constants.ZERO;
        Object[] allParams = null;
        int updateIndex = 0;
        int updateBacth = 100;
        Connection conn = null;
        PreparedStatement pstmt = null;
        IRowSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(updateBalanceSql.toString());
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                if (info.getBizDate() == null) {
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"49_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()));
                }
                allParams = this.getAllParams(info);
                rs = DbUtil.executeQuery((Context)ctx, (String)allBalanceSql.toString(), (Object[])allParams);
                if (rs.next()) {
                    preSaveBalance = rs.getBigDecimal("preSaveBalance");
                    preSaveLocBalance = rs.getBigDecimal("preSaveLocBalance");
                    saveBalance = rs.getBigDecimal("saveBalance");
                    saveLocBalance = rs.getBigDecimal("saveLocBalance");
                    preTrustBalance = rs.getBigDecimal("preTrustBalance");
                    preTrustLocBalance = rs.getBigDecimal("preTrustLocBalance");
                    trustBalance = rs.getBigDecimal("trustBalance");
                    trustLocBalance = rs.getBigDecimal("trustLocBalance");
                    prePledgeBalance = rs.getBigDecimal("prePledgeBalance");
                    prePledgeLocBalance = rs.getBigDecimal("prePledgeLocBalance");
                    pledgeBalance = rs.getBigDecimal("pledgeBalance");
                    pledgeLocBalance = rs.getBigDecimal("pledgeLocBalance");
                }
                preSaveBalance = preSaveBalance == null ? Constants.ZERO : preSaveBalance;
                saveBalance = saveBalance == null ? Constants.ZERO : saveBalance;
                preTrustBalance = preTrustBalance == null ? Constants.ZERO : preTrustBalance;
                trustBalance = trustBalance == null ? Constants.ZERO : trustBalance;
                prePledgeBalance = prePledgeBalance == null ? Constants.ZERO : prePledgeBalance;
                pledgeBalance = pledgeBalance == null ? Constants.ZERO : pledgeBalance;
                preSaveLocBalance = preSaveLocBalance == null ? Constants.ZERO : preSaveLocBalance;
                saveLocBalance = saveLocBalance == null ? Constants.ZERO : saveLocBalance;
                preTrustLocBalance = preTrustLocBalance == null ? Constants.ZERO : preTrustLocBalance;
                trustLocBalance = trustLocBalance == null ? Constants.ZERO : trustLocBalance;
                prePledgeLocBalance = prePledgeLocBalance == null ? Constants.ZERO : prePledgeLocBalance;
                pledgeLocBalance = pledgeLocBalance == null ? Constants.ZERO : pledgeLocBalance;
                updateIndex = 1;
                pstmt.setBigDecimal(updateIndex++, preSaveBalance);
                pstmt.setBigDecimal(updateIndex++, preSaveLocBalance);
                pstmt.setBigDecimal(updateIndex++, saveBalance);
                pstmt.setBigDecimal(updateIndex++, saveLocBalance);
                pstmt.setBigDecimal(updateIndex++, preTrustBalance);
                pstmt.setBigDecimal(updateIndex++, preTrustLocBalance);
                pstmt.setBigDecimal(updateIndex++, trustBalance);
                pstmt.setBigDecimal(updateIndex++, trustLocBalance);
                pstmt.setBigDecimal(updateIndex++, prePledgeBalance);
                pstmt.setBigDecimal(updateIndex++, prePledgeLocBalance);
                pstmt.setBigDecimal(updateIndex++, pledgeBalance);
                pstmt.setBigDecimal(updateIndex++, pledgeLocBalance);
                pstmt.setString(updateIndex++, info.getId().toString());
                pstmt.addBatch();
                if ((i + 1) % updateBacth != 0 && i != size - 1) continue;
                int[] executeCtns = pstmt.executeBatch();
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"50_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()) + executeCtns.length));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        return coll;
    }

    private Object[] getAllParams(ReceivableBillBalanceInfo info) {
        Object[] allParams = new Object[39];
        allParams[0] = info.getCompany().getId().toString();
        allParams[1] = info.getNtType().getId().toString();
        allParams[2] = info.getCurrency().getId().toString();
        int i = 3;
        while (i <= 18) {
            allParams[i++] = info.getCompany().getId().toString();
            allParams[i++] = info.getNtType().getId().toString();
            allParams[i++] = info.getCurrency().getId().toString();
            allParams[i++] = info.getBizDate();
            allParams[i++] = info.getBizDate();
            allParams[i++] = info.getBizDate();
            allParams[i++] = info.getBizDate();
            allParams[i++] = info.getBizDate();
        }
        i = 19;
        while (i <= 38) {
            allParams[i++] = info.getCompany().getId().toString();
            allParams[i++] = info.getNtType().getId().toString();
            allParams[i++] = info.getCurrency().getId().toString();
            allParams[i++] = info.getBizDate();
            allParams[i++] = info.getBizDate();
        }
        return allParams;
    }

    private ReceivableBillBalanceInfo buildBalanceInfo(IRowSet rs, ReceivableBillBalanceInfo preInfo) throws BOSException {
        ReceivableBillBalanceInfo info = new ReceivableBillBalanceInfo();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        CurrencyInfo currency = new CurrencyInfo();
        NTTypeInfo ntType = new NTTypeInfo();
        try {
            company.setId(BOSUuid.read((String)rs.getString("COMPANYID")));
            info.setCompany(company);
            info.setBizDate(rs.getDate("BIZDATE"));
            ntType.setId(BOSUuid.read((String)rs.getString("NTTYPE")));
            info.setNtType(ntType);
            currency.setId(BOSUuid.read((String)rs.getString("CURRENCYID")));
            info.setCurrency(currency);
            if (preInfo == null) {
                info.setPreSaveBal(Constants.ZERO);
                info.setPreTrustBal(Constants.ZERO);
                info.setPrePledgeBal(Constants.ZERO);
            } else {
                info.setPreSaveBal(preInfo.getSaveBal());
                info.setPreTrustBal(preInfo.getTrustBal());
                info.setPrePledgeBal(preInfo.getPledgeBal());
            }
            info.setSaveAmt(rs.getBigDecimal("SAVEAMT"));
            info.setTrustAmt(rs.getBigDecimal("TRUSTAMT"));
            info.setPledgeAmt(rs.getBigDecimal("PLEDGEAMT"));
            info.setEndorseAmt(rs.getBigDecimal("ENDORSEAMT"));
            info.setDiscountAmt(rs.getBigDecimal("DISCOUNTAMT"));
            info.setDiscountIntAmt(rs.getBigDecimal("DISCOUNTINT"));
            info.setRecAmt(rs.getBigDecimal("RECAMT"));
            info.setReturnAmt(rs.getBigDecimal("RETURNAMT"));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    private String getSaveAmtSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT A.FCOMPANYID COMPANYID \n").append(" ,A.FTAKEDATE BIZDATE \n").append(" ,A.FNTTYPEID NTTYPE \n").append(" ,A.FCURRENCYID CURRENCYID \n").append(" ,A.FBILLAMT SAVEAMT \n").append(" ,A.FNaturalAmt SAVELOCAMT \n").append(" ,0 ENDORSEAMT \n").append(" ,0 ENDORSELOCAMT \n").append(" ,0 DISCOUNTAMT \n").append(" ,0 DISCOUNTLOCAMT \n").append(" ,0 DISCOUNTINT \n").append(" ,0 DISCOUNTLOCINT \n").append(" ,0 RECAMT \n").append(" ,0 RECLOCAMT \n").append(" ,0 RETURNAMT \n").append(" ,0 RETURNLOCAMT \n").append(" ,0 TranLendAmt \n").append(" ,0 TranLendLocAmt \n").append(" FROM T_NT_RECEIVABLEBILL A \n").append(" LEFT JOIN T_ORG_COMPANY B ON A.FCOMPANYID=B.FID \n").append(" LEFT JOIN T_BD_CURRENCY C ON A.FCURRENCYID=C.FID \n").append(" LEFT JOIN T_NT_NTTYPE D ON A.FNTTYPEID=D.FID  \n").append(" WHERE A.FBILLSTATE <> 0 \n");
        logger.debug((Object)("getSaveAmtSql = " + sql.toString()));
        return sql.toString();
    }

    private String getTrustAmtSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT A.FCOMPANYID COMPANYID \n").append(" ,A.FTRUSTDATE BIZDATE \n").append(" ,A.FNTTYPEID NTTYPE \n").append(" ,A.FCURRENCYID CURRENCYID \n").append(" ,0 SAVEAMT \n").append(" ,0 ENDORSEAMT \n").append(" ,0 DISCOUNTAMT \n").append(" ,0 DISCOUNTINT \n").append(" ,0 RECAMT \n").append(" ,0 RETURNAMT \n").append(" FROM T_NT_RECEIVABLEBILL A \n").append(" LEFT JOIN T_ORG_COMPANY B ON A.FCOMPANYID=B.FID \n").append(" LEFT JOIN T_BD_CURRENCY C ON A.FCURRENCYID=C.FID \n").append(" LEFT JOIN T_NT_NTTYPE D ON A.FNTTYPEID=D.FID \n").append(" WHERE A.FTrustDate iS NOT NULL \n");
        logger.debug((Object)("getTrustAmtSql = " + sql.toString()));
        return sql.toString();
    }

    private String getPledgeAmtSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT A.FCOMPANYID COMPANYID \n").append(" ,E.FIssueDate BIZDATE \n").append(" ,A.FNTTYPEID NTTYPE \n").append(" ,A.FCURRENCYID CURRENCYID \n").append(" ,0 SAVEAMT \n").append(" ,0 ENDORSEAMT \n").append(" ,0 DISCOUNTAMT \n").append(" ,0 DISCOUNTINT \n").append(" ,0 RECAMT \n").append(" ,0 RETURNAMT \n").append(" FROM T_NT_RECEIVABLEBILL A \n").append(" LEFT JOIN T_ORG_COMPANY B ON A.FCOMPANYID=B.FID \n").append(" LEFT JOIN T_BD_CURRENCY C ON A.FCURRENCYID=C.FID \n").append(" LEFT JOIN T_NT_NTTYPE D ON A.FNTTYPEID=D.FID \n").append(" LEFT JOIN T_FIN_WAGE E ON A.FWAGEID=E.FID \n").append(" WHERE A.FIsDisPledge = 0 AND A.FIsPledge=1 \n");
        logger.debug((Object)("getPledgeAmtSql = " + sql.toString()));
        return sql.toString();
    }

    private String getTransferAmtSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT COMPANYID,BIZDATE,NTTYPE,CURRENCYID \n").append(" ,0 SAVEAMT,0 SAVELOCAMT \n").append(" ,ENDORSEAMT \n").append(" ,ENDORSELOCAMT \n").append(" ,DISCOUNTAMT \n").append(" ,DISCOUNTLOCAMT \n").append(" ,DISCOUNTINT \n").append(" ,DISCOUNTLOCINT \n").append(" ,RECAMT \n").append(" ,RECLOCAMT \n").append(" ,RETURNAMT \n").append(" ,RETURNLOCAMT \n").append(" ,TranLendAmt \n").append(" ,TranLendLocAmt \n").append(" FROM  \n").append(" (SELECT A.FCOMPANYID COMPANYID \n").append(" ,CASE WHEN D.FENDORSEDATE IS NOT NULL THEN  D.FENDORSEDATE \n").append(" \tWHEN E.FDISCOUNTDATE IS NOT NULL THEN  E.FDISCOUNTDATE \n").append(" \tWHEN F.FBIZDATE  IS NOT NULL THEN  F.FBIZDATE \n").append(" \tWHEN G.FRETURNDATE  IS NOT NULL THEN  G.FRETURNDATE \n").append(" \tWHEN A.FBILLSTATE =10 THEN  A.FTRANSFERDATE \n").append(" \tEND BIZDATE \n").append(" ,A.FNTTYPEID NTTYPE \n").append(" ,A.FCURRENCYID CURRENCYID, \n").append(" CASE WHEN (A.FBILLSTATE IN (7,2) OR G.FSRCBILLSTATE IN (7,2)) THEN FBILLAMT ELSE 0 END ENDORSEAMT, \n").append(" CASE WHEN (A.FBILLSTATE IN (7,2) OR G.FSRCBILLSTATE IN (7,2)) THEN D.FLocalAmount ELSE 0 END ENDORSELOCAMT, \n").append(" CASE WHEN (A.FBILLSTATE IN (3) OR G.FSRCBILLSTATE IN (3)) \tTHEN FBILLAMT ELSE 0 END DISCOUNTAMT, \n").append(" CASE WHEN (A.FBILLSTATE IN (3) OR G.FSRCBILLSTATE IN (3)) \tTHEN E.FLocalAmount ELSE 0 END DISCOUNTLOCAMT, \n").append(" CASE WHEN (A.FBILLSTATE IN (3) OR G.FSRCBILLSTATE IN (3)) \tTHEN E.FActDiscountInt ELSE 0 END DISCOUNTINT, \n").append(" CASE WHEN (A.FBILLSTATE IN (3) OR G.FSRCBILLSTATE IN (3)) \tTHEN E.FDiscountLocInt ELSE 0 END DISCOUNTLOCINT, \n").append(" CASE WHEN (A.FBILLSTATE IN (4) OR G.FSRCBILLSTATE IN (4)) \tTHEN FBILLAMT ELSE 0 END RECAMT, \n").append(" CASE WHEN (A.FBILLSTATE IN (4) OR G.FSRCBILLSTATE IN (4)) \tTHEN F.FLocalAmount ELSE 0 END RECLOCAMT, \n").append(" CASE WHEN (A.FBILLSTATE IN (9) AND (G.FSRCBILLSTATE IN (0,1,8))) THEN FBILLAMT ELSE 0 END RETURNAMT, \n").append(" CASE WHEN (A.FBILLSTATE IN (9) AND (G.FSRCBILLSTATE IN (0,1,8))) THEN G.FLocAmount ELSE 0 END RETURNLOCAMT, \n").append(" CASE WHEN A.FBILLSTATE IN (10) THEN FBILLAMT ELSE 0 END TranLendAmt, \n").append(" CASE WHEN A.FBILLSTATE IN (10) THEN FNaturalAmt ELSE 0 END TranLendLocAmt \n").append(" FROM T_NT_RECEIVABLEBILL A \n").append(" LEFT JOIN T_ORG_COMPANY B ON A.FCOMPANYID=B.FID \n").append(" LEFT JOIN T_BD_CURRENCY C ON A.FCURRENCYID=C.FID \n").append(" LEFT JOIN T_NT_ENDORSEMENTBILL D ON A.FENDORSEBILLID=D.FID \n").append(" LEFT JOIN T_NT_DISCOUNTBILL E ON A.FID=E.FRECEIVABLEBILLID \n").append(" LEFT JOIN T_CAS_RECEIVINGBILL F ON A.FRECEIVINGBILLID=F.FID \n").append(" LEFT JOIN T_NT_RETURNBILL G ON A.FID=G.FSRCBILLID \n").append(" LEFT JOIN T_NT_NTTYPE H ON A.FNTTYPEID=H.FID \n").append(" WHERE A.FTRANSFERDATE IS NOT NULL ) as xxx \n");
        logger.debug((Object)("getTransferAmtSql = " + sql.toString()));
        return sql.toString();
    }

    @Override
    protected void _settle(Context ctx) throws BOSException, EASBizException {
        String deleteOprtSql = "DELETE FROM T_NT_OprtLog";
        DbUtil.execute((Context)ctx, (String)deleteOprtSql);
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"52_ReceivableBillBalanceControllerBean", (Locale)ctx.getLocale()));
    }

    private String getHisTable(Context ctx) throws BOSException {
        Date curDate = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(curDate);
        int year = cal.get(1);
        String tableName = "T_NT_OprtLog_" + year;
        String sql = " IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '" + tableName + "') Create Table " + tableName + " ( FCompanyID VARCHAR(44),FCurrencyID VARCHAR(44),FNtTypeID VARCHAR(44), FChangeAmt NUMERIC(17,4) DEFAULT 0,FChangeLocalAmt NUMERIC(17,4) DEFAULT 0,FOprtState INT,FIsSaveChanged INT, FBillId NVARCHAR(80),FBizDate DateTime,FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255), FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255), FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44), FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FID VARCHAR(44) NOT NULL , CONSTRAINT PK_OprtLog_" + year + " PRIMARY KEY (FID))";
        DbUtil.execute((Context)ctx, (String)sql);
        return tableName;
    }

    private String getKey(OprtLogInfo info) {
        String flag = "";
        flag = flag + info.getCompany().getId().toString();
        flag = flag + ";" + Constants.FORMAT_DAY.format(DateTimeUtils.truncateDate((Date)info.getBizDate()));
        flag = flag + ";" + info.getNtType().getId().toString();
        flag = flag + ";" + info.getCurrency().getId().toString();
        return flag;
    }

    private void updateBalance(Context ctx, OprtLogInfo logInfo) throws BOSException {
        OprtEnum oprtEnum = logInfo.getOprtState();
        if (oprtEnum.equals((Object)OprtEnum.SAVE)) {
            if (logInfo.isIsSaveChanged()) {
                this.updateOccurAmt(ctx, logInfo, "FSaveAmt");
            }
            this.updateBalance(ctx, logInfo, "FPreSaveBal", "FSaveBal");
        } else if (oprtEnum.equals((Object)OprtEnum.TRUST)) {
            this.updateBalance(ctx, logInfo, "FPreTrustBal", "FTrustBal");
        } else if (oprtEnum.equals((Object)OprtEnum.PLEDGE)) {
            this.updateBalance(ctx, logInfo, "FPrePledgeBal", "FPledgeBal");
        } else if (oprtEnum.equals((Object)OprtEnum.ENDORSE)) {
            this.updateOccurAmt(ctx, logInfo, "FEndorseAmt");
        } else if (oprtEnum.equals((Object)OprtEnum.DISCOUNT)) {
            this.updateOccurAmt(ctx, logInfo, "FDiscountAmt");
        } else if (oprtEnum.equals((Object)OprtEnum.DISCOUNTINT)) {
            this.updateOccurAmt(ctx, logInfo, "FDiscountIntAmt");
        } else if (oprtEnum.equals((Object)OprtEnum.RECEIVE)) {
            this.updateOccurAmt(ctx, logInfo, "FRecAmt");
        } else if (oprtEnum.equals((Object)OprtEnum.RETURN)) {
            this.updateOccurAmt(ctx, logInfo, "FReturnAmt");
        }
    }

    private void updateBalance(Context ctx, Statement stmt, OprtLogInfo logInfo) throws BOSException, SQLException {
        OprtEnum oprtEnum = logInfo.getOprtState();
        if (oprtEnum.equals((Object)OprtEnum.SAVE)) {
            if (logInfo.isIsSaveChanged()) {
                stmt.addBatch(this.getOccurAmtSql(logInfo, "FSaveAmt"));
            }
            stmt.addBatch(this.getPreBalanceSql(logInfo, "FPreSaveBal"));
            stmt.addBatch(this.getBalanceSql(logInfo, "FSaveBal"));
        } else if (oprtEnum.equals((Object)OprtEnum.TRUST)) {
            stmt.addBatch(this.getPreBalanceSql(logInfo, "FPreTrustBal"));
            stmt.addBatch(this.getBalanceSql(logInfo, "FTrustBal"));
        } else if (oprtEnum.equals((Object)OprtEnum.PLEDGE)) {
            stmt.addBatch(this.getPreBalanceSql(logInfo, "FPrePledgeBal"));
            stmt.addBatch(this.getBalanceSql(logInfo, "FPledgeBal"));
        } else if (oprtEnum.equals((Object)OprtEnum.ENDORSE)) {
            stmt.addBatch(this.getOccurAmtSql(logInfo, "FEndorseAmt"));
        } else if (oprtEnum.equals((Object)OprtEnum.DISCOUNT)) {
            stmt.addBatch(this.getOccurAmtSql(logInfo, "FDiscountAmt"));
        } else if (oprtEnum.equals((Object)OprtEnum.DISCOUNTINT)) {
            stmt.addBatch(this.getOccurAmtSql(logInfo, "FDiscountIntAmt"));
        } else if (oprtEnum.equals((Object)OprtEnum.RECEIVE)) {
            stmt.addBatch(this.getOccurAmtSql(logInfo, "FRecAmt"));
        } else if (oprtEnum.equals((Object)OprtEnum.RETURN)) {
            stmt.addBatch(this.getOccurAmtSql(logInfo, "FReturnAmt"));
        } else if (oprtEnum.equals((Object)OprtEnum.TRANLEND)) {
            stmt.addBatch(this.getOccurAmtSql(logInfo, "FTranLendAmt"));
        }
    }

    private void updateOccurAmt(Context ctx, OprtLogInfo logInfo, String occurField) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_NT_ReceivableBillBalance \n").append(" SET ").append(occurField).append(" = ").append(occurField).append(" + ? \n").append(" WHERE FCompanyId = ? AND FCurrencyId = ? \n").append(" AND FBizDate = ? AND FNtTypeId = ?");
        Object[] params = new Object[5];
        int i = 0;
        params[i++] = logInfo.getChangeAmt();
        params[i++] = logInfo.getCompany().getId().toString();
        params[i++] = logInfo.getCurrency().getId().toString();
        params[i++] = logInfo.getBizDate();
        params[i++] = logInfo.getNtType().getId().toString();
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void updateBalance(Context ctx, OprtLogInfo logInfo, String preBalaceField, String balanceField) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_NT_ReceivableBillBalance \n").append(" SET ").append(balanceField).append(" = ").append(balanceField).append(" + ? \n").append(" WHERE FCompanyId = ? AND FCurrencyId = ? \n").append(" AND FBizDate >= ? AND FNtTypeId = ?");
        Object[] params = new Object[5];
        int i = 0;
        params[i++] = logInfo.getChangeAmt();
        params[i++] = logInfo.getCompany().getId().toString();
        params[i++] = logInfo.getCurrency().getId().toString();
        params[i++] = logInfo.getBizDate();
        params[i++] = logInfo.getNtType().getId().toString();
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        StringBuffer sql2 = new StringBuffer();
        sql2.append("UPDATE T_NT_ReceivableBillBalance \n").append(" SET ").append(preBalaceField).append(" = ").append(preBalaceField).append(" + ? \n").append(" WHERE FCompanyId = ? AND FCurrencyId = ? \n").append(" AND FBizDate > ? AND FNtTypeId = ?");
        Object[] params2 = new Object[5];
        i = 0;
        params2[i++] = logInfo.getChangeAmt();
        params2[i++] = logInfo.getCompany().getId().toString();
        params2[i++] = logInfo.getCurrency().getId().toString();
        params2[i++] = logInfo.getBizDate();
        params2[i++] = logInfo.getNtType().getId().toString();
        DbUtil.execute((Context)ctx, (String)sql2.toString(), (Object[])params2);
    }

    private String getBalanceSql(OprtLogInfo logInfo, String balanceField) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_NT_ReceivableBillBalance \n").append(" SET ").append(balanceField).append(" = ").append(balanceField).append(" + " + NTHelper.getPlainString(logInfo.getChangeAmt()) + " \n").append("," + this.getLocAmtField(balanceField)).append(" = ").append(this.getLocAmtField(balanceField)).append(" + " + NTHelper.getPlainString(logInfo.getChangeLocalAmt()) + " \n").append(" WHERE FCompanyId = '" + logInfo.getCompany().getId().toString() + "' AND FCurrencyId = '" + logInfo.getCurrency().getId().toString() + "' \n").append(" AND FBizDate >= {" + logInfo.getBizDate() + "} AND FNtTypeId = '" + logInfo.getNtType().getId().toString() + "'");
        return sql.toString();
    }

    private String getPreBalanceSql(OprtLogInfo logInfo, String prebalanceField) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_NT_ReceivableBillBalance \n").append(" SET ").append(prebalanceField).append(" = ").append(prebalanceField).append(" + " + NTHelper.getPlainString(logInfo.getChangeAmt()) + " \n").append("," + this.getLocAmtField(prebalanceField)).append(" = ").append(this.getLocAmtField(prebalanceField)).append(" + " + NTHelper.getPlainString(logInfo.getChangeLocalAmt()) + " \n").append(" WHERE FCompanyId = '" + logInfo.getCompany().getId().toString() + "' AND FCurrencyId = '" + logInfo.getCurrency().getId().toString() + "' \n").append(" AND FBizDate > {" + logInfo.getBizDate() + "} AND FNtTypeId = '" + logInfo.getNtType().getId().toString() + "'");
        return sql.toString();
    }

    private String getOccurAmtSql(OprtLogInfo logInfo, String occurField) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_NT_ReceivableBillBalance \n").append(" SET ").append(occurField).append(" = ").append(occurField).append(" + " + NTHelper.getPlainString(logInfo.getChangeAmt()) + " \n").append("," + this.getLocAmtField(occurField)).append(" = ").append(this.getLocAmtField(occurField)).append(" + " + NTHelper.getPlainString(logInfo.getChangeLocalAmt()) + " \n").append(" WHERE FCompanyId = '" + logInfo.getCompany().getId().toString() + "' AND FCurrencyId = '" + logInfo.getCurrency().getId().toString() + "' \n").append(" AND FBizDate = {" + logInfo.getBizDate() + "} AND FNtTypeId = '" + logInfo.getNtType().getId().toString() + "'");
        return sql.toString();
    }

    private String getKey(ReceivableBillBalanceInfo info) {
        String flag = "";
        flag = flag + info.getCompany().getId().toString();
        flag = flag + ";" + Constants.FORMAT_DAY.format(DateTimeUtils.truncateDate((Date)info.getBizDate()));
        flag = flag + ";" + info.getNtType().getId().toString();
        flag = flag + ";" + info.getCurrency().getId().toString();
        return flag;
    }

    private Map getBalanceMap(Context ctx) throws BOSException {
        HashMap<String, ReceivableBillBalanceInfo> map = new HashMap<String, ReceivableBillBalanceInfo>();
        ReceivableBillBalanceCollection coll = ReceivableBillBalanceFactory.getLocalInstance(ctx).getReceivableBillBalanceCollection();
        ReceivableBillBalanceInfo info = null;
        String flag = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            flag = this.getKey(info);
            map.put(flag, info);
        }
        return map;
    }

    private ReceivableBillBalanceInfo buildBalanceInfo(OprtLogInfo logInfo) {
        ReceivableBillBalanceInfo balanceInfo = new ReceivableBillBalanceInfo();
        balanceInfo.setCompany(logInfo.getCompany());
        balanceInfo.setBizDate(logInfo.getBizDate());
        balanceInfo.setNtType(logInfo.getNtType());
        balanceInfo.setCurrency(logInfo.getCurrency());
        balanceInfo.setPreSaveBal(Constants.ZERO);
        balanceInfo.setPreSaveLocBal(Constants.ZERO);
        balanceInfo.setPreTrustBal(Constants.ZERO);
        balanceInfo.setPreTrustLocBal(Constants.ZERO);
        balanceInfo.setPrePledgeBal(Constants.ZERO);
        balanceInfo.setPrePledgeLocBal(Constants.ZERO);
        balanceInfo.setSaveAmt(Constants.ZERO);
        balanceInfo.setSaveLocAmt(Constants.ZERO);
        balanceInfo.setTrustAmt(Constants.ZERO);
        balanceInfo.setPledgeAmt(Constants.ZERO);
        balanceInfo.setEndorseAmt(Constants.ZERO);
        balanceInfo.setEndorseLocAmt(Constants.ZERO);
        balanceInfo.setDiscountAmt(Constants.ZERO);
        balanceInfo.setDiscountLocAmt(Constants.ZERO);
        balanceInfo.setDiscountIntAmt(Constants.ZERO);
        balanceInfo.setDiscountLocIntAmt(Constants.ZERO);
        balanceInfo.setRecAmt(Constants.ZERO);
        balanceInfo.setRecLocAmt(Constants.ZERO);
        balanceInfo.setReturnAmt(Constants.ZERO);
        balanceInfo.setReturnLocAmt(Constants.ZERO);
        balanceInfo.setSaveBal(Constants.ZERO);
        balanceInfo.setSaveLocBal(Constants.ZERO);
        balanceInfo.setTrustBal(Constants.ZERO);
        balanceInfo.setTrustLocBal(Constants.ZERO);
        balanceInfo.setPledgeBal(Constants.ZERO);
        balanceInfo.setPledgeLocBal(Constants.ZERO);
        return balanceInfo;
    }

    private ReceivableBillBalanceInfo getLastestBalanceInfo(Context ctx, OprtLogInfo logInfo) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)logInfo.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)logInfo.getNtType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)logInfo.getCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)logInfo.getBizDate(), CompareType.LESS_EQUALS));
        evi.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("bizDate");
        sorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorter);
        ReceivableBillBalanceCollection balanceColl = ReceivableBillBalanceFactory.getLocalInstance(ctx).getReceivableBillBalanceCollection(evi);
        if (balanceColl != null && !balanceColl.isEmpty()) {
            return balanceColl.get(0);
        }
        return null;
    }

    private OprtLogCollection getOprtLogColl(Context ctx) throws BOSException {
        SorterItemInfo sorter = new SorterItemInfo("bizDate");
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSorter().add(sorter);
        OprtLogCollection coll = OprtLogFactory.getLocalInstance(ctx).getOprtLogCollection(evi);
        return coll;
    }

    private String getLocAmtField(String amtField) {
        String s = "";
        if ("FSaveAmt".equals(amtField)) {
            s = "FSaveLocAmt";
        } else if ("FPreSaveBal".equals(amtField)) {
            s = "FPreSaveLocBal";
        } else if ("FSaveBal".equals(amtField)) {
            s = "FSaveLocBal";
        } else if ("FPreTrustBal".equals(amtField)) {
            s = "FPreTrustLocBal";
        } else if ("FTrustBal".equals(amtField)) {
            s = "FTrustLocBal";
        } else if ("FPrePledgeBal".equals(amtField)) {
            s = "FPrePledgeLocBal";
        } else if ("FPledgeBal".equals(amtField)) {
            s = "FPledgeLocBal";
        } else {
            if ("FEndorseAmt".equals(amtField)) {
                return "FEndorseLocAmt";
            }
            if ("FDiscountAmt".equals(amtField)) {
                return "FDiscountLocAmt";
            }
            if ("FDiscountIntAmt".equals(amtField)) {
                return "FDiscountLocIntAmt";
            }
            if ("FRecAmt".equals(amtField)) {
                return "FRecLocAmt";
            }
            if ("FReturnAmt".equals(amtField)) {
                return "FReturnLocAmt";
            }
            if ("FTranLendAmt".equals(amtField)) {
                return "FTranLendLocAmt";
            }
        }
        return s;
    }
}

