/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.AbstractEndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;

public class ReceivableBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bankAccount.*");
        ReceivableBillInfo receivableInfo = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        if (receivableInfo.getBankAccount() == null) {
            throw new NTException(NTException.ACCOUNTBANK_NULL_218);
        }
        JournalInfo jnInfo = new JournalInfo();
        jnInfo.setType(JournalTypeEnum.BANK);
        jnInfo.setAccountBank(receivableInfo.getBankAccount());
        jnInfo.setCurrency(receivableInfo.getCurrency());
        jnInfo.setCreateDate(new Date());
        AbstractEndorsementBillInfo endBillInfo = null;
        if (receivableInfo.getSourceBillId() != null && BOSUuid.read((String)receivableInfo.getSourceBillId()).getType().equals((Object)new EndorsementBillInfo().getBOSType())) {
            endBillInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(receivableInfo.getSourceBillId()));
        }
        if (endBillInfo != null) {
            jnInfo.setCreditAmount(receivableInfo.getBillAmt().multiply(Constants.ONE.subtract(endBillInfo.getFeeRate())));
        } else {
            jnInfo.setCreditAmount(receivableInfo.getBillAmt());
        }
        jnInfo.setSettlementType(this.getSettlementType(ctx));
        jnInfo.setSettlementNumber(receivableInfo.getDraftNumber());
        jnInfo.setBizDate(receivableInfo.getTakeDate());
        jnInfo.setAccountView(receivableInfo.getBankAccount().getAccount());
        jnInfo.setOppAccountView(receivableInfo.getBillAccount());
        jnInfo.setOppUnit(receivableInfo.getDeliverName());
        jnInfo.setBillType(BillTypeEnum.ReceivableBill);
        jnInfo.setBillNumber(receivableInfo.getNumber());
        jnInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        jnInfo.setCompany(receivableInfo.getCompany());
        jnInfo.setCU(receivableInfo.getCompany().getCU());
        jnInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"53_ReceivableBillBookNotifyBuilder", (Locale)ctx.getLocale()));
        jnInfo.setBillId(receivableInfo.getId().toString());
        jnInfo.setIsDebit(false);
        jnInfo.setCashier(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        jnInfo.setSource(JournalSourceEnum.BYBILL);
        JournalCollection jnColl = new JournalCollection();
        jnColl.add(jnInfo);
        return jnColl;
    }

    private SettlementTypeInfo getSettlementType(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)"33333333-3333-3333-3333-3333333333331C9A9013"));
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = null;
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        return type;
    }
}

