/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.app.AbstractReceivingBillRecWebFacadeControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceivingBillRecWebFacadeControllerBean
extends AbstractReceivingBillRecWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.ReceivingBillRecWebFacadeControllerBean");

    @Override
    protected Map _submit(Context ctx, Map map) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        ReceivingBillInfo receivingInfo = (ReceivingBillInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)map.get("model").toString(), ReceivingBillInfo.class);
        List idList = (List)map.get("receivableBill");
        HashSet idSet = new HashSet(idList);
        ReceivableBillCollection colls = this.getReceivableBillCollByIdSet(ctx, idSet);
        try {
            receivingInfo.setBizDate(receivingInfo.getRecDate());
            receivingInfo.setPayeeAccount(receivingInfo.getPayeeAccountBank().getAccount());
            ReceivableBillFactory.getLocalInstance(ctx).batchReceiving(receivingInfo, colls);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", ReceivingBillRecWebFacadeControllerBean.getResource(ctx, "236_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    @Override
    protected Map _removeGather(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)map.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + ReceivingBillRecWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            ReceivingBillCollection colls = this.getReceivingBillCollByIdSet(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                ReceivingBillInfo info = colls.get(i);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"RECEIVABLE_12CANCEL_GATHER");
                if (!isPermission) {
                    throw new BOSException(ReceivingBillRecWebFacadeControllerBean.getResource(ctx, "216_ReceivableBill", new String[]{info.getCompany().getName()}));
                }
                try {
                    ArrayList<String> lst = new ArrayList<String>();
                    lst.add(info.getId().toString());
                    ReceivableBillFactory.getLocalInstance(ctx).removeGather(lst);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(ReceivingBillRecWebFacadeControllerBean.getResource(ctx, "218_ReceivableBill", new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(ReceivingBillRecWebFacadeControllerBean.getResource(ctx, "290_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? ReceivingBillRecWebFacadeControllerBean.getResource(ctx, "220_ReceivableBill", null) : summary + ReceivingBillRecWebFacadeControllerBean.getResource(ctx, "221_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private ReceivableBillCollection getReceivableBillCollByIdSet(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(sic);
        return ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillCollection(entityViewInfo);
    }

    private ReceivingBillCollection getReceivingBillCollByIdSet(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("relatedRecBills.*"));
        sic.add(new SelectorItemInfo("company.*"));
        entityViewInfo.setSelector(sic);
        return ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillCollection(entityViewInfo);
    }

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }
}

