/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fm.nt.RecChequeDataEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RecChequeBatchCaculator
implements ICalculator,
IMethodBatchQuery {
    private ICalculateContextProvider context;
    private Context serverCtx;
    private List paramList = new ArrayList();
    private Map companyMap = new HashMap(400);
    private Map currencyMap = new HashMap(50);
    private String reportCurrencyId;
    private String reportCompanyId;
    private Date reportStartDate;
    private Date reportEndDate;

    public RecChequeBatchCaculator() {
    }

    public RecChequeBatchCaculator(ICalculateContextProvider calContext, Context serverCtxParam) {
        this.context = calContext;
        this.serverCtx = serverCtxParam;
    }

    public BigDecimal RecCheque(String companyNum, String currencyNum, String issueDate, String expiredData, String dataType) throws BOSException, EASBizException {
        return null;
    }

    public void execute(SortedParameterArray params) {
        this.init(params);
        this.caculate();
        this.handleResult(params);
    }

    private void init(SortedParameterArray params) {
        this.cacheData();
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            Parameter param = params.getParameter(i);
            Param p = new Param(param);
            p.init();
            this.paramList.add(p);
        }
    }

    private void cacheData() {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        evi.setSelector(sic);
        try {
            CompanyOrgUnitCollection comColl = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverCtx).getCompanyOrgUnitCollection(evi);
            int size = comColl.size();
            for (int i = 0; i < size; ++i) {
                CompanyOrgUnitInfo comInfo = comColl.get(i);
                this.companyMap.put(comInfo.getNumber(), comInfo.getId().toString());
            }
            CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)this.serverCtx).getCurrencyCollection(evi);
            int size2 = currencyColl.size();
            for (int i = 0; i < size2; ++i) {
                CurrencyInfo currencyInfo = currencyColl.get(i);
                this.currencyMap.put(currencyInfo.getNumber(), currencyInfo.getId().toString());
            }
            String reportNum = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
            this.reportCompanyId = (String)this.context.getReportAdapter().getReportProperty("Company.ID");
            this.reportCurrencyId = (String)this.currencyMap.get(reportNum);
            this.reportStartDate = (Date)this.context.getReportAdapter().getReportProperty("Report_StartDate");
            this.reportEndDate = (Date)this.context.getReportAdapter().getReportProperty("Report_EndDate");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void caculate() {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.fm.nt.app", "RecChequeCaculateQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.serverCtx, (IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        for (int i = 0; i < this.paramList.size(); ++i) {
            Param param = (Param)this.paramList.get(i);
            if (param.hasException()) continue;
            try {
                evi.setFilter(param.getFilter());
                exec.setObjectView(evi);
                IRowSet rs = exec.executeQuery();
                if (!rs.next()) continue;
                param.setSum(rs.getBigDecimal("amount") == null ? Constants.ZERO : rs.getBigDecimal("amount"));
                param.setCount(rs.getInt("id"));
                continue;
            }
            catch (BOSException e) {
                param.setException((Exception)((Object)e));
                continue;
            }
            catch (SQLException e) {
                param.setException(e);
            }
        }
    }

    private void handleResult(SortedParameterArray params) {
        for (int i = 0; i < this.paramList.size(); ++i) {
            Parameter param = params.getParameter(i);
            Param result = (Param)this.paramList.get(i);
            if (result.hasException()) {
                param.setValue((Object)result.getException().getMessage());
                continue;
            }
            if (RecChequeDataEnum.AMOUNT.equals((Object)result.getDataType())) {
                if (result.getCount() == 0) {
                    param.setValue((Object)Constants.ZERO);
                    continue;
                }
                param.setValue((Object)result.getSum());
                continue;
            }
            if (!RecChequeDataEnum.COUNT.equals((Object)result.getDataType())) continue;
            param.setValue((Object)new Integer(result.getCount()));
        }
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = this.context.getServerContext();
    }

    public boolean batchQuery(Map methods) {
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    private class Param {
        private final Parameter param;
        private Set companyIdSet = new HashSet();
        private String currencyId;
        private Date issueDate;
        private Date expiredDate;
        private RecChequeDataEnum data;
        private boolean hasException;
        private Exception e;
        private BigDecimal sum;
        private int count;

        public Param(Parameter param) {
            this.param = param;
        }

        public void init() {
            Object[] args = this.param.getArgs();
            String companyNums = args[0].toString();
            String currencyNum = args[1].toString().trim();
            String issue = args[2].toString();
            String expired = args[3].toString();
            String type = args[4].toString();
            this.setCompanyIdSet(companyNums);
            this.setCurrencyId(currencyNum);
            this.setDates(issue, expired);
            this.setDataType(type);
        }

        private void setDataType(String type) {
            if (!StringUtils.isEmpty((String)type)) {
                this.data = RecChequeDataEnum.getEnum(type);
                if (this.data == null) {
                    this.setException((Exception)((Object)new BOSException("Data Type Error!")));
                }
            } else {
                this.setException((Exception)((Object)new BOSException("Data Type Null!")));
            }
        }

        private void setDates(String issue, String expired) {
            this.issueDate = !StringUtils.isEmpty((String)issue) ? DateUtil.stringToDate((String)issue) : RecChequeBatchCaculator.this.reportStartDate;
            this.expiredDate = !StringUtils.isEmpty((String)expired) ? DateUtil.stringToDate((String)expired) : RecChequeBatchCaculator.this.reportEndDate;
        }

        private void setCurrencyId(String currencyNum) {
            if (!StringUtils.isEmpty((String)currencyNum)) {
                this.currencyId = (String)RecChequeBatchCaculator.this.currencyMap.get(currencyNum);
                if (this.currencyId == null) {
                    this.setException((Exception)((Object)new BOSException("BAD CURRENCY NUMBER!")));
                }
            } else {
                String sheetName = this.param.getSheetName();
                String sheetNum = RecChequeBatchCaculator.this.context.getReportVariables().getStringValue("Currency", sheetName);
                if (!StringUtils.isEmpty((String)sheetNum)) {
                    String sheetCurrencyId = (String)RecChequeBatchCaculator.this.currencyMap.get(sheetNum);
                    if (sheetCurrencyId == null) {
                        this.setException((Exception)((Object)new BOSException("Sheet Variable Currency Is Invalid!")));
                    } else {
                        this.currencyId = sheetCurrencyId;
                    }
                } else {
                    this.currencyId = RecChequeBatchCaculator.this.reportCurrencyId;
                }
            }
        }

        private void setCompanyIdSet(String companyNums) {
            if (!StringUtils.isEmpty((String)companyNums)) {
                String[] companyNum = companyNums.split(";");
                for (int i = 0; i < companyNum.length; ++i) {
                    Object companyId = RecChequeBatchCaculator.this.companyMap.get(companyNum[i].trim());
                    this.companyIdSet.add(companyId);
                    if (companyId != null) continue;
                    this.setException((Exception)((Object)new BOSException("One Or More Company Number Is Invalid!")));
                }
            } else {
                this.companyIdSet.add(RecChequeBatchCaculator.this.reportCompanyId);
            }
        }

        public FilterInfo getFilter() throws BOSException {
            FilterInfo filter = new FilterInfo();
            if (this.companyIdSet != null && this.companyIdSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyIdSet, CompareType.INCLUDE));
            }
            if (this.currencyId != null) {
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
            }
            if (this.issueDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("expiredDate", (Object)this.issueDate, CompareType.GREATER_EQUALS));
            }
            if (this.expiredDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("expiredDate", (Object)this.expiredDate, CompareType.LESS_EQUALS));
                FilterInfo filterReceipt = new FilterInfo();
                filterReceipt.getFilterItems().add(new FilterItemInfo("receiptDate", null, CompareType.EQUALS));
                filterReceipt.getFilterItems().add(new FilterItemInfo("receiptDate", (Object)this.expiredDate, CompareType.GREATER));
                filterReceipt.setMaskString("#0 or #1");
                filter.mergeFilter(filterReceipt, "and");
                FilterInfo filterEndorse = new FilterInfo();
                filterEndorse.getFilterItems().add(new FilterItemInfo("endorseDate", null, CompareType.EQUALS));
                filterEndorse.getFilterItems().add(new FilterItemInfo("endorseDate", (Object)this.expiredDate, CompareType.GREATER));
                filterEndorse.setMaskString("#0 or #1");
                filter.mergeFilter(filterEndorse, "and");
                FilterInfo filterAbandon = new FilterInfo();
                filterAbandon.getFilterItems().add(new FilterItemInfo("abandonDate", null, CompareType.EQUALS));
                filterAbandon.getFilterItems().add(new FilterItemInfo("abandonDate", (Object)this.expiredDate, CompareType.GREATER));
                filterAbandon.setMaskString("#0 or #1");
                filter.mergeFilter(filterAbandon, "and");
            }
            return filter;
        }

        public Set getCompanyIdSet() {
            return this.companyIdSet;
        }

        public String getCurrencyId() {
            return this.currencyId;
        }

        public Date getIssueDate() {
            return this.issueDate;
        }

        public Date getExpiredDate() {
            return this.expiredDate;
        }

        public RecChequeDataEnum getDataType() {
            return this.data;
        }

        public boolean hasException() {
            return this.hasException;
        }

        public void setException(Exception e) {
            this.e = e;
            this.hasException = true;
        }

        public Exception getException() {
            return this.e;
        }

        public BigDecimal getSum() {
            return this.sum;
        }

        public void setSum(BigDecimal sum) {
            this.sum = sum;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

