/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.BillTransBizType;
import com.kingdee.eas.fm.ntp.BillTransactionLogFactory;
import com.kingdee.eas.fm.ntp.BillTransactionLogInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;

public class NTPUtil {
    public static void addBillTransLogByColl(Context ctx, ReceivableBillCollection coll, BillTransBizType typeEnum) throws EASBizException, BOSException {
        if (coll.size() > 0) {
            CoreBaseCollection logColl = new CoreBaseCollection();
            BillTransactionLogInfo logInfo = null;
            ReceivableBillInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                logInfo = new BillTransactionLogInfo();
                info = coll.get(i);
                logInfo.setDraftNumber(info.getDraftNumber());
                logInfo.setCompany(info.getHolder());
                logInfo.setBizType(typeEnum);
                logInfo.setHandler(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                logInfo.setHandleDate(new Date());
                logColl.add((CoreBaseInfo)logInfo);
            }
            if (logColl.size() > 0) {
                BillTransactionLogFactory.getLocalInstance(ctx).addnewBatchData(logColl);
            }
        }
    }

    public static void addBillTransLogByInfo(Context ctx, ReceivableBillInfo info, BillTransBizType typeEnum) throws EASBizException, BOSException {
        if (info != null) {
            BillTransactionLogInfo logInfo = new BillTransactionLogInfo();
            logInfo.setDraftNumber(info.getDraftNumber());
            logInfo.setCompany(info.getHolder());
            logInfo.setBizType(typeEnum);
            logInfo.setHandler(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
            logInfo.setHandleDate(new Date());
            BillTransactionLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)logInfo);
        }
    }

    public static boolean isAllBEFailed(Context ctx, ReceivableBillCollection coll) {
        boolean flag = true;
        ReceivableBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (BankReturnStatusEnum.COMMIT_FAIL == info.getBankReturnStatus() || BankReturnStatusEnum.BANK_FAIL == info.getBankReturnStatus()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static boolean isAllPaperBillFailed(Context ctx, ReceivableBillCollection coll) {
        boolean flag = true;
        ReceivableBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!BankReturnStatusEnum.BANK_SUCCESS.equals((Object)info.getBankReturnStatus())) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static void clearBEStatus(Context ctx, ReceivableBillCollection coll) throws BOSException {
        if (coll.size() > 0) {
            ReceivableBillInfo info = null;
            String sql = "update t_nt_ReceivableBill set FBatchSeqID=null,FDetailSeqID=null,FElecBillStatus=null,FBankReturnMsg=null,FBankReturnStatus=null where FID=?";
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
            }
        }
    }
}

