/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fm.ntp.app.AbstractBillPoolDcWarningFacadeControllerBean;
import com.kingdee.eas.fm.ntp.vo.DcWarningRowSetVO;
import com.kingdee.eas.fm.ntp.vo.DcWarningVO;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BillPoolDcWarningFacadeControllerBean
extends AbstractBillPoolDcWarningFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ntp.app.BillPoolDcWarningFacadeControllerBean");

    @Override
    protected Map _getDcWarningData(Context ctx, String argJsonStr, String tableName, int page, int rows) throws BOSException {
        HashMap<String, Object> gridData = new HashMap<String, Object>();
        try {
            FilterItemCollection filterItems = new EntityViewInfo("where " + argJsonStr).getFilter().getFilterItems();
            String currencyID = "";
            String fexpiredDate1 = "";
            String fexpiredDate2 = "";
            for (int i = 0; i < filterItems.size(); ++i) {
                FilterItemInfo filterItem = filterItems.get(i);
                if (filterItem.getPropertyName().equalsIgnoreCase("RECEIVABLEBILL.FCurrencyID")) {
                    currencyID = filterItem.getCompareValue().toString();
                }
                if (!filterItem.getPropertyName().equalsIgnoreCase("RECEIVABLEBILL.FexpiredDate")) continue;
                if (fexpiredDate1.equals("")) {
                    fexpiredDate1 = filterItem.getCompareValue().toString();
                    continue;
                }
                fexpiredDate2 = filterItem.getCompareValue().toString();
            }
            if (tableName == null) {
                tableName = this.createDcWarningTempTable(ctx);
                this.insertTableByDate(ctx, filterItems, fexpiredDate1, fexpiredDate2, tableName);
            }
            gridData.put("tableName", tableName);
            String keyCountSql = "SELECT COUNT(*) NUM FROM " + tableName;
            IRowSet keyCountRowSet = DbUtil.executeQuery((Context)ctx, (String)keyCountSql);
            keyCountRowSet.next();
            int num = keyCountRowSet.getInt("NUM");
            gridData.put("totalCount", num);
            if (num == 0) {
                gridData.put("dcWarningVOLists", new ArrayList());
            } else {
                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
                String selectKeySql = "SELECT BIZDATE, BILLPOOLLIMITS, USELIMITS, RESIDUALLIMITS  FROM " + tableName;
                IRowSet keyRowSet = DbUtil.executeQuery((Context)ctx, (String)selectKeySql, (int)((page - 1) * rows), (int)rows);
                keyRowSet.next();
                ArrayList<DcWarningVO> dcWarningVOLists = new ArrayList<DcWarningVO>();
                keyRowSet.beforeFirst();
                while (keyRowSet.next()) {
                    DcWarningVO dcWarningVO = new DcWarningVO();
                    dcWarningVO.setBIZDATE(keyRowSet.getDate("BIZDATE"));
                    BigDecimal billpoollimits = keyRowSet.getBigDecimal("BILLPOOLLIMITS");
                    dcWarningVO.setBILLPOOLLIMITS(BillPoolDcWarningFacadeControllerBean.insertComma(billpoollimits.setScale(currencyInfo.getPrecision(), 4).toString(), currencyInfo.getPrecision()));
                    BigDecimal uselimits = keyRowSet.getBigDecimal("USELIMITS");
                    dcWarningVO.setUSELIMITS(BillPoolDcWarningFacadeControllerBean.insertComma(uselimits.setScale(currencyInfo.getPrecision(), 4).toString(), currencyInfo.getPrecision()));
                    BigDecimal residuallimits = keyRowSet.getBigDecimal("RESIDUALLIMITS");
                    dcWarningVO.setRESIDUALLIMITS(BillPoolDcWarningFacadeControllerBean.insertComma(residuallimits.setScale(currencyInfo.getPrecision(), 4).toString(), currencyInfo.getPrecision()));
                    dcWarningVOLists.add(dcWarningVO);
                }
                gridData.put("dcWarningVOLists", dcWarningVOLists);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return gridData;
    }

    public static String insertComma(String s, int len) {
        if (s == null || s.length() < 1) {
            return "";
        }
        DecimalFormat formater = null;
        double num = Double.parseDouble(s);
        if (len == 0) {
            formater = new DecimalFormat("#,##0");
        } else {
            StringBuffer buff = new StringBuffer();
            String value = StringUtils.leftPad((String)"0", (int)len, (String)"0");
            buff.append("#,##0." + value);
            formater = new DecimalFormat(buff.toString());
        }
        return formater.format(num);
    }

    private String createDcWarningTempTable(Context ctx) throws BOSException {
        String tableName = "";
        try {
            ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tableName = mang.getTableName("vcgrouplist");
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        StringBuffer sbCreate = new StringBuffer("create table ");
        sbCreate.append(tableName);
        sbCreate.append(" ( ");
        sbCreate.append("BIZDATE DATETIME  NOT NULL, ");
        sbCreate.append("BILLPOOLLIMITS NUMERIC(17,4), ");
        sbCreate.append("USELIMITS NUMERIC(17,4), ");
        sbCreate.append("RESIDUALLIMITS NUMERIC(17,4) ");
        sbCreate.append(")");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbCreate.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        return tableName;
    }

    private DcWarningRowSetVO getDcWarningSQL(Context ctx, FilterItemCollection filterItems, String bizDateStr) throws BOSException, SQLException, ParseException {
        DcWarningRowSetVO dcWarningRowSetVO = new DcWarningRowSetVO();
        HashSet<String> companyIds = new HashSet<String>();
        String bankID = "";
        String currencyID = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo filterItem = filterItems.get(i);
            if (filterItem.getPropertyName().equalsIgnoreCase("RECEIVABLEBILL.FcompanyId")) {
                if (!filterItem.getCompareType().equals((Object)CompareType.INCLUDE)) {
                    companyIds.add(filterItem.getCompareValue().toString());
                    continue;
                }
                LinkedHashSet set = (LinkedHashSet)filterItem.getCompareValue();
                for (String companyId : set) {
                    companyIds.add(companyId);
                }
                continue;
            }
            if (filterItem.getPropertyName().equalsIgnoreCase("RECEIVABLEBILL.FCurrencyID")) {
                currencyID = filterItem.getCompareValue().toString();
                continue;
            }
            if (!filterItem.getPropertyName().equalsIgnoreCase("RECEIVABLEBILL.FcooperativeBankId")) continue;
            bankID = filterItem.getCompareValue().toString();
        }
        Iterator ids = companyIds.iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (ids.hasNext()) {
            String companyId = (String)ids.next();
            StringBuffer oqlB = new StringBuffer();
            oqlB.append("SELECT  * FROM T_NT_ReceivableBill AS RECEIVABLEBILL WHERE RECEIVABLEBILL.FcompanyId = '" + companyId + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oqlB.toString());
            if (!rowSet.next()) continue;
            idSet.add(companyId);
        }
        if (idSet.size() <= 0) {
            JdbcRowSet rowset = new JdbcRowSet();
            return null;
        }
        StringBuffer receivableBilloql = new StringBuffer();
        receivableBilloql.append("SELECT Sum(ISNULL(RECEIVABLEBILL.FBillAmt,0)) AS BILLAMT   FROM T_NT_ReceivableBill AS RECEIVABLEBILL");
        receivableBilloql.append(" WHERE  RECEIVABLEBILL.FBillState = 11   AND  RECEIVABLEBILL.FcompanyId in ( " + BirtUtils.idListToInClause(companyIds) + " )");
        if (!EmptyUtil.isEmpty((String)bankID)) {
            receivableBilloql.append(" AND RECEIVABLEBILL.FcooperativeBankId = '" + bankID + "'");
        }
        if (!EmptyUtil.isEmpty((String)currencyID)) {
            receivableBilloql.append(" AND RECEIVABLEBILL.FCurrencyID = '" + currencyID + "'");
        }
        receivableBilloql.append(" AND RECEIVABLEBILL.FexpiredDate > {d'" + bizDateStr + "'} ");
        StringBuffer OQL = new StringBuffer();
        OQL.append("  select SUM(CREDITLIMITUSED. FUsedQuota) AS UsedQuota");
        OQL.append("  From T_FIN_CreditLimitUsed CREDITLIMITUSED");
        OQL.append("  LEFT OUTER JOIN T_FIN_CreditLimit CREDITLIMIT");
        OQL.append("    ON CREDITLIMIT.FID = CREDITLIMITUSED.FCreditLimitId");
        OQL.append("    WHERE  CREDITLIMITUSED.FExpiredDate >  {d'" + bizDateStr + "'} AND  CREDITLIMIT.FLimitType = 2  AND  CREDITLIMIT.FCompanyID in ( " + BirtUtils.idListToInClause(companyIds) + " )");
        if (!EmptyUtil.isEmpty((String)bankID)) {
            OQL.append(" AND CREDITLIMIT.FCreditInstitutionId = '" + bankID + "'");
        }
        if (!EmptyUtil.isEmpty((String)currencyID)) {
            OQL.append(" AND CREDITLIMIT.FCurrencyID = '" + currencyID + "'");
        }
        IRowSet receivableBillRowSet = DbUtil.executeQuery((Context)ctx, (String)receivableBilloql.toString());
        BigDecimal billamt = new BigDecimal(0);
        while (receivableBillRowSet.next()) {
            billamt = receivableBillRowSet.getBigDecimal("BILLAMT") == null ? new BigDecimal(0) : receivableBillRowSet.getBigDecimal("BILLAMT");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)OQL.toString());
        BigDecimal usedQuota = new BigDecimal(0);
        while (rowSet.next()) {
            usedQuota = rowSet.getBigDecimal("UsedQuota") == null ? new BigDecimal(0) : rowSet.getBigDecimal("UsedQuota");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date bizDate = format.parse(bizDateStr);
        dcWarningRowSetVO.setBIZDATE(bizDate);
        dcWarningRowSetVO.setBILLPOOLLIMITS(billamt);
        dcWarningRowSetVO.setUSELIMITS(usedQuota);
        dcWarningRowSetVO.setRESIDUALLIMITS(dcWarningRowSetVO.getBILLPOOLLIMITS().subtract(dcWarningRowSetVO.getUSELIMITS()));
        return dcWarningRowSetVO;
    }

    protected void insertTableByDate(Context ctx, FilterItemCollection filterItems, String fexpiredDateStr1, String fexpiredDateStr2, String tableName) throws BOSException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        Connection conn = null;
        PreparedStatement ps = null;
        StringBuffer insertTempDataSql = new StringBuffer("");
        try {
            java.util.Date fexpiredDate1 = format.parse(fexpiredDateStr1);
            java.util.Date fexpiredDate2 = format.parse(fexpiredDateStr2);
            if (fexpiredDate1.before(fexpiredDate2)) {
                start.setTime(format.parse(fexpiredDateStr1));
                end.setTime(format.parse(fexpiredDateStr2));
            } else {
                start.setTime(format.parse(fexpiredDateStr2));
                end.setTime(format.parse(fexpiredDateStr1));
            }
            end.add(5, 1);
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement("INSERT INTO " + tableName + "(BIZDATE, BILLPOOLLIMITS, USELIMITS, RESIDUALLIMITS) VALUES  (?,?,?,?)");
            int count = 1;
            while (start.before(end)) {
                String bizDateStr = format.format(start.getTime());
                DcWarningRowSetVO dcWarningRowSetVO = this.getDcWarningSQL(ctx, filterItems, bizDateStr);
                if (count == 1 && (dcWarningRowSetVO == null || BigDecimal.ZERO.equals(dcWarningRowSetVO.getBILLPOOLLIMITS()) && BigDecimal.ZERO.equals(dcWarningRowSetVO.getUSELIMITS()))) break;
                java.util.Date bIZDATE = new java.util.Date();
                BigDecimal bILLAMT = new BigDecimal(0);
                BigDecimal bALANCE = new BigDecimal(0);
                BigDecimal rESIDUALLIMITS = new BigDecimal(0);
                if (dcWarningRowSetVO != null) {
                    bIZDATE = dcWarningRowSetVO.getBIZDATE();
                    Date date = new Date(bIZDATE.getTime());
                    bILLAMT = dcWarningRowSetVO.getBILLPOOLLIMITS();
                    bALANCE = dcWarningRowSetVO.getUSELIMITS();
                    rESIDUALLIMITS = dcWarningRowSetVO.getRESIDUALLIMITS();
                    ps.setDate(1, date);
                    ps.setBigDecimal(2, bILLAMT);
                    ps.setBigDecimal(3, bALANCE);
                    ps.setBigDecimal(4, rESIDUALLIMITS);
                    ps.addBatch();
                }
                start.add(5, 1);
                ++count;
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected String _getWarnLedger(Context ctx, String companyNumber, BigDecimal residualLimits, int beforeDate) throws BOSException {
        try {
            StringBuffer msg = new StringBuffer();
            java.util.Date beginDate = new java.util.Date();
            java.util.Date endDate = this.getendDate(beforeDate);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("name", (Object)"\u4eba\u6c11\u5e01", CompareType.LIKE));
            SelectorItemCollection CurrencySelector = new SelectorItemCollection();
            CurrencySelector.add(new SelectorItemInfo("id"));
            CurrencySelector.add(new SelectorItemInfo("name"));
            CurrencySelector.add(new SelectorItemInfo("number"));
            view.setSelector(CurrencySelector);
            view.setFilter(filter1);
            CurrencyCollection acctColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
            String currencyId = "";
            if (acctColl.size() > 0) {
                CurrencyInfo currencyInfo = acctColl.get(0);
                currencyId = currencyInfo.getId().toString();
            }
            Set<String> companyNumbers = this.collectionId2Set(companyNumber);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", companyNumbers, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            evi.setSelector(selector);
            evi.setFilter(filter);
            CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
            if (companyOrgUnitCollection.size() <= 0 || companyOrgUnitCollection.size() != companyNumbers.size()) {
                return ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"659_BillPoolDcWarningFacadeControllerBean", (Locale)ctx.getLocale());
            }
            for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
                CompanyOrgUnitInfo OrgUnitInfo2 = companyOrgUnitCollection.get(i);
                IRowSet rs = this.getBankInfo(ctx, OrgUnitInfo2.getId().toString());
                while (rs.next()) {
                    String cooperativeBankID = rs.getString("cooperativeBankID");
                    String cooperativeBankName = rs.getString("cooperativeBankName");
                    System.out.println(cooperativeBankName);
                    FilterItemCollection filterItems = new FilterItemCollection();
                    filterItems.add(new FilterItemInfo("RECEIVABLEBILL.FcompanyId", (Object)OrgUnitInfo2.getId().toString(), CompareType.EQUALS));
                    filterItems.add(new FilterItemInfo("RECEIVABLEBILL.FcooperativeBankId", (Object)cooperativeBankID, CompareType.EQUALS));
                    filterItems.add(new FilterItemInfo("RECEIVABLEBILL.FCurrencyID", (Object)currencyId, CompareType.EQUALS));
                    String value = this.getWarnLedgerByDate(ctx, filterItems, beginDate, endDate, residualLimits, OrgUnitInfo2.getName().toString(), cooperativeBankName);
                    msg.append(value);
                }
            }
            if (!"".equals(msg.toString())) {
                return msg.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return null;
    }

    private Set<String> collectionId2Set(String str) {
        HashSet<String> set = new HashSet<String>();
        if (str != null && !"".equals(str)) {
            String[] strs = str.split(",");
            for (int i = 0; i < strs.length; ++i) {
                set.add(strs[i]);
            }
        }
        return set;
    }

    private IRowSet getBankInfo(Context ctx, String orgId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct ");
        sql.append(" ReceivableBill.FCooperativeBankID AS cooperativeBankID, ");
        sql.append(" Bank.FNAME_l2 AS cooperativeBankName ");
        sql.append(" FROM T_NT_ReceivableBill ReceivableBill  ");
        sql.append(" LEFT OUTER JOIN T_BD_Bank Bank   ");
        sql.append(" ON Bank.FID = ReceivableBill.FCooperativeBankID   ");
        sql.append(" where ReceivableBill.FBillState in (11) and ReceivableBill.FCooperativeBankID is not null  ");
        sql.append(" and ReceivableBill.FCompanyID = '" + orgId + "' ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    protected java.util.Date getendDate(int beforeDate) throws BOSException {
        java.util.Date beginDate = new java.util.Date();
        Calendar date = Calendar.getInstance();
        date.setTime(beginDate);
        date.set(5, date.get(5) + beforeDate);
        java.util.Date endDate = new java.util.Date();
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        try {
            endDate = dft.parse(dft.format(date.getTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return endDate;
    }

    protected String getWarnLedgerByDate(Context ctx, FilterItemCollection filterItems, java.util.Date beginDate, java.util.Date endDate, BigDecimal limits, String CompanyName, String cooperativeBankName) throws BOSException {
        StringBuffer msg = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        try {
            start.setTime(beginDate);
            end.setTime(endDate);
            end.add(5, 1);
            DcWarningRowSetVO dcWarningRowSetVO = this.getDcWarningSQL(ctx, filterItems, format.format(end.getTime()));
            if (dcWarningRowSetVO != null && dcWarningRowSetVO.getUSELIMITS().compareTo(limits) == 1) {
                return "";
            }
            while (start.before(end)) {
                String bizDateStr = format.format(start.getTime());
                DcWarningRowSetVO rowSetVO = this.getDcWarningSQL(ctx, filterItems, bizDateStr);
                if (rowSetVO != null) {
                    BigDecimal residuallimits = rowSetVO.getRESIDUALLIMITS();
                    BigDecimal bigLimits = limits;
                    java.util.Date bizDate = rowSetVO.getBIZDATE();
                    if (residuallimits.compareTo(bigLimits) == -1) {
                        msg.append(CompanyName + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"660_BillPoolDcWarningFacadeControllerBean", (Locale)ctx.getLocale()) + cooperativeBankName + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"661_BillPoolDcWarningFacadeControllerBean", (Locale)ctx.getLocale()) + format.format(bizDate) + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"662_BillPoolDcWarningFacadeControllerBean", (Locale)ctx.getLocale()) + bigLimits + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"663_BillPoolDcWarningFacadeControllerBean", (Locale)ctx.getLocale()) + "\n");
                        return msg.toString();
                    }
                }
                start.add(5, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return "";
    }

    @Override
    protected Map _getDcWarningExcelData(Context ctx, String tableName, String currencyID) throws BOSException {
        HashMap<String, Object> gridData = new HashMap<String, Object>();
        try {
            gridData.put("tableName", tableName);
            String keyCountSql = "SELECT COUNT(*) NUM FROM " + tableName;
            IRowSet keyCountRowSet = DbUtil.executeQuery((Context)ctx, (String)keyCountSql);
            keyCountRowSet.next();
            int num = keyCountRowSet.getInt("NUM");
            gridData.put("totalCount", num);
            if (num == 0) {
                gridData.put("dcWarningVOLists", new ArrayList());
            } else {
                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
                String selectKeySql = "SELECT BIZDATE, BILLPOOLLIMITS, USELIMITS, RESIDUALLIMITS  FROM " + tableName;
                IRowSet keyRowSet = DbUtil.executeQuery((Context)ctx, (String)selectKeySql);
                keyRowSet.next();
                ArrayList<DcWarningVO> dcWarningVOLists = new ArrayList<DcWarningVO>();
                keyRowSet.beforeFirst();
                while (keyRowSet.next()) {
                    DcWarningVO dcWarningVO = new DcWarningVO();
                    dcWarningVO.setBIZDATE(keyRowSet.getDate("BIZDATE"));
                    BigDecimal billpoollimits = keyRowSet.getBigDecimal("BILLPOOLLIMITS");
                    dcWarningVO.setBILLPOOLLIMITS(billpoollimits.setScale(currencyInfo.getPrecision(), 4).toString());
                    BigDecimal uselimits = keyRowSet.getBigDecimal("USELIMITS");
                    dcWarningVO.setUSELIMITS(uselimits.setScale(currencyInfo.getPrecision(), 4).toString());
                    BigDecimal residuallimits = keyRowSet.getBigDecimal("RESIDUALLIMITS");
                    dcWarningVO.setRESIDUALLIMITS(residuallimits.setScale(currencyInfo.getPrecision(), 4).toString());
                    dcWarningVOLists.add(dcWarningVO);
                }
                gridData.put("dcWarningVOLists", dcWarningVOLists);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return gridData;
    }
}

