/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.BillPoolJournalFactory;
import com.kingdee.eas.fm.ntp.BillPoolJournalInfo;
import com.kingdee.eas.fm.ntp.BizProcessTypeEnum;
import com.kingdee.eas.fm.ntp.DirectionEnum;
import com.kingdee.eas.fm.ntp.IPledgeToTrusteeBill;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.fm.ntp.NTPVerifyHelper;
import com.kingdee.eas.fm.ntp.PledgeToTrusteeBillCollection;
import com.kingdee.eas.fm.ntp.PledgeToTrusteeBillFactory;
import com.kingdee.eas.fm.ntp.PledgeToTrusteeBillInfo;
import com.kingdee.eas.fm.ntp.PoolTypeEnum;
import com.kingdee.eas.fm.ntp.TransferState;
import com.kingdee.eas.fm.ntp.app.AbstractPledgeToTrusteeBillControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PledgeToTrusteeBillControllerBean
extends AbstractPledgeToTrusteeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ntp.app.PledgeToTrusteeBillControllerBean");
    private IMutexServiceControl iMutex = null;
    public static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _submitNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PledgeToTrusteeBillInfo info = (PledgeToTrusteeBillInfo)model;
        info.setBizDate(new Date());
        info.setBillState(TransferState.SUBMITED);
        info.setCompany(info.getReceivableEntrys().get(0).getHolder());
        ArrayList<String> srcIdList = new ArrayList<String>();
        for (int i = 0; i < info.getReceivableEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = info.getReceivableEntrys().get(i);
            srcIdList.add(recInfo.getId().toString());
        }
        BatchExecuteResult result = this.beforeSubmit(ctx, info);
        if (result.getDetailMsgList().size() > 0) {
            return result;
        }
        try {
            this.iMutex.batchRequestObjIDForUpdate(srcIdList);
            ReceivableBillCollection collection = info.getReceivableEntrys();
            collection.clear();
            info.getReceivableEntrys();
            IObjectPK pk = super._submit(ctx, (IObjectValue)info);
            this.afterSubmit(ctx, info, pk, srcIdList);
        }
        finally {
            this.iMutex.batchReleaseObjIDForUpdate(srcIdList);
        }
        HashMap map = new HashMap();
        return map;
    }

    private BatchExecuteResult beforeSubmit(Context ctx, PledgeToTrusteeBillInfo info) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        this.iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ReceivableBillInfo recInfo = null;
        String recId = null;
        for (int i = 0; i < info.getReceivableEntrys().size(); ++i) {
            try {
                recInfo = info.getReceivableEntrys().get(i);
                recId = recInfo.getId().toString();
                ReceivableBillCollection coll = this.getReceivableBillInfo(ctx, recId);
                if (coll.size() > 0) {
                    recInfo = coll.get(0);
                }
                NTPVerifyHelper.verifyLock(ctx, this.iMutex, recInfo.getId().toString());
                NTPVerifyHelper.verifyOutPledgeOut(recInfo.getOutPledgeID());
                if (11 != recInfo.getBillState().getValue()) {
                    throw new NTPException(NTPException.POOLPLEDGE_CAN_OUT);
                }
                NTPVerifyHelper.verifyIsIsPledgeToTrustee(recInfo.isIsPledgeToTrustee());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"733_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"734_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (result.getDetailMsgList().size() > 0) {
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"735_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    private ReceivableBillCollection getReceivableBillInfo(Context ctx, String pk) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("elecBillStatus");
        selector.add("bankReturnStatus");
        selector.add("bankReturnMsg");
        selector.add("ntType.name");
        selector.add("currency.precision");
        selector.add("holder.name");
        selector.add("cooperativeBank.id");
        selector.add("cooperativeBank.name");
        selector.add("trusteeOutBill.id");
        view.setSelector(selector);
        ReceivableBillCollection coll = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(view);
        return coll;
    }

    private void afterSubmit(Context ctx, PledgeToTrusteeBillInfo info, IObjectPK pk, List<String> srcIdList) throws EASBizException, BOSException {
        ReceivableBillInfo recInfo = null;
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("pledgeToTrusteeBill"));
        updateSelector.add(new SelectorItemInfo("isPledgeToTrustee"));
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < srcIdList.size(); ++i) {
            idSet.add(srcIdList.get(i));
        }
        ReceivableBillCollection coll = this.getRecCollection(ctx, idSet);
        for (int i = 0; i < coll.size(); ++i) {
            recInfo = coll.get(i);
            recInfo.setPledgeToTrusteeBill(info);
            recInfo.setIsPledgeToTrustee(true);
            iReceivableBill.updatePartial((CoreBaseInfo)recInfo, updateSelector);
        }
        FMHelper.saveBOTRelation((Context)ctx, srcIdList, (String)pk.toString());
    }

    private ReceivableBillCollection getRecCollection(Context ctx, Set recIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)recIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("draftNumber");
        selector.add("billState");
        selector.add("isCollect");
        selector.add("trusteeOutBill.id");
        selector.add("currency.id");
        selector.add("ntType.id");
        selector.add("holder.id");
        selector.add("trusteeToPledgeBill.id");
        selector.add("trusteeToPledgeBill.billState");
        selector.add(new SelectorItemInfo("holder.name"));
        view.setSelector(selector);
        ReceivableBillCollection coll = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(view);
        return coll;
    }

    private PledgeToTrusteeBillCollection getPledgeToTrusteeCollection(Context ctx, Set recIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)recIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("receivableEntrys.id");
        view.setSelector(selector);
        PledgeToTrusteeBillCollection coll = PledgeToTrusteeBillFactory.getLocalInstance(ctx).getPledgeToTrusteeBillCollection(view);
        return coll;
    }

    @Override
    protected Map _deleteBatch(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        int success = 0;
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{pks.length + ""});
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            idSet.add(pks[i]);
        }
        PledgeToTrusteeBillCollection coll = this.getPledgeToTrusteeCollection(ctx, idSet);
        for (int i = 0; i < coll.size(); ++i) {
            PledgeToTrusteeBillInfo info = coll.get(i);
            try {
                if (!info.getBillState().equals((Object)TransferState.SUBMITED)) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"736_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), (String)"ntp_pledgeToTrusteeBill_02delete");
                if (!isPermission) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"737_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"738_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                this.doDelete(ctx, info);
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"739_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"740_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (success == pks.length) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(pks.length - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void doDelete(Context ctx, PledgeToTrusteeBillInfo info) throws EASBizException, BOSException {
        ReceivableBillCollection entryColl = info.getReceivableEntrys();
        ReceivableBillInfo recInfo = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            idSet.add(entryColl.get(i).getId().toString());
        }
        ReceivableBillCollection coll = this.getRecCollection(ctx, idSet);
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("pledgeToTrusteeBill"));
        updateSelector.add(new SelectorItemInfo("isPledgeToTrustee"));
        for (int i = 0; i < coll.size(); ++i) {
            recInfo = coll.get(i);
            recInfo.setPledgeToTrusteeBill(null);
            recInfo.setIsPledgeToTrustee(false);
            iReceivableBill.updatePartial((CoreBaseInfo)recInfo, updateSelector);
        }
        BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationByDestObjId(info.getId().toString(), info.getBOSType().toString());
        PledgeToTrusteeBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId().toString()));
    }

    @Override
    protected Map _auditBatch(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{pks.length + ""});
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IPledgeToTrusteeBill iPledgeToTrusteeBill = PledgeToTrusteeBillFactory.getLocalInstance(ctx);
        int success = 0;
        for (int i = 0; i < pks.length; ++i) {
            PledgeToTrusteeBillInfo info = iPledgeToTrusteeBill.getPledgeToTrusteeBillInfo((IObjectPK)new ObjectUuidPK(pks[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(pks[i]);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ntp_pledgeToTrusteeBill_03audit");
                if (!isPermission) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"741_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                if (!info.getBillState().equals((Object)TransferState.SUBMITED)) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"742_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                if (FMHelper.isInWorkFlow((Context)ctx, (String)info.getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"743_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                info.setBillState(TransferState.AUDITED);
                info.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setAuditDate(DateUtil.getDayBegin());
                SelectorItemCollection updateSelector = new SelectorItemCollection();
                updateSelector.add(new SelectorItemInfo("billState"));
                updateSelector.add(new SelectorItemInfo("auditor"));
                updateSelector.add(new SelectorItemInfo("auditDate"));
                iPledgeToTrusteeBill.updatePartial((CoreBaseInfo)info, updateSelector);
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.getDetailMsgList().add(info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"739_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"744_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (success == pks.length) {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"79_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale());
            result.setSummaryMsg(summary);
        } else {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"80_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(success) + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(pks.length - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"76_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale());
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _unAuditBatch(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{pks.length + ""});
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IPledgeToTrusteeBill iPledgeToTrusteeBill = PledgeToTrusteeBillFactory.getLocalInstance(ctx);
        int success = 0;
        for (int i = 0; i < pks.length; ++i) {
            PledgeToTrusteeBillInfo info = iPledgeToTrusteeBill.getPledgeToTrusteeBillInfo((IObjectPK)new ObjectUuidPK(pks[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(pks[i]);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ntp_pledgeToTrusteeBill_04unAudit");
                if (!isPermission) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"745_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                if (!info.getBillState().equals((Object)TransferState.AUDITED)) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"746_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                if (FMHelper.isInWorkFlow((Context)ctx, (String)pks[i])) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"743_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                info.setBillState(TransferState.SUBMITED);
                info.setAuditor(null);
                info.setAuditDate(null);
                SelectorItemCollection updateSelector = new SelectorItemCollection();
                updateSelector.add(new SelectorItemInfo("billState"));
                updateSelector.add(new SelectorItemInfo("auditor"));
                updateSelector.add(new SelectorItemInfo("auditDate"));
                iPledgeToTrusteeBill.updatePartial((CoreBaseInfo)info, updateSelector);
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.getDetailMsgList().add(info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"739_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"747_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (success == pks.length) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RES, (String)"ALL_UNAUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RES, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(pks.length - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _transferConfirm(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{pks.length + ""});
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("receivableEntrys.id"));
        sic.add(new SelectorItemInfo("pledgee.id"));
        sic.add(new SelectorItemInfo("pledgee.name"));
        sic.add(new SelectorItemInfo("transferDate"));
        sic.add(new SelectorItemInfo("confirmDate"));
        sic.add(new SelectorItemInfo("totalAmount"));
        sic.add(new SelectorItemInfo("count"));
        IPledgeToTrusteeBill iPledgeToTrusteeBill = PledgeToTrusteeBillFactory.getLocalInstance(ctx);
        CoreBaseCollection journalColl = new CoreBaseCollection();
        int success = 0;
        for (int i = 0; i < pks.length; ++i) {
            PledgeToTrusteeBillInfo info = iPledgeToTrusteeBill.getPledgeToTrusteeBillInfo((IObjectPK)new ObjectUuidPK(pks[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(pks[i]);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ntp_pledgeToTrusteeBill_05transfered");
                if (!isPermission) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"748_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                if (!info.getBillState().equals((Object)TransferState.AUDITED)) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"749_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                if (FMHelper.isInWorkFlow((Context)ctx, (String)info.getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"743_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                info.setBillState(TransferState.TRANSFERED);
                info.setTransferConfirmor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setConfirmDate(DateUtil.getDayBegin());
                this.updateBillPoolJournal(ctx, info, journalColl);
                this.doTransferConfirm(ctx, info);
                SelectorItemCollection updateSelector = new SelectorItemCollection();
                updateSelector.add(new SelectorItemInfo("billState"));
                updateSelector.add(new SelectorItemInfo("transferConfirmor"));
                updateSelector.add(new SelectorItemInfo("confirmDate"));
                iPledgeToTrusteeBill.updatePartial((CoreBaseInfo)info, updateSelector);
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.getDetailMsgList().add(info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"739_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"750_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (journalColl.size() > 0) {
            BillPoolJournalFactory.getLocalInstance(ctx).addnewBatchData(journalColl);
        }
        if (success == pks.length) {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"751_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale());
            result.setSummaryMsg(summary);
        } else {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"752_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + success + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + (pks.length - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"76_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale());
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void updateBillPoolJournal(Context ctx, PledgeToTrusteeBillInfo info, CoreBaseCollection journalColl) {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(info.getCompany());
        journalInfo.setBillID(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getTransferDate());
        journalInfo.setCreateDate(DateUtil.getDayBegin());
        journalInfo.setPoolType(PoolTypeEnum.PLEDGE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.PLEDGETOTRUSTEE);
        journalInfo.setDirection(DirectionEnum.OUTFLOW);
        journalInfo.setOutAmount(info.getTotalAmount());
        journalInfo.setCooperativeBank(info.getPledgee());
        journalInfo.setCooperativeBankName(info.getPledgee().getName());
        journalInfo.setCount(info.getCount());
        journalInfo.setCurrency(info.getCurrency());
        journalColl.add((CoreBaseInfo)journalInfo);
        BillPoolJournalInfo journalInfoIn = new BillPoolJournalInfo();
        journalInfoIn.setCompany(info.getCompany());
        journalInfoIn.setBillID(info.getId().toString());
        journalInfoIn.setBillNumber(info.getNumber());
        journalInfoIn.setBizDate(info.getTransferDate());
        journalInfoIn.setCreateDate(DateUtil.getDayBegin());
        journalInfoIn.setPoolType(PoolTypeEnum.TRUSTEE);
        journalInfoIn.setBizProcessType(BizProcessTypeEnum.PLEDGETOTRUSTEE);
        journalInfoIn.setDirection(DirectionEnum.INFLOW);
        journalInfoIn.setInAmount(info.getTotalAmount());
        journalInfoIn.setCooperativeBank(info.getPledgee());
        journalInfoIn.setCooperativeBankName(info.getPledgee().getName());
        journalInfoIn.setCount(info.getCount());
        journalInfoIn.setCurrency(info.getCurrency());
        journalColl.add((CoreBaseInfo)journalInfoIn);
    }

    @Override
    protected Map _cancelConfirm(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{pks.length + ""});
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("receivableEntrys.id"));
        IPledgeToTrusteeBill iPledgeToTrusteeBill = PledgeToTrusteeBillFactory.getLocalInstance(ctx);
        int success = 0;
        for (int i = 0; i < pks.length; ++i) {
            PledgeToTrusteeBillInfo info = iPledgeToTrusteeBill.getPledgeToTrusteeBillInfo((IObjectPK)new ObjectUuidPK(pks[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(pks[i]);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ntp_pledgeToTrusteeBill_06calTransfered");
                if (!isPermission) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"753_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                if (!info.getBillState().equals((Object)TransferState.TRANSFERED)) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"754_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                if (FMHelper.isInWorkFlow((Context)ctx, (String)info.getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"743_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
                }
                this.doCancelConfirm(ctx, info);
                info.setBillState(TransferState.AUDITED);
                info.setTransferConfirmor(null);
                info.setConfirmDate(null);
                SelectorItemCollection updateSelector = new SelectorItemCollection();
                updateSelector.add(new SelectorItemInfo("billState"));
                updateSelector.add(new SelectorItemInfo("transferConfirmor"));
                updateSelector.add(new SelectorItemInfo("confirmDate"));
                iPledgeToTrusteeBill.updatePartial((CoreBaseInfo)info, updateSelector);
                DbUtil.execute((Context)ctx, (String)("delete from T_NTP_BillPoolJournal  where FBillID ='" + info.getId().toString() + "'"));
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.getDetailMsgList().add(info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"739_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"755_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (success == pks.length) {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"756_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale());
            result.setSummaryMsg(summary);
        } else {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"757_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + success + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + (pks.length - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"76_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale());
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void doTransferConfirm(Context ctx, PledgeToTrusteeBillInfo info) throws EASBizException, BOSException {
        ReceivableBillCollection entryColl = info.getReceivableEntrys();
        ReceivableBillInfo recInfo = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            idSet.add(entryColl.get(i).getId().toString());
        }
        ReceivableBillCollection coll = this.getRecCollection(ctx, idSet);
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("billState"));
        updateSelector.add(new SelectorItemInfo("isPledgeToTrustee"));
        updateSelector.add(new SelectorItemInfo("billLastState"));
        updateSelector.add(new SelectorItemInfo("isPoolTrustee"));
        updateSelector.add(new SelectorItemInfo("isPoolPledge"));
        for (int i = 0; i < coll.size(); ++i) {
            recInfo = coll.get(i);
            recInfo.setBillLastState(recInfo.getBillState());
            recInfo.setBillState(BillStateEnum.POOLTRUSTEE);
            recInfo.setIsPledgeToTrustee(false);
            recInfo.setIsPoolTrustee(true);
            recInfo.setIsPoolPledge(false);
            iReceivableBill.updatePartial((CoreBaseInfo)recInfo, updateSelector);
        }
    }

    private void doCancelConfirm(Context ctx, PledgeToTrusteeBillInfo info) throws EASBizException, BOSException {
        ReceivableBillCollection entryColl = info.getReceivableEntrys();
        ReceivableBillInfo recInfo = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            idSet.add(entryColl.get(i).getId().toString());
        }
        ReceivableBillCollection coll = this.getRecCollection(ctx, idSet);
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("billState"));
        updateSelector.add(new SelectorItemInfo("isPledgeToTrustee"));
        updateSelector.add(new SelectorItemInfo("billLastState"));
        for (int i = 0; i < coll.size(); ++i) {
            recInfo = coll.get(i);
            if (12 != recInfo.getBillState().getValue()) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"758_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
            }
            NTPVerifyHelper.verifyIsCollect(recInfo.isIsCollect());
            NTPVerifyHelper.verifyIsTrusteeOut(recInfo.getTrusteeOutBill());
            NTPVerifyHelper.verifyIsTrusteeToPledge(recInfo.getTrusteeToPledgeBill());
            recInfo.setBillState(BillStateEnum.POOLPLEDGE);
            recInfo.setIsPledgeToTrustee(true);
            recInfo.setIsPoolTrustee(false);
            recInfo.setIsPoolPledge(true);
            recInfo.setBillLastState(recInfo.getBillState());
            iReceivableBill.updatePartial((CoreBaseInfo)recInfo, updateSelector);
        }
    }
}

