/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.BillPoolJournalFactory;
import com.kingdee.eas.fm.ntp.BillPoolJournalInfo;
import com.kingdee.eas.fm.ntp.BillTransBizType;
import com.kingdee.eas.fm.ntp.BizProcessTypeEnum;
import com.kingdee.eas.fm.ntp.DirectionEnum;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.fm.ntp.NTPUtil;
import com.kingdee.eas.fm.ntp.NTPVerifyHelper;
import com.kingdee.eas.fm.ntp.PoolTypeEnum;
import com.kingdee.eas.fm.ntp.TransferState;
import com.kingdee.eas.fm.ntp.TrusteeToPledgeBillCollection;
import com.kingdee.eas.fm.ntp.TrusteeToPledgeBillInfo;
import com.kingdee.eas.fm.ntp.app.AbstractTrusteeToPledgeBillControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrusteeToPledgeBillControllerBean
extends AbstractTrusteeToPledgeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ntp.app.TrusteeToPledgeBillControllerBean");
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String NTP_RESOURCE = "com.kingdee.eas.fm.ntp.NtpResource";
    private IMutexServiceControl iMutex = null;
    private ReceivableBillCollection recCollForLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _submit(Context ctx, IObjectValue model, Set recIdSet) throws BOSException, EASBizException {
        TrusteeToPledgeBillInfo info = (TrusteeToPledgeBillInfo)model;
        info.setCU(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit());
        this._checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
        ReceivableBillCollection coll = this.getRecCollection(ctx, recIdSet);
        info.setBillState(TransferState.SUBMITED);
        info.setBizDate(new Date());
        info.setCurrency(coll.get(0).getCurrency());
        info.setNtType(coll.get(0).getNtType());
        info.setCount(coll.size());
        info.setCompany(coll.get(0).getHolder());
        ArrayList<String> srcIdList = new ArrayList<String>();
        BatchExecuteResult result = this.beforeSubmit(ctx, info, coll, srcIdList);
        if (srcIdList.size() < coll.size()) {
            return result;
        }
        try {
            this.iMutex.batchRequestObjIDForUpdate(srcIdList);
            IObjectPK pk = super._submit(ctx, (IObjectValue)info);
            this.afterSubmit(ctx, info, coll, srcIdList, pk);
        }
        finally {
            this.iMutex.batchReleaseObjIDForUpdate(srcIdList);
        }
        return null;
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        return super._checkNumberDup(ctx, pk, model);
    }

    private BatchExecuteResult beforeSubmit(Context ctx, TrusteeToPledgeBillInfo info, ReceivableBillCollection coll, List<String> srcIdList) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        this.iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ReceivableBillInfo recInfo = null;
        String recId = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                recInfo = coll.get(i);
                recId = recInfo.getId().toString();
                NTPVerifyHelper.verifyLock(ctx, this.iMutex, recInfo.getId().toString());
                NTPVerifyHelper.verifyIsTrusteeOut(recInfo.getTrusteeOutBill());
                NTPVerifyHelper.verifyIsTrusteeToPledge(recInfo.getTrusteeToPledgeBill());
                NTPVerifyHelper.verifyIsPoolTrustee(recInfo.getBillState().getValue());
                NTPVerifyHelper.verifyIsCollect(recInfo.isIsCollect());
                srcIdList.add(recId);
                info.getReceivableEntrys().add(recInfo);
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"733_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"763_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (result.getDetailMsgList().size() > 0) {
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"735_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    private void afterSubmit(Context ctx, TrusteeToPledgeBillInfo info, ReceivableBillCollection coll, List<String> srcIdList, IObjectPK pk) throws EASBizException, BOSException {
        ReceivableBillInfo recInfo = null;
        CoreBaseCollection baseColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            recInfo = coll.get(i);
            recInfo.setTrusteeToPledgeBill(info);
            baseColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(baseColl);
        FMHelper.saveBOTRelation((Context)ctx, srcIdList, (String)pk.toString());
        NTPUtil.addBillTransLogByColl(ctx, coll, BillTransBizType.TRUSTEETOPLEDGE_SUBMIT);
    }

    private ReceivableBillCollection getRecCollection(Context ctx, Set recIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)recIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("draftNumber");
        selector.add("billState");
        selector.add("isCollect");
        selector.add("trusteeToPledgeBill.id");
        selector.add("trusteeOutBill.id");
        selector.add("currency.id");
        selector.add("ntType.id");
        selector.add("holder.id");
        selector.add(new SelectorItemInfo("holder.name"));
        view.setSelector(selector);
        ReceivableBillCollection coll = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(view);
        return coll;
    }

    @Override
    protected Map _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeToPledgeBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection baseColl = new CoreBaseCollection();
        this.recCollForLog = new ReceivableBillCollection();
        TrusteeToPledgeBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeToPledge_03audit")) {
                    throw new NTPException(NTPException.NO_AUDIT_AUTHRIZED);
                }
                if (TransferState.SUBMITED != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEETOPLEDGE_AUDIT);
                }
                info.setBillState(TransferState.AUDITED);
                UserInfo auditUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
                info.setAuditor(auditUser);
                info.setAuditDate(DATE_FORMAT.parse(DATE_FORMAT.format(new Date())));
                baseColl.add((CoreBaseInfo)info);
                this.recCollForLog.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"764_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"56_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (baseColl.size() > 0) {
            this.updateBatchData(ctx, baseColl);
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEETOPLEDGE_AUDIT);
        }
        if (baseColl.size() == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"ALL_AUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(baseColl.size()), String.valueOf(coll.size() - baseColl.size())});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _unAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeToPledgeBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection baseColl = new CoreBaseCollection();
        this.recCollForLog = new ReceivableBillCollection();
        TrusteeToPledgeBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeToPledge_04unaudit")) {
                    throw new NTPException(NTPException.NO_UNAUDIT_AUTHRIZED);
                }
                if (TransferState.AUDITED != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEETOPLEDGE_UNAUDIT);
                }
                info.setBillState(TransferState.SUBMITED);
                info.setAuditor(null);
                info.setAuditDate(null);
                baseColl.add((CoreBaseInfo)info);
                this.recCollForLog.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"764_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"60_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (baseColl.size() > 0) {
            this.updateBatchData(ctx, baseColl);
        }
        if (baseColl.size() == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"ALL_UNAUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(baseColl.size()), String.valueOf(coll.size() - baseColl.size())});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _delete(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        StringBuffer truIdsBuffer = new StringBuffer("(");
        StringBuffer recIdsBuffer = new StringBuffer("(");
        int deletedIdsCount = 0;
        TrusteeToPledgeBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        TrusteeToPledgeBillInfo info = null;
        ReceivableBillCollection recColl = null;
        this.recCollForLog = new ReceivableBillCollection();
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeToPledge_02delete")) {
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
                if (TransferState.SUBMITED != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEETOPLEDGE_DELETE);
                }
                ++deletedIdsCount;
                DbUtil.execute((Context)ctx, (String)("delete from T_bot_relation  where FDESTOBJECTID = '" + info.getId().toString() + "' and FDESTENTITYID ='" + info.getBOSType().toString() + "'"));
                truIdsBuffer.append("'" + info.getId().toString() + "',");
                recColl = info.getReceivableEntrys();
                this.recCollForLog.addCollection(recColl);
                for (int j = 0; j < recColl.size(); ++j) {
                    recIdsBuffer.append("'" + recColl.get(j).getId().toString() + "',");
                }
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"764_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"64_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (deletedIdsCount > 0) {
            truIdsBuffer.deleteCharAt(truIdsBuffer.length() - 1);
            truIdsBuffer.append(")");
            DbUtil.execute((Context)ctx, (String)("delete from T_NTP_TrusteeToPledgeBill  where FID in " + truIdsBuffer.toString()));
            recIdsBuffer.deleteCharAt(recIdsBuffer.length() - 1);
            recIdsBuffer.append(")");
            DbUtil.execute((Context)ctx, (String)("update t_nt_ReceivableBill set FTrusteeToPlegdeID=null  where FID in " + recIdsBuffer.toString()));
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEETOPLEDGE_DELETE);
        }
        if (deletedIdsCount == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(deletedIdsCount), String.valueOf(coll.size() - deletedIdsCount)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _transferConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeToPledgeBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection recCoreColl = new CoreBaseCollection();
        CoreBaseCollection billCoreColl = new CoreBaseCollection();
        CoreBaseCollection journalColl = new CoreBaseCollection();
        this.recCollForLog = new ReceivableBillCollection();
        TrusteeToPledgeBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeToPledge_05confirm")) {
                    throw new NTPException(NTPException.NO_TRANSFERCONFIRM_PERMISSION);
                }
                if (TransferState.AUDITED != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEETOPLEDGE_CONFIRM);
                }
                this.setValue4TrusteeToPledgeBill(ctx, info, billCoreColl, true);
                this.updateBillPoolJournal(ctx, info, journalColl);
                this.setValue4ReceivableBill(ctx, info, recCoreColl, true);
                this.recCollForLog.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"764_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"765_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (billCoreColl.size() > 0) {
            this.updateBatchData(ctx, billCoreColl);
            BillPoolJournalFactory.getLocalInstance(ctx).addnewBatchData(journalColl);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recCoreColl);
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEETOPLEDGE_CONFIRM);
        }
        if (billCoreColl.size() == coll.size()) {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"766_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale());
            result.setSummaryMsg(summary);
        } else {
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"752_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + String.valueOf(billCoreColl.size()) + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + String.valueOf(coll.size() - billCoreColl.size()) + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"76_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale());
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _cancelConfirm(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeToPledgeBillInfo info = this.getInfoById(ctx, id);
        if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeToPledge_06cancelConfirm")) {
            throw new NTPException(NTPException.NO_CANCELCONFIRM_PERMISSION);
        }
        if (TransferState.TRANSFERED != info.getBillState()) {
            throw new NTPException(NTPException.TRUSTEETOPLEDGE_CANCELCONFIRM);
        }
        ReceivableBillCollection recColl = info.getReceivableEntrys();
        CoreBaseCollection recCoreColl = new CoreBaseCollection();
        ReceivableBillInfo recInfo = null;
        for (int i = 0; i < recColl.size(); ++i) {
            try {
                recInfo = recColl.get(i);
                if (BillStateEnum.POOLPLEDGE != recInfo.getBillState()) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"733_PledgeToTrusteeBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"767_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()));
                }
                NTPVerifyHelper.verifyIsCollect(recInfo.isIsCollect());
                NTPVerifyHelper.verifyOutPledgeOut(recInfo.getOutPledgeID());
                NTPVerifyHelper.verifyIsPledgeToTrustee(recInfo.isIsPledgeToTrustee());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"764_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"768_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (result.getDetailMsgList().size() == 0) {
            this.setValue4TrusteeToPledgeBill(ctx, info, null, false);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            DbUtil.execute((Context)ctx, (String)("delete from T_NTP_BillPoolJournal  where FBillID ='" + info.getId().toString() + "'"));
            this.setValue4ReceivableBill(ctx, info, recCoreColl, false);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recCoreColl);
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"769_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"770_TrusteeToPledgeBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    private void setValue4TrusteeToPledgeBill(Context ctx, TrusteeToPledgeBillInfo info, CoreBaseCollection billCoreColl, boolean isConfirm) {
        if (isConfirm) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            info.setConfirmor(userInfo);
            info.setConfirmDate(DateUtil.getDayBegin());
            info.setBillState(TransferState.TRANSFERED);
            billCoreColl.add((CoreBaseInfo)info);
        } else {
            info.setBillState(TransferState.AUDITED);
            info.setConfirmor(null);
            info.setConfirmDate(null);
        }
    }

    private void updateBillPoolJournal(Context ctx, TrusteeToPledgeBillInfo info, CoreBaseCollection journalColl) {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(info.getCompany());
        journalInfo.setBillID(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getTransferDate());
        journalInfo.setCreateDate(info.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.TRUSTEE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEETOPLEDGE);
        journalInfo.setDirection(DirectionEnum.OUTFLOW);
        journalInfo.setOutAmount(info.getTotalAmount());
        journalInfo.setCooperativeBank(info.getPledgee());
        journalInfo.setCooperativeBankName(info.getPledgee().getName());
        journalInfo.setCount(info.getCount());
        journalInfo.setCurrency(info.getCurrency());
        journalColl.add((CoreBaseInfo)journalInfo);
        journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(info.getCompany());
        journalInfo.setBillID(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getTransferDate());
        journalInfo.setCreateDate(info.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.PLEDGE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEETOPLEDGE);
        journalInfo.setDirection(DirectionEnum.INFLOW);
        journalInfo.setInAmount(info.getTotalAmount());
        journalInfo.setCooperativeBank(info.getPledgee());
        journalInfo.setCooperativeBankName(info.getPledgee().getName());
        journalInfo.setCount(info.getCount());
        journalInfo.setCurrency(info.getCurrency());
        journalColl.add((CoreBaseInfo)journalInfo);
    }

    private void setValue4ReceivableBill(Context ctx, TrusteeToPledgeBillInfo info, CoreBaseCollection recCoreColl, boolean isConfirm) {
        ReceivableBillCollection recColl = info.getReceivableEntrys();
        ReceivableBillInfo recInfo = null;
        if (isConfirm) {
            for (int i = 0; i < recColl.size(); ++i) {
                recInfo = recColl.get(i);
                recInfo.setBillLastState(recInfo.getBillState());
                recInfo.setBillState(BillStateEnum.POOLPLEDGE);
                recInfo.setIsPoolPledge(true);
                recInfo.setIsPoolTrustee(false);
                recCoreColl.add((CoreBaseInfo)recInfo);
            }
        } else {
            for (int i = 0; i < recColl.size(); ++i) {
                recInfo = recColl.get(i);
                recInfo.setBillLastState(recInfo.getBillState());
                recInfo.setBillState(BillStateEnum.POOLTRUSTEE);
                recInfo.setIsPoolPledge(false);
                recInfo.setIsPoolTrustee(true);
                recCoreColl.add((CoreBaseInfo)recInfo);
            }
        }
    }

    private TrusteeToPledgeBillCollection getCollByIDSet(Context ctx, Set idSet) throws BOSException {
        SelectorItemCollection selector = this.getSelector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(selector);
        return this.getTrusteeToPledgeBillCollection(ctx, evi);
    }

    private TrusteeToPledgeBillInfo getInfoById(Context ctx, String id) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        return this.getCollByIDSet(ctx, idSet).get(0);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("billState");
        selector.add("auditor.id");
        selector.add("auditDate");
        selector.add("company.id");
        selector.add("pledgee.id");
        selector.add("transferDate");
        selector.add("confirmDate");
        selector.add("totalAmount");
        selector.add("count");
        selector.add("currency.id");
        selector.add("pledgeee.name");
        selector.add("receivableEntrys.id");
        selector.add("receivableEntrys.billState");
        selector.add("receivableEntrys.outPledgeID");
        selector.add("receivableEntrys.draftNumber");
        selector.add("receivableEntrys.billMedium");
        selector.add("receivableEntrys.isCollect");
        selector.add("receivableEntrys.isPledge");
        selector.add("receivableEntrys.isTrustee");
        selector.add("receivableEntrys.isPledge");
        selector.add("receivableEntrys.isDisPledge");
        selector.add("receivableEntrys.expiredDate");
        selector.add("receivableEntrys.holder.id");
        selector.add("receivableEntrys.inPoolDate");
        selector.add("receivableEntrys.isPledgeToTrustee");
        selector.add("receivableEntrys.cooperativeBankName");
        selector.add("receivableEntrys.cooperativeBank.id");
        return selector;
    }
}

