/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.PledgeToTrusteeBillInfo;
import com.kingdee.eas.fm.ntp.common.INtpModelCreate;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;

public class PledgeToTrusteeModelCreator
implements INtpModelCreate {
    private Context context = null;

    @Override
    public IObjectValue createModel(IObjectValue infoObj, String bosType, String mainOrgUnitId, Context context) throws BOSException, EASBizException {
        this.context = context;
        Object obj = null;
        obj = "6C449858".equals(bosType) ? this.createPledgeToTrustee(infoObj, bosType, mainOrgUnitId, context) : infoObj;
        return obj;
    }

    private PledgeToTrusteeBillInfo createPledgeToTrustee(IObjectValue infoObj, String bosType, String pks, Context ctx) throws BOSException, EASBizException {
        PledgeToTrusteeBillInfo billInfo = (PledgeToTrusteeBillInfo)infoObj;
        ReceivableBillCollection receivableBillCollection = billInfo.getReceivableEntrys();
        if (pks != null) {
            String[] ids = pks.split(",");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < ids.length; ++i) {
                idSet.add(ids[i]);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.getSelector().add("*");
            evi.getSelector().add("company.id");
            evi.getSelector().add("company.name");
            evi.getSelector().add("ntType.id");
            evi.getSelector().add("ntType.name");
            evi.getSelector().add("currency.id");
            evi.getSelector().add("currency.name");
            evi.getSelector().add("currency.precision");
            evi.getSelector().add("cooperativeBank.id");
            evi.getSelector().add("cooperativeBank.name");
            ReceivableBillCollection coll = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(evi);
            int precision = 0;
            if (coll.size() > 0) {
                precision = coll.get(0).getCurrency().getPrecision();
            }
            BigDecimal sumBillAmt = new BigDecimal(0);
            Date minDate = new Date();
            Date maxDate = new Date();
            for (int i = 0; i < coll.size(); ++i) {
                ReceivableBillInfo info = coll.get(i);
                BigDecimal billAmt = info.getBillAmt();
                info.setBillAmt(billAmt.setScale(precision, 4));
                sumBillAmt = sumBillAmt.add(billAmt);
                if (i == 0) {
                    minDate = info.getInPoolDate();
                    maxDate = info.getExpiredDate();
                    billInfo.setBillMedium(info.getBillMedium());
                    billInfo.setPledgee(info.getCooperativeBank());
                    billInfo.setCurrency(info.getCurrency());
                    billInfo.setNtType(info.getNtType());
                    billInfo.setCurrency(info.getCurrency());
                    continue;
                }
                if (minDate.compareTo(info.getInPoolDate()) < 0) {
                    minDate = info.getInPoolDate();
                }
                if (maxDate.compareTo(info.getExpiredDate()) <= 0) continue;
                maxDate = info.getExpiredDate();
            }
            receivableBillCollection.addCollection(coll);
            sumBillAmt.setScale(precision, 4);
            billInfo.setTotalAmount(sumBillAmt);
            billInfo.put("maxDate", maxDate);
            billInfo.put("minDate", minDate);
            billInfo.put("precision", precision);
            billInfo.setTransferDate(new Date());
            billInfo.setCount(coll.size());
        }
        return billInfo;
    }
}

