/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FMAccountBankBalanceHelper {
    private static Logger logger = Logger.getLogger((String)FMAccountBankBalanceHelper.class.getName());
    static Map ComInacctCur_BalanceMap = new HashMap();

    public static BigDecimal getBeAcctBankBalance(Context ctx, String acctbankId, CurrencyInfo currencyInfo) throws BOSException {
        BigDecimal balance = Constants.ZERO;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1  FBALANCE FROM T_BE_AccountBankBalance ");
        sql.append(" WHERE FACCOUNTBANKID ='");
        sql.append(acctbankId);
        sql.append("' AND FCURRENCYID ='");
        sql.append(currencyInfo.getId().toString());
        sql.append("' ORDER BY FBIZDATE desc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                balance = rs.getBigDecimal("FBALANCE");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (EmptyUtil.isEmpty((Object)balance)) {
            balance = Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    public static BigDecimal getNoBeAcctBankBalance(Context ctx, String companyId, String accountBankId, CurrencyInfo currencyInfo, Date beginDate, Date endDate, CashDataTypeEnum dataType) throws BOSException, EASBizException {
        BigDecimal balance = CashManagementFactory.getLocalInstance((Context)ctx).getBankData(companyId, accountBankId, currencyInfo.getId().toString(), beginDate, endDate, dataType, true);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    public static BigDecimal getInnerAcctBankBalance(Context ctx, String companyNumber, String innerAcctNumber, CurrencyInfo currencyInfo, Date beginDay, Date endDay, InAcctDataTypeEnum inAcctDataType) throws BOSException, EASBizException {
        BigDecimal balance = InAcctFactory.getLocalInstance((Context)ctx).inAcct(companyNumber, innerAcctNumber, currencyInfo.getNumber(), beginDay, endDay, inAcctDataType);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map getBeAcctBankBalance(Context ctx, List beAcctbankList) throws BOSException {
        StringBuffer beAcctbankIds = new StringBuffer();
        if (beAcctbankList.size() <= 0) return new HashMap();
        for (int i = 0; i < beAcctbankList.size(); ++i) {
            String beAcctId = (String)beAcctbankList.get(i);
            beAcctbankIds.append("'");
            beAcctbankIds.append(beAcctId);
            beAcctbankIds.append("'");
            if (i >= beAcctbankList.size() - 1) continue;
            beAcctbankIds.append(",");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FCOMPANYID , FACCOUNTBANKID ,FCURRENCYID,max(FBIZDATE) date");
        sql.append(" FROM T_BE_AccountBankBalance  group by FCOMPANYID ,FACCOUNTBANKID,FCURRENCYID");
        sql.append("having   FACCOUNTBANKID in ('");
        sql.append(beAcctbankIds.toString());
        sql.append("')");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) return new HashMap();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return new HashMap();
    }

    public static Map batchGetinnerAcctBalance(Context ctx, Map com_InnerAcctMap, Date beginDay) throws EASBizException, BOSException {
        Set companyIdSet = com_InnerAcctMap.keySet();
        if (companyIdSet != null) {
            for (Object companyId : companyIdSet) {
                List innAcctList = (List)com_InnerAcctMap.get(companyId);
                BankInfo CHInfo = FSHelper.getClearingHouseInfo((Context)ctx, (String)((String)companyId));
                Date unSettledDate = new Date("1994/01/01");
                if (CHInfo != null && CHInfo.getSettleDate() != null) {
                    unSettledDate = CHInfo.getSettleDate();
                }
                if (!beginDay.before(unSettledDate)) {
                    FMAccountBankBalanceHelper.subsidiaryLedgerQuery(ctx, (String)companyId, new HashSet(innAcctList), unSettledDate, beginDay);
                    beginDay = DateUtil.getBeforeDay((Date)unSettledDate);
                }
                FMAccountBankBalanceHelper.SummaryLedgerQuery(ctx, (String)companyId, new HashSet(innAcctList), beginDay);
            }
        }
        return ComInacctCur_BalanceMap;
    }

    private static void subsidiaryLedgerQuery(Context ctx, String companyID, Set innerAcctSet, Date beginDate, Date endDate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("amountOffset"));
        selector.add(new SelectorItemInfo("company.id", "companyID"));
        selector.add(new SelectorItemInfo("currency"));
        selector.add(new SelectorItemInfo("innerAccountID"));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("innerAccountID", (Object)innerAcctSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)endDate, CompareType.LESS_EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fm.fs.SubsidiaryLedgerQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        String sql = exec.getSQL();
        sql = "select sum(amountOffset) amountOffset , companyID, innerAccountID,currency from (" + sql + ") as subTable group by companyID ,innerAccountID, currency";
        BigDecimal amountOffset = null;
        String companyId = null;
        String currenyId = null;
        String innerAcctId = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = FMAccountBankBalanceHelper.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                companyId = rs.getString("companyID");
                innerAcctId = rs.getString("innerAccountID");
                currenyId = rs.getString("currency");
                amountOffset = rs.getBigDecimal("amountOffset");
                if (amountOffset == null) {
                    amountOffset = Constants.ZERO;
                }
                ComInacctCur_BalanceMap.put(companyId + ";" + innerAcctId + ";" + currenyId, amountOffset);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    private static void SummaryLedgerQuery(Context ctx, String companyID, Set InnerAcctIdSet, Date beginDay) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("endBalance"));
        selector.add("company.id", "companyID");
        selector.add(new SelectorItemInfo("innerAccountID"));
        selector.add(new SelectorItemInfo("currencyID"));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("innerAccountID", (Object)InnerAcctIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beginDay, CompareType.EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fm.fs.SummaryLedgerQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        String sql = exec.getSQL();
        sql = "select sum(endBalance) balance , companyID, currencyID, innerAccountID from (" + sql + ") as subTable group by companyID,innerAccountID,currencyID";
        BigDecimal balance = null;
        String companyId = null;
        String currenyId = null;
        String innerAcctId = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = FMAccountBankBalanceHelper.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                BigDecimal amount;
                companyId = rs.getString("companyID");
                innerAcctId = rs.getString("innerAccountID");
                currenyId = rs.getString("currencyID");
                balance = rs.getBigDecimal("balance");
                if (balance == null) {
                    balance = Constants.ZERO;
                }
                if ((amount = (BigDecimal)ComInacctCur_BalanceMap.get(companyId + ";" + innerAcctId + ";" + currenyId)) == null) {
                    amount = Constants.ZERO;
                }
                balance = balance.add(amount);
                ComInacctCur_BalanceMap.put(companyId + ";" + innerAcctId + ";" + currenyId, balance);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }
}

