/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fm.ps.FundPropertyCollection;
import com.kingdee.eas.fm.ps.FundPropertyFactory;
import com.kingdee.eas.fm.ps.FundPropertyInfo;
import com.kingdee.eas.fm.ps.RevenueAndExpensesMarkEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundPropertyDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)FundPropertyDataImport.class.getName());
    private Map infoMap = new HashMap(100);
    private String lastKey;
    private String curKey;
    private CompanyOrgUnitInfo currentCompany;

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return FundPropertyFactory.getLocalInstance((Context)ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        FundPropertyInfo head = new FundPropertyInfo();
        String number = (String)this.getData(hsData, "number");
        boolean flag = true;
        this.curKey = number;
        logger.error((Object)("\u83b7\u53d6\u5230EXCEL \u5355\u636e\u7f16\u7801\u4e3a\uff1a" + number));
        if (this.lastKey == null) {
            this.lastKey = this.curKey;
        }
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            head = (FundPropertyInfo)this.parseHead(hsData, ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)head.getNumber()));
            view.setFilter(fi);
            FundPropertyCollection coll = null;
            try {
                coll = FundPropertyFactory.getLocalInstance((Context)ctx).getFundPropertyCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll.size() > 0) {
                head.setId(coll.get(0).getId());
            }
        } else {
            if (EmptyUtil.isEmpty((String)number)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"025_setFundProperty", (Locale)ctx.getLocale()));
            }
            if (!this.isExistHead(hsData, ctx)) {
                if (!this.infoMap.containsKey(this.curKey)) {
                    head = (FundPropertyInfo)this.parseHead(hsData, ctx);
                    this.infoMap.put(this.curKey, head);
                } else {
                    head = (FundPropertyInfo)this.infoMap.get(this.curKey);
                }
            }
            if (flag) {
                head.setNumber(this.curKey);
            }
        }
        return head;
    }

    private boolean isExistHead(Hashtable hsData, Context ctx) throws BOSException {
        String number = (String)this.getData(hsData, "number");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (number == null) {
            return true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        evi.setFilter(filter);
        FundPropertyCollection coll = FundPropertyFactory.getLocalInstance((Context)ctx).getFundPropertyCollection(evi);
        if (coll != null && coll.size() > 0) {
            throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"022_setFundProperty", (Locale)ctx.getLocale()));
        }
        return false;
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx) throws BOSException {
        FundPropertyInfo info = new FundPropertyInfo();
        BigDecimal zero = Constants.ZERO;
        Object data = null;
        data = this.getData(hsData, "number");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "name")) != null && data.toString().trim().length() > 0) {
            info.setName(data.toString());
        }
        if ((data = this.getData(hsData, "revenueAndExpensesMark")) != null && data.toString().trim().length() > 0) {
            if ("1".equals(data)) {
                info.setRevenueAndExpensesMark(RevenueAndExpensesMarkEnum.REVENUE);
            } else if ("2".equals(data)) {
                info.setRevenueAndExpensesMark(RevenueAndExpensesMarkEnum.EXPENSES);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"023_setFundProperty", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "parentNumber")) != null && data.toString().trim().length() > 0) {
            FundPropertyInfo pInfo = new FundPropertyInfo();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", data));
            evi.setFilter(filter);
            FundPropertyCollection coll = FundPropertyFactory.getLocalInstance((Context)ctx).getFundPropertyCollection(evi);
            if (coll.equals(null) && coll.size() == 0) {
                throw new BOSException(data + ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"024_setFundProperty", (Locale)ctx.getLocale()));
            }
            pInfo = coll.get(0);
            info.setParent(pInfo);
        }
        if ((data = this.getData(hsData, "description")) != null && data.toString().trim().length() > 0) {
            info.setDescription(data.toString());
        }
        return info;
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            this._getController(ctx).addnew(coreBaseInfo);
        } else {
            this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
        }
    }
}

