/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillAccountEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillCollection;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillAccountEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountOutBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillCollection;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillAccountEntryCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillAccountEntryCollection;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillCollection;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillCollection;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillAccountEntryCollection;
import com.kingdee.eas.cp.bc.TravelAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillCollection;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanCollection;
import com.kingdee.eas.fi.ar.OtherBillPlanFactory;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.pp.AutoGenPayPlanAndRecPlanFacadeFactory;
import com.kingdee.eas.fm.pp.IAutoGenPayPlanAndRecPlanFacade;
import com.kingdee.eas.fm.pp.PayPlanBillCollection;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.RecPlanBillCollection;
import com.kingdee.eas.fm.pp.RecPlanBillFactory;
import com.kingdee.eas.fm.pp.RecPlanBillInfo;
import com.kingdee.eas.fm.pp.SrcBillTypeEnum;
import com.kingdee.eas.fm.pp.app.AbstractAutoGenPayPlanAndRecPlanFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoGenPayPlanAndRecPlanFacadeControllerBean
extends AbstractAutoGenPayPlanAndRecPlanFacadeControllerBean {
    private static final long serialVersionUID = -253429178816337921L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.AutoGenPayPlanAndRecPlanFacadeControllerBean");
    private Date currentDate = DateTimeUtils.truncateDate((Date)new Date());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _autoGenPayPlan(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"\u5f00\u59cb\u6267\u884c\u4ed8\u6b3e\u7533\u8bf7\u5355\u81ea\u52a8\u751f\u6210\u4ed8\u6b3e\u8ba1\u5212\u7684\u540e\u53f0\u4e8b\u52a1");
        Set<String> companySet = this.getCompanySet(ctx);
        if (companySet == null || companySet.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u516c\u53f8");
            return;
        }
        PayRequestSumEntryCollection sumEntrys = this.getSrcPayReqSumEntrys(ctx, companySet, null);
        if (sumEntrys == null || sumEntrys.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355");
            return;
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IAutoGenPayPlanAndRecPlanFacade facade = AutoGenPayPlanAndRecPlanFacadeFactory.getLocalInstance(ctx);
        boolean isLock = false;
        for (int i = 0; i < sumEntrys.size(); ++i) {
            PayRequestSumEntryInfo entry = sumEntrys.get(i);
            String srcId = entry.getParent().getId().toString();
            String srcEntryId = entry.getId().toString();
            try {
                isLock = iMutex.requestObjIDForUpdate(srcId);
                if (!isLock) continue;
                facade.genOnePayPlanFromAP(srcId, srcEntryId, companySet);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u4ed8\u6b3e\u7533\u8bf7\u5355\uff1a" + entry.getParent().getNumber() + "\u751f\u6210\u4ed8\u6b3e\u8ba1\u5212\u5355\u62a5\u9519"));
                logger.error((Object)e);
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(srcId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _autoGenRecPlan(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"\u5f00\u59cb\u6267\u884c\u5e94\u6536\u5355\u81ea\u52a8\u751f\u6210\u6536\u6b3e\u8ba1\u5212\u7684\u540e\u53f0\u4e8b\u52a1");
        Set<String> companySet = this.getCompanySet(ctx);
        if (companySet == null || companySet.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u516c\u53f8");
            return;
        }
        OtherBillPlanCollection recOtherPlancoll = this.getSrcOtherBillPlans(ctx, companySet, null);
        if (recOtherPlancoll == null || recOtherPlancoll.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5e94\u6536\u5355");
            return;
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IAutoGenPayPlanAndRecPlanFacade facade = AutoGenPayPlanAndRecPlanFacadeFactory.getLocalInstance(ctx);
        boolean isLock = false;
        for (int i = 0; i < recOtherPlancoll.size(); ++i) {
            OtherBillPlanInfo otherBillPlan = recOtherPlancoll.get(i);
            String srcId = otherBillPlan.getParent().getId().toString();
            String srcEntryId = otherBillPlan.getId().toString();
            try {
                isLock = iMutex.requestObjIDForUpdate(srcEntryId);
                if (!isLock) continue;
                facade.genOneRecPlanFromAR(srcId, srcEntryId, companySet);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u5e94\u6536\u5355\uff1a" + otherBillPlan.getParent().getNumber() + "\u5206\u5f55" + otherBillPlan.getId().toString() + "\u751f\u6210\u6536\u6b3e\u8ba1\u5212\u5355\u62a5\u9519"));
                logger.error((Object)e);
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(srcEntryId);
                }
            }
        }
    }

    private PayRequestSumEntryCollection getSrcPayReqSumEntrys(Context ctx, Set companySet, String srcEntryId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("parent.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.billStatus", (Object)3));
        filter.getFilterItems().add(new FilterItemInfo("parent.isPaySchedule", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("parent.company.id", (Object)companySet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("payableDate", (Object)this.currentDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isPayPlanCreated", (Object)0));
        if (srcEntryId != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)srcEntryId));
        }
        view.setSelector(selector);
        view.setFilter(filter);
        PayRequestSumEntryCollection coll = PayRequestSumEntryFactory.getLocalInstance((Context)ctx).getPayRequestSumEntryCollection(view);
        return coll;
    }

    private OtherBillPlanCollection getSrcOtherBillPlans(Context ctx, Set companySet, String srcEntryId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("parent.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.billStatus", (Object)3));
        filter.getFilterItems().add(new FilterItemInfo("parent.company.id", (Object)companySet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("recievePayDate", (Object)this.currentDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isPayPlanCreated", (Object)0));
        if (srcEntryId != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)srcEntryId));
        }
        view.setSelector(selector);
        view.setFilter(filter);
        OtherBillPlanCollection coll = OtherBillPlanFactory.getLocalInstance((Context)ctx).getOtherBillPlanCollection(view);
        return coll;
    }

    @Override
    protected void _genOnePayPlanFromAP(Context ctx, String srcId, String srcEntryId, Set companySet) throws BOSException, EASBizException {
        PayRequestSumEntryInfo entry;
        PayPlanBillInfo payPlanBill;
        String sql = "update T_AP_PayRequestBill set FLASTUPDATETIME = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), srcId});
        PayRequestSumEntryCollection sumEntrys = this.getSrcPayReqSumEntrys(ctx, companySet, srcEntryId);
        if (sumEntrys != null && sumEntrys.size() > 0 && (payPlanBill = this.transPayPlanBillInfo(ctx, entry = sumEntrys.get(0))) != null) {
            AutoGenPayPlanAndRecPlanFacadeFactory.getLocalInstance(ctx).genOnePayPlanBill(payPlanBill);
        }
    }

    @Override
    protected void _genOneRecPlanFromAR(Context ctx, String srcId, String srcEntryId, Set companySet) throws BOSException, EASBizException {
        OtherBillPlanInfo entry;
        RecPlanBillInfo recPlanBill;
        String sql = "update T_AR_OtherBill set FLASTUPDATETIME = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), srcId});
        OtherBillPlanCollection recOtherPlancoll = this.getSrcOtherBillPlans(ctx, companySet, srcEntryId);
        if (recOtherPlancoll != null && recOtherPlancoll.size() > 0 && (recPlanBill = this.transRecPlanBillInfo(ctx, entry = recOtherPlancoll.get(0))) != null) {
            AutoGenPayPlanAndRecPlanFacadeFactory.getLocalInstance(ctx).genOneRecPlanBill(recPlanBill);
        }
    }

    private RecPlanBillInfo transRecPlanBillInfo(Context ctx, OtherBillPlanInfo otherBillPlan) throws BTPException, BOSException {
        RecPlanBillInfo recPlanBill = null;
        OtherBillInfo otherBill = otherBillPlan.getParent();
        otherBill.getRecievePlan().clear();
        otherBill.getRecievePlan().add(otherBillPlan);
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)otherBill, new RecPlanBillInfo().getBOSType().toString());
        RecPlanBillCollection recPlanColl = (RecPlanBillCollection)btpResult.getBills();
        if (recPlanColl.size() > 0) {
            recPlanBill = recPlanColl.get(0);
            recPlanBill.setSourceBillId(otherBill.getId().toString());
            recPlanBill.setSrcBillHeadID(otherBillPlan.getId().toString());
            recPlanBill.setSourceBillType(SrcBillTypeEnum.AR_OTHERBILL);
            recPlanBill.setSourceBillNumber(otherBill.getNumber());
        }
        return recPlanBill;
    }

    private PayPlanBillInfo transPayPlanBillInfo(Context ctx, PayRequestSumEntryInfo entry) throws BTPException, BOSException {
        PayPlanBillInfo payPlanBill = null;
        PayRequestBillInfo info = entry.getParent();
        info.getSumEntry().clear();
        info.getSumEntry().add(entry);
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)info, new PayPlanBillInfo().getBOSType().toString());
        PayPlanBillCollection PayPlanColl = (PayPlanBillCollection)btpResult.getBills();
        if (PayPlanColl.size() > 0) {
            payPlanBill = PayPlanColl.get(0);
            payPlanBill.setSourceBillId(info.getId().toString());
            payPlanBill.setSrcBillHeadID(entry.getId().toString());
            payPlanBill.setSourceBillType(SrcBillTypeEnum.PAYREQUESTBILL);
            payPlanBill.setSourceBillNumber(info.getNumber());
        }
        return payPlanBill;
    }

    private Set<String> getCompanySet(Context ctx) throws EASBizException, BOSException {
        HashSet<String> companySet = new HashSet<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"PS301"));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)true));
        viewInfo.setFilter(filter);
        ParamItemCollection coll = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(viewInfo);
        for (int i = 0; i < coll.size(); ++i) {
            companySet.add(coll.get(i).getOrgUnitID().getId().toString());
        }
        return companySet;
    }

    @Override
    public void _genOneRecPlanBill(Context ctx, RecPlanBillInfo recPlanBillInfo) throws BOSException, EASBizException {
        IObjectPK pk = RecPlanBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)recPlanBillInfo);
        logger.error((Object)"\u4fdd\u5b58\u6210\u529f");
        ArrayList<String> srcIdList = new ArrayList<String>();
        String sourceBillID = recPlanBillInfo.getSourceBillId();
        srcIdList.add(sourceBillID);
        BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)pk.toString());
        logger.error((Object)"\u4fdd\u5b58botp\u5173\u7cfb\u6210\u529f");
    }

    @Override
    public void _genOnePayPlanBill(Context ctx, PayPlanBillInfo payPlanBillInfo) throws BOSException, EASBizException {
        IObjectPK pk = PayPlanBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)payPlanBillInfo);
        logger.error((Object)"\u4fdd\u5b58\u6210\u529f");
        ArrayList<String> srcIdList = new ArrayList<String>();
        String sourceBillID = payPlanBillInfo.getSourceBillId();
        srcIdList.add(sourceBillID);
        BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)pk.toString());
        logger.error((Object)"\u4fdd\u5b58botp\u5173\u7cfb\u6210\u529f");
    }

    @Override
    public Map _pullToRecPlan(Context ctx, String[] ids, String mappingID, String srcBosType) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        Set ids2Set = CASWebUtil.ids2Set((String[])ids);
        BOTMappingInfo botMapInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(mappingID));
        if ("FC910EF3".equals(srcBosType)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("parent.*"));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids2Set, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(sic);
            OtherBillPlanCollection otherBillPlanColl = OtherBillPlanFactory.getLocalInstance((Context)ctx).getOtherBillPlanCollection(view);
            if (otherBillPlanColl != null && otherBillPlanColl.size() > 0) {
                for (int i = 0; i < otherBillPlanColl.size(); ++i) {
                    OtherBillPlanInfo otherPlan = otherBillPlanColl.get(i);
                    OtherBillInfo otherInfo = otherPlan.getParent();
                    try {
                        OtherBillInfo newOtherBill = (OtherBillInfo)otherInfo.clone();
                        newOtherBill.getRecievePlan().clear();
                        newOtherBill.getRecievePlan().add(otherPlan);
                        RecPlanBillInfo recPlanBillInfo = this.transRecPlanBillInfo(ctx, newOtherBill, botMapInfo);
                        AutoGenPayPlanAndRecPlanFacadeFactory.getLocalInstance(ctx).genOneRecPlanBill(recPlanBillInfo);
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_TRANSFORM_FAIL", (String[])new String[]{otherInfo.getCompany().getName(), otherInfo.getNumber(), String.valueOf(otherPlan.getSeq())}) + e.getMessage());
                    }
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"ALL_TRANSFORM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"TRANSFORM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private RecPlanBillInfo transRecPlanBillInfo(Context ctx, OtherBillInfo otherBillInfoNew, BOTMappingInfo botMapInfo) throws BTPException, BOSException {
        RecPlanBillInfo recPlanBill = null;
        ArrayList<CoreBillBaseCollection> srcBillColsList = new ArrayList<CoreBillBaseCollection>();
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)otherBillInfoNew);
        srcBillColsList.add(sourceBillCollection);
        ArrayList<String> botMappingPKCols = new ArrayList<String>();
        botMappingPKCols.add(botMapInfo.getId().toString());
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(srcBillColsList, new RecPlanBillInfo().getBOSType().toString(), botMappingPKCols);
        RecPlanBillCollection recPlanColl = (RecPlanBillCollection)btpResult.getBills();
        if (recPlanColl.size() > 0) {
            recPlanBill = recPlanColl.get(0);
            recPlanBill.setSourceBillId(otherBillInfoNew.getId().toString());
            recPlanBill.setSrcBillHeadID(otherBillInfoNew.getRecievePlan().get(0).getId().toString());
            recPlanBill.setSourceBillType(SrcBillTypeEnum.AR_OTHERBILL);
            recPlanBill.setSourceBillNumber(otherBillInfoNew.getNumber());
        }
        return recPlanBill;
    }

    @Override
    public void _autoGenPayPlanFromBC(Context ctx, int beforeDays) throws BOSException, EASBizException {
        EvectionLoanBillCollection evectionLoanBillCollection;
        DailyLoanBillCollection dailyLoanBillCollection;
        BizAccountOutBillCollection bizAccountOutBillCollection;
        DailyPurchaseAccountBillCollection dailyPurchaseAccountBillCollection;
        TravelAccountBillCollection travelAccountBillCollection;
        logger.error((Object)"\u5f00\u59cb\u6267\u884c\u8d39\u7528\u5355\u636e\u81ea\u52a8\u751f\u6210\u4ed8\u6b3e\u8ba1\u5212\u7684\u540e\u53f0\u4e8b\u52a1");
        Set<String> companySet = this.getCompanySet(ctx);
        if (companySet == null || companySet.size() == 0) {
            logger.error((Object)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u516c\u53f8");
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("id"));
        FilterInfo filter = this.getBcFilters(ctx, companySet, beforeDays);
        view.setFilter(filter);
        view.setSelector(seletor);
        BizAccountBillCollection bizAccountBillCollection = BizAccountBillFactory.getLocalInstance((Context)ctx).getBizAccountBillCollection(view);
        if (bizAccountBillCollection != null && bizAccountBillCollection.size() > 0) {
            logger.error((Object)"\u8d39\u7528\u62a5\u9500\u5355 \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5f00\u59cb");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < bizAccountBillCollection.size(); ++i) {
                idSet.add(bizAccountBillCollection.get(i).getId().toString());
            }
            this.transToPayPlan(ctx, idSet, 3);
            logger.error((Object)"\u8d39\u7528\u62a5\u9500\u5355 \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5b8c\u6210");
        }
        if ((travelAccountBillCollection = TravelAccountBillFactory.getLocalInstance((Context)ctx).getTravelAccountBillCollection(view)) != null && travelAccountBillCollection.size() > 0) {
            logger.error((Object)"\u5dee\u65c5\u8d39\u62a5\u9500\u5355 \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5f00\u59cb");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < travelAccountBillCollection.size(); ++i) {
                idSet.add(travelAccountBillCollection.get(i).getId().toString());
            }
            this.transToPayPlan(ctx, idSet, 4);
            logger.error((Object)"\u5dee\u65c5\u8d39\u62a5\u9500\u5355 \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5b8c\u6210");
        }
        if ((dailyPurchaseAccountBillCollection = DailyPurchaseAccountBillFactory.getLocalInstance((Context)ctx).getDailyPurchaseAccountBillCollection(view)) != null && dailyPurchaseAccountBillCollection.size() > 0) {
            logger.error((Object)"\u7269\u54c1\u91c7\u8d2d\u62a5\u9500\u5355 \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5f00\u59cb");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < dailyPurchaseAccountBillCollection.size(); ++i) {
                idSet.add(dailyPurchaseAccountBillCollection.get(i).getId().toString());
            }
            this.transToPayPlan(ctx, idSet, 5);
            logger.error((Object)"\u7269\u54c1\u91c7\u8d2d\u62a5\u9500\u5355 \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5b8c\u6210");
        }
        if ((bizAccountOutBillCollection = BizAccountOutBillFactory.getLocalInstance((Context)ctx).getBizAccountOutBillCollection(view)) != null && bizAccountOutBillCollection.size() > 0) {
            logger.error((Object)"\u5bf9\u516c\u62a5\u9500\u5355  \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5f00\u59cb");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < bizAccountOutBillCollection.size(); ++i) {
                idSet.add(bizAccountOutBillCollection.get(i).getId().toString());
            }
            this.transToPayPlan(ctx, idSet, 6);
            logger.error((Object)"\u5bf9\u516c\u62a5\u9500\u5355  \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5b8c\u6210");
        }
        if ((dailyLoanBillCollection = DailyLoanBillFactory.getLocalInstance((Context)ctx).getDailyLoanBillCollection(view)) != null && dailyLoanBillCollection.size() > 0) {
            logger.error((Object)"\u501f\u6b3e\u5355   \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5f00\u59cb");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < dailyLoanBillCollection.size(); ++i) {
                idSet.add(dailyLoanBillCollection.get(i).getId().toString());
            }
            this.transToPayPlan(ctx, idSet, 7);
            logger.error((Object)"\u501f\u6b3e\u5355   \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5b8c\u6210");
        }
        if ((evectionLoanBillCollection = EvectionLoanBillFactory.getLocalInstance((Context)ctx).getEvectionLoanBillCollection(view)) != null && evectionLoanBillCollection.size() > 0) {
            logger.error((Object)"\u51fa\u5dee\u501f\u6b3e\u5355  \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5f00\u59cb");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < evectionLoanBillCollection.size(); ++i) {
                idSet.add(evectionLoanBillCollection.get(i).getId().toString());
            }
            this.transToPayPlan(ctx, idSet, 8);
            logger.error((Object)"\u51fa\u5dee\u501f\u6b3e\u5355  \u8f6c\u6362 \u4ed8\u6b3e\u8ba1\u5212 \u5b8c\u6210");
        }
    }

    private FilterInfo getBcFilters(Context ctx, Set<String> companySet, int beforeDays) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("applierCompany.id", companySet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isPaySchedule", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("isCreatePayPlanBill", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isCallBackPayPlan", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
        filter.getFilterItems().add(new FilterItemInfo("amount", (Object)BigDecimal.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("bizReqDate", (Object)this.getBeforeDay(this.currentDate, beforeDays), CompareType.GREATER_EQUALS));
        return filter;
    }

    private Date getBeforeDay(Date thisDate, int beforeDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, -beforeDays);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transToPayPlan(Context ctx, Set<String> idSet, int SrcBillType) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IAutoGenPayPlanAndRecPlanFacade iAutoGenPayPlanAndRecPlanFacade = AutoGenPayPlanAndRecPlanFacadeFactory.getLocalInstance(ctx);
        boolean isLock = false;
        for (String id : idSet) {
            try {
                isLock = iMutex.requestObjIDForUpdate(id);
                if (!isLock) continue;
                iAutoGenPayPlanAndRecPlanFacade.genPayPlanCollFromOneBC(id, SrcBillType);
            }
            catch (Exception e) {
                logger.error((Object)("\u8d39\u7528\u5355\uff1a" + id + "\u751f\u6210\u4ed8\u6b3e\u8ba1\u5212\u5355\u62a5\u9519"));
                logger.error((Object)e);
            }
            finally {
                if (!isLock) continue;
                iMutex.releaseObjIDForUpdate(id);
            }
        }
    }

    @Override
    protected void _genPayPlanCollFromOneBC(Context ctx, String srcId, int srcBillType) throws BOSException, EASBizException {
        PayPlanBillCollection PayPlanColl = this.transPayPlanColl(ctx, srcId, srcBillType);
        for (int i = 0; i < PayPlanColl.size(); ++i) {
            PayPlanBillInfo payPlanBill = PayPlanColl.get(i);
            AutoGenPayPlanAndRecPlanFacadeFactory.getLocalInstance(ctx).genOnePayPlanBill(payPlanBill);
        }
    }

    private PayPlanBillCollection transPayPlanColl(Context ctx, String srcId, int srcBillType) throws BOSException, EASBizException {
        PayPlanBillCollection PayPlanColl = new PayPlanBillCollection();
        switch (srcBillType) {
            case 3: {
                BizAccountBillInfo bizAccountTnfo = BizAccountBillFactory.getLocalInstance((Context)ctx).getBizAccountBillInfo((IObjectPK)new ObjectUuidPK(srcId));
                if (bizAccountTnfo == null) break;
                PayPlanColl = this.doTransPayPlanBillColl(ctx, bizAccountTnfo);
                break;
            }
            case 4: {
                TravelAccountBillInfo travelAccountInfo = TravelAccountBillFactory.getLocalInstance((Context)ctx).getTravelAccountBillInfo((IObjectPK)new ObjectUuidPK(srcId));
                if (travelAccountInfo == null) break;
                PayPlanColl = this.doTransPayPlanBillColl(ctx, travelAccountInfo);
                break;
            }
            case 5: {
                DailyPurchaseAccountBillInfo dailyPurchaseAccountInfo = DailyPurchaseAccountBillFactory.getLocalInstance((Context)ctx).getDailyPurchaseAccountBillInfo((IObjectPK)new ObjectUuidPK(srcId));
                if (dailyPurchaseAccountInfo == null) break;
                PayPlanColl = this.doTransPayPlanBillColl(ctx, dailyPurchaseAccountInfo);
                break;
            }
            case 6: {
                BizAccountOutBillInfo bizAccountOutInfo = BizAccountOutBillFactory.getLocalInstance((Context)ctx).getBizAccountOutBillInfo((IObjectPK)new ObjectUuidPK(srcId));
                if (bizAccountOutInfo == null) break;
                PayPlanColl = this.doTransPayPlanBillColl(ctx, bizAccountOutInfo);
                break;
            }
            case 7: {
                DailyLoanBillInfo dailyLoanInfo = DailyLoanBillFactory.getLocalInstance((Context)ctx).getDailyLoanBillInfo((IObjectPK)new ObjectUuidPK(srcId));
                if (dailyLoanInfo == null) break;
                PayPlanColl = this.doTransPayPlanBillColl(ctx, dailyLoanInfo);
                break;
            }
            case 8: {
                EvectionLoanBillInfo evectionLoanInfo = EvectionLoanBillFactory.getLocalInstance((Context)ctx).getEvectionLoanBillInfo((IObjectPK)new ObjectUuidPK(srcId));
                if (evectionLoanInfo == null) break;
                PayPlanColl = this.doTransPayPlanBillColl(ctx, evectionLoanInfo);
            }
        }
        return PayPlanColl;
    }

    private PayPlanBillCollection doTransPayPlanBillColl(Context ctx, BizAccountBillInfo info) throws BTPException, BOSException {
        PayPlanBillCollection payPlanBillColl = new PayPlanBillCollection();
        PayPlanBillInfo payPlanBill = null;
        if (info.getCollectionEntries().size() >= 1) {
            BizAccountBillAccountEntryCollection copyColl = (BizAccountBillAccountEntryCollection)info.getCollectionEntries().clone();
            info.getCollectionEntries().clear();
            for (int i = 0; i < copyColl.size(); ++i) {
                BizAccountBillInfo newInfo = (BizAccountBillInfo)info.clone();
                BizAccountBillAccountEntryInfo entryInfo = copyColl.get(i);
                newInfo.getCollectionEntries().add(entryInfo);
                BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)newInfo, new PayPlanBillInfo().getBOSType().toString());
                PayPlanBillCollection PayPlanColl = (PayPlanBillCollection)btpResult.getBills();
                if (PayPlanColl.size() <= 0) continue;
                payPlanBill = PayPlanColl.get(0);
                payPlanBill.setSourceBillId(newInfo.getId().toString());
                payPlanBill.setSrcBillHeadID(entryInfo.getId().toString());
                payPlanBill.setSourceBillType(SrcBillTypeEnum.BC_BizAccountBill);
                payPlanBill.setSourceBillNumber(newInfo.getNumber());
                payPlanBillColl.add(payPlanBill);
            }
        }
        return payPlanBillColl;
    }

    private PayPlanBillCollection doTransPayPlanBillColl(Context ctx, TravelAccountBillInfo info) throws BTPException, BOSException {
        PayPlanBillCollection payPlanBillColl = new PayPlanBillCollection();
        PayPlanBillInfo payPlanBill = null;
        if (info.getCollectionEntries().size() >= 1) {
            TravelAccountBillAccountEntryCollection copyColl = (TravelAccountBillAccountEntryCollection)info.getCollectionEntries().clone();
            info.getCollectionEntries().clear();
            for (int i = 0; i < copyColl.size(); ++i) {
                TravelAccountBillInfo newInfo = (TravelAccountBillInfo)info.clone();
                TravelAccountBillAccountEntryInfo entryInfo = copyColl.get(i);
                newInfo.getCollectionEntries().add(entryInfo);
                BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)newInfo, new PayPlanBillInfo().getBOSType().toString());
                PayPlanBillCollection PayPlanColl = (PayPlanBillCollection)btpResult.getBills();
                if (PayPlanColl.size() <= 0) continue;
                payPlanBill = PayPlanColl.get(0);
                payPlanBill.setSourceBillId(newInfo.getId().toString());
                payPlanBill.setSrcBillHeadID(entryInfo.getId().toString());
                payPlanBill.setSourceBillType(SrcBillTypeEnum.BC_TravelAccountBill);
                payPlanBill.setSourceBillNumber(newInfo.getNumber());
                payPlanBillColl.add(payPlanBill);
            }
        }
        return payPlanBillColl;
    }

    private PayPlanBillCollection doTransPayPlanBillColl(Context ctx, DailyPurchaseAccountBillInfo info) throws BTPException, BOSException {
        PayPlanBillCollection payPlanBillColl = new PayPlanBillCollection();
        PayPlanBillInfo payPlanBill = null;
        if (info.getCollectionEntries().size() >= 1) {
            DailyPurchaseAccountBillAccountEntryCollection copyColl = (DailyPurchaseAccountBillAccountEntryCollection)info.getCollectionEntries().clone();
            info.getCollectionEntries().clear();
            for (int i = 0; i < copyColl.size(); ++i) {
                DailyPurchaseAccountBillInfo newInfo = (DailyPurchaseAccountBillInfo)info.clone();
                DailyPurchaseAccountBillAccountEntryInfo entryInfo = copyColl.get(i);
                newInfo.getCollectionEntries().add(entryInfo);
                BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)newInfo, new PayPlanBillInfo().getBOSType().toString());
                PayPlanBillCollection PayPlanColl = (PayPlanBillCollection)btpResult.getBills();
                if (PayPlanColl.size() <= 0) continue;
                payPlanBill = PayPlanColl.get(0);
                payPlanBill.setSourceBillId(newInfo.getId().toString());
                payPlanBill.setSrcBillHeadID(entryInfo.getId().toString());
                payPlanBill.setSourceBillType(SrcBillTypeEnum.BC_DailyPurchaseAccountBill);
                payPlanBill.setSourceBillNumber(newInfo.getNumber());
                payPlanBillColl.add(payPlanBill);
            }
        }
        return payPlanBillColl;
    }

    private PayPlanBillCollection doTransPayPlanBillColl(Context ctx, BizAccountOutBillInfo info) throws BTPException, BOSException {
        PayPlanBillCollection payPlanBillColl = new PayPlanBillCollection();
        PayPlanBillInfo payPlanBill = null;
        if (info.getCollectionEntries().size() >= 1) {
            BizAccountOutBillAccountEntryCollection copyColl = (BizAccountOutBillAccountEntryCollection)info.getCollectionEntries().clone();
            info.getCollectionEntries().clear();
            for (int i = 0; i < copyColl.size(); ++i) {
                BizAccountOutBillInfo newInfo = (BizAccountOutBillInfo)info.clone();
                BizAccountOutBillAccountEntryInfo entryInfo = copyColl.get(i);
                newInfo.getCollectionEntries().add(entryInfo);
                BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)newInfo, new PayPlanBillInfo().getBOSType().toString());
                PayPlanBillCollection PayPlanColl = (PayPlanBillCollection)btpResult.getBills();
                if (PayPlanColl.size() <= 0) continue;
                payPlanBill = PayPlanColl.get(0);
                payPlanBill.setSourceBillId(newInfo.getId().toString());
                payPlanBill.setSrcBillHeadID(entryInfo.getId().toString());
                payPlanBill.setSourceBillType(SrcBillTypeEnum.BC_BizAccountOutBill);
                payPlanBill.setSourceBillNumber(newInfo.getNumber());
                payPlanBillColl.add(payPlanBill);
            }
        }
        return payPlanBillColl;
    }

    private PayPlanBillCollection doTransPayPlanBillColl(Context ctx, DailyLoanBillInfo info) throws BTPException, BOSException {
        PayPlanBillCollection payPlanBillColl = new PayPlanBillCollection();
        PayPlanBillInfo payPlanBill = null;
        if (info.getCollectionEntries().size() >= 1) {
            DailyLoanBillAccountEntryCollection copyColl = (DailyLoanBillAccountEntryCollection)info.getCollectionEntries().clone();
            info.getCollectionEntries().clear();
            for (int i = 0; i < copyColl.size(); ++i) {
                DailyLoanBillInfo newInfo = (DailyLoanBillInfo)info.clone();
                DailyLoanBillAccountEntryInfo entryInfo = copyColl.get(i);
                newInfo.getCollectionEntries().add(entryInfo);
                BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)newInfo, new PayPlanBillInfo().getBOSType().toString());
                PayPlanBillCollection PayPlanColl = (PayPlanBillCollection)btpResult.getBills();
                if (PayPlanColl.size() <= 0) continue;
                payPlanBill = PayPlanColl.get(0);
                payPlanBill.setSourceBillId(newInfo.getId().toString());
                payPlanBill.setSrcBillHeadID(entryInfo.getId().toString());
                payPlanBill.setSourceBillType(SrcBillTypeEnum.BC_DailyLoanBill);
                payPlanBill.setSourceBillNumber(newInfo.getNumber());
                payPlanBillColl.add(payPlanBill);
            }
        }
        return payPlanBillColl;
    }

    private PayPlanBillCollection doTransPayPlanBillColl(Context ctx, EvectionLoanBillInfo info) throws BTPException, BOSException {
        PayPlanBillCollection payPlanBillColl = new PayPlanBillCollection();
        PayPlanBillInfo payPlanBill = null;
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)info, new PayPlanBillInfo().getBOSType().toString());
        PayPlanBillCollection PayPlanColl = (PayPlanBillCollection)btpResult.getBills();
        if (PayPlanColl.size() > 0) {
            payPlanBill = PayPlanColl.get(0);
            payPlanBill.setSourceBillId(info.getId().toString());
            payPlanBill.setSrcBillHeadID(info.getId().toString());
            payPlanBill.setSourceBillType(SrcBillTypeEnum.BC_EvectionLoanBill);
            payPlanBill.setSourceBillNumber(info.getNumber());
            payPlanBillColl.add(payPlanBill);
        }
        return payPlanBillColl;
    }
}

