/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.pp.IPayPlanBill;
import com.kingdee.eas.fm.pp.PayPlanBillCollection;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.fm.pp.app.PayRecPlanDataImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PayPlanBillDataImport
extends AbstractFMDataImport {
    String resourcePath = "com.kingdee.eas.fm.pp.PpResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.PayPlanBillDataImport");

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return PayPlanBillFactory.getLocalInstance(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        Object asstActNumberData;
        PayPlanBillInfo info = new PayPlanBillInfo();
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        this.verifyNotNull(info, ctx);
        Object asstActType = this.getData(hsData, "asstActType");
        if (!EmptyUtil.isEmpty((Object)asstActType) && info.getAsstActType() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoAsstActType", (Locale)ctx.getLocale()));
        }
        Object companyData = this.getData(hsData, "company");
        CompanyOrgUnitInfo company = PayRecPlanDataImportUtil.getCompanyByNumber(ctx, (String)companyData);
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), "payPlanBill_07import");
        String companyId = company.getId().toString();
        CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
        Object currencyData = this.getData(hsData, "currency");
        CurrencyInfo currency = PayRecPlanDataImportUtil.getCurrencyByNumber(ctx, (String)currencyData);
        String currencyId = currency.getId().toString();
        Object applyPayAmountData = this.getData(hsData, "applyPayAmount");
        BigDecimal applyPayAmount = PayRecPlanDataImportUtil.objToBigDecimal(ctx, applyPayAmountData);
        if (applyPayAmount.compareTo(BigDecimal.ZERO) == 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"applyPayAmountNotZero", (Locale)ctx.getLocale()));
        }
        applyPayAmount = applyPayAmount.setScale(currency.getPrecision(), 4);
        info.setApplyPayAmount(applyPayAmount);
        BigDecimal applyPayLocAmt = PayRecPlanDataImportUtil.getLocAmount(ctx, companyId, currencyId, baseCurrency, applyPayAmount, info.getPayableDate());
        info.setApplyPayLocAmt(applyPayLocAmt);
        Object setFundPropertyData = this.getData(hsData, "setFundProperty");
        SetFundPropertyInfo setFundProPerty = PayRecPlanDataImportUtil.getSetFundPropertyByNumber(ctx, (String)setFundPropertyData, companyId);
        info.setSetFundProperty(setFundProPerty);
        Object payerAccountBankData = this.getData(hsData, "payerAccountBank");
        AccountBankInfo accountBank = PayRecPlanDataImportUtil.getAccountBankByNumber(ctx, "payerAccountBank", companyId, (String)payerAccountBankData, true, false);
        info.setPayerAccountBank(accountBank);
        if (info.getDepartment() == null) {
            Object departmentData = this.getData(hsData, "department");
            AdminOrgUnitInfo department = PayRecPlanDataImportUtil.getDepartmentByNumber(ctx, (String)departmentData);
            info.setDepartment(department);
        }
        if (info.getSettlementType() == null) {
            Object settlementTypeData = this.getData(hsData, "settlementType");
            SettlementTypeInfo settlementType = PayRecPlanDataImportUtil.getSettlementTypeByNumber(ctx, (String)settlementTypeData);
            info.setSettlementType(settlementType);
        }
        if ((asstActNumberData = this.getData(hsData, "asstActName")) == null || asstActNumberData.toString().trim().length() <= 0) return info;
        if (info.getAsstActType() != null) {
            IRowSet asstActInfo = PayRecPlanDataImportUtil.getAsstActInfoByName(info.getAsstActType(), (String)asstActNumberData, ctx);
            try {
                if (!asstActInfo.next()) return info;
                String tableName = info.getAsstActType().getRealtionDataObject();
                if ((tableName.equalsIgnoreCase("T_BD_SUPPLIER") || tableName.equalsIgnoreCase("T_BD_CUSTOMER")) && !EmptyUtil.isEmpty((String)asstActInfo.getString("fusedstatus"))) {
                    if (!asstActInfo.getString("fusedstatus").equals("1")) {
                        throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"MUSTBEAPPROVE", (Locale)ctx.getLocale()));
                    }
                    info.setAsstActID(asstActInfo.getString("fid"));
                    info.setAsstActNumber(asstActInfo.getString("fnumber"));
                    String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                    info.setAsstActName(asstActInfo.getString("fname_" + loc));
                    return info;
                }
                info.setAsstActID(asstActInfo.getString("fid"));
                info.setAsstActNumber(asstActInfo.getString("fnumber"));
                String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                info.setAsstActName(asstActInfo.getString("fname_" + loc));
                return info;
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage());
            }
        } else {
            info.setAsstActName(asstActNumberData.toString());
        }
        return info;
    }

    private void verifyNotNull(PayPlanBillInfo info, Context ctx) throws BOSException {
        if (info.getApplyPayDate() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoApplyPayDate", (Locale)ctx.getLocale()));
        }
        if (info.getPayableDate() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoPayableDate", (Locale)ctx.getLocale()));
        }
        if (info.getCompany() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoCompany", (Locale)ctx.getLocale()));
        }
        if (info.getCurrency() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoCurrency", (Locale)ctx.getLocale()));
        }
        if (info.getApplyPayAmount() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoApplyPayAmount", (Locale)ctx.getLocale()));
        }
        if (info.getPaymentBillType() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoPaymentBillType", (Locale)ctx.getLocale()));
        }
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        PayPlanBillInfo payPlan = (PayPlanBillInfo)coreBaseInfo;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (payPlan.getNumber() != null && mode == 16) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)payPlan.getNumber()));
            view.setFilter(filter);
            IPayPlanBill payPlanBill = (IPayPlanBill)this._getController(ctx);
            PayPlanBillCollection coll = payPlanBill.getPayPlanBillCollection(view);
            if (coll != null && coll.size() > 0) {
                coreBaseInfo.setId(coll.get(0).getId());
            }
        }
        this._getController(ctx).save(coreBaseInfo);
    }

    protected String getTemplateNumber() {
        return "payPlanBill";
    }
}

