/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.IPayPlanBill;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PayPlanBillCollection;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.StatusEnum;
import com.kingdee.eas.fm.pp.app.AbstractPayPlanBillWebFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayPlanBillWebFacadeControllerBean
extends AbstractPayPlanBillWebFacadeControllerBean {
    private static final long serialVersionUID = -8884020539712221890L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.PayPlanBillWebFacadeControllerBean");

    @Override
    public Map _batchSubmit(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        PayPlanBillCollection colls = this.getPayPlanBills(ctx, ids);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"payPlanBill_03submit");
                    if (!isPermission) {
                        throw new PPException(PPException.PAYPLANBILL_NO_SUBMIT, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                PayPlanBillFactory.getLocalInstance(ctx).batchSubmit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_SUBMIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_SUBMIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _batchAudit(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        PayPlanBillCollection colls = this.getPayPlanBills(ctx, ids);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"payPlanBill_05audit");
                    if (!isPermission) {
                        throw new PPException(PPException.PAYPLANBILL_NO_AUDIT, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                PayPlanBillFactory.getLocalInstance(ctx).audit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_AUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_AUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _batchUnAudit(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        PayPlanBillCollection colls = this.getPayPlanBills(ctx, ids);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"payPlanBill_06unAudit");
                    if (!isPermission) {
                        throw new PPException(PPException.PAYPLANBILL_NO_UNAUDIT, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                PayPlanBillFactory.getLocalInstance(ctx).unAudit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_UNAUDIT_FAIL_MF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_UNAUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _batchDelete(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        PayPlanBillCollection colls = this.getPayPlanBills(ctx, ids);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"payPlanBill_04delete");
                    if (!isPermission) {
                        throw new PPException(PPException.PAYPLANBILL_NO_DELETE, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new Exception(CASWebUtil.getResource((Context)ctx, (String)"610_CantOpreateWhileOtherUse"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                PayPlanBillFactory.getLocalInstance(ctx).delete(idSet);
                ++success;
                iMutex.releaseObjIDForUpdate(info.getId().toString());
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_DELETE_FAIL_MF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_DELETE_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _toNext(Context ctx, String orgScheId, String[] ids, Date appointDate) throws BOSException, EASBizException {
        boolean isPermission;
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        StringBuffer numbers = new StringBuffer();
        numbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"68_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer failNumbers = new StringBuffer();
        failNumbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"69_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        if (orgScheId == null) {
            return result;
        }
        OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheId), this.getOrgScheduleSelector());
        Date startDate = orgScheduleInfo.getUserDefinedPeriod().getStartDate();
        Date endDate = orgScheduleInfo.getUserDefinedPeriod().getEndDate();
        Date afterDate = DateUtil.getAfterDay((Date)endDate);
        this.verifyOrgScheduleStatus(orgScheduleInfo);
        Date toNextDate = afterDate;
        if (appointDate != null) {
            toNextDate = appointDate;
            numbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"70_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + DateUtil.formatDate2((Date)toNextDate) + ", ");
            if (appointDate.before(afterDate)) {
                throw new PPException(PPException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"71_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale())});
            }
        }
        if (!(isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgScheduleInfo.getCompany().getId()), (String)"payPlanBill_09toNext"))) {
            throw new PPException(PPException.PAYPLANBILL_NO_TONEXT, new Object[]{orgScheduleInfo.getCompany().getName()});
        }
        if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)orgScheduleInfo.getCompany())) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE")});
        }
        PayPlanBillCollection colls = this.getPayPlanBillColl(ctx, ids);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<String> successIdset = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                Date payableDate = info.getPayableDate();
                if (payableDate.before(startDate) || payableDate.after(afterDate) || payableDate.equals(afterDate)) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_ToNext_CurrentPeriod"));
                }
                String companyId = info.getCompany().getId().toString();
                if (!companyId.equals(orgScheduleInfo.getCompany().getId().toString())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"RECPAY_COMPANY_NOT_MATCH", (String[])new String[]{orgScheduleInfo.getCompany().getName()}));
                }
                BillStatusEnum billStatus = info.getBillStatus();
                if (billStatus != BillStatusEnum.AUDIT && billStatus != BillStatusEnum.SCHEDULED && billStatus != BillStatusEnum.TONEXT) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_ToNext_BillStatusErr", (String[])new String[]{billStatus.getAlias()}));
                }
                if (info.getSchdlBalanceAmt().compareTo(BigDecimal.ZERO) == 0) {
                    throw new PPException(PPException.PAYPLAN_BALANCE_ZERO, new Object[]{info.getNumber()});
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CANTTONEXT"));
                }
                ++success;
                successIdset.add(info.getId().toString());
                numbers.append(info.getNumber());
                numbers.append(",");
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                failNumbers.append(info.getNumber());
                failNumbers.append(",");
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_TONEXT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        if (successIdset.size() > 0) {
            try {
                String successids = FMHelper.setTran2String(successIdset);
                String sql = "UPDATE T_PP_PayPlanBill SET FBillLastStatus = FBillStatus , FBillStatus = ? , FPayableDate = ? , FLastUpdateUserID = ? ,FLastUpdateTime = ?  WHERE FID IN " + successids;
                Integer status = new Integer(5);
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, new Timestamp(toNextDate.getTime()), userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
                if (success != ids.length) {
                    numbers.append(failNumbers);
                }
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"toNext", (BOSObjectType)new PayPlanBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_payPlanBill_toNext", (String)orgScheduleInfo.getCompany().getId().toString(), null);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BATCHTONEXT_FAIL")});
            }
            finally {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(successIdset));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"ALL_TONEXT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"TONEXT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _backToNext(Context ctx, String orgScheId, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        StringBuffer numbers = new StringBuffer();
        numbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"72_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer failNumbers = new StringBuffer();
        failNumbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"73_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        if (orgScheId == null) {
            return new BatchExecuteResult();
        }
        OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheId), this.getOrgScheduleSelector());
        Date startDate = orgScheduleInfo.getUserDefinedPeriod().getStartDate();
        Date endDate = orgScheduleInfo.getUserDefinedPeriod().getEndDate();
        Date afterDate = DateUtil.getAfterDay((Date)endDate);
        this.verifyOrgScheduleStatus(orgScheduleInfo);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgScheduleInfo.getCompany().getId()), (String)"payPlanBill_11backToNext");
        if (!isPermission) {
            throw new PPException(PPException.PAYPLANBILL_NO_BACKTONEXT, new Object[]{orgScheduleInfo.getCompany().getName()});
        }
        if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)orgScheduleInfo.getCompany())) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE")});
        }
        PayPlanBillCollection colls = this.getPayPlanBillColl(ctx, ids);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<String> successIdset = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                Date payableDate = info.getPayableDate();
                if (!payableDate.after(afterDate) && !payableDate.equals(afterDate)) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_BackToNext_AfterCurrent"));
                }
                String companyId = info.getCompany().getId().toString();
                if (!companyId.equals(orgScheduleInfo.getCompany().getId().toString())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"RECPAY_COMPANY_NOT_MATCH", (String[])new String[]{orgScheduleInfo.getCompany().getName()}));
                }
                BillStatusEnum billStatus = info.getBillStatus();
                if (billStatus != BillStatusEnum.TONEXT) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_BackToNext_BillStatusErr"));
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CANTBACKTONEXT"));
                }
                ++success;
                successIdset.add(info.getId().toString());
                numbers.append(info.getNumber());
                numbers.append(",");
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                failNumbers.append(info.getNumber());
                failNumbers.append(",");
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_BACKTONEXT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        if (successIdset.size() > 0) {
            try {
                String successids = FMHelper.setTran2String(successIdset);
                String sql = "UPDATE T_PP_PayPlanBill SET  FBillStatus =  FBillLastStatus , FPayableDate = ? , FLastUpdateUserID = ?,FLastUpdateTime = ? WHERE FID IN " + successids;
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(startDate.getTime()), userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
                if (success != ids.length) {
                    numbers.append(failNumbers);
                }
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"backToNext", (BOSObjectType)new PayPlanBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_payPlanBill_backToNext", (String)orgScheduleInfo.getCompany().getId().toString(), null);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BATCHBACKTONEXT_FAIL")});
            }
            finally {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(successIdset));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"ALL_BACKTONEXT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BACKTONEXT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _refuse(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        StringBuffer numbers = new StringBuffer();
        numbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"74_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer failNumbers = new StringBuffer();
        failNumbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"75_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        PayPlanBillCollection colls = this.getPayPlanBillColl(ctx, ids);
        CompanyOrgUnitInfo company = colls.get(0).getCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)"payPlanBill_10refuse");
        if (!isPermission) {
            throw new PPException(PPException.PAYPLANBILL_NO_REFUSE, new Object[]{company.getName()});
        }
        if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)company)) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE")});
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<String> successIdset = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                BillStatusEnum billStatus = info.getBillStatus();
                if (billStatus != BillStatusEnum.AUDIT && billStatus != BillStatusEnum.SCHEDULED && billStatus != BillStatusEnum.TONEXT) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_refuse_BillStatusErr", (String[])new String[]{billStatus.getAlias()}));
                }
                if (info.getSchdlBalanceAmt().compareTo(BigDecimal.ZERO) == 0) {
                    throw new PPException(PPException.PAYPLAN_BALANCE_ZERO, new Object[]{info.getNumber()});
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CANTREFUSE"));
                }
                ++success;
                successIdset.add(info.getId().toString());
                numbers.append(info.getNumber());
                numbers.append(",");
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                failNumbers.append(info.getNumber());
                failNumbers.append(",");
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_REFUSE_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        if (successIdset.size() > 0) {
            try {
                String successids = FMHelper.setTran2String(successIdset);
                String sql = "UPDATE T_PP_PayPlanBill SET FBillLastStatus = FBillStatus , FBillStatus = ?  , FLastUpdateUserID = ? ,FLastUpdateTime = ?  WHERE FID IN " + successids;
                Integer status = new Integer(6);
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
                if (success != ids.length) {
                    numbers.append(failNumbers);
                }
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"refuse", (BOSObjectType)new PayPlanBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_payPlanBill_refuse", (String)company.getId().toString(), null);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BATCHREFUSE_FAIL")});
            }
            finally {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(successIdset));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"ALL_REFUSE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REFUSE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _backRefuse(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        StringBuffer numbers = new StringBuffer();
        numbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"76_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer failNumbers = new StringBuffer();
        failNumbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"77_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        PayPlanBillCollection colls = this.getPayPlanBillColl(ctx, ids);
        CompanyOrgUnitInfo company = colls.get(0).getCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)"payPlanBill_12backRefuse");
        if (!isPermission) {
            throw new PPException(PPException.PAYPLANBILL_NO_BACKREFUSE, new Object[]{company.getName()});
        }
        if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)company)) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE")});
        }
        HashSet<String> successIdset = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                BillStatusEnum billStatus = info.getBillStatus();
                if (billStatus != BillStatusEnum.REFUSE) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_BackRefuse_BillStatusErr"));
                }
                ++success;
                successIdset.add(info.getId().toString());
                numbers.append(info.getNumber());
                numbers.append(",");
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                failNumbers.append(info.getNumber());
                failNumbers.append(",");
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_BACKREFUSE_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        if (successIdset.size() > 0) {
            try {
                String successids = FMHelper.setTran2String(successIdset);
                String sql = "UPDATE T_PP_PayPlanBill SET  FBillStatus = FBillLastStatus , FLastUpdateUserID = ? ,FLastUpdateTime = ?  WHERE FID IN " + successids;
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
                if (success != ids.length) {
                    numbers.append(failNumbers);
                }
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"backRefuse", (BOSObjectType)new PayPlanBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_payPlanBill_backRefuse", (String)company.getId().toString(), null);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BATCHBACKREFUSE_FAIL")});
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"ALL_BACKREFUSE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BACKREFUSE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _backTo(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        IPayPlanBill payPlanBill = PayPlanBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.name");
        view.setSelector(selector);
        PayPlanBillCollection colls = payPlanBill.getPayPlanBillCollection(view);
        HashSet<String> sourceBillidSet = new HashSet<String>();
        HashSet<String> notBackToIdSet = new HashSet<String>();
        HashSet idSet = new HashSet();
        for (int i = 0; i < colls.size(); ++i) {
            if (colls.get(i).getSourceBillType() == null || colls.get(i).getSourceBillType().getValue() < 3 || colls.get(i).getSourceBillType().getValue() > 8) continue;
            sourceBillidSet.add(colls.get(i).getSourceBillId());
        }
        if (sourceBillidSet.size() > 0) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("sourceBillId", sourceBillidSet, CompareType.INCLUDE));
            view.setFilter(filter1);
            PayPlanBillCollection tempColls = payPlanBill.getPayPlanBillCollection(view);
            for (int i = 0; i < tempColls.size(); ++i) {
                PayPlanBillInfo info = tempColls.get(i);
                colls.add(info);
                if (info.getBillStatus() == BillStatusEnum.REFUSE) continue;
                notBackToIdSet.add(info.getSourceBillId());
            }
        }
        summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{colls.size() + ""});
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"payPlanBill_13backTo");
                    if (!isPermission) {
                        throw new PPException(PPException.PAYPLANBILL_NO_BACKTO, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                if (info.getSourceBillId() != null && notBackToIdSet.size() > 0 && notBackToIdSet.contains(info.getSourceBillId())) {
                    result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_BACKTO_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"AMOUNT_NOT_EQUALS"));
                    continue;
                }
                PayPlanBillFactory.getLocalInstance(ctx).backTo((IObjectPK)new ObjectUuidPK(info.getId()));
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_BACKTO_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PAY_BACKTO_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == colls.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"ALL_BACKTO_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BACKTO_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(colls.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    protected SelectorItemCollection getOrgScheduleSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("userDefinedPeriod.startDate");
        sic.add("userDefinedPeriod.endDate");
        sic.add("userDefinedPeriod.id");
        sic.add("status");
        return sic;
    }

    protected PayPlanBillCollection getPayPlanBills(Context ctx, String[] ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        return PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillCollection(view);
    }

    protected PayPlanBillCollection getPayPlanBillColl(Context ctx, String[] ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.name");
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        return PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillCollection(view);
    }

    @Override
    protected Map _schedule(Context ctx, String[] ids, String orgScheduleId) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId), this.getOrgScheduleSelector());
        Date endDate = orgScheduleInfo.getUserDefinedPeriod().getEndDate();
        PayPlanBillCollection colls = this.getPayPlanBillColl(ctx, ids);
        for (int i = 0; i < colls.size(); ++i) {
            PayPlanBillInfo info = colls.get(i);
            if (info.getPayableDate().after(endDate) && info.getBillStatus() == BillStatusEnum.TONEXT || info.getBillStatus() == BillStatusEnum.REFUSE) {
                throw new PPException(PPException.PAYPLAN_TONEXT_REFUSE, new Object[]{info.getNumber()});
            }
            if (info.getSchdlBalanceAmt().compareTo(BigDecimal.ZERO) != 0) continue;
            throw new PPException(PPException.PAYPLAN_BALANCE_ZERO, new Object[]{info.getNumber()});
        }
        result.setError(0);
        return result;
    }

    private void verifyOrgScheduleStatus(OrgScheduleInfo orgScheduleInfo) throws BOSException, EASBizException {
        if (orgScheduleInfo.getStatus() == StatusEnum.SCHEDULE_SUBMIT || orgScheduleInfo.getStatus() == StatusEnum.ADJUST_SUBMIT || orgScheduleInfo.getStatus() == StatusEnum.SCHEDULE_AUDIT || orgScheduleInfo.getStatus() == StatusEnum.ADJUST_AUDIT || orgScheduleInfo.getStatus() == StatusEnum.COMPLETE) {
            throw new PPException(PPException.STATUSCHANGE_REFRESH);
        }
    }
}

