/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.OperateBillEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillLogFactory;
import com.kingdee.eas.fi.cas.PaymentBillLogInfo;
import com.kingdee.eas.fi.cas.PaymentOperateType;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.CapitalBalanceFactory;
import com.kingdee.eas.fm.pp.CapitalBalanceWebFacadeFactory;
import com.kingdee.eas.fm.pp.IPayPlanBill;
import com.kingdee.eas.fm.pp.IPaySchDetailBill;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PPScheduleSettingCollection;
import com.kingdee.eas.fm.pp.PPScheduleSettingFactory;
import com.kingdee.eas.fm.pp.PayPlanBillCollection;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillStatuEnum;
import com.kingdee.eas.fm.pp.SetFundPropertyFactory;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.fm.pp.StatusEnum;
import com.kingdee.eas.fm.pp.app.AbstractPaySchDetailBillControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public class PaySchDetailBillControllerBean
extends AbstractPaySchDetailBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.PaySchDetailBillControllerBean");
    private static final String NTAMT = "\u6392\u7a0b\u7968\u636e\u4ed8\u6b3e\u91d1\u989d";
    private static final String CASHAMT = "\u6392\u7a0b\u73b0\u6b3e\u4ed8\u6b3e\u91d1\u989d";
    private static final String NTAUDITEDAMT = "\u7968\u636e\u5ba1\u6279\u91d1\u989d";
    private static final String CASHAUDITEDAMT = "\u73b0\u6b3e\u5ba1\u6279\u91d1\u989d";
    private static final String NTBALANCE = "\u7968\u636e\u4ed8\u6b3e\u5dee\u989d";
    private static final String NTSETTLETYPE = "\u6392\u7a0b\u7968\u636e\u7ed3\u7b97\u65b9\u5f0f";

    @Override
    protected IObjectCollection _transToPaySchDetails(Context ctx, List idList, String orgScheduleId) throws BOSException, EASBizException {
        PaySchDetailBillCollection coll = new PaySchDetailBillCollection();
        HashSet payPlanIdSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", payPlanIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.DESCEND);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.name");
        selector.add("currency.name");
        selector.add("currency.precision");
        selector.add("department.name");
        selector.add("payerAccountBank.id");
        selector.add("payerAccountBank.name");
        selector.add("payerAccountBank.bank.id");
        selector.add("payerAccountBank.bank.name");
        selector.add("settlementType.name");
        selector.add("settlementType.nttype.group");
        selector.add("settlementType.nttype.superGroup");
        selector.add("setFundProperty.name");
        selector.add("setFundProperty.accountbank.name");
        selector.add("setFundProperty.accountbank.bank.id");
        selector.add("setFundProperty.accountbank.bank.name");
        selector.add("setFundProperty.fundPropertyProperty");
        selector.add("setFundProperty.optionalSTNumber");
        sort.add(sortInfo);
        view.setSorter(sort);
        view.setSelector(selector);
        PayPlanBillCollection payPlanColl = PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillCollection(view);
        SelectorItemCollection orgSelector = new SelectorItemCollection();
        orgSelector.add("*");
        orgSelector.add("userDefinedPeriod.startDate");
        orgSelector.add("userDefinedPeriod.endDate");
        OrgScheduleInfo scheInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId), orgSelector);
        Date startDate = scheInfo.getUserDefinedPeriod().getStartDate();
        Date endDate = scheInfo.getUserDefinedPeriod().getEndDate();
        Date afterDate = DateUtil.getAfterDay((Date)endDate);
        String OrgCompanyId = scheInfo.getCompany().getId().toString();
        for (int i = 0; i < payPlanColl.size(); ++i) {
            PayPlanBillInfo payPlanBillInfo = payPlanColl.get(i);
            Date payableDate = payPlanBillInfo.getPayableDate();
            String companyId = payPlanBillInfo.getCompany().getId().toString();
            if (!payableDate.after(startDate) && !payableDate.equals(startDate) || !payableDate.before(afterDate) || !OrgCompanyId.equals(companyId)) continue;
            coll.add(this.transToPaySchDetailBillInfo(payPlanColl.get(i), orgScheduleId, scheInfo.getCount()));
        }
        return coll;
    }

    private PaySchDetailBillInfo transToPaySchDetailBillInfo(PayPlanBillInfo payPlanBillInfo, String orgScheduleId, int paySchDetailNumber) {
        PaySchDetailBillInfo info = new PaySchDetailBillInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCompany(payPlanBillInfo.getCompany());
        info.setPayPlan(payPlanBillInfo);
        info.setOrgScheduleId(orgScheduleId);
        info.setPaySchDetailNumber(paySchDetailNumber);
        info.setPayerAccountBank(payPlanBillInfo.getPayerAccountBank());
        if (EmptyUtil.isEmpty((CoreBaseInfo)payPlanBillInfo.getPayerAccountBank())) {
            AccountBankInfo acctBank = payPlanBillInfo.getSetFundProperty().getAccountBank();
            info.setPayerAccountBank(acctBank);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)acctBank)) {
                info.setPayerBank(acctBank.getBank());
            }
        } else {
            info.setPayerBank(payPlanBillInfo.getPayerAccountBank().getBank());
        }
        info.setCurrency(payPlanBillInfo.getCurrency());
        info.setApplyPayAmt(payPlanBillInfo.getApplyPayAmount());
        info.setSchBanlance(payPlanBillInfo.getSchdlBalanceAmt());
        info.setDueDate(payPlanBillInfo.getPayableDate());
        SettlementTypeInfo settlementType = payPlanBillInfo.getSettlementType();
        info.setSettlementType(payPlanBillInfo.getSettlementType());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)settlementType.getNtType()) && (NTTypeGroupEnum.RECEIVABLE.equals((Object)settlementType.getNtType().getGroup()) || NTTypeGroupEnum.RECEIVABLE.equals((Object)settlementType.getNtType().getSuperGroup()) || NTTypeGroupEnum.PAYABLE.equals((Object)settlementType.getNtType().getGroup()) || NTTypeGroupEnum.PAYABLE.equals((Object)settlementType.getNtType().getSuperGroup()))) {
            info.setNtSettleType(payPlanBillInfo.getSettlementType());
            info.setNtAmt(payPlanBillInfo.getSchdlBalanceAmt());
            info.setNtBalance(BigDecimal.ZERO);
            info.setCashSettleType(null);
            info.setCashAmt(BigDecimal.ZERO);
        } else {
            info.setCashSettleType(payPlanBillInfo.getSettlementType());
            info.setCashAmt(payPlanBillInfo.getSchdlBalanceAmt());
            info.setNtSettleType(null);
            info.setNtAmt(BigDecimal.ZERO);
            info.setNtBalance(BigDecimal.ZERO);
        }
        info.setSetFundProperty(payPlanBillInfo.getSetFundProperty());
        info.setAsstActName(payPlanBillInfo.getAsstActName());
        info.setPayeeAccountBank(payPlanBillInfo.getPayeeAccountBank());
        info.setPayeeBank(payPlanBillInfo.getPayeeBank());
        info.setUsage(payPlanBillInfo.getUsage());
        info.setDepartment(payPlanBillInfo.getDepartment());
        info.setPaymentBillType(payPlanBillInfo.getPaymentBillType());
        info.setCoreBillType(payPlanBillInfo.getCoreBillType());
        info.setCoreBillNumber(payPlanBillInfo.getCoreBillNumber());
        info.setContractNum(payPlanBillInfo.getContractNo());
        info.setStatus(PaySchDetailBillStatuEnum.UNGENERATE);
        info.setNumber(payPlanBillInfo.getNumber() + "-" + String.valueOf(new Date().getTime()));
        info.setSourceBillId(payPlanBillInfo.getSourceBillId());
        info.setSrcBillHeadID(payPlanBillInfo.getSrcBillHeadID());
        info.setNtSelectAmt(BigDecimal.ZERO);
        info.setMinExpiredDate(365);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _submitPaySchDetails(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        if (coll.size() <= 0) {
            return;
        }
        HashSet<String> payPlanIdSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            payPlanIdSet.add(((PaySchDetailBillInfo)coll.getObject(i)).getPayPlan().getId().toString());
        }
        List idList = FMHelper.set2List(payPlanIdSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            int i;
            Boolean boolResult;
            int i2;
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            for (i2 = 0; i2 < idList.size(); ++i2) {
                boolResult = (Boolean)resultRequest.get(idList.get(i2));
                if (!boolResult.booleanValue()) continue;
                appliedList.add(idList.get(i2));
            }
            for (i2 = 0; i2 < idList.size(); ++i2) {
                boolResult = (Boolean)resultRequest.get(idList.get(i2));
                if (boolResult.booleanValue()) continue;
                PayPlanBillInfo payPlanBillInfo = PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i2)));
                throw new PPException(PPException.PAYSCHEDULING_LOCK, new Object[]{payPlanBillInfo.getNumber()});
            }
            PaySchDetailBillInfo info = (PaySchDetailBillInfo)coll.getObject(0);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"paySchDetail_02submit");
            if (!isPermission) {
                throw new PPException(PPException.PAYSCHAUTH, new Object[]{info.getCompany().getName()});
            }
            boolean isAddnew = true;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("userDefinedPeriod.endDate");
            OrgScheduleInfo oInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(info.getOrgScheduleId().toString()), sic);
            if (oInfo.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT) || oInfo.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT)) {
                isAddnew = false;
            }
            if (oInfo.getStatus().equals((Object)StatusEnum.SCHEDULE_AUDIT) || oInfo.getStatus().equals((Object)StatusEnum.ADJUST_AUDIT) || oInfo.getStatus().equals((Object)StatusEnum.COMPLETE)) {
                throw new PPException(PPException.STATUSCHANGE_REFRESH);
            }
            if (!isAddnew && !PaySchDetailBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                throw new PPException(PPException.STATUSCHANGE_REFRESH);
            }
            if ((!isAddnew || PaySchDetailBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) && (oInfo.getStatus().equals((Object)StatusEnum.SCHEDULEING) || oInfo.getStatus().equals((Object)StatusEnum.ADJUSTING))) {
                throw new PPException(PPException.STATUSCHANGE_REFRESH);
            }
            Date endDate = oInfo.getUserDefinedPeriod().getEndDate();
            for (i = 0; i < coll.size(); ++i) {
                this.submitVerify(ctx, (PaySchDetailBillInfo)coll.getObject(i), endDate, isAddnew);
            }
            for (i = 0; i < coll.size(); ++i) {
                this.reversePayPlan(ctx, (PaySchDetailBillInfo)coll.getObject(i), isAddnew);
            }
            this.updatePaySchDetailBill(ctx, coll, info, isAddnew);
            this._submitBatchData(ctx, coll);
            for (i = 0; i < coll.size(); ++i) {
                PaySchDetailBillInfo pInfo = (PaySchDetailBillInfo)coll.getObject(i);
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)pInfo.getBOSType(), null, (String)pInfo.getLogInfo(), (String)"pp_paySchDetail_submit");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    private void updatePaySchDetailBill(Context ctx, IObjectCollection coll, PaySchDetailBillInfo info, boolean isAddnew) throws EASBizException, BOSException {
        CurrencyInfo bassCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany());
        for (int i = 0; i < coll.size(); ++i) {
            PaySchDetailBillInfo pInfo = (PaySchDetailBillInfo)coll.getObject(i);
            if (isAddnew) {
                if (pInfo.getCashAuditedAmt() == null || pInfo.getCashAuditedAmt() != null && pInfo.getCashAuditedAmt().compareTo(Constants.ZERO) == 0) {
                    pInfo.setCashAuditedAmt(pInfo.getCashAmt());
                }
                if (pInfo.getNtAuditedAmt() == null || pInfo.getNtAuditedAmt() != null && pInfo.getNtAuditedAmt().compareTo(Constants.ZERO) == 0) {
                    pInfo.setNtAuditedAmt(pInfo.getNtAmt());
                }
            }
            CurrencyInfo casCurrency = pInfo.getCurrency();
            ExchangeRateInfo casExchangeRate = null;
            if (casCurrency != null && !casCurrency.getId().toString().equals(bassCurrency.getId().toString())) {
                casExchangeRate = this.findExchangeRate(ctx, casCurrency.getId().toString(), bassCurrency.getId().toString(), info);
            }
            pInfo.setCashLocAmt(PaySchDetailBillControllerBean.calLocAmt(pInfo.getCashAmt(), casExchangeRate, bassCurrency));
            pInfo.setCashAuditedLocAmt(PaySchDetailBillControllerBean.calLocAmt(pInfo.getCashAuditedAmt(), casExchangeRate, bassCurrency));
            if (isAddnew) {
                pInfo.setLastCashAmt(pInfo.getCashAmt());
                pInfo.setLastNtAmt(pInfo.getNtAmt());
                pInfo.setNtBalance(pInfo.getNtAmt());
            } else {
                pInfo.setNtBalance(pInfo.getNtAuditedAmt().subtract(pInfo.getLastNtAmt()).add(pInfo.getNtBalance()));
                if (pInfo.getSummaryFlag() != null) {
                    pInfo.setNtSummaryAmt(pInfo.getNtSummaryAmt().subtract(pInfo.getLastNtAmt()).add(pInfo.getNtAuditedAmt()));
                    pInfo.setCashSummaryAmt(pInfo.getCashSummaryAmt().subtract(pInfo.getLastCashAmt()).add(pInfo.getCashAuditedAmt()));
                }
                pInfo.setLastCashAmt(pInfo.getCashAuditedAmt());
                pInfo.setLastNtAmt(pInfo.getNtAuditedAmt());
            }
            pInfo.setNtLocAmt(this.calCulateNTLoc(ctx, pInfo, pInfo.getNtAmt()));
            pInfo.setNtAuditedLocAmt(this.calCulateNTLoc(ctx, pInfo, pInfo.getNtAuditedAmt()));
            if (pInfo.getSummaryFlag() == null) continue;
            String sql = "update T_PP_PaySchDetailBill set FNtSummaryAmt = " + pInfo.getNtSummaryAmt() + ",FCashSummaryAmt = " + pInfo.getCashSummaryAmt() + " where FSummaryFlag = '" + pInfo.getSummaryFlag() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private ExchangeRateInfo findExchangeRate(Context ctx, String sourceCurID, String desCurID, PaySchDetailBillInfo info) throws BOSException, EASBizException {
        ObjectUuidPK sourceCurrpk;
        CompanyOrgUnitInfo clearingHouseCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        ExchangeTableInfo baseExchangeTable = clearingHouseCompany.getBaseExchangeTable();
        if (baseExchangeTable == null) {
            throw new PPException(PPException.NO_EXCHANGERATE, new Object[]{clearingHouseCompany.getName()});
        }
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCurID);
        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurID)), (IObjectPK)destCurrpk, new Date(System.currentTimeMillis()));
        if (erInfo == null) {
            throw new PPException(PPException.NOT_EXCHANGERATE);
        }
        return erInfo;
    }

    public static BigDecimal calLocAmt(BigDecimal amt, ExchangeRateInfo exchangeRate, CurrencyInfo bassCurrency) throws EASBizException, BOSException {
        BigDecimal apLocAmt = new BigDecimal("0.00");
        int baseScale = 2;
        if (bassCurrency != null && bassCurrency.getPrecision() > 0) {
            baseScale = bassCurrency.getPrecision();
        }
        Boolean isDirectExchange = true;
        if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
            int convertMode = exchangeRate.getExchangeAux().getConvertMode().getValue();
            isDirectExchange = convertMode == 0;
        }
        BigDecimal exRate = Constants.ONE;
        if (exchangeRate != null) {
            exRate = exchangeRate.getConvertRate();
        }
        apLocAmt = isDirectExchange != false ? amt.multiply(exRate).setScale(baseScale, 4) : (SysConstant.BIGZERO.compareTo(exRate) != 0 ? amt.divide(exRate, baseScale, 4) : amt.multiply(exRate).setScale(baseScale, 4));
        return apLocAmt;
    }

    private void reversePayPlan(Context ctx, PaySchDetailBillInfo info, boolean isAddnew) throws EASBizException, BOSException {
        String payPlanId = info.getPayPlan().getId().toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("number");
        selector.add("schdlBalanceAmt");
        selector.add("cashSchdlLockAmt");
        selector.add("paperSchdlLockAmt");
        selector.add("LockAmt");
        selector.add("applyPayAmount");
        selector.add("schedulor");
        selector.add("scheduleDate");
        selector.add("lastUpdateTime");
        selector.add("lastUpdateUser");
        IPayPlanBill payPlan = PayPlanBillFactory.getLocalInstance(ctx);
        PayPlanBillInfo payPlanBillInfo = payPlan.getPayPlanBillInfo((IObjectPK)new ObjectUuidPK(payPlanId), selector);
        if (isAddnew) {
            selector.add("billStatus");
            payPlanBillInfo.setCashSchdlLockAmt(payPlanBillInfo.getCashSchdlLockAmt().add(info.getCashAmt()));
            payPlanBillInfo.setPaperSchdlLockAmt(payPlanBillInfo.getPaperSchdlLockAmt().add(info.getNtAmt()));
            payPlanBillInfo.setLockAmt(payPlanBillInfo.getLockAmt().add(info.getCashAmt()).add(info.getNtAmt()));
            payPlanBillInfo.setSchdlBalanceAmt(payPlanBillInfo.getApplyPayAmount().subtract(payPlanBillInfo.getLockAmt()));
            payPlanBillInfo.setBillStatus(BillStatusEnum.SCHEDULED);
        } else {
            if (info.getLastCashAmt().equals(null) && info.getLastNtAmt().equals(null)) {
                payPlanBillInfo.setCashSchdlLockAmt(payPlanBillInfo.getCashSchdlLockAmt().subtract(info.getCashAmt()).add(info.getCashAuditedAmt()));
                payPlanBillInfo.setPaperSchdlLockAmt(payPlanBillInfo.getPaperSchdlLockAmt().subtract(info.getNtAmt()).add(info.getNtAuditedAmt()));
            } else {
                payPlanBillInfo.setCashSchdlLockAmt(payPlanBillInfo.getCashSchdlLockAmt().subtract(info.getLastCashAmt()).add(info.getCashAuditedAmt()));
                payPlanBillInfo.setPaperSchdlLockAmt(payPlanBillInfo.getPaperSchdlLockAmt().subtract(info.getLastNtAmt()).add(info.getNtAuditedAmt()));
            }
            payPlanBillInfo.setLockAmt(payPlanBillInfo.getCashSchdlLockAmt().add(payPlanBillInfo.getPaperSchdlLockAmt()));
            payPlanBillInfo.setSchdlBalanceAmt(payPlanBillInfo.getApplyPayAmount().subtract(payPlanBillInfo.getLockAmt()));
        }
        if (payPlanBillInfo.getSchdlBalanceAmt().compareTo(BigDecimal.ZERO) < 0) {
            throw new PPException(PPException.SCHBALANCENOTEHOUGH, new Object[]{payPlanBillInfo.getNumber()});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        payPlanBillInfo.setSchedulor(userInfo);
        payPlanBillInfo.setScheduleDate(new Date());
        payPlanBillInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        payPlanBillInfo.setLastUpdateUser(userInfo);
        payPlan.updatePartial(payPlanBillInfo, selector);
    }

    private void submitVerify(Context ctx, PaySchDetailBillInfo info, Date endDate, boolean isAddnew) throws EASBizException, BOSException {
        String payPlanId = info.getPayPlan().getId().toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("number");
        selector.add("billStatus");
        selector.add("payableDate");
        selector.add("schdlBalanceAmt");
        selector.add("payerAccountBank.id");
        PayPlanBillInfo payPlanBillInfo = PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillInfo((IObjectPK)new ObjectUuidPK(payPlanId), selector);
        if (info.getCashAmt() == null) {
            info.setCashAmt(BigDecimal.ZERO);
        }
        if (info.getCashAuditedAmt() == null) {
            info.setCashAuditedAmt(BigDecimal.ZERO);
        }
        if (info.getNtAmt() == null) {
            info.setNtAmt(BigDecimal.ZERO);
        }
        if (info.getNtAuditedAmt() == null) {
            info.setNtAuditedAmt(BigDecimal.ZERO);
        }
        if (isAddnew) {
            if (payPlanBillInfo.getPayableDate().after(endDate) && payPlanBillInfo.getBillStatus() == BillStatusEnum.TONEXT || payPlanBillInfo.getBillStatus() == BillStatusEnum.REFUSE) {
                throw new PPException(PPException.PAYPLAN_TONEXT_REFUSE, new Object[]{payPlanBillInfo.getNumber()});
            }
            if (payPlanBillInfo.getSchdlBalanceAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new PPException(PPException.PAYPLAN_BALANCE_ZERO, new Object[]{payPlanBillInfo.getNumber()});
            }
            if (!(info.getId() != null && this.innerExists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) || payPlanBillInfo.getSchdlBalanceAmt().compareTo(info.getSchBanlance()) == 0)) {
                throw new PPException(PPException.SCHBALANCECHANGE, new Object[]{payPlanBillInfo.getNumber()});
            }
            if (info.getSchBanlance().compareTo(info.getCashAmt().add(info.getNtAmt())) < 0) {
                throw new PPException(PPException.SCHBALANCENOTEHOUGH, new Object[]{payPlanBillInfo.getNumber()});
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank())) {
                throw new PPException(PPException.PAYERACCTBANKNOTNULL, new Object[]{payPlanBillInfo.getNumber()});
            }
            if (BigDecimal.ZERO.compareTo(info.getCashAmt().add(info.getNtAmt())) == 0) {
                throw new PPException(PPException.AMT_ERROR, new Object[]{payPlanBillInfo.getNumber()});
            }
        } else {
            if (info.getLastCashAmt().equals(null) && info.getLastNtAmt().equals(null) ? payPlanBillInfo.getSchdlBalanceAmt().add(info.getCashAmt()).add(info.getNtAmt()).compareTo(info.getCashAuditedAmt().add(info.getNtAuditedAmt())) < 0 : payPlanBillInfo.getSchdlBalanceAmt().add(info.getLastCashAmt()).add(info.getLastNtAmt()).compareTo(info.getCashAuditedAmt().add(info.getNtAuditedAmt())) < 0) {
                throw new PPException(PPException.SCHBALANCENOTEHOUGH, new Object[]{payPlanBillInfo.getNumber()});
            }
            if (!EmptyUtil.isEmpty((String)info.getBreakUpNumber())) {
                throw new PPException(PPException.PAYSCH_NEW_NOT_EDIT, new Object[]{info.getNumber()});
            }
        }
    }

    @Override
    protected Map _getNts(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, ArrayList<String>> ntMap = new HashMap<String, ArrayList<String>>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.id");
        sic.add("receivableBill.draftNumber");
        view.setFilter(filter);
        view.setSelector(sic);
        PaySchDetailBillNTsCollection ntsColl = PaySchDetailBillNTsFactory.getLocalInstance(ctx).getPaySchDetailBillNTsCollection(view);
        if (ntsColl != null && ntsColl.size() > 0) {
            for (int i = 0; i < ntsColl.size(); ++i) {
                PaySchDetailBillNTsInfo ntsInfo = ntsColl.get(i);
                String paySchDetailBillId = ntsInfo.getParent().getId().toString();
                ArrayList<String> ntList = (ArrayList<String>)ntMap.get(paySchDetailBillId);
                if (ntList == null) {
                    ntList = new ArrayList<String>();
                    ntMap.put(paySchDetailBillId, ntList);
                }
                ntList.add(ntsInfo.getReceivableBill().getDraftNumber());
            }
        }
        return ntMap;
    }

    @Override
    protected void _verifyLockReceivableBill(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("ntSettleType.*");
        sic.add("status");
        PaySchDetailBillInfo paySchDetailBillInfo = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getCompany().getId()), (String)"paySchDetail_04LockReceivable");
        if (!isPermission) {
            throw new PPException(PPException.PAYSCHDETAIL_NO_LOCK, new Object[]{paySchDetailBillInfo.getCompany().getName()});
        }
        if (paySchDetailBillInfo.getNtSettleType() != null && paySchDetailBillInfo.getNtSettleType().getNtType() != null) {
            NTTypeInfo ntInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getNtSettleType().getNtType().getId()));
            if (ntInfo.getSuperGroup() != null && !ntInfo.getSuperGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE)) {
                throw new PPException(PPException.NOT_LOCKRECEIVABLEBILL);
            }
        } else {
            throw new PPException(PPException.NOT_LOCKRECEIVABLEBILL);
        }
        if (!paySchDetailBillInfo.getStatus().equals((Object)PaySchDetailBillStatuEnum.UNGENERATE)) {
            throw new PPException(PPException.NOT_UNGENERATE);
        }
    }

    @Override
    protected IObjectCollection _getPaySchDetailBillCollectionById(Context ctx, List idList, String orgScheduleId) throws BOSException, EASBizException {
        HashSet paySchDetailBillIdSet = new HashSet(idList);
        OrgScheduleInfo scheInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId));
        int count = scheInfo.getCount();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", paySchDetailBillIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("PaySchDetailNumber", (Object)count));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payerAccountBank.*");
        sic.add("payerBank.*");
        sic.add("currency.*");
        sic.add("company.*");
        sic.add("settlementType.*");
        sic.add("cashSettleType.*");
        sic.add("ntSettleType.*");
        sic.add("setFundProperty.*");
        sic.add("payPlan.*");
        sic.add("department.*");
        sic.add("paymentBillType.*");
        sic.add("coreBillType.*");
        sic.add("coreBillType.*");
        sic.add("nts.*");
        view.setSelector(sic);
        PaySchDetailBillCollection coll = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(view);
        return coll;
    }

    @Override
    protected Map _back(Context ctx, Set idSet) throws BOSException, EASBizException {
        String summary = "";
        int success = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        boolean flag = true;
        boolean isBackPayment = true;
        HashSet<String> paySchDetailSet = new HashSet<String>();
        int failCount = 0;
        summary = summary + PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_Count", new String[]{idSet.size() + ""});
        try {
            PaySchDetailBillCollection coll = this.getPaySchDetailBillCollection(ctx, idSet);
            if (coll.size() == 0) {
                result.setSummaryMsg(PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_DateError", null));
            } else {
                PaySchDetailBillInfo pInfo = (PaySchDetailBillInfo)coll.getObject(0);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(pInfo.getCompany().getId()), (String)"paySchDetail_03back");
                if (!isPermission) {
                    throw new PPException(PPException.NOT_BACK, new Object[]{pInfo.getCompany().getName()});
                }
                this.verifyOrgScheduleStatusByBack(ctx, coll.get(0));
                if (coll.size() > 1) {
                    PaymentBillCollection paymentColl = new PaymentBillCollection();
                    for (int i = 0; i < coll.size(); ++i) {
                        PaySchDetailBillInfo info = coll.get(i);
                        if (info.getCashPayBill() != null || info.getNtPayBill() != null) {
                            if (info.getCashPayBill() != null) {
                                paymentColl.add(info.getCashPayBill());
                            }
                            if (info.getNtPayBill() != null) {
                                paymentColl.add(info.getNtPayBill());
                            }
                            paySchDetailSet.add(info.getId().toString());
                            result.getDetailMsgList().add(PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_NotBatchBack", new String[]{info.getPayPlan().getNumber()}));
                            continue;
                        }
                        isBackPayment = false;
                        if (info.getStatus().equals((Object)PaySchDetailBillStatuEnum.ALLBACK)) {
                            ++failCount;
                            result.getDetailMsgList().add(PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_AllBack_NotBatchBack", new String[]{info.getPayPlan().getNumber()}));
                            continue;
                        }
                        this.backPaySchDetailBill(ctx, info, null, false, false);
                        ++success;
                        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_paySchDetail_back");
                        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                    }
                    if (paymentColl.size() > 0) {
                        result.setOtherProperty("paymentBillCollection", (Object)paymentColl);
                        result.setOtherProperty("paySchDetailSet", paySchDetailSet);
                    }
                    result.setOtherProperty("isBackPayment", (Object)isBackPayment);
                } else {
                    PaySchDetailBillInfo info = coll.get(0);
                    PaymentBillCollection payColl = new PaymentBillCollection();
                    if (info.getCashPayBill() != null) {
                        payColl.add(info.getCashPayBill());
                    }
                    if (info.getNtPayBill() != null) {
                        payColl.add(info.getNtPayBill());
                    }
                    if (payColl.size() > 0) {
                        result.setOtherProperty("paymentBillCollection", (Object)payColl);
                        paySchDetailSet.add(info.getId().toString());
                        result.setOtherProperty("paySchDetailSet", paySchDetailSet);
                        flag = false;
                    } else {
                        isBackPayment = false;
                        if (info.getStatus().equals((Object)PaySchDetailBillStatuEnum.ALLBACK)) {
                            ++failCount;
                            result.getDetailMsgList().add(PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_AllBack_NotBatchBack", new String[]{info.getPayPlan().getNumber()}));
                        } else {
                            this.backPaySchDetailBill(ctx, info, null, false, false);
                            ++success;
                            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_paySchDetail_back");
                            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                        }
                    }
                    result.setOtherProperty("isBackPayment", (Object)isBackPayment);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSummaryMsg(PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_Error", new String[]{e.getMessage()}));
        }
        if (result.getSummaryMsg() == null && flag) {
            if (success == idSet.size()) {
                summary = PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_BackSuccess", null);
            } else {
                summary = summary + PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_Success_Failed", new String[]{String.valueOf(success), String.valueOf(failCount)});
                if (idSet.size() - success - failCount != 0) {
                    summary = summary + PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_needBackPayment", new String[]{String.valueOf(idSet.size() - success - failCount)});
                }
            }
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private PaymentBillCollection getPaymentBillCollection(Context ctx, Set idSet) throws BOSException, EASBizException {
        PaymentBillCollection coll = new PaymentBillCollection();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        coll = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(view);
        return coll;
    }

    private PaySchDetailBillCollection getPaySchDetailBillCollection(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payPlan.number"));
        sic.add(new SelectorItemInfo("cashPayBill.company.name"));
        sic.add(new SelectorItemInfo("cashPayBill.number"));
        sic.add(new SelectorItemInfo("cashPayBill.bizDate"));
        sic.add(new SelectorItemInfo("cashPayBill.payBillType.name"));
        sic.add(new SelectorItemInfo("cashPayBill.payerAccountBank.name"));
        sic.add(new SelectorItemInfo("cashPayBill.payerAccount.name"));
        sic.add(new SelectorItemInfo("cashPayBill.currency.name"));
        sic.add(new SelectorItemInfo("cashPayBill.actPayAmt"));
        sic.add(new SelectorItemInfo("cashPayBill.actPayLocAmt"));
        sic.add(new SelectorItemInfo("cashPayBill.payeeName"));
        sic.add(new SelectorItemInfo("cashPayBill.settlementType.name"));
        sic.add(new SelectorItemInfo("cashPayBill.settlementNumber"));
        sic.add(new SelectorItemInfo("cashPayBill.billStatus"));
        sic.add(new SelectorItemInfo("ntPayBill.company.name"));
        sic.add(new SelectorItemInfo("ntPayBill.number"));
        sic.add(new SelectorItemInfo("ntPayBill.bizDate"));
        sic.add(new SelectorItemInfo("ntPayBill.payBillType.name"));
        sic.add(new SelectorItemInfo("ntPayBill.payerAccountBank.name"));
        sic.add(new SelectorItemInfo("ntPayBill.payerAccount.name"));
        sic.add(new SelectorItemInfo("ntPayBill.currency.name"));
        sic.add(new SelectorItemInfo("ntPayBill.actPayAmt"));
        sic.add(new SelectorItemInfo("ntPayBill.actPayLocAmt"));
        sic.add(new SelectorItemInfo("ntPayBill.payeeName"));
        sic.add(new SelectorItemInfo("ntPayBill.settlementType.name"));
        sic.add(new SelectorItemInfo("ntPayBill.settlementNumber"));
        sic.add(new SelectorItemInfo("ntPayBill.billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("payPlan.asstActNumber"));
        sic.add(new SelectorItemInfo("payPlan.asstActID"));
        sic.add(new SelectorItemInfo("payerAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payerBank.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("cashSettleType.name"));
        sic.add(new SelectorItemInfo("ntSettleType.name"));
        sic.add(new SelectorItemInfo("setFundProperty.name"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("nts.*"));
        sic.add(new SelectorItemInfo("nts.receivableBill.draftNumber"));
        sic.add(new SelectorItemInfo("nts.receivableBill.company.id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PaySchDetailBillCollection coll = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(view);
        return coll;
    }

    private Map getPaySchDetailAndPayId(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("cashPayBill.id"));
        sic.add(new SelectorItemInfo("ntPayBill.id"));
        sic.add(new SelectorItemInfo("orgScheduleId"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PaySchDetailBillCollection coll = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            PaySchDetailBillInfo info = coll.get(i);
            if (i == 0) {
                this.verifyOrgScheduleStatusByBack(ctx, info);
            }
            if (info.getCashPayBill() != null) {
                map.put(info.getCashPayBill().getId().toString(), info.getId().toString());
            }
            if (info.getNtPayBill() == null) continue;
            map.put(info.getNtPayBill().getId().toString(), info.getId().toString());
        }
        return map;
    }

    @Override
    protected Map _backPaySchDetailBill(Context ctx, IObjectValue paySchDetailBillInfo, IObjectCollection paymentColl, boolean isCreatePaymentBill, boolean isScheduleBack) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean b = true;
        PaySchDetailBillInfo info = (PaySchDetailBillInfo)paySchDetailBillInfo;
        try {
            b = iMutex.requestObjIDForUpdate(info.getId().toString());
            if (!b) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
            }
            PaymentBillCollection coll = (PaymentBillCollection)paymentColl;
            if (isCreatePaymentBill) {
                this.deletePaymentBill(ctx, info, coll, map, isScheduleBack);
            } else {
                this.unLockReceivableBill(ctx, info);
                this.disPaySchDetailBill(ctx, info, isCreatePaymentBill, false);
                this.disPayPlan(ctx, info, isCreatePaymentBill, false, false);
            }
            String sql = "update T_PP_PaySchDetailBill set FSummaryFlag = null,FNtSummaryAmt = null,FCashSummaryAmt = null where FSummaryFlag = '" + info.getSummaryFlag() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (b) {
                iMutex.releaseObjIDForUpdate(info.getId().toString());
            }
        }
        return map;
    }

    private void deletePaymentBill(Context ctx, PaySchDetailBillInfo paySchDetailBillInfo, PaymentBillCollection paymentColl, Map map, boolean isScheduleBack) throws BOSException, EASBizException {
        ctx.put((Object)"deleteFromSchedule", (Object)true);
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        boolean NT051 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT051", (IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getCompany().getId()));
        for (int i = 0; i < paymentColl.size(); ++i) {
            PaymentBillInfo paymentInfo = paymentColl.get(i);
            boolean isNtback = false;
            isNtback = paySchDetailBillInfo.getNtPayBill() != null && paymentInfo.getId().toString().equals(paySchDetailBillInfo.getNtPayBill().getId().toString());
            PaySchDetailBillCollection paySchDetailBillCollection = this.getPaySchDetailBillCollectionByPayment(ctx, paymentInfo);
            if (paySchDetailBillCollection.size() > 0) {
                for (int m = 0; m < paySchDetailBillCollection.size(); ++m) {
                    PaySchDetailBillInfo paySchInfo = paySchDetailBillCollection.get(m);
                    this.unLockReceivableBill(ctx, paySchInfo);
                    this.disPaySchDetailBill(ctx, paySchInfo, true, isNtback);
                    this.disPayPlan(ctx, paySchInfo, true, isNtback, isScheduleBack);
                    BigDecimal backAmt = BigDecimal.ZERO.compareTo(paySchInfo.getNtBackAmt()) == 0 ? paySchInfo.getCashBackAmt() : paySchInfo.getNtBackAmt();
                    map.put(paySchInfo.getId(), ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"84_PaySchDetailBillControllerBean", (Locale)ctx.getLocale()) + paymentInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"85_PaySchDetailBillControllerBean", (Locale)ctx.getLocale()) + paySchInfo.getPayPlan().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"86_PaySchDetailBillControllerBean", (Locale)ctx.getLocale()) + paymentInfo.getSettlementType().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"87_PaySchDetailBillControllerBean", (Locale)ctx.getLocale()) + backAmt);
                }
            }
            iPaymentBill.delete((IObjectPK)new ObjectUuidPK(paymentInfo.getId().toString()));
            this.deleteBotp(ctx, paymentInfo);
            if (!isScheduleBack) continue;
            String orgScheduleId = paySchDetailBillInfo.getOrgScheduleId();
            Map balancemap = CapitalBalanceWebFacadeFactory.getLocalInstance(ctx).calculateCapitalBalanceData(orgScheduleId, null);
            List rowList = (List)balancemap.get("rowList");
            String updateSql = " UPDATE T_PP_OrgSchedule SET FSTATUS =? WHERE  fid = ?";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{5, orgScheduleId});
            CapitalBalanceFactory.getLocalInstance(ctx).saveBalance(orgScheduleId, rowList);
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{8, orgScheduleId});
        }
    }

    private void deleteBotp(Context ctx, PaymentBillInfo paymentInfo) throws BOSException, EASBizException {
        HashSet<String> srcIdSet = new HashSet<String>();
        PaymentBillEntryCollection entrys = paymentInfo.getEntries();
        for (int i = 0; i < entrys.size(); ++i) {
            PaymentBillEntryInfo entryInfo = entrys.get(i);
            if (entryInfo.getSrcPlanBillID() != null) {
                srcIdSet.add(entryInfo.getSrcPlanBillID());
            }
            if (entryInfo.getSrcPlanBillEntryID() == null) continue;
            srcIdSet.add(entryInfo.getSrcPlanBillEntryID());
        }
        if (!EmptyUtil.isEmpty(srcIdSet)) {
            String desId = paymentInfo.getId().toString();
            String sql2 = "delete T_BOT_Relation WHERE FSrcObjectID  in " + FMHelper.setTran2String(srcIdSet) + " and FDestObjectID = ? ";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{desId});
        }
    }

    private PaySchDetailBillCollection getPaySchDetailBillCollectionByPayment(Context ctx, PaymentBillInfo paymentInfo) throws BOSException, EASBizException {
        PaySchDetailBillCollection paySchDetailBillCollection = new PaySchDetailBillCollection();
        HashSet<String> paySchDetailBillIdSet = new HashSet<String>();
        PaymentBillEntryCollection entrys = paymentInfo.getEntries();
        for (int i = 0; i < entrys.size(); ++i) {
            PaymentBillEntryInfo entry = entrys.get(i);
            if (entry.getSrcPlanBillEntryID() == null) continue;
            paySchDetailBillIdSet.add(entry.getSrcPlanBillEntryID().toString());
        }
        if (paySchDetailBillIdSet.size() > 0) {
            paySchDetailBillCollection = this.getPaySchDetailBillCollection(ctx, paySchDetailBillIdSet);
        }
        return paySchDetailBillCollection;
    }

    private void unLockReceivableBill(Context ctx, PaySchDetailBillInfo paySchDetailBillInfo) throws BOSException, EASBizException {
        PaySchDetailBillNTsCollection ntsColl = paySchDetailBillInfo.getNts();
        HashSet<String> receivableBillSet = new HashSet<String>();
        if (ntsColl.size() > 0) {
            for (int i = 0; i < ntsColl.size(); ++i) {
                receivableBillSet.add(ntsColl.get(i).getReceivableBill().getId().toString());
            }
        }
        HashSet<String> companyset = new HashSet<String>();
        companyset.add(paySchDetailBillInfo.getCompany().getId().toString());
        if (paySchDetailBillInfo.isIsCrossOrg()) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)paySchDetailBillInfo.getCompany().getId().toString(), CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            SelectorItemCollection setSic = new SelectorItemCollection();
            setSic.add(new SelectorItemInfo("id"));
            setSic.add(new SelectorItemInfo("clearingHouse"));
            entityViewInfo.setSelector(setSic);
            PPScheduleSettingCollection coll = PPScheduleSettingFactory.getRemoteInstance().getPPScheduleSettingCollection(entityViewInfo);
            if (coll.size() > 0 && coll.get(0).getClearingHouse() != null) {
                companyset.add(coll.get(0).getClearingHouse().getId().toString());
            }
        }
        if (receivableBillSet.size() > 0) {
            String sql = "update T_NT_ReceivableBill set FIsLockByBill=0 where Fid in " + FMHelper.setTran2String(receivableBillSet) + " and FCompanyId in " + FMHelper.setTran2String(companyset);
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private void disPayPlan(Context ctx, PaySchDetailBillInfo paySchDetailBillInfo, boolean isCreatePaymentBill, boolean isNtback, boolean isScheduleBack) throws BOSException, EASBizException {
        String payPlanId = paySchDetailBillInfo.getPayPlan().getId().toString();
        SelectorItemCollection payPlanSic = new SelectorItemCollection();
        payPlanSic.add("number");
        payPlanSic.add("schdlBalanceAmt");
        payPlanSic.add("cashSchdlLockAmt");
        payPlanSic.add("paperSchdlLockAmt");
        payPlanSic.add("applyPayAmount");
        payPlanSic.add("LockAmt");
        payPlanSic.add("cashToPayAmt");
        payPlanSic.add("paperToPayAmt");
        payPlanSic.add("toPayAmount");
        payPlanSic.add("lastUpdateTime");
        payPlanSic.add("lastUpdateUser");
        IPayPlanBill payPlan = PayPlanBillFactory.getLocalInstance(ctx);
        PayPlanBillInfo payPlanBillInfo = payPlan.getPayPlanBillInfo((IObjectPK)new ObjectUuidPK(payPlanId), payPlanSic);
        if (!isCreatePaymentBill) {
            payPlanBillInfo.setPaperSchdlLockAmt(payPlanBillInfo.getPaperSchdlLockAmt().subtract(paySchDetailBillInfo.getNtAuditedAmt()));
            payPlanBillInfo.setCashSchdlLockAmt(payPlanBillInfo.getCashSchdlLockAmt().subtract(paySchDetailBillInfo.getCashAuditedAmt()));
        } else if (isNtback) {
            payPlanBillInfo.setPaperSchdlLockAmt(payPlanBillInfo.getPaperSchdlLockAmt().subtract(paySchDetailBillInfo.getNtBackAmt()));
            payPlanBillInfo.setPaperToPayAmt(payPlanBillInfo.getPaperToPayAmt().subtract(paySchDetailBillInfo.getNtBackAmt()));
        } else {
            payPlanBillInfo.setCashSchdlLockAmt(payPlanBillInfo.getCashSchdlLockAmt().subtract(paySchDetailBillInfo.getCashBackAmt()));
            payPlanBillInfo.setCashToPayAmt(payPlanBillInfo.getCashToPayAmt().subtract(paySchDetailBillInfo.getCashBackAmt()));
        }
        payPlanBillInfo.setToPayAmount(payPlanBillInfo.getPaperToPayAmt().add(payPlanBillInfo.getCashToPayAmt()));
        payPlanBillInfo.setLockAmt(payPlanBillInfo.getCashSchdlLockAmt().add(payPlanBillInfo.getPaperSchdlLockAmt()));
        payPlanBillInfo.setSchdlBalanceAmt(payPlanBillInfo.getApplyPayAmount().subtract(payPlanBillInfo.getLockAmt()));
        if (payPlanBillInfo.getSchdlBalanceAmt().compareTo(payPlanBillInfo.getApplyPayAmount()) == 0) {
            payPlanBillInfo.setBillStatus(BillStatusEnum.AUDIT);
            payPlanSic.add("billStatus");
        }
        if (isScheduleBack) {
            payPlanSic.add("payableDate");
            payPlanSic.add("billStatus");
            payPlanBillInfo.setPayableDate(new Date());
            payPlanBillInfo.setBillStatus(BillStatusEnum.TONEXT);
        }
        payPlanBillInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        payPlanBillInfo.setLastUpdateUser(userInfo);
        payPlan.updatePartial(payPlanBillInfo, payPlanSic);
    }

    private void disPaySchDetailBill(Context ctx, PaySchDetailBillInfo paySchDetailBillInfo, boolean isCreatePaymentBill, boolean isNtback) throws BOSException, EASBizException {
        IPaySchDetailBill paySchDetailBill = PaySchDetailBillFactory.getLocalInstance(ctx);
        if (isCreatePaymentBill) {
            SelectorItemCollection paySchDetailSrc = new SelectorItemCollection();
            paySchDetailSrc.add("ntBackAmt");
            paySchDetailSrc.add("ntBackLocAmt");
            paySchDetailSrc.add("cashBackAmt");
            paySchDetailSrc.add("cashBackLocAmt");
            paySchDetailSrc.add("backCount");
            paySchDetailSrc.add("ntBackCount");
            paySchDetailSrc.add("status");
            paySchDetailSrc.add("cashPayBill");
            paySchDetailSrc.add("ntPayBill");
            OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getOrgScheduleId()));
            if (isNtback) {
                paySchDetailBillInfo.setNtBackAmt(paySchDetailBillInfo.getNtAuditedAmt());
                paySchDetailBillInfo.setNtBackLocAmt(paySchDetailBillInfo.getNtAuditedLocAmt());
                paySchDetailBillInfo.setNtBackCount(orgScheduleInfo.getCount());
                paySchDetailBillInfo.setNtPayBill(null);
                if (paySchDetailBillInfo.getCashBackAmt() == null) {
                    paySchDetailBillInfo.setCashBackAmt(BigDecimal.ZERO);
                    paySchDetailBillInfo.setCashBackLocAmt(BigDecimal.ZERO);
                }
            } else {
                paySchDetailBillInfo.setCashBackAmt(paySchDetailBillInfo.getCashAuditedAmt());
                paySchDetailBillInfo.setCashBackLocAmt(paySchDetailBillInfo.getCashAuditedLocAmt());
                paySchDetailBillInfo.setBackCount(orgScheduleInfo.getCount());
                paySchDetailBillInfo.setCashPayBill(null);
                if (paySchDetailBillInfo.getNtBackAmt() == null) {
                    paySchDetailBillInfo.setNtBackAmt(BigDecimal.ZERO);
                    paySchDetailBillInfo.setNtBackLocAmt(BigDecimal.ZERO);
                }
            }
            if (paySchDetailBillInfo.getNtAmt().compareTo(BigDecimal.ZERO) > 0 && paySchDetailBillInfo.getNtBackAmt().compareTo(BigDecimal.ZERO) == 0 || paySchDetailBillInfo.getCashAmt().compareTo(BigDecimal.ZERO) > 0 && paySchDetailBillInfo.getCashBackAmt().compareTo(BigDecimal.ZERO) == 0) {
                paySchDetailBillInfo.setStatus(PaySchDetailBillStatuEnum.PARTBACK);
            } else {
                paySchDetailBillInfo.setStatus(PaySchDetailBillStatuEnum.ALLBACK);
            }
            paySchDetailBill.updatePartial(paySchDetailBillInfo, paySchDetailSrc);
        } else {
            paySchDetailBill.delete((IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getId().toString()));
        }
    }

    @Override
    protected Map _backPayment(Context ctx, Set idSet, String paySchDetailBillId, boolean isScheduleBack) throws BOSException, EASBizException {
        String summary = "";
        summary = summary + PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_Count", new String[]{idSet.size() + ""});
        Map map = new HashMap();
        BatchExecuteResult result = new BatchExecuteResult();
        int success = 0;
        Set paySchDetailIdSet = PaySchDetailBillControllerBean.ids2Set(paySchDetailBillId);
        Map idMap = this.getPaySchDetailAndPayId(ctx, paySchDetailIdSet);
        PaymentBillCollection paymentColl = this.getPaymentBillCollection(ctx, idSet);
        for (int i = 0; i < paymentColl.size(); ++i) {
            PaymentBillCollection paymentCollNew = new PaymentBillCollection();
            PaymentBillInfo paymentInfo = paymentColl.get(i);
            paymentCollNew.add(paymentInfo);
            try {
                if (!paymentInfo.getBillStatus().equals((Object)com.kingdee.eas.fi.cas.BillStatusEnum.SAVE) && !paymentInfo.getBillStatus().equals((Object)com.kingdee.eas.fi.cas.BillStatusEnum.SUBMIT)) {
                    throw new PPException(PPException.NOT_PAYSCHDETAILBILL);
                }
                HashSet paySchIdSet = new HashSet();
                paySchIdSet.add(idMap.get(paymentInfo.getId().toString()));
                PaySchDetailBillInfo paySchDetailBillInfo = this.getPaySchDetailBillCollection(ctx, paySchIdSet).get(0);
                map = this.backPaySchDetailBill(ctx, paySchDetailBillInfo, paymentCollNew, true, isScheduleBack);
                ++success;
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)paySchDetailBillInfo.getBOSType(), null, (String)paySchDetailBillInfo.getLogInfo(), (String)"pp_paySchDetail_back");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.getDetailMsgList().add(PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_Error_Payment", new String[]{paymentInfo.getNumber(), e.getMessage()}));
            }
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_BackSuccess", null) : summary + PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_Success_Failed", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        if (result.getSummaryMsg() == null) {
            for (String value : map.values()) {
                result.getDetailMsgList().add(value);
            }
            result.setSummaryMsg(PaySchDetailBillControllerBean.getResource(ctx, "PaySchDetailBill_BackSuccess", null));
        }
        return result;
    }

    public static Set ids2Set(String modelID) {
        String[] ids = modelID.split(",");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        return set;
    }

    @Override
    public Map _beforeBreakUp(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("status");
        sic.add("isBreakUp");
        sic.add("breakUpNumber");
        sic.add("SetFundProperty.id");
        sic.add("orgScheduleId");
        PaySchDetailBillInfo info = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        this.verifyOrgScheduleStatus(ctx, info);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"paySchDetail_11breakUp");
        if (!isPermission) {
            throw new PPException(PPException.NO_BREAKUP, new Object[]{info.getCompany().getName()});
        }
        if (info.getStatus() != PaySchDetailBillStatuEnum.UNGENERATE) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PaySch_NO_UNGENERATE_BU")});
        }
        if (info.isIsBreakUp()) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PaySch_NOT_AGAIN_BU")});
        }
        if (!EmptyUtil.isEmpty((String)info.getBreakUpNumber())) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PaySch_SON_NOT_BU")});
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("optionalSTNumber");
        SetFundPropertyInfo setFundPropertyInfo = SetFundPropertyFactory.getLocalInstance(ctx).getSetFundPropertyInfo((IObjectPK)new ObjectUuidPK(info.getSetFundProperty().getId()), selector);
        String optionalSTNumber = setFundPropertyInfo.getOptionalSTNumber();
        Object[] settlementTypes = optionalSTNumber.split(",");
        HashSet numberSet = new HashSet(Arrays.asList((Object[])settlementTypes));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("ntType.superGroup", (Object)5));
        filter.getFilterItems().add(new FilterItemInfo("ntType.superGroup", (Object)4));
        filter.setMaskString("#0 and (#1 or #2)");
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            idSet.add(coll.get(i).getId().toString());
        }
        idSet.add("");
        FilterInfo newFilter = new FilterInfo();
        newFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filter", newFilter.toSql());
        return map;
    }

    @Override
    public void _breakUp(Context ctx, String billId, BigDecimal breakUpAmt, String settlementTypeId) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean b = true;
        try {
            b = iMutex.requestObjIDForUpdate(billId);
            if (!b) {
                throw new PPException(PPException.BREAK_LOCK);
            }
            PaySchDetailBillInfo info = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(billId));
            this.verifyOrgScheduleStatus(ctx, info);
            PaySchDetailBillInfo oldInfo = (PaySchDetailBillInfo)info.clone();
            PaySchDetailBillInfo newInfo = this.copyPaySchDetail(info);
            BigDecimal ntAmt = info.getNtAmt();
            BigDecimal ntAuditedAmt = info.getNtAuditedAmt();
            if (breakUpAmt.compareTo(ntAuditedAmt) > 0) {
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PaySch_BUAmt_BIGERR")});
            }
            if (info.getSummaryFlag() != null) {
                throw new PPException(PPException.NOT_SUMMARY, new Object[]{info.getNumber()});
            }
            info.setNtAuditedAmt(ntAuditedAmt.subtract(breakUpAmt));
            info.setNtAmt(ntAmt.subtract(breakUpAmt));
            info.setNtLocAmt(this.calCulateNTLoc(ctx, info, info.getNtAmt()));
            info.setNtAuditedLocAmt(this.calCulateNTLoc(ctx, info, info.getNtAuditedAmt()));
            info.setLastNtAmt(info.getLastNtAmt().subtract(breakUpAmt));
            if (info.getNtSelectAmt() != null) {
                info.setNtBalance(info.getNtAuditedAmt().subtract(info.getNtSelectAmt()));
            }
            info.setIsBreakUp(true);
            newInfo.setNtAmt(breakUpAmt);
            newInfo.setNtAuditedAmt(breakUpAmt);
            newInfo.setNtBalance(newInfo.getNtAuditedAmt().subtract(newInfo.getNtSelectAmt()));
            newInfo.setNtAuditedLocAmt(this.calCulateNTLoc(ctx, newInfo, newInfo.getNtAuditedAmt()));
            newInfo.setNtLocAmt(this.calCulateNTLoc(ctx, newInfo, newInfo.getNtAmt()));
            SettlementTypeInfo settlementType = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeInfo((IObjectPK)new ObjectUuidPK(settlementTypeId));
            newInfo.setNtSettleType(settlementType);
            this.submit(ctx, (CoreBaseInfo)info);
            this.submit(ctx, (CoreBaseInfo)newInfo);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_paySchDetail_breakUp");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            boolean CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (CS127) {
                this.recordPayInfoLog(ctx, oldInfo, info, PaymentOperateType.BREAKUP);
                this.recordPayInfoLog(ctx, new PaySchDetailBillInfo(), newInfo, PaymentOperateType.BREAKUPNEW);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u6392\u7a0b\u660e\u7ec6\u62c6\u5206\u5931\u8d25 ");
            logger.error((Object)e);
            throw new PPException(PPException.COMMON, new Object[]{e.getMessage()});
        }
        finally {
            if (b) {
                iMutex.releaseObjIDForUpdate(billId);
            }
        }
    }

    private PaySchDetailBillInfo copyPaySchDetail(PaySchDetailBillInfo info) {
        PaySchDetailBillInfo newInfo = (PaySchDetailBillInfo)info.clone();
        newInfo.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        newInfo.setBreakUpNumber(info.getNumber());
        newInfo.setNumber("BU-" + info.getNumber());
        newInfo.setCashAmt(BigDecimal.ZERO);
        newInfo.setCashSettleType(null);
        newInfo.setCashAuditedAmt(BigDecimal.ZERO);
        newInfo.setCashBackAmt(BigDecimal.ZERO);
        newInfo.setCashAuditedLocAmt(BigDecimal.ZERO);
        newInfo.setCashLocAmt(BigDecimal.ZERO);
        newInfo.setCashAuditedLocAmt(BigDecimal.ZERO);
        newInfo.setLastCashAmt(BigDecimal.ZERO);
        newInfo.setCashBackLocAmt(BigDecimal.ZERO);
        newInfo.setLastNtAmt(BigDecimal.ZERO);
        newInfo.setNtBalance(BigDecimal.ZERO);
        newInfo.setNtSelectAmt(BigDecimal.ZERO);
        newInfo.setNtLocAmt(BigDecimal.ZERO);
        newInfo.setNtAuditedLocAmt(BigDecimal.ZERO);
        newInfo.setIsBreakUp(false);
        newInfo.getNts().clear();
        return newInfo;
    }

    private BigDecimal calCulateNTLoc(Context ctx, PaySchDetailBillInfo info, BigDecimal amount) throws EASBizException, BOSException {
        BigDecimal locAmt = BigDecimal.ZERO;
        CurrencyInfo bassCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany());
        BigDecimal ntExchangeRate = Constants.ONE;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isoCode", (Object)"RMB"));
        filter.getFilterItems().add(new FilterItemInfo("isoCode", (Object)"CNY"));
        filter.setMaskString("#0 or #1 ");
        view.setFilter(filter);
        CurrencyCollection ntCurrencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        if (ntCurrencyColl.size() > 0) {
            CurrencyInfo ntCurrency = ntCurrencyColl.get(0);
            if (ntCurrency != null && !ntCurrency.getId().toString().equals(bassCurrency.getId().toString())) {
                ExchangeRateInfo exchangeRate = this.findExchangeRate(ctx, ntCurrency.getId().toString(), bassCurrency.getId().toString(), info);
                locAmt = PaySchDetailBillControllerBean.calLocAmt(amount, exchangeRate, bassCurrency);
            } else {
                locAmt = amount.multiply(ntExchangeRate);
            }
        }
        return locAmt;
    }

    @Override
    public void _unbreakUp(Context ctx, String billId) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean b = true;
        try {
            b = iMutex.requestObjIDForUpdate(billId);
            if (!b) {
                throw new PPException(PPException.UNBREAK_LOCK);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("company.name");
            PaySchDetailBillInfo info = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
            this.verifyOrgScheduleStatus(ctx, info);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"paySchDetail_11breakUp");
            if (!isPermission) {
                throw new PPException(PPException.NO_UNBREAKUP, new Object[]{info.getCompany().getName()});
            }
            if (info.getStatus() != PaySchDetailBillStatuEnum.UNGENERATE) {
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PaySch_NO_UNGENERATE_UBU")});
            }
            if (!info.isIsBreakUp()) {
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PaySch_NOBU_NOUBU")});
            }
            if (info.getSummaryFlag() != null) {
                throw new PPException(PPException.NOT_SUMMARY, new Object[]{info.getNumber()});
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("breakUpNumber", (Object)info.getNumber()));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            if (info.isIsBreakUp() && !this.exists(ctx, filter)) {
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PaySch_SON_NOT_UBU")});
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            PaySchDetailBillCollection coll = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(view);
            PaySchDetailBillInfo sonInfo = coll.get(0);
            if (sonInfo.getNtSelectAmt().compareTo(BigDecimal.ZERO) > 0) {
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PaySch_SON_LOCKNT")});
            }
            info.setIsBreakUp(false);
            info.setNtAmt(info.getNtAmt().add(sonInfo.getNtAmt()));
            info.setNtLocAmt(info.getNtLocAmt().add(sonInfo.getNtLocAmt()));
            info.setNtAuditedAmt(info.getNtAuditedAmt().add(sonInfo.getNtAuditedAmt()));
            info.setNtAuditedLocAmt(info.getNtAuditedLocAmt().add(sonInfo.getNtAuditedLocAmt()));
            info.setLastNtAmt(info.getLastNtAmt().add(sonInfo.getNtAmt()));
            if (info.getNtSelectAmt() != null) {
                info.setNtBalance(info.getNtAuditedAmt().subtract(info.getNtSelectAmt()));
            }
            this.submit(ctx, (CoreBaseInfo)info);
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(sonInfo.getId()));
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_paySchDetail_unbreakUp");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        catch (Exception e) {
            logger.error((Object)"\u6392\u7a0b\u660e\u7ec6\u53d6\u6d88\u62c6\u5206\u5931\u8d25 ");
            logger.error((Object)e);
            throw new PPException(PPException.COMMON, new Object[]{e.getMessage()});
        }
        finally {
            if (b) {
                iMutex.releaseObjIDForUpdate(billId);
            }
        }
    }

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _balanceClera(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        summary = summary + PaySchDetailBillControllerBean.getResource(ctx, "002_setFundProperty", new String[]{idSet.size() + ""});
        PaySchDetailBillCollection coll = this.getPaySchDetailBillCollection(ctx, idSet);
        PaySchDetailBillInfo pInfo = (PaySchDetailBillInfo)coll.getObject(0);
        this.verifyOrgScheduleStatus(ctx, pInfo);
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(pInfo.getCompany().getId()), (String)"paySchDetail_12balanceClera");
            if (!isPermission) {
                throw new PPException(PPException.NOT_BALANCECLERA, new Object[]{pInfo.getCompany().getName()});
            }
            boolean CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(pInfo.getCompany().getId()));
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean b = true;
            for (int i = 0; i < coll.size(); ++i) {
                PaySchDetailBillInfo info = coll.get(i);
                PaySchDetailBillInfo oldInfo = (PaySchDetailBillInfo)info.clone();
                try {
                    b = iMutex.requestObjIDForUpdate(info.getId().toString());
                    if (!b) {
                        throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                    }
                    if (info.getNtSelectAmt().compareTo(BigDecimal.ZERO) == 0) {
                        throw new PPException(PPException.NTSELECTAMT_ISZERO, new Object[]{info.getNumber()});
                    }
                    BigDecimal ntBalance = info.getNtBalance();
                    this.updatePaySchDetailBill(ctx, info, ntBalance, false);
                    this.updatePayPlan(ctx, info, ntBalance, false);
                    IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_paySchDetail_balanceClera");
                    LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                    if (CS127) {
                        this.recordPayInfoLog(ctx, oldInfo, info, PaymentOperateType.BALANCECLEAR);
                    }
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PaySchDetailBillControllerBean.getResource(ctx, "IS_NOT_BALANCECLERA", new String[]{info.getNumber()}) + e.getMessage());
                    continue;
                }
                finally {
                    if (b) {
                        iMutex.releaseObjIDForUpdate(info.getId().toString());
                    }
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(PaySchDetailBillControllerBean.getResource(ctx, "IS_BALANCECLERA_ERROE", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? PaySchDetailBillControllerBean.getResource(ctx, "EXECUTE_SUCCESS", null) : summary + PaySchDetailBillControllerBean.getResource(ctx, "EXECUTE_SUCCESS_FAILED", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void updatePayPlan(Context ctx, PaySchDetailBillInfo info, BigDecimal ntBalance, boolean isCash) throws BOSException, EASBizException {
        String payPlanId = info.getPayPlan().getId().toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("number");
        selector.add("schdlBalanceAmt");
        selector.add("cashSchdlLockAmt");
        selector.add("paperSchdlLockAmt");
        selector.add("LockAmt");
        selector.add("applyPayAmount");
        IPayPlanBill payPlan = PayPlanBillFactory.getLocalInstance(ctx);
        PayPlanBillInfo payPlanBillInfo = payPlan.getPayPlanBillInfo((IObjectPK)new ObjectUuidPK(payPlanId), selector);
        if (isCash) {
            payPlanBillInfo.setCashSchdlLockAmt(payPlanBillInfo.getCashSchdlLockAmt().add(ntBalance));
        }
        payPlanBillInfo.setPaperSchdlLockAmt(payPlanBillInfo.getPaperSchdlLockAmt().subtract(ntBalance));
        payPlanBillInfo.setLockAmt(payPlanBillInfo.getCashSchdlLockAmt().add(payPlanBillInfo.getPaperSchdlLockAmt()));
        payPlanBillInfo.setSchdlBalanceAmt(payPlanBillInfo.getApplyPayAmount().subtract(payPlanBillInfo.getLockAmt()));
        payPlan.updatePartial(payPlanBillInfo, selector);
    }

    private void updatePaySchDetailBill(Context ctx, PaySchDetailBillInfo info, BigDecimal ntBalance, boolean isCash) throws PPException, BOSException, EASBizException {
        if (ntBalance.compareTo(BigDecimal.ZERO) < 0) {
            throw new PPException(PPException.BALANCE_IS_MINUS, new Object[]{info.getNumber()});
        }
        if (ntBalance.compareTo(BigDecimal.ZERO) == 0) {
            throw new PPException(PPException.BALANCE_IS_ZERO, new Object[]{info.getNumber()});
        }
        if (!info.getStatus().equals((Object)PaySchDetailBillStatuEnum.UNGENERATE)) {
            throw new PPException(PPException.NOT_EXECUTE);
        }
        if (info.getSummaryFlag() != null) {
            throw new PPException(PPException.NOT_SUMMARY, new Object[]{info.getNumber()});
        }
        OrgScheduleInfo oInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(info.getOrgScheduleId().toString()));
        SelectorItemCollection paySchSelector = new SelectorItemCollection();
        paySchSelector.add(new SelectorItemInfo("ntAuditedAmt"));
        paySchSelector.add(new SelectorItemInfo("ntAuditedLocAmt"));
        paySchSelector.add(new SelectorItemInfo("ntAmt"));
        paySchSelector.add(new SelectorItemInfo("ntLocAmt"));
        paySchSelector.add(new SelectorItemInfo("cashAmt"));
        paySchSelector.add(new SelectorItemInfo("cashAuditedAmt"));
        paySchSelector.add(new SelectorItemInfo("cashLocAmt"));
        paySchSelector.add(new SelectorItemInfo("cashAuditedLocAmt"));
        paySchSelector.add(new SelectorItemInfo("lastNtAmt"));
        paySchSelector.add(new SelectorItemInfo("lastCashAmt"));
        paySchSelector.add(new SelectorItemInfo("ntBalance"));
        ExchangeRateInfo casExchangeRate = null;
        CurrencyInfo bassCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany());
        CurrencyInfo casCurrency = info.getCurrency();
        if (casCurrency != null && !casCurrency.getId().toString().equals(bassCurrency.getId().toString())) {
            casExchangeRate = this.findExchangeRate(ctx, casCurrency.getId().toString(), bassCurrency.getId().toString(), info);
        }
        if (!oInfo.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT) && !oInfo.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT)) {
            info.setNtAmt(info.getNtAmt().subtract(ntBalance));
            info.setNtLocAmt(this.calCulateNTLoc(ctx, info, info.getNtAmt()));
            if (isCash) {
                info.setCashAmt(info.getCashAmt().add(ntBalance));
                info.setCashLocAmt(PaySchDetailBillControllerBean.calLocAmt(info.getCashAmt(), casExchangeRate, bassCurrency));
            }
        }
        info.setNtAuditedAmt(info.getNtAuditedAmt().subtract(ntBalance));
        info.setNtAuditedLocAmt(this.calCulateNTLoc(ctx, info, info.getNtAuditedAmt()));
        info.setLastNtAmt(info.getNtAuditedAmt());
        if (isCash) {
            info.setCashAuditedAmt(info.getCashAuditedAmt().add(ntBalance));
            info.setCashAuditedLocAmt(PaySchDetailBillControllerBean.calLocAmt(info.getCashAuditedAmt(), casExchangeRate, bassCurrency));
            info.setLastCashAmt(info.getCashAuditedAmt());
        }
        info.setNtBalance(BigDecimal.ZERO);
        this.updatePartial(ctx, info, paySchSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _balanceCash(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        summary = summary + PaySchDetailBillControllerBean.getResource(ctx, "002_setFundProperty", new String[]{idSet.size() + ""});
        PaySchDetailBillCollection coll = this.getPaySchDetailBillCollection(ctx, idSet);
        PaySchDetailBillInfo pInfo = (PaySchDetailBillInfo)coll.getObject(0);
        this.verifyOrgScheduleStatus(ctx, pInfo);
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(pInfo.getCompany().getId()), (String)"paySchDetail_13balanceCash");
            if (!isPermission) {
                throw new PPException(PPException.NOT_BALANCECASH, new Object[]{pInfo.getCompany().getName()});
            }
            boolean CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(pInfo.getCompany().getId()));
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean b = true;
            for (int i = 0; i < coll.size(); ++i) {
                PaySchDetailBillInfo info = coll.get(i);
                PaySchDetailBillInfo oldInfo = (PaySchDetailBillInfo)info.clone();
                try {
                    b = iMutex.requestObjIDForUpdate(info.getId().toString());
                    if (!b) {
                        throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource((Context)ctx, (String)"HAS_LOCKED")});
                    }
                    if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCashSettleType())) {
                        throw new PPException(PPException.CASHSETTLETYPE_ISNOT, new Object[]{info.getNumber()});
                    }
                    BigDecimal ntBalance = info.getNtBalance();
                    this.updatePaySchDetailBill(ctx, info, ntBalance, true);
                    this.updatePayPlan(ctx, info, ntBalance, true);
                    IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_paySchDetail_balanceCash");
                    LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                    if (CS127) {
                        this.recordPayInfoLog(ctx, oldInfo, info, PaymentOperateType.BALANCECASH);
                    }
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PaySchDetailBillControllerBean.getResource(ctx, "IS_NOT_BALANCECASH", new String[]{info.getNumber()}) + e.getMessage());
                    continue;
                }
                finally {
                    if (b) {
                        iMutex.releaseObjIDForUpdate(info.getId().toString());
                    }
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(PaySchDetailBillControllerBean.getResource(ctx, "IS_BALANCECASH_ERROR", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? PaySchDetailBillControllerBean.getResource(ctx, "EXECUTE_SUCCESS", null) : summary + PaySchDetailBillControllerBean.getResource(ctx, "EXECUTE_SUCCESS_FAILED", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _getExportData(Context ctx, Set idSet) throws BOSException, EASBizException {
        int i;
        Map<String, Object> map;
        BatchExecuteResult result = new BatchExecuteResult();
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.pp.app.PaySchDetailBillQuery"));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("dueDate");
        sorterItemInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterItemInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        ArrayList dataList = new ArrayList();
        try {
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            while (rowSet.next()) {
                map = new HashMap();
                int count = md.getColumnCount();
                for (i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = rowSet.getObject(i);
                    if (columnName.equals("status")) {
                        value = PaySchDetailBillStatuEnum.getEnum(Integer.parseInt(value.toString())).getAlias();
                    } else if (columnName.equals("isBreakUp") && value != null) {
                        value = Boolean.parseBoolean(value.toString()) ? "\u662f" : "\u5426";
                    }
                    map.put(columnName, value);
                }
                dataList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (dataList.size() > 0) {
            map = this.getNts(ctx, idSet);
            for (i = 0; i < dataList.size(); ++i) {
                String id;
                List numberList;
                Map row;
                if (dataList.get(i) == null || !(dataList.get(i) instanceof Map) || !(row = (Map)dataList.get(i)).containsKey("id") || row.get("id") == null || (numberList = (List)map.get(id = (String)row.get("id"))) == null) continue;
                row.put("receivableBill", StringUtils.strip((String)numberList.toString(), (String)"[]"));
            }
        }
        result.put((Object)"exportData", dataList);
        return result;
    }

    @Override
    protected Map _summary(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        PaySchDetailBillCollection coll = this.getPaySchDetailBillCollection(ctx, idSet);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            this.verifyOrgScheduleStatus(ctx, coll.get(0));
            try {
                ReceivableBillCollection receColl;
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(coll.get(0).getCompany().getId()), (String)"paySchDetail_14summary");
                if (!isPermission) {
                    throw new PPException(PPException.NOT_SUMMARY_PERMISSION, new Object[]{coll.get(0).getCompany().getName()});
                }
                boolean isSuccess = true;
                StringBuffer numbers = new StringBuffer();
                BigDecimal cashAmt = BigDecimal.ZERO;
                BigDecimal ntAmt = BigDecimal.ZERO;
                String paymentType = coll.get(0).getPaymentBillType().getId().toString();
                String currencyId = coll.get(0).getCurrency().getId().toString();
                String payerAccountBankId = coll.get(0).getPayerAccountBank().getId().toString();
                String payeeNameId = coll.get(0).getPayPlan().getAsstActID();
                String payeeAccountBank = coll.get(0).getPayeeAccountBank();
                Date payDate = coll.get(0).getDueDate();
                String payeeNunmber = coll.get(0).getPayPlan().getAsstActNumber();
                for (int i = 0; i < coll.size(); ++i) {
                    PaySchDetailBillInfo info = coll.get(i);
                    numbers.append(info.getNumber());
                    numbers.append(",");
                    if (!info.getStatus().equals((Object)PaySchDetailBillStatuEnum.UNGENERATE)) {
                        isSuccess = false;
                        break;
                    }
                    if (info.getSummaryFlag() != null) {
                        isSuccess = false;
                        break;
                    }
                    if (info.isIsBreakUp()) {
                        isSuccess = false;
                        break;
                    }
                    if (info.getSummaryFlag() != null) {
                        isSuccess = false;
                        break;
                    }
                    if (!(info.getPaymentBillType().getId().toString().equals(paymentType) && info.getCurrency().getId().toString().equals(currencyId) && info.getPayerAccountBank().getId().toString().equals(payerAccountBankId) && info.getPayPlan().getAsstActID().equals(payeeNameId) && info.getPayeeAccountBank().equals(payeeAccountBank) && info.getDueDate().compareTo(payDate) == 0)) {
                        isSuccess = false;
                        break;
                    }
                    cashAmt = cashAmt.add(info.getCashAuditedLocAmt());
                    ntAmt = ntAmt.add(info.getNtAuditedLocAmt());
                }
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)(receColl = this.getReceivableBillCollection(ctx, idSet))) && isSuccess) {
                    String receCurrencyId = receColl.get(0).getCompany().getId().toString();
                    for (int i = 0; i < receColl.size(); ++i) {
                        if (receColl.get(i).getCompany().getId().toString().equals(receCurrencyId)) continue;
                        isSuccess = false;
                        break;
                    }
                }
                if (isSuccess) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
                    String time = dateFormat.format(new Date());
                    String summaryFlag = payeeNunmber + "-" + time + "-" + idSet.size();
                    String sql = "update T_PP_PaySchDetailBill set FSummaryFlag = '" + summaryFlag + "',FNtSummaryAmt=" + ntAmt + ",FCashSummaryAmt=" + cashAmt + " where FId in " + FMHelper.setTran2String((Set)idSet);
                    DbUtil.execute((Context)ctx, (String)sql);
                    String summary = PaySchDetailBillControllerBean.getResource(ctx, "summary_success", null);
                    result.setSummaryMsg(summary);
                    IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new PaySchDetailBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_paySchDetail_summary");
                    LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                } else {
                    String summary = PaySchDetailBillControllerBean.getResource(ctx, "summary_failed", null);
                    result.setSummaryMsg(summary);
                    result.setError(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setSummaryMsg(PaySchDetailBillControllerBean.getResource(ctx, "summary_error", new String[]{e.getMessage()}));
            }
        }
        return result;
    }

    private ReceivableBillCollection getReceivableBillCollection(Context ctx, Set<String> idSet) throws BOSException {
        ReceivableBillCollection colls = new ReceivableBillCollection();
        if (idSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("receivableBill.*"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            PaySchDetailBillNTsCollection ntsColl = PaySchDetailBillNTsFactory.getLocalInstance(ctx).getPaySchDetailBillNTsCollection(view);
            if (ntsColl.size() > 0) {
                for (int i = 0; i < ntsColl.size(); ++i) {
                    colls.add(ntsColl.get(i).getReceivableBill());
                }
            }
        }
        return colls;
    }

    @Override
    protected Map _unSummary(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        StringBuffer numbers = new StringBuffer();
        int success = 0;
        summary = summary + PaySchDetailBillControllerBean.getResource(ctx, "002_setFundProperty", new String[]{idSet.size() + ""});
        HashSet<String> summaryFlagSet = new HashSet<String>();
        try {
            PaySchDetailBillCollection coll = this.getPaySchDetailBillCollection(ctx, idSet);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                this.verifyOrgScheduleStatus(ctx, coll.get(0));
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(coll.get(0).getCompany().getId()), (String)"paySchDetail_15unSummary");
                if (!isPermission) {
                    throw new PPException(PPException.NOT_UNSUMMARY_PERMISSION, new Object[]{coll.get(0).getCompany().getName()});
                }
                for (int i = 0; i < coll.size(); ++i) {
                    PaySchDetailBillInfo info = coll.get(i);
                    if (info.getSummaryFlag() == null) {
                        result.getDetailMsgList().add(PaySchDetailBillControllerBean.getResource(ctx, "not_unSummary", new String[]{info.getNumber()}));
                        continue;
                    }
                    if (!info.getStatus().equals((Object)PaySchDetailBillStatuEnum.UNGENERATE)) {
                        result.getDetailMsgList().add(PaySchDetailBillControllerBean.getResource(ctx, "notStatus_unSummary", new String[]{info.getNumber()}));
                        continue;
                    }
                    ++success;
                    summaryFlagSet.add(info.getSummaryFlag());
                    numbers.append(info.getNumber());
                    numbers.append(",");
                }
            }
            if (summaryFlagSet.size() > 0) {
                String sql = "update T_PP_PaySchDetailBill set FSummaryFlag = null,FNtSummaryAmt = null,FCashSummaryAmt = null where FSummaryFlag in " + FMHelper.setTran2String(summaryFlagSet);
                DbUtil.execute((Context)ctx, (String)sql);
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new PaySchDetailBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_paySchDetail_unsummary");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSummaryMsg(PaySchDetailBillControllerBean.getResource(ctx, "unSummary_error", new String[]{e.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? PaySchDetailBillControllerBean.getResource(ctx, "unSummary_success", null) : summary + PaySchDetailBillControllerBean.getResource(ctx, "unSummary_success_failed", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void recordPayInfoLog(Context ctx, PaySchDetailBillInfo oldInfo, PaySchDetailBillInfo info, PaymentOperateType operateType) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection logCollection = new CoreBaseCollection();
        this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, NTAMT);
        this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, NTAUDITEDAMT);
        this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, NTBALANCE);
        switch (operateType.getValue()) {
            case 39: {
                break;
            }
            case 40: {
                this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, CASHAMT);
                this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, CASHAUDITEDAMT);
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, NTSETTLETYPE);
            }
        }
        Date DestDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(-30));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("operateTime", (Object)DestDate, CompareType.LESS_EQUALS));
        PaymentBillLogFactory.getLocalInstance((Context)ctx).delete(filter);
        PaymentBillLogFactory.getLocalInstance((Context)ctx).addnewBatchData(logCollection);
    }

    private void createPaymentLogInfo(Context ctx, CoreBaseCollection logCollection, PaySchDetailBillInfo info, PaySchDetailBillInfo oldInfo, UserInfo userInfo, Timestamp currTime, PaymentOperateType operateType, String column) {
        PaymentBillLogInfo logInfo = new PaymentBillLogInfo();
        logInfo.setIP(ctx.getClientHostIP());
        logInfo.setOperateBillEnum(OperateBillEnum.PaySchDetailBill);
        logInfo.setBillNumber(info.getNumber());
        logInfo.setOperateTime(currTime);
        logInfo.setUserName(userInfo.getName());
        logInfo.setUserNumber(userInfo.getNumber());
        logInfo.setOperateType(operateType);
        logInfo.setCompany(info.getCompany());
        if (NTAMT.equals(column)) {
            logInfo.setUpdateColumn(NTAMT);
            if (oldInfo.getNtAmt() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getNtAmt().setScale(4, 4)));
            }
            if (info.getNtAmt() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getNtAmt().setScale(4, 4)));
            }
        } else if (CASHAMT.equals(column)) {
            logInfo.setUpdateColumn(CASHAMT);
            if (oldInfo.getCashAmt() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getCashAmt().setScale(4, 4)));
            }
            if (info.getCashAmt() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getCashAmt().setScale(4, 4)));
            }
        } else if (NTAUDITEDAMT.equals(column)) {
            logInfo.setUpdateColumn(NTAUDITEDAMT);
            if (oldInfo.getNtAuditedAmt() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getNtAuditedAmt().setScale(4, 4)));
            }
            if (info.getNtAuditedAmt() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getNtAuditedAmt().setScale(4, 4)));
            }
        } else if (CASHAUDITEDAMT.equals(column)) {
            logInfo.setUpdateColumn(CASHAUDITEDAMT);
            if (oldInfo.getCashAuditedAmt() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getCashAuditedAmt().setScale(4, 4)));
            }
            if (info.getCashAuditedAmt() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getCashAuditedAmt().setScale(4, 4)));
            }
        } else if (NTBALANCE.equals(column)) {
            logInfo.setUpdateColumn(NTBALANCE);
            if (oldInfo.getNtBalance() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getNtBalance().setScale(4, 4)));
            }
            if (info.getNtBalance() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getNtBalance().setScale(4, 4)));
            }
        } else if (NTSETTLETYPE.equals(column)) {
            logInfo.setUpdateColumn(NTSETTLETYPE);
            if (oldInfo.getNtSettleType() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getNtSettleType().getName()));
            }
            if (info.getNtSettleType() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getNtSettleType().getName()));
            }
        }
        logCollection.add((CoreBaseInfo)logInfo);
    }

    private Date getSrcDate(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + days);
        return calendar.getTime();
    }

    private void verifyOrgScheduleStatus(Context ctx, PaySchDetailBillInfo info) throws BOSException, EASBizException {
        OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(info.getOrgScheduleId()));
        if (orgScheduleInfo.getStatus() == StatusEnum.SCHEDULE_AUDIT || orgScheduleInfo.getStatus() == StatusEnum.ADJUST_AUDIT || orgScheduleInfo.getStatus() == StatusEnum.COMPLETE) {
            throw new PPException(PPException.STATUSCHANGE_REFRESH);
        }
    }

    private void verifyOrgScheduleStatusByBack(Context ctx, PaySchDetailBillInfo info) throws BOSException, EASBizException {
        OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(info.getOrgScheduleId()));
        if (orgScheduleInfo.getStatus() == StatusEnum.SCHEDULE_SUBMIT || orgScheduleInfo.getStatus() == StatusEnum.ADJUST_SUBMIT || orgScheduleInfo.getStatus() == StatusEnum.SCHEDULE_AUDIT || orgScheduleInfo.getStatus() == StatusEnum.ADJUST_AUDIT) {
            throw new PPException(PPException.STATUSCHANGE_REFRESH);
        }
    }
}

