/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.pp.IRecPlanBill;
import com.kingdee.eas.fm.pp.RecPlanBillCollection;
import com.kingdee.eas.fm.pp.RecPlanBillFactory;
import com.kingdee.eas.fm.pp.RecPlanBillInfo;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.fm.pp.app.PayRecPlanDataImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RecPlanBillDataImport
extends AbstractFMDataImport {
    String resourcePath = "com.kingdee.eas.fm.pp.PpResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.RecPlanBillDataImport");

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return RecPlanBillFactory.getLocalInstance(ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        Object asstActNumberData;
        RecPlanBillInfo info = new RecPlanBillInfo();
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        this.verifyNotNull(info, ctx);
        Object companyData = this.getData(hsData, "company");
        CompanyOrgUnitInfo company = PayRecPlanDataImportUtil.getCompanyByNumber(ctx, (String)companyData);
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), "recPlanBill_07import");
        String companyId = company.getId().toString();
        CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
        Object currencyData = this.getData(hsData, "currency");
        CurrencyInfo currency = PayRecPlanDataImportUtil.getCurrencyByNumber(ctx, (String)currencyData);
        String currencyId = currency.getId().toString();
        Object recAmountData = this.getData(hsData, "recAmount");
        BigDecimal recAmount = PayRecPlanDataImportUtil.objToBigDecimal(ctx, recAmountData);
        if (recAmount.compareTo(BigDecimal.ZERO) == 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"recAmountNotZero", (Locale)ctx.getLocale()));
        }
        recAmount = recAmount.setScale(currency.getPrecision(), 4);
        info.setRecAmount(recAmount);
        BigDecimal recLocAmt = PayRecPlanDataImportUtil.getLocAmount(ctx, companyId, currencyId, baseCurrency, recAmount, info.getRecableDate());
        info.setRecLocAmount(recLocAmt);
        Object setFundPropertyData = this.getData(hsData, "setFundProperty");
        SetFundPropertyInfo setFundProPerty = PayRecPlanDataImportUtil.getSetFundPropertyByNumber(ctx, (String)setFundPropertyData, companyId);
        info.setSetFundProperty(setFundProPerty);
        Object payeeAccountBankData = this.getData(hsData, "payeeAccountBank");
        AccountBankInfo accountBank = PayRecPlanDataImportUtil.getAccountBankByNumber(ctx, "payeeAccountBank", companyId, (String)payeeAccountBankData, true, false);
        info.setPayeeAccountBank(accountBank);
        if (info.getDepartment() == null) {
            Object departmentData = this.getData(hsData, "department");
            AdminOrgUnitInfo department = PayRecPlanDataImportUtil.getDepartmentByNumber(ctx, (String)departmentData);
            info.setDepartment(department);
        }
        if (info.getSettlementType() == null) {
            Object settlementTypeData = this.getData(hsData, "settlementType");
            SettlementTypeInfo settlementType = PayRecPlanDataImportUtil.getSettlementTypeByNumber(ctx, (String)settlementTypeData);
            info.setSettlementType(settlementType);
        }
        if ((asstActNumberData = this.getData(hsData, "asstActNumber")) != null && asstActNumberData.toString().trim().length() > 0) {
            IRowSet asstActInfo = PayRecPlanDataImportUtil.getAsstActInfo(info.getAsstActType(), (String)asstActNumberData, ctx);
            try {
                if (asstActInfo.next()) {
                    info.setAsstActID(asstActInfo.getString("fid"));
                    info.setAsstActNumber(asstActInfo.getString("fnumber"));
                    String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                    info.setAsstActName(asstActInfo.getString("fname_" + loc));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage());
            }
        }
        return info;
    }

    private void verifyNotNull(RecPlanBillInfo info, Context ctx) throws BOSException {
        if (info.getRecableDate() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoRecableDate", (Locale)ctx.getLocale()));
        }
        if (info.getCompany() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoCompany", (Locale)ctx.getLocale()));
        }
        if (info.getCurrency() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoCurrency", (Locale)ctx.getLocale()));
        }
        if (info.getRecAmount() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoRecAmount", (Locale)ctx.getLocale()));
        }
        if (info.getAsstActType() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoAsstActType", (Locale)ctx.getLocale()));
        }
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        RecPlanBillInfo recPlan = (RecPlanBillInfo)coreBaseInfo;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (recPlan.getNumber() != null && mode == 16) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)recPlan.getNumber()));
            view.setFilter(filter);
            IRecPlanBill recPlanBill = (IRecPlanBill)this._getController(ctx);
            RecPlanBillCollection coll = recPlanBill.getRecPlanBillCollection(view);
            if (coll != null && coll.size() > 0) {
                coreBaseInfo.setId(coll.get(0).getId());
            }
        }
        this._getController(ctx).save(coreBaseInfo);
    }

    protected String getTemplateNumber() {
        return "recPlanBill";
    }
}

