/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.StandbyAmountCollection;
import com.kingdee.eas.fm.pp.StandbyAmountFactory;
import com.kingdee.eas.fm.pp.StandbyAmountInfo;
import com.kingdee.eas.fm.pp.app.AbstractStandbyAmountControllerBean;
import org.apache.log4j.Logger;

public class StandbyAmountControllerBean
extends AbstractStandbyAmountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.StandbyAmountControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandbyAmountInfo info = (StandbyAmountInfo)model;
        this.checkInfo(info);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId()));
        entityViewInfo.setFilter(filter);
        StandbyAmountCollection coll = StandbyAmountFactory.getLocalInstance(ctx).getStandbyAmountCollection(entityViewInfo);
        if (coll.size() > 0) {
            throw new PPException(PPException.STANDBYAMOUNT_NOT_SAVE);
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        StandbyAmountInfo info = (StandbyAmountInfo)model;
        this.checkInfo(info);
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "standbyAmount_02update");
        super._update(ctx, pk, model);
    }

    private void checkInfo(StandbyAmountInfo info) throws PPException {
        if (info.getCompany() == null) {
            throw new PPException(PPException.NOCOMPANY);
        }
        if (info.getCurrency() == null) {
            throw new PPException(PPException.NOCURRENCY);
        }
        if (info.getAmount() == null) {
            throw new PPException(PPException.NOAMOUNT);
        }
    }
}

