/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.UserDefinedPeriodCollection;
import com.kingdee.eas.fm.pp.UserDefinedPeriodEnum;
import com.kingdee.eas.fm.pp.UserDefinedPeriodFactory;
import com.kingdee.eas.fm.pp.UserDefinedPeriodInfo;
import com.kingdee.eas.fm.pp.WeekNumberEnum;
import com.kingdee.eas.fm.pp.app.AbstractUserDefinedPeriodControllerBean;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class UserDefinedPeriodControllerBean
extends AbstractUserDefinedPeriodControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.UserDefinedPeriodControllerBean");
    private final Integer weekLeastDay = 5;
    private final Integer oneWeekMaxDay = 15;

    @Override
    protected void _autoGenWeeks(Context ctx, int yearNumber) throws BOSException, EASBizException {
        CtrlUnitInfo cu = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)yearNumber));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString()));
        if (this.exists(ctx, filter)) {
            this.isReferenced(ctx, yearNumber, null);
            this.delete(ctx, filter);
        }
        int[] dayRealSort = new int[]{7, 1, 2, 3, 4, 5, 6};
        Calendar cal = Calendar.getInstance();
        UserDefinedPeriodCollection coll = new UserDefinedPeriodCollection();
        for (int i = 0; i < 12; ++i) {
            int monthNumber = i + 1;
            int dayAmtOfThisMonth = DateHelper.daysOfMonth((int)yearNumber, (int)monthNumber);
            ArrayList<Integer> dayAmtList = new ArrayList<Integer>();
            int dayAmt = 0;
            cal.set(yearNumber, monthNumber - 1, 1, 0, 0, 0);
            cal.set(14, 0);
            int w = dayRealSort[cal.get(7) - 1];
            if (8 - w >= this.weekLeastDay) {
                dayAmtList.add(8 - w);
                dayAmt += 8 - w;
            } else if (8 - w < this.weekLeastDay && 8 - w > 0) {
                dayAmtList.add(8 - w + 7);
                dayAmt += 8 - w + 7;
            } else {
                throw new PPException(PPException.SETDAYERROR);
            }
            while (dayAmtOfThisMonth - dayAmt >= this.weekLeastDay + 7) {
                dayAmtList.add(7);
                dayAmt += 7;
            }
            dayAmtList.add(dayAmtOfThisMonth - dayAmt);
            coll.addCollection(this.genInfoByDayAmtList(ctx, dayAmtList, yearNumber, monthNumber, cal, cu, UserDefinedPeriodEnum.WEEK));
        }
        this._addnewBatchData(ctx, (IObjectCollection)coll);
    }

    @Override
    protected void _autoGenMonths(Context ctx, int yearNumber) throws BOSException, EASBizException {
        CtrlUnitInfo cu = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)yearNumber));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString()));
        if (this.exists(ctx, filter)) {
            this.isReferenced(ctx, yearNumber, null);
            this.delete(ctx, filter);
        }
        Calendar cal = Calendar.getInstance();
        UserDefinedPeriodCollection coll = new UserDefinedPeriodCollection();
        for (int i = 0; i < 12; ++i) {
            int monthNumber = i + 1;
            int dayAmtOfThisMonth = DateHelper.daysOfMonth((int)yearNumber, (int)monthNumber);
            ArrayList<Integer> dayAmtList = new ArrayList<Integer>();
            cal.set(yearNumber, monthNumber - 1, 1, 0, 0, 0);
            cal.set(14, 0);
            dayAmtList.add(dayAmtOfThisMonth);
            coll.addCollection(this.genInfoByDayAmtList(ctx, dayAmtList, yearNumber, monthNumber, cal, cu, UserDefinedPeriodEnum.MONTH));
        }
        this._addnewBatchData(ctx, (IObjectCollection)coll);
    }

    private UserDefinedPeriodCollection genInfoByDayAmtList(Context ctx, List<Integer> dayAmtList, int yearNumber, int monthNumber, Calendar cal, CtrlUnitInfo cu, UserDefinedPeriodEnum periodType) {
        UserDefinedPeriodCollection coll = new UserDefinedPeriodCollection();
        for (int i = 0; i < dayAmtList.size(); ++i) {
            if (dayAmtList.get(i) <= 0) continue;
            UserDefinedPeriodInfo info = new UserDefinedPeriodInfo();
            info.setYear(yearNumber);
            info.setMonth(monthNumber);
            if (UserDefinedPeriodEnum.WEEK.equals((Object)periodType)) {
                info.setWeekNumber(WeekNumberEnum.getEnum(dayAmtList.size()));
                info.setWeekCount(i + 1);
            }
            info.setDayNumber(dayAmtList.get(i));
            info.setStartDate(cal.getTime());
            cal.add(5, dayAmtList.get(i) - 1);
            info.setEndDate(cal.getTime());
            if (i != dayAmtList.size()) {
                cal.add(5, 1);
            }
            info.setCU(cu);
            info.setPeriodType(periodType);
            coll.add(info);
        }
        return coll;
    }

    @Override
    protected void _modifyDayNumber(Context ctx, String id, int dayNumber) throws BOSException, EASBizException {
        int dayAmtOfThisMonth;
        UserDefinedPeriodInfo info = this.getUserDefinedPeriodInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        int yearNumber = info.getYear();
        int monthNumber = info.getMonth();
        CtrlUnitInfo cu = info.getCU();
        this.isReferenced(ctx, yearNumber, cu);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)yearNumber));
        filter.getFilterItems().add(new FilterItemInfo("month", (Object)monthNumber));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("weekCount");
        sortItem.setSortType(SortType.ASCEND);
        sort.add(sortItem);
        view.setSorter(sort);
        view.setFilter(filter);
        UserDefinedPeriodCollection coll = this.getUserDefinedPeriodCollection(ctx, view);
        if (coll.size() > 5) {
            throw new PPException(PPException.DAYLIMIT);
        }
        ArrayList<Integer> dayAmtList = new ArrayList<Integer>();
        int dayLeft = dayAmtOfThisMonth = DateHelper.daysOfMonth((int)yearNumber, (int)monthNumber);
        for (int i = 0; i < coll.size(); ++i) {
            UserDefinedPeriodInfo tmpInfo = coll.get(i);
            if (tmpInfo.getWeekCount() < info.getWeekCount()) {
                dayAmtList.add(tmpInfo.getDayNumber());
                dayLeft -= tmpInfo.getDayNumber();
                continue;
            }
            if (tmpInfo.getWeekCount() == info.getWeekCount()) {
                if (dayLeft < dayNumber) {
                    throw new PPException(PPException.MODIFYDAYERROR);
                }
                dayAmtList.add(dayNumber);
                dayLeft -= dayNumber;
                continue;
            }
            if (dayLeft > tmpInfo.getDayNumber()) {
                dayAmtList.add(tmpInfo.getDayNumber());
                dayLeft -= tmpInfo.getDayNumber();
                continue;
            }
            if (dayLeft <= 0) continue;
            dayAmtList.add(dayLeft);
            dayLeft -= dayAmtOfThisMonth;
        }
        while (dayLeft > 0) {
            if (dayLeft > this.oneWeekMaxDay) {
                dayAmtList.add(this.oneWeekMaxDay);
                dayLeft -= this.oneWeekMaxDay.intValue();
                continue;
            }
            dayAmtList.add(dayLeft);
            dayLeft -= dayLeft;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(yearNumber, monthNumber - 1, 1, 0, 0, 0);
        cal.set(14, 0);
        UserDefinedPeriodCollection newColl = this.genInfoByDayAmtList(ctx, dayAmtList, yearNumber, monthNumber, cal, cu, UserDefinedPeriodEnum.WEEK);
        this.delete(ctx, filter);
        this._addnewBatchData(ctx, (IObjectCollection)newColl);
    }

    @Override
    protected void _addNewWeek(Context ctx, int dayNumber, int yearNumber, int monthNumber) throws BOSException, EASBizException {
        int dayAmtOfThisMonth;
        CtrlUnitInfo cu = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        this.isReferenced(ctx, yearNumber, cu);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)yearNumber));
        filter.getFilterItems().add(new FilterItemInfo("month", (Object)monthNumber));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("weekCount");
        sortItem.setSortType(SortType.ASCEND);
        sort.add(sortItem);
        view.setSorter(sort);
        view.setFilter(filter);
        UserDefinedPeriodCollection coll = this.getUserDefinedPeriodCollection(ctx, view);
        ArrayList<Integer> dayAmtList = new ArrayList<Integer>();
        int dayLeft = dayAmtOfThisMonth = DateHelper.daysOfMonth((int)yearNumber, (int)monthNumber);
        for (int i = 0; i < coll.size(); ++i) {
            UserDefinedPeriodInfo tmpInfo = coll.get(i);
            if (i == coll.size() - 1) {
                if (dayNumber >= tmpInfo.getDayNumber()) {
                    throw new PPException(PPException.ADDWEEKDAYERROR);
                }
                dayAmtList.add(dayNumber);
                dayAmtList.add(tmpInfo.getDayNumber() - dayNumber);
                continue;
            }
            dayAmtList.add(tmpInfo.getDayNumber());
        }
        Calendar cal = Calendar.getInstance();
        cal.set(yearNumber, monthNumber - 1, 1, 0, 0, 0);
        cal.set(14, 0);
        UserDefinedPeriodCollection newColl = this.genInfoByDayAmtList(ctx, dayAmtList, yearNumber, monthNumber, cal, cu, UserDefinedPeriodEnum.WEEK);
        this.delete(ctx, filter);
        this._addnewBatchData(ctx, (IObjectCollection)newColl);
    }

    @Override
    protected void _beforeAddNewWeek(Context ctx, int yearNumber) throws BOSException, EASBizException {
        UserDefinedPeriodCollection coll = this.getCollection(ctx, yearNumber, null);
        if (coll.size() == 0) {
            throw new PPException(PPException.NOWEEKDATA);
        }
        if (!UserDefinedPeriodEnum.WEEK.equals((Object)coll.get(0).getPeriodType())) {
            throw new PPException(PPException.MONTHNOADD);
        }
    }

    private void isReferenced(Context ctx, int yearNumber, CtrlUnitInfo cu) throws BOSException, PPException {
        UserDefinedPeriodCollection coll = this.getCollection(ctx, yearNumber, cu);
        try {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            for (String id : idSet) {
                this.isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            }
        }
        catch (Exception e) {
            throw new PPException(PPException.NOCHANGE);
        }
    }

    private UserDefinedPeriodCollection getCollection(Context ctx, int yearNumber, CtrlUnitInfo cu) throws BOSException {
        UserDefinedPeriodCollection coll = new UserDefinedPeriodCollection();
        if (cu == null || cu.getId() == null) {
            cu = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)yearNumber));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString()));
        view.setFilter(filter);
        coll = UserDefinedPeriodFactory.getLocalInstance(ctx).getUserDefinedPeriodCollection(view);
        return coll;
    }

    @Override
    protected IObjectValue _getPeriodInfoByDate(Context ctx, Date date, String cuId) throws BOSException, EASBizException {
        if (cuId == null) {
            cuId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit().getId().toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)date, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        view.setFilter(filter);
        UserDefinedPeriodCollection coll = UserDefinedPeriodFactory.getLocalInstance(ctx).getUserDefinedPeriodCollection(view);
        if (coll.size() == 0) {
            return null;
        }
        if (coll.size() == 1) {
            return coll.get(0);
        }
        throw new PPException(PPException.DOUBLE_PERIOD);
    }

    @Override
    protected IObjectValue _getNextPeriodInfoById(Context ctx, String id) throws BOSException, EASBizException {
        UserDefinedPeriodInfo info = this.getUserDefinedPeriodInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        String cuId = info.getCU().getId().toString();
        Date endDate = info.getEndDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.add(5, 1);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)cal.getTime()));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        view.setFilter(filter);
        UserDefinedPeriodCollection coll = UserDefinedPeriodFactory.getLocalInstance(ctx).getUserDefinedPeriodCollection(view);
        if (coll.size() == 0) {
            return null;
        }
        if (coll.size() == 1) {
            return coll.get(0);
        }
        throw new PPException(PPException.DOUBLE_PERIOD);
    }
}

