/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.model.MsgInfo;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.ps.PayPlanSourceSettingCollection;
import com.kingdee.eas.fm.ps.PayPlanSourceSettingFactory;
import com.kingdee.eas.fm.ps.PayPlanSourceSettingInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillFactory;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import com.kingdee.eas.fm.ps.app.AbstractAutoGenPaymentPlanBillFacadeControllerBean;
import com.kingdee.eas.fm.ps.app.service.TransPsBillBaseAdapter;
import com.kingdee.eas.fm.ps.utils.PSUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoGenPaymentPlanBillFacadeControllerBean
extends AbstractAutoGenPaymentPlanBillFacadeControllerBean {
    private static final long serialVersionUID = -2850368142208794403L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.app.AutoGenPaymentPlanBillFacadeControllerBean");
    private static final String PS_RES = "com.kingdee.eas.fm.ps.PsResource";
    private TransPsBillBaseAdapter adapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _autoGenPayPlanFromAp(Context ctx, String startDate, String endDate) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("*");
        sel.add("company.id");
        sel.add("company.name");
        sel.add("company.number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)7, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billType", (Object)"0", CompareType.EQUALS));
        view.setSelector(sel);
        view.setFilter(filter);
        PayPlanSourceSettingCollection coll = PayPlanSourceSettingFactory.getLocalInstance(ctx).getPayPlanSourceSettingCollection(view);
        PayPlanSourceSettingInfo info = null;
        Map srcDetailBillMap = null;
        Iterator it = null;
        String srcId2 = null;
        PaymentPlanBillCollection payPlanBillCol = null;
        IContextHelper ctxHelp = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean isPS001 = false;
        TransPsBillBaseAdapter adapter = this.getTransAdapter(new OtherBillInfo().getBOSType().toString());
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            logger.error((Object)("\u6267\u884c\u4ed8\u6b3e\u8ba1\u5212\u6765\u6e90\u8bbe\u7f6e\u7684\u7f16\u53f7\u4e3a\uff1a" + info.getNumber() + "\u540d\u79f0\u4e3a\uff1a" + info.getName()));
            isPS001 = ctxHelp.getBooleanParam("PS001", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
            if (!isPS001) {
                logger.error((Object)("\u516c\u53f8\uff1a" + info.getCompany().getName() + "\u7684PS001\u53c2\u6570\u542f\u7528\uff1a" + isPS001));
                continue;
            }
            srcDetailBillMap = adapter.getSrcBillHeadDetailMap(ctx, info, startDate, endDate);
            for (String srcId2 : srcDetailBillMap.keySet()) {
                try {
                    if (!PSUtils.requestMutexLock(ctx, srcId2)) continue;
                    payPlanBillCol = adapter.trans2PaymentPlanBillColl(ctx, info, srcId2, srcDetailBillMap);
                    for (int j = 0; j < payPlanBillCol.size(); ++j) {
                        this.genOnePayPlanBill(ctx, payPlanBillCol.get(j), adapter);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                finally {
                    PSUtils.releaseMutexLock(ctx, srcId2);
                }
            }
        }
    }

    private TransPsBillBaseAdapter getTransAdapter(String srcBosType) throws BOSException {
        TransPsBillBaseAdapter adapter = null;
        String adapterClassName = "";
        if (new OtherBillInfo().getBOSType().toString().equals(srcBosType)) {
            adapterClassName = "com.kingdee.eas.fm.ps.app.service.TransPsBillFromAPAdapter";
        } else if (new PayRequestBillInfo().getBOSType().toString().equals(srcBosType)) {
            adapterClassName = "com.kingdee.eas.fm.ps.app.service.TransPsBillFromAPReqAdapter";
        }
        try {
            adapter = (TransPsBillBaseAdapter)Class.forName(adapterClassName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _autoGenPayPlanFromApReq(Context ctx, String startDate, String endDate) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("*");
        sel.add("company.id");
        sel.add("company.name");
        sel.add("company.number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)7, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billType", (Object)"1", CompareType.EQUALS));
        view.setSelector(sel);
        view.setFilter(filter);
        PayPlanSourceSettingCollection coll = PayPlanSourceSettingFactory.getLocalInstance(ctx).getPayPlanSourceSettingCollection(view);
        PayPlanSourceSettingInfo info = null;
        Map srcDetailBillMap = null;
        Iterator it = null;
        String srcId2 = null;
        PaymentPlanBillCollection payPlanBillCol = null;
        IContextHelper ctxHelp = ContextHelperFactory.getLocalInstance((Context)ctx);
        TransPsBillBaseAdapter adapter = this.getTransAdapter(new PayRequestBillInfo().getBOSType().toString());
        boolean isPS001 = false;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            logger.error((Object)("\u6267\u884c\u4ed8\u6b3e\u8ba1\u5212\u6765\u6e90\u8bbe\u7f6e\u7684\u7f16\u53f7\u4e3a\uff1a" + info.getNumber() + "\u540d\u79f0\u4e3a\uff1a" + info.getName()));
            isPS001 = ctxHelp.getBooleanParam("PS001", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
            if (!isPS001) {
                logger.error((Object)("\u516c\u53f8\uff1a" + info.getCompany().getName() + "\u7684PS001\u53c2\u6570\u542f\u7528\uff1a" + isPS001));
                continue;
            }
            srcDetailBillMap = adapter.getSrcBillHeadDetailMap(ctx, info, startDate, endDate);
            for (String srcId2 : srcDetailBillMap.keySet()) {
                try {
                    if (!PSUtils.requestMutexLock(ctx, srcId2)) continue;
                    payPlanBillCol = adapter.trans2PaymentPlanBillColl(ctx, info, srcId2, srcDetailBillMap);
                    for (int j = 0; j < payPlanBillCol.size(); ++j) {
                        this.genOnePayPlanBill(ctx, payPlanBillCol.get(j), adapter);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                finally {
                    PSUtils.releaseMutexLock(ctx, srcId2);
                }
            }
        }
    }

    @Override
    protected Map _genOnePayPlanBill(Context ctx, PaymentPlanBillInfo payPlanBillInfo, TransPsBillBaseAdapter adapter) throws BOSException, EASBizException {
        IObjectPK pk = PaymentPlanBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)payPlanBillInfo);
        ArrayList<String> srcIdList = new ArrayList<String>();
        String sourceBillID = payPlanBillInfo.getSourceBillId();
        srcIdList.add(sourceBillID);
        BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)pk.toString());
        adapter.diposeSrcBill(ctx, payPlanBillInfo.getSrcBillHeadID());
        return null;
    }

    @Override
    protected Map _pullToAssBill(Context ctx, String[] ids, String mappingID, String srcBosType) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{ids.length + ""});
        List idList = CASWebUtil.ids2List((String[])ids);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>(idList.size());
        List<MsgInfo> errList = null;
        int fail = 0;
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            TransPsBillBaseAdapter adapter = this.getTransAdapter(srcBosType);
            Map<String, List<String>> idMap = adapter.getSrcBillHeadDetailMap(ctx, idList);
            String table = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityTableName(BOSObjectType.create((String)srcBosType));
            String sSQL = "Select Fid, FNumber From " + table + " Where Fid in " + AutoGenPaymentPlanBillFacadeControllerBean.Array2String(ids);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sSQL);
            while (rs.next()) {
                String srcId = rs.getString("Fid");
                Boolean isLocked = (Boolean)requestMap.get(srcId);
                String msg = null;
                if (!isLocked.booleanValue()) {
                    msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                } else if (!idMap.containsKey(srcId)) {
                    msg = FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"145_TRANS_CONDITION_LESSTHAN");
                }
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(srcId);
                msgInfo.setNumber(rs.getString("FNumber"));
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
            }
            if (msgList.size() > 0) {
                errList = this.doProcess(ctx, adapter, idMap, mappingID, msgList);
            }
            if (errList != null && errList.size() > 0) {
                block6: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block6;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"146_TRANS_PAYMENTBILL_FAILED", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"147_ALL_TRANS_PAYMENTBILL_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"148_TRANS_PAYMENTBILL_RESULT", (String[])new String[]{String.valueOf(ids.length - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    public static String Array2String(String[] array) {
        if (array == null || array.length < 1) {
            return null;
        }
        String ids = null;
        for (int i = 0; i < array.length; ++i) {
            ids = ids == null ? "('" + array[i] + "'" : ids + ", '" + array[i] + "'";
        }
        ids = ids + ")";
        return ids;
    }

    private List<MsgInfo> doProcess(Context ctx, TransPsBillBaseAdapter adapter, Map<String, List<String>> idMap, String mappingID, List<MsgInfo> infoList) {
        List<MsgInfo> errList = null;
        try {
            for (String srcId : idMap.keySet()) {
                PaymentPlanBillCollection payPlanBillCol = adapter.trans2PaymentPlanBillColl(ctx, mappingID, srcId, idMap);
                for (int j = 0; j < payPlanBillCol.size(); ++j) {
                    this.genOnePayPlanBill(ctx, payPlanBillCol.get(j), adapter);
                }
            }
        }
        catch (Exception e) {
            errList = this.setErrMsgList(ctx, errList, infoList, e.getMessage());
        }
        return errList;
    }

    private List<MsgInfo> setErrMsgList(Context ctx, List<MsgInfo> errList, List<MsgInfo> infoList, String message) {
        if (errList == null) {
            errList = new ArrayList<MsgInfo>(infoList.size());
        }
        for (int i = 0; i < infoList.size(); ++i) {
            MsgInfo info = infoList.get(i);
            MsgInfo msgInfo = new MsgInfo();
            msgInfo.setId(info.getId().toString());
            msgInfo.setNumber(info.getNumber());
            msgInfo.setMsg(message);
            errList.add(msgInfo);
        }
        return errList;
    }
}

