/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.MsgInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.ps.BillStatusEnum;
import com.kingdee.eas.fm.ps.DecomposeBillCollection;
import com.kingdee.eas.fm.ps.DecomposeBillEntryCollection;
import com.kingdee.eas.fm.ps.DecomposeBillEntryFactory;
import com.kingdee.eas.fm.ps.DecomposeBillEntryInfo;
import com.kingdee.eas.fm.ps.DecomposeBillFactory;
import com.kingdee.eas.fm.ps.DecomposeBillInfo;
import com.kingdee.eas.fm.ps.DecomposeBillStatusEnum;
import com.kingdee.eas.fm.ps.PSException;
import com.kingdee.eas.fm.ps.PayPlanSumSettleEntryCollection;
import com.kingdee.eas.fm.ps.PayPlanSumSettleEntryInfo;
import com.kingdee.eas.fm.ps.PayPlanSumaryCollection;
import com.kingdee.eas.fm.ps.PayPlanSumaryFactory;
import com.kingdee.eas.fm.ps.PayPlanSumaryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillFactory;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingInfo;
import com.kingdee.eas.fm.ps.PrioritySettingCollection;
import com.kingdee.eas.fm.ps.PrioritySettingFactory;
import com.kingdee.eas.fm.ps.PrioritySettingInfo;
import com.kingdee.eas.fm.ps.ReportTypeEnum;
import com.kingdee.eas.fm.ps.ScheduleRelationFactory;
import com.kingdee.eas.fm.ps.ScheduleRelationInfo;
import com.kingdee.eas.fm.ps.SettlementCategoryInfo;
import com.kingdee.eas.fm.ps.SummaryBillStatusEnum;
import com.kingdee.eas.fm.ps.app.AbstractDecomposeBillControllerBean;
import com.kingdee.eas.fm.ps.app.service.DecomposeBillService;
import com.kingdee.eas.fm.ps.utils.PSUtils;
import com.kingdee.eas.fm.ps.vo.DecompScheuleInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DecomposeBillControllerBean
extends AbstractDecomposeBillControllerBean {
    private static final long serialVersionUID = 2927384700774604272L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.app.DecomposeBillControllerBean");
    public static final String PS_RES = "com.kingdee.eas.fm.ps.PsResource";
    private String scheduleDimension;
    private UserInfo userInfo;
    private static final String PERM_ITEM_SUBMIT = "ps_decomposebill_04submit";
    private static final String PERM_ITEM_DELETE = "ps_decomposebill_05cancel";
    private Date currentDate = DateTimeUtils.truncateDate((Date)new Date());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _schedule(Context ctx, List idList) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idList.size() + ""});
        HashSet<String> idSet = new HashSet<String>(idList);
        DecomposeBillCollection colls = this.getDecomposeBillColls(ctx, idSet);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("decompUser.*"));
        selector.add(new SelectorItemInfo("decompDate"));
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>(idSet.size());
        List<MsgInfo> errList = null;
        int fail = 0;
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            TreeMap<String, List<DecomposeBillEntryInfo>> sIDMap = new TreeMap<String, List<DecomposeBillEntryInfo>>();
            this.userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            Boolean checkPermission = true;
            if (this.userInfo.getType().equals((Object)UserType.SYSTEM)) {
                checkPermission = false;
            }
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < colls.size(); ++i) {
                DecomposeBillInfo info = colls.get(i);
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                String msg = this.verify(ctx, isLocked, info, checkPermission);
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(info.getId().toString());
                msgInfo.setNumber(info.getNumber());
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
                if (msg != null) continue;
                for (int j = 0; j < info.getEntrys().size(); ++j) {
                    DecomposeBillEntryInfo entry = info.getEntrys().get(j);
                    entry.setAvailable(true);
                    String sID = entry.getSummary().getId().toString();
                    ArrayList<DecomposeBillEntryInfo> lst = (ArrayList<DecomposeBillEntryInfo>)sIDMap.get(sID);
                    if (lst == null) {
                        lst = new ArrayList<DecomposeBillEntryInfo>();
                    }
                    lst.add(entry);
                    sIDMap.put(sID, lst);
                }
                info.setBillStatus(DecomposeBillStatusEnum.SCHEDULED);
                info.setDecompUser(this.userInfo);
                info.setDecompDate(this.currentDate);
                coll.add((CoreBaseInfo)info);
            }
            if (sIDMap.size() > 0) {
                errList = this.doProcess(ctx, sIDMap, coll);
            }
            if (errList != null && errList.size() > 0) {
                block5: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block5;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"063_SCHEDULE_FAILED", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"064_ALL_SCHEDULE_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"065_SCHEDULE_RESULT", (String[])new String[]{String.valueOf(idSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private DecomposeBillCollection getDecomposeBillColls(Context ctx, Set<String> idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.parent.id"));
        sic.add(new SelectorItemInfo("entrys.summary.id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return this.getDecomposeBillCollection(ctx, view);
    }

    private String verify(Context ctx, boolean isLocked, DecomposeBillInfo info, Boolean checkPermission) throws EASBizException, BOSException {
        String msg = null;
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ps_decomposebill_06schedule");
        if (checkPermission.booleanValue() && !isPermission) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"061_NO_SCHEDULE_AUTHRIZED");
        } else if (!isLocked) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
        } else if (info.getBillStatus() != DecomposeBillStatusEnum.SUBMIT) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"062_BILL_CANNOT_SCHEDULE");
        } else if (this.currentDate.compareTo(info.getDecompStartDate()) < 0 || this.currentDate.compareTo(info.getDecompEndDate()) > 0) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"116_DECOMPDATE_RANGE_OVER");
        }
        return msg;
    }

    private List<MsgInfo> doProcess(Context ctx, Map<String, List<DecomposeBillEntryInfo>> sIDMap, CoreBaseCollection coll) throws EASBizException, BOSException {
        List<MsgInfo> errList = null;
        HashMap<String, PrioritySettingCollection> scheduleMap = new HashMap<String, PrioritySettingCollection>();
        HashMap<String, List> settleCateMap = new HashMap<String, List>();
        try {
            for (String sID : sIDMap.keySet()) {
                PayPlanSumaryInfo summaryInfo = PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryInfo((IObjectPK)new ObjectUuidPK(sID));
                if (summaryInfo.getCU() == null) {
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{"CU"});
                }
                String cuId = summaryInfo.getCU().getId().toString();
                PrioritySettingCollection scheduleSettingColl = null;
                if (scheduleMap.containsKey(cuId)) {
                    scheduleSettingColl = (PrioritySettingCollection)((Object)scheduleMap.get(cuId));
                } else {
                    scheduleSettingColl = this.getScheduleSettingColl(ctx, cuId);
                    if (scheduleSettingColl != null) {
                        scheduleMap.put(cuId, scheduleSettingColl);
                    } else {
                        throw new PSException(PSException.CU_NO_SCHEDULE_SETTING);
                    }
                }
                List settleCateList = null;
                if (settleCateMap.containsKey(cuId)) {
                    settleCateList = (List)settleCateMap.get(cuId);
                } else {
                    settleCateList = PSUtils.getSettleCategoryList(ctx, cuId);
                    if (settleCateList != null) {
                        settleCateMap.put(cuId, settleCateList);
                    }
                }
                List<DecomposeBillEntryInfo> entryList = sIDMap.get(sID);
                String inClause = PSUtils.idListToInClause(this.getDecompEntryIdList(entryList));
                List<DecompScheuleInfo> issueList = this.getIssueList(ctx, settleCateList, inClause);
                PaymentPlanBillCollection detailColl = this.getDetailColl(ctx, sID, scheduleSettingColl);
                this.doSchedule(ctx, summaryInfo.getLimitStartDate(), summaryInfo.getLimitExpiredDate(), issueList, detailColl);
            }
            this.updateBatchData(ctx, coll);
        }
        catch (Exception e) {
            errList = this.setErrMsgList(ctx, errList, coll, e.getMessage());
        }
        return errList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSchedule(Context ctx, Date limitStartDate, Date limitExpiredDate, List<DecompScheuleInfo> issueList, PaymentPlanBillCollection detailColl) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List idList = CASWebUtil.collectionId2List((AbstractBaseObjectCollection)detailColl);
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            List<PaymentPlanBillInfo> detailList = this.decomposeAmt(issueList, detailColl, requestMap);
            this.dispose(ctx, detailList, limitStartDate, limitExpiredDate);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
    }

    private void dispose(Context ctx, List<PaymentPlanBillInfo> detailList, Date limitStartDate, Date limitExpiredDate) throws EASBizException, BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        for (PaymentPlanBillInfo info : detailList) {
            info.setScheduleDate(this.currentDate);
            info.setSchdlPayDate(limitStartDate);
            info.setSchdlExpiredDate(limitExpiredDate);
            BigDecimal schdlAmt = BigDecimal.ZERO;
            for (int i = 0; i < info.getEntries().size(); ++i) {
                PaymentPlanBillEntryInfo entry = info.getEntries().get(i);
                schdlAmt = schdlAmt.add(entry.getScheduleAmt());
            }
            info.setScheduleAmount(schdlAmt);
            info.setBillStatus(info.getApplyPayAmount().compareTo(schdlAmt) != 0 ? BillStatusEnum.SCHEDULING : BillStatusEnum.SCHEDULED);
            coll.add((CoreBaseInfo)info);
        }
        PaymentPlanBillFactory.getLocalInstance(ctx).updateBatchData(coll);
    }

    private List<PaymentPlanBillInfo> decomposeAmt(List<DecompScheuleInfo> issueList, PaymentPlanBillCollection detailColl, Map requestMap) throws EASBizException {
        ArrayList<PaymentPlanBillInfo> detailList = new ArrayList<PaymentPlanBillInfo>();
        for (int i = 0; i < detailColl.size(); ++i) {
            BigDecimal applyAmt;
            PaymentPlanBillInfo detail = detailColl.get(i);
            Boolean isLocked = (Boolean)requestMap.get(detail.getId().toString());
            if (!isLocked.booleanValue()) {
                logger.error((Object)("PaymentPlanBill is Locked! id = " + detail.getId().toString()));
                throw new PSException(PSException.PAYMENTPLANBILL_ISLOCKED, new String[]{detail.getNumber()});
            }
            BigDecimal schdlAmt = detail.getScheduleAmount() != null ? detail.getScheduleAmount() : BigDecimal.ZERO;
            int entryInitSize = 0;
            boolean isSchdled = false;
            if (schdlAmt.compareTo(BigDecimal.ZERO) > 0) {
                entryInitSize = detail.getEntries().size();
                boolean bl = isSchdled = detail.getScheduleAmount().compareTo(BigDecimal.ZERO) > 0 && detail.getApprovedAmt().compareTo(BigDecimal.ZERO) == 0 && detail.getPayAmount().compareTo(BigDecimal.ZERO) == 0;
            }
            if ((applyAmt = detail.getApplyPayAmount().subtract(schdlAmt)).compareTo(BigDecimal.ZERO) <= 0) continue;
            int seqNo = entryInitSize;
            for (DecompScheuleInfo issueInfo : issueList) {
                PaymentPlanBillEntryInfo entry;
                BigDecimal currentIssueAmt;
                if (!issueInfo.isAvalilable() || (currentIssueAmt = issueInfo.getCurrentIssueAmt().subtract(issueInfo.getActAmt())).compareTo(BigDecimal.ZERO) <= 0) continue;
                if (currentIssueAmt.compareTo(applyAmt) < 0) {
                    schdlAmt = currentIssueAmt;
                    issueInfo.setActAmt(currentIssueAmt);
                    entry = null;
                    if (isSchdled) {
                        entry = this.buildEntryInfo(detail.getEntries(), issueInfo, schdlAmt);
                    }
                    if (entry == null) {
                        entry = this.buildEntryInfo(issueInfo, schdlAmt, ++seqNo);
                        detail.getEntries().add(entry);
                    }
                    applyAmt = applyAmt.subtract(currentIssueAmt);
                    issueInfo.setAvalilable(false);
                    continue;
                }
                schdlAmt = applyAmt;
                issueInfo.setActAmt(issueInfo.getActAmt().add(applyAmt));
                entry = null;
                if (isSchdled) {
                    entry = this.buildEntryInfo(detail.getEntries(), issueInfo, schdlAmt);
                }
                if (entry != null) break;
                entry = this.buildEntryInfo(issueInfo, schdlAmt, ++seqNo);
                detail.getEntries().add(entry);
                break;
            }
            if (!isSchdled && detail.getEntries().size() <= entryInitSize) continue;
            detailList.add(detail);
        }
        return detailList;
    }

    private PaymentPlanBillEntryInfo buildEntryInfo(PaymentPlanBillEntryCollection entries, DecompScheuleInfo issueInfo, BigDecimal schdlAmt) {
        PaymentPlanBillEntryInfo info = null;
        for (int i = 0; i < entries.size(); ++i) {
            PaymentPlanBillEntryInfo entry = entries.get(i);
            boolean isSame = false;
            if (issueInfo.getSettleCateID() == null && entry.getSettleCate() == null) {
                isSame = true;
            }
            if (issueInfo.getSettleCateID() != null && entry.getSettleCate() != null) {
                isSame = issueInfo.getSettleCateID().equals(entry.getSettleCate().getId().toString());
            }
            if (issueInfo.getSettleTypeID() == null && entry.getSettleType() == null) {
                boolean bl = isSame = isSame;
            }
            if (issueInfo.getSettleTypeID() != null && entry.getSettleType() != null) {
                boolean bl = isSame = isSame && issueInfo.getSettleTypeID().equals(entry.getSettleType().getId().toString());
            }
            if (issueInfo.getAccountBankID() == null && entry.getPayerAccBank() == null) {
                boolean bl = isSame = isSame;
            }
            if (issueInfo.getAccountBankID() != null && entry.getPayerAccBank() != null) {
                boolean bl = isSame = isSame && issueInfo.getAccountBankID().equals(entry.getPayerAccBank().getId().toString());
            }
            if (!isSame) continue;
            entry.setScheduleAmt(entry.getScheduleAmt().add(schdlAmt));
            info = entry;
        }
        return info;
    }

    private PaymentPlanBillEntryInfo buildEntryInfo(DecompScheuleInfo issueInfo, BigDecimal schdlAmt, int seqNo) {
        PaymentPlanBillEntryInfo entry = new PaymentPlanBillEntryInfo();
        entry.setSeq(seqNo);
        if (issueInfo.getSettleCateID() != null) {
            SettlementCategoryInfo sc = new SettlementCategoryInfo();
            sc.setId(BOSUuid.read((String)issueInfo.getSettleCateID()));
            entry.setSettleCate(sc);
        }
        entry.setScheduleAmt(schdlAmt != null ? schdlAmt : issueInfo.getCurrentIssueAmt());
        if (issueInfo.getSettleTypeID() != null) {
            SettlementTypeInfo st = new SettlementTypeInfo();
            st.setId(BOSUuid.read((String)issueInfo.getSettleTypeID()));
            entry.setSettleType(st);
        }
        if (issueInfo.getAccountBankID() != null) {
            AccountBankInfo ab = new AccountBankInfo();
            ab.setId(BOSUuid.read((String)issueInfo.getAccountBankID()));
            entry.setPayerAccBank(ab);
        }
        return entry;
    }

    private List<DecompScheuleInfo> getIssueList(Context ctx, List<SettlementCategoryInfo> settleCateList, String inClause) throws BOSException, EASBizException {
        ArrayList<DecompScheuleInfo> issueList = new ArrayList<DecompScheuleInfo>();
        StringBuffer sql = new StringBuffer();
        if (settleCateList == null) {
            sql.append(" SELECT FSummaryID, null AS FSettleCateID, sum(FCurrentIssueAmt) AS FCurrentIssueAmt, FSettleTypeID,FPayerAccountBankID AS FPayerAccBankID ");
            sql.append(" FROM T_PS_DecomposeBillEntry ");
            sql.append(" WHERE FID  IN (" + inClause + ")");
            sql.append(" GROUP BY FSummaryID, FSettleTypeID, FPayerAccountBankID ");
        } else {
            int size = settleCateList.size();
            sql.append(" SELECT FSummaryID, FSettleCateID1 AS FSettleCateID, sum(FCurrentIssueAmt1) AS FCurrentIssueAmt, FSettleTypeID1 AS FSettleTypeID, FPayerAccBankID1 AS FPayerAccBankID ");
            sql.append(" FROM T_PS_DecomposeBillEntry ");
            sql.append(" WHERE FID  IN (" + inClause + ")");
            sql.append(" GROUP BY FSummaryID, FSettleCateID1, FSettleTypeID1, FPayerAccBankID1 ");
            if (size == 2) {
                sql.append(" UNION ALL ");
                sql.append(" SELECT FSummaryID, FSettleCateID2 AS FSettleCateID, sum(FCurrentIssueAmt2) AS FCurrentIssueAmt, FSettleTypeID2 AS FSettleTypeID, FPayerAccBankID2 AS FPayerAccBankID ");
                sql.append(" FROM T_PS_DecomposeBillEntry ");
                sql.append(" WHERE FID  IN (" + inClause + ")");
                sql.append(" GROUP BY FSummaryID, FSettleCateID2, FSettleTypeID2, FPayerAccBankID2 ");
            }
            if (size == 3) {
                sql.append(" UNION ALL ");
                sql.append(" SELECT FSummaryID, FSettleCateID2 AS FSettleCateID, sum(FCurrentIssueAmt2) AS FCurrentIssueAmt, FSettleTypeID2 AS FSettleTypeID, FPayerAccBankID2 AS FPayerAccBankID ");
                sql.append(" FROM T_PS_DecomposeBillEntry ");
                sql.append(" WHERE FID  IN (" + inClause + ")");
                sql.append(" GROUP BY FSummaryID, FSettleCateID2, FSettleTypeID2, FPayerAccBankID2 ");
                sql.append(" UNION ALL ");
                sql.append(" SELECT FSummaryID, FSettleCateID3 AS FSettleCateID, sum(FCurrentIssueAmt3) AS FCurrentIssueAmt, FSettleTypeID3 AS FSettleTypeID, FPayerAccBankID3 AS FPayerAccBankID ");
                sql.append(" FROM T_PS_DecomposeBillEntry ");
                sql.append(" WHERE FID  IN (" + inClause + ")");
                sql.append(" GROUP BY FSummaryID, FSettleCateID3, FSettleTypeID3, FPayerAccBankID3 ");
            }
        }
        logger.debug((Object)("sql:" + sql.toString()));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                BigDecimal currentIssueAmt = rs.getBigDecimal("FCurrentIssueAmt");
                if (currentIssueAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                DecompScheuleInfo scheuleInfo = new DecompScheuleInfo();
                scheuleInfo.setSummaryID(rs.getString("FSummaryID"));
                scheuleInfo.setSettleCateID(rs.getString("FSettleCateID"));
                scheuleInfo.setCurrentIssueAmt(currentIssueAmt);
                scheuleInfo.setSettleTypeID(rs.getString("FSettleTypeID"));
                scheuleInfo.setAccountBankID(rs.getString("FPayerAccBankID"));
                issueList.add(scheuleInfo);
            }
        }
        catch (SQLException e) {
            throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return issueList;
    }

    private List<String> getDecompEntryIdList(List<DecomposeBillEntryInfo> entryList) {
        ArrayList<String> list = new ArrayList<String>(entryList.size());
        for (int i = 0; i < entryList.size(); ++i) {
            DecomposeBillEntryInfo info = entryList.get(i);
            list.add(info.getId().toString());
        }
        return list;
    }

    private PaymentPlanBillCollection getDetailColl(Context ctx, String sID, PrioritySettingCollection scheduleSettingColl) throws BOSException {
        PaymentPlanBillCollection detailColl = null;
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)scheduleSettingColl)) {
            PaymentPlanBillCollection notInColl;
            List<String> idList = this.getSettingIdList(scheduleSettingColl);
            detailColl = new PaymentPlanBillCollection();
            HashSet<String> idSet = new HashSet<String>(idList);
            PaymentPlanBillCollection inColl = this.getPaymentPlanColl4Rule(ctx, sID, idSet, true);
            if (inColl != null && inColl.size() > 0) {
                detailColl.addCollection(this.getSortColl(inColl, idList));
            }
            if ((notInColl = this.getPaymentPlanColl4Rule(ctx, sID, idSet, false)) != null && notInColl.size() > 0) {
                detailColl.addCollection(notInColl);
            }
        } else {
            detailColl = this.getPaymentPlanColl(ctx, sID);
        }
        return detailColl;
    }

    private PaymentPlanBillCollection getSortColl(PaymentPlanBillCollection inColl, List<String> idList) {
        PaymentPlanBillCollection sortColl = new PaymentPlanBillCollection();
        TreeMap<String, PaymentPlanBillCollection> dimMap = new TreeMap<String, PaymentPlanBillCollection>();
        for (int i = 0; i < inColl.size(); ++i) {
            PaymentPlanBillInfo info = inColl.get(i);
            String key = null;
            if (this.scheduleDimension.equals("department")) {
                key = info.getDepartment().getId().toString();
            } else if (this.scheduleDimension.equals("asstActID")) {
                key = info.getAsstActID();
            } else if (this.scheduleDimension.equals("fundProperty")) {
                key = info.getFundProperty().getId().toString();
            } else if (this.scheduleDimension.equals("fundFlowItem")) {
                key = info.getFundFlowItem().getId().toString();
            }
            PaymentPlanBillCollection lst = (PaymentPlanBillCollection)((Object)dimMap.get(key));
            if (lst == null) {
                lst = new PaymentPlanBillCollection();
            }
            lst.add(info);
            dimMap.put(key, lst);
        }
        for (String dimID : idList) {
            for (String k : dimMap.keySet()) {
                PaymentPlanBillCollection coll = (PaymentPlanBillCollection)((Object)dimMap.get(k));
                if (!dimID.equals(k)) continue;
                sortColl.addCollection(coll);
            }
        }
        return sortColl;
    }

    private List<MsgInfo> setErrMsgList(Context ctx, List<MsgInfo> errList, CoreBaseCollection coll, String message) {
        if (errList == null) {
            errList = new ArrayList<MsgInfo>(coll.size());
        }
        for (int i = 0; i < coll.size(); ++i) {
            CoreBaseInfo info = coll.get(i);
            MsgInfo msgInfo = new MsgInfo();
            msgInfo.setId(info.getId().toString());
            msgInfo.setNumber(info.getString("number"));
            msgInfo.setMsg(message);
            errList.add(msgInfo);
        }
        return errList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSchedule(Context ctx, Date limitStartDate, Date limitExpiredDate, BigDecimal issueAmt, List<DecomposeBillEntryInfo> infoList, PaymentPlanBillCollection detailColl) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List idList = CASWebUtil.collectionId2List((AbstractBaseObjectCollection)detailColl);
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            this.doSaveRelation(ctx, detailColl, infoList, requestMap);
            List<PaymentPlanBillInfo> detailList = this.decomposeAmt(issueAmt, detailColl, limitStartDate, limitExpiredDate);
            this.dispose(ctx, detailList);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
    }

    private PaymentPlanBillCollection getPaymentPlanColl(Context ctx, String sID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("planSumary.id", (Object)sID));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)6, CompareType.NOTEQUALS));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        if (EmptyUtil.isEmpty((String)this.scheduleDimension)) {
            sort.add(new SorterItemInfo("payableDate"));
        }
        view.setSorter(sort);
        return PaymentPlanBillFactory.getLocalInstance(ctx).getPaymentPlanBillCollection(view);
    }

    private PaymentPlanBillCollection getPaymentPlanColl4Rule(Context ctx, String sID, Set<String> idSet, boolean include) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("planSumary.id", (Object)sID));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)6, CompareType.NOTEQUALS));
        String schdlDimension = null;
        schdlDimension = this.scheduleDimension.equals("asstActID") ? this.scheduleDimension : this.scheduleDimension + ".id";
        if (include) {
            filter.getFilterItems().add(new FilterItemInfo(schdlDimension, idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(schdlDimension + " IS NULL "));
            filter.getFilterItems().add(new FilterItemInfo(schdlDimension, idSet, CompareType.NOTINCLUDE));
            filter.setMaskString("#0 and #1 and (#2 or #3)");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return PaymentPlanBillFactory.getLocalInstance(ctx).getPaymentPlanBillCollection(view);
    }

    private List<String> getSettingIdList(PrioritySettingCollection scheduleSettingColl) {
        ArrayList<String> lst = new ArrayList<String>();
        for (int i = 0; i < scheduleSettingColl.size(); ++i) {
            PrioritySettingInfo info = scheduleSettingColl.get(i);
            if (lst.contains(info.getItemId())) continue;
            lst.add(info.getItemId());
        }
        return lst;
    }

    private List<PaymentPlanBillInfo> decomposeAmt(BigDecimal issueAmt, PaymentPlanBillCollection detailColl, Date limitStartDate, Date limitExpiredDate) {
        BigDecimal decompAmt = issueAmt;
        ArrayList<PaymentPlanBillInfo> detailList = new ArrayList<PaymentPlanBillInfo>();
        for (int i = 0; i < detailColl.size(); ++i) {
            PaymentPlanBillInfo detail = detailColl.get(i);
            detail.setScheduleDate(this.currentDate);
            detail.setSchdlPayDate(limitStartDate);
            detail.setSchdlExpiredDate(limitExpiredDate);
            BigDecimal schdlAmt = detail.getScheduleAmount() != null ? detail.getScheduleAmount() : BigDecimal.ZERO;
            BigDecimal applyAmt = detail.getApplyPayAmount().subtract(schdlAmt);
            if (applyAmt.compareTo(decompAmt) >= 0) {
                detail.setBillStatus(applyAmt.compareTo(decompAmt) != 0 ? BillStatusEnum.SCHEDULING : BillStatusEnum.SCHEDULED);
                detail.setScheduleAmount(schdlAmt.add(decompAmt));
                detailList.add(detail);
                break;
            }
            if (applyAmt.compareTo(decompAmt) >= 0) {
                detail.setBillStatus(BillStatusEnum.SCHEDULING);
                detail.setScheduleAmount(schdlAmt.add(decompAmt));
                detailList.add(detail);
                break;
            }
            detail.setBillStatus(BillStatusEnum.SCHEDULED);
            detail.setScheduleAmount(schdlAmt.add(applyAmt));
            detailList.add(detail);
            decompAmt = decompAmt.subtract(applyAmt);
        }
        return detailList;
    }

    private void dispose(Context ctx, List<PaymentPlanBillInfo> detailList) throws EASBizException, BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        for (PaymentPlanBillInfo info : detailList) {
            coll.add((CoreBaseInfo)info);
        }
        PaymentPlanBillFactory.getLocalInstance(ctx).updateBatchData(coll);
    }

    private void doSaveRelation(Context ctx, PaymentPlanBillCollection detailColl, List<DecomposeBillEntryInfo> infoList, Map requestMap) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.userInfo)) {
            this.userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        }
        String userID = this.userInfo.getId().toString();
        block0: for (int i = 0; i < detailColl.size(); ++i) {
            PaymentPlanBillInfo detail = detailColl.get(i);
            Boolean isLocked = (Boolean)requestMap.get(detail.getId().toString());
            if (!isLocked.booleanValue()) {
                logger.error((Object)("PaymentPlanBill is Locked! id = " + detail.getId().toString()));
                throw new PSException(PSException.PAYMENTPLANBILL_ISLOCKED, new String[]{detail.getNumber()});
            }
            BigDecimal schdlAmt = detail.getScheduleAmount() != null ? detail.getScheduleAmount() : BigDecimal.ZERO;
            BigDecimal applyAmt = detail.getApplyPayAmount().subtract(schdlAmt);
            for (DecomposeBillEntryInfo entry : infoList) {
                BigDecimal currentIssueAmt;
                if (!entry.isAvailable() || (currentIssueAmt = entry.getCurrentIssueAmt().subtract(entry.getActAmt())).compareTo(BigDecimal.ZERO) <= 0) continue;
                if (currentIssueAmt.compareTo(applyAmt) < 0) {
                    schdlAmt = currentIssueAmt;
                    entry.setActAmt(currentIssueAmt);
                    this.saveRelation(ctx, detail, entry, schdlAmt, userID);
                    applyAmt = applyAmt.subtract(currentIssueAmt);
                    entry.setAvailable(false);
                    continue;
                }
                schdlAmt = applyAmt;
                entry.setActAmt(applyAmt);
                this.saveRelation(ctx, detail, entry, schdlAmt, userID);
                continue block0;
            }
        }
    }

    private void saveRelation(Context ctx, PaymentPlanBillInfo detail, DecomposeBillEntryInfo entry, BigDecimal schdlAmt, String userID) throws BOSException {
        ScheduleRelationInfo relation = new ScheduleRelationInfo();
        relation.setBizDate(this.currentDate);
        relation.setCreatorID(userID);
        relation.setCreateTime(new Timestamp(System.currentTimeMillis()));
        relation.setDetailID(detail.getId().toString());
        relation.setApplyPayAmt(detail.getApplyPayAmount());
        relation.setScheduleAmt(schdlAmt != null ? schdlAmt : entry.getCurrentIssueAmt());
        relation.setDecompEntryID(entry.getId().toString());
        relation.setCurrentIssueAmt(entry.getCurrentIssueAmt());
        relation.setActAmt(entry.getActAmt());
        StringBuffer sb = new StringBuffer();
        sb.append(detail.getNumber()).append("\t");
        sb.append(detail.getApplyPayAmount().toString()).append("\t");
        sb.append(schdlAmt != null ? schdlAmt.toString() : entry.getCurrentIssueAmt().toString()).append("\t");
        sb.append(entry.getSumNumber()).append("\t");
        sb.append(entry.getCurrentIssueAmt().toString()).append("\t");
        sb.append(entry.getActAmt().toString()).append("\t");
        logger.info((Object)("saveRelation == " + sb.toString() + "\n"));
        ScheduleRelationFactory.getLocalInstance(ctx).addnew(relation);
    }

    private PrioritySettingCollection getScheduleSettingColl(Context ctx, String cuId) throws BOSException, EASBizException {
        PrioritySettingCollection coll = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT setting.FDimensionID AS schdlDimensionID, dim.FPayPlanColumnName, schdl.FDimensionID ");
        sql.append(" FROM T_PS_PaymentScheduleSetting setting ");
        sql.append(" LEFT JOIN T_PS_DIMENSION dim ");
        sql.append(" ON dim.FID = setting.FDimensionID ");
        sql.append(" LEFT JOIN T_PS_SummaryDimensionSetting schdl ");
        sql.append(" ON schdl.FPaymentScheduleSettingID = setting.FID ");
        sql.append(" WHERE setting.FControlUnitID = '" + cuId + "'");
        sql.append(" AND schdl.FIsGrounpSummary = 0 ");
        logger.debug((Object)("sql:" + sql.toString()));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rs != null && rs.size() > 0) {
                String scheduleID = null;
                while (rs.next()) {
                    String dimensionID = rs.getString("schdlDimensionID");
                    if (dimensionID.equals("9Updm/V1TPiN3jWhBrLQbtL/X/A=")) {
                        coll = new PrioritySettingCollection();
                        break;
                    }
                    this.scheduleDimension = rs.getString("FPayPlanColumnName");
                    if (!dimensionID.equals(rs.getString("FDimensionID"))) continue;
                    scheduleID = rs.getString("FDimensionID");
                    break;
                }
                if (scheduleID != null) {
                    coll = this.getPriorityInfoList(ctx, scheduleID);
                }
            } else {
                StringBuffer oql = new StringBuffer();
                oql.append(" SELECT setting.FDimensionID AS schdlDimensionID ");
                oql.append(" FROM T_PS_PaymentScheduleSetting setting ");
                oql.append(" WHERE setting.FControlUnitID = '" + cuId + "'");
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])new Object[0]);
                if (rs1 != null && rs1.next()) {
                    String dimensionID = rs1.getString("schdlDimensionID");
                    if (dimensionID.equals("9Updm/V1TPiN3jWhBrLQbtL/X/A=")) {
                        coll = new PrioritySettingCollection();
                    }
                } else {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("parent.id"));
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
                    if (company != null && company.getParent() != null) {
                        this.getScheduleSettingColl(ctx, company.getParent().getId().toString());
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return coll;
    }

    private PrioritySettingCollection getPriorityInfoList(Context ctx, String scheduleID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("summaryDimension.id", (Object)scheduleID));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("priority"));
        view.setSorter(sort);
        return PrioritySettingFactory.getLocalInstance(ctx).getPrioritySettingCollection(view);
    }

    private List<MsgInfo> setErrMsgList(Context ctx, List<MsgInfo> errList, List<DecomposeBillEntryInfo> validList, String message) throws EASBizException, BOSException {
        if (errList == null) {
            errList = new ArrayList<MsgInfo>();
        }
        HashSet idSet = new HashSet();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        for (DecomposeBillEntryInfo info : validList) {
            DecomposeBillEntryInfo entry = null;
            String id = null;
            String number = null;
            if (info.getParent() != null) {
                id = info.getParent().getId().toString();
                number = info.getParent().getNumber();
            } else {
                entry = DecomposeBillEntryFactory.getLocalInstance(ctx).getDecomposeBillEntryInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
                id = entry.getParent().getId().toString();
                number = entry.getParent().getNumber();
            }
            if (idSet.contains(id)) continue;
            MsgInfo msgInfo = new MsgInfo();
            msgInfo.setId(id);
            msgInfo.setNumber(number);
            msgInfo.setMsg(message);
            errList.add(msgInfo);
        }
        return errList;
    }

    @Override
    protected Map _genPaymentBill(Context ctx, List idList) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _saveDecomposeBill(Context ctx, DecomposeBillInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        CoreBaseCollection payPlanSumColls = new CoreBaseCollection();
        boolean isLock = PSUtils.requestMutexLock(ctx, info.getId().toString());
        try {
            if (!isLock) {
                throw new PSException(PSException.BILL_IS_MUTEXED);
            }
            if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
                throw new PSException(PSException.BILL_NOT_EXISTS);
            }
            DecomposeBillInfo dbInfo = this.getDecomposeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            if (dbInfo.getBillStatus() != DecomposeBillStatusEnum.SUBMIT) {
                throw new BOSException(PSUtils.getResource(ctx, "083_BILL_NOT_SUBMIT", null));
            }
            dbInfo.setDecompStartDate(info.getDecompStartDate());
            dbInfo.setDecompEndDate(info.getDecompEndDate());
            DecomposeBillEntryCollection billEntrys = dbInfo.getEntrys();
            DecomposeBillEntryCollection paramBillEntys = info.getEntrys();
            BigDecimal sumCurentIssueAmtDiff = BigDecimal.ZERO;
            for (int i = 0; i < paramBillEntys.size(); ++i) {
                DecomposeBillEntryInfo paramBillEntryInfo = paramBillEntys.get(0);
                DecomposeBillEntryInfo dbBillEntryInfo = this.findDecomposeBillEntryInfo(billEntrys, paramBillEntryInfo.getId().toString());
                if (paramBillEntryInfo.getCurrentIssueAmt().compareTo(dbBillEntryInfo.getCurrentIssueAmt()) == 0) continue;
                BigDecimal diff = paramBillEntryInfo.getCurrentIssueAmt().subtract(dbBillEntryInfo.getCurrentIssueAmt());
                dbBillEntryInfo.setCurrentIssueAmt(paramBillEntryInfo.getCurrentIssueAmt());
                dbBillEntryInfo.setNotIssuedAmt(dbBillEntryInfo.getNotIssuedAmt().subtract(diff));
                dbBillEntryInfo.setIssuedAmt(dbBillEntryInfo.getIssuedAmt().add(diff));
                PayPlanSumaryInfo dbSumInfo = PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryInfo((IObjectPK)new ObjectUuidPK(dbBillEntryInfo.getSummary().getId()));
                dbSumInfo.setNotIssuedAmt(dbSumInfo.getNotIssuedAmt().subtract(diff));
                dbSumInfo.setIssuedAmt(dbSumInfo.getIssuedAmt().add(diff));
                payPlanSumColls.add((CoreBaseInfo)dbSumInfo);
                sumCurentIssueAmtDiff = sumCurentIssueAmtDiff.add(diff);
            }
            dbInfo.setCurrentIssueAmt(dbInfo.getCurrentIssueAmt().add(sumCurentIssueAmtDiff));
            dbInfo.setNotIssuedAmt(dbInfo.getNotIssuedAmt().subtract(sumCurentIssueAmtDiff));
            this.save(ctx, (CoreBaseInfo)dbInfo);
            PayPlanSumaryFactory.getLocalInstance(ctx).updateBatchData(payPlanSumColls);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "071_EXCEPTION", null) + e.getMessage());
        }
        finally {
            PSUtils.releaseMutexLock(ctx, info.getId().toString());
        }
        if (result.getSummaryMsg() == null) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "069_SUCCESS", null));
        }
        return result;
    }

    @Override
    protected Map _submitDecomposeBill(Context ctx, DecomposeBillInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = info.getId() == null ? this.doProcessAddNewDecomposeBill(ctx, info) : this.doProcessModifyDecompseBill(ctx, info);
        String successMsg = PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "069_SUCCESS", null);
        if (successMsg.equals(result.getSummaryMsg())) {
            String companyId = info.getCompany().getId().toString();
            Boolean PS005 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS005", (IObjectPK)new ObjectUuidPK(companyId));
            if (PS005.booleanValue()) {
                ArrayList<String> idList = new ArrayList<String>();
                idList.add((String)result.get((Object)"billId"));
                ScheduleThread scheduleThread = new ScheduleThread(ctx, idList);
                scheduleThread.run();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchExecuteResult doProcessModifyDecompseBill(Context ctx, DecomposeBillInfo info) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        ArrayList<String> sumaryIdList = null;
        ArrayList<String> decomposeList = null;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            this.verifyDecompseDate(ctx, info);
            CoreBaseCollection payPlanSumColls = new CoreBaseCollection();
            boolean isLock = iMutex.requestObjIDForUpdate(info.getId().toString());
            DecomposeBillInfo dbInfo = this.getDecomposeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            this.verifyBeforeSubmit(ctx, dbInfo, isLock);
            DecomposeBillEntryCollection billEntrys = dbInfo.getEntrys();
            DecomposeBillEntryCollection paramBillEntys = info.getEntrys();
            Set<String> sumarySet = this.getSumaryIdListByDecomEntry(billEntrys);
            sumaryIdList = new ArrayList<String>(sumarySet);
            Map requestMap = iMutex.batchRequestBizObjIDForUpdate(sumaryIdList);
            dbInfo.setDecompStartDate(info.getDecompStartDate());
            dbInfo.setDecompEndDate(info.getDecompEndDate());
            HashMap<String, PayPlanSumaryInfo> sumaryMap = new HashMap<String, PayPlanSumaryInfo>();
            BigDecimal sumCurentIssueAmtDiff = BigDecimal.ZERO;
            for (int i = 0; i < paramBillEntys.size(); ++i) {
                DecomposeBillEntryInfo paramBillEntryInfo = paramBillEntys.get(0);
                DecomposeBillEntryInfo dbBillEntryInfo = this.findDecomposeBillEntryInfo(billEntrys, paramBillEntryInfo.getId().toString());
                BigDecimal diff = paramBillEntryInfo.getCurrentIssueAmt().subtract(dbBillEntryInfo.getCurrentIssueAmt());
                dbBillEntryInfo.setNotIssuedAmt(dbBillEntryInfo.getNotIssuedAmt().subtract(diff));
                dbBillEntryInfo.setIssuedAmt(dbBillEntryInfo.getIssuedAmt().add(diff));
                dbBillEntryInfo.setSettlementType(paramBillEntryInfo.getSettlementType());
                dbBillEntryInfo.setSettleType1(paramBillEntryInfo.getSettleType1());
                dbBillEntryInfo.setSettleType2(paramBillEntryInfo.getSettleType2());
                dbBillEntryInfo.setSettleType3(paramBillEntryInfo.getSettleType3());
                dbBillEntryInfo.setPayerAccountBank(paramBillEntryInfo.getPayerAccountBank());
                dbBillEntryInfo.setPayerAccBank1(paramBillEntryInfo.getPayerAccBank1());
                dbBillEntryInfo.setPayerAccBank2(paramBillEntryInfo.getPayerAccBank2());
                dbBillEntryInfo.setPayerAccBank3(paramBillEntryInfo.getPayerAccBank3());
                Boolean isLockedSum = (Boolean)requestMap.get(dbBillEntryInfo.getSummary().getId().toString());
                if (!isLockedSum.booleanValue()) {
                    throw new PSException(PSException.BILL_IS_MUTEXED);
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("settleEntries.*"));
                sic.add(new SelectorItemInfo("settleEntries.settleCategory.name"));
                PayPlanSumaryInfo dbSumInfo = PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryInfo((IObjectPK)new ObjectUuidPK(dbBillEntryInfo.getSummary().getId()), sic);
                if (dbSumInfo.getNotIssuedAmt().compareTo(diff) < 0) {
                    throw new BOSException(PSUtils.getResource(ctx, "084_GREATER_AMT", new String[]{dbSumInfo.getNumber(), String.valueOf(dbSumInfo.getNotIssuedAmt())}));
                }
                dbSumInfo.setNotIssuedAmt(dbSumInfo.getNotIssuedAmt().subtract(diff));
                dbSumInfo.setIssuedAmt(dbSumInfo.getIssuedAmt().add(diff));
                dbSumInfo.setSettlementType(paramBillEntryInfo.getSettlementType());
                dbSumInfo.setPayerAccountBank(paramBillEntryInfo.getPayerAccountBank());
                PayPlanSumSettleEntryCollection settleEntryColls = dbSumInfo.getSettleEntries();
                if (settleEntryColls != null && settleEntryColls.size() > 0) {
                    BigDecimal settleDiff = null;
                    block11: for (int m = 0; m < settleEntryColls.size(); ++m) {
                        PayPlanSumSettleEntryInfo settleEntryInfo = settleEntryColls.get(m);
                        switch (m + 1) {
                            case 1: {
                                settleEntryInfo.setSettleType(paramBillEntryInfo.getSettleType1());
                                settleEntryInfo.setPayerAccountBank(paramBillEntryInfo.getPayerAccBank1());
                                settleDiff = paramBillEntryInfo.getCurrentIssueAmt1().subtract(dbBillEntryInfo.getCurrentIssueAmt1());
                                if (settleEntryInfo.getNotIssuedAmt().compareTo(settleDiff) < 0) {
                                    String exMsg = PSUtils.getResource(ctx, "122_SRCSUM_CATE_CUR_GREATER", new String[]{paramBillEntryInfo.getSumNumber(), settleEntryInfo.getSettleCategory().getName()});
                                    throw new BOSException(exMsg);
                                }
                                settleEntryInfo.setNotIssuedAmt(settleEntryInfo.getNotIssuedAmt().subtract(settleDiff));
                                dbSumInfo.setNotIssuedAmt1(settleEntryInfo.getNotIssuedAmt());
                                dbBillEntryInfo.setNotIssueAmt1(settleEntryInfo.getNotIssuedAmt());
                                continue block11;
                            }
                            case 2: {
                                settleEntryInfo.setSettleType(paramBillEntryInfo.getSettleType2());
                                settleEntryInfo.setPayerAccountBank(paramBillEntryInfo.getPayerAccBank2());
                                settleDiff = paramBillEntryInfo.getCurrentIssueAmt2().subtract(dbBillEntryInfo.getCurrentIssueAmt2());
                                if (settleEntryInfo.getNotIssuedAmt().compareTo(settleDiff) < 0) {
                                    String exMsg = PSUtils.getResource(ctx, "122_SRCSUM_CATE_CUR_GREATER", new String[]{paramBillEntryInfo.getSumNumber(), settleEntryInfo.getSettleCategory().getName()});
                                    throw new BOSException(exMsg);
                                }
                                settleEntryInfo.setNotIssuedAmt(settleEntryInfo.getNotIssuedAmt().subtract(settleDiff));
                                dbSumInfo.setNotIssuedAmt2(settleEntryInfo.getNotIssuedAmt());
                                dbBillEntryInfo.setNotIssueAmt2(settleEntryInfo.getNotIssuedAmt());
                                continue block11;
                            }
                            case 3: {
                                settleEntryInfo.setSettleType(paramBillEntryInfo.getSettleType3());
                                settleEntryInfo.setPayerAccountBank(paramBillEntryInfo.getPayerAccBank3());
                                settleDiff = paramBillEntryInfo.getCurrentIssueAmt3().subtract(dbBillEntryInfo.getCurrentIssueAmt3());
                                if (settleEntryInfo.getNotIssuedAmt().compareTo(settleDiff) < 0) {
                                    String exMsg = PSUtils.getResource(ctx, "122_SRCSUM_CATE_CUR_GREATER", new String[]{paramBillEntryInfo.getSumNumber(), settleEntryInfo.getSettleCategory().getName()});
                                    throw new BOSException(exMsg);
                                }
                                settleEntryInfo.setNotIssuedAmt(settleEntryInfo.getNotIssuedAmt().subtract(settleDiff));
                                dbSumInfo.setNotIssuedAmt3(settleEntryInfo.getNotIssuedAmt());
                                dbBillEntryInfo.setNotIssueAmt3(settleEntryInfo.getNotIssuedAmt());
                            }
                        }
                    }
                }
                dbBillEntryInfo.setCurrentIssueAmt(paramBillEntryInfo.getCurrentIssueAmt());
                dbBillEntryInfo.setCurrentIssueAmt1(paramBillEntryInfo.getCurrentIssueAmt1());
                dbBillEntryInfo.setCurrentIssueAmt2(paramBillEntryInfo.getCurrentIssueAmt2());
                dbBillEntryInfo.setCurrentIssueAmt3(paramBillEntryInfo.getCurrentIssueAmt3());
                int compare = dbSumInfo.getApprovedAmt().compareTo(dbSumInfo.getNotIssuedAmt());
                if (compare == 0) {
                    dbSumInfo.setBillStatus(SummaryBillStatusEnum.APPROVED);
                } else {
                    dbSumInfo.setBillStatus(SummaryBillStatusEnum.DECOMPOSING);
                }
                payPlanSumColls.add((CoreBaseInfo)dbSumInfo);
                sumCurentIssueAmtDiff = sumCurentIssueAmtDiff.add(diff);
                sumaryMap.put(dbSumInfo.getId().toString(), dbSumInfo);
            }
            Set<String> sumaryIdSet = sumaryMap.keySet();
            Set<String> decomposeSet = DecomposeBillService.getDecomposeBillIdSet(ctx, sumaryIdSet);
            decomposeSet.remove(dbInfo.getId().toString());
            DecomposeBillCollection decomposeColls = null;
            if (decomposeSet.size() > 0) {
                decomposeList = new ArrayList<String>(decomposeSet);
                Map decompseMap = iMutex.batchRequestBizObjIDForUpdate(decomposeList);
                decomposeColls = DecomposeBillService.updateDecomposeBySumaryInfo(ctx, sumaryMap, decomposeSet, decompseMap);
            }
            dbInfo.setCurrentIssueAmt(dbInfo.getCurrentIssueAmt().add(sumCurentIssueAmtDiff));
            dbInfo.setNotIssuedAmt(dbInfo.getNotIssuedAmt().subtract(sumCurentIssueAmtDiff));
            dbInfo.setBillStatus(DecomposeBillStatusEnum.SUBMIT);
            this.save(ctx, (CoreBaseInfo)dbInfo);
            if (decomposeSet.size() > 0) {
                CoreBaseCollection coreColls = new CoreBaseCollection();
                if (decomposeColls != null && decomposeColls.size() > 0) {
                    for (int i = 0; i < decomposeColls.size(); ++i) {
                        coreColls.add((CoreBaseInfo)decomposeColls.get(i));
                    }
                }
                DecomposeBillFactory.getLocalInstance(ctx).updateBatchData(coreColls);
            }
            PayPlanSumaryFactory.getLocalInstance(ctx).updateBatchData(payPlanSumColls);
            result.put((Object)"billId", (Object)dbInfo.getId().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "070_FAIL", null) + e.getMessage());
        }
        finally {
            if (sumaryIdList != null) {
                iMutex.batchReleaseObjIDForUpdate(sumaryIdList);
            }
            if (decomposeList != null) {
                iMutex.batchReleaseObjIDForUpdate(decomposeList);
            }
            iMutex.releaseObjIDForUpdate(info.getId().toString());
        }
        if (result.getSummaryMsg() == null) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "069_SUCCESS", null));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchExecuteResult doProcessAddNewDecomposeBill(Context ctx, DecomposeBillInfo paremInfo) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        result.setError(-1);
        ArrayList<String> sumaryIdList = null;
        ArrayList<String> decomposeList = null;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            PaymentScheduleSettingInfo payScheduleInfo;
            PayPlanSumaryCollection colls;
            Map requestMap;
            DecomposeBillEntryCollection paramBillEntys;
            block30: {
                this.verifyDecompseDate(ctx, paremInfo);
                paramBillEntys = paremInfo.getEntrys();
                Set<String> sumIdSet = this.getSumaryIdListByDecomEntry(paramBillEntys);
                sumaryIdList = new ArrayList<String>(sumIdSet);
                requestMap = iMutex.batchRequestBizObjIDForUpdate(sumaryIdList);
                colls = this.getSumaryColls(ctx, sumaryIdList);
                CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                payScheduleInfo = null;
                try {
                    payScheduleInfo = PSUtils.getPaymentScheduleInfo(ctx, cu.getId().toString());
                }
                catch (BOSException e) {
                    if (!e.getMessage().equals(PSUtils.getResource(ctx, "136_NO_SCHEDULE", null)) || EmptyUtil.isEmpty((CoreBaseInfo)paremInfo.getCU()) || cu.getId().toString().equals(paremInfo.getCU().getId().toString())) break block30;
                    payScheduleInfo = PSUtils.getPaymentScheduleInfo(ctx, paremInfo.getCU().getId().toString());
                }
            }
            int periodType = payScheduleInfo.getPeriodType().getValue();
            String period = null;
            String periodEntry = null;
            for (int i = 0; i < colls.size(); ++i) {
                PayPlanSumaryInfo sumInfo = colls.get(i);
                this.verify4Decompose(ctx, sumInfo, requestMap, result);
                PayPlanSumaryInfo dbSumInfo = colls.get(i);
                if (dbSumInfo.getPeriod() == null && period == null) {
                    String exMsg = PSUtils.getResource(ctx, "119_SUM_PERIOD_NULL", new String[]{dbSumInfo.getNumber()});
                    throw new BOSException(exMsg);
                }
                if (i == 0) {
                    period = dbSumInfo.getPeriod();
                    periodEntry = dbSumInfo.getPeriodEntry();
                    continue;
                }
                this.verifyPeriod(ctx, period, periodEntry, periodType, dbSumInfo);
            }
            if (result.getDetailMsgList().size() == 0) {
                int i;
                HashMap<String, PayPlanSumaryInfo> sumaryMap = new HashMap<String, PayPlanSumaryInfo>();
                DecomposeBillInfo info = new DecomposeBillInfo();
                info.setBillStatus(DecomposeBillStatusEnum.SUBMIT);
                info.setDecompUser(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setDecompDate(DateUtil.getDayBegin());
                if (!EmptyUtil.isEmpty((CoreBaseInfo)paremInfo.getCU())) {
                    info.setCU(paremInfo.getCU());
                }
                info.setDecompStartDate(paremInfo.getDecompStartDate());
                info.setDecompEndDate(paremInfo.getDecompEndDate());
                info.setPeriod(period);
                info.setPeriodEntry(periodEntry);
                BigDecimal sumNotIssuedAmt = Constants.ZERO;
                BigDecimal sumCurrentIssueAmt = Constants.ZERO;
                BigDecimal sumApplyPayAmt = Constants.ZERO;
                BigDecimal sumApprovedAmt = Constants.ZERO;
                for (int i2 = 0; i2 < colls.size(); ++i2) {
                    PayPlanSumaryInfo payPlanSumInfo = colls.get(i2);
                    if (info.getCompany() == null) {
                        info.setCompany(payPlanSumInfo.getCompany());
                    }
                    DecomposeBillEntryInfo paramBillEnty = this.findDecomposeBillEntryInfoBySumId(paramBillEntys, payPlanSumInfo.getId().toString());
                    this.verifySumNotIssueAmt(ctx, payPlanSumInfo, paramBillEnty);
                    this.setDecomposeAmt(payPlanSumInfo, paramBillEnty);
                    DecomposeBillEntryInfo entryInfo = new DecomposeBillEntryInfo();
                    entryInfo.setSumNumber(payPlanSumInfo.getNumber());
                    entryInfo.setReportType(payPlanSumInfo.getReportType());
                    entryInfo.setDepartment(payPlanSumInfo.getDepartment());
                    entryInfo.setAsstActType(payPlanSumInfo.getAsstActType());
                    entryInfo.setAsstActID(payPlanSumInfo.getAsstActID());
                    entryInfo.setAsstActName(payPlanSumInfo.getAsstActName());
                    entryInfo.setAsstActNumber(payPlanSumInfo.getAsstActNumber());
                    entryInfo.setFundFlowItem(payPlanSumInfo.getFundFlowItem());
                    entryInfo.setFundProperty(payPlanSumInfo.getFundProperty());
                    entryInfo.setCurrency(payPlanSumInfo.getCurrency());
                    entryInfo.setApplyPayAmt(payPlanSumInfo.getApplyPayAmt());
                    entryInfo.setApprovedAmt(payPlanSumInfo.getApprovedAmt());
                    entryInfo.setNotIssuedAmt(payPlanSumInfo.getNotIssuedAmt());
                    entryInfo.setIssuedAmt(payPlanSumInfo.getIssuedAmt());
                    entryInfo.setCurrentIssueAmt(payPlanSumInfo.getCurrentIssuedAmt());
                    entryInfo.setLimitStartDate(payPlanSumInfo.getLimitStartDate());
                    entryInfo.setLimitExpiredDate(payPlanSumInfo.getLimitExpiredDate());
                    entryInfo.setSummary(payPlanSumInfo);
                    entryInfo.setSettleCate1(payPlanSumInfo.getSettleCate1());
                    entryInfo.setSettleCate2(payPlanSumInfo.getSettleCate2());
                    entryInfo.setSettleCate3(payPlanSumInfo.getSettleCate3());
                    entryInfo.setApproveAmt1(payPlanSumInfo.getApproveAmt1());
                    entryInfo.setApproveAmt2(payPlanSumInfo.getApproveAmt2());
                    entryInfo.setApproveAmt3(payPlanSumInfo.getApproveAmt3());
                    entryInfo.setSettlementType(paramBillEnty.getSettlementType());
                    entryInfo.setSettleType1(paramBillEnty.getSettleType1());
                    entryInfo.setSettleType2(paramBillEnty.getSettleType2());
                    entryInfo.setSettleType3(paramBillEnty.getSettleType3());
                    entryInfo.setPayerAccBank1(paramBillEnty.getPayerAccBank1());
                    entryInfo.setPayerAccBank2(paramBillEnty.getPayerAccBank2());
                    entryInfo.setPayerAccBank3(paramBillEnty.getPayerAccBank3());
                    entryInfo.setPayerAccountBank(paramBillEnty.getPayerAccountBank());
                    for (int m = 0; m < payPlanSumInfo.getSettleEntries().size(); ++m) {
                        PayPlanSumSettleEntryInfo entry = payPlanSumInfo.getSettleEntries().get(m);
                        String categoryId = entry.getSettleCategory().getId().toString();
                        if (entryInfo.getSettleCate1() != null && categoryId.equals(entryInfo.getSettleCate1().getId().toString())) {
                            entryInfo.setNotIssueAmt1(payPlanSumInfo.getNotIssuedAmt1());
                            entryInfo.setCurrentIssueAmt1(payPlanSumInfo.getCurrentIssuedAmt1());
                        }
                        if (entryInfo.getSettleCate2() != null && categoryId.equals(entryInfo.getSettleCate2().getId().toString())) {
                            entryInfo.setNotIssueAmt2(payPlanSumInfo.getNotIssuedAmt2());
                            entryInfo.setCurrentIssueAmt2(payPlanSumInfo.getCurrentIssuedAmt2());
                        }
                        if (entryInfo.getSettleCate3() == null || !categoryId.equals(entryInfo.getSettleCate3().getId().toString())) continue;
                        entryInfo.setNotIssueAmt3(payPlanSumInfo.getNotIssuedAmt3());
                        entryInfo.setCurrentIssueAmt3(payPlanSumInfo.getCurrentIssuedAmt3());
                    }
                    info.getEntrys().add(entryInfo);
                    sumNotIssuedAmt = sumNotIssuedAmt.add(payPlanSumInfo.getNotIssuedAmt());
                    sumCurrentIssueAmt = sumCurrentIssueAmt.add(payPlanSumInfo.getCurrentIssuedAmt());
                    sumApplyPayAmt = sumApplyPayAmt.add(payPlanSumInfo.getApplyPayAmt());
                    sumApprovedAmt = sumApprovedAmt.add(payPlanSumInfo.getApprovedAmt());
                    if (payPlanSumInfo.getNotIssuedAmt().compareTo(BigDecimal.ZERO) > 0) {
                        payPlanSumInfo.setBillStatus(SummaryBillStatusEnum.DECOMPOSING);
                    } else {
                        payPlanSumInfo.setBillStatus(SummaryBillStatusEnum.DECOMPOSED);
                    }
                    sumaryMap.put(payPlanSumInfo.getId().toString(), payPlanSumInfo);
                }
                info.setNotIssuedAmt(sumNotIssuedAmt);
                info.setCurrentIssueAmt(sumCurrentIssueAmt);
                info.setApplyPayAmt(sumApplyPayAmt);
                info.setApprovedAmt(sumApprovedAmt);
                info.setCurrency(info.getEntrys().get(0).getCurrency());
                String number = PSUtils.initNumber(ctx, info, info.getCompany().getId().toString());
                info.setNumber(number);
                Set<String> sumaryIdSet = sumaryMap.keySet();
                Set<String> decomposeSet = DecomposeBillService.getDecomposeBillIdSet(ctx, sumaryIdSet);
                DecomposeBillCollection decomposeColls = null;
                if (decomposeSet.size() > 0) {
                    decomposeList = new ArrayList<String>(decomposeSet);
                    Map decompseMap = iMutex.batchRequestBizObjIDForUpdate(decomposeList);
                    decomposeColls = DecomposeBillService.updateDecomposeBySumaryInfo(ctx, sumaryMap, decomposeSet, decompseMap);
                }
                IObjectPK id = DecomposeBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                result.put((Object)"billId", (Object)id.toString());
                CoreBaseCollection coreColls = new CoreBaseCollection();
                for (i = 0; i < colls.size(); ++i) {
                    coreColls.add((CoreBaseInfo)colls.get(i));
                }
                PayPlanSumaryFactory.getLocalInstance(ctx).update(coreColls);
                if (decomposeSet.size() > 0) {
                    coreColls.clear();
                    if (decomposeColls != null && decomposeColls.size() > 0) {
                        for (i = 0; i < decomposeColls.size(); ++i) {
                            coreColls.add((CoreBaseInfo)decomposeColls.get(i));
                        }
                    }
                    DecomposeBillFactory.getLocalInstance(ctx).updateBatchData(coreColls);
                }
                for (i = 0; i < colls.size(); ++i) {
                    PayPlanSumaryInfo sumInfo = colls.get(i);
                    this.reversePlanSumaryStatus(ctx, sumInfo.getId().toString(), sumInfo.getBillStatus());
                }
                BOTPUtil.saveBOTRelation((Context)ctx, sumaryIdList, (String)id.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "070_FAIL", null) + e.getMessage());
            result.setError(1);
        }
        finally {
            if (decomposeList != null) {
                iMutex.batchReleaseObjIDForUpdate(decomposeList);
            }
            if (sumaryIdList != null) {
                iMutex.batchReleaseObjIDForUpdate(sumaryIdList);
            }
        }
        if (result.getSummaryMsg() == null && result.getDetailMsgList().size() == 0) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "069_SUCCESS", null));
        } else if (result.getSummaryMsg() == null) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "070_FAIL", null));
            result.setError(1);
        }
        return result;
    }

    private void verifySumNotIssueAmt(Context ctx, PayPlanSumaryInfo payPlanSumInfo, DecomposeBillEntryInfo paramBillEnty) throws BOSException {
        BigDecimal totalCurAmt = paramBillEnty.getCurrentIssueAmt();
        if (totalCurAmt.compareTo(BigDecimal.ZERO) < 1) {
            String exMsg = PSUtils.getResource(ctx, "123_CURAMT_MUST_GREATER_ZEO", new String[]{payPlanSumInfo.getNumber()});
            throw new BOSException(exMsg);
        }
        if (payPlanSumInfo.getNotIssuedAmt().compareTo(totalCurAmt) < 0) {
            throw new BOSException(PSUtils.getResource(ctx, "084_GREATER_AMT", new String[]{payPlanSumInfo.getNumber(), String.valueOf(payPlanSumInfo.getNotIssuedAmt())}));
        }
        PayPlanSumSettleEntryCollection settleEntryColls = payPlanSumInfo.getSettleEntries();
        if (settleEntryColls != null && settleEntryColls.size() > 0) {
            for (int m = 0; m < settleEntryColls.size(); ++m) {
                String settleCateId;
                PayPlanSumSettleEntryInfo settleEntryInfo = settleEntryColls.get(m);
                if (paramBillEnty.getSettleCate1() != null && (settleCateId = paramBillEnty.getSettleCate1().getId().toString()).equals(settleEntryInfo.getSettleCategory().getId().toString()) && settleEntryInfo.getNotIssuedAmt().compareTo(paramBillEnty.getCurrentIssueAmt1()) < 0) {
                    String exMsg = PSUtils.getResource(ctx, "122_SRCSUM_CATE_CUR_GREATER", new String[]{payPlanSumInfo.getNumber(), settleEntryInfo.getSettleCategory().getName()});
                    throw new BOSException(exMsg);
                }
                if (paramBillEnty.getSettleCate2() != null && (settleCateId = paramBillEnty.getSettleCate2().getId().toString()).equals(settleEntryInfo.getSettleCategory().getId().toString()) && settleEntryInfo.getNotIssuedAmt().compareTo(paramBillEnty.getCurrentIssueAmt2()) < 0) {
                    String exMsg = PSUtils.getResource(ctx, "122_SRCSUM_CATE_CUR_GREATER", new String[]{payPlanSumInfo.getNumber(), settleEntryInfo.getSettleCategory().getName()});
                    throw new BOSException(exMsg);
                }
                if (paramBillEnty.getSettleCate3() == null || !(settleCateId = paramBillEnty.getSettleCate3().getId().toString()).equals(settleEntryInfo.getSettleCategory().getId().toString()) || settleEntryInfo.getNotIssuedAmt().compareTo(paramBillEnty.getCurrentIssueAmt3()) >= 0) continue;
                String exMsg = PSUtils.getResource(ctx, "122_SRCSUM_CATE_CUR_GREATER", new String[]{payPlanSumInfo.getNumber(), settleEntryInfo.getSettleCategory().getName()});
                throw new BOSException(exMsg);
            }
        }
    }

    private void verifyPeriod(Context ctx, String period, String periodEntry, int periodType, PayPlanSumaryInfo sumInfo) throws BOSException {
        boolean rs = true;
        if (!period.equals(sumInfo.getPeriod())) {
            rs = false;
        } else if (periodType == 0 && rs && !periodEntry.equals(sumInfo.getPeriodEntry())) {
            rs = false;
        }
        if (!rs) {
            throw new BOSException(PSUtils.getResource(ctx, "124_SUM_NOT_SAMEPERIOD", null));
        }
    }

    private void verify4Decompose(Context ctx, PayPlanSumaryInfo sumInfo, Map requestMap, BatchExecuteResult result) {
        try {
            String id = sumInfo.getId().toString();
            Boolean isLocked = (Boolean)requestMap.get(id);
            if (!isLocked.booleanValue()) {
                throw new PSException(PSException.BILL_IS_MUTEXED);
            }
            if (sumInfo.getReportType() == ReportTypeEnum.EMERGENCY) {
                throw new BOSException(PSUtils.getResource(ctx, "125_EMER_SUM_NOT_DECOM", null));
            }
            if (sumInfo.getBillStatus() != SummaryBillStatusEnum.APPROVED && sumInfo.getBillStatus() != SummaryBillStatusEnum.DECOMPOSING) {
                throw new BOSException(PSUtils.getResource(ctx, "072_BILL_DECOMPOSE", null));
            }
            if (sumInfo.getNotIssuedAmt().compareTo(Constants.ZERO) == -1) {
                throw new BOSException(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null));
            }
        }
        catch (Exception e) {
            result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"058_BILL_DECOMPOSE_FAIL", (String[])new String[]{sumInfo.getNumber(), e.getMessage()}));
        }
    }

    private PayPlanSumaryInfo getPayPlanSumaryInfoById(Context ctx, String id) throws EASBizException, BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        sel.add(new SelectorItemInfo("settleEntries.*"));
        sel.add(new SelectorItemInfo("settleEntries.settleCategory"));
        entityViewInfo.setSelector(sel);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        return PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryInfo((IObjectPK)new ObjectUuidPK(id), sel);
    }

    private PayPlanSumaryInfo setDecomposeAmt(PayPlanSumaryInfo info, DecomposeBillEntryInfo entryInfo) {
        BigDecimal totalCurrentIssueAmt = BigDecimal.ZERO;
        if (entryInfo.getCurrentIssueAmt1() != null) {
            info.setNotIssuedAmt1(info.getNotIssuedAmt1().subtract(entryInfo.getCurrentIssueAmt1()));
            info.setCurrentIssuedAmt1(entryInfo.getCurrentIssueAmt1());
            totalCurrentIssueAmt = totalCurrentIssueAmt.add(entryInfo.getCurrentIssueAmt1());
        }
        if (entryInfo.getCurrentIssueAmt2() != null) {
            info.setNotIssuedAmt2(info.getNotIssuedAmt2().subtract(entryInfo.getCurrentIssueAmt2()));
            info.setCurrentIssuedAmt2(entryInfo.getCurrentIssueAmt2());
            totalCurrentIssueAmt = totalCurrentIssueAmt.add(entryInfo.getCurrentIssueAmt2());
        }
        if (entryInfo.getCurrentIssueAmt3() != null) {
            info.setNotIssuedAmt3(info.getNotIssuedAmt3().subtract(entryInfo.getCurrentIssueAmt3()));
            info.setCurrentIssuedAmt3(entryInfo.getCurrentIssueAmt3());
            totalCurrentIssueAmt = totalCurrentIssueAmt.add(entryInfo.getCurrentIssueAmt3());
        }
        if (entryInfo.getCurrentIssueAmt() != null) {
            info.setNotIssuedAmt(info.getNotIssuedAmt().subtract(entryInfo.getCurrentIssueAmt()));
            info.setIssuedAmt(info.getApprovedAmt().subtract(info.getNotIssuedAmt()));
            info.setCurrentIssuedAmt(entryInfo.getCurrentIssueAmt());
        }
        for (int i = 0; i < info.getSettleEntries().size(); ++i) {
            String entryCateId;
            PayPlanSumSettleEntryInfo entry = info.getSettleEntries().get(i);
            String categoryId = entry.getSettleCategory().getId().toString();
            if (entryInfo.getSettleCate1() != null && categoryId.equals(entryCateId = entryInfo.getSettleCate1().getId().toString())) {
                entry.setNotIssuedAmt(entry.getNotIssuedAmt().subtract(entryInfo.getCurrentIssueAmt1()));
                entry.setCurrentIssuedAmt(entryInfo.getCurrentIssueAmt1());
            }
            if (entryInfo.getSettleCate2() != null && categoryId.equals(entryCateId = entryInfo.getSettleCate2().getId().toString())) {
                entry.setNotIssuedAmt(entry.getNotIssuedAmt().subtract(entryInfo.getCurrentIssueAmt2()));
                entry.setCurrentIssuedAmt(entryInfo.getCurrentIssueAmt2());
            }
            if (entryInfo.getSettleCate3() == null || !categoryId.equals(entryCateId = entryInfo.getSettleCate3().getId().toString())) continue;
            entry.setNotIssuedAmt(entry.getNotIssuedAmt().subtract(entryInfo.getCurrentIssueAmt3()));
            entry.setCurrentIssuedAmt(entryInfo.getCurrentIssueAmt3());
        }
        return info;
    }

    private DecomposeBillEntryInfo findDecomposeBillEntryInfo(DecomposeBillEntryCollection billEntrys, String id) {
        DecomposeBillEntryInfo info = null;
        for (int m = 0; m < billEntrys.size(); ++m) {
            DecomposeBillEntryInfo tempInfo = billEntrys.get(m);
            if (!tempInfo.getId().toString().equals(id)) continue;
            return tempInfo;
        }
        return info;
    }

    private DecomposeBillEntryInfo findDecomposeBillEntryInfoBySumId(DecomposeBillEntryCollection billEntrys, String id) {
        DecomposeBillEntryInfo info = null;
        for (int m = 0; m < billEntrys.size(); ++m) {
            info = billEntrys.get(m);
            if (info.getSummary() == null || !info.getSummary().getId().toString().equals(id)) continue;
            return info;
        }
        return info;
    }

    private void verifyBeforeSubmit(Context ctx, DecomposeBillInfo info, boolean isLock) throws BOSException, EASBizException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_SUBMIT);
        if (!isPermission) {
            throw new PSException(PSException.NO_SUBMIT_AUTH);
        }
        if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            throw new PSException(PSException.BILL_NOT_EXISTS);
        }
        if (!isLock) {
            throw new PSException(PSException.BILL_IS_MUTEXED);
        }
        if (info.getBillStatus() != DecomposeBillStatusEnum.SUBMIT) {
            throw new BOSException(PSUtils.getResource(ctx, "083_BILL_NOT_SUBMIT", null));
        }
    }

    private Set<String> getSumaryIdListByDecomEntry(DecomposeBillEntryCollection decomposeBillEntys) {
        HashSet<String> sumIdSet = new HashSet<String>();
        for (int i = 0; i < decomposeBillEntys.size(); ++i) {
            DecomposeBillEntryInfo entryInfo = decomposeBillEntys.get(i);
            sumIdSet.add(entryInfo.getSummary().getId().toString());
        }
        return sumIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _deleteBatch(Context ctx, List idList) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = PSUtils.getResource(ctx, "008_BILL_SUM", new String[]{idList.size() + ""});
        int success = 0;
        Object payPlanColls = null;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        try {
            DecomposeBillCollection decomposeBillColls = this.getDecomposeBillCollectionByIdList(ctx, idList);
            for (int i = 0; i < decomposeBillColls.size(); ++i) {
                DecomposeBillInfo info = decomposeBillColls.get(i);
                ArrayList<String> sumaryIdList = null;
                ArrayList<String> decomposeList = null;
                try {
                    Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                    this.verifyBeforeDelete(ctx, info, result, isLocked);
                    DecomposeBillEntryCollection decomposeEntrys = info.getEntrys();
                    Set<String> sumSet = this.getSumaryIdListByDecomEntry(decomposeEntrys);
                    sumaryIdList = new ArrayList<String>(sumSet);
                    Map sumaryMutexMap = iMutex.batchRequestBizObjIDForUpdate(sumaryIdList);
                    CoreBaseCollection sumCoreColls = new CoreBaseCollection();
                    PayPlanSumaryCollection sumColls = this.getPayPlanSumCollsByDecompseBill(ctx, decomposeEntrys);
                    for (int m = 0; m < decomposeEntrys.size(); ++m) {
                        DecomposeBillEntryInfo decomposeBillEntry = decomposeEntrys.get(m);
                        PayPlanSumaryInfo sumaryInfo = this.getPayPlanSumaryInfo(sumColls, decomposeBillEntry.getSummary().getId().toString());
                        Boolean isLockedSum = (Boolean)sumaryMutexMap.get(sumaryInfo.getId().toString());
                        if (!isLockedSum.booleanValue()) {
                            throw new PSException(PSException.BILL_IS_MUTEXED);
                        }
                        sumaryInfo.setNotIssuedAmt(sumaryInfo.getNotIssuedAmt().add(decomposeBillEntry.getCurrentIssueAmt()));
                        sumaryInfo.setIssuedAmt(sumaryInfo.getIssuedAmt().subtract(decomposeBillEntry.getCurrentIssueAmt()));
                        int compare = sumaryInfo.getApprovedAmt().compareTo(sumaryInfo.getNotIssuedAmt());
                        if (compare == 0) {
                            sumaryInfo.setBillStatus(SummaryBillStatusEnum.APPROVED);
                        } else {
                            sumaryInfo.setBillStatus(SummaryBillStatusEnum.DECOMPOSING);
                        }
                        PayPlanSumSettleEntryCollection settleColls = sumaryInfo.getSettleEntries();
                        if (settleColls != null && settleColls.size() > 0) {
                            block17: for (int n = 0; n < settleColls.size(); ++n) {
                                PayPlanSumSettleEntryInfo settleEntryInfo = settleColls.get(n);
                                switch (n + 1) {
                                    case 1: {
                                        settleEntryInfo.setNotIssuedAmt(settleEntryInfo.getNotIssuedAmt().add(decomposeBillEntry.getCurrentIssueAmt1()));
                                        sumaryInfo.setNotIssuedAmt1(settleEntryInfo.getNotIssuedAmt());
                                        continue block17;
                                    }
                                    case 2: {
                                        settleEntryInfo.setNotIssuedAmt(settleEntryInfo.getNotIssuedAmt().add(decomposeBillEntry.getCurrentIssueAmt2()));
                                        sumaryInfo.setNotIssuedAmt2(settleEntryInfo.getNotIssuedAmt());
                                        continue block17;
                                    }
                                    case 3: {
                                        settleEntryInfo.setNotIssuedAmt(settleEntryInfo.getNotIssuedAmt().add(decomposeBillEntry.getCurrentIssueAmt3()));
                                        sumaryInfo.setNotIssuedAmt3(settleEntryInfo.getNotIssuedAmt());
                                    }
                                }
                            }
                        }
                        sumCoreColls.add((CoreBaseInfo)sumaryInfo);
                    }
                    HashMap<String, PayPlanSumaryInfo> sumaryMap = new HashMap<String, PayPlanSumaryInfo>();
                    for (int s = 0; s < sumColls.size(); ++s) {
                        PayPlanSumaryInfo sumInfo = sumColls.get(s);
                        sumaryMap.put(sumInfo.getId().toString(), sumInfo);
                    }
                    Set<String> sumaryIdSet = sumaryMap.keySet();
                    Set<String> decomposeSet = DecomposeBillService.getDecomposeBillIdSet(ctx, sumaryIdSet);
                    DecomposeBillCollection decomposeColls = null;
                    if (decomposeSet.size() > 0) {
                        for (Object id : idList) {
                            decomposeSet.remove(id);
                        }
                        decomposeList = new ArrayList<String>(decomposeSet);
                        Map decompseMap = iMutex.batchRequestBizObjIDForUpdate(decomposeList);
                        decompseMap.putAll(requestMap);
                        decomposeColls = DecomposeBillService.updateDecomposeBySumaryInfo(ctx, sumaryMap, decomposeSet, decompseMap);
                    }
                    PayPlanSumaryFactory.getLocalInstance(ctx).saveBatchData(sumCoreColls);
                    if (decomposeSet.size() > 0) {
                        CoreBaseCollection coreColls = new CoreBaseCollection();
                        if (decomposeColls != null && decomposeColls.size() > 0) {
                            for (int t = 0; t < decomposeColls.size(); ++t) {
                                coreColls.add((CoreBaseInfo)decomposeColls.get(t));
                            }
                        }
                        DecomposeBillFactory.getLocalInstance(ctx).updateBatchData(coreColls);
                    }
                    for (int n = 0; n < sumCoreColls.size(); ++n) {
                        PayPlanSumaryInfo sumaryInfo = (PayPlanSumaryInfo)sumCoreColls.get(n);
                        this.reversePlanSumaryStatus(ctx, sumaryInfo.getId().toString(), sumaryInfo.getBillStatus());
                    }
                    DecomposeBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PSUtils.getResource(ctx, "009_BILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                    continue;
                }
                finally {
                    if (sumaryIdList != null) {
                        iMutex.batchReleaseObjIDForUpdate(sumaryIdList);
                    }
                    if (decomposeList != null) {
                        iMutex.batchReleaseObjIDForUpdate(decomposeList);
                    }
                }
            }
        }
        catch (Exception e) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "087_DECOMPOSE_DELETE", null) + PSUtils.getResource(ctx, "071_EXCEPTION", null) + e.getMessage());
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (success == idList.size()) {
            summary = PSUtils.getResource(ctx, "088_DECOMPOSE_BILL", null) + PSUtils.getResource(ctx, "086_ALL_DELETE_SUCC", null);
            result.setSummaryMsg(summary);
        } else if (result.getSummaryMsg() == null) {
            summary = summary + PSUtils.getResource(ctx, "013_DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void verifyBeforeDelete(Context ctx, DecomposeBillInfo info, BatchExecuteResult result, Boolean isLocked) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_DELETE);
        if (!isPermission) {
            throw new PSException(PSException.NO_DELETE_AUTHRIZED);
        }
        if (!isLocked.booleanValue()) {
            throw new BOSException(PSUtils.getResource(ctx, "041_BILL_HAS_LOCK", null));
        }
        if (info.getBillStatus() != DecomposeBillStatusEnum.SUBMIT) {
            throw new BOSException(PSUtils.getResource(ctx, "085_STATUS_NOT_SUBMIT", null));
        }
    }

    private DecomposeBillCollection getDecomposeBillCollectionByIdList(Context ctx, List idList) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("entrys.summary"));
        selector.add(new SelectorItemInfo("entrys.currentIssueAmt"));
        entityViewInfo.setSelector(selector);
        return DecomposeBillFactory.getLocalInstance(ctx).getDecomposeBillCollection(entityViewInfo);
    }

    private PayPlanSumaryCollection getPayPlanSumCollsByDecompseBill(Context ctx, DecomposeBillEntryCollection billEntrys) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < billEntrys.size(); ++i) {
            String sumaryId = billEntrys.get(i).getSummary().getId().toString();
            idSet.add(sumaryId);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        return PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryCollection(entityViewInfo);
    }

    private PayPlanSumaryInfo getPayPlanSumaryInfo(PayPlanSumaryCollection colls, String sumaryId) {
        for (int i = 0; i < colls.size(); ++i) {
            if (!colls.get(i).getId().toString().equals(sumaryId)) continue;
            return colls.get(i);
        }
        return null;
    }

    private void reversePlanSumaryStatus(Context ctx, String sumaryId, SummaryBillStatusEnum sumaryStatus) throws EASBizException, BOSException {
        PaymentPlanBillCollection paymentPlanColls = this.getPaymentPlanColls(ctx, sumaryId);
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int m = 0; m < paymentPlanColls.size(); ++m) {
            PaymentPlanBillInfo planInfo = paymentPlanColls.get(m);
            planInfo.setSumBillStatus(sumaryStatus);
            colls.add((CoreBaseInfo)planInfo);
        }
        PaymentPlanBillFactory.getLocalInstance(ctx).updateBatchData(colls);
    }

    private PaymentPlanBillCollection getPaymentPlanColls(Context ctx, String sumaryId) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("planSumary", (Object)sumaryId, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        return PaymentPlanBillFactory.getLocalInstance(ctx).getPaymentPlanBillCollection(entityViewInfo);
    }

    private PayPlanSumaryCollection getSumaryColls(Context ctx, List<String> sumaryIdList) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("*");
        sel.add("settleEntries.*");
        sel.add("settleEntries.settleCategory.name");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(sumaryIdList), CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        entityViewInfo.setSelector(sel);
        return PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryCollection(entityViewInfo);
    }

    private void verifyDecompseDate(Context ctx, DecomposeBillInfo info) throws BOSException {
        DecomposeBillEntryCollection entryColls = info.getEntrys();
        Date minLimitStart = null;
        Date maxLimitEnd = null;
        for (int i = 0; i < entryColls.size(); ++i) {
            DecomposeBillEntryInfo entryInfo = entryColls.get(i);
            if (minLimitStart == null) {
                minLimitStart = entryInfo.getLimitStartDate();
                maxLimitEnd = entryInfo.getLimitExpiredDate();
                continue;
            }
            if (minLimitStart.after(entryInfo.getLimitStartDate())) {
                minLimitStart = entryInfo.getLimitStartDate();
            }
            if (maxLimitEnd == null || !maxLimitEnd.before(entryInfo.getLimitExpiredDate())) continue;
            maxLimitEnd = entryInfo.getLimitExpiredDate();
        }
        String exMsg = "";
        if (info.getDecompStartDate().after(info.getDecompEndDate())) {
            exMsg = PSUtils.getResource(ctx, "126_DECOM_END_GREATER_START", null);
            throw new BOSException(exMsg);
        }
        Date now = DateTimeUtils.truncateDate((Date)new Date());
        if (info.getDecompStartDate().before(now)) {
            exMsg = PSUtils.getResource(ctx, "127_DECOM_START_GREATER_NOW", null);
            throw new BOSException(exMsg);
        }
        if (info.getDecompEndDate().before(now)) {
            exMsg = PSUtils.getResource(ctx, "128_DECOM_END_GREATER_NOW", null);
            throw new BOSException(exMsg);
        }
        if (minLimitStart != null && minLimitStart.after(info.getDecompStartDate())) {
            exMsg = PSUtils.getResource(ctx, "129_DECOM_START_G_LIMIT_START", null);
            throw new BOSException(exMsg);
        }
        if (maxLimitEnd != null && maxLimitEnd.before(info.getDecompEndDate())) {
            exMsg = PSUtils.getResource(ctx, "130_DECOM_START_L_LIMIT_END", null);
            throw new BOSException(exMsg);
        }
    }

    class ScheduleThread
    extends Thread {
        private Context ctx;
        private List<String> idList;

        public ScheduleThread(Context ctx, List<String> idList) {
            this.ctx = ctx;
            this.idList = idList;
        }

        @Override
        public void run() {
            try {
                DecomposeBillFactory.getLocalInstance(this.ctx).schedule(this.idList);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                logger.info((Object)e.getMessage());
            }
            catch (BOSException e) {
                e.printStackTrace();
                logger.info((Object)e.getMessage());
            }
        }
    }
}

