/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.ps.BillStatusEnum;
import com.kingdee.eas.fm.ps.PSException;
import com.kingdee.eas.fm.ps.PayPlanSourceSettingInfo;
import com.kingdee.eas.fm.ps.app.AbstractPayPlanSourceSettingControllerBean;
import com.kingdee.eas.fm.ps.utils.PSUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayPlanSourceSettingControllerBean
extends AbstractPayPlanSourceSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.app.PayPlanSourceSettingControllerBean");

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayPlanSourceSettingInfo info = (PayPlanSourceSettingInfo)model;
        super._checkNumberDup(ctx, (IObjectValue)info);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{model.getString("name"), ""});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayPlanSourceSettingInfo info = (PayPlanSourceSettingInfo)model;
        this.checkNumberDup(ctx, info);
        info.setStatus(BillStatusEnum.START);
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected Map _deleteRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        String perfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)("\u64cd\u4f5c\u65b9\u6cd5\uff1aPayPlanSourceSettingControllerBean._deleteRule \u64cd\u4f5c\u5458\uff1a" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        ObjectUuidPK[] pkArray = new ObjectUuidPK[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            pkArray[i] = new ObjectUuidPK(ids[i]);
        }
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("status");
        sel.add("number");
        sel.add("company.id");
        sel.add("company.name");
        sel.add("company.number");
        PayPlanSourceSettingInfo ppssInfo = null;
        String summary = PSUtils.getResource(ctx, "008_BILL_SUM", new String[]{pkArray.length + ""});
        int success = 0;
        for (int i = 0; i < pkArray.length; ++i) {
            try {
                ppssInfo = this.getPayPlanSourceSettingInfo(ctx, (IObjectPK)pkArray[i], sel);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ppssInfo.getCompany().getId()), (String)"payPlanSourceSetting04Delete");
                if (!isPermission) {
                    throw new PSException(PSException.NO_DELETE_AUTHRIZED);
                }
                if (ppssInfo.getStatus().getValue() == 7) {
                    throw new BOSException(PSUtils.getResource(ctx, "002_IsStartCanNotDele", null));
                }
                this.delete(ctx, (IObjectPK)pkArray[i]);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(PSUtils.getResource(ctx, "009_BILL_DELETE_FAILED", new String[]{ppssInfo.getCompany().getName(), ppssInfo.getNumber(), e.getMessage()}));
            }
        }
        summary = success == pkArray.length ? summary + PSUtils.getResource(ctx, "014_ALL_DELETE_SUCCESS", null) : summary + PSUtils.getResource(ctx, "013_DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(pkArray.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord((String)perfLogId);
        return result;
    }

    @Override
    protected Map _end(Context ctx, String jsonstr) throws BOSException, EASBizException {
        String perfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)("\u64cd\u4f5c\u65b9\u6cd5\uff1aPayPlanSourceSettingControllerBean._end \u64cd\u4f5c\u5458\uff1a" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        ObjectUuidPK[] pkArray = new ObjectUuidPK[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            pkArray[i] = new ObjectUuidPK(ids[i]);
        }
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("status");
        sel.add("company.id");
        sel.add("company.name");
        sel.add("company.number");
        sel.add("number");
        PayPlanSourceSettingInfo ppssInfo = null;
        String summary = PSUtils.getResource(ctx, "008_BILL_SUM", new String[]{pkArray.length + ""});
        int success = 0;
        Date bizDate = new Date();
        for (int i = 0; i < pkArray.length; ++i) {
            try {
                ppssInfo = this.getPayPlanSourceSettingInfo(ctx, (IObjectPK)pkArray[i], sel);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ppssInfo.getCompany().getId()), (String)"payPlanSourceSetting06Disable");
                if (!isPermission) {
                    throw new PSException(PSException.NO_END_AUTH);
                }
                if (ppssInfo.getStatus().getValue() == 8) {
                    throw new BOSException(PSUtils.getResource(ctx, "003_IsEndCanNotEnd", null));
                }
                ppssInfo.setStatus(BillStatusEnum.END);
                ppssInfo.setStartDate(null);
                ppssInfo.setEndDate(bizDate);
                this.update(ctx, (IObjectPK)pkArray[i], ppssInfo);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(PSUtils.getResource(ctx, "080_END_FAIL", new String[]{ppssInfo.getCompany().getName(), ppssInfo.getNumber(), e.getMessage()}));
            }
        }
        summary = success == pkArray.length ? summary + PSUtils.getResource(ctx, "059_ALL_END_SUCCESS", null) : summary + PSUtils.getResource(ctx, "082_END_RESULT", new String[]{String.valueOf(success), String.valueOf(pkArray.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord((String)perfLogId);
        return result;
    }

    @Override
    protected Map _start(Context ctx, String jsonstr) throws BOSException, EASBizException {
        String perfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)("\u64cd\u4f5c\u65b9\u6cd5\uff1aPayPlanSourceSettingControllerBean._start \u64cd\u4f5c\u5458\uff1a" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        ObjectUuidPK[] pkArray = new ObjectUuidPK[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            pkArray[i] = new ObjectUuidPK(ids[i]);
        }
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("status");
        sel.add("company.id");
        sel.add("company.name");
        sel.add("company.number");
        sel.add("number");
        PayPlanSourceSettingInfo ppssInfo = null;
        String summary = PSUtils.getResource(ctx, "008_BILL_SUM", new String[]{pkArray.length + ""});
        int success = 0;
        Date bizDate = new Date();
        for (int i = 0; i < pkArray.length; ++i) {
            try {
                ppssInfo = this.getPayPlanSourceSettingInfo(ctx, (IObjectPK)pkArray[i], sel);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ppssInfo.getCompany().getId()), (String)"payPlanSourceSetting05Enable");
                if (!isPermission) {
                    throw new PSException(PSException.NO_START_AUTH);
                }
                if (ppssInfo.getStatus().getValue() == 7) {
                    throw new BOSException(PSUtils.getResource(ctx, "004_IsStartCanNotStart", null));
                }
                ppssInfo.setStatus(BillStatusEnum.START);
                ppssInfo.setStartDate(bizDate);
                ppssInfo.setEndDate(null);
                this.update(ctx, (IObjectPK)pkArray[i], ppssInfo);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(PSUtils.getResource(ctx, "079_START_FAIL", new String[]{ppssInfo.getCompany().getName(), ppssInfo.getNumber(), e.getMessage()}));
            }
        }
        summary = success == pkArray.length ? summary + PSUtils.getResource(ctx, "060_ALL_START_SUCCESS", null) : summary + PSUtils.getResource(ctx, "081_START_RESULT", new String[]{String.valueOf(success), String.valueOf(pkArray.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord((String)perfLogId);
        return result;
    }

    @Override
    protected Map _getBOTPRule(Context ctx, String bizSource, String companyID) throws BOSException, EASBizException {
        String targetBillType = "FDB9FA00";
        ArrayList srcBOTTypeList = BOTMappingHelper.getSourceBillTypeList((Context)ctx, (String)targetBillType);
        String type = null;
        HashMap transmitCtxMap = new HashMap();
        Map<String, Map<String, Object>> srcBOTTypeMapByBizSource = this.getSrcBOTTypeMapByBizSource(ctx, bizSource);
        HashMap<String, String> map = null;
        BOTMappingCollection botMapCol = null;
        ArrayList botpRuleList = null;
        for (int i = 0; i < srcBOTTypeList.size(); ++i) {
            type = srcBOTTypeList.get(i).toString();
            if (!srcBOTTypeMapByBizSource.containsKey(type) || (botMapCol = (BOTMappingCollection)BOTMappingHelper.getMappingForSelect((Context)ctx, (String)type, (String)targetBillType, transmitCtxMap)).size() <= 0) continue;
            botpRuleList = new ArrayList();
            for (int j = 0; j < botMapCol.size(); ++j) {
                map = new HashMap<String, String>();
                map.put("alias", botMapCol.get(j).getAlias());
                map.put("value", (String)botMapCol.get(j).getId());
                botpRuleList.add(map);
            }
            srcBOTTypeMapByBizSource.get(type).put("value", botMapCol.get(0).getId().toString());
            srcBOTTypeMapByBizSource.get(type).put("botpRuleList", botpRuleList);
        }
        return srcBOTTypeMapByBizSource;
    }

    private Map<String, Map<String, Object>> getSrcBOTTypeMapByBizSource(Context ctx, String bizSource) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> subMap = new HashMap<String, String>();
        if ("0".equals(bizSource)) {
            subMap.put("value", "D001019A");
            subMap.put("alias", "1");
            map.put("D001019A", subMap);
            subMap = new HashMap();
            subMap.put("value", "48DA3A71");
            subMap.put("alias", "0");
            map.put("48DA3A71", subMap);
        }
        return map;
    }
}

