/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ps.BillStatusEnum;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryFactory;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillFactory;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PsBillDisposer
implements IPaymentDisposer {
    private static final String LOCKED = "LOCKED";

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        if (action.getDestBill() == null) {
            return;
        }
        PaymentBillInfo destInfo = (PaymentBillInfo)action.getDestBill();
        DisposerActionEnum actionType = action.getActionType();
        boolean isSrcBill = destInfo.getPayPlanBillID() != null;
        String destId = destInfo.getId().toString();
        String sourceBillId = destInfo.getEntries().get(0).getSourceBillId();
        BOSObjectType bosType = BOSUuid.read((String)sourceBillId).getType();
        if (bosType.equals((Object)new OtherBillInfo().getBOSType())) {
            Map<String, BigDecimal> amtMap = this.getDisposeAmtMap(destInfo.getEntries());
            for (String srcEntryId : amtMap.keySet()) {
                PaymentPlanBillEntryInfo srcEntryInfo = PaymentPlanBillEntryFactory.getLocalInstance(ctx).getPaymentPlanBillEntryInfo((IObjectPK)new ObjectUuidPK(srcEntryId));
                PaymentPlanBillInfo srcInfo = PaymentPlanBillFactory.getLocalInstance(ctx).getPaymentPlanBillInfo((IObjectPK)new ObjectUuidPK(srcEntryInfo.getParent().getId().toString()), this.getSelector());
                BigDecimal disposeAmt = amtMap.get(srcEntryId);
                if (DisposerActionEnum.SAVE.equals((Object)actionType) || DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
                    this.dispose4Save(ctx, srcInfo, srcEntryId, isSrcBill, destId, disposeAmt);
                    continue;
                }
                if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
                    this.dispose4Delete(ctx, srcInfo, srcEntryId, disposeAmt);
                    continue;
                }
                if (DisposerActionEnum.PAY.equals((Object)actionType)) {
                    this.dispose4Pay(ctx, srcInfo, srcEntryId, isSrcBill, destId, disposeAmt);
                    continue;
                }
                if (!DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) continue;
                this.dispose4CancelPay(ctx, srcInfo, srcEntryId, disposeAmt);
            }
        } else {
            for (int i = 0; i < destInfo.getEntries().size(); ++i) {
                PaymentBillEntryInfo destEntryInfo = destInfo.getEntries().get(i);
                String srcEntryId = null;
                srcEntryId = isSrcBill ? destEntryInfo.getSrcPlanBillEntryID() : destEntryInfo.getSourceBillEntryId();
                PaymentPlanBillEntryInfo srcEntryInfo = PaymentPlanBillEntryFactory.getLocalInstance(ctx).getPaymentPlanBillEntryInfo((IObjectPK)new ObjectUuidPK(srcEntryId));
                PaymentPlanBillInfo srcInfo = PaymentPlanBillFactory.getLocalInstance(ctx).getPaymentPlanBillInfo((IObjectPK)new ObjectUuidPK(srcEntryInfo.getParent().getId().toString()), this.getSelector());
                BigDecimal destEntryAmt = destEntryInfo.getAmount();
                if (DisposerActionEnum.SAVE.equals((Object)actionType) || DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
                    this.dispose4Save(ctx, srcInfo, srcEntryId, isSrcBill, destId, destEntryAmt);
                    continue;
                }
                if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
                    this.dispose4Delete(ctx, srcInfo, srcEntryId, destEntryAmt);
                    continue;
                }
                if (DisposerActionEnum.PAY.equals((Object)actionType)) {
                    this.dispose4Pay(ctx, srcInfo, srcEntryId, isSrcBill, destId, destEntryAmt);
                    continue;
                }
                if (!DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) continue;
                this.dispose4CancelPay(ctx, srcInfo, srcEntryId, destEntryAmt);
            }
        }
    }

    private Map<String, BigDecimal> getDisposeAmtMap(PaymentBillEntryCollection coll) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (int i = 0; i < coll.size(); ++i) {
            PaymentBillEntryInfo entry = coll.get(i);
            String eid = entry.getSrcPlanBillEntryID();
            sumAmt = map.containsKey(eid) ? sumAmt.add(entry.getAmount()) : entry.getAmount();
            map.put(eid, sumAmt);
        }
        return map;
    }

    private Map<String, BigDecimal> getDisposeAmtMap(Context ctx, String destId) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT entrys.FSrcPlanBillEntryID, SUM(entrys.FAmount) AS FAmount ");
        sql.append(" FROM T_CAS_PaymentBillEntry entrys ");
        sql.append(" WHERE entrys.FPaymentBillID = '" + destId + "'");
        sql.append(" GROUP BY entrys.FSrcPlanBillEntryID; ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    BigDecimal sumAmt = rs.getBigDecimal("FAmount");
                    if (sumAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    amtMap.put(rs.getString("FSrcPlanBillEntryID"), sumAmt);
                }
            }
        }
        catch (SQLException e) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{e.getMessage()});
        }
        return amtMap;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("applyPayAmount"));
        sic.add(new SelectorItemInfo("scheduleAmount"));
        sic.add(new SelectorItemInfo("approvedAmt"));
        sic.add(new SelectorItemInfo("payAmount"));
        sic.add(new SelectorItemInfo("payDate"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.scheduleAmt"));
        sic.add(new SelectorItemInfo("entries.lockAmt"));
        sic.add(new SelectorItemInfo("entries.payAmt"));
        sic.add(new SelectorItemInfo("entries.payDate"));
        return sic;
    }

    private void dispose4Save(Context ctx, PaymentPlanBillInfo srcInfo, String srcEntryId, boolean isSrcBill, String destId, BigDecimal destEntryAmt) throws EASBizException, BOSException {
        Map<String, BigDecimal> map = null;
        map = isSrcBill ? this.getPreGenBillMap(ctx, srcEntryId, destId, SourceTypeEnum.AP) : this.getPreGenBillMap(ctx, srcEntryId, destId, SourceTypeEnum.PS);
        BigDecimal sumLockAmt = BigDecimal.ZERO;
        for (int i = 0; i < srcInfo.getEntries().size(); ++i) {
            PaymentPlanBillEntryInfo entry = srcInfo.getEntries().get(i);
            if (srcEntryId.equals(entry.getId().toString())) {
                if (map != null && map.containsKey(LOCKED)) {
                    BigDecimal lockAmt = map.get(LOCKED);
                    entry.setLockAmt(lockAmt.add(destEntryAmt));
                } else {
                    entry.setLockAmt(destEntryAmt);
                }
            }
            sumLockAmt = sumLockAmt.add(entry.getLockAmt());
        }
        srcInfo.setApprovedAmt(sumLockAmt);
        srcInfo.setBillStatus(BillStatusEnum.PAYING);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("approvedAmt"));
        sic.add(new SelectorItemInfo("entries.lockAmt"));
        PaymentPlanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)srcInfo, sic);
    }

    private void dispose4Delete(Context ctx, PaymentPlanBillInfo srcInfo, String srcEntryId, BigDecimal destEntryAmt) throws EASBizException, BOSException {
        BigDecimal sumLockAmt = BigDecimal.ZERO;
        for (int i = 0; i < srcInfo.getEntries().size(); ++i) {
            PaymentPlanBillEntryInfo entry = srcInfo.getEntries().get(i);
            if (!srcEntryId.equals(entry.getId().toString())) continue;
            if (entry.getLockAmt().compareTo(BigDecimal.ZERO) > 0) {
                entry.setLockAmt(entry.getLockAmt().subtract(destEntryAmt));
            } else {
                entry.setLockAmt(BigDecimal.ZERO);
            }
            sumLockAmt = sumLockAmt.add(destEntryAmt);
        }
        srcInfo.setApprovedAmt(srcInfo.getApprovedAmt().subtract(sumLockAmt));
        if (srcInfo.getPayAmount() == null) {
            srcInfo.setPayAmount(BigDecimal.ZERO);
        }
        if (srcInfo.getBillStatus() != BillStatusEnum.CLOSE) {
            if (srcInfo.getApprovedAmt().compareTo(BigDecimal.ZERO) > 0) {
                if (srcInfo.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                    srcInfo.setBillStatus(BillStatusEnum.PAYING);
                } else if (srcInfo.getApprovedAmt().compareTo(BigDecimal.ZERO) == 0) {
                    srcInfo.setBillStatus(srcInfo.getApplyPayAmount().compareTo(srcInfo.getScheduleAmount()) != 0 ? BillStatusEnum.SCHEDULING : BillStatusEnum.SCHEDULED);
                }
            } else {
                srcInfo.setBillStatus(srcInfo.getApplyPayAmount().compareTo(srcInfo.getScheduleAmount()) != 0 ? BillStatusEnum.SCHEDULING : BillStatusEnum.SCHEDULED);
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        if (srcInfo.getBillStatus() != BillStatusEnum.CLOSE) {
            sic.add(new SelectorItemInfo("billStatus"));
        }
        sic.add(new SelectorItemInfo("approvedAmt"));
        sic.add(new SelectorItemInfo("entries.lockAmt"));
        PaymentPlanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)srcInfo, sic);
    }

    private void dispose4Pay(Context ctx, PaymentPlanBillInfo srcInfo, String srcEntryId, boolean isSrcBill, String destId, BigDecimal destEntryAmt) throws EASBizException, BOSException {
        Map<String, BigDecimal> map = null;
        map = isSrcBill ? this.getPreGenBillMap(ctx, srcEntryId, destId, SourceTypeEnum.AP) : this.getPreGenBillMap(ctx, srcEntryId, destId, SourceTypeEnum.PS);
        BigDecimal sumLockAmt = BigDecimal.ZERO;
        BigDecimal sumPayAmt = BigDecimal.ZERO;
        for (int i = 0; i < srcInfo.getEntries().size(); ++i) {
            PaymentPlanBillEntryInfo entry = srcInfo.getEntries().get(i);
            if (!srcEntryId.equals(entry.getId().toString())) continue;
            entry.setLockAmt(entry.getLockAmt().subtract(destEntryAmt));
            if (map != null) {
                if (map.containsKey(com.kingdee.eas.fi.cas.BillStatusEnum.PAYED.getName())) {
                    entry.setPayAmt(map.get(com.kingdee.eas.fi.cas.BillStatusEnum.PAYED.getName()).add(destEntryAmt));
                } else {
                    entry.setPayAmt(destEntryAmt);
                }
            } else {
                entry.setPayAmt(destEntryAmt);
            }
            entry.setPayDate(DateTimeUtils.truncateDate((Date)new Date()));
            sumLockAmt = sumLockAmt.add(destEntryAmt);
            sumPayAmt = sumPayAmt.add(destEntryAmt);
        }
        if (srcInfo.getPayAmount() == null) {
            srcInfo.setPayAmount(BigDecimal.ZERO);
        }
        srcInfo.setApprovedAmt(srcInfo.getApprovedAmt().subtract(sumLockAmt));
        srcInfo.setPayAmount(srcInfo.getPayAmount().add(sumPayAmt));
        srcInfo.setBillStatus(srcInfo.getApplyPayAmount().compareTo(srcInfo.getPayAmount()) != 0 ? BillStatusEnum.PAYING : BillStatusEnum.PAYED);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("approvedAmt"));
        sic.add(new SelectorItemInfo("payAmount"));
        sic.add(new SelectorItemInfo("entries.lockAmt"));
        sic.add(new SelectorItemInfo("entries.payAmt"));
        sic.add(new SelectorItemInfo("entries.payDate"));
        PaymentPlanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)srcInfo, sic);
    }

    private void dispose4CancelPay(Context ctx, PaymentPlanBillInfo srcInfo, String srcEntryId, BigDecimal destEntryAmt) throws EASBizException, BOSException {
        BigDecimal sumLockAmt = BigDecimal.ZERO;
        BigDecimal sumPayAmt = BigDecimal.ZERO;
        for (int i = 0; i < srcInfo.getEntries().size(); ++i) {
            PaymentPlanBillEntryInfo entry = srcInfo.getEntries().get(i);
            if (!srcEntryId.equals(entry.getId().toString())) continue;
            entry.setLockAmt(entry.getLockAmt().add(destEntryAmt));
            entry.setPayAmt(entry.getPayAmt().subtract(destEntryAmt));
            entry.setPayDate(null);
            sumLockAmt = sumLockAmt.add(destEntryAmt);
            sumPayAmt = sumPayAmt.add(destEntryAmt);
        }
        srcInfo.setApprovedAmt(srcInfo.getApprovedAmt().add(sumLockAmt));
        srcInfo.setPayAmount(srcInfo.getPayAmount().subtract(sumPayAmt));
        srcInfo.setBillStatus(BillStatusEnum.PAYING);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("approvedAmt"));
        sic.add(new SelectorItemInfo("payAmount"));
        sic.add(new SelectorItemInfo("entries.lockAmt"));
        sic.add(new SelectorItemInfo("entries.payAmt"));
        sic.add(new SelectorItemInfo("entries.payDate"));
        PaymentPlanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)srcInfo, sic);
    }

    private Map<String, BigDecimal> getPreGenBillMap(Context ctx, String srcEntryId, String pk, SourceTypeEnum sourceType) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT head.FBillStatus, SUM(entrys.FAmount) AS FAmount ");
        sql.append(" FROM T_CAS_PaymentBill head ");
        sql.append(" LEFT JOIN T_CAS_PaymentBillEntry entrys ON entrys.FPaymentBillID = head.FID ");
        sql.append(" WHERE head.FID <> '" + pk + "'");
        if (sourceType == SourceTypeEnum.AP) {
            sql.append(" AND entrys.FSrcPlanBillEntryID = '" + srcEntryId + "'");
        } else {
            sql.append(" AND entrys.FSourceBillEntryId = '" + srcEntryId + "'");
        }
        sql.append(" GROUP BY head.FBillStatus; ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rs != null && rs.size() > 0) {
                BigDecimal sumLockAmt = BigDecimal.ZERO;
                while (rs.next()) {
                    BigDecimal sumAmt = rs.getBigDecimal("FAmount");
                    if (sumAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (rs.getInt("FBillStatus") == 15) {
                        map.put(com.kingdee.eas.fi.cas.BillStatusEnum.PAYED.getName(), sumAmt);
                        continue;
                    }
                    sumLockAmt = sumLockAmt.add(sumAmt);
                    map.put(LOCKED, sumLockAmt);
                }
            } else {
                map = null;
            }
        }
        catch (SQLException e) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{e.getMessage()});
        }
        return map;
    }
}

