/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.Cas4PsException;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.PaymentBillDataProcess;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.PaySaveService;
import java.util.Date;

public class PsPaySaveService
extends PaySaveService {
    public void beforeSave() throws EASBizException, BOSException {
        if (this.info.getEntries() == null || this.info.getEntries().size() == 0) {
            throw new Cas4PsException(Cas4PsException.NOENTRYNOSAVE);
        }
        super.beforeSave();
        if (this.info.getSourceType() == SourceTypeEnum.PS) {
            // empty if block
        }
        if (this.info.getBizDate() == null) {
            this.info.setBizDate(new Date());
        }
        if (this.info.getBillDate() == null) {
            this.info.setBillDate(new Date());
        }
        if (this.info.getSourceSysType() == null) {
            this.info.setSourceSysType(SourceTypeEnum.PS);
        }
        if (this.info.getCU() == null && this.info.getCompany().getCU() != null) {
            this.info.setCU(this.info.getCompany().getCU());
        }
        if (this.info.getBillStatus() == null || this.info.getBillStatus() != BillStatusEnum.SAVE) {
            this.info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (this.info.getId() != null && !this.isAddNew) {
            if (this.info.getBillStatus().getValue() == 11) {
                throw new CasForArApException(CasForArApException.SUBMMITED_CANNNOTSAVE);
            }
            if (this.info.getBillStatus().getValue() >= 12) {
                throw new CasForArApException(CasForArApException.BILLISAUDITED);
            }
        }
        this.serviceHandler.checkIsInQueue(this.ctx, this.info);
        PaymentBillDataProcess.setAmountProp((Context)this.ctx, (PaymentBillInfo)this.info);
    }
}

