/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.test;

import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.fm.ps.BillStatusEnum;
import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import com.kingdee.eas.fm.ps.SettlementCategoryInfo;
import com.kingdee.eas.fm.ps.vo.DecompScheuleInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class DecomposeAmt4SettleCateTest {
    public static void main(String[] args) {
        PaymentPlanBillCollection detailColl = new PaymentPlanBillCollection();
        PaymentPlanBillInfo detail1 = new PaymentPlanBillInfo();
        detail1.setNumber("M001");
        detail1.setApplyPayAmount(new BigDecimal(10));
        detail1.setScheduleAmount(new BigDecimal(2));
        detail1.setApprovedAmt(new BigDecimal(0));
        detail1.setPayAmount(new BigDecimal(0));
        detailColl.add(detail1);
        PaymentPlanBillInfo detail2 = new PaymentPlanBillInfo();
        detail2.setNumber("M002");
        detail2.setApplyPayAmount(new BigDecimal(5));
        detailColl.add(detail2);
        List<DecompScheuleInfo> issueList = DecomposeAmt4SettleCateTest.getIssueList();
        List<PaymentPlanBillInfo> detailList = DecomposeAmt4SettleCateTest.decomposeAmt(issueList, detailColl);
        DecomposeAmt4SettleCateTest.dispose(detailList);
        for (PaymentPlanBillInfo detail : detailList) {
            StringBuffer sb = new StringBuffer();
            sb.append(detail.getNumber()).append("\t");
            sb.append(detail.getApplyPayAmount().toString()).append("\t");
            sb.append(detail.getScheduleAmount().toString()).append("\t");
            sb.append(detail.getBillStatus().getAlias()).append("\t");
            System.out.println(sb.toString());
            for (int i = 0; i < detail.getEntries().size(); ++i) {
                PaymentPlanBillEntryInfo entry = detail.getEntries().get(i);
                StringBuffer eb = new StringBuffer();
                eb.append(entry.getSeq()).append("\t");
                if (entry.getSettleCate() != null) {
                    eb.append(entry.getSettleCate().getName().toString()).append("\t");
                }
                eb.append(entry.getScheduleAmt().toString()).append("\t");
                eb.append(entry.getSettleType().getName().toString()).append("\t");
                eb.append(entry.getPayerAccBank().getName().toString()).append("\t");
                System.out.println(eb.toString());
            }
        }
    }

    private static PaymentPlanBillEntryInfo setEntryInfo(int seqNo, BigDecimal schdlAmt) {
        PaymentPlanBillEntryInfo entry = new PaymentPlanBillEntryInfo();
        entry.setSeq(seqNo);
        SettlementCategoryInfo sc = new SettlementCategoryInfo();
        sc.setName("NOTE");
        entry.setSettleCate(sc);
        entry.setScheduleAmt(schdlAmt);
        SettlementTypeInfo st = new SettlementTypeInfo();
        st.setName("P");
        entry.setSettleType(st);
        AccountBankInfo ab = new AccountBankInfo();
        ab.setName("P");
        entry.setPayerAccBank(ab);
        return entry;
    }

    private static List<PaymentPlanBillInfo> decomposeAmt(List<DecompScheuleInfo> issueList, PaymentPlanBillCollection detailColl) {
        ArrayList<PaymentPlanBillInfo> detailList = new ArrayList<PaymentPlanBillInfo>();
        for (int i = 0; i < detailColl.size(); ++i) {
            PaymentPlanBillInfo detail = detailColl.get(i);
            BigDecimal schdlAmt = detail.getScheduleAmount() != null ? detail.getScheduleAmount() : BigDecimal.ZERO;
            int entryInitSize = 0;
            boolean isSchdled = false;
            if (schdlAmt.compareTo(BigDecimal.ZERO) > 0) {
                entryInitSize = detail.getEntries().size();
                isSchdled = detail.getApprovedAmt().compareTo(BigDecimal.ZERO) == 0 && detail.getPayAmount().compareTo(BigDecimal.ZERO) == 0;
            }
            BigDecimal applyAmt = detail.getApplyPayAmount().subtract(schdlAmt);
            int seqNo = entryInitSize;
            for (DecompScheuleInfo issueInfo : issueList) {
                PaymentPlanBillEntryInfo entry;
                BigDecimal currentIssueAmt;
                if (!issueInfo.isAvalilable() || (currentIssueAmt = issueInfo.getCurrentIssueAmt().subtract(issueInfo.getActAmt())).compareTo(BigDecimal.ZERO) <= 0) continue;
                if (currentIssueAmt.compareTo(applyAmt) < 0) {
                    schdlAmt = currentIssueAmt;
                    issueInfo.setActAmt(currentIssueAmt);
                    entry = null;
                    if (isSchdled) {
                        entry = DecomposeAmt4SettleCateTest.buildEntryInfo(detail.getEntries(), issueInfo, schdlAmt);
                    }
                    if (entry == null) {
                        entry = DecomposeAmt4SettleCateTest.buildEntryInfo(issueInfo, schdlAmt, ++seqNo);
                        detail.getEntries().add(entry);
                    }
                    applyAmt = applyAmt.subtract(currentIssueAmt);
                    issueInfo.setAvalilable(false);
                    continue;
                }
                schdlAmt = applyAmt;
                issueInfo.setActAmt(applyAmt);
                entry = null;
                if (isSchdled) {
                    entry = DecomposeAmt4SettleCateTest.buildEntryInfo(detail.getEntries(), issueInfo, schdlAmt);
                }
                if (entry != null) break;
                entry = DecomposeAmt4SettleCateTest.buildEntryInfo(issueInfo, schdlAmt, ++seqNo);
                detail.getEntries().add(entry);
                break;
            }
            if (!isSchdled && detail.getEntries().size() <= entryInitSize) continue;
            detailList.add(detail);
        }
        return detailList;
    }

    private static PaymentPlanBillEntryInfo buildEntryInfo(PaymentPlanBillEntryCollection entries, DecompScheuleInfo issueInfo, BigDecimal schdlAmt) {
        PaymentPlanBillEntryInfo info = null;
        for (int i = 0; i < entries.size(); ++i) {
            PaymentPlanBillEntryInfo entry = entries.get(i);
            boolean isSame = false;
            if (issueInfo.getSettleCateID() == null && entry.getSettleType() == null) {
                isSame = true;
            }
            if (issueInfo.getSettleCateID() != null && entry.getSettleType() != null) {
                isSame = entry.getSettleCate().getName().equals(issueInfo.getSettleCateID());
            }
            if (issueInfo.getSettleTypeID() == null && entry.getSettleType() == null) {
                boolean bl = isSame = isSame;
            }
            if (issueInfo.getSettleTypeID() != null && entry.getSettleType() != null) {
                boolean bl = isSame = isSame && entry.getSettleType().getName().equals(issueInfo.getSettleTypeID());
            }
            if (issueInfo.getAccountBankID() == null && entry.getPayerAccBank() == null) {
                boolean bl = isSame = isSame;
            }
            if (issueInfo.getAccountBankID() != null && entry.getPayerAccBank() != null) {
                boolean bl = isSame = isSame && entry.getPayerAccBank().getName().equals(issueInfo.getAccountBankID());
            }
            if (!isSame) continue;
            entry.setScheduleAmt(entry.getScheduleAmt().add(schdlAmt));
            info = entry;
        }
        return info;
    }

    private static PaymentPlanBillEntryInfo buildEntryInfo(DecompScheuleInfo issueInfo, BigDecimal schdlAmt, int seqNo) {
        PaymentPlanBillEntryInfo entry = new PaymentPlanBillEntryInfo();
        entry.setSeq(seqNo);
        if (issueInfo.getSettleCateID() != null) {
            SettlementCategoryInfo sc = new SettlementCategoryInfo();
            sc.setName(issueInfo.getSettleCateID());
            entry.setSettleCate(sc);
        }
        entry.setScheduleAmt(schdlAmt != null ? schdlAmt : issueInfo.getCurrentIssueAmt());
        if (issueInfo.getSettleTypeID() != null) {
            SettlementTypeInfo st = new SettlementTypeInfo();
            st.setName(issueInfo.getSettleTypeID());
            entry.setSettleType(st);
        }
        if (issueInfo.getAccountBankID() != null) {
            AccountBankInfo ab = new AccountBankInfo();
            ab.setName(issueInfo.getAccountBankID());
            entry.setPayerAccBank(ab);
        }
        return entry;
    }

    private static List<DecompScheuleInfo> getSchdlList(PaymentPlanBillCollection detailColl) {
        ArrayList<DecompScheuleInfo> schdlList = new ArrayList<DecompScheuleInfo>();
        for (int i = 0; i < detailColl.size(); ++i) {
            boolean isSchdled;
            PaymentPlanBillInfo detail = detailColl.get(i);
            boolean bl = isSchdled = detail.getScheduleAmount().compareTo(BigDecimal.ZERO) != 0 && detail.getApprovedAmt().compareTo(BigDecimal.ZERO) == 0 && detail.getPayAmount().compareTo(BigDecimal.ZERO) == 0;
            if (!isSchdled) continue;
            for (int j = 0; j < detail.getEntries().size(); ++j) {
                PaymentPlanBillEntryInfo entry = detail.getEntries().get(j);
                DecompScheuleInfo schdl = DecomposeAmt4SettleCateTest.buildScheuleInfo(entry);
                schdlList.add(schdl);
            }
        }
        return schdlList;
    }

    private static DecompScheuleInfo buildScheuleInfo(PaymentPlanBillEntryInfo entry) {
        DecompScheuleInfo schdl = new DecompScheuleInfo();
        schdl.setSettleCateID(entry.getSettleCate().getName());
        schdl.setCurrentIssueAmt(entry.getScheduleAmt());
        schdl.setSettleTypeID(entry.getSettleType().getName());
        schdl.setAccountBankID(entry.getPayerAccBank().getName());
        return schdl;
    }

    private static void dispose(List<PaymentPlanBillInfo> detailList) {
        for (PaymentPlanBillInfo info : detailList) {
            BigDecimal schdlAmt = BigDecimal.ZERO;
            for (int i = 0; i < info.getEntries().size(); ++i) {
                PaymentPlanBillEntryInfo entry = info.getEntries().get(i);
                schdlAmt = schdlAmt.add(entry.getScheduleAmt());
            }
            info.setScheduleAmount(schdlAmt);
            BigDecimal applyAmt = info.getApplyPayAmount();
            info.setBillStatus(applyAmt.compareTo(schdlAmt) != 0 ? BillStatusEnum.SCHEDULING : BillStatusEnum.SCHEDULED);
        }
    }

    private static List<DecompScheuleInfo> getIssueList() {
        ArrayList<DecompScheuleInfo> issueList = new ArrayList<DecompScheuleInfo>();
        DecompScheuleInfo schld1 = new DecompScheuleInfo();
        schld1.setSummaryID("FS001");
        schld1.setCurrentIssueAmt(new BigDecimal(5));
        schld1.setSettleTypeID("A");
        schld1.setAccountBankID("A");
        issueList.add(schld1);
        DecompScheuleInfo schld2 = new DecompScheuleInfo();
        schld2.setSummaryID("FS002");
        schld2.setCurrentIssueAmt(new BigDecimal(5));
        schld2.setSettleTypeID("C");
        schld2.setAccountBankID("C");
        issueList.add(schld2);
        return issueList;
    }
}

