/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.test;

import com.kingdee.eas.fm.ps.BillStatusEnum;
import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class DecomposeAmtTest {
    public static void main(String[] args) {
        PaymentPlanBillCollection detailColl = new PaymentPlanBillCollection();
        PaymentPlanBillInfo detail1 = new PaymentPlanBillInfo();
        detail1.setNumber("M001");
        detail1.setApplyPayAmount(new BigDecimal(10));
        detail1.setScheduleAmount(new BigDecimal(2));
        detailColl.add(detail1);
        PaymentPlanBillInfo detail2 = new PaymentPlanBillInfo();
        detail2.setNumber("M002");
        detail2.setApplyPayAmount(new BigDecimal(5));
        detailColl.add(detail2);
        BigDecimal issueAmt = new BigDecimal("9");
        List<PaymentPlanBillInfo> detailList = DecomposeAmtTest.decomposeAmt(issueAmt, detailColl);
        for (PaymentPlanBillInfo detail : detailList) {
            StringBuffer sb = new StringBuffer();
            sb.append(detail.getNumber()).append("\t");
            sb.append(detail.getApplyPayAmount().toString()).append("\t");
            sb.append(detail.getScheduleAmount().toString()).append("\t");
            sb.append(detail.getBillStatus().getAlias()).append("\t");
            System.out.println(sb.toString());
        }
    }

    private static List<PaymentPlanBillInfo> decomposeAmt(BigDecimal issueAmt, PaymentPlanBillCollection detailColl) {
        BigDecimal decompAmt = issueAmt;
        ArrayList<PaymentPlanBillInfo> detailList = new ArrayList<PaymentPlanBillInfo>();
        for (int i = 0; i < detailColl.size(); ++i) {
            PaymentPlanBillInfo detail = detailColl.get(i);
            BigDecimal schdlAmt = detail.getScheduleAmount() != null ? detail.getScheduleAmount() : BigDecimal.ZERO;
            BigDecimal applyAmt = detail.getApplyPayAmount().subtract(schdlAmt);
            if (applyAmt.compareTo(decompAmt) >= 0) {
                detail.setBillStatus(applyAmt.compareTo(decompAmt) != 0 ? BillStatusEnum.SCHEDULING : BillStatusEnum.SCHEDULED);
                detail.setScheduleAmount(schdlAmt.add(decompAmt));
                detailList.add(detail);
                break;
            }
            if (applyAmt.compareTo(decompAmt) >= 0) {
                detail.setBillStatus(BillStatusEnum.SCHEDULING);
                detail.setScheduleAmount(schdlAmt.add(decompAmt));
                detailList.add(detail);
                break;
            }
            detail.setBillStatus(BillStatusEnum.SCHEDULED);
            detail.setScheduleAmount(schdlAmt.add(applyAmt));
            detailList.add(detail);
            decompAmt = decompAmt.subtract(applyAmt);
        }
        return detailList;
    }
}

