/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.recon.FmSettleResultCollection;
import com.kingdee.eas.fm.recon.FmSettleResultFactory;
import com.kingdee.eas.fm.recon.FmSettleResultInfo;
import com.kingdee.eas.fm.recon.ISipgFmReconFacade;
import com.kingdee.eas.fm.recon.SettleStatusEnum;
import com.kingdee.eas.fm.recon.SipgFmReconFacadeFactory;
import com.kingdee.eas.fm.recon.TableModel;
import com.kingdee.eas.fm.recon.app.AbstractFmSettleResultControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FmSettleResultControllerBean
extends AbstractFmSettleResultControllerBean {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmSettleResource";
    private static final String BEAUTO_GENERATE_RESOURCE_PATH = "com.kingdee.eas.fm.be.BEAutoGenerateResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.recon.app.FmSettleResultControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _settleBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        List<Object> msgList = new ArrayList();
        List lockIds = FMHelper.set2List((Set)idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList successLockIds = new ArrayList();
        ArrayList failedLockIds = new ArrayList();
        try {
            FmSettleResultCollection settleResultCollection;
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(lockIds);
            for (int i = 0; i < lockIds.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                if (boolResult.booleanValue()) {
                    successLockIds.add(lockIds.get(i));
                    continue;
                }
                failedLockIds.add(lockIds.get(i));
            }
            if (successLockIds.size() > 0) {
                Set successIdSet = FMHelper.list2Set(successLockIds);
                settleResultCollection = this.getFmSettleResultCollection(ctx, successIdSet);
                Map<String, Map<String, FmSettleResultInfo>> map = this.proccessSettleResultCollection(settleResultCollection);
                Map<String, Map<String, SystemStatusCtrolInfo>> systemStatusCtrlMap = this.getSystemStatusCtrlCollection(ctx, map.keySet());
                msgList = this.verifyForSettle(ctx, map, systemStatusCtrlMap, settleResultCollection);
                if (settleResultCollection.size() > 0) {
                    this.doProcessSettle(ctx, settleResultCollection);
                    this.doAfterSettle(ctx, systemStatusCtrlMap);
                }
            }
            if (failedLockIds.size() > 0) {
                Set failedIdSet = FMHelper.list2Set(failedLockIds);
                settleResultCollection = this.getFmSettleResultCollection(ctx, failedIdSet);
                for (int i = 0; i < settleResultCollection.size(); ++i) {
                    FmSettleResultInfo fmSettleResultInfo = settleResultCollection.get(i);
                    String msg1 = EASCommonResource.getString((String)RESOURCE_PATH, (String)"25_PERIOD", (Locale)ctx.getLocale()) + fmSettleResultInfo.getPeriod().getDescription() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"26_MODULE", (Locale)ctx.getLocale()) + fmSettleResultInfo.getSystemStatus().getName() + EASCommonResource.getString((String)BEAUTO_GENERATE_RESOURCE_PATH, (String)"REQ_MUTEX_FAILED", (Locale)ctx.getLocale());
                    msgList.add(msg1);
                }
            }
        }
        finally {
            if (successLockIds.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(successLockIds);
            }
        }
        return msgList;
    }

    @Override
    protected List _unSettleBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        FmSettleResultCollection settleResultCollection = this.getFmSettleResultCollection(ctx, idSet);
        Map<String, Map<String, FmSettleResultInfo>> map = this.proccessSettleResultCollection(settleResultCollection);
        List<String> msgList = this.verifyForUnSettle(ctx, settleResultCollection, map);
        if (settleResultCollection.size() > 0) {
            this.doProcessUnSettle(ctx, settleResultCollection);
            this.doAfterUnSettle(ctx, settleResultCollection);
        }
        return msgList;
    }

    private List<String> verifyForUnSettle(Context ctx, FmSettleResultCollection settleResultCollection, Map<String, Map<String, FmSettleResultInfo>> map) throws EASBizException, BOSException {
        ArrayList<String> msgList = new ArrayList<String>();
        for (String companyId : map.keySet()) {
            Map<String, FmSettleResultInfo> settleResultMap;
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), "FMSETTLE_03UNSETTLE");
            if (!isPermission) {
                msgList.add(EASCommonResource.getString((String)RESOURCE_PATH, (String)"23_NOT_HAVE", (Locale)ctx.getLocale()) + companyInfo.getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"24_UNSETTLED_PERM", (Locale)ctx.getLocale()));
                settleResultMap = map.get(companyId);
                Set<String> settleResultIdSet = settleResultMap.keySet();
                for (String id : settleResultIdSet) {
                    FmSettleResultInfo settleInfo = settleResultMap.get(id);
                    settleResultCollection.remove(settleInfo);
                }
                continue;
            }
            settleResultMap = map.get(companyId);
            for (Map.Entry<String, FmSettleResultInfo> entry : settleResultMap.entrySet()) {
                FmSettleResultInfo settleInfo = entry.getValue();
                if (settleInfo.getSettleStatus() == SettleStatusEnum.unSettle) {
                    msgList.add(settleInfo.getCompany().getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"25_PERIOD", (Locale)ctx.getLocale()) + settleInfo.getPeriod().getDescription() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"26_MODULE", (Locale)ctx.getLocale()) + settleInfo.getSystemStatus().getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"27_UNSETTLED", (Locale)ctx.getLocale()));
                    settleResultCollection.remove(settleInfo);
                    continue;
                }
                PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)settleInfo.getPeriod());
                boolean isExistSettleData = this.isExistSettleData(ctx, settleInfo, nextPeriod.getId().toString());
                if (isExistSettleData) {
                    msgList.add(settleInfo.getCompany().getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"25_PERIOD", (Locale)ctx.getLocale()) + nextPeriod.getDescription() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"26_MODULE", (Locale)ctx.getLocale()) + settleInfo.getSystemStatus().getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"28_HAS_SETTLED_DATA", (Locale)ctx.getLocale()));
                    settleResultCollection.remove(settleInfo);
                    continue;
                }
                SystemStatusCtrolUtils sscUtils = new SystemStatusCtrolUtils();
                if (!sscUtils.isRelatedAccount(ctx, companyId, settleInfo.getSystemStatus().getName())) continue;
                PeriodInfo glCurPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyInfo);
                PeriodInfo periodInfo = settleInfo.getPeriod();
                if (glCurPeriod == null || periodInfo == null || periodInfo.getPeriodYear() >= glCurPeriod.getPeriodYear() && (periodInfo.getPeriodYear() != glCurPeriod.getPeriodYear() || periodInfo.getPeriodNumber() >= glCurPeriod.getPeriodNumber())) continue;
                msgList.add(EASResource.getString((String)RESOURCE_PATH, (String)"37_UNSETTLED_ERROR", (Object[])new String[]{settleInfo.getCompany().getName(), settleInfo.getSystemStatus().getName().getAlias()}));
                settleResultCollection.remove(settleInfo);
            }
        }
        return msgList;
    }

    private void doAfterSettle(Context ctx, Map<String, Map<String, SystemStatusCtrolInfo>> systemStatusCtrlMap) throws BOSException, EASBizException {
        Set<String> companyIdSet = systemStatusCtrlMap.keySet();
        for (String companyId : companyIdSet) {
            Map<String, SystemStatusCtrolInfo> companyStatusMap = systemStatusCtrlMap.get(companyId);
            for (Map.Entry<String, SystemStatusCtrolInfo> entry : companyStatusMap.entrySet()) {
                SystemStatusCtrolInfo systemStatusInfo = entry.getValue();
                Boolean isExsitUnSettleData = this.isExistUnSettleData(ctx, systemStatusInfo);
                if (isExsitUnSettleData.booleanValue()) continue;
                PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(systemStatusInfo.getCurrentPeriod().getId()));
                if (!systemStatusInfo.isIsStart()) continue;
                systemStatusInfo.setCurrentPeriod(nextPeriod);
                FmSettleResultInfo settleResult = new FmSettleResultInfo();
                settleResult.setCompany(systemStatusInfo.getCompany());
                settleResult.setPeriod(nextPeriod);
                settleResult.setSystemStatus(systemStatusInfo.getSystemStatus());
                settleResult.setSettleStatus(SettleStatusEnum.unSettle);
                FmSettleResultFactory.getLocalInstance(ctx).save((CoreBaseInfo)settleResult);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("currentPeriod"));
                SystemStatusCtrolFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)systemStatusInfo, sic);
            }
        }
    }

    private void doAfterUnSettle(Context ctx, FmSettleResultCollection settleResultCollection) throws BOSException, EASBizException {
        for (int i = 0; i < settleResultCollection.size(); ++i) {
            PeriodInfo nextPeriod;
            FmSettleResultInfo info = settleResultCollection.get(i);
            boolean isExistSettleData = this.isExistSettleData(ctx, info, (nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)info.getPeriod())).getId().toString());
            if (isExistSettleData) continue;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)nextPeriod.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("systemStatus", (Object)info.getSystemStatus().getId().toString(), CompareType.EQUALS));
            FmSettleResultFactory.getLocalInstance(ctx).delete(filter);
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString(), CompareType.INCLUDE));
            filter1.getFilterItems().add(new FilterItemInfo("systemStatus", (Object)info.getSystemStatus().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("isStart", (Object)true, CompareType.EQUALS));
            entity.setFilter(filter1);
            SystemStatusCtrolCollection systemStatusColls = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(entity);
            if (systemStatusColls.size() <= 0) continue;
            SystemStatusCtrolInfo systemStatusInfo = systemStatusColls.get(0);
            systemStatusInfo.setCurrentPeriod(info.getPeriod());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("currentPeriod"));
            SystemStatusCtrolFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)systemStatusInfo, sic);
        }
    }

    private boolean isExistUnSettleData(Context ctx, SystemStatusCtrolInfo statusCtrlInfo) throws BOSException {
        EntityViewInfo entity = new EntityViewInfo();
        entity.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)statusCtrlInfo.getCompany().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)statusCtrlInfo.getCurrentPeriod().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus", (Object)statusCtrlInfo.getSystemStatus().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("settleStatus", (Object)0, CompareType.EQUALS));
        entity.setFilter(filter);
        FmSettleResultCollection settleResultColls = FmSettleResultFactory.getLocalInstance(ctx).getFmSettleResultCollection(entity);
        return settleResultColls != null && settleResultColls.size() != 0;
    }

    private boolean isExistSettleData(Context ctx, FmSettleResultInfo info, String currentPeriod) throws BOSException {
        EntityViewInfo entity = new EntityViewInfo();
        entity.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)currentPeriod, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus", (Object)info.getSystemStatus().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("settleStatus", (Object)1, CompareType.EQUALS));
        entity.setFilter(filter);
        FmSettleResultCollection settleResultColls = FmSettleResultFactory.getLocalInstance(ctx).getFmSettleResultCollection(entity);
        return settleResultColls != null && settleResultColls.size() != 0;
    }

    private void doProcessSettle(Context ctx, FmSettleResultCollection settleResultCollection) throws EASBizException, BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:sss");
        Date now = new Date();
        CoreBaseCollection baseColls = new CoreBaseCollection();
        for (int i = 0; i < settleResultCollection.size(); ++i) {
            FmSettleResultInfo settleResultInfo = settleResultCollection.get(i);
            settleResultInfo.setSettleStatus(SettleStatusEnum.settle);
            settleResultInfo.setSettleTime(now);
            baseColls.add((CoreBaseInfo)settleResultInfo);
        }
        FmSettleResultFactory.getLocalInstance(ctx).update(baseColls);
    }

    private List<String> verifyForSettle(Context ctx, String companyId, FmSettleResultInfo settleInfo, boolean NT011, boolean NT019, boolean NT020) throws BOSException, EASBizException {
        String sql;
        IRowSet set;
        String filter1;
        ArrayList<String> msgList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        PeriodInfo periodInfo = settleInfo.getPeriod();
        Date beginDate = periodInfo.getBeginDate();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = periodInfo.getEndDate();
        endDate = DateHelper.getNextDay((Date)endDate);
        String strBeginDate = sf.format(beginDate);
        String strEndDate = sf.format(endDate);
        SystemStatusInfo statusInfo = settleInfo.getSystemStatus();
        if (NT011 && statusInfo.getName().equals((Object)SystemEnum.NT_MANAGEMENT)) {
            filter1 = " and FTAKEDATE >= {TS '" + strBeginDate + "'} and FTAKEDATE < { TS '" + strEndDate + "'} and (FBillState = 1 or FBillState = 0)";
            String filter2 = " and FISSUEDATE >= {TS '" + strBeginDate + "'} and FISSUEDATE < {TS '" + strEndDate + "'} and (FBillState = 4 or FBillState = 0)";
            buf.append(this.getSql(" T_NT_ReceivableBill ", filter1, "28", companyId, "\u5e94\u6536\u7968\u636e")).append(" union all ");
            buf.append(this.getSql(" T_NT_PayableBill", filter2, "28", companyId, "\u5e94\u4ed8\u7968\u636e")).append(" union all");
        }
        if (NT019 && statusInfo.getName().equals((Object)SystemEnum.NT_MANAGEMENT)) {
            filter1 = " and FEndorseDate >= {TS '" + strBeginDate + "'} and FEndorseDate < {TS '" + strEndDate + "'} and (FState = 1)";
            buf.append(this.getSql(" T_NT_EndorsementBill ", filter1, "28", companyId, "\u80cc\u4e66\u5355")).append(" union all");
        }
        if (NT020 && statusInfo.getName().equals((Object)SystemEnum.NT_MANAGEMENT)) {
            filter1 = " and FDiscountDate >= {TS '" + strBeginDate + "'} and FDiscountDate < {TS '" + strEndDate + "'} and (FBillState = 1)";
            buf.append(this.getSql(" T_NT_DiscountBill ", filter1, "28", companyId, "\u8d34\u73b0\u5355", "FNOTEBILLNUMBER")).append(" union all");
        }
        List<TableModel> list = this.getTable(strBeginDate, strEndDate);
        if (statusInfo.getName().equals((Object)SystemEnum.NT_MANAGEMENT)) {
            for (TableModel tableModel : list) {
                if (!"28".equals(tableModel.getType())) continue;
                if ("T_FIN_ModifyLetter".equals(tableModel.getTableName())) {
                    buf.append(this.getSql("  " + tableModel.getTableName() + "  ", tableModel.getFilter(), tableModel.getType(), companyId, tableModel.getRemark(), "FLETTERNUMBER")).append(" union all");
                    continue;
                }
                buf.append(this.getSql("  " + tableModel.getTableName() + "  ", tableModel.getFilter(), tableModel.getType(), companyId, tableModel.getRemark())).append(" union all");
            }
        }
        if (statusInfo.getName().equals((Object)SystemEnum.FIN_MANAGE)) {
            for (TableModel tableModel : list) {
                if (!"29".equals(tableModel.getType())) continue;
                buf.append(this.getSql("  " + tableModel.getTableName() + "  ", tableModel.getFilter(), tableModel.getType(), companyId, tableModel.getRemark())).append(" union all");
            }
        }
        if (statusInfo.getName().equals((Object)SystemEnum.IVT_MANAGE)) {
            for (TableModel tableModel : list) {
                if (!"30".equals(tableModel.getType())) continue;
                buf.append(this.getSql("  " + tableModel.getTableName() + "  ", tableModel.getFilter(), tableModel.getType(), companyId, tableModel.getRemark())).append(" union all");
            }
        }
        if (statusInfo.getName().equals((Object)SystemEnum.CTL_MANAGE)) {
            for (TableModel tableModel : list) {
                if (!"31".equals(tableModel.getType())) continue;
                if ("T_CTL_BankFactor".equals(tableModel.getTableName())) {
                    buf.append(this.getSql("  " + tableModel.getTableName() + "  ", tableModel.getFilter(), tableModel.getType(), companyId, tableModel.getRemark(), "fnumber", "FFICompanyID")).append(" union all");
                    continue;
                }
                buf.append(this.getSql("  " + tableModel.getTableName() + "  ", tableModel.getFilter(), tableModel.getType(), companyId, tableModel.getRemark())).append(" union all");
            }
        }
        if (!EmptyUtil.isEmpty((Object)buf) && buf.length() > 10 && (set = DbUtil.executeQuery((Context)ctx, (String)(sql = buf.substring(0, buf.length() - 10)))) != null) {
            try {
                while (set.next()) {
                    String number = set.getString("FNUMBER");
                    String type = set.getString("type");
                    String tableName = set.getString("tableName");
                    String remark = set.getString("remark");
                    msgList.add(SystemEnum.getEnum((int)Integer.parseInt(type)).getAlias() + "  " + remark + "  " + number);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return msgList;
    }

    private List<TableModel> getTable(String strBeginDate, String strEndDate) {
        ArrayList<TableModel> list = new ArrayList<TableModel>();
        TableModel model1 = new TableModel();
        model1.setTableName("T_FIN_Repayment");
        model1.setType("28");
        model1.setFilter(" and FSourceType =2 and  FBizDate >= {TS '" + strBeginDate + "'} and FBizDate < { TS '" + strEndDate + "'}  and (FStatusExtEnum=-1 or FStatusExtEnum=0)");
        model1.setRemark("\u5e94\u4ed8\u7968\u636e\u5151\u4ed8\u67e5\u8be2");
        TableModel model2 = new TableModel();
        model2.setTableName("T_NT_BankDraft");
        model2.setType("28");
        model2.setFilter(" and FPayerDate >= {TS '" + strBeginDate + "'} and FPayerDate < { TS '" + strEndDate + "'}  and (FBillState=1 or FBillState=2)");
        model2.setRemark("\u94f6\u884c\u6c47\u7968");
        TableModel model3 = new TableModel();
        model3.setTableName("T_FIN_LetterOfCredit");
        model3.setType("28");
        model3.setFilter(" and FISSUEDATE >= {TS '" + strBeginDate + "'} and FISSUEDATE < { TS '" + strEndDate + "'}  and (FOperateStatus=5 or FOperateStatus=6)");
        model3.setRemark("\u4fe1\u7528\u8bc1");
        TableModel model4 = new TableModel();
        model4.setTableName("T_FIN_LetOfCreditAcctRecord");
        model4.setType("28");
        model4.setFilter(" and FBizDate >= {TS '" + strBeginDate + "'} and FBizDate < { TS '" + strEndDate + "'}  and (FBillState='submited' or FBillState is null)");
        model4.setRemark("\u4fe1\u7528\u8bc1\u627f\u5151");
        TableModel model5 = new TableModel();
        model5.setTableName("T_FIN_Repayment");
        model5.setType("28");
        model5.setFilter(" and FSourceType =3 and FIsDirect = 0 and fbizdate >= {TS '" + strBeginDate + "'} and fbizdate < { TS '" + strEndDate + "'}  and (FStatusExtEnum=0)");
        model5.setRemark("\u4fe1\u7528\u8bc1-\u8fd8\u6b3e\u5904\u7406");
        TableModel model6 = new TableModel();
        model6.setTableName("T_FIN_ModifyLetter");
        model6.setType("28");
        model6.setFilter(" and FModifyDate >= {TS '" + strBeginDate + "'} and FModifyDate < { TS '" + strEndDate + "'}  and (FBillStatus=1 or FBillStatus=2)");
        model6.setRemark("\u6539\u8bc1");
        TableModel model7 = new TableModel();
        model7.setTableName("T_NT_LetterOfCreditReceive");
        model7.setType("28");
        model7.setFilter(" and FIssureDate >= {TS '" + strBeginDate + "'} and FIssureDate < { TS '" + strEndDate + "'}  and (FBillstate=0 or FBillstate=1)");
        model7.setRemark("\u4fe1\u7528\u8bc1\u6536\u8bc1");
        TableModel model8 = new TableModel();
        model8.setTableName("T_CL_ConsignmentLoanBill");
        model8.setType("29");
        model8.setFilter(" and FEffectiveDate >= {TS '" + strBeginDate + "'} and FEffectiveDate < { TS '" + strEndDate + "'}  and (FState=1 or FState=0)");
        model8.setRemark("\u59d4\u6258\u8d37\u6b3e\u5355");
        TableModel model9 = new TableModel();
        model9.setTableName("T_CL_ConsignLoanIntBill");
        model9.setType("29");
        model9.setFilter(" and FEndDate >= {TS '" + strBeginDate + "'} and FEndDate < { TS '" + strEndDate + "'}  and (FEffectedStatus=1 or FEffectedStatus=0)");
        model9.setRemark("\u59d4\u6258\u8d37\u6b3e\u5229\u606f\u5355");
        TableModel model10 = new TableModel();
        model10.setTableName("T_FT_FundTransferBill");
        model10.setType("29");
        model10.setFilter(" and FEffectiveDate >= {TS '" + strBeginDate + "'} and FEffectiveDate < { TS '" + strEndDate + "'}  and (FStatus=1 or FStatus=0)");
        model10.setRemark("\u8d44\u91d1\u5f80\u6765\u5355");
        TableModel model11 = new TableModel();
        model11.setTableName("T_FT_FundTransferRepayBill");
        model11.setType("29");
        model11.setFilter(" and FRepayDate >= {TS '" + strBeginDate + "'} and FRepayDate < { TS '" + strEndDate + "'}  and (FState=1 or FState=0)");
        model11.setRemark("\u8d44\u91d1\u5f80\u6765\u8fd8\u6b3e\u5355");
        TableModel model12 = new TableModel();
        model12.setTableName("T_FT_FundTransferInterestBill");
        model12.setType("29");
        model12.setFilter(" and FEndDate >= {TS '" + strBeginDate + "'} and FEndDate < { TS '" + strEndDate + "'}  and (FEffectedStatus=1 or FEffectedStatus=0)");
        model12.setRemark("\u8d44\u91d1\u5f80\u6765\u5229\u606f\u5355");
        TableModel model13 = new TableModel();
        model13.setTableName("T_FIN_FinancingFeeBill");
        model13.setType("30");
        model13.setFilter(" and FBIZDATE >= {TS '" + strBeginDate + "'} and FBIZDATE < { TS '" + strEndDate + "'}  and (FState=1 or FState=2)");
        model13.setRemark("\u878d\u8d44\u8d39\u7528");
        TableModel model14 = new TableModel();
        model14.setTableName("T_FIN_UnTimeDepositBill");
        model14.setType("30");
        model14.setFilter(" and FUNTIMEDATE >= {TS '" + strBeginDate + "'} and FUNTIMEDATE < { TS '" + strEndDate + "'}  and (FStatus=1 or FStatus=2) ");
        model14.setRemark("\u4f01\u4e1a\u5b9a\u671f\u5b58\u6b3e\u89e3\u6d3b\u5355");
        TableModel model15 = new TableModel();
        model15.setTableName("T_FIN_CompDepositAccountBill");
        model15.setType("30");
        model15.setFilter(" and FEffectiveDate >= {TS '" + strBeginDate + "'} and FEffectiveDate < { TS '" + strEndDate + "'}  and (FEffectedStatus=1 or FEffectedStatus=2)");
        model15.setRemark("\u4f01\u4e1a\u5b9a\u671f\u5b58\u6b3e\u5355");
        TableModel model16 = new TableModel();
        model16.setTableName("T_CTL_LetterOfGuarantee");
        model16.setType("31");
        model16.setFilter(" and FIssueDate >= {TS '" + strBeginDate + "'} and FIssueDate < { TS '" + strEndDate + "'}  and (FState=1 or FState=0)");
        model16.setRemark("\u94f6\u884c\u4fdd\u51fd\u5f00\u51fd");
        TableModel model17 = new TableModel();
        model17.setTableName("T_CTL_LetOfGuarantee");
        model17.setType("31");
        model17.setFilter(" and FBizdate >= {TS '" + strBeginDate + "'} and FBizdate < { TS '" + strEndDate + "'} and FAUDITORID is  null ");
        model17.setRemark("\u94f6\u884c\u4fdd\u51fd\u6539\u51fd");
        TableModel model18 = new TableModel();
        model18.setTableName("T_FIN_Repayment");
        model18.setType("31");
        model18.setFilter(" and FSourceType =4 and FENDDATE >= {TS '" + strBeginDate + "'} and FENDDATE < { TS '" + strEndDate + "'}  and (FStatusExtEnum=-1 or FStatusExtEnum=0)");
        model18.setRemark("\u94f6\u884c\u4fdd\u51fd-\u5f00\u51fd\u7d22\u8d54");
        TableModel model19 = new TableModel();
        model19.setTableName("T_CTL_ReceiveLetter");
        model19.setType("31");
        model19.setFilter(" and FIssueDate >= {TS '" + strBeginDate + "'} and FIssueDate < { TS '" + strEndDate + "'}  and (FState=1 or FState=0)");
        model19.setRemark("\u94f6\u884c\u4fdd\u51fd\u6536\u51fd");
        TableModel model20 = new TableModel();
        model20.setTableName("T_CTL_ReceiveRepay");
        model20.setType("31");
        model20.setFilter(" and FSuoDate >= {TS '" + strBeginDate + "'} and FSuoDate < { TS '" + strEndDate + "'}  and (FState=1)");
        model20.setRemark("\u6536\u51fd\u7d22\u8d54");
        TableModel model21 = new TableModel();
        model21.setTableName("T_CTL_BankFactor");
        model21.setType("31");
        model21.setFilter(" and FIssueDate >= {TS '" + strBeginDate + "'} and FIssueDate < { TS '" + strEndDate + "'}  and (FState=0 or FState=1)");
        model21.setRemark("\u94f6\u884c\u4fdd\u7406");
        TableModel model22 = new TableModel();
        model22.setTableName("T_CTL_AssureBill");
        model22.setType("31");
        model22.setFilter(" and FBeginDate >= {TS '" + strBeginDate + "'} and FBeginDate < { TS '" + strEndDate + "'}  and (FState=1 or FState=0)");
        model22.setRemark("\u62c5\u4fdd\u5355");
        TableModel model23 = new TableModel();
        model23.setTableName("T_FIN_Loan");
        model23.setType("30");
        model23.setFilter(" and FIssueDate >= {TS '" + strBeginDate + "'} and FIssueDate < { TS '" + strEndDate + "'}  and (FStatus=1 or FStatus=0)");
        model23.setRemark("\u501f\u6b3e");
        TableModel model24 = new TableModel();
        model24.setTableName("T_IVT_FinancingAccount");
        model24.setType("29");
        model24.setFilter(" and FBeginDate >= {TS '" + strBeginDate + "'} and FBeginDate < { TS '" + strEndDate + "'}  and (FState=1)");
        model24.setRemark("\u91d1\u878d\u7406\u8d22\u53f0\u8d26");
        TableModel model25 = new TableModel();
        model25.setTableName("T_FIN_Wage");
        model25.setType("30");
        model25.setFilter(" and FIssueDate >= {TS '" + strBeginDate + "'} and FIssueDate < { TS '" + strEndDate + "'}  and (FBillStatus=1)");
        model25.setRemark("\u62b5(\u8d28)\u62bc\u7269\u5355");
        TableModel model26 = new TableModel();
        model26.setTableName("T_FIN_LoanInterest");
        model26.setType("30");
        model26.setFilter(" and  FIsPrediction = 0 and FEndDate >= {TS '" + strBeginDate + "'} and FEndDate < { TS '" + strEndDate + "'}  and (FStatusExtEnum=0 or FStatusExtEnum=-1)");
        model26.setRemark("\u501f\u6b3e\u5229\u606f\u5355");
        TableModel model27 = new TableModel();
        model27.setTableName("T_FIN_CreditLimit");
        model27.setType("30");
        model27.setFilter(" and FIssueDate >= {TS '" + strBeginDate + "'} and FIssueDate < { TS '" + strEndDate + "'}  and (FBillStatus=0)");
        model27.setRemark("\u6388\u4fe1\u989d\u5ea6");
        TableModel model28 = new TableModel();
        model28.setTableName("T_IVT_ChLoan");
        model28.setType("29");
        model28.setFilter(" and FStartDate >= {TS '" + strBeginDate + "'} and FStartDate < { TS '" + strEndDate + "'}  and (FBillStatus=1 or FBillStatus=2 or FBillStatus=3)");
        model28.setRemark("\u4f01\u4e1a\u8d37\u6b3e");
        TableModel model29 = new TableModel();
        model29.setTableName("T_CL_ConsingnRepaymentBill");
        model29.setType("29");
        model29.setFilter(" and FRepayDate >= {TS '" + strBeginDate + "'} and FRepayDate < { TS '" + strEndDate + "'}  and (FState=1 or FState=0)");
        model29.setRemark("\u59d4\u6258\u8d37\u6b3e\u8fd8\u6b3e");
        TableModel model30 = new TableModel();
        model30.setTableName("T_IVT_EntRepaymentBill");
        model30.setType("29");
        model30.setFilter(" and FRepayDate >= {TS '" + strBeginDate + "'} and FRepayDate < { TS '" + strEndDate + "'}  and (FBillStatus=1 or FBillStatus=2 or FBillStatus=3)");
        model30.setRemark("\u4f01\u4e1a\u8fd8\u6b3e\u5355");
        TableModel model31 = new TableModel();
        model31.setTableName("T_FIN_Repayment");
        model31.setType("30");
        model31.setFilter(" and FSourceType =1 and  FBizDate >= {TS '" + strBeginDate + "'} and FBizDate < { TS '" + strEndDate + "'}  and (FStatusExtEnum=-1 or FStatusExtEnum=0)");
        model31.setRemark("\u501f\u6b3e\u8fd8\u6b3e");
        list.add(model1);
        list.add(model2);
        list.add(model3);
        list.add(model4);
        list.add(model5);
        list.add(model6);
        list.add(model7);
        list.add(model8);
        list.add(model9);
        list.add(model10);
        list.add(model11);
        list.add(model12);
        list.add(model13);
        list.add(model14);
        list.add(model15);
        list.add(model16);
        list.add(model17);
        list.add(model18);
        list.add(model19);
        list.add(model20);
        list.add(model21);
        list.add(model22);
        list.add(model23);
        list.add(model24);
        list.add(model25);
        list.add(model26);
        list.add(model27);
        list.add(model28);
        list.add(model29);
        list.add(model30);
        list.add(model31);
        return list;
    }

    private String getSql(String tableName, String filter, String type, String companyId, String remark) {
        String sql = " SELECT FNUMBER," + type + " as type ,'" + tableName + "' as tableName ,'" + remark + "' as remark from " + tableName + " where fcompanyid = '" + companyId + "'" + filter;
        return sql;
    }

    private String getSql(String tableName, String filter, String type, String companyId, String remark, String colName) {
        String sql = " SELECT " + colName + " as fnumber," + type + " as type ,'" + tableName + "' as tableName ,'" + remark + "' as remark from " + tableName + " where fcompanyid = '" + companyId + "'" + filter;
        return sql;
    }

    private String getSql(String tableName, String filter, String type, String companyId, String remark, String colName, String colCompany) {
        String sql = " SELECT " + colName + " as fnumber," + type + " as type ,'" + tableName + "' as tableName ,'" + remark + "' as remark from " + tableName + " where " + colCompany + " = '" + companyId + "'" + filter;
        return sql;
    }

    private void doProcessUnSettle(Context ctx, FmSettleResultCollection settleResultCollection) throws EASBizException, BOSException {
        CoreBaseCollection baseColls = new CoreBaseCollection();
        for (int i = 0; i < settleResultCollection.size(); ++i) {
            FmSettleResultInfo settleResultInfo = settleResultCollection.get(i);
            settleResultInfo.setSettleStatus(SettleStatusEnum.unSettle);
            settleResultInfo.setSettleTime(null);
            settleResultInfo.setSettleRemark(null);
            baseColls.add((CoreBaseInfo)settleResultInfo);
        }
        FmSettleResultFactory.getLocalInstance(ctx).update(baseColls);
    }

    private List<String> verifyForSettle(Context ctx, Map<String, Map<String, FmSettleResultInfo>> map, Map<String, Map<String, SystemStatusCtrolInfo>> systemStatusCtrlMap, FmSettleResultCollection settleResultCollection) throws BOSException, EASBizException {
        List<String> msgList = new ArrayList<String>();
        Set<String> companyIdSet = map.keySet();
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        for (String companyId : companyIdSet) {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), "FMSETTLE_02SETTLE");
            if (!isPermission) {
                msgList.add(EASCommonResource.getString((String)RESOURCE_PATH, (String)"23_NOT_HAVE", (Locale)ctx.getLocale()) + companyInfo.getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"29_SETTLED_PERM", (Locale)ctx.getLocale()));
                Map<String, FmSettleResultInfo> settleResultMap = map.get(companyId);
                Set<String> settleResultIdSet = settleResultMap.keySet();
                for (String id : settleResultIdSet) {
                    FmSettleResultInfo settleInfo = settleResultMap.get(id);
                    settleResultCollection.remove(settleInfo);
                }
                continue;
            }
            Map<String, SystemStatusCtrolInfo> companySystemStatusCtrlMap = systemStatusCtrlMap.get(companyId);
            Map<String, FmSettleResultInfo> settleResultMap = map.get(companyId);
            Set<String> settleResultIdSet = settleResultMap.keySet();
            boolean val = contextHelper.getBooleanParam("FMJZ002", (IObjectPK)new ObjectUuidPK(companyId));
            boolean NT011 = contextHelper.getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(companyId));
            boolean NT019 = contextHelper.getBooleanParam("NT019", (IObjectPK)new ObjectUuidPK(companyId));
            boolean NT020 = contextHelper.getBooleanParam("FMJZ001", (IObjectPK)new ObjectUuidPK(companyId));
            for (String id : settleResultIdSet) {
                FmSettleResultInfo settleInfo = settleResultMap.get(id);
                SystemStatusCtrolInfo systemStatusCtrlInfo = companySystemStatusCtrlMap.get(settleInfo.getSystemStatus().getId().toString());
                if (settleInfo.getSettleStatus() == SettleStatusEnum.settle) {
                    msgList.add(settleInfo.getCompany().getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"25_PERIOD", (Locale)ctx.getLocale()) + settleInfo.getPeriod().getDescription() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"26_MODULE", (Locale)ctx.getLocale()) + settleInfo.getSystemStatus().getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"30_HAS_SETTLED", (Locale)ctx.getLocale()));
                    settleResultCollection.remove(settleInfo);
                    continue;
                }
                if (!settleInfo.getPeriod().getId().toString().equals(systemStatusCtrlInfo.getCurrentPeriod().getId().toString())) {
                    settleResultCollection.remove(settleInfo);
                    msgList.add(settleInfo.getCompany().getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"25_PERIOD", (Locale)ctx.getLocale()) + settleInfo.getPeriod().getDescription() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"26_MODULE", (Locale)ctx.getLocale()) + settleInfo.getSystemStatus().getName() + EASCommonResource.getString((String)RESOURCE_PATH, (String)"31_PREPERIOD_UNSETTLED", (Locale)ctx.getLocale()));
                    continue;
                }
                List<Object> list = new ArrayList();
                if (val) {
                    list = this.verifyForSettle(ctx, companyId, settleInfo, NT011, NT019, NT020);
                }
                if (!EmptyUtil.isEmpty(list)) {
                    msgList.addAll(list);
                    settleResultCollection.remove(settleInfo);
                    continue;
                }
                boolean isNeedRecon = contextHelper.getBooleanParam("FMJZ002", (IObjectPK)new ObjectUuidPK(settleInfo.getCompany().getId().toString()));
                if (isNeedRecon) {
                    ISipgFmReconFacade fmReconFacade = SipgFmReconFacadeFactory.getLocalInstance(ctx);
                    msgList = fmReconFacade.settleRecon(msgList, settleInfo, settleResultCollection);
                    continue;
                }
                settleInfo.setSettleRemark(null);
            }
        }
        return msgList;
    }

    private Map<String, Map<String, FmSettleResultInfo>> proccessSettleResultCollection(FmSettleResultCollection settleResultCollection) {
        HashMap<String, Map<String, FmSettleResultInfo>> map = new HashMap<String, Map<String, FmSettleResultInfo>>();
        for (int i = 0; i < settleResultCollection.size(); ++i) {
            FmSettleResultInfo info = settleResultCollection.get(i);
            String companyId = info.getCompany().getId().toString();
            HashMap<String, FmSettleResultInfo> settleResultMap = (HashMap<String, FmSettleResultInfo>)map.get(companyId);
            if (settleResultMap == null) {
                settleResultMap = new HashMap<String, FmSettleResultInfo>();
                map.put(companyId, settleResultMap);
            }
            settleResultMap.put(info.getId().toString(), info);
        }
        return map;
    }

    private FmSettleResultCollection getFmSettleResultCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entity = new EntityViewInfo();
        entity.getSelector().add(new SelectorItemInfo("*"));
        entity.getSelector().add(new SelectorItemInfo("company.id"));
        entity.getSelector().add(new SelectorItemInfo("company.name"));
        entity.getSelector().add(new SelectorItemInfo("company.number"));
        entity.getSelector().add(new SelectorItemInfo("company.CU.id"));
        entity.getSelector().add(new SelectorItemInfo("company.baseCurrency.*"));
        entity.getSelector().add(new SelectorItemInfo("period.id"));
        entity.getSelector().add(new SelectorItemInfo("period.description"));
        entity.getSelector().add(new SelectorItemInfo("period.beginDate"));
        entity.getSelector().add(new SelectorItemInfo("period.endDate"));
        entity.getSelector().add(new SelectorItemInfo("period.periodYear"));
        entity.getSelector().add(new SelectorItemInfo("period.periodNumber"));
        entity.getSelector().add(new SelectorItemInfo("period.number"));
        entity.getSelector().add(new SelectorItemInfo("systemStatus.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        return FmSettleResultFactory.getLocalInstance(ctx).getFmSettleResultCollection(entity);
    }

    private Map<String, Map<String, SystemStatusCtrolInfo>> getSystemStatusCtrlCollection(Context ctx, Set companyIdSet) throws BOSException {
        EntityViewInfo entity = new EntityViewInfo();
        entity.getSelector().add(new SelectorItemInfo("id"));
        entity.getSelector().add(new SelectorItemInfo("systemStatus"));
        entity.getSelector().add(new SelectorItemInfo("isStart"));
        entity.getSelector().add(new SelectorItemInfo("startPeriod"));
        entity.getSelector().add(new SelectorItemInfo("currentPeriod"));
        entity.getSelector().add(new SelectorItemInfo("isRelatedAccount"));
        entity.getSelector().add(new SelectorItemInfo("relatedPeriod"));
        entity.getSelector().add(new SelectorItemInfo("company"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)28, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)29, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)30, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)31, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)true, CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2 or #3 or #4) and #5");
        entity.setFilter(filter);
        SystemStatusCtrolCollection systemStatusCtrolColl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(entity);
        HashMap<String, Map<String, SystemStatusCtrolInfo>> map = new HashMap<String, Map<String, SystemStatusCtrolInfo>>();
        for (int i = 0; i < systemStatusCtrolColl.size(); ++i) {
            SystemStatusCtrolInfo info = systemStatusCtrolColl.get(i);
            String companyId = info.getCompany().getId().toString();
            HashMap<String, SystemStatusCtrolInfo> SystemStatusCtrolMap = (HashMap<String, SystemStatusCtrolInfo>)map.get(companyId);
            if (SystemStatusCtrolMap == null) {
                SystemStatusCtrolMap = new HashMap<String, SystemStatusCtrolInfo>();
                map.put(companyId, SystemStatusCtrolMap);
            }
            SystemStatusCtrolMap.put(info.getSystemStatus().getId().toString(), info);
        }
        return map;
    }
}

