/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillCollection;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyBase;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SipgConsignLoanStrategy
extends SipgFmReconStrategyBase
implements ISipgFmReconStrategy {
    @Override
    public List _getReconResult(Context ctx, HashMap hmParams) {
        if (!this.initParams(hmParams)) {
            return null;
        }
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < reconMapping.getEntrys().size(); ++i) {
            ArrayList results = new ArrayList();
            SipgFmReconMappingEntryInfo mappingEntry = reconMapping.getEntrys().get(i);
            String fmNumber = null;
            String fmName = null;
            String glNumber = null;
            String glName = null;
            try {
                this.baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()));
                FinancingProductsInfo productsInfo = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getProducts().getId()));
                fmNumber = productsInfo.getNumber();
                fmName = productsInfo.getName();
                AccountViewCollection accountViewCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection("select * where id='" + mappingEntry.getAccount().getId().toString() + "'");
                if (accountViewCollection.size() > 0) {
                    AccountViewInfo accountViewInfo = accountViewCollection.get(0);
                    glNumber = accountViewInfo.getNumber();
                    glName = accountViewInfo.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap currencyMap = this.getCurrencyFmEnd(ctx, mappingEntry);
            for (CurrencyInfo cur : currencyMap.keySet()) {
                HashMap fmIncDec = (HashMap)currencyMap.get(cur);
                HashMap<String, Object> hmResult = this.getReturnValue(ctx, fmNumber, fmName, glNumber, glName, fmIncDec, cur, mappingEntry);
                result.add(hmResult);
            }
        }
        return result;
    }

    private HashMap getCurrencyFmEnd(Context ctx, SipgFmReconMappingEntryInfo mappingEntry) {
        String productsId = mappingEntry.getProducts().getId().toString();
        Date bizDateStart = reconPeriod.getBeginDate();
        Timestamp bizDateEnd = reconPeriod.getEndDate();
        Date date = new Date();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.currentCompany.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("loan.finacingProduct", (Object)productsId, CompareType.EQUALS));
        filter.getFilterItems().add(this.getDirectionFilter());
        try {
            ConsignLoanIntBillCollection cIntBillCol = ConsignLoanIntBillFactory.getLocalInstance((Context)ctx).getConsignLoanIntBillCollection(evi);
            HashMap hmTDB = new HashMap();
            for (int i = 0; i < cIntBillCol.size(); ++i) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                ConsignLoanIntBillInfo cIntBillInfo = cIntBillCol.get(i);
                HashMap hmIncDec = this.getFmIncDec(ctx, mappingEntry, directionInfo, bizDateStart, bizDateEnd, cIntBillInfo.getCurrency(), cIntBillInfo);
                BigDecimal bdIncs = (BigDecimal)hmIncDec.get("endIncrease");
                BigDecimal bdDecs = (BigDecimal)hmIncDec.get("endDecrease");
                BigDecimal fmEnd = bdIncs.subtract(bdDecs);
                BigDecimal fmInc = (BigDecimal)hmIncDec.get("fmIncrease");
                BigDecimal fmDec = (BigDecimal)hmIncDec.get("fmDecrease");
                BigDecimal fmBegin = fmEnd.add(fmDec).subtract(fmInc);
                hmTDB_Detail.put("fmBegin", fmBegin);
                hmTDB_Detail.put("fmIncrease", fmInc);
                hmTDB_Detail.put("fmDecrease", fmDec);
                hmTDB_Detail.put("fmEnd", fmEnd);
                if (hmTDB.containsKey(this.baseCurrency)) {
                    HashMap hashMap = (HashMap)hmTDB.get(this.baseCurrency);
                    BigDecimal fmsBegin = (BigDecimal)hashMap.get("fmBegin");
                    BigDecimal fmsIncrease = (BigDecimal)hashMap.get("fmIncrease");
                    BigDecimal fmsDecrease = (BigDecimal)hashMap.get("fmDecrease");
                    BigDecimal fmsEnd = (BigDecimal)hashMap.get("fmEnd");
                    hmTDB_Detail.put("fmBegin", fmsBegin.add(fmBegin));
                    hmTDB_Detail.put("fmIncrease", fmsIncrease.add(fmInc));
                    hmTDB_Detail.put("fmDecrease", fmsDecrease.add(fmDec));
                    hmTDB_Detail.put("fmEnd", fmsEnd.add(fmEnd));
                    hmTDB.put(this.baseCurrency, hmTDB_Detail);
                    continue;
                }
                hmTDB.put(this.baseCurrency, hmTDB_Detail);
            }
            if (cIntBillCol.size() == 0) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                hmTDB_Detail.put("fmBegin", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmIncrease", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmDecrease", new BigDecimal("0.00"));
                hmTDB_Detail.put("fmEnd", new BigDecimal("0.00"));
                hmTDB.put(this.baseCurrency, hmTDB_Detail);
            }
            return hmTDB;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getFmIncDec(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, CurrencyInfo currency, ConsignLoanIntBillInfo consignLoanIntBillInfo) {
        try {
            HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
            BigDecimal fmIncrease = new BigDecimal("0.00");
            fmIncrease = fmIncrease.setScale(this.persion);
            BigDecimal fmDecrease = new BigDecimal("0.00");
            fmDecrease = fmDecrease.setScale(this.persion);
            BigDecimal bdIncrease = new BigDecimal("0.00");
            bdIncrease = bdIncrease.setScale(this.persion);
            BigDecimal bdDecrease = new BigDecimal("0.00");
            bdDecrease = bdDecrease.setScale(this.persion);
            String direction = null;
            boolean ispred = this.IsInPeriod(consignLoanIntBillInfo.getBizDate());
            switch (consignLoanIntBillInfo.getIntCalType().getValue()) {
                case 0: {
                    direction = this.getDirectionType(directionInfo, 0);
                    break;
                }
                case 1: {
                    direction = this.getDirectionType(directionInfo, 1);
                    break;
                }
                case 2: {
                    direction = this.getDirectionType(directionInfo, 2);
                }
            }
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(consignLoanIntBillInfo.getShijiIntAmt());
                if (ispred) {
                    fmIncrease = fmIncrease.add(consignLoanIntBillInfo.getShijiIntAmt());
                }
            } else if (direction == "decrease") {
                bdDecrease = bdDecrease.add(consignLoanIntBillInfo.getShijiIntAmt());
                if (ispred) {
                    fmDecrease = fmDecrease.add(consignLoanIntBillInfo.getShijiIntAmt());
                }
            }
            hashmap.put("fmIncrease", fmIncrease);
            hashmap.put("fmDecrease", fmDecrease);
            hashmap.put("endIncrease", bdIncrease);
            hashmap.put("endDecrease", bdDecrease);
            return hashmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean IsInPeriod(Date bizDate) {
        if (bizDate == reconPeriod.getEndDate() || bizDate == reconPeriod.getBeginDate()) {
            return true;
        }
        return !bizDate.after(reconPeriod.getEndDate()) && !bizDate.before(reconPeriod.getBeginDate());
    }

    private FilterItemInfo getDirectionFilter() {
        HashSet<Integer> state = new HashSet<Integer>();
        FilterItemInfo itemInfo = new FilterItemInfo();
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        for (int i = 0; i < directionEntryCollection.size(); ++i) {
            SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
            if (entryInfo.getStatusName().equals("\u9884\u63d0") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(0);
                continue;
            }
            if (entryInfo.getStatusName().equals("\u6536\u606f") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(1);
                continue;
            }
            if (!entryInfo.getStatusName().equals("\u8fd8\u672c\u4ed8\u606f") || entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) continue;
            state.add(2);
        }
        if (state.size() > 0) {
            itemInfo = new FilterItemInfo("intCalType", state, CompareType.INCLUDE);
        } else {
            state.add(10);
            itemInfo = new FilterItemInfo("intCalType", state, CompareType.INCLUDE);
        }
        return itemInfo;
    }

    private String getDirectionType(SipgFmReconDirectionInfo directionInfo2, int i) {
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
        if (entryInfo.getCashflow() == SipgFmCashflow.increase) {
            return "increase";
        }
        if (entryInfo.getCashflow() == SipgFmCashflow.none) {
            return "none";
        }
        return "decrease";
    }
}

