/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ivt.FinanceFinancingFactory;
import com.kingdee.eas.fm.ivt.FinanceFinancingInfo;
import com.kingdee.eas.fm.ivt.FinancingAccountCollection;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemCollection;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.ivt.FinancingStateEnum;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SipgFinancingAccountStrategy
extends SipgFmReconStrategyBase
implements ISipgFmReconStrategy {
    private static final long serialVersionUID = 5895417043005400193L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> _getReconResult(Context ctx, HashMap hmParams) {
        if (!this.initParams(hmParams)) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int i = 0;
        int count = reconMapping.getEntrys().size();
        while (true) {
            HashMap<String, BigDecimal> hmTDB_Detail;
            HashSet<CurrencyInfo> currencyId;
            HashMap<CurrencyInfo, Map<String, BigDecimal>> currencyMap;
            String glName;
            String glNumber;
            String fmName;
            String fmNumber;
            SipgFmReconMappingEntryInfo mappingEntry;
            block16: {
                if (i >= count) {
                    return result;
                }
                mappingEntry = reconMapping.getEntrys().get(i);
                fmNumber = null;
                fmName = null;
                glNumber = null;
                glName = null;
                try {
                    FinanceFinancingInfo financeFinancingInfo = FinanceFinancingFactory.getLocalInstance((Context)ctx).getFinanceFinancingInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getFinanceFinancing().getId()));
                    fmNumber = financeFinancingInfo.getNumber();
                    fmName = financeFinancingInfo.getName();
                    AccountViewCollection accountViewCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection("select name, number where id='" + mappingEntry.getAccount().getId().toString() + "'");
                    if (accountViewCollection.size() > 0) {
                        AccountViewInfo accountViewInfo = accountViewCollection.get(0);
                        glNumber = accountViewInfo.getNumber();
                        glName = accountViewInfo.getName();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HashSet currencyIds = (HashSet)hmParams.get("currencyIds");
                currencyMap = this.getCurrencyFmEnd(ctx, mappingEntry, currencyIds);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("account.number", glNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("account.name", glName, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("sourceSys", (Object)6, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)5, CompareType.EQUALS));
                ev.getSelector().add(new SelectorItemInfo("currency.id"));
                ev.setFilter(filter);
                IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gl.app.VoucherEntryQuery");
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
                exec.setObjectView(ev);
                currencyId = null;
                hmTDB_Detail = new HashMap<String, BigDecimal>();
                BigDecimal value = new BigDecimal("0.00");
                hmTDB_Detail.put("fmBegin", value);
                hmTDB_Detail.put("fmIncrease", value);
                hmTDB_Detail.put("fmDecrease", value);
                hmTDB_Detail.put("fmEnd", value);
                try {
                    IRowSet rs = exec.executeQuery();
                    if (rs.size() <= 0) break block16;
                    currencyId = new HashSet<CurrencyInfo>();
                    CurrencyInfo currencyInfo = null;
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    try {
                        while (rs.next()) {
                            String id = rs.getString("currency.id");
                            try {
                                currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id), sic);
                                if (currencyInfo == null) continue;
                                currencyId.add(currencyInfo);
                            }
                            catch (EASBizException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (!EmptyUtil.isEmpty(currencyId)) {
                for (CurrencyInfo info : currencyId) {
                    if (currencyMap.containsKey(info)) continue;
                    currencyMap.put(info, hmTDB_Detail);
                }
            }
            for (CurrencyInfo cur : currencyMap.keySet()) {
                HashMap fmIncDec = (HashMap)currencyMap.get(cur);
                HashMap<String, Object> hmResult = this.getReturnValue(ctx, fmNumber, fmName, glNumber, glName, fmIncDec, cur, mappingEntry);
                result.add(hmResult);
            }
            ++i;
        }
    }

    private HashMap<CurrencyInfo, Map<String, BigDecimal>> getCurrencyFmEnd(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, Set currencyIds) {
        Date bizDateStart = reconPeriod.getBeginDate();
        Timestamp bizDateEnd = reconPeriod.getEndDate();
        CurrencyInfo originalCurrency = null;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.number"));
        evi.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.currentCompany.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(this.getMappingFilter(mappingEntry));
        if (!EmptyUtil.isEmpty((Collection)currencyIds)) {
            filter.getFilterItems().add(new FilterItemInfo("Currency.id", (Object)currencyIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(this.getDirectionFilter());
        try {
            FinancingAccountCollection coll = FinancingAccountFactory.getLocalInstance((Context)ctx).getFinancingAccountCollection(evi);
            HashMap<CurrencyInfo, Map<String, BigDecimal>> hmTDB = new HashMap<CurrencyInfo, Map<String, BigDecimal>>();
            int count = coll.size();
            for (int i = 0; i < count; ++i) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                FinancingAccountInfo info = coll.get(i);
                originalCurrency = info.getCurrency();
                HashMap hmIncDec = this.getFmIncDec(ctx, mappingEntry, directionInfo, bizDateStart, bizDateEnd, info.getCurrency(), info);
                BigDecimal bdIncs = (BigDecimal)hmIncDec.get("endIncrease");
                BigDecimal bdDecs = (BigDecimal)hmIncDec.get("endDecrease");
                BigDecimal fmEnd = bdIncs.subtract(bdDecs);
                BigDecimal fmInc = (BigDecimal)hmIncDec.get("fmIncrease");
                BigDecimal fmDec = (BigDecimal)hmIncDec.get("fmDecrease");
                BigDecimal fmBegin = fmEnd.add(fmDec).subtract(fmInc);
                hmTDB_Detail.put("fmBegin", fmBegin);
                hmTDB_Detail.put("fmIncrease", fmInc);
                hmTDB_Detail.put("fmDecrease", fmDec);
                hmTDB_Detail.put("fmEnd", fmEnd);
                if (hmTDB.containsKey(originalCurrency)) {
                    HashMap hashMap = (HashMap)hmTDB.get(originalCurrency);
                    BigDecimal fmsBegin = (BigDecimal)hashMap.get("fmBegin");
                    BigDecimal fmsIncrease = (BigDecimal)hashMap.get("fmIncrease");
                    BigDecimal fmsDecrease = (BigDecimal)hashMap.get("fmDecrease");
                    BigDecimal fmsEnd = (BigDecimal)hashMap.get("fmEnd");
                    hmTDB_Detail.put("fmBegin", fmsBegin.add(fmBegin));
                    hmTDB_Detail.put("fmIncrease", fmsIncrease.add(fmInc));
                    hmTDB_Detail.put("fmDecrease", fmsDecrease.add(fmDec));
                    hmTDB_Detail.put("fmEnd", fmsEnd.add(fmEnd));
                    hmTDB.put(originalCurrency, hmTDB_Detail);
                    continue;
                }
                hmTDB.put(originalCurrency, hmTDB_Detail);
            }
            if (coll.size() == 0) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                hmTDB_Detail.put("fmBegin", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmIncrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmDecrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmEnd", new BigDecimal("0.00").setScale(this.persion));
                hmTDB.put(this.baseCurrency, hmTDB_Detail);
            }
            return hmTDB;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return new HashMap<CurrencyInfo, Map<String, BigDecimal>>();
        }
    }

    private FilterItemInfo getDirectionFilter() {
        HashSet<Integer> state = new HashSet<Integer>();
        FilterItemInfo itemInfo = new FilterItemInfo();
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        int count = directionEntryCollection.size();
        for (int i = 0; i < count; ++i) {
            SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
            if (entryInfo.getStatusName().equals("\u4fdd\u5b58") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(0);
                continue;
            }
            if (entryInfo.getStatusName().equals("\u63d0\u4ea4") && !entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) {
                state.add(1);
                continue;
            }
            if (!entryInfo.getStatusName().equals("\u5ba1\u6279") && !entryInfo.getStatusName().equals("\u8d4e\u56de") || entryInfo.getCashflow().equals((Object)SipgFmCashflow.none)) continue;
            state.add(3);
            state.add(2);
        }
        if (state.size() > 0) {
            itemInfo = new FilterItemInfo("state", state, CompareType.INCLUDE);
        } else {
            state.add(30);
            itemInfo = new FilterItemInfo("state", state, CompareType.INCLUDE);
        }
        return itemInfo;
    }

    private FilterItemInfo getMappingFilter(SipgFmReconMappingEntryInfo mappingEntry) {
        FilterItemInfo itemInfo = new FilterItemInfo();
        if (mappingEntry.getFinanceFinancing() != null) {
            itemInfo = new FilterItemInfo("financeFinancing.id", (Object)mappingEntry.getFinanceFinancing().getId().toString(), CompareType.EQUALS);
            return itemInfo;
        }
        return itemInfo;
    }

    private HashMap getFmIncDec(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, CurrencyInfo currency, FinancingAccountInfo info) {
        try {
            HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
            BigDecimal fmIncrease = new BigDecimal("0.00");
            fmIncrease = fmIncrease.setScale(this.persion);
            BigDecimal fmDecrease = new BigDecimal("0.00");
            fmDecrease = fmDecrease.setScale(this.persion);
            BigDecimal bdIncrease = new BigDecimal("0.00");
            bdIncrease = bdIncrease.setScale(this.persion);
            BigDecimal bdDecrease = new BigDecimal("0.00");
            bdDecrease = bdDecrease.setScale(this.persion);
            String direction = null;
            HashMap fmIncDecMap = new HashMap();
            boolean ispred = this.IsInPeriod(info.getBizDate());
            switch (info.getState().getValue()) {
                case 0: {
                    direction = this.getDirectionType(reconDirection, 0);
                    break;
                }
                case 1: {
                    direction = this.getDirectionType(reconDirection, 1);
                    break;
                }
                case 3: {
                    direction = this.getDirectionType(reconDirection, 2);
                    fmIncDecMap = this.getfmAmount(ctx, info, bizDateEnd, reconDirection);
                    fmIncrease = fmIncrease.add((BigDecimal)fmIncDecMap.get("fmIncrease"));
                    fmDecrease = fmDecrease.add((BigDecimal)fmIncDecMap.get("fmDecrease"));
                    bdIncrease = bdIncrease.add((BigDecimal)fmIncDecMap.get("endIncrease"));
                    bdDecrease = bdDecrease.add((BigDecimal)fmIncDecMap.get("endDecrease"));
                    break;
                }
                case 2: {
                    fmIncDecMap = this.getfmAmount(ctx, info, bizDateEnd, reconDirection);
                    fmIncrease = fmIncrease.add((BigDecimal)fmIncDecMap.get("fmIncrease"));
                    fmDecrease = fmDecrease.add((BigDecimal)fmIncDecMap.get("fmDecrease"));
                    bdIncrease = bdIncrease.add((BigDecimal)fmIncDecMap.get("endIncrease"));
                    bdDecrease = bdDecrease.add((BigDecimal)fmIncDecMap.get("endDecrease"));
                }
            }
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(info.getFinanceAmount());
                if (ispred) {
                    fmIncrease = fmIncrease.add(info.getFinanceAmount());
                }
            } else if (direction == "decrease") {
                bdDecrease = bdDecrease.add(info.getFinanceAmount());
                if (ispred) {
                    fmDecrease = fmDecrease.add(info.getFinanceAmount());
                }
            }
            hashmap.put("fmIncrease", fmIncrease);
            hashmap.put("fmDecrease", fmDecrease);
            hashmap.put("endIncrease", bdIncrease);
            hashmap.put("endDecrease", bdDecrease);
            return hashmap;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getfmAmount(Context ctx, FinancingAccountInfo info, Date bizDateEnd, SipgFmReconDirectionInfo directionInfo2) throws BOSException {
        BigDecimal fmIncrease = new BigDecimal("0.00");
        fmIncrease = fmIncrease.setScale(this.persion);
        BigDecimal fmDecrease = new BigDecimal("0.00");
        fmDecrease = fmDecrease.setScale(this.persion);
        BigDecimal bdIncrease = new BigDecimal("0.00");
        bdIncrease = bdIncrease.setScale(this.persion);
        BigDecimal bdDecrease = new BigDecimal("0.00");
        bdDecrease = bdDecrease.setScale(this.persion);
        String direction = this.getDirectionType(directionInfo, 3);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        FinancingRedeemCollection redeemColl = FinancingRedeemFactory.getLocalInstance((Context)ctx).getFinancingRedeemCollection(evi);
        int count = redeemColl.size();
        for (int p = 0; p < count; ++p) {
            FinancingRedeemInfo redeemInfo = redeemColl.get(p);
            boolean ispred = this.IsInPeriod(redeemInfo.getBizDate());
            if (direction == "increase") {
                bdIncrease = bdIncrease.add(redeemInfo.getRedeemAmount());
                if (!ispred) continue;
                fmIncrease = fmIncrease.add(redeemInfo.getRedeemAmount());
                continue;
            }
            if (direction != "decrease") continue;
            bdDecrease = bdDecrease.add(redeemInfo.getRedeemAmount());
            if (!ispred) continue;
            fmDecrease = fmDecrease.add(redeemInfo.getRedeemAmount());
        }
        if (info.getState().equals((Object)FinancingStateEnum.CLOSE)) {
            if (direction == "decrease") {
                bdIncrease = bdIncrease.add(info.getFinanceAmount());
                if (this.IsInPeriod(info.getBizDate())) {
                    fmIncrease = fmIncrease.add(info.getFinanceAmount());
                }
            } else if (direction == "increase") {
                bdDecrease = bdDecrease.add(info.getFinanceAmount());
                if (this.IsInPeriod(info.getBizDate())) {
                    fmDecrease = fmDecrease.add(info.getFinanceAmount());
                }
            }
        }
        HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
        hashmap.put("fmIncrease", fmIncrease);
        hashmap.put("fmDecrease", fmDecrease);
        hashmap.put("endIncrease", bdIncrease);
        hashmap.put("endDecrease", bdDecrease);
        return hashmap;
    }

    private String getDirectionType(SipgFmReconDirectionInfo directionInfo2, int i) {
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
        if (entryInfo.getCashflow() == SipgFmCashflow.increase) {
            return "increase";
        }
        if (entryInfo.getCashflow() == SipgFmCashflow.none) {
            return "none";
        }
        return "decrease";
    }

    private boolean IsInPeriod(Date bizDate) {
        if (bizDate == reconPeriod.getEndDate() || bizDate == reconPeriod.getBeginDate()) {
            return true;
        }
        return !bizDate.after(reconPeriod.getEndDate()) && !bizDate.before(reconPeriod.getBeginDate());
    }
}

