/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.recon.FmReconResultCollection;
import com.kingdee.eas.fm.recon.FmReconResultEntryCollection;
import com.kingdee.eas.fm.recon.FmReconResultEntryFactory;
import com.kingdee.eas.fm.recon.FmReconResultEntryInfo;
import com.kingdee.eas.fm.recon.FmReconResultFactory;
import com.kingdee.eas.fm.recon.FmReconResultInfo;
import com.kingdee.eas.fm.recon.FmSettleResultCollection;
import com.kingdee.eas.fm.recon.FmSettleResultFactory;
import com.kingdee.eas.fm.recon.FmSettleResultInfo;
import com.kingdee.eas.fm.recon.SipgAccountDirectionEnum;
import com.kingdee.eas.fm.recon.SipgFmBizTypeEnum;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionFactory;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingCollection;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingFactory;
import com.kingdee.eas.fm.recon.SipgFmReconMappingInfo;
import com.kingdee.eas.fm.recon.SipgFmReconPeriodCollection;
import com.kingdee.eas.fm.recon.SipgFmReconPeriodEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconPeriodEntryDEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconPeriodEntryDEntryFactory;
import com.kingdee.eas.fm.recon.SipgFmReconPeriodEntryFactory;
import com.kingdee.eas.fm.recon.SipgFmReconPeriodFactory;
import com.kingdee.eas.fm.recon.SipgReconType;
import com.kingdee.eas.fm.recon.app.AbstractSipgFmReconFacadeControllerBean;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyImpl;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SipgFmReconFacadeControllerBean
extends AbstractSipgFmReconFacadeControllerBean {
    private static final String FMRECON_RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmReconResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sipg.fmrecon.recon.app.SipgFmReconFacadeControllerBean");
    private Class iSipgFmReconStrategy;
    private SipgFmReconStrategyImpl strategyImpl;
    private int persion;

    @Override
    protected List _fetchReconResult(Context ctx, HashMap hmParams) throws BOSException {
        String reconYear = (String)hmParams.get("reconYear");
        PeriodInfo sipgFmReconPeriodEntryInfo = (PeriodInfo)hmParams.get("reconPeriod");
        SipgFmReconMappingInfo sipgFmReconMappingInfo = (SipgFmReconMappingInfo)hmParams.get("reconMapping");
        SipgFmReconDirectionInfo sipgFmReconDirectionInfo = (SipgFmReconDirectionInfo)hmParams.get("reconDirection");
        String bizType = (String)hmParams.get("bizType");
        try {
            if (bizType != null) {
                this.iSipgFmReconStrategy = Class.forName("com.kingdee.eas.fm.recon.app.Sipg" + SipgFmReconFacadeControllerBean.toUpperCaseFirstOne(bizType) + "Strategy");
                ISipgFmReconStrategy iStrategy = (ISipgFmReconStrategy)this.iSipgFmReconStrategy.newInstance();
                this.strategyImpl = new SipgFmReconStrategyImpl(iStrategy);
                return this.strategyImpl.getReconResult(ctx, hmParams);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return this.strategyImpl.getReconResult(ctx, hmParams);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    @Override
    protected boolean _getReconResultByDate(Context ctx, SipgFmBizTypeEnum bizType, Date caprtalAccountDate) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (bizType != null && caprtalAccountDate != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(caprtalAccountDate);
            int dateYear = c.get(1);
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
            SipgFmReconPeriodCollection fmReconPeriodCol = SipgFmReconPeriodFactory.getLocalInstance(ctx).getSipgFmReconPeriodCollection("select * where periodYear='" + dateYear + "' and CU.id='" + company.getId().toString() + "'");
            if (fmReconPeriodCol.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                evi.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("parent", (Object)fmReconPeriodCol.get(0).getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizDateStart", (Object)sdf.format(caprtalAccountDate), CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bizDateEnd", (Object)sdf.format(caprtalAccountDate), CompareType.GREATER_EQUALS));
                SipgFmReconPeriodEntryCollection fmReconPeriodEntryCol = SipgFmReconPeriodEntryFactory.getLocalInstance(ctx).getSipgFmReconPeriodEntryCollection(evi);
                if (fmReconPeriodEntryCol.size() > 0) {
                    SipgFmReconPeriodEntryDEntryCollection fmReconPeriodEDECol = SipgFmReconPeriodEntryDEntryFactory.getLocalInstance(ctx).getSipgFmReconPeriodEntryDEntryCollection("select * where parent1='" + fmReconPeriodEntryCol.get(0).getId().toString() + "' and bizType=" + "1");
                    if (fmReconPeriodEDECol.size() > 0 && fmReconPeriodEDECol.get(0).isIsReconed()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected boolean _addReconResult(Context ctx, List result, HashMap inParam) throws BOSException, EASBizException {
        Date now = new Date();
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)inParam.get("companyInfo");
        this.persion = currentCompany.getBaseCurrency().getPrecision();
        this.persion = 4;
        boolean isReconedStatus = false;
        BigDecimal diffAmount = new BigDecimal("0.00");
        diffAmount.setScale(this.persion);
        UserInfo creator = ContextUtil.getCurrentUserInfo((Context)ctx);
        SipgFmReconMappingInfo mappingInfo = (SipgFmReconMappingInfo)inParam.get("reconMapping");
        PeriodInfo periodEntryInfo = (PeriodInfo)inParam.get("reconPeriod");
        SipgFmReconDirectionInfo sipgFmReconDirectionInfo = (SipgFmReconDirectionInfo)inParam.get("reconDirection");
        FmReconResultInfo resultInfo = new FmReconResultInfo();
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("company", (Object)currentCompany.getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("mapping", (Object)mappingInfo.getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("direction", (Object)sipgFmReconDirectionInfo.getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("PeriodEntry", (Object)periodEntryInfo.getId().toString(), CompareType.EQUALS));
        evis.setFilter(filters);
        FmReconResultCollection resultColl = FmReconResultFactory.getLocalInstance(ctx).getFmReconResultCollection(evis);
        if (resultColl.size() != 0) {
            resultInfo = resultColl.get(0);
        } else {
            resultInfo.setMapping(mappingInfo);
            resultInfo.setDirection(sipgFmReconDirectionInfo);
            resultInfo.setPeriodEntry(periodEntryInfo);
        }
        FmReconResultEntryCollection collection = resultInfo.getEntrys();
        ObjectUuidPK[] deltetPk = null;
        if (collection.size() > 0) {
            deltetPk = new ObjectUuidPK[collection.size()];
            for (int idx = 0; idx < collection.size(); ++idx) {
                deltetPk[idx] = new ObjectUuidPK(collection.get(idx).getId());
            }
        }
        collection = new FmReconResultEntryCollection();
        resultInfo.setFmBizType(mappingInfo.getFmBizType());
        resultInfo.setCompany(currentCompany);
        resultInfo.setCreator(creator);
        if (mappingInfo.getFmBizType() == SipgFmBizTypeEnum.timeDeopsit) {
            return this.doonetoone(ctx, resultInfo, result, collection, (IObjectPK[])deltetPk);
        }
        String fmtype = "prouds";
        if (mappingInfo.getFmBizType() == SipgFmBizTypeEnum.receivableBill || mappingInfo.getFmBizType() == SipgFmBizTypeEnum.payableBill) {
            fmtype = "biilltype";
        } else if (mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.financingAccount)) {
            fmtype = "financeFinancing";
        }
        ArrayList fmlist = new ArrayList();
        ArrayList gllist = new ArrayList();
        HashMap entrymap = new HashMap();
        List samelist = this.getsame(mappingInfo);
        FmReconResultEntryCollection samecoll = new FmReconResultEntryCollection();
        HashMap samemap = new HashMap();
        HashMap hashmap = new HashMap();
        HashMap<FmReconResultEntryCollection, String> typesame = new HashMap<FmReconResultEntryCollection, String>();
        String type = null;
        if (samelist.size() == 0) {
            return this.doonetoone(ctx, resultInfo, result, collection, (IObjectPK[])deltetPk);
        }
        for (int same = 0; same < samelist.size(); ++same) {
            samecoll = new FmReconResultEntryCollection();
            for (int i = 0; i < result.size(); ++i) {
                HashMap data = (HashMap)result.get(i);
                CurrencyInfo curency = (CurrencyInfo)data.get("currenctInfo");
                SipgFmReconMappingEntryInfo mappingEntryInfo = (SipgFmReconMappingEntryInfo)data.get("reconMapping");
                FmReconResultEntryInfo entryInfo = new FmReconResultEntryInfo();
                entryInfo.setParent(resultInfo);
                entryInfo.setMappingEntry(mappingEntryInfo);
                entryInfo.setFmbeginAmount((BigDecimal)data.get("fmBegin"));
                entryInfo.setFmDecAmount((BigDecimal)data.get("fmDecrease"));
                entryInfo.setFmendAmount((BigDecimal)data.get("fmEnd"));
                entryInfo.setFmIncAmount((BigDecimal)data.get("fmIncrease"));
                entryInfo.setGlbeginAmount((BigDecimal)data.get("glBegin"));
                entryInfo.setGlendAmount((BigDecimal)data.get("glEnd"));
                entryInfo.setGlDebitAmount((BigDecimal)data.get("glDebit"));
                entryInfo.setGlCreditAmount((BigDecimal)data.get("glCredit"));
                entryInfo.setDifbeginAmount((BigDecimal)data.get("beginDifference"));
                entryInfo.setDifendAmount((BigDecimal)data.get("gap"));
                entryInfo.setDifIncAmount((BigDecimal)data.get("increaseDifference"));
                entryInfo.setDifDecAmount((BigDecimal)data.get("decreaseDifference"));
                entryInfo.setCurrency(curency);
                if (fmtype == "prouds") {
                    if (mappingEntryInfo.getProducts().getId().toString().equals(samelist.get(same)) && !samecoll.contains(entryInfo)) {
                        samecoll.add(entryInfo);
                        type = "fm";
                        collection.remove(entryInfo);
                        continue;
                    }
                    if (mappingEntryInfo.getAccount().getId().toString().equals(samelist.get(same)) && !samecoll.contains(entryInfo)) {
                        samecoll.add(entryInfo);
                        type = "gl";
                        collection.remove(entryInfo);
                        continue;
                    }
                    if (collection.contains(entryInfo)) continue;
                    collection.add(entryInfo);
                    continue;
                }
                if (fmtype == "financeFinancing") {
                    if (mappingEntryInfo.getFinanceFinancing().getId().toString().equals(samelist.get(same)) && !samecoll.contains(entryInfo)) {
                        samecoll.add(entryInfo);
                        type = "fm";
                        collection.remove(entryInfo);
                        continue;
                    }
                    if (mappingEntryInfo.getAccount().getId().toString().equals(samelist.get(same)) && !samecoll.contains(entryInfo)) {
                        samecoll.add(entryInfo);
                        type = "gl";
                        collection.remove(entryInfo);
                        continue;
                    }
                    if (collection.contains(entryInfo)) continue;
                    collection.add(entryInfo);
                    continue;
                }
                if (mappingEntryInfo.getBillType().getId().toString().equals(samelist.get(same)) && !samecoll.contains(entryInfo)) {
                    samecoll.add(entryInfo);
                    type = "fm";
                    collection.remove(entryInfo);
                    continue;
                }
                if (mappingEntryInfo.getAccount().getId().toString().equals(samelist.get(same)) && !samecoll.contains(entryInfo)) {
                    samecoll.add(entryInfo);
                    type = "gl";
                    collection.remove(entryInfo);
                    continue;
                }
                if (collection.contains(entryInfo)) continue;
                collection.add(entryInfo);
            }
            resultInfo.setBizDate(now);
            typesame.put(samecoll, type);
        }
        HashMap hmResult = this.updateDiffamount(collection, typesame, sipgFmReconDirectionInfo);
        collection.addCollection((FmReconResultEntryCollection)((Object)hmResult.get("collection")));
        diffAmount = (BigDecimal)hmResult.get("difamount");
        resultInfo.setDiffAmount(diffAmount);
        if (diffAmount.compareTo(Constants.ZERO) == 0) {
            resultInfo.setReconedStatus(SipgReconType.YES);
            isReconedStatus = true;
        } else {
            resultInfo.setReconedStatus(SipgReconType.NO);
            isReconedStatus = false;
        }
        resultInfo.getEntrys().addCollection(collection);
        if (collection.size() > 0) {
            FmReconResultFactory.getLocalInstance(ctx).save((CoreBaseInfo)resultInfo);
        }
        if (deltetPk != null) {
            FmReconResultEntryFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])deltetPk);
        }
        return isReconedStatus;
    }

    private boolean doonetoone(Context ctx, FmReconResultInfo resultInfo, List result, FmReconResultEntryCollection collection, IObjectPK[] deltetPk) throws EASBizException, BOSException {
        boolean isReconedStatus = false;
        BigDecimal diffAmount = new BigDecimal("0.00");
        diffAmount.setScale(this.persion);
        for (int i = 0; i < result.size(); ++i) {
            HashMap data = (HashMap)result.get(i);
            CurrencyInfo curency = (CurrencyInfo)data.get("currenctInfo");
            SipgFmReconMappingEntryInfo mappingEntryInfo = (SipgFmReconMappingEntryInfo)data.get("reconMapping");
            FmReconResultEntryInfo entryInfo = new FmReconResultEntryInfo();
            entryInfo.setParent(resultInfo);
            entryInfo.setMappingEntry(mappingEntryInfo);
            entryInfo.setFmbeginAmount((BigDecimal)data.get("fmBegin"));
            entryInfo.setFmDecAmount((BigDecimal)data.get("fmDecrease"));
            entryInfo.setFmendAmount((BigDecimal)data.get("fmEnd"));
            entryInfo.setFmIncAmount((BigDecimal)data.get("fmIncrease"));
            entryInfo.setGlbeginAmount((BigDecimal)data.get("glBegin"));
            entryInfo.setGlendAmount((BigDecimal)data.get("glEnd"));
            entryInfo.setGlDebitAmount((BigDecimal)data.get("glDebit"));
            entryInfo.setGlCreditAmount((BigDecimal)data.get("glCredit"));
            entryInfo.setDifbeginAmount((BigDecimal)data.get("beginDifference"));
            entryInfo.setDifendAmount((BigDecimal)data.get("gap"));
            entryInfo.setDifIncAmount((BigDecimal)data.get("increaseDifference"));
            entryInfo.setDifDecAmount((BigDecimal)data.get("decreaseDifference"));
            entryInfo.setCurrency(curency);
            collection.add(entryInfo);
            diffAmount = diffAmount.add((BigDecimal)data.get("gap"));
            resultInfo.setBizDate(new Date());
            resultInfo.setDiffAmount(diffAmount);
            if (diffAmount.compareTo(Constants.ZERO) == 0) {
                resultInfo.setReconedStatus(SipgReconType.YES);
                isReconedStatus = true;
            } else {
                resultInfo.setReconedStatus(SipgReconType.NO);
                isReconedStatus = false;
            }
            resultInfo.getEntrys().addCollection(collection);
            if (collection.size() <= 0) continue;
            FmReconResultFactory.getLocalInstance(ctx).save((CoreBaseInfo)resultInfo);
        }
        if (deltetPk != null) {
            FmReconResultEntryFactory.getLocalInstance(ctx).deleteBatchData(deltetPk);
        }
        return isReconedStatus;
    }

    private HashMap updateDiffamount(FmReconResultEntryCollection collection, Map<FmReconResultEntryCollection, String> typesame, SipgFmReconDirectionInfo sipgFmReconDirectionInfo) {
        HashMap<String, Object> hmmap = new HashMap<String, Object>();
        BigDecimal diffamount = new BigDecimal("0.00");
        diffamount.setScale(this.persion);
        FmReconResultEntryCollection entryCollection = new FmReconResultEntryCollection();
        for (FmReconResultEntryCollection key : typesame.keySet()) {
            String type = typesame.get((Object)key);
            entryCollection.addCollection(this.updatecoll(collection, key, type, sipgFmReconDirectionInfo));
            if (key.get(0) == null) continue;
            diffamount = diffamount.add(key.get(0).getDifendAmount());
        }
        for (int i = 0; i < collection.size(); ++i) {
            diffamount = diffamount.add(collection.get(i).getDifendAmount());
        }
        hmmap.put("collection", (Object)entryCollection);
        hmmap.put("difamount", diffamount);
        return hmmap;
    }

    private FmReconResultEntryCollection updatecoll(FmReconResultEntryCollection key, FmReconResultEntryCollection entryCollection, String type, SipgFmReconDirectionInfo sipgFmReconDirectionInfo) {
        int c;
        BigDecimal samebegin = new BigDecimal("0.00");
        samebegin.setScale(this.persion);
        BigDecimal sameIncrease = new BigDecimal("0.00");
        sameIncrease.setScale(this.persion);
        BigDecimal sameDecrease = new BigDecimal("0.00");
        sameDecrease.setScale(this.persion);
        BigDecimal sameend = new BigDecimal("0.00");
        sameend.setScale(this.persion);
        BigDecimal zero = new BigDecimal("0.00");
        FmReconResultEntryInfo entryInfo = null;
        HashSet<BOSUuid> currId = new HashSet<BOSUuid>();
        for (c = 0; c < entryCollection.size(); ++c) {
            entryInfo = entryCollection.get(c);
            currId.add(entryInfo.getCurrency().getId());
        }
        if (currId.size() > 1) {
            block41: for (c = 0; c < entryCollection.size(); ++c) {
                SipgAccountDirectionEnum lessdirection;
                SipgAccountDirectionEnum adddirection;
                entryInfo = entryCollection.get(c);
                key.remove(entryInfo);
                samebegin = new BigDecimal("0.00");
                samebegin.setScale(this.persion);
                sameIncrease = new BigDecimal("0.00");
                sameIncrease.setScale(this.persion);
                sameDecrease = new BigDecimal("0.00");
                sameDecrease.setScale(this.persion);
                sameend = new BigDecimal("0.00");
                sameend.setScale(this.persion);
                zero = new BigDecimal("0.00");
                if (type == "fm") {
                    samebegin = samebegin.add(entryInfo.getGlbeginAmount());
                    sameIncrease = sameIncrease.add(entryInfo.getGlDebitAmount());
                    sameDecrease = sameDecrease.add(entryInfo.getGlCreditAmount());
                    sameend = sameend.add(entryInfo.getGlendAmount());
                } else {
                    samebegin = samebegin.add(entryInfo.getFmbeginAmount());
                    sameIncrease = sameIncrease.add(entryInfo.getFmIncAmount());
                    sameDecrease = sameDecrease.add(entryInfo.getFmDecAmount());
                    sameend = sameend.add(entryInfo.getFmendAmount());
                }
                Map directionSet = this.getdirection(sipgFmReconDirectionInfo);
                entryInfo = entryCollection.get(c);
                key.remove(entryInfo);
                if (type == "fm") {
                    entryInfo.setDifbeginAmount(entryInfo.getFmbeginAmount().subtract(samebegin).setScale(this.persion));
                    entryInfo.setDifendAmount(entryInfo.getFmendAmount().subtract(sameend).setScale(this.persion));
                    adddirection = (SipgAccountDirectionEnum)((Object)directionSet.get("add"));
                    switch (Integer.parseInt(adddirection.getValue())) {
                        case 1: {
                            entryInfo.setDifIncAmount(entryInfo.getFmIncAmount().subtract(sameIncrease).setScale(this.persion));
                            break;
                        }
                        case -1: {
                            entryInfo.setDifIncAmount(entryInfo.getFmIncAmount().subtract(sameDecrease).setScale(this.persion));
                            break;
                        }
                        case 0: {
                            entryInfo.setDifIncAmount(entryInfo.getFmIncAmount().subtract(zero).setScale(this.persion));
                        }
                    }
                    lessdirection = (SipgAccountDirectionEnum)((Object)directionSet.get("less"));
                    switch (Integer.parseInt(lessdirection.getValue())) {
                        case 1: {
                            entryInfo.setDifDecAmount(entryInfo.getFmDecAmount().subtract(sameIncrease).setScale(this.persion));
                            break;
                        }
                        case -1: {
                            entryInfo.setDifDecAmount(entryInfo.getFmDecAmount().subtract(sameDecrease).setScale(this.persion));
                            break;
                        }
                        case 0: {
                            entryInfo.setDifDecAmount(entryInfo.getFmDecAmount().subtract(zero).setScale(this.persion));
                        }
                    }
                    continue;
                }
                entryInfo.setDifbeginAmount(samebegin.subtract(entryInfo.getGlbeginAmount()).setScale(this.persion));
                entryInfo.setDifendAmount(sameend.subtract(entryInfo.getGlendAmount()).setScale(this.persion));
                adddirection = (SipgAccountDirectionEnum)((Object)directionSet.get("add"));
                switch (Integer.parseInt(adddirection.getValue())) {
                    case 1: {
                        entryInfo.setDifIncAmount(sameIncrease.subtract(entryInfo.getGlDebitAmount()).setScale(this.persion));
                        break;
                    }
                    case -1: {
                        entryInfo.setDifIncAmount(sameIncrease.subtract(entryInfo.getGlCreditAmount()).setScale(this.persion));
                        break;
                    }
                    case 0: {
                        entryInfo.setDifIncAmount(sameIncrease.subtract(zero).setScale(this.persion));
                    }
                }
                lessdirection = (SipgAccountDirectionEnum)((Object)directionSet.get("less"));
                switch (Integer.parseInt(lessdirection.getValue())) {
                    case 1: {
                        entryInfo.setDifDecAmount(sameDecrease.subtract(entryInfo.getGlDebitAmount()).setScale(this.persion));
                        continue block41;
                    }
                    case -1: {
                        entryInfo.setDifDecAmount(sameDecrease.subtract(entryInfo.getGlCreditAmount()).setScale(this.persion));
                        continue block41;
                    }
                    case 0: {
                        entryInfo.setDifDecAmount(sameDecrease.subtract(zero).setScale(this.persion));
                    }
                }
            }
        } else {
            for (c = 0; c < entryCollection.size(); ++c) {
                entryInfo = entryCollection.get(c);
                key.remove(entryInfo);
                if (type == "fm") {
                    samebegin = samebegin.add(entryInfo.getGlbeginAmount());
                    sameIncrease = sameIncrease.add(entryInfo.getGlDebitAmount());
                    sameDecrease = sameDecrease.add(entryInfo.getGlCreditAmount());
                    sameend = sameend.add(entryInfo.getGlendAmount());
                    continue;
                }
                samebegin = samebegin.add(entryInfo.getFmbeginAmount());
                sameIncrease = sameIncrease.add(entryInfo.getFmIncAmount());
                sameDecrease = sameDecrease.add(entryInfo.getFmDecAmount());
                sameend = sameend.add(entryInfo.getFmendAmount());
            }
            Map directionSet = this.getdirection(sipgFmReconDirectionInfo);
            block43: for (int d = 0; d < entryCollection.size(); ++d) {
                SipgAccountDirectionEnum lessdirection;
                SipgAccountDirectionEnum adddirection;
                entryInfo = entryCollection.get(d);
                if (type == "fm") {
                    entryInfo.setDifbeginAmount(entryInfo.getFmbeginAmount().subtract(samebegin).setScale(this.persion));
                    entryInfo.setDifendAmount(entryInfo.getFmendAmount().subtract(sameend).setScale(this.persion));
                    adddirection = (SipgAccountDirectionEnum)((Object)directionSet.get("add"));
                    switch (Integer.parseInt(adddirection.getValue())) {
                        case 1: {
                            entryInfo.setDifIncAmount(entryInfo.getFmIncAmount().subtract(sameIncrease).setScale(this.persion));
                            break;
                        }
                        case -1: {
                            entryInfo.setDifIncAmount(entryInfo.getFmIncAmount().subtract(sameDecrease).setScale(this.persion));
                            break;
                        }
                        case 0: {
                            entryInfo.setDifIncAmount(entryInfo.getFmIncAmount().subtract(zero).setScale(this.persion));
                        }
                    }
                    lessdirection = (SipgAccountDirectionEnum)((Object)directionSet.get("less"));
                    switch (Integer.parseInt(lessdirection.getValue())) {
                        case 1: {
                            entryInfo.setDifDecAmount(entryInfo.getFmDecAmount().subtract(sameIncrease).setScale(this.persion));
                            break;
                        }
                        case -1: {
                            entryInfo.setDifDecAmount(entryInfo.getFmDecAmount().subtract(sameDecrease).setScale(this.persion));
                            break;
                        }
                        case 0: {
                            entryInfo.setDifDecAmount(entryInfo.getFmDecAmount().subtract(zero).setScale(this.persion));
                        }
                    }
                    continue;
                }
                entryInfo.setDifbeginAmount(samebegin.subtract(entryInfo.getGlbeginAmount()).setScale(this.persion));
                entryInfo.setDifendAmount(sameend.subtract(entryInfo.getGlendAmount()).setScale(this.persion));
                adddirection = (SipgAccountDirectionEnum)((Object)directionSet.get("add"));
                switch (Integer.parseInt(adddirection.getValue())) {
                    case 1: {
                        entryInfo.setDifIncAmount(sameIncrease.subtract(entryInfo.getGlDebitAmount()).setScale(this.persion));
                        break;
                    }
                    case -1: {
                        entryInfo.setDifIncAmount(sameIncrease.subtract(entryInfo.getGlCreditAmount()).setScale(this.persion));
                        break;
                    }
                    case 0: {
                        entryInfo.setDifIncAmount(sameIncrease.subtract(zero).setScale(this.persion));
                    }
                }
                lessdirection = (SipgAccountDirectionEnum)((Object)directionSet.get("less"));
                switch (Integer.parseInt(lessdirection.getValue())) {
                    case 1: {
                        entryInfo.setDifDecAmount(sameDecrease.subtract(entryInfo.getGlDebitAmount()).setScale(this.persion));
                        continue block43;
                    }
                    case -1: {
                        entryInfo.setDifDecAmount(sameDecrease.subtract(entryInfo.getGlCreditAmount()).setScale(this.persion));
                        continue block43;
                    }
                    case 0: {
                        entryInfo.setDifDecAmount(sameDecrease.subtract(zero).setScale(this.persion));
                    }
                }
            }
        }
        return entryCollection;
    }

    private Map getdirection(SipgFmReconDirectionInfo sipgFmReconDirectionInfo) {
        HashMap<String, SipgAccountDirectionEnum> set = new HashMap<String, SipgAccountDirectionEnum>();
        SipgFmReconDirectionEntryInfo entryInfo = new SipgFmReconDirectionEntryInfo();
        for (int i = 0; i < sipgFmReconDirectionInfo.getEntrys().size(); ++i) {
            entryInfo = sipgFmReconDirectionInfo.getEntrys().get(i);
            if (entryInfo.getCashflow() == SipgFmCashflow.increase && !set.containsKey("add")) {
                set.put("add", entryInfo.getAccountDirection());
                continue;
            }
            if (entryInfo.getCashflow() != SipgFmCashflow.decrease || set.containsKey("less")) continue;
            set.put("less", entryInfo.getAccountDirection());
        }
        if (set.get("add") == null) {
            set.put("add", SipgAccountDirectionEnum.none);
        }
        if (set.get("less") == null) {
            set.put("less", SipgAccountDirectionEnum.none);
        }
        return set;
    }

    private List getsame(SipgFmReconMappingInfo mappingInfo) {
        SipgFmReconMappingEntryCollection entryCollection = mappingInfo.getEntrys();
        ArrayList<String> fmlist = new ArrayList<String>();
        ArrayList<String> gllist = new ArrayList<String>();
        SipgFmReconMappingEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            if (mappingInfo.getFmBizType() == SipgFmBizTypeEnum.receivableBill || mappingInfo.getFmBizType() == SipgFmBizTypeEnum.payableBill) {
                fmlist.add(entryInfo.getBillType().getId().toString());
            } else if (mappingInfo.getFmBizType() == SipgFmBizTypeEnum.financingAccount) {
                fmlist.add(entryInfo.getFinanceFinancing().getId().toString());
            } else {
                fmlist.add(entryInfo.getProducts().getId().toString());
            }
            gllist.add(entryInfo.getAccount().getId().toString());
        }
        HashSet fmset = new HashSet(fmlist);
        HashSet glset = new HashSet(gllist);
        ArrayList samelist = new ArrayList();
        if (fmset.size() < fmlist.size()) {
            samelist.addAll(this.getdiff(fmlist, fmset));
        }
        if (glset.size() < gllist.size()) {
            samelist.addAll(this.getdiff(gllist, glset));
        }
        return samelist;
    }

    private List getdiff(List list, HashSet glset) {
        ArrayList tempList = new ArrayList();
        tempList.addAll(list);
        ArrayList linshilist = new ArrayList(glset);
        for (int i = 0; i < linshilist.size(); ++i) {
            tempList.remove(linshilist.get(i));
        }
        return tempList;
    }

    @Override
    protected List _settleRecon(Context ctx, List msgList, FmSettleResultInfo settleInfo, FmSettleResultCollection collection) throws BOSException, EASBizException {
        HashSet<SipgFmBizTypeEnum> types = new HashSet<SipgFmBizTypeEnum>();
        SipgFmReconMappingInfo mappingInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)Integer.valueOf("2"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)settleInfo.getCompany().getId(), CompareType.EQUALS));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fmBizType"));
        ev.setSelector(sic);
        SipgFmReconMappingCollection mappingColl = SipgFmReconMappingFactory.getLocalInstance(ctx).getSipgFmReconMappingCollection(ev);
        switch (settleInfo.getSystemStatus().getName().getValue()) {
            case 30: {
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)mappingColl)) {
                    for (int index = 0; index < mappingColl.size(); ++index) {
                        mappingInfo = mappingColl.get(index);
                        if (mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.loanBill)) {
                            types.add(SipgFmBizTypeEnum.loanBill);
                            continue;
                        }
                        if (!mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.interest)) continue;
                        types.add(SipgFmBizTypeEnum.interest);
                    }
                }
                msgList = this.dorecon(ctx, msgList, types, settleInfo, collection);
                break;
            }
            case 29: {
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)mappingColl)) {
                    for (int index = 0; index < mappingColl.size(); ++index) {
                        mappingInfo = mappingColl.get(index);
                        if (mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.consignmentBill)) {
                            types.add(SipgFmBizTypeEnum.consignmentBill);
                            continue;
                        }
                        if (mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.consignLoan)) {
                            types.add(SipgFmBizTypeEnum.consignLoan);
                            continue;
                        }
                        if (mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.timeDeopsit)) {
                            types.add(SipgFmBizTypeEnum.timeDeopsit);
                            continue;
                        }
                        if (mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.fundTransferBill)) {
                            types.add(SipgFmBizTypeEnum.fundTransferBill);
                            continue;
                        }
                        if (mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.fundTransferBillInterest)) {
                            types.add(SipgFmBizTypeEnum.fundTransferBillInterest);
                            continue;
                        }
                        if (!mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.financingAccount)) continue;
                        types.add(SipgFmBizTypeEnum.financingAccount);
                    }
                }
                msgList = this.dorecon(ctx, msgList, types, settleInfo, collection);
                break;
            }
            case 28: {
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)mappingColl)) {
                    for (int index = 0; index < mappingColl.size(); ++index) {
                        mappingInfo = mappingColl.get(index);
                        if (mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.receivableBill)) {
                            types.add(SipgFmBizTypeEnum.receivableBill);
                            continue;
                        }
                        if (!mappingInfo.getFmBizType().equals((Object)SipgFmBizTypeEnum.payableBill)) continue;
                        types.add(SipgFmBizTypeEnum.payableBill);
                    }
                }
                msgList = this.dorecon(ctx, msgList, types, settleInfo, collection);
            }
        }
        return msgList;
    }

    private List<String> dorecon(Context ctx, List msgList, Set<SipgFmBizTypeEnum> types, FmSettleResultInfo settleInfo, FmSettleResultCollection settleResultCollection) throws BOSException, EASBizException {
        ArrayList<String> reconmsgList = new ArrayList<String>();
        HashMap<String, Object> inParam = new HashMap<String, Object>();
        boolean stats = false;
        SipgFmReconMappingInfo sipgFmReconMappingInfo = null;
        SipgFmReconDirectionInfo sipgFmReconDirectionInfo = null;
        List result = new ArrayList();
        if (!EmptyUtil.isEmpty(types)) {
            for (SipgFmBizTypeEnum type : types) {
                sipgFmReconMappingInfo = this.getMappingInfo(ctx, settleInfo.getCompany(), type);
                if (sipgFmReconMappingInfo == null) {
                    msgList.add(EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"015_recon_settle_error", (Object[])new String[]{settleInfo.getCompany().getName(), type.getAlias()}));
                    reconmsgList.add(EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"015_recon_settle_error", (Object[])new String[]{settleInfo.getCompany().getName(), type.getAlias()}));
                }
                if ((sipgFmReconDirectionInfo = this.getDirectionInfo(ctx, settleInfo.getCompany(), type)) == null) {
                    msgList.add(EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"016_recon_settle_error", (Object[])new String[]{settleInfo.getCompany().getName(), type.getAlias()}));
                    reconmsgList.add(EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"016_recon_settle_error", (Object[])new String[]{settleInfo.getCompany().getName(), type.getAlias()}));
                }
                if (sipgFmReconDirectionInfo != null && sipgFmReconMappingInfo != null) {
                    inParam.put("bizType", type.getName());
                    inParam.put("reconPeriod", settleInfo.getPeriod());
                    inParam.put("reconMapping", sipgFmReconMappingInfo);
                    inParam.put("reconDirection", sipgFmReconDirectionInfo);
                    inParam.put("companyInfo", settleInfo.getCompany());
                    result = this._fetchReconResult(ctx, inParam);
                    stats = this._addReconResult(ctx, result, inParam);
                    if (!stats) {
                        msgList.add(EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"017_recon_settle_error", (Object[])new String[]{type.getAlias()}));
                        reconmsgList.add(EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"017_recon_settle_error", (Object[])new String[]{type.getAlias()}));
                        settleResultCollection.remove(settleInfo);
                        continue;
                    }
                    reconmsgList.add(EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"018_recon_settle_success", (Object[])new String[]{type.getAlias()}));
                    continue;
                }
                settleResultCollection.remove(settleInfo);
            }
        } else {
            msgList.add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"815_SipgFmReconFacadeControllerBean", (Locale)ctx.getLocale()));
            reconmsgList.add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"815_SipgFmReconFacadeControllerBean", (Locale)ctx.getLocale()));
            settleResultCollection.remove(settleInfo);
        }
        settleInfo.setSettleRemark(((Object)reconmsgList).toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("settleRemark"));
        FmSettleResultFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)settleInfo, sic);
        return msgList;
    }

    private SipgFmReconDirectionInfo getDirectionInfo(Context ctx, CompanyOrgUnitInfo company, SipgFmBizTypeEnum loanbill) throws BOSException {
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("CU.id", (Object)company.getCU().getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("bizType", (Object)loanbill.getValue(), CompareType.EQUALS));
        evis.setFilter(filters);
        SipgFmReconDirectionCollection directionCollection = SipgFmReconDirectionFactory.getLocalInstance(ctx).getSipgFmReconDirectionCollection(evis);
        if (directionCollection.size() != 0) {
            return directionCollection.get(0);
        }
        return null;
    }

    private SipgFmReconMappingInfo getMappingInfo(Context ctx, CompanyOrgUnitInfo company, SipgFmBizTypeEnum loanbill) throws BOSException {
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("fmBizType", (Object)loanbill.getValue(), CompareType.EQUALS));
        evis.setFilter(filters);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.account.*"));
        sic.add(new SelectorItemInfo("entrys.products.*"));
        sic.add(new SelectorItemInfo("entrys.billType.*"));
        sic.add(new SelectorItemInfo("entrys.Institution.*"));
        sic.add(new SelectorItemInfo("entrys.accountBank.*"));
        sic.add(new SelectorItemInfo("entrys.financeFinancing.*"));
        evis.setSelector(sic);
        SipgFmReconMappingCollection mappingCollection = SipgFmReconMappingFactory.getLocalInstance(ctx).getSipgFmReconMappingCollection(evis);
        if (mappingCollection.size() != 0) {
            return mappingCollection.get(0);
        }
        return null;
    }
}

