/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingProductsCollection;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.recon.DimensionType;
import com.kingdee.eas.fm.recon.FmReconResultCollection;
import com.kingdee.eas.fm.recon.FmReconResultFactory;
import com.kingdee.eas.fm.recon.SipgFmBillStateEnum;
import com.kingdee.eas.fm.recon.SipgFmBizTypeEnum;
import com.kingdee.eas.fm.recon.SipgFmReconMappingCollection;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingFactory;
import com.kingdee.eas.fm.recon.SipgFmReconMappingInfo;
import com.kingdee.eas.fm.recon.app.AbstractSipgFmReconMappingControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SipgFmReconMappingControllerBean
extends AbstractSipgFmReconMappingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.recon.app.SipgFmReconMappingControllerBean");
    private static final String RECON_RES = "com.kingdee.eas.fm.recon.FmReconBaseResource";

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection src = new SelectorItemCollection();
        src.add("id");
        src.add("number");
        src.add("FICompany");
        src.add("fmBizType");
        src.add("SipgDimensionType");
        src.add("billState");
        src.add("entrys.products.id");
        src.add("entrys.products.number");
        src.add("entrys.products.name");
        src.add("entrys.Institution.id");
        src.add("entrys.Institution.number");
        src.add("entrys.Institution.name");
        src.add("entrys.billType.id");
        src.add("entrys.billType.number");
        src.add("entrys.billType.name");
        src.add("entrys.account.id");
        src.add("entrys.account.number");
        src.add("entrys.account.name");
        src.add("entrys.accountBank.id");
        src.add("entrys.accountBank.number");
        src.add("entrys.accountBank.name");
        src.add("entrys.financeFinancing.id");
        src.add("entrys.financeFinancing.number");
        src.add("entrys.financeFinancing.name");
        return src;
    }

    @Override
    protected Map _actionCancel(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        SipgFmReconMappingCollection colls = SipgFmReconMappingFactory.getLocalInstance(ctx).getSipgFmReconMappingCollection(view);
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        int validCount = 0;
        for (int i = 0; i < colls.size(); ++i) {
            SipgFmReconMappingInfo info = colls.get(i);
            if (!SipgFmBillStateEnum.start.equals((Object)info.getBillState())) {
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"12_StartNoStop", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\n";
                continue;
            }
            ++validCount;
            info.setBillState(SipgFmBillStateEnum.stop);
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("billState");
                this.updatePartial(ctx, (CoreBaseInfo)info, selector);
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
            }
        }
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    @Override
    protected Map _actionCancelCancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        SipgFmReconMappingCollection colls = SipgFmReconMappingFactory.getLocalInstance(ctx).getSipgFmReconMappingCollection(view);
        String errorDetail = "";
        HashMap<SipgFmBizTypeEnum, Object> mapOnly = new HashMap<SipgFmBizTypeEnum, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < colls.size(); ++i) {
            SipgFmReconMappingInfo info = colls.get(i);
            if (mapOnly.containsKey((Object)info.getFmBizType())) {
                mapOnly.remove((Object)info.getFmBizType());
                mapOnly.put(info.getFmBizType(), "more");
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"42_bizTypeOnlyMappingStart", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getFmBizType()}) + "\n";
                continue;
            }
            mapOnly.put(info.getFmBizType(), i);
        }
        int validCount = 0;
        for (int i = 0; i < colls.size(); ++i) {
            SipgFmReconMappingInfo info = colls.get(i);
            if (mapOnly.get((Object)info.getFmBizType()).equals("more")) continue;
            if (SipgFmBillStateEnum.start.equals((Object)info.getBillState())) {
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"41_StartNoStart", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\n";
                continue;
            }
            String error = this.doStart(ctx, info, currentCompany);
            errorDetail = errorDetail + error;
            if (!error.equals("")) continue;
            ++validCount;
        }
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    private String doStart(Context ctx, SipgFmReconMappingInfo info, CompanyOrgUnitInfo currentCompany) {
        String errorDetail = "";
        errorDetail = errorDetail + this.checkNull(ctx, info, currentCompany);
        if ((errorDetail = errorDetail + this.checkOtherIsStart(ctx, info, currentCompany)).equals("")) {
            info.setBillState(SipgFmBillStateEnum.start);
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("billState");
                this.updatePartial(ctx, (CoreBaseInfo)info, selector);
            }
            catch (BOSException e) {
                e.printStackTrace();
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
            }
            catch (EASBizException e) {
                e.printStackTrace();
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
            }
        }
        return errorDetail;
    }

    private String checkNull(Context ctx, SipgFmReconMappingInfo info, CompanyOrgUnitInfo currentCompany) {
        int i;
        String errorDetail = "";
        if (DimensionType.financingProducts.equals((Object)info.getSipgDimensionType())) {
            for (i = 0; i < info.getEntrys().size(); ++i) {
                if (info.getEntrys().get(i).get("products") != null) continue;
                errorDetail = errorDetail + info.getNumber() + ResourceBase.getString((String)RECON_RES, (String)"14_productsIsNull", (Locale)ctx.getLocale()) + "\n";
                break;
            }
        }
        if (DimensionType.billType.equals((Object)info.getSipgDimensionType())) {
            for (i = 0; i < info.getEntrys().size(); ++i) {
                if (info.getEntrys().get(i).get("billType") != null) continue;
                errorDetail = errorDetail + info.getNumber() + ResourceBase.getString((String)RECON_RES, (String)"15_billTypeIsNull", (Locale)ctx.getLocale()) + "\n";
                break;
            }
        }
        if (DimensionType.accountBank.equals((Object)info.getSipgDimensionType())) {
            for (i = 0; i < info.getEntrys().size(); ++i) {
                if (info.getEntrys().get(i).get("accountBank") != null) continue;
                errorDetail = errorDetail + info.getNumber() + ResourceBase.getString((String)RECON_RES, (String)"16_accountBankIsNull", (Locale)ctx.getLocale()) + "\n";
                break;
            }
        }
        if (!DimensionType.accountBank.equals((Object)info.getSipgDimensionType())) {
            for (i = 0; i < info.getEntrys().size(); ++i) {
                if (info.getEntrys().get(i).get("account") != null) continue;
                errorDetail = errorDetail + info.getNumber() + ResourceBase.getString((String)RECON_RES, (String)"1_accountIsNull", (Locale)ctx.getLocale()) + "\n";
                break;
            }
        }
        return errorDetail;
    }

    private String checkDimensionTypeAndAccount(Context ctx, SipgFmReconMappingInfo info, CompanyOrgUnitInfo currentCompany) {
        FinancingProductsCollection colls;
        FilterInfo filter;
        int i;
        SelectorItemCollection selector;
        EntityViewInfo view;
        String errorDetail = "";
        if (DimensionType.financingProducts.equals((Object)info.getSipgDimensionType())) {
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            selector.add("number");
            view.setSelector(selector);
            for (i = 0; i < info.getEntrys().size(); ++i) {
                FinancingProductsInfo products = info.getEntrys().get(i).getProducts();
                if (products == null) {
                    info.getEntrys().get(i).setProducts(null);
                    continue;
                }
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)products.getNumber()));
                view.setFilter(filter);
                try {
                    colls = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsCollection(view);
                    if (colls.size() < 1) {
                        info.getEntrys().get(i).setProducts(null);
                        continue;
                    }
                    info.getEntrys().get(i).setProducts(colls.get(0));
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
                }
            }
        }
        if (DimensionType.billType.equals((Object)info.getSipgDimensionType())) {
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            selector.add("number");
            view.setSelector(selector);
            for (i = 0; i < info.getEntrys().size(); ++i) {
                NTTypeInfo nttype = info.getEntrys().get(i).getBillType();
                if (nttype == null) {
                    info.getEntrys().get(i).setBillType(null);
                    continue;
                }
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)nttype.getNumber()));
                view.setFilter(filter);
                try {
                    colls = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeCollection(view);
                    if (colls.size() < 1) {
                        info.getEntrys().get(i).setBillType(null);
                        continue;
                    }
                    info.getEntrys().get(i).setBillType(colls.get(0));
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
                }
            }
        }
        if (DimensionType.accountBank.equals((Object)info.getSipgDimensionType())) {
            errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"55_TimeDeopsitCannotCopyMapping", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\n";
        }
        if (!DimensionType.accountBank.equals((Object)info.getSipgDimensionType())) {
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            selector.add("number");
            selector.add("companyID.id");
            view.setSelector(selector);
            for (i = 0; i < info.getEntrys().size(); ++i) {
                AccountViewInfo account = info.getEntrys().get(i).getAccount();
                if (account == null) {
                    info.getEntrys().get(i).setAccount(null);
                    continue;
                }
                if (EmptyUtil.isEmpty((CoreBaseInfo)currentCompany.getAccountTable())) {
                    info.getEntrys().get(i).setAccount(null);
                    continue;
                }
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)account.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)currentCompany.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)currentCompany.getAccountTable().getId().toString()));
                view.setFilter(filter);
                try {
                    colls = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
                    if (colls.size() < 1) {
                        info.getEntrys().get(i).setAccount(null);
                        continue;
                    }
                    info.getEntrys().get(i).setAccount(colls.get(0));
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
                }
            }
        }
        return errorDetail;
    }

    private String checkOtherIsStart(Context ctx, SipgFmReconMappingInfo info, CompanyOrgUnitInfo currentCompany) {
        String errorDetail = "";
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("billState");
        selector.add("company.id");
        selector.add("fmBizType");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"2"));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("fmBizType", (Object)info.getFmBizType()));
        try {
            SipgFmReconMappingCollection colls = SipgFmReconMappingFactory.getLocalInstance(ctx).getSipgFmReconMappingCollection(view);
            if (colls.size() >= 1) {
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"17_SipgFmReconMappingControllerBean", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), info.getFmBizType()}) + "\n";
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"13_Exception", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), e.getMessage()}) + "\n";
        }
        return errorDetail;
    }

    @Override
    protected Map _copyMapping(Context ctx, String CompanyID) throws EASBizException {
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        int validCount = 0;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CtrlUnitInfo cuInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)CompanyID));
        try {
            SipgFmReconMappingCollection colls = SipgFmReconMappingFactory.getLocalInstance(ctx).getSipgFmReconMappingCollection(view);
            if (colls.size() >= 1) {
                CoreBaseCollection coreColls = new CoreBaseCollection();
                for (int i = 0; i < colls.size(); ++i) {
                    SipgFmReconMappingInfo info = colls.get(i);
                    String error = this.checkDimensionTypeAndAccount(ctx, info, currentCompany);
                    errorDetail = errorDetail + error;
                    if (!error.equals("")) continue;
                    ++validCount;
                    info.setId(null);
                    info.setNumber(info.getNumber() + "copy");
                    info.setBillState(SipgFmBillStateEnum.save);
                    info.setCompany(currentCompany);
                    info.setFICompany(null);
                    info.setCU(cuInfo);
                    SipgFmReconMappingEntryCollection entrys = info.getEntrys();
                    for (int m = 0; m < entrys.size(); ++m) {
                        SipgFmReconMappingEntryInfo entryInfo = entrys.get(m);
                        entryInfo.setId(null);
                        entryInfo.setParent(null);
                    }
                    coreColls.add((CoreBaseInfo)info);
                }
                SipgFmReconMappingFactory.getLocalInstance(ctx).save(coreColls);
            } else {
                errorDetail = errorDetail + ResourceBase.getString((String)RECON_RES, (String)"18_SipgFmReconMappingControllerBean", (Locale)ctx.getLocale()) + "\n";
            }
            map.put("validCount", new Integer(validCount));
            map.put("falseCount", new Integer(colls.size() - validCount));
            map.put("errorDetail", errorDetail);
        }
        catch (BOSException e) {
            e.printStackTrace();
            errorDetail = errorDetail + e.getMessage() + "\n";
        }
        return map;
    }

    @Override
    protected Map _actionRemove(Context ctx, Set idSet) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        SipgFmReconMappingCollection colls = SipgFmReconMappingFactory.getLocalInstance(ctx).getSipgFmReconMappingCollection(view);
        String errorDetail = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        int validCount = 0;
        for (int i = 0; i < colls.size(); ++i) {
            SipgFmReconMappingInfo info = colls.get(i);
            if (SipgFmBillStateEnum.start.equals((Object)info.getBillState())) {
                errorDetail = errorDetail + info.getNumber() + ":" + ResourceBase.getString((String)RECON_RES, (String)"35_StartMappingCannotRemove", (Locale)ctx.getLocale()) + "\n";
            }
            if (!(errorDetail = errorDetail + this.checkIsUsed(ctx, info, currentCompany)).equals("")) continue;
            ++validCount;
        }
        map.put("validCount", new Integer(validCount));
        map.put("errorDetail", errorDetail);
        return map;
    }

    private String checkIsUsed(Context ctx, SipgFmReconMappingInfo info, CompanyOrgUnitInfo currentCompany) throws BOSException {
        String errorDetail = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mapping.id", (Object)info.getId(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection src = new SelectorItemCollection();
        src.add("id");
        src.add("number");
        view.setSelector(src);
        FmReconResultCollection colls = FmReconResultFactory.getLocalInstance(ctx).getFmReconResultCollection(view);
        if (colls.size() > 1) {
            errorDetail = errorDetail + info.getNumber() + ":" + ResourceBase.getString((String)RECON_RES, (String)"36_isUsedCannotRemove", (Locale)ctx.getLocale()) + "\n";
        }
        return errorDetail;
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        SipgFmReconMappingInfo info = (SipgFmReconMappingInfo)model;
        if (info.getId() != null) {
            super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), model);
        }
        return super.save(ctx, (CoreBaseInfo)info);
    }
}

