/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.nt.DiscountBillCollection;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillCollection;
import com.kingdee.eas.fm.nt.ReturnBillFactory;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyBase;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

public class SipgPayableBillStrategy
extends SipgFmReconStrategyBase
implements ISipgFmReconStrategy {
    @Override
    public List _getReconResult(Context ctx, HashMap hmParams) {
        if (!this.initParams(hmParams)) {
            return null;
        }
        try {
            this.baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < reconMapping.getEntrys().size(); ++i) {
            SipgFmReconMappingEntryInfo mappingEntry = reconMapping.getEntrys().get(i);
            String fmNumber = null;
            String fmName = null;
            String glNumber = null;
            String glName = null;
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("name");
                selector.add("number");
                NTTypeInfo nTTypeInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getBillType().getId()), selector);
                fmNumber = nTTypeInfo.getNumber();
                fmName = nTTypeInfo.getName();
                AccountViewInfo accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getAccount().getId()), selector);
                glNumber = accountViewInfo.getNumber();
                glName = accountViewInfo.getName();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            HashMap currencyMap = this.getCurrencyFmEnd(ctx, mappingEntry);
            for (CurrencyInfo cur : currencyMap.keySet()) {
                HashMap fmIncDec = (HashMap)currencyMap.get(cur);
                HashMap<String, Object> hmResult = this.getReturnValue(ctx, fmNumber, fmName, glNumber, glName, fmIncDec, cur, mappingEntry);
                result.add(hmResult);
            }
        }
        return result;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection src = new SelectorItemCollection();
        src.add("id");
        src.add("number");
        src.add("draftNumber");
        src.add("billState");
        src.add("AmountLocalCur");
        src.add("IssueDate");
        src.add("company");
        src.add("RepaymentDate");
        src.add("transfer.id");
        src.add("transfer.transferDate");
        src.add("transfer.amount");
        src.add("transfer.currency");
        return src;
    }

    private HashMap getCurrencyFmEnd(Context ctx, SipgFmReconMappingEntryInfo mappingEntry) {
        String billTypeId = mappingEntry.getBillType().getId().toString();
        Date bizDateStart = reconPeriod.getBeginDate();
        Date bizDateEnd = reconPeriod.getEndDate();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(bizDateEnd);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        bizDateEnd = cal.getTime();
        Date date = new Date();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        SimpleDateFormat simp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("IssueDate", (Object)simp.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)billTypeId, CompareType.EQUALS));
        try {
            PayableBillCollection rbCol = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillCollection(evi);
            HashMap hmTDB = new HashMap();
            for (int i = 0; i < rbCol.size(); ++i) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                PayableBillInfo payableBillInfo = rbCol.get(i);
                String id = payableBillInfo.getId().toString();
                HashMap hmcDec = this.getFmIncDec(ctx, mappingEntry, directionInfo, bizDateStart, bizDateEnd, payableBillInfo);
                BigDecimal endInc = (BigDecimal)hmcDec.get("endIncrease");
                BigDecimal endDec = (BigDecimal)hmcDec.get("endDecrease");
                BigDecimal fmInc = (BigDecimal)hmcDec.get("fmIncrease");
                BigDecimal fmDec = (BigDecimal)hmcDec.get("fmDecrease");
                BigDecimal fmEnd = endInc.subtract(endDec);
                BigDecimal fmBegin = fmEnd.add(fmDec).subtract(fmInc);
                hmTDB_Detail.put("fmBegin", fmBegin);
                hmTDB_Detail.put("fmIncrease", fmInc);
                hmTDB_Detail.put("fmDecrease", fmDec);
                hmTDB_Detail.put("fmEnd", fmEnd);
                if (hmTDB.containsKey(this.baseCurrency)) {
                    HashMap hashMap = (HashMap)hmTDB.get(this.baseCurrency);
                    BigDecimal fmsBegin = (BigDecimal)hashMap.get("fmBegin");
                    BigDecimal fmsIncrease = (BigDecimal)hashMap.get("fmIncrease");
                    BigDecimal fmsDecrease = (BigDecimal)hashMap.get("fmDecrease");
                    BigDecimal fmsEnd = (BigDecimal)hashMap.get("fmEnd");
                    hmTDB_Detail.put("fmBegin", fmsBegin.add(fmBegin));
                    hmTDB_Detail.put("fmIncrease", fmsIncrease.add(fmInc));
                    hmTDB_Detail.put("fmDecrease", fmsDecrease.add(fmDec));
                    hmTDB_Detail.put("fmEnd", fmsEnd.add(fmEnd));
                    hmTDB.put(this.baseCurrency, hmTDB_Detail);
                    continue;
                }
                hmTDB.put(this.baseCurrency, hmTDB_Detail);
            }
            if (rbCol.size() == 0) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                hmTDB_Detail.put("fmBegin", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmIncrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmDecrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmEnd", new BigDecimal("0.00").setScale(this.persion));
                hmTDB.put(this.baseCurrency, hmTDB_Detail);
            }
            return hmTDB;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getFmIncDec(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, PayableBillInfo payableBillInfo) {
        HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
        BigDecimal fmIncrease = new BigDecimal("0.00");
        fmIncrease = fmIncrease.setScale(this.persion);
        BigDecimal fmDecrease = new BigDecimal("0.00");
        fmDecrease = fmDecrease.setScale(this.persion);
        BigDecimal endIncrease = new BigDecimal("0.00");
        endIncrease = endIncrease.setScale(this.persion);
        BigDecimal endDecrease = new BigDecimal("0.00");
        endDecrease = endDecrease.setScale(this.persion);
        SipgFmCashflow direction = SipgFmCashflow.none;
        BigDecimal amount = new BigDecimal("0.00");
        Date tempDate = null;
        HashMap map = new HashMap();
        Boolean hasTraceDown = true;
        String id = payableBillInfo.getId().toString();
        switch (payableBillInfo.getBillState().getValue()) {
            case 4: {
                hasTraceDown = false;
                direction = this.getDirectionType(0);
                amount = payableBillInfo.getAmountLocalCur();
                tempDate = payableBillInfo.getIssueDate();
                break;
            }
            case 0: {
                hasTraceDown = false;
                direction = this.getDirectionType(1);
                amount = payableBillInfo.getAmountLocalCur();
                tempDate = payableBillInfo.getIssueDate();
                break;
            }
            case 5: {
                hasTraceDown = false;
                direction = this.getDirectionType(2);
                amount = payableBillInfo.getAmountLocalCur();
                tempDate = payableBillInfo.getIssueDate();
                break;
            }
            case 1: {
                direction = this.getDirectionType(3);
                amount = payableBillInfo.getAmountLocalCur();
                tempDate = payableBillInfo.getRepaymentDate();
                break;
            }
            case 2: {
                direction = this.getDirectionType(4);
                amount = payableBillInfo.getAmountLocalCur();
                tempDate = payableBillInfo.getTransfer().getTransferDate();
                break;
            }
            case 3: {
                direction = this.getDirectionType(5);
                amount = payableBillInfo.getAmountLocalCur();
                tempDate = payableBillInfo.getTransfer().getTransferDate();
                break;
            }
            case 6: {
                direction = this.getDirectionType(6);
                map = this.getDiscountDecrease(ctx, bizDateStart, bizDateEnd, id);
                amount = (BigDecimal)map.get("amount");
                tempDate = (Date)map.get("tempDate");
                break;
            }
            case 7: {
                direction = this.getDirectionType(7);
                map = this.getLoanDecrease(ctx, bizDateStart, bizDateEnd, id);
                amount = (BigDecimal)map.get("amount");
                tempDate = (Date)map.get("tempDate");
                break;
            }
            case 9: {
                direction = this.getDirectionType(8);
                map = this.getAbandonDecrease(ctx, bizDateStart, bizDateEnd, id);
                amount = (BigDecimal)map.get("amount");
                tempDate = (Date)map.get("tempDate");
            }
        }
        if (tempDate != null) {
            if (SipgFmCashflow.increase.equals((Object)direction)) {
                if (!tempDate.after(bizDateEnd)) {
                    endIncrease = endIncrease.add(amount);
                    if (!tempDate.before(bizDateStart) && amount != null) {
                        fmIncrease = fmIncrease.add(amount);
                    }
                }
            } else if (SipgFmCashflow.decrease.equals((Object)direction) && !tempDate.after(bizDateEnd) && amount != null) {
                endDecrease = endDecrease.add(amount);
                if (!tempDate.before(bizDateStart)) {
                    fmDecrease = fmDecrease.add(amount);
                }
            }
        }
        if (hasTraceDown.booleanValue() && !payableBillInfo.getIssueDate().after(bizDateEnd)) {
            endIncrease = endIncrease.add(payableBillInfo.getAmountLocalCur());
            if (!payableBillInfo.getIssueDate().before(bizDateStart)) {
                fmIncrease = fmIncrease.add(payableBillInfo.getAmountLocalCur());
            }
        }
        hashmap.put("fmIncrease", fmIncrease);
        hashmap.put("fmDecrease", fmDecrease);
        hashmap.put("endIncrease", endIncrease);
        hashmap.put("endDecrease", endDecrease);
        return hashmap;
    }

    private HashMap getDiscountDecrease(Context ctx, Date bizDateStart, Date bizDateEnd, String id) {
        HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("payablebill.id");
        selector.add("DiscountDate");
        selector.add("localAmount");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("payablebill.id", (Object)id, CompareType.EQUALS));
        try {
            DiscountBillCollection coll = DiscountBillFactory.getLocalInstance((Context)ctx).getDiscountBillCollection(view);
            for (int j = 0; j < coll.size(); ++j) {
                DiscountBillInfo info = coll.get(j);
                map.put("amount", info.getLocalAmount());
                map.put("tempDate", info.getDiscountDate());
            }
            if (coll.size() == 0) {
                map.put("amount", new BigDecimal("0.00").setScale(this.persion));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    private HashMap getLoanDecrease(Context ctx, Date bizDateStart, Date bizDateEnd, String id) {
        HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("sourceBillId");
        selector.add("bizDate");
        selector.add("AmountLocalCur");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)id, CompareType.EQUALS));
        try {
            LoanCollection coll = LoanFactory.getLocalInstance((Context)ctx).getLoanCollection(view);
            for (int j = 0; j < coll.size(); ++j) {
                LoanInfo info = coll.get(j);
                map.put("amount", info.getAmountLocalCur());
                map.put("tempDate", info.getBizDate());
            }
            if (coll.size() == 0) {
                map.put("amount", new BigDecimal("0.00").setScale(this.persion));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    private HashMap getAbandonDecrease(Context ctx, Date bizDateStart, Date bizDateEnd, String id) {
        HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("srcBillId");
        selector.add("returnDate");
        selector.add("amount");
        selector.add("currency");
        selector.add("exRate");
        selector.add("locAmount");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcBillId", (Object)id, CompareType.EQUALS));
        try {
            ReturnBillCollection coll = ReturnBillFactory.getLocalInstance((Context)ctx).getReturnBillCollection(view);
            for (int j = 0; j < coll.size(); ++j) {
                ReturnBillInfo info = coll.get(j);
                map.put("amount", info.getAmount());
                map.put("tempDate", info.getReturnDate());
            }
            if (coll.size() == 0) {
                map.put("amount", new BigDecimal("0.00").setScale(this.persion));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    private SipgFmCashflow getDirectionType(int i) {
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
        return entryInfo.getCashflow();
    }
}

